// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemakerfeaturestoreruntime

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchGetRecord = "BatchGetRecord"

// BatchGetRecordRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetRecord operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetRecord for more information on using the BatchGetRecord
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetRecordRequest method.
//	req, resp := client.BatchGetRecordRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/BatchGetRecord
func (c *SageMakerFeatureStoreRuntime) BatchGetRecordRequest(input *BatchGetRecordInput) (req *request.Request, output *BatchGetRecordOutput) {
	op := &request.Operation{
		Name:       opBatchGetRecord,
		HTTPMethod: "POST",
		HTTPPath:   "/BatchGetRecord",
	}

	if input == nil {
		input = &BatchGetRecordInput{}
	}

	output = &BatchGetRecordOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetRecord API operation for Amazon SageMaker Feature Store Runtime.
//
// Retrieves a batch of Records from a FeatureGroup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Feature Store Runtime's
// API operation BatchGetRecord for usage and error information.
//
// Returned Error Types:
//
//   - ValidationError
//     There was an error validating your request.
//
//   - InternalFailure
//     An internal failure occurred. Try your request again. If the problem persists,
//     contact Amazon Web Services customer support.
//
//   - ServiceUnavailable
//     The service is currently unavailable.
//
//   - AccessForbidden
//     You do not have permission to perform an action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/BatchGetRecord
func (c *SageMakerFeatureStoreRuntime) BatchGetRecord(input *BatchGetRecordInput) (*BatchGetRecordOutput, error) {
	req, out := c.BatchGetRecordRequest(input)
	return out, req.Send()
}

// BatchGetRecordWithContext is the same as BatchGetRecord with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetRecord for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerFeatureStoreRuntime) BatchGetRecordWithContext(ctx aws.Context, input *BatchGetRecordInput, opts ...request.Option) (*BatchGetRecordOutput, error) {
	req, out := c.BatchGetRecordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRecord = "DeleteRecord"

// DeleteRecordRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRecord operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRecord for more information on using the DeleteRecord
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRecordRequest method.
//	req, resp := client.DeleteRecordRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/DeleteRecord
func (c *SageMakerFeatureStoreRuntime) DeleteRecordRequest(input *DeleteRecordInput) (req *request.Request, output *DeleteRecordOutput) {
	op := &request.Operation{
		Name:       opDeleteRecord,
		HTTPMethod: "DELETE",
		HTTPPath:   "/FeatureGroup/{FeatureGroupName}",
	}

	if input == nil {
		input = &DeleteRecordInput{}
	}

	output = &DeleteRecordOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRecord API operation for Amazon SageMaker Feature Store Runtime.
//
// Deletes a Record from a FeatureGroup in the OnlineStore. Feature Store supports
// both SoftDelete and HardDelete. For SoftDelete (default), feature columns
// are set to null and the record is no longer retrievable by GetRecord or BatchGetRecord.
// For HardDelete, the complete Record is removed from the OnlineStore. In both
// cases, Feature Store appends the deleted record marker to the OfflineStore.
// The deleted record marker is a record with the same RecordIdentifer as the
// original, but with is_deleted value set to True, EventTime set to the delete
// input EventTime, and other feature values set to null.
//
// Note that the EventTime specified in DeleteRecord should be set later than
// the EventTime of the existing record in the OnlineStore for that RecordIdentifer.
// If it is not, the deletion does not occur:
//
//   - For SoftDelete, the existing (not deleted) record remains in the OnlineStore,
//     though the delete record marker is still written to the OfflineStore.
//
//   - HardDelete returns EventTime: 400 ValidationException to indicate that
//     the delete operation failed. No delete record marker is written to the
//     OfflineStore.
//
// When a record is deleted from the OnlineStore, the deleted record marker
// is appended to the OfflineStore. If you have the Iceberg table format enabled
// for your OfflineStore, you can remove all history of a record from the OfflineStore
// using Amazon Athena or Apache Spark. For information on how to hard delete
// a record from the OfflineStore with the Iceberg table format enabled, see
// Delete records from the offline store (https://docs.aws.amazon.com/sagemaker/latest/dg/feature-store-delete-records-offline-store.html#feature-store-delete-records-offline-store).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Feature Store Runtime's
// API operation DeleteRecord for usage and error information.
//
// Returned Error Types:
//
//   - ValidationError
//     There was an error validating your request.
//
//   - InternalFailure
//     An internal failure occurred. Try your request again. If the problem persists,
//     contact Amazon Web Services customer support.
//
//   - ServiceUnavailable
//     The service is currently unavailable.
//
//   - AccessForbidden
//     You do not have permission to perform an action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/DeleteRecord
func (c *SageMakerFeatureStoreRuntime) DeleteRecord(input *DeleteRecordInput) (*DeleteRecordOutput, error) {
	req, out := c.DeleteRecordRequest(input)
	return out, req.Send()
}

// DeleteRecordWithContext is the same as DeleteRecord with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRecord for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerFeatureStoreRuntime) DeleteRecordWithContext(ctx aws.Context, input *DeleteRecordInput, opts ...request.Option) (*DeleteRecordOutput, error) {
	req, out := c.DeleteRecordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRecord = "GetRecord"

// GetRecordRequest generates a "aws/request.Request" representing the
// client's request for the GetRecord operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRecord for more information on using the GetRecord
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRecordRequest method.
//	req, resp := client.GetRecordRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/GetRecord
func (c *SageMakerFeatureStoreRuntime) GetRecordRequest(input *GetRecordInput) (req *request.Request, output *GetRecordOutput) {
	op := &request.Operation{
		Name:       opGetRecord,
		HTTPMethod: "GET",
		HTTPPath:   "/FeatureGroup/{FeatureGroupName}",
	}

	if input == nil {
		input = &GetRecordInput{}
	}

	output = &GetRecordOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRecord API operation for Amazon SageMaker Feature Store Runtime.
//
// Use for OnlineStore serving from a FeatureStore. Only the latest records
// stored in the OnlineStore can be retrieved. If no Record with RecordIdentifierValue
// is found, then an empty result is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Feature Store Runtime's
// API operation GetRecord for usage and error information.
//
// Returned Error Types:
//
//   - ValidationError
//     There was an error validating your request.
//
//   - ResourceNotFound
//     A resource that is required to perform an action was not found.
//
//   - InternalFailure
//     An internal failure occurred. Try your request again. If the problem persists,
//     contact Amazon Web Services customer support.
//
//   - ServiceUnavailable
//     The service is currently unavailable.
//
//   - AccessForbidden
//     You do not have permission to perform an action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/GetRecord
func (c *SageMakerFeatureStoreRuntime) GetRecord(input *GetRecordInput) (*GetRecordOutput, error) {
	req, out := c.GetRecordRequest(input)
	return out, req.Send()
}

// GetRecordWithContext is the same as GetRecord with the addition of
// the ability to pass a context and additional request options.
//
// See GetRecord for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerFeatureStoreRuntime) GetRecordWithContext(ctx aws.Context, input *GetRecordInput, opts ...request.Option) (*GetRecordOutput, error) {
	req, out := c.GetRecordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRecord = "PutRecord"

// PutRecordRequest generates a "aws/request.Request" representing the
// client's request for the PutRecord operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRecord for more information on using the PutRecord
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutRecordRequest method.
//	req, resp := client.PutRecordRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/PutRecord
func (c *SageMakerFeatureStoreRuntime) PutRecordRequest(input *PutRecordInput) (req *request.Request, output *PutRecordOutput) {
	op := &request.Operation{
		Name:       opPutRecord,
		HTTPMethod: "PUT",
		HTTPPath:   "/FeatureGroup/{FeatureGroupName}",
	}

	if input == nil {
		input = &PutRecordInput{}
	}

	output = &PutRecordOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutRecord API operation for Amazon SageMaker Feature Store Runtime.
//
// The PutRecord API is used to ingest a list of Records into your feature group.
//
// If a new record’s EventTime is greater, the new record is written to both
// the OnlineStore and OfflineStore. Otherwise, the record is a historic record
// and it is written only to the OfflineStore.
//
// You can specify the ingestion to be applied to the OnlineStore, OfflineStore,
// or both by using the TargetStores request parameter.
//
// You can set the ingested record to expire at a given time to live (TTL) duration
// after the record’s event time, ExpiresAt = EventTime + TtlDuration, by
// specifying the TtlDuration parameter. A record level TtlDuration is set when
// specifying the TtlDuration parameter using the PutRecord API call. If the
// input TtlDuration is null or unspecified, TtlDuration is set to the default
// feature group level TtlDuration. A record level TtlDuration supersedes the
// group level TtlDuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SageMaker Feature Store Runtime's
// API operation PutRecord for usage and error information.
//
// Returned Error Types:
//
//   - ValidationError
//     There was an error validating your request.
//
//   - InternalFailure
//     An internal failure occurred. Try your request again. If the problem persists,
//     contact Amazon Web Services customer support.
//
//   - ServiceUnavailable
//     The service is currently unavailable.
//
//   - AccessForbidden
//     You do not have permission to perform an action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sagemaker-featurestore-runtime-2020-07-01/PutRecord
func (c *SageMakerFeatureStoreRuntime) PutRecord(input *PutRecordInput) (*PutRecordOutput, error) {
	req, out := c.PutRecordRequest(input)
	return out, req.Send()
}

// PutRecordWithContext is the same as PutRecord with the addition of
// the ability to pass a context and additional request options.
//
// See PutRecord for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SageMakerFeatureStoreRuntime) PutRecordWithContext(ctx aws.Context, input *PutRecordInput, opts ...request.Option) (*PutRecordOutput, error) {
	req, out := c.PutRecordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have permission to perform an action.
type AccessForbidden struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessForbidden) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessForbidden) GoString() string {
	return s.String()
}

func newErrorAccessForbidden(v protocol.ResponseMetadata) error {
	return &AccessForbidden{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessForbidden) Code() string {
	return "AccessForbidden"
}

// Message returns the exception's message.
func (s *AccessForbidden) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessForbidden) OrigErr() error {
	return nil
}

func (s *AccessForbidden) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessForbidden) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessForbidden) RequestID() string {
	return s.RespMetadata.RequestID
}

// The error that has occurred when attempting to retrieve a batch of Records.
type BatchGetRecordError struct {
	_ struct{} `type:"structure"`

	// The error code of an error that has occurred when attempting to retrieve
	// a batch of Records. For more information on errors, see Errors (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_GetRecord.html#API_feature_store_GetRecord_Errors).
	//
	// ErrorCode is a required field
	ErrorCode *string `type:"string" required:"true"`

	// The error message of an error that has occurred when attempting to retrieve
	// a record in the batch.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `type:"string" required:"true"`

	// The name of the feature group that the record belongs to.
	//
	// FeatureGroupName is a required field
	FeatureGroupName *string `type:"string" required:"true"`

	// The value for the RecordIdentifier in string format of a Record from a FeatureGroup
	// that is causing an error when attempting to be retrieved.
	//
	// RecordIdentifierValueAsString is a required field
	RecordIdentifierValueAsString *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetRecordError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetRecordError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchGetRecordError) SetErrorCode(v string) *BatchGetRecordError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchGetRecordError) SetErrorMessage(v string) *BatchGetRecordError {
	s.ErrorMessage = &v
	return s
}

// SetFeatureGroupName sets the FeatureGroupName field's value.
func (s *BatchGetRecordError) SetFeatureGroupName(v string) *BatchGetRecordError {
	s.FeatureGroupName = &v
	return s
}

// SetRecordIdentifierValueAsString sets the RecordIdentifierValueAsString field's value.
func (s *BatchGetRecordError) SetRecordIdentifierValueAsString(v string) *BatchGetRecordError {
	s.RecordIdentifierValueAsString = &v
	return s
}

// The identifier that identifies the batch of Records you are retrieving in
// a batch.
type BatchGetRecordIdentifier struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the FeatureGroup containing the
	// records you are retrieving in a batch.
	//
	// FeatureGroupName is a required field
	FeatureGroupName *string `min:"1" type:"string" required:"true"`

	// List of names of Features to be retrieved. If not specified, the latest value
	// for all the Features are returned.
	FeatureNames []*string `min:"1" type:"list"`

	// The value for a list of record identifiers in string format.
	//
	// RecordIdentifiersValueAsString is a required field
	RecordIdentifiersValueAsString []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetRecordIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetRecordIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetRecordIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetRecordIdentifier"}
	if s.FeatureGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("FeatureGroupName"))
	}
	if s.FeatureGroupName != nil && len(*s.FeatureGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FeatureGroupName", 1))
	}
	if s.FeatureNames != nil && len(s.FeatureNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FeatureNames", 1))
	}
	if s.RecordIdentifiersValueAsString == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordIdentifiersValueAsString"))
	}
	if s.RecordIdentifiersValueAsString != nil && len(s.RecordIdentifiersValueAsString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecordIdentifiersValueAsString", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFeatureGroupName sets the FeatureGroupName field's value.
func (s *BatchGetRecordIdentifier) SetFeatureGroupName(v string) *BatchGetRecordIdentifier {
	s.FeatureGroupName = &v
	return s
}

// SetFeatureNames sets the FeatureNames field's value.
func (s *BatchGetRecordIdentifier) SetFeatureNames(v []*string) *BatchGetRecordIdentifier {
	s.FeatureNames = v
	return s
}

// SetRecordIdentifiersValueAsString sets the RecordIdentifiersValueAsString field's value.
func (s *BatchGetRecordIdentifier) SetRecordIdentifiersValueAsString(v []*string) *BatchGetRecordIdentifier {
	s.RecordIdentifiersValueAsString = v
	return s
}

type BatchGetRecordInput struct {
	_ struct{} `type:"structure"`

	// Parameter to request ExpiresAt in response. If Enabled, BatchGetRecord will
	// return the value of ExpiresAt, if it is not null. If Disabled and null, BatchGetRecord
	// will return null.
	ExpirationTimeResponse *string `type:"string" enum:"ExpirationTimeResponse"`

	// A list containing the name or Amazon Resource Name (ARN) of the FeatureGroup,
	// the list of names of Features to be retrieved, and the corresponding RecordIdentifier
	// values as strings.
	//
	// Identifiers is a required field
	Identifiers []*BatchGetRecordIdentifier `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetRecordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetRecordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetRecordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetRecordInput"}
	if s.Identifiers == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifiers"))
	}
	if s.Identifiers != nil && len(s.Identifiers) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifiers", 1))
	}
	if s.Identifiers != nil {
		for i, v := range s.Identifiers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Identifiers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpirationTimeResponse sets the ExpirationTimeResponse field's value.
func (s *BatchGetRecordInput) SetExpirationTimeResponse(v string) *BatchGetRecordInput {
	s.ExpirationTimeResponse = &v
	return s
}

// SetIdentifiers sets the Identifiers field's value.
func (s *BatchGetRecordInput) SetIdentifiers(v []*BatchGetRecordIdentifier) *BatchGetRecordInput {
	s.Identifiers = v
	return s
}

type BatchGetRecordOutput struct {
	_ struct{} `type:"structure"`

	// A list of errors that have occurred when retrieving a batch of Records.
	//
	// Errors is a required field
	Errors []*BatchGetRecordError `type:"list" required:"true"`

	// A list of Records you requested to be retrieved in batch.
	//
	// Records is a required field
	Records []*BatchGetRecordResultDetail `type:"list" required:"true"`

	// A unprocessed list of FeatureGroup names, with their corresponding RecordIdentifier
	// value, and Feature name.
	//
	// UnprocessedIdentifiers is a required field
	UnprocessedIdentifiers []*BatchGetRecordIdentifier `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetRecordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetRecordOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchGetRecordOutput) SetErrors(v []*BatchGetRecordError) *BatchGetRecordOutput {
	s.Errors = v
	return s
}

// SetRecords sets the Records field's value.
func (s *BatchGetRecordOutput) SetRecords(v []*BatchGetRecordResultDetail) *BatchGetRecordOutput {
	s.Records = v
	return s
}

// SetUnprocessedIdentifiers sets the UnprocessedIdentifiers field's value.
func (s *BatchGetRecordOutput) SetUnprocessedIdentifiers(v []*BatchGetRecordIdentifier) *BatchGetRecordOutput {
	s.UnprocessedIdentifiers = v
	return s
}

// The output of records that have been retrieved in a batch.
type BatchGetRecordResultDetail struct {
	_ struct{} `type:"structure"`

	// The ExpiresAt ISO string of the requested record.
	ExpiresAt *string `type:"string"`

	// The FeatureGroupName containing Records you retrieved in a batch.
	//
	// FeatureGroupName is a required field
	FeatureGroupName *string `type:"string" required:"true"`

	// The Record retrieved.
	//
	// Record is a required field
	Record []*FeatureValue `min:"1" type:"list" required:"true"`

	// The value of the record identifier in string format.
	//
	// RecordIdentifierValueAsString is a required field
	RecordIdentifierValueAsString *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetRecordResultDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetRecordResultDetail) GoString() string {
	return s.String()
}

// SetExpiresAt sets the ExpiresAt field's value.
func (s *BatchGetRecordResultDetail) SetExpiresAt(v string) *BatchGetRecordResultDetail {
	s.ExpiresAt = &v
	return s
}

// SetFeatureGroupName sets the FeatureGroupName field's value.
func (s *BatchGetRecordResultDetail) SetFeatureGroupName(v string) *BatchGetRecordResultDetail {
	s.FeatureGroupName = &v
	return s
}

// SetRecord sets the Record field's value.
func (s *BatchGetRecordResultDetail) SetRecord(v []*FeatureValue) *BatchGetRecordResultDetail {
	s.Record = v
	return s
}

// SetRecordIdentifierValueAsString sets the RecordIdentifierValueAsString field's value.
func (s *BatchGetRecordResultDetail) SetRecordIdentifierValueAsString(v string) *BatchGetRecordResultDetail {
	s.RecordIdentifierValueAsString = &v
	return s
}

type DeleteRecordInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the deletion mode for deleting the record. By default, the deletion
	// mode is set to SoftDelete.
	DeletionMode *string `location:"querystring" locationName:"DeletionMode" type:"string" enum:"DeletionMode"`

	// Timestamp indicating when the deletion event occurred. EventTime can be used
	// to query data at a certain point in time.
	//
	// EventTime is a required field
	EventTime *string `location:"querystring" locationName:"EventTime" type:"string" required:"true"`

	// The name or Amazon Resource Name (ARN) of the feature group to delete the
	// record from.
	//
	// FeatureGroupName is a required field
	FeatureGroupName *string `location:"uri" locationName:"FeatureGroupName" min:"1" type:"string" required:"true"`

	// The value for the RecordIdentifier that uniquely identifies the record, in
	// string format.
	//
	// RecordIdentifierValueAsString is a required field
	RecordIdentifierValueAsString *string `location:"querystring" locationName:"RecordIdentifierValueAsString" type:"string" required:"true"`

	// A list of stores from which you're deleting the record. By default, Feature
	// Store deletes the record from all of the stores that you're using for the
	// FeatureGroup.
	TargetStores []*string `location:"querystring" locationName:"TargetStores" min:"1" type:"list" enum:"TargetStore"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRecordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRecordInput"}
	if s.EventTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTime"))
	}
	if s.FeatureGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("FeatureGroupName"))
	}
	if s.FeatureGroupName != nil && len(*s.FeatureGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FeatureGroupName", 1))
	}
	if s.RecordIdentifierValueAsString == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordIdentifierValueAsString"))
	}
	if s.TargetStores != nil && len(s.TargetStores) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetStores", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeletionMode sets the DeletionMode field's value.
func (s *DeleteRecordInput) SetDeletionMode(v string) *DeleteRecordInput {
	s.DeletionMode = &v
	return s
}

// SetEventTime sets the EventTime field's value.
func (s *DeleteRecordInput) SetEventTime(v string) *DeleteRecordInput {
	s.EventTime = &v
	return s
}

// SetFeatureGroupName sets the FeatureGroupName field's value.
func (s *DeleteRecordInput) SetFeatureGroupName(v string) *DeleteRecordInput {
	s.FeatureGroupName = &v
	return s
}

// SetRecordIdentifierValueAsString sets the RecordIdentifierValueAsString field's value.
func (s *DeleteRecordInput) SetRecordIdentifierValueAsString(v string) *DeleteRecordInput {
	s.RecordIdentifierValueAsString = &v
	return s
}

// SetTargetStores sets the TargetStores field's value.
func (s *DeleteRecordInput) SetTargetStores(v []*string) *DeleteRecordInput {
	s.TargetStores = v
	return s
}

type DeleteRecordOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecordOutput) GoString() string {
	return s.String()
}

// The value associated with a feature.
type FeatureValue struct {
	_ struct{} `type:"structure"`

	// The name of a feature that a feature value corresponds to.
	//
	// FeatureName is a required field
	FeatureName *string `min:"1" type:"string" required:"true"`

	// The value in string format associated with a feature. Used when your CollectionType
	// is None. Note that features types can be String, Integral, or Fractional.
	// This value represents all three types as a string.
	ValueAsString *string `type:"string"`

	// The list of values in string format associated with a feature. Used when
	// your CollectionType is a List, Set, or Vector. Note that features types can
	// be String, Integral, or Fractional. These values represents all three types
	// as a string.
	ValueAsStringList []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FeatureValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FeatureValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FeatureValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FeatureValue"}
	if s.FeatureName == nil {
		invalidParams.Add(request.NewErrParamRequired("FeatureName"))
	}
	if s.FeatureName != nil && len(*s.FeatureName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FeatureName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFeatureName sets the FeatureName field's value.
func (s *FeatureValue) SetFeatureName(v string) *FeatureValue {
	s.FeatureName = &v
	return s
}

// SetValueAsString sets the ValueAsString field's value.
func (s *FeatureValue) SetValueAsString(v string) *FeatureValue {
	s.ValueAsString = &v
	return s
}

// SetValueAsStringList sets the ValueAsStringList field's value.
func (s *FeatureValue) SetValueAsStringList(v []*string) *FeatureValue {
	s.ValueAsStringList = v
	return s
}

type GetRecordInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Parameter to request ExpiresAt in response. If Enabled, GetRecord will return
	// the value of ExpiresAt, if it is not null. If Disabled and null, GetRecord
	// will return null.
	ExpirationTimeResponse *string `location:"querystring" locationName:"ExpirationTimeResponse" type:"string" enum:"ExpirationTimeResponse"`

	// The name or Amazon Resource Name (ARN) of the feature group from which you
	// want to retrieve a record.
	//
	// FeatureGroupName is a required field
	FeatureGroupName *string `location:"uri" locationName:"FeatureGroupName" min:"1" type:"string" required:"true"`

	// List of names of Features to be retrieved. If not specified, the latest value
	// for all the Features are returned.
	FeatureNames []*string `location:"querystring" locationName:"FeatureName" min:"1" type:"list"`

	// The value that corresponds to RecordIdentifier type and uniquely identifies
	// the record in the FeatureGroup.
	//
	// RecordIdentifierValueAsString is a required field
	RecordIdentifierValueAsString *string `location:"querystring" locationName:"RecordIdentifierValueAsString" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRecordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRecordInput"}
	if s.FeatureGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("FeatureGroupName"))
	}
	if s.FeatureGroupName != nil && len(*s.FeatureGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FeatureGroupName", 1))
	}
	if s.FeatureNames != nil && len(s.FeatureNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FeatureNames", 1))
	}
	if s.RecordIdentifierValueAsString == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordIdentifierValueAsString"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpirationTimeResponse sets the ExpirationTimeResponse field's value.
func (s *GetRecordInput) SetExpirationTimeResponse(v string) *GetRecordInput {
	s.ExpirationTimeResponse = &v
	return s
}

// SetFeatureGroupName sets the FeatureGroupName field's value.
func (s *GetRecordInput) SetFeatureGroupName(v string) *GetRecordInput {
	s.FeatureGroupName = &v
	return s
}

// SetFeatureNames sets the FeatureNames field's value.
func (s *GetRecordInput) SetFeatureNames(v []*string) *GetRecordInput {
	s.FeatureNames = v
	return s
}

// SetRecordIdentifierValueAsString sets the RecordIdentifierValueAsString field's value.
func (s *GetRecordInput) SetRecordIdentifierValueAsString(v string) *GetRecordInput {
	s.RecordIdentifierValueAsString = &v
	return s
}

type GetRecordOutput struct {
	_ struct{} `type:"structure"`

	// The ExpiresAt ISO string of the requested record.
	ExpiresAt *string `type:"string"`

	// The record you requested. A list of FeatureValues.
	Record []*FeatureValue `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecordOutput) GoString() string {
	return s.String()
}

// SetExpiresAt sets the ExpiresAt field's value.
func (s *GetRecordOutput) SetExpiresAt(v string) *GetRecordOutput {
	s.ExpiresAt = &v
	return s
}

// SetRecord sets the Record field's value.
func (s *GetRecordOutput) SetRecord(v []*FeatureValue) *GetRecordOutput {
	s.Record = v
	return s
}

// An internal failure occurred. Try your request again. If the problem persists,
// contact Amazon Web Services customer support.
type InternalFailure struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalFailure) GoString() string {
	return s.String()
}

func newErrorInternalFailure(v protocol.ResponseMetadata) error {
	return &InternalFailure{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalFailure) Code() string {
	return "InternalFailure"
}

// Message returns the exception's message.
func (s *InternalFailure) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalFailure) OrigErr() error {
	return nil
}

func (s *InternalFailure) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalFailure) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalFailure) RequestID() string {
	return s.RespMetadata.RequestID
}

type PutRecordInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the feature group that you want
	// to insert the record into.
	//
	// FeatureGroupName is a required field
	FeatureGroupName *string `location:"uri" locationName:"FeatureGroupName" min:"1" type:"string" required:"true"`

	// List of FeatureValues to be inserted. This will be a full over-write. If
	// you only want to update few of the feature values, do the following:
	//
	//    * Use GetRecord to retrieve the latest record.
	//
	//    * Update the record returned from GetRecord.
	//
	//    * Use PutRecord to update feature values.
	//
	// Record is a required field
	Record []*FeatureValue `min:"1" type:"list" required:"true"`

	// A list of stores to which you're adding the record. By default, Feature Store
	// adds the record to all of the stores that you're using for the FeatureGroup.
	TargetStores []*string `min:"1" type:"list" enum:"TargetStore"`

	// Time to live duration, where the record is hard deleted after the expiration
	// time is reached; ExpiresAt = EventTime + TtlDuration. For information on
	// HardDelete, see the DeleteRecord (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html)
	// API in the Amazon SageMaker API Reference guide.
	TtlDuration *TtlDuration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRecordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRecordInput"}
	if s.FeatureGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("FeatureGroupName"))
	}
	if s.FeatureGroupName != nil && len(*s.FeatureGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FeatureGroupName", 1))
	}
	if s.Record == nil {
		invalidParams.Add(request.NewErrParamRequired("Record"))
	}
	if s.Record != nil && len(s.Record) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Record", 1))
	}
	if s.TargetStores != nil && len(s.TargetStores) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetStores", 1))
	}
	if s.Record != nil {
		for i, v := range s.Record {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Record", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TtlDuration != nil {
		if err := s.TtlDuration.Validate(); err != nil {
			invalidParams.AddNested("TtlDuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFeatureGroupName sets the FeatureGroupName field's value.
func (s *PutRecordInput) SetFeatureGroupName(v string) *PutRecordInput {
	s.FeatureGroupName = &v
	return s
}

// SetRecord sets the Record field's value.
func (s *PutRecordInput) SetRecord(v []*FeatureValue) *PutRecordInput {
	s.Record = v
	return s
}

// SetTargetStores sets the TargetStores field's value.
func (s *PutRecordInput) SetTargetStores(v []*string) *PutRecordInput {
	s.TargetStores = v
	return s
}

// SetTtlDuration sets the TtlDuration field's value.
func (s *PutRecordInput) SetTtlDuration(v *TtlDuration) *PutRecordInput {
	s.TtlDuration = v
	return s
}

type PutRecordOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordOutput) GoString() string {
	return s.String()
}

// A resource that is required to perform an action was not found.
type ResourceNotFound struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFound) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFound) GoString() string {
	return s.String()
}

func newErrorResourceNotFound(v protocol.ResponseMetadata) error {
	return &ResourceNotFound{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFound) Code() string {
	return "ResourceNotFound"
}

// Message returns the exception's message.
func (s *ResourceNotFound) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFound) OrigErr() error {
	return nil
}

func (s *ResourceNotFound) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFound) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFound) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service is currently unavailable.
type ServiceUnavailable struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailable) GoString() string {
	return s.String()
}

func newErrorServiceUnavailable(v protocol.ResponseMetadata) error {
	return &ServiceUnavailable{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailable) Code() string {
	return "ServiceUnavailable"
}

// Message returns the exception's message.
func (s *ServiceUnavailable) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailable) OrigErr() error {
	return nil
}

func (s *ServiceUnavailable) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailable) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailable) RequestID() string {
	return s.RespMetadata.RequestID
}

// Time to live duration, where the record is hard deleted after the expiration
// time is reached; ExpiresAt = EventTime + TtlDuration. For information on
// HardDelete, see the DeleteRecord (https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html)
// API in the Amazon SageMaker API Reference guide.
type TtlDuration struct {
	_ struct{} `type:"structure"`

	// TtlDuration time unit.
	//
	// Unit is a required field
	Unit *string `type:"string" required:"true" enum:"TtlDurationUnit"`

	// TtlDuration time value.
	//
	// Value is a required field
	Value *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TtlDuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TtlDuration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TtlDuration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TtlDuration"}
	if s.Unit == nil {
		invalidParams.Add(request.NewErrParamRequired("Unit"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && *s.Value < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUnit sets the Unit field's value.
func (s *TtlDuration) SetUnit(v string) *TtlDuration {
	s.Unit = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TtlDuration) SetValue(v int64) *TtlDuration {
	s.Value = &v
	return s
}

// There was an error validating your request.
type ValidationError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationError) GoString() string {
	return s.String()
}

func newErrorValidationError(v protocol.ResponseMetadata) error {
	return &ValidationError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationError) Code() string {
	return "ValidationError"
}

// Message returns the exception's message.
func (s *ValidationError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationError) OrigErr() error {
	return nil
}

func (s *ValidationError) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationError) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// DeletionModeSoftDelete is a DeletionMode enum value
	DeletionModeSoftDelete = "SoftDelete"

	// DeletionModeHardDelete is a DeletionMode enum value
	DeletionModeHardDelete = "HardDelete"
)

// DeletionMode_Values returns all elements of the DeletionMode enum
func DeletionMode_Values() []string {
	return []string{
		DeletionModeSoftDelete,
		DeletionModeHardDelete,
	}
}

const (
	// ExpirationTimeResponseEnabled is a ExpirationTimeResponse enum value
	ExpirationTimeResponseEnabled = "Enabled"

	// ExpirationTimeResponseDisabled is a ExpirationTimeResponse enum value
	ExpirationTimeResponseDisabled = "Disabled"
)

// ExpirationTimeResponse_Values returns all elements of the ExpirationTimeResponse enum
func ExpirationTimeResponse_Values() []string {
	return []string{
		ExpirationTimeResponseEnabled,
		ExpirationTimeResponseDisabled,
	}
}

const (
	// TargetStoreOnlineStore is a TargetStore enum value
	TargetStoreOnlineStore = "OnlineStore"

	// TargetStoreOfflineStore is a TargetStore enum value
	TargetStoreOfflineStore = "OfflineStore"
)

// TargetStore_Values returns all elements of the TargetStore enum
func TargetStore_Values() []string {
	return []string{
		TargetStoreOnlineStore,
		TargetStoreOfflineStore,
	}
}

const (
	// TtlDurationUnitSeconds is a TtlDurationUnit enum value
	TtlDurationUnitSeconds = "Seconds"

	// TtlDurationUnitMinutes is a TtlDurationUnit enum value
	TtlDurationUnitMinutes = "Minutes"

	// TtlDurationUnitHours is a TtlDurationUnit enum value
	TtlDurationUnitHours = "Hours"

	// TtlDurationUnitDays is a TtlDurationUnit enum value
	TtlDurationUnitDays = "Days"

	// TtlDurationUnitWeeks is a TtlDurationUnit enum value
	TtlDurationUnitWeeks = "Weeks"
)

// TtlDurationUnit_Values returns all elements of the TtlDurationUnit enum
func TtlDurationUnit_Values() []string {
	return []string{
		TtlDurationUnitSeconds,
		TtlDurationUnitMinutes,
		TtlDurationUnitHours,
		TtlDurationUnitDays,
		TtlDurationUnitWeeks,
	}
}
