// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package artifact_test

import (
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awserr"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/artifact"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// Invoke GetAccountSettings operation
// Get the current account settings.
func ExampleArtifact_GetAccountSettings_shared00() {
	svc := artifact.New(session.New())
	input := &artifact.GetAccountSettingsInput{}

	result, err := svc.GetAccountSettings(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case artifact.ErrCodeResourceNotFoundException:
				fmt.Println(artifact.ErrCodeResourceNotFoundException, aerr.Error())
			case artifact.ErrCodeThrottlingException:
				fmt.Println(artifact.ErrCodeThrottlingException, aerr.Error())
			case artifact.ErrCodeAccessDeniedException:
				fmt.Println(artifact.ErrCodeAccessDeniedException, aerr.Error())
			case artifact.ErrCodeConflictException:
				fmt.Println(artifact.ErrCodeConflictException, aerr.Error())
			case artifact.ErrCodeInternalServerException:
				fmt.Println(artifact.ErrCodeInternalServerException, aerr.Error())
			case artifact.ErrCodeValidationException:
				fmt.Println(artifact.ErrCodeValidationException, aerr.Error())
			case artifact.ErrCodeServiceQuotaExceededException:
				fmt.Println(artifact.ErrCodeServiceQuotaExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Invoke GetReport operation on the latest version of a specific report
// The GetReport operation is invoked on a reportId and on a optional version.
//
//	Callers must provide a termToken, which is provided by the
//	GetTermForReport
//	operation. If callers do not provide a version, it will default
//	to the
//	report's latest version
func ExampleArtifact_GetReport_shared00() {
	svc := artifact.New(session.New())
	input := &artifact.GetReportInput{
		ReportId:  aws.String("report-1hVFddebtfDNJAUf"),
		TermToken: aws.String("term-token-gPFEGk7CF4wS901w7ppYclt7"),
	}

	result, err := svc.GetReport(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case artifact.ErrCodeResourceNotFoundException:
				fmt.Println(artifact.ErrCodeResourceNotFoundException, aerr.Error())
			case artifact.ErrCodeThrottlingException:
				fmt.Println(artifact.ErrCodeThrottlingException, aerr.Error())
			case artifact.ErrCodeAccessDeniedException:
				fmt.Println(artifact.ErrCodeAccessDeniedException, aerr.Error())
			case artifact.ErrCodeConflictException:
				fmt.Println(artifact.ErrCodeConflictException, aerr.Error())
			case artifact.ErrCodeInternalServerException:
				fmt.Println(artifact.ErrCodeInternalServerException, aerr.Error())
			case artifact.ErrCodeValidationException:
				fmt.Println(artifact.ErrCodeValidationException, aerr.Error())
			case artifact.ErrCodeServiceQuotaExceededException:
				fmt.Println(artifact.ErrCodeServiceQuotaExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Invoke GetReportMetadata operation on the latest version of a specific report
// The GetReportMetadata operation is invoked on a reportId and on a optional version.
//
//	If callers do not provide a version, it will default to the
//	report's latest version.
func ExampleArtifact_GetReportMetadata_shared00() {
	svc := artifact.New(session.New())
	input := &artifact.GetReportMetadataInput{
		ReportId: aws.String("report-bqhUJF3FrQZsMJpb"),
	}

	result, err := svc.GetReportMetadata(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case artifact.ErrCodeResourceNotFoundException:
				fmt.Println(artifact.ErrCodeResourceNotFoundException, aerr.Error())
			case artifact.ErrCodeThrottlingException:
				fmt.Println(artifact.ErrCodeThrottlingException, aerr.Error())
			case artifact.ErrCodeAccessDeniedException:
				fmt.Println(artifact.ErrCodeAccessDeniedException, aerr.Error())
			case artifact.ErrCodeInternalServerException:
				fmt.Println(artifact.ErrCodeInternalServerException, aerr.Error())
			case artifact.ErrCodeValidationException:
				fmt.Println(artifact.ErrCodeValidationException, aerr.Error())
			case artifact.ErrCodeServiceQuotaExceededException:
				fmt.Println(artifact.ErrCodeServiceQuotaExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Invoke GetTermForReport operation on the latest version of a specific report
// The GetTermForReport operation is invoked on a reportId and on a optional version.
//
//	If callers do not provide a version, it will default to the
//	report's latest version.
func ExampleArtifact_GetTermForReport_shared00() {
	svc := artifact.New(session.New())
	input := &artifact.GetTermForReportInput{
		ReportId: aws.String("report-bqhUJF3FrQZsMJpb"),
	}

	result, err := svc.GetTermForReport(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case artifact.ErrCodeResourceNotFoundException:
				fmt.Println(artifact.ErrCodeResourceNotFoundException, aerr.Error())
			case artifact.ErrCodeThrottlingException:
				fmt.Println(artifact.ErrCodeThrottlingException, aerr.Error())
			case artifact.ErrCodeAccessDeniedException:
				fmt.Println(artifact.ErrCodeAccessDeniedException, aerr.Error())
			case artifact.ErrCodeConflictException:
				fmt.Println(artifact.ErrCodeConflictException, aerr.Error())
			case artifact.ErrCodeInternalServerException:
				fmt.Println(artifact.ErrCodeInternalServerException, aerr.Error())
			case artifact.ErrCodeValidationException:
				fmt.Println(artifact.ErrCodeValidationException, aerr.Error())
			case artifact.ErrCodeServiceQuotaExceededException:
				fmt.Println(artifact.ErrCodeServiceQuotaExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Invoke ListReports operation
// The ListReports operation returns a collection of report resources.
func ExampleArtifact_ListReports_shared00() {
	svc := artifact.New(session.New())
	input := &artifact.ListReportsInput{}

	result, err := svc.ListReports(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case artifact.ErrCodeResourceNotFoundException:
				fmt.Println(artifact.ErrCodeResourceNotFoundException, aerr.Error())
			case artifact.ErrCodeThrottlingException:
				fmt.Println(artifact.ErrCodeThrottlingException, aerr.Error())
			case artifact.ErrCodeAccessDeniedException:
				fmt.Println(artifact.ErrCodeAccessDeniedException, aerr.Error())
			case artifact.ErrCodeInternalServerException:
				fmt.Println(artifact.ErrCodeInternalServerException, aerr.Error())
			case artifact.ErrCodeValidationException:
				fmt.Println(artifact.ErrCodeValidationException, aerr.Error())
			case artifact.ErrCodeServiceQuotaExceededException:
				fmt.Println(artifact.ErrCodeServiceQuotaExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Invoke PutAccountSettings operation
// Set the account settings.
func ExampleArtifact_PutAccountSettings_shared00() {
	svc := artifact.New(session.New())
	input := &artifact.PutAccountSettingsInput{
		NotificationSubscriptionStatus: aws.String("SUBSCRIBED"),
	}

	result, err := svc.PutAccountSettings(input)
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case artifact.ErrCodeResourceNotFoundException:
				fmt.Println(artifact.ErrCodeResourceNotFoundException, aerr.Error())
			case artifact.ErrCodeThrottlingException:
				fmt.Println(artifact.ErrCodeThrottlingException, aerr.Error())
			case artifact.ErrCodeAccessDeniedException:
				fmt.Println(artifact.ErrCodeAccessDeniedException, aerr.Error())
			case artifact.ErrCodeConflictException:
				fmt.Println(artifact.ErrCodeConflictException, aerr.Error())
			case artifact.ErrCodeInternalServerException:
				fmt.Println(artifact.ErrCodeInternalServerException, aerr.Error())
			case artifact.ErrCodeValidationException:
				fmt.Println(artifact.ErrCodeValidationException, aerr.Error())
			case artifact.ErrCodeServiceQuotaExceededException:
				fmt.Println(artifact.ErrCodeServiceQuotaExceededException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
