package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeHealthChecks invokes the smartag.DescribeHealthChecks API synchronously
func (client *Client) DescribeHealthChecks(request *DescribeHealthChecksRequest) (response *DescribeHealthChecksResponse, err error) {
	response = CreateDescribeHealthChecksResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeHealthChecksWithChan invokes the smartag.DescribeHealthChecks API asynchronously
func (client *Client) DescribeHealthChecksWithChan(request *DescribeHealthChecksRequest) (<-chan *DescribeHealthChecksResponse, <-chan error) {
	responseChan := make(chan *DescribeHealthChecksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeHealthChecks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeHealthChecksWithCallback invokes the smartag.DescribeHealthChecks API asynchronously
func (client *Client) DescribeHealthChecksWithCallback(request *DescribeHealthChecksRequest, callback func(response *DescribeHealthChecksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeHealthChecksResponse
		var err error
		defer close(result)
		response, err = client.DescribeHealthChecks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeHealthChecksRequest is the request struct for api DescribeHealthChecks
type DescribeHealthChecksRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	HcInstanceId         string           `position:"Query" name:"HcInstanceId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Name                 string           `position:"Query" name:"Name"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// DescribeHealthChecksResponse is the response struct for api DescribeHealthChecks
type DescribeHealthChecksResponse struct {
	*responses.BaseResponse
	TotalCount   int          `json:"TotalCount" xml:"TotalCount"`
	PageSize     int          `json:"PageSize" xml:"PageSize"`
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	PageNumber   int          `json:"PageNumber" xml:"PageNumber"`
	HealthChecks HealthChecks `json:"HealthChecks" xml:"HealthChecks"`
}

// CreateDescribeHealthChecksRequest creates a request to invoke DescribeHealthChecks API
func CreateDescribeHealthChecksRequest() (request *DescribeHealthChecksRequest) {
	request = &DescribeHealthChecksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribeHealthChecks", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeHealthChecksResponse creates a response to parse from DescribeHealthChecks response
func CreateDescribeHealthChecksResponse() (response *DescribeHealthChecksResponse) {
	response = &DescribeHealthChecksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
