package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCache invokes the sgw.CreateCache API synchronously
func (client *Client) CreateCache(request *CreateCacheRequest) (response *CreateCacheResponse, err error) {
	response = CreateCreateCacheResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCacheWithChan invokes the sgw.CreateCache API asynchronously
func (client *Client) CreateCacheWithChan(request *CreateCacheRequest) (<-chan *CreateCacheResponse, <-chan error) {
	responseChan := make(chan *CreateCacheResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCache(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCacheWithCallback invokes the sgw.CreateCache API asynchronously
func (client *Client) CreateCacheWithCallback(request *CreateCacheRequest, callback func(response *CreateCacheResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCacheResponse
		var err error
		defer close(result)
		response, err = client.CreateCache(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCacheRequest is the request struct for api CreateCache
type CreateCacheRequest struct {
	*requests.RpcRequest
	SizeInGB      requests.Integer `position:"Query" name:"SizeInGB"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	Category      string           `position:"Query" name:"Category"`
	GatewayId     string           `position:"Query" name:"GatewayId"`
}

// CreateCacheResponse is the response struct for api CreateCache
type CreateCacheResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	CacheId   string `json:"CacheId" xml:"CacheId"`
	BuyURL    string `json:"BuyURL" xml:"BuyURL"`
}

// CreateCreateCacheRequest creates a request to invoke CreateCache API
func CreateCreateCacheRequest() (request *CreateCacheRequest) {
	request = &CreateCacheRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "CreateCache", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateCacheResponse creates a response to parse from CreateCache response
func CreateCreateCacheResponse() (response *CreateCacheResponse) {
	response = &CreateCacheResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
