package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTagResourcesForRegion invokes the polardb.ListTagResourcesForRegion API synchronously
func (client *Client) ListTagResourcesForRegion(request *ListTagResourcesForRegionRequest) (response *ListTagResourcesForRegionResponse, err error) {
	response = CreateListTagResourcesForRegionResponse()
	err = client.DoAction(request, response)
	return
}

// ListTagResourcesForRegionWithChan invokes the polardb.ListTagResourcesForRegion API asynchronously
func (client *Client) ListTagResourcesForRegionWithChan(request *ListTagResourcesForRegionRequest) (<-chan *ListTagResourcesForRegionResponse, <-chan error) {
	responseChan := make(chan *ListTagResourcesForRegionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTagResourcesForRegion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTagResourcesForRegionWithCallback invokes the polardb.ListTagResourcesForRegion API asynchronously
func (client *Client) ListTagResourcesForRegionWithCallback(request *ListTagResourcesForRegionRequest, callback func(response *ListTagResourcesForRegionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTagResourcesForRegionResponse
		var err error
		defer close(result)
		response, err = client.ListTagResourcesForRegion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTagResourcesForRegionRequest is the request struct for api ListTagResourcesForRegion
type ListTagResourcesForRegionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NextToken            string           `position:"Query" name:"NextToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ListTagResourcesForRegionResponse is the response struct for api ListTagResourcesForRegion
type ListTagResourcesForRegionResponse struct {
	*responses.BaseResponse
	NextToken    string                                  `json:"NextToken" xml:"NextToken"`
	RequestId    string                                  `json:"RequestId" xml:"RequestId"`
	TagResources TagResourcesInListTagResourcesForRegion `json:"TagResources" xml:"TagResources"`
}

// CreateListTagResourcesForRegionRequest creates a request to invoke ListTagResourcesForRegion API
func CreateListTagResourcesForRegionRequest() (request *ListTagResourcesForRegionRequest) {
	request = &ListTagResourcesForRegionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "ListTagResourcesForRegion", "", "")
	request.Method = requests.POST
	return
}

// CreateListTagResourcesForRegionResponse creates a response to parse from ListTagResourcesForRegion response
func CreateListTagResourcesForRegionResponse() (response *ListTagResourcesForRegionResponse) {
	response = &ListTagResourcesForRegionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
