package openanalytics_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddPartitions invokes the openanalytics_open.AddPartitions API synchronously
func (client *Client) AddPartitions(request *AddPartitionsRequest) (response *AddPartitionsResponse, err error) {
	response = CreateAddPartitionsResponse()
	err = client.DoAction(request, response)
	return
}

// AddPartitionsWithChan invokes the openanalytics_open.AddPartitions API asynchronously
func (client *Client) AddPartitionsWithChan(request *AddPartitionsRequest) (<-chan *AddPartitionsResponse, <-chan error) {
	responseChan := make(chan *AddPartitionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddPartitions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddPartitionsWithCallback invokes the openanalytics_open.AddPartitions API asynchronously
func (client *Client) AddPartitionsWithCallback(request *AddPartitionsRequest, callback func(response *AddPartitionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddPartitionsResponse
		var err error
		defer close(result)
		response, err = client.AddPartitions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddPartitionsRequest is the request struct for api AddPartitions
type AddPartitionsRequest struct {
	*requests.RpcRequest
	Partition string `position:"Query" name:"Partition"`
}

// AddPartitionsResponse is the response struct for api AddPartitions
type AddPartitionsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Data      int64  `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateAddPartitionsRequest creates a request to invoke AddPartitions API
func CreateAddPartitionsRequest() (request *AddPartitionsRequest) {
	request = &AddPartitionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("openanalytics-open", "2020-09-28", "AddPartitions", "openanalytics", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddPartitionsResponse creates a response to parse from AddPartitions response
func CreateAddPartitionsResponse() (response *AddPartitionsResponse) {
	response = &AddPartitionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
