package itaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRegisterBoxList invokes the itaas.GetRegisterBoxList API synchronously
// api document: https://help.aliyun.com/api/itaas/getregisterboxlist.html
func (client *Client) GetRegisterBoxList(request *GetRegisterBoxListRequest) (response *GetRegisterBoxListResponse, err error) {
	response = CreateGetRegisterBoxListResponse()
	err = client.DoAction(request, response)
	return
}

// GetRegisterBoxListWithChan invokes the itaas.GetRegisterBoxList API asynchronously
// api document: https://help.aliyun.com/api/itaas/getregisterboxlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRegisterBoxListWithChan(request *GetRegisterBoxListRequest) (<-chan *GetRegisterBoxListResponse, <-chan error) {
	responseChan := make(chan *GetRegisterBoxListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRegisterBoxList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRegisterBoxListWithCallback invokes the itaas.GetRegisterBoxList API asynchronously
// api document: https://help.aliyun.com/api/itaas/getregisterboxlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRegisterBoxListWithCallback(request *GetRegisterBoxListRequest, callback func(response *GetRegisterBoxListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRegisterBoxListResponse
		var err error
		defer close(result)
		response, err = client.GetRegisterBoxList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRegisterBoxListRequest is the request struct for api GetRegisterBoxList
type GetRegisterBoxListRequest struct {
	*requests.RpcRequest
	Clientappid string `position:"Query" name:"Clientappid"`
	Sysfrom     string `position:"Query" name:"Sysfrom"`
	Operator    string `position:"Query" name:"Operator"`
}

// GetRegisterBoxListResponse is the response struct for api GetRegisterBoxList
type GetRegisterBoxListResponse struct {
	*responses.BaseResponse
	RequestId string                        `json:"RequestId" xml:"RequestId"`
	ErrorCode int                           `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string                        `json:"ErrorMsg" xml:"ErrorMsg"`
	Success   bool                          `json:"Success" xml:"Success"`
	Data      Data                          `json:"Data" xml:"Data"`
	ErrorList ErrorListInGetRegisterBoxList `json:"ErrorList" xml:"ErrorList"`
}

// CreateGetRegisterBoxListRequest creates a request to invoke GetRegisterBoxList API
func CreateGetRegisterBoxListRequest() (request *GetRegisterBoxListRequest) {
	request = &GetRegisterBoxListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ITaaS", "2017-05-05", "GetRegisterBoxList", "itaas", "openAPI")
	return
}

// CreateGetRegisterBoxListResponse creates a response to parse from GetRegisterBoxList response
func CreateGetRegisterBoxListResponse() (response *GetRegisterBoxListResponse) {
	response = &GetRegisterBoxListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
