package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MigrateVm invokes the ens.MigrateVm API synchronously
func (client *Client) MigrateVm(request *MigrateVmRequest) (response *MigrateVmResponse, err error) {
	response = CreateMigrateVmResponse()
	err = client.DoAction(request, response)
	return
}

// MigrateVmWithChan invokes the ens.MigrateVm API asynchronously
func (client *Client) MigrateVmWithChan(request *MigrateVmRequest) (<-chan *MigrateVmResponse, <-chan error) {
	responseChan := make(chan *MigrateVmResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MigrateVm(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MigrateVmWithCallback invokes the ens.MigrateVm API asynchronously
func (client *Client) MigrateVmWithCallback(request *MigrateVmRequest, callback func(response *MigrateVmResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MigrateVmResponse
		var err error
		defer close(result)
		response, err = client.MigrateVm(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MigrateVmRequest is the request struct for api MigrateVm
type MigrateVmRequest struct {
	*requests.RpcRequest
	Instances   string `position:"Body" name:"Instances"`
	GroupUuid   string `position:"Query" name:"GroupUuid"`
	Tenant      string `position:"Query" name:"Tenant"`
	InstanceIds string `position:"Query" name:"InstanceIds"`
}

// MigrateVmResponse is the response struct for api MigrateVm
type MigrateVmResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Data      string `json:"Data" xml:"Data"`
	Msg       string `json:"Msg" xml:"Msg"`
	Desc      string `json:"Desc" xml:"Desc"`
}

// CreateMigrateVmRequest creates a request to invoke MigrateVm API
func CreateMigrateVmRequest() (request *MigrateVmRequest) {
	request = &MigrateVmRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "MigrateVm", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateMigrateVmResponse creates a response to parse from MigrateVm response
func CreateMigrateVmResponse() (response *MigrateVmResponse) {
	response = &MigrateVmResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
