package devops_rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDevopsProjectSprint invokes the devops_rdc.CreateDevopsProjectSprint API synchronously
func (client *Client) CreateDevopsProjectSprint(request *CreateDevopsProjectSprintRequest) (response *CreateDevopsProjectSprintResponse, err error) {
	response = CreateCreateDevopsProjectSprintResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDevopsProjectSprintWithChan invokes the devops_rdc.CreateDevopsProjectSprint API asynchronously
func (client *Client) CreateDevopsProjectSprintWithChan(request *CreateDevopsProjectSprintRequest) (<-chan *CreateDevopsProjectSprintResponse, <-chan error) {
	responseChan := make(chan *CreateDevopsProjectSprintResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDevopsProjectSprint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDevopsProjectSprintWithCallback invokes the devops_rdc.CreateDevopsProjectSprint API asynchronously
func (client *Client) CreateDevopsProjectSprintWithCallback(request *CreateDevopsProjectSprintRequest, callback func(response *CreateDevopsProjectSprintResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDevopsProjectSprintResponse
		var err error
		defer close(result)
		response, err = client.CreateDevopsProjectSprint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDevopsProjectSprintRequest is the request struct for api CreateDevopsProjectSprint
type CreateDevopsProjectSprintRequest struct {
	*requests.RpcRequest
	ExecutorId  string `position:"Body" name:"ExecutorId"`
	Description string `position:"Body" name:"Description"`
	StartDate   string `position:"Body" name:"StartDate"`
	OrgId       string `position:"Body" name:"OrgId"`
	DueDate     string `position:"Body" name:"DueDate"`
	Name        string `position:"Body" name:"Name"`
	ProjectId   string `position:"Body" name:"ProjectId"`
}

// CreateDevopsProjectSprintResponse is the response struct for api CreateDevopsProjectSprint
type CreateDevopsProjectSprintResponse struct {
	*responses.BaseResponse
	Successful bool   `json:"Successful" xml:"Successful"`
	ErrorCode  string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Object     Object `json:"Object" xml:"Object"`
}

// CreateCreateDevopsProjectSprintRequest creates a request to invoke CreateDevopsProjectSprint API
func CreateCreateDevopsProjectSprintRequest() (request *CreateDevopsProjectSprintRequest) {
	request = &CreateDevopsProjectSprintRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("devops-rdc", "2020-03-03", "CreateDevopsProjectSprint", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateDevopsProjectSprintResponse creates a response to parse from CreateDevopsProjectSprint response
func CreateCreateDevopsProjectSprintResponse() (response *CreateDevopsProjectSprintResponse) {
	response = &CreateDevopsProjectSprintResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
