package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribleLayer7InstanceRelations invokes the ddoscoo.DescribleLayer7InstanceRelations API synchronously
func (client *Client) DescribleLayer7InstanceRelations(request *DescribleLayer7InstanceRelationsRequest) (response *DescribleLayer7InstanceRelationsResponse, err error) {
	response = CreateDescribleLayer7InstanceRelationsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribleLayer7InstanceRelationsWithChan invokes the ddoscoo.DescribleLayer7InstanceRelations API asynchronously
func (client *Client) DescribleLayer7InstanceRelationsWithChan(request *DescribleLayer7InstanceRelationsRequest) (<-chan *DescribleLayer7InstanceRelationsResponse, <-chan error) {
	responseChan := make(chan *DescribleLayer7InstanceRelationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribleLayer7InstanceRelations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribleLayer7InstanceRelationsWithCallback invokes the ddoscoo.DescribleLayer7InstanceRelations API asynchronously
func (client *Client) DescribleLayer7InstanceRelationsWithCallback(request *DescribleLayer7InstanceRelationsRequest, callback func(response *DescribleLayer7InstanceRelationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribleLayer7InstanceRelationsResponse
		var err error
		defer close(result)
		response, err = client.DescribleLayer7InstanceRelations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribleLayer7InstanceRelationsRequest is the request struct for api DescribleLayer7InstanceRelations
type DescribleLayer7InstanceRelationsRequest struct {
	*requests.RpcRequest
	DomainList      *[]string `position:"Query" name:"DomainList"  type:"Repeated"`
	ResourceGroupId string    `position:"Query" name:"ResourceGroupId"`
	SourceIp        string    `position:"Query" name:"SourceIp"`
}

// DescribleLayer7InstanceRelationsResponse is the response struct for api DescribleLayer7InstanceRelations
type DescribleLayer7InstanceRelationsResponse struct {
	*responses.BaseResponse
	RequestId               string                   `json:"RequestId" xml:"RequestId"`
	Layer7InstanceRelations []Layer7InstanceRelation `json:"Layer7InstanceRelations" xml:"Layer7InstanceRelations"`
}

// CreateDescribleLayer7InstanceRelationsRequest creates a request to invoke DescribleLayer7InstanceRelations API
func CreateDescribleLayer7InstanceRelationsRequest() (request *DescribleLayer7InstanceRelationsRequest) {
	request = &DescribleLayer7InstanceRelationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "DescribleLayer7InstanceRelations", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribleLayer7InstanceRelationsResponse creates a response to parse from DescribleLayer7InstanceRelations response
func CreateDescribleLayer7InstanceRelationsResponse() (response *DescribleLayer7InstanceRelationsResponse) {
	response = &DescribleLayer7InstanceRelationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
