package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListBusiness invokes the dataworks_public.ListBusiness API synchronously
func (client *Client) ListBusiness(request *ListBusinessRequest) (response *ListBusinessResponse, err error) {
	response = CreateListBusinessResponse()
	err = client.DoAction(request, response)
	return
}

// ListBusinessWithChan invokes the dataworks_public.ListBusiness API asynchronously
func (client *Client) ListBusinessWithChan(request *ListBusinessRequest) (<-chan *ListBusinessResponse, <-chan error) {
	responseChan := make(chan *ListBusinessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListBusiness(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListBusinessWithCallback invokes the dataworks_public.ListBusiness API asynchronously
func (client *Client) ListBusinessWithCallback(request *ListBusinessRequest, callback func(response *ListBusinessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListBusinessResponse
		var err error
		defer close(result)
		response, err = client.ListBusiness(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListBusinessRequest is the request struct for api ListBusiness
type ListBusinessRequest struct {
	*requests.RpcRequest
	PageSize          requests.Integer `position:"Body" name:"PageSize"`
	Keyword           string           `position:"Body" name:"Keyword"`
	ProjectId         requests.Integer `position:"Body" name:"ProjectId"`
	ProjectIdentifier string           `position:"Body" name:"ProjectIdentifier"`
	PageNumber        requests.Integer `position:"Body" name:"PageNumber"`
}

// ListBusinessResponse is the response struct for api ListBusiness
type ListBusinessResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateListBusinessRequest creates a request to invoke ListBusiness API
func CreateListBusinessRequest() (request *ListBusinessRequest) {
	request = &ListBusinessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListBusiness", "", "")
	request.Method = requests.POST
	return
}

// CreateListBusinessResponse creates a response to parse from ListBusiness response
func CreateListBusinessResponse() (response *ListBusinessResponse) {
	response = &ListBusinessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
