package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOnlineStaTimeSer invokes the cloudwf.GetOnlineStaTimeSer API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getonlinestatimeser.html
func (client *Client) GetOnlineStaTimeSer(request *GetOnlineStaTimeSerRequest) (response *GetOnlineStaTimeSerResponse, err error) {
	response = CreateGetOnlineStaTimeSerResponse()
	err = client.DoAction(request, response)
	return
}

// GetOnlineStaTimeSerWithChan invokes the cloudwf.GetOnlineStaTimeSer API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getonlinestatimeser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOnlineStaTimeSerWithChan(request *GetOnlineStaTimeSerRequest) (<-chan *GetOnlineStaTimeSerResponse, <-chan error) {
	responseChan := make(chan *GetOnlineStaTimeSerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOnlineStaTimeSer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOnlineStaTimeSerWithCallback invokes the cloudwf.GetOnlineStaTimeSer API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getonlinestatimeser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOnlineStaTimeSerWithCallback(request *GetOnlineStaTimeSerRequest, callback func(response *GetOnlineStaTimeSerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOnlineStaTimeSerResponse
		var err error
		defer close(result)
		response, err = client.GetOnlineStaTimeSer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOnlineStaTimeSerRequest is the request struct for api GetOnlineStaTimeSer
type GetOnlineStaTimeSerRequest struct {
	*requests.RpcRequest
	ZoomStart requests.Integer `position:"Query" name:"ZoomStart"`
	CompanyId requests.Integer `position:"Query" name:"CompanyId"`
	ApgroupId requests.Integer `position:"Query" name:"ApgroupId"`
	Start     requests.Integer `position:"Query" name:"Start"`
	ZoomEnd   requests.Integer `position:"Query" name:"ZoomEnd"`
	End       requests.Integer `position:"Query" name:"End"`
}

// GetOnlineStaTimeSerResponse is the response struct for api GetOnlineStaTimeSer
type GetOnlineStaTimeSerResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetOnlineStaTimeSerRequest creates a request to invoke GetOnlineStaTimeSer API
func CreateGetOnlineStaTimeSerRequest() (request *GetOnlineStaTimeSerRequest) {
	request = &GetOnlineStaTimeSerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetOnlineStaTimeSer", "cloudwf", "openAPI")
	return
}

// CreateGetOnlineStaTimeSerResponse creates a response to parse from GetOnlineStaTimeSer response
func CreateGetOnlineStaTimeSerResponse() (response *GetOnlineStaTimeSerResponse) {
	response = &GetOnlineStaTimeSerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
