package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLogQuery invokes the aegis.DescribeLogQuery API synchronously
// api document: https://help.aliyun.com/api/aegis/describelogquery.html
func (client *Client) DescribeLogQuery(request *DescribeLogQueryRequest) (response *DescribeLogQueryResponse, err error) {
	response = CreateDescribeLogQueryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLogQueryWithChan invokes the aegis.DescribeLogQuery API asynchronously
// api document: https://help.aliyun.com/api/aegis/describelogquery.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLogQueryWithChan(request *DescribeLogQueryRequest) (<-chan *DescribeLogQueryResponse, <-chan error) {
	responseChan := make(chan *DescribeLogQueryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLogQuery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLogQueryWithCallback invokes the aegis.DescribeLogQuery API asynchronously
// api document: https://help.aliyun.com/api/aegis/describelogquery.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLogQueryWithCallback(request *DescribeLogQueryRequest, callback func(response *DescribeLogQueryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLogQueryResponse
		var err error
		defer close(result)
		response, err = client.DescribeLogQuery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLogQueryRequest is the request struct for api DescribeLogQuery
type DescribeLogQueryRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeLogQueryResponse is the response struct for api DescribeLogQuery
type DescribeLogQueryResponse struct {
	*responses.BaseResponse
	RequestId  string           `json:"RequestId" xml:"RequestId"`
	ListTotal  int              `json:"ListTotal" xml:"ListTotal"`
	QueryItems []QueryItemsItem `json:"QueryItems" xml:"QueryItems"`
}

// CreateDescribeLogQueryRequest creates a request to invoke DescribeLogQuery API
func CreateDescribeLogQueryRequest() (request *DescribeLogQueryRequest) {
	request = &DescribeLogQueryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeLogQuery", "vipaegis", "openAPI")
	return
}

// CreateDescribeLogQueryResponse creates a response to parse from DescribeLogQuery response
func CreateDescribeLogQueryResponse() (response *DescribeLogQueryResponse) {
	response = &DescribeLogQueryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
