/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Info {
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final String PAX_EXAM_VERSION;
    private static final String PAX_URL_VERSION;
    private static final String OPS4J_BASE_VERSION;
    private static final String PAX_SWISSBOX_VERSION;
    private static final String PAX_TINYBUNDLES_VERSION;
    private static final String ATINJECT_VERSION;
    private static boolean paxExamSnapshotVersion;
    private static boolean paxUrlSnapshotVersion;
    private static boolean ops4jBaseSnapshotVersion;
    private static boolean paxSwissboxSnapshotVersion;
    private static boolean paxTinybundlesSnapshotVersion;

    private Info() {
    }

    public static String getPaxExamVersion() {
        return PAX_EXAM_VERSION;
    }

    public static String getPaxUrlVersion() {
        return PAX_URL_VERSION;
    }

    public static String getOps4jBaseVersion() {
        return OPS4J_BASE_VERSION;
    }

    public static String getPaxSwissboxVersion() {
        return PAX_SWISSBOX_VERSION;
    }

    public static String getPaxTinybundlesVersion() {
        return PAX_TINYBUNDLES_VERSION;
    }

    public static String getAtinjectVersion() {
        return ATINJECT_VERSION;
    }

    public static boolean isPaxExamSnapshotVersion() {
        return paxExamSnapshotVersion;
    }

    public static boolean isPaxUrlSnapshotVersion() {
        return paxUrlSnapshotVersion;
    }

    public static boolean isOps4jBaseSnapshotVersion() {
        return ops4jBaseSnapshotVersion;
    }

    public static boolean isPaxSwissboxSnapshotVersion() {
        return paxSwissboxSnapshotVersion;
    }

    public static boolean isPaxTinybundlesSnapshotVersion() {
        return paxTinybundlesSnapshotVersion;
    }

    public static void showLogo() {
        System.out.println("__________                 ___________");
        System.out.println("\\______   \\_____  ___  ___ \\_   _____/__  ________    _____");
        System.out.println(" |     ___/\\__  \\ \\  \\/  /  |    __)_\\  \\/  /\\__  \\  /     \\");
        System.out.println(" |    |     / __ \\_>    <   |        \\>    <  / __ \\|  Y Y  \\");
        System.out.println(" |____|    (____  /__/\\_ \\ /_______  /__/\\_ \\(____  /__|_|  /");
        System.out.println("                \\/      \\/         \\/      \\/     \\/      \\/");
        System.out.println();
        String logo = "Pax Exam " + Info.getPaxExamVersion() + " from OPS4J - http://www.ops4j.org";
        System.out.println(logo);
        System.out.println("---------------------------------------------------------------------------------------------------------".substring(0, logo.length()));
        System.out.println();
    }

    static {
        String paxExamVersion = "";
        String paxUrlVersion = "";
        String ops4jBaseVersion = "";
        String paxSwissboxVersion = "";
        String paxTinybundlesVersion = "";
        String atinjectVersion = "";
        try {
            InputStream is = Info.class.getClassLoader().getResourceAsStream("META-INF/pax-exam-version.properties");
            if (is != null) {
                Properties properties = new Properties();
                properties.load(is);
                paxExamVersion = properties.getProperty("pax.exam.version", "").trim();
                paxUrlVersion = properties.getProperty("pax.url.version", "").trim();
                ops4jBaseVersion = properties.getProperty("ops4j.base.version", "").trim();
                paxSwissboxVersion = properties.getProperty("pax.swissbox.version").trim();
                paxTinybundlesVersion = properties.getProperty("pax.tinybundles.version").trim();
                atinjectVersion = properties.getProperty("atinject.version").trim();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PAX_EXAM_VERSION = paxExamVersion;
        PAX_URL_VERSION = paxUrlVersion;
        OPS4J_BASE_VERSION = ops4jBaseVersion;
        PAX_SWISSBOX_VERSION = paxSwissboxVersion;
        PAX_TINYBUNDLES_VERSION = paxTinybundlesVersion;
        ATINJECT_VERSION = atinjectVersion;
        paxExamSnapshotVersion = paxExamVersion.endsWith(SNAPSHOT);
        paxUrlSnapshotVersion = paxUrlVersion.endsWith(SNAPSHOT);
        ops4jBaseSnapshotVersion = ops4jBaseVersion.endsWith(SNAPSHOT);
        paxSwissboxSnapshotVersion = paxSwissboxVersion.endsWith(SNAPSHOT);
        paxTinybundlesSnapshotVersion = paxTinybundlesVersion.endsWith(SNAPSHOT);
    }
}

