//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
#[cfg(feature = "dispatch2")]
use dispatch2::*;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-audio-types")]
use objc2_core_audio_types::*;
use objc2_core_foundation::*;
#[cfg(feature = "objc2-foundation")]
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioendpointdeviceuidkey?language=objc)
pub const kAudioEndPointDeviceUIDKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"uid\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioendpointdevicenamekey?language=objc)
pub const kAudioEndPointDeviceNameKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"name\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioendpointdeviceendpointlistkey?language=objc)
pub const kAudioEndPointDeviceEndPointListKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"endpoints\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioendpointdevicemainendpointkey?language=objc)
pub const kAudioEndPointDeviceMainEndPointKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"main\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioendpointdevicemasterendpointkey?language=objc)
pub const kAudioEndPointDeviceMasterEndPointKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"master\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioendpointdeviceisprivatekey?language=objc)
pub const kAudioEndPointDeviceIsPrivateKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"private\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioendpointuidkey?language=objc)
pub const kAudioEndPointUIDKey: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"uid\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioendpointnamekey?language=objc)
pub const kAudioEndPointNameKey: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"name\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioendpointinputchannelskey?language=objc)
pub const kAudioEndPointInputChannelsKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"channels-in\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioendpointoutputchannelskey?language=objc)
pub const kAudioEndPointOutputChannelsKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"channels-out\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedeviceuidkey?language=objc)
pub const kAudioAggregateDeviceUIDKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"uid\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedevicenamekey?language=objc)
pub const kAudioAggregateDeviceNameKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"name\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedevicesubdevicelistkey?language=objc)
pub const kAudioAggregateDeviceSubDeviceListKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"subdevices\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedevicemainsubdevicekey?language=objc)
pub const kAudioAggregateDeviceMainSubDeviceKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"master\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedeviceclockdevicekey?language=objc)
pub const kAudioAggregateDeviceClockDeviceKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"clock\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedeviceisprivatekey?language=objc)
pub const kAudioAggregateDeviceIsPrivateKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"private\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedeviceisstackedkey?language=objc)
pub const kAudioAggregateDeviceIsStackedKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"stacked\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedevicetaplistkey?language=objc)
pub const kAudioAggregateDeviceTapListKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"taps\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedevicetapautostartkey?language=objc)
pub const kAudioAggregateDeviceTapAutoStartKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"tapautostart\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubdeviceuidkey?language=objc)
pub const kAudioSubDeviceUIDKey: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"uid\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubdevicenamekey?language=objc)
pub const kAudioSubDeviceNameKey: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"name\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubdeviceinputchannelskey?language=objc)
pub const kAudioSubDeviceInputChannelsKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"channels-in\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubdeviceoutputchannelskey?language=objc)
pub const kAudioSubDeviceOutputChannelsKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"channels-out\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubdeviceextrainputlatencykey?language=objc)
pub const kAudioSubDeviceExtraInputLatencyKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"latency-in\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubdeviceextraoutputlatencykey?language=objc)
pub const kAudioSubDeviceExtraOutputLatencyKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"latency-out\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubdevicedriftcompensationkey?language=objc)
pub const kAudioSubDeviceDriftCompensationKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"drift\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubdevicedriftcompensationqualitykey?language=objc)
pub const kAudioSubDeviceDriftCompensationQualityKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"drift quality\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubtapuidkey?language=objc)
pub const kAudioSubTapUIDKey: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"uid\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubtapextrainputlatencykey?language=objc)
pub const kAudioSubTapExtraInputLatencyKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"latency-in\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubtapextraoutputlatencykey?language=objc)
pub const kAudioSubTapExtraOutputLatencyKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"latency-out\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubtapdriftcompensationkey?language=objc)
pub const kAudioSubTapDriftCompensationKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"drift\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubtapdriftcompensationqualitykey?language=objc)
pub const kAudioSubTapDriftCompensationQualityKey: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"drift quality\0") };
/// A UInt32 that provides a handle on a specific AudioObject.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audioobjectid?language=objc)
pub type AudioObjectID = u32;

/// AudioClassIDs are used to identify the class of an AudioObject.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audioclassid?language=objc)
pub type AudioClassID = u32;

/// An AudioObjectPropertySelector is a four char code that identifies, along with
/// the AudioObjectPropertyScope and AudioObjectPropertyElement, a specific piece of
/// information about an AudioObject.
///
/// The property selector specifies the general classification of the property such
/// as volume, stream format, latency, etc. Note that each class has a different set
/// of selectors. A subclass inherits its super class's set of selectors, although
/// it may not implement them all.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audioobjectpropertyselector?language=objc)
pub type AudioObjectPropertySelector = u32;

/// An AudioObjectPropertyScope is a four char code that identifies, along with the
/// AudioObjectPropertySelector and AudioObjectPropertyElement, a specific piece of
/// information about an AudioObject.
///
/// The scope specifies the section of the object in which to look for the property,
/// such as input, output, global, etc. Note that each class has a different set of
/// scopes. A subclass inherits its superclass's set of scopes.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audioobjectpropertyscope?language=objc)
pub type AudioObjectPropertyScope = u32;

/// An AudioObjectPropertyElement is an integer that identifies, along with the
/// AudioObjectPropertySelector and AudioObjectPropertyScope, a specific piece of
/// information about an AudioObject.
///
/// The element selects one of possibly many items in the section of the object in
/// which to look for the property. Elements are number sequentially where 0
/// represents the main element. Elements are particular to an instance of a
/// class, meaning that two instances can have different numbers of elements in the
/// same scope. There is no inheritance of elements.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audioobjectpropertyelement?language=objc)
pub type AudioObjectPropertyElement = u32;

/// An AudioObjectPropertyAddress collects the three parts that identify a specific
/// property together in a struct for easy transmission.
/// Field: mSelector
/// The AudioObjectPropertySelector for the property.
/// Field: mScope
/// The AudioObjectPropertyScope for the property.
/// Field: mElement
/// The AudioObjectPropertyElement for the property.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audioobjectpropertyaddress?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioObjectPropertyAddress {
    pub mSelector: AudioObjectPropertySelector,
    pub mScope: AudioObjectPropertyScope,
    pub mElement: AudioObjectPropertyElement,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for AudioObjectPropertyAddress {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioObjectPropertyAddress",
        &[
            <AudioObjectPropertySelector>::ENCODING,
            <AudioObjectPropertyScope>::ENCODING,
            <AudioObjectPropertyElement>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for AudioObjectPropertyAddress {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarenoerror?language=objc)
pub const kAudioHardwareNoError: OSStatus = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarenotrunningerror?language=objc)
pub const kAudioHardwareNotRunningError: OSStatus = 0x73746f70;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwareunspecifiederror?language=objc)
pub const kAudioHardwareUnspecifiedError: OSStatus = 0x77686174;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwareunknownpropertyerror?language=objc)
pub const kAudioHardwareUnknownPropertyError: OSStatus = 0x77686f3f;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarebadpropertysizeerror?language=objc)
pub const kAudioHardwareBadPropertySizeError: OSStatus = 0x2173697a;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwareillegaloperationerror?language=objc)
pub const kAudioHardwareIllegalOperationError: OSStatus = 0x6e6f7065;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarebadobjecterror?language=objc)
pub const kAudioHardwareBadObjectError: OSStatus = 0x216f626a;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarebaddeviceerror?language=objc)
pub const kAudioHardwareBadDeviceError: OSStatus = 0x21646576;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarebadstreamerror?language=objc)
pub const kAudioHardwareBadStreamError: OSStatus = 0x21737472;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwareunsupportedoperationerror?language=objc)
pub const kAudioHardwareUnsupportedOperationError: OSStatus = 0x756e6f70;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarenotreadyerror?language=objc)
pub const kAudioHardwareNotReadyError: OSStatus = 0x6e726479;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodeviceunsupportedformaterror?language=objc)
pub const kAudioDeviceUnsupportedFormatError: OSStatus = 0x21646174;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepermissionserror?language=objc)
pub const kAudioDevicePermissionsError: OSStatus = 0x21686f67;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectunknown?language=objc)
pub const kAudioObjectUnknown: AudioObjectID = 0;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertyscopeglobal?language=objc)
pub const kAudioObjectPropertyScopeGlobal: AudioObjectPropertyScope = 0x676c6f62;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertyscopeinput?language=objc)
pub const kAudioObjectPropertyScopeInput: AudioObjectPropertyScope = 0x696e7074;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertyscopeoutput?language=objc)
pub const kAudioObjectPropertyScopeOutput: AudioObjectPropertyScope = 0x6f757470;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertyscopeplaythrough?language=objc)
pub const kAudioObjectPropertyScopePlayThrough: AudioObjectPropertyScope = 0x70747275;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertyelementmain?language=objc)
pub const kAudioObjectPropertyElementMain: AudioObjectPropertyScope = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertyelementmaster?language=objc)
#[deprecated]
pub const kAudioObjectPropertyElementMaster: AudioObjectPropertyScope =
    kAudioObjectPropertyElementMain;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertyselectorwildcard?language=objc)
pub const kAudioObjectPropertySelectorWildcard: AudioObjectPropertySelector = 0x2a2a2a2a;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertyscopewildcard?language=objc)
pub const kAudioObjectPropertyScopeWildcard: AudioObjectPropertyScope = 0x2a2a2a2a;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertyelementwildcard?language=objc)
pub const kAudioObjectPropertyElementWildcard: AudioObjectPropertyElement = 0xFFFFFFFF;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectclassidwildcard?language=objc)
pub const kAudioObjectClassIDWildcard: AudioClassID = 0x2a2a2a2a;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectclassid?language=objc)
pub const kAudioObjectClassID: AudioClassID = 0x616f626a;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertybaseclass?language=objc)
pub const kAudioObjectPropertyBaseClass: AudioObjectPropertySelector = 0x62636c73;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertyclass?language=objc)
pub const kAudioObjectPropertyClass: AudioObjectPropertySelector = 0x636c6173;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertyowner?language=objc)
pub const kAudioObjectPropertyOwner: AudioObjectPropertySelector = 0x73746476;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertyname?language=objc)
pub const kAudioObjectPropertyName: AudioObjectPropertySelector = 0x6c6e616d;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertymodelname?language=objc)
pub const kAudioObjectPropertyModelName: AudioObjectPropertySelector = 0x6c6d6f64;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertymanufacturer?language=objc)
pub const kAudioObjectPropertyManufacturer: AudioObjectPropertySelector = 0x6c6d616b;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertyelementname?language=objc)
pub const kAudioObjectPropertyElementName: AudioObjectPropertySelector = 0x6c63686e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertyelementcategoryname?language=objc)
pub const kAudioObjectPropertyElementCategoryName: AudioObjectPropertySelector = 0x6c63636e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertyelementnumbername?language=objc)
pub const kAudioObjectPropertyElementNumberName: AudioObjectPropertySelector = 0x6c636e6e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertyownedobjects?language=objc)
pub const kAudioObjectPropertyOwnedObjects: AudioObjectPropertySelector = 0x6f776e64;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertyidentify?language=objc)
pub const kAudioObjectPropertyIdentify: AudioObjectPropertySelector = 0x6964656e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertyserialnumber?language=objc)
pub const kAudioObjectPropertySerialNumber: AudioObjectPropertySelector = 0x736e756d;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertyfirmwareversion?language=objc)
pub const kAudioObjectPropertyFirmwareVersion: AudioObjectPropertySelector = 0x6677766e;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiopluginclassid?language=objc)
pub const kAudioPlugInClassID: AudioClassID = 0x61706c67;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiopluginpropertybundleid?language=objc)
pub const kAudioPlugInPropertyBundleID: AudioObjectPropertySelector = 0x70696964;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiopluginpropertydevicelist?language=objc)
pub const kAudioPlugInPropertyDeviceList: AudioObjectPropertySelector = 0x64657623;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiopluginpropertytranslateuidtodevice?language=objc)
pub const kAudioPlugInPropertyTranslateUIDToDevice: AudioObjectPropertySelector = 0x75696464;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiopluginpropertyboxlist?language=objc)
pub const kAudioPlugInPropertyBoxList: AudioObjectPropertySelector = 0x626f7823;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiopluginpropertytranslateuidtobox?language=objc)
pub const kAudioPlugInPropertyTranslateUIDToBox: AudioObjectPropertySelector = 0x75696462;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiopluginpropertyclockdevicelist?language=objc)
pub const kAudioPlugInPropertyClockDeviceList: AudioObjectPropertySelector = 0x636c6b23;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiopluginpropertytranslateuidtoclockdevice?language=objc)
pub const kAudioPlugInPropertyTranslateUIDToClockDevice: AudioObjectPropertySelector = 0x75696463;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiotransportmanagerclassid?language=objc)
pub const kAudioTransportManagerClassID: AudioClassID = 0x7472706d;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiotransportmanagerpropertyendpointlist?language=objc)
pub const kAudioTransportManagerPropertyEndPointList: AudioObjectPropertySelector = 0x656e6423;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiotransportmanagerpropertytranslateuidtoendpoint?language=objc)
pub const kAudioTransportManagerPropertyTranslateUIDToEndPoint: AudioObjectPropertySelector =
    0x75696465;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiotransportmanagerpropertytransporttype?language=objc)
pub const kAudioTransportManagerPropertyTransportType: AudioObjectPropertySelector = 0x7472616e;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioboxclassid?language=objc)
pub const kAudioBoxClassID: AudioClassID = 0x61626f78;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioboxpropertyboxuid?language=objc)
pub const kAudioBoxPropertyBoxUID: AudioObjectPropertySelector = 0x62756964;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioboxpropertytransporttype?language=objc)
pub const kAudioBoxPropertyTransportType: AudioObjectPropertySelector = 0x7472616e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioboxpropertyhasaudio?language=objc)
pub const kAudioBoxPropertyHasAudio: AudioObjectPropertySelector = 0x62686175;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioboxpropertyhasvideo?language=objc)
pub const kAudioBoxPropertyHasVideo: AudioObjectPropertySelector = 0x62687669;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioboxpropertyhasmidi?language=objc)
pub const kAudioBoxPropertyHasMIDI: AudioObjectPropertySelector = 0x62686d69;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioboxpropertyisprotected?language=objc)
pub const kAudioBoxPropertyIsProtected: AudioObjectPropertySelector = 0x6270726f;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioboxpropertyacquired?language=objc)
pub const kAudioBoxPropertyAcquired: AudioObjectPropertySelector = 0x62786f6e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioboxpropertyacquisitionfailed?language=objc)
pub const kAudioBoxPropertyAcquisitionFailed: AudioObjectPropertySelector = 0x62786f66;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioboxpropertydevicelist?language=objc)
pub const kAudioBoxPropertyDeviceList: AudioObjectPropertySelector = 0x62647623;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioboxpropertyclockdevicelist?language=objc)
pub const kAudioBoxPropertyClockDeviceList: AudioObjectPropertySelector = 0x62636c23;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodeviceclassid?language=objc)
pub const kAudioDeviceClassID: AudioClassID = 0x61646576;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicetransporttypeunknown?language=objc)
pub const kAudioDeviceTransportTypeUnknown: u32 = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicetransporttypebuiltin?language=objc)
pub const kAudioDeviceTransportTypeBuiltIn: u32 = 0x626c746e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicetransporttypeaggregate?language=objc)
pub const kAudioDeviceTransportTypeAggregate: u32 = 0x67727570;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicetransporttypevirtual?language=objc)
pub const kAudioDeviceTransportTypeVirtual: u32 = 0x76697274;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicetransporttypepci?language=objc)
pub const kAudioDeviceTransportTypePCI: u32 = 0x70636920;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicetransporttypeusb?language=objc)
pub const kAudioDeviceTransportTypeUSB: u32 = 0x75736220;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicetransporttypefirewire?language=objc)
pub const kAudioDeviceTransportTypeFireWire: u32 = 0x31333934;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicetransporttypebluetooth?language=objc)
pub const kAudioDeviceTransportTypeBluetooth: u32 = 0x626c7565;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicetransporttypebluetoothle?language=objc)
pub const kAudioDeviceTransportTypeBluetoothLE: u32 = 0x626c6561;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicetransporttypehdmi?language=objc)
pub const kAudioDeviceTransportTypeHDMI: u32 = 0x68646d69;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicetransporttypedisplayport?language=objc)
pub const kAudioDeviceTransportTypeDisplayPort: u32 = 0x64707274;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicetransporttypeairplay?language=objc)
pub const kAudioDeviceTransportTypeAirPlay: u32 = 0x61697270;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicetransporttypeavb?language=objc)
pub const kAudioDeviceTransportTypeAVB: u32 = 0x65617662;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicetransporttypethunderbolt?language=objc)
pub const kAudioDeviceTransportTypeThunderbolt: u32 = 0x7468756e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicetransporttypecontinuitycapturewired?language=objc)
pub const kAudioDeviceTransportTypeContinuityCaptureWired: u32 = 0x63637764;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicetransporttypecontinuitycapturewireless?language=objc)
pub const kAudioDeviceTransportTypeContinuityCaptureWireless: u32 = 0x6363776c;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicetransporttypecontinuitycapture?language=objc)
#[deprecated = "Please use kAudioDeviceTransportTypeContinuityCaptureWired and kAudioDeviceTransportTypeContinuityCaptureWireless to describe Continuity Capture devices."]
pub const kAudioDeviceTransportTypeContinuityCapture: u32 = 0x63636170;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyconfigurationapplication?language=objc)
pub const kAudioDevicePropertyConfigurationApplication: AudioObjectPropertySelector = 0x63617070;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertydeviceuid?language=objc)
pub const kAudioDevicePropertyDeviceUID: AudioObjectPropertySelector = 0x75696420;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertymodeluid?language=objc)
pub const kAudioDevicePropertyModelUID: AudioObjectPropertySelector = 0x6d756964;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertytransporttype?language=objc)
pub const kAudioDevicePropertyTransportType: AudioObjectPropertySelector = 0x7472616e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyrelateddevices?language=objc)
pub const kAudioDevicePropertyRelatedDevices: AudioObjectPropertySelector = 0x616b696e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyclockdomain?language=objc)
pub const kAudioDevicePropertyClockDomain: AudioObjectPropertySelector = 0x636c6b64;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertydeviceisalive?language=objc)
pub const kAudioDevicePropertyDeviceIsAlive: AudioObjectPropertySelector = 0x6c69766e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertydeviceisrunning?language=objc)
pub const kAudioDevicePropertyDeviceIsRunning: AudioObjectPropertySelector = 0x676f696e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertydevicecanbedefaultdevice?language=objc)
pub const kAudioDevicePropertyDeviceCanBeDefaultDevice: AudioObjectPropertySelector = 0x64666c74;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertydevicecanbedefaultsystemdevice?language=objc)
pub const kAudioDevicePropertyDeviceCanBeDefaultSystemDevice: AudioObjectPropertySelector =
    0x73666c74;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertylatency?language=objc)
pub const kAudioDevicePropertyLatency: AudioObjectPropertySelector = 0x6c746e63;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertystreams?language=objc)
pub const kAudioDevicePropertyStreams: AudioObjectPropertySelector = 0x73746d23;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertycontrollist?language=objc)
pub const kAudioObjectPropertyControlList: AudioObjectPropertySelector = 0x6374726c;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertysafetyoffset?language=objc)
pub const kAudioDevicePropertySafetyOffset: AudioObjectPropertySelector = 0x73616674;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertynominalsamplerate?language=objc)
pub const kAudioDevicePropertyNominalSampleRate: AudioObjectPropertySelector = 0x6e737274;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyavailablenominalsamplerates?language=objc)
pub const kAudioDevicePropertyAvailableNominalSampleRates: AudioObjectPropertySelector = 0x6e737223;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyicon?language=objc)
pub const kAudioDevicePropertyIcon: AudioObjectPropertySelector = 0x69636f6e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyishidden?language=objc)
pub const kAudioDevicePropertyIsHidden: AudioObjectPropertySelector = 0x6869646e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertypreferredchannelsforstereo?language=objc)
pub const kAudioDevicePropertyPreferredChannelsForStereo: AudioObjectPropertySelector = 0x64636832;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertypreferredchannellayout?language=objc)
pub const kAudioDevicePropertyPreferredChannelLayout: AudioObjectPropertySelector = 0x73726e64;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioclockdeviceclassid?language=objc)
pub const kAudioClockDeviceClassID: AudioObjectPropertySelector = 0x61636c6b;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioclockdevicepropertydeviceuid?language=objc)
pub const kAudioClockDevicePropertyDeviceUID: AudioObjectPropertySelector = 0x63756964;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioclockdevicepropertytransporttype?language=objc)
pub const kAudioClockDevicePropertyTransportType: AudioObjectPropertySelector = 0x7472616e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioclockdevicepropertyclockdomain?language=objc)
pub const kAudioClockDevicePropertyClockDomain: AudioObjectPropertySelector = 0x636c6b64;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioclockdevicepropertydeviceisalive?language=objc)
pub const kAudioClockDevicePropertyDeviceIsAlive: AudioObjectPropertySelector = 0x6c69766e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioclockdevicepropertydeviceisrunning?language=objc)
pub const kAudioClockDevicePropertyDeviceIsRunning: AudioObjectPropertySelector = 0x676f696e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioclockdevicepropertylatency?language=objc)
pub const kAudioClockDevicePropertyLatency: AudioObjectPropertySelector = 0x6c746e63;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioclockdevicepropertycontrollist?language=objc)
pub const kAudioClockDevicePropertyControlList: AudioObjectPropertySelector = 0x6374726c;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioclockdevicepropertynominalsamplerate?language=objc)
pub const kAudioClockDevicePropertyNominalSampleRate: AudioObjectPropertySelector = 0x6e737274;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioclockdevicepropertyavailablenominalsamplerates?language=objc)
pub const kAudioClockDevicePropertyAvailableNominalSampleRates: AudioObjectPropertySelector =
    0x6e737223;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioendpointdeviceclassid?language=objc)
pub const kAudioEndPointDeviceClassID: AudioClassID = 0x65646576;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioendpointdevicepropertycomposition?language=objc)
pub const kAudioEndPointDevicePropertyComposition: AudioObjectPropertySelector = 0x61636f6d;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioendpointdevicepropertyendpointlist?language=objc)
pub const kAudioEndPointDevicePropertyEndPointList: AudioObjectPropertySelector = 0x61677270;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioendpointdevicepropertyisprivate?language=objc)
pub const kAudioEndPointDevicePropertyIsPrivate: AudioObjectPropertySelector = 0x70726976;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioendpointclassid?language=objc)
pub const kAudioEndPointClassID: AudioClassID = 0x656e6470;

/// This structure allows a specific sample rate range to be associated with an
/// AudioStreamBasicDescription that specifies its sample rate as
/// kAudioStreamAnyRate.
///
/// Note that this structure is only used to describe the the available formats
/// for a stream. It is not used for the current format.
/// Field: mFormat
/// The AudioStreamBasicDescription that describes the format of the stream.
/// Note that the mSampleRate field of the structure will be the same as the
/// the values in mSampleRateRange when only a single sample rate is supported.
/// It will be kAudioStreamAnyRate when there is a range with more elements.
/// Field: mSampleRateRange
/// The AudioValueRange that describes the minimum and maximum sample rate for
/// the stream. If the mSampleRate field of mFormat is kAudioStreamAnyRate the
/// format supports the range of sample rates described by this structure.
/// Otherwise, the minimum will be the same as the maximum which will be the
/// same as the mSampleRate field of mFormat.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audiostreamrangeddescription?language=objc)
#[cfg(feature = "objc2-core-audio-types")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioStreamRangedDescription {
    pub mFormat: AudioStreamBasicDescription,
    pub mSampleRateRange: AudioValueRange,
}

#[cfg(all(feature = "objc2", feature = "objc2-core-audio-types"))]
unsafe impl Encode for AudioStreamRangedDescription {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioStreamRangedDescription",
        &[
            <AudioStreamBasicDescription>::ENCODING,
            <AudioValueRange>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "objc2", feature = "objc2-core-audio-types"))]
unsafe impl RefEncode for AudioStreamRangedDescription {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreamclassid?language=objc)
pub const kAudioStreamClassID: AudioClassID = 0x61737472;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreamterminaltypeunknown?language=objc)
pub const kAudioStreamTerminalTypeUnknown: u32 = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreamterminaltypeline?language=objc)
pub const kAudioStreamTerminalTypeLine: u32 = 0x6c696e65;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreamterminaltypedigitalaudiointerface?language=objc)
pub const kAudioStreamTerminalTypeDigitalAudioInterface: u32 = 0x73706466;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreamterminaltypespeaker?language=objc)
pub const kAudioStreamTerminalTypeSpeaker: u32 = 0x73706b72;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreamterminaltypeheadphones?language=objc)
pub const kAudioStreamTerminalTypeHeadphones: u32 = 0x68647068;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreamterminaltypelfespeaker?language=objc)
pub const kAudioStreamTerminalTypeLFESpeaker: u32 = 0x6c666573;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreamterminaltypereceiverspeaker?language=objc)
pub const kAudioStreamTerminalTypeReceiverSpeaker: u32 = 0x7273706b;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreamterminaltypemicrophone?language=objc)
pub const kAudioStreamTerminalTypeMicrophone: u32 = 0x6d696372;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreamterminaltypeheadsetmicrophone?language=objc)
pub const kAudioStreamTerminalTypeHeadsetMicrophone: u32 = 0x686d6963;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreamterminaltypereceivermicrophone?language=objc)
pub const kAudioStreamTerminalTypeReceiverMicrophone: u32 = 0x726d6963;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreamterminaltypetty?language=objc)
pub const kAudioStreamTerminalTypeTTY: u32 = 0x7474795f;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreamterminaltypehdmi?language=objc)
pub const kAudioStreamTerminalTypeHDMI: u32 = 0x68646d69;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreamterminaltypedisplayport?language=objc)
pub const kAudioStreamTerminalTypeDisplayPort: u32 = 0x64707274;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreampropertyisactive?language=objc)
pub const kAudioStreamPropertyIsActive: AudioObjectPropertySelector = 0x73616374;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreampropertydirection?language=objc)
pub const kAudioStreamPropertyDirection: AudioObjectPropertySelector = 0x73646972;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreampropertyterminaltype?language=objc)
pub const kAudioStreamPropertyTerminalType: AudioObjectPropertySelector = 0x7465726d;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreampropertystartingchannel?language=objc)
pub const kAudioStreamPropertyStartingChannel: AudioObjectPropertySelector = 0x7363686e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreampropertylatency?language=objc)
pub const kAudioStreamPropertyLatency: AudioObjectPropertySelector = kAudioDevicePropertyLatency;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreampropertyvirtualformat?language=objc)
pub const kAudioStreamPropertyVirtualFormat: AudioObjectPropertySelector = 0x73666d74;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreampropertyavailablevirtualformats?language=objc)
pub const kAudioStreamPropertyAvailableVirtualFormats: AudioObjectPropertySelector = 0x73666d61;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreampropertyphysicalformat?language=objc)
pub const kAudioStreamPropertyPhysicalFormat: AudioObjectPropertySelector = 0x70667420;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostreampropertyavailablephysicalformats?language=objc)
pub const kAudioStreamPropertyAvailablePhysicalFormats: AudioObjectPropertySelector = 0x70667461;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiocontrolclassid?language=objc)
pub const kAudioControlClassID: AudioClassID = 0x6163746c;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiocontrolpropertyscope?language=objc)
pub const kAudioControlPropertyScope: AudioObjectPropertySelector = 0x63736370;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiocontrolpropertyelement?language=objc)
pub const kAudioControlPropertyElement: AudioObjectPropertySelector = 0x63656c6d;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioslidercontrolclassid?language=objc)
pub const kAudioSliderControlClassID: AudioClassID = 0x736c6472;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioslidercontrolpropertyvalue?language=objc)
pub const kAudioSliderControlPropertyValue: AudioObjectPropertySelector = 0x73647276;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioslidercontrolpropertyrange?language=objc)
pub const kAudioSliderControlPropertyRange: AudioObjectPropertySelector = 0x73647272;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiolevelcontrolclassid?language=objc)
pub const kAudioLevelControlClassID: AudioClassID = 0x6c65766c;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiovolumecontrolclassid?language=objc)
pub const kAudioVolumeControlClassID: AudioClassID = 0x766c6d65;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiolfevolumecontrolclassid?language=objc)
pub const kAudioLFEVolumeControlClassID: AudioClassID = 0x73756276;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiolevelcontrolpropertyscalarvalue?language=objc)
pub const kAudioLevelControlPropertyScalarValue: AudioObjectPropertySelector = 0x6c637376;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiolevelcontrolpropertydecibelvalue?language=objc)
pub const kAudioLevelControlPropertyDecibelValue: AudioObjectPropertySelector = 0x6c636476;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiolevelcontrolpropertydecibelrange?language=objc)
pub const kAudioLevelControlPropertyDecibelRange: AudioObjectPropertySelector = 0x6c636472;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiolevelcontrolpropertyconvertscalartodecibels?language=objc)
pub const kAudioLevelControlPropertyConvertScalarToDecibels: AudioObjectPropertySelector =
    0x6c637364;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiolevelcontrolpropertyconvertdecibelstoscalar?language=objc)
pub const kAudioLevelControlPropertyConvertDecibelsToScalar: AudioObjectPropertySelector =
    0x6c636473;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiobooleancontrolclassid?language=objc)
pub const kAudioBooleanControlClassID: AudioClassID = 0x746f676c;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiomutecontrolclassid?language=objc)
pub const kAudioMuteControlClassID: AudioClassID = 0x6d757465;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosolocontrolclassid?language=objc)
pub const kAudioSoloControlClassID: AudioClassID = 0x736f6c6f;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiojackcontrolclassid?language=objc)
pub const kAudioJackControlClassID: AudioClassID = 0x6a61636b;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiolfemutecontrolclassid?language=objc)
pub const kAudioLFEMuteControlClassID: AudioClassID = 0x7375626d;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiophantompowercontrolclassid?language=objc)
pub const kAudioPhantomPowerControlClassID: AudioClassID = 0x7068616e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiophaseinvertcontrolclassid?language=objc)
pub const kAudioPhaseInvertControlClassID: AudioClassID = 0x70687369;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiocliplightcontrolclassid?language=objc)
pub const kAudioClipLightControlClassID: AudioClassID = 0x636c6970;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiotalkbackcontrolclassid?language=objc)
pub const kAudioTalkbackControlClassID: AudioClassID = 0x74616c62;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiolistenbackcontrolclassid?language=objc)
pub const kAudioListenbackControlClassID: AudioClassID = 0x6c736e62;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiobooleancontrolpropertyvalue?language=objc)
pub const kAudioBooleanControlPropertyValue: AudioObjectPropertySelector = 0x6263766c;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioselectorcontrolclassid?language=objc)
pub const kAudioSelectorControlClassID: AudioClassID = 0x736c6374;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodatasourcecontrolclassid?language=objc)
pub const kAudioDataSourceControlClassID: AudioClassID = 0x64737263;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodatadestinationcontrolclassid?language=objc)
pub const kAudioDataDestinationControlClassID: AudioClassID = 0x64657374;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioclocksourcecontrolclassid?language=objc)
pub const kAudioClockSourceControlClassID: AudioClassID = 0x636c636b;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiolinelevelcontrolclassid?language=objc)
pub const kAudioLineLevelControlClassID: AudioClassID = 0x6e6c766c;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohighpassfiltercontrolclassid?language=objc)
pub const kAudioHighPassFilterControlClassID: AudioClassID = 0x68697066;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioselectorcontrolpropertycurrentitem?language=objc)
pub const kAudioSelectorControlPropertyCurrentItem: AudioObjectPropertySelector = 0x73636369;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioselectorcontrolpropertyavailableitems?language=objc)
pub const kAudioSelectorControlPropertyAvailableItems: AudioObjectPropertySelector = 0x73636169;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioselectorcontrolpropertyitemname?language=objc)
pub const kAudioSelectorControlPropertyItemName: AudioObjectPropertySelector = 0x7363696e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioselectorcontrolpropertyitemkind?language=objc)
pub const kAudioSelectorControlPropertyItemKind: AudioObjectPropertySelector = 0x636c6b6b;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioselectorcontrolitemkindspacer?language=objc)
pub const kAudioSelectorControlItemKindSpacer: u32 = 0x73706372;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioclocksourceitemkindinternal?language=objc)
pub const kAudioClockSourceItemKindInternal: u32 = 0x696e7420;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostereopancontrolclassid?language=objc)
pub const kAudioStereoPanControlClassID: AudioClassID = 0x7370616e;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostereopancontrolpropertyvalue?language=objc)
pub const kAudioStereoPanControlPropertyValue: AudioObjectPropertySelector = 0x73706376;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiostereopancontrolpropertypanningchannels?language=objc)
pub const kAudioStereoPanControlPropertyPanningChannels: AudioObjectPropertySelector = 0x73706363;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectsystemobject?language=objc)
pub const kAudioObjectSystemObject: c_int = 1;

/// Clients register an AudioObjectPropertyListenerProc with an AudioObject in order
/// to receive notifications when the properties of the object change.
///
/// Listeners will be called when possibly many properties have changed.
/// Consequently, the implementation of a listener must go through the array of
/// addresses to see what exactly has changed. Note that the array of addresses will
/// always have at least one address in it for which the listener is signed up to
/// receive notifications about but may contain addresses for properties for which
/// the listener is not signed up to receive notifications.
///
/// Parameter `inObjectID`: The AudioObject whose properties have changed.
///
/// Parameter `inNumberAddresses`: The number of elements in the inAddresses array.
///
/// Parameter `inAddresses`: An array of AudioObjectPropertyAddresses indicating which properties
/// changed.
///
/// Parameter `inClientData`: A pointer to client data established when the listener proc was registered
/// with the AudioObject.
///
/// Returns: The return value is currently unused and should always be 0.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audioobjectpropertylistenerproc?language=objc)
pub type AudioObjectPropertyListenerProc = Option<
    unsafe extern "C-unwind" fn(
        AudioObjectID,
        u32,
        NonNull<AudioObjectPropertyAddress>,
        *mut c_void,
    ) -> OSStatus,
>;

/// Clients register an AudioObjectPropertyListenerBlock with an AudioObject in
/// order to receive notifications when the properties of the object change.
///
/// Listeners will be called when possibly many properties have changed.
/// Consequently, the implementation of a listener must go through the array of
/// addresses to see what exactly has changed. Note that the array of addresses will
/// always have at least one address in it for which the listener is signed up to
/// receive notifications about but may contain addresses for properties for which
/// the listener is not signed up to receive notifications.
///
/// Parameter `inNumberAddresses`: The number of elements in the inAddresses array.
///
/// Parameter `inAddresses`: An array of AudioObjectPropertyAddresses indicating which properties
/// changed.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audioobjectpropertylistenerblock?language=objc)
#[cfg(feature = "block2")]
pub type AudioObjectPropertyListenerBlock =
    *mut block2::DynBlock<dyn Fn(u32, NonNull<AudioObjectPropertyAddress>)>;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertycreator?language=objc)
pub const kAudioObjectPropertyCreator: AudioObjectPropertySelector = 0x6f706c67;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertylisteneradded?language=objc)
pub const kAudioObjectPropertyListenerAdded: AudioObjectPropertySelector = 0x6c697361;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioobjectpropertylistenerremoved?language=objc)
pub const kAudioObjectPropertyListenerRemoved: AudioObjectPropertySelector = 0x6c697372;

extern "C-unwind" {
    /// Prints to standard out a textural description of the AudioObject.
    ///
    /// Parameter `inObjectID`: The AudioObject to show.
    pub fn AudioObjectShow(in_object_id: AudioObjectID);
}

/// Queries an AudioObject about whether or not it has the given property.
///
/// Parameter `inObjectID`: The AudioObject to query.
///
/// Parameter `inAddress`: An AudioObjectPropertyAddress indicating which property is being queried.
///
/// Returns: A Boolean indicating whether or not the AudioObject has the given property.
///
/// # Safety
///
/// `in_address` must be a valid pointer.
#[inline]
pub unsafe extern "C-unwind" fn AudioObjectHasProperty(
    in_object_id: AudioObjectID,
    in_address: NonNull<AudioObjectPropertyAddress>,
) -> bool {
    extern "C-unwind" {
        fn AudioObjectHasProperty(
            in_object_id: AudioObjectID,
            in_address: NonNull<AudioObjectPropertyAddress>,
        ) -> Boolean;
    }
    let ret = unsafe { AudioObjectHasProperty(in_object_id, in_address) };
    ret != 0
}

extern "C-unwind" {
    /// Queries an AudioObject about whether or not the given property can be set using
    /// AudioObjectSetPropertyData.
    ///
    /// Parameter `inObjectID`: The AudioObject to query.
    ///
    /// Parameter `inAddress`: An AudioObjectPropertyAddress indicating which property is being queried.
    ///
    /// Parameter `outIsSettable`: A Boolean indicating whether or not the property can be set.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// - `in_address` must be a valid pointer.
    /// - `out_is_settable` must be a valid pointer.
    pub fn AudioObjectIsPropertySettable(
        in_object_id: AudioObjectID,
        in_address: NonNull<AudioObjectPropertyAddress>,
        out_is_settable: NonNull<Boolean>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Queries an AudioObject to find the size of the data for the given property.
    ///
    /// Parameter `inObjectID`: The AudioObject to query.
    ///
    /// Parameter `inAddress`: An AudioObjectPropertyAddress indicating which property is being queried.
    ///
    /// Parameter `inQualifierDataSize`: A UInt32 indicating the size of the buffer pointed to by inQualifierData.
    /// Note that not all properties require qualification, in which case this
    /// value will be 0.
    ///
    /// Parameter `inQualifierData`: A buffer of data to be used in determining the data of the property being
    /// queried. Note that not all properties require qualification, in which case
    /// this value will be NULL.
    ///
    /// Parameter `outDataSize`: A UInt32 indicating how many bytes the data for the given property occupies.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// - `in_address` must be a valid pointer.
    /// - `in_qualifier_data` must be a valid pointer or null.
    /// - `out_data_size` must be a valid pointer.
    pub fn AudioObjectGetPropertyDataSize(
        in_object_id: AudioObjectID,
        in_address: NonNull<AudioObjectPropertyAddress>,
        in_qualifier_data_size: u32,
        in_qualifier_data: *const c_void,
        out_data_size: NonNull<u32>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Queries an AudioObject to get the data of the given property and places it in
    /// the provided buffer.
    ///
    /// Parameter `inObjectID`: The AudioObject to query.
    ///
    /// Parameter `inAddress`: An AudioObjectPropertyAddress indicating which property is being queried.
    ///
    /// Parameter `inQualifierDataSize`: A UInt32 indicating the size of the buffer pointed to by inQualifierData.
    /// Note that not all properties require qualification, in which case this
    /// value will be 0.
    ///
    /// Parameter `inQualifierData`: A buffer of data to be used in determining the data of the property being
    /// queried. Note that not all properties require qualification, in which case
    /// this value will be NULL.
    ///
    /// Parameter `ioDataSize`: A UInt32 which on entry indicates the size of the buffer pointed to by
    /// outData and on exit indicates how much of the buffer was used.
    ///
    /// Parameter `outData`: The buffer into which the AudioObject will put the data for the given
    /// property.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// - `in_address` must be a valid pointer.
    /// - `in_qualifier_data` must be a valid pointer or null.
    /// - `io_data_size` must be a valid pointer.
    /// - `out_data` must be a valid pointer.
    pub fn AudioObjectGetPropertyData(
        in_object_id: AudioObjectID,
        in_address: NonNull<AudioObjectPropertyAddress>,
        in_qualifier_data_size: u32,
        in_qualifier_data: *const c_void,
        io_data_size: NonNull<u32>,
        out_data: NonNull<c_void>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Tells an AudioObject to change the value of the given property using the
    /// provided data.
    ///
    /// Note that the value of the property should not be considered changed until the
    /// HAL has called the listeners as many properties values are changed
    /// asynchronously.
    ///
    /// Parameter `inObjectID`: The AudioObject to change.
    ///
    /// Parameter `inAddress`: An AudioObjectPropertyAddress indicating which property is being changed.
    ///
    /// Parameter `inQualifierDataSize`: A UInt32 indicating the size of the buffer pointed to by inQualifierData.
    /// Note that not all properties require qualification, in which case this
    /// value will be 0.
    ///
    /// Parameter `inQualifierData`: A buffer of data to be used in determining the data of the property being
    /// queried. Note that not all properties require qualification, in which case
    /// this value will be NULL.
    ///
    /// Parameter `inDataSize`: A UInt32 indicating the size of the buffer pointed to by inData.
    ///
    /// Parameter `inData`: The buffer containing the data to be used to change the property's value.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// - `in_address` must be a valid pointer.
    /// - `in_qualifier_data` must be a valid pointer or null.
    /// - `in_data` must be a valid pointer.
    pub fn AudioObjectSetPropertyData(
        in_object_id: AudioObjectID,
        in_address: NonNull<AudioObjectPropertyAddress>,
        in_qualifier_data_size: u32,
        in_qualifier_data: *const c_void,
        in_data_size: u32,
        in_data: NonNull<c_void>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Registers the given AudioObjectPropertyListenerProc to receive notifications
    /// when the given properties change.
    ///
    /// Parameter `inObjectID`: The AudioObject to register the listener with.
    ///
    /// Parameter `inAddress`: The AudioObjectPropertyAddresses indicating which property the listener
    /// should be notified about.
    ///
    /// Parameter `inListener`: The AudioObjectPropertyListenerProc to call.
    ///
    /// Parameter `inClientData`: A pointer to client data that is passed to the listener when it is called.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// - `in_address` must be a valid pointer.
    /// - `in_listener` must be implemented correctly.
    /// - `in_client_data` must be a valid pointer or null.
    pub fn AudioObjectAddPropertyListener(
        in_object_id: AudioObjectID,
        in_address: NonNull<AudioObjectPropertyAddress>,
        in_listener: AudioObjectPropertyListenerProc,
        in_client_data: *mut c_void,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Unregisters the given AudioObjectPropertyListenerProc from receiving
    /// notifications when the given properties change.
    ///
    /// Parameter `inObjectID`: The AudioObject to unregister the listener from.
    ///
    /// Parameter `inAddress`: The AudioObjectPropertyAddress indicating from which property the listener
    /// should be removed.
    ///
    /// Parameter `inListener`: The AudioObjectPropertyListenerProc being removed.
    ///
    /// Parameter `inClientData`: A pointer to client data that is passed to the listener when it is called.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// - `in_address` must be a valid pointer.
    /// - `in_listener` must be implemented correctly.
    /// - `in_client_data` must be a valid pointer or null.
    pub fn AudioObjectRemovePropertyListener(
        in_object_id: AudioObjectID,
        in_address: NonNull<AudioObjectPropertyAddress>,
        in_listener: AudioObjectPropertyListenerProc,
        in_client_data: *mut c_void,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Registers the given AudioObjectPropertyListenerBlock to receive notifications
    /// when the given properties change.
    ///
    /// Parameter `inObjectID`: The AudioObject to register the listener with.
    ///
    /// Parameter `inAddress`: The AudioObjectPropertyAddresses indicating which property the listener
    /// should be notified about.
    ///
    /// Parameter `inDispatchQueue`: The dispatch queue on which the listener block will be dispatched. All
    /// listener blocks will be dispatched asynchronously save for those dispatched
    /// from the IO context (of which kAudioDevicePropertyDeviceIsRunning and
    /// kAudioDeviceProcessorOverload are the only examples) which will be
    /// dispatched synchronously. Note that this dispatch queue will be retained
    /// until a matching call to AudioObjectRemovePropertyListenerBlock is made. If
    /// this value is NULL, then the block will be directly invoked.
    ///
    /// Parameter `inListener`: The AudioObjectPropertyListenerBlock to call. Note that this block will be
    /// Block_copy'd and the reference maintained until a matching call to
    /// AudioObjectRemovePropertyListenerBlock is made.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// - `in_address` must be a valid pointer.
    /// - `in_dispatch_queue` possibly has additional threading requirements.
    /// - `in_listener` must be a valid pointer.
    #[cfg(all(feature = "block2", feature = "dispatch2"))]
    pub fn AudioObjectAddPropertyListenerBlock(
        in_object_id: AudioObjectID,
        in_address: NonNull<AudioObjectPropertyAddress>,
        in_dispatch_queue: Option<&DispatchQueue>,
        in_listener: AudioObjectPropertyListenerBlock,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Unregisters the given AudioObjectPropertyListenerBlock from receiving
    /// notifications when the given properties change.
    ///
    /// Parameter `inObjectID`: The AudioObject to unregister the listener from.
    ///
    /// Parameter `inAddress`: The AudioObjectPropertyAddress indicating from which property the listener
    /// should be removed.
    ///
    /// Parameter `inDispatchQueue`: The dispatch queue on which the listener block was being dispatched to.
    ///
    /// Parameter `inListener`: The AudioObjectPropertyListenerBlock being removed.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// - `in_address` must be a valid pointer.
    /// - `in_dispatch_queue` possibly has additional threading requirements.
    /// - `in_listener` must be a valid pointer.
    #[cfg(all(feature = "block2", feature = "dispatch2"))]
    pub fn AudioObjectRemovePropertyListenerBlock(
        in_object_id: AudioObjectID,
        in_address: NonNull<AudioObjectPropertyAddress>,
        in_dispatch_queue: Option<&DispatchQueue>,
        in_listener: AudioObjectPropertyListenerBlock,
    ) -> OSStatus;
}

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosystemobjectclassid?language=objc)
pub const kAudioSystemObjectClassID: AudioClassID = 0x61737973;

/// The values for kAudioHardwarePropertyPowerHint
///
/// The system object property, kAudioHardwarePropertyPowerHint, allows a process to
/// to indicate how aggressive the system can be with optimizations that save power.
/// Note that the value of this property can be set in an application's info.plist
/// using the key, "AudioHardwarePowerHint". The values for this key are the strings
/// that correspond to the values in the enum.
///
/// This is the default value and it indicates that the system will not make any
/// power optimizations that compromise latency or quality in order to save
/// power. The info.plist value is "None" or the "AudioHardwarePowerHint" entry
/// can be omitted entirely.
///
/// The system will choose to save power even at the expense of latency. The
/// info.plist value is "Favor Saving Power"
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audiohardwarepowerhint?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioHardwarePowerHint(pub u32);
impl AudioHardwarePowerHint {
    #[doc(alias = "kAudioHardwarePowerHintNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "kAudioHardwarePowerHintFavorSavingPower")]
    pub const FavorSavingPower: Self = Self(1);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for AudioHardwarePowerHint {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for AudioHardwarePowerHint {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertydevices?language=objc)
pub const kAudioHardwarePropertyDevices: AudioObjectPropertySelector = 0x64657623;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertydefaultinputdevice?language=objc)
pub const kAudioHardwarePropertyDefaultInputDevice: AudioObjectPropertySelector = 0x64496e20;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertydefaultoutputdevice?language=objc)
pub const kAudioHardwarePropertyDefaultOutputDevice: AudioObjectPropertySelector = 0x644f7574;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertydefaultsystemoutputdevice?language=objc)
pub const kAudioHardwarePropertyDefaultSystemOutputDevice: AudioObjectPropertySelector = 0x734f7574;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertytranslateuidtodevice?language=objc)
pub const kAudioHardwarePropertyTranslateUIDToDevice: AudioObjectPropertySelector = 0x75696464;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertymixstereotomono?language=objc)
pub const kAudioHardwarePropertyMixStereoToMono: AudioObjectPropertySelector = 0x73746d6f;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertypluginlist?language=objc)
pub const kAudioHardwarePropertyPlugInList: AudioObjectPropertySelector = 0x706c6723;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertytranslatebundleidtoplugin?language=objc)
pub const kAudioHardwarePropertyTranslateBundleIDToPlugIn: AudioObjectPropertySelector = 0x62696470;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertytransportmanagerlist?language=objc)
pub const kAudioHardwarePropertyTransportManagerList: AudioObjectPropertySelector = 0x746d6723;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertytranslatebundleidtotransportmanager?language=objc)
pub const kAudioHardwarePropertyTranslateBundleIDToTransportManager: AudioObjectPropertySelector =
    0x746d6269;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertyboxlist?language=objc)
pub const kAudioHardwarePropertyBoxList: AudioObjectPropertySelector = 0x626f7823;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertytranslateuidtobox?language=objc)
pub const kAudioHardwarePropertyTranslateUIDToBox: AudioObjectPropertySelector = 0x75696462;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertyclockdevicelist?language=objc)
pub const kAudioHardwarePropertyClockDeviceList: AudioObjectPropertySelector = 0x636c6b23;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertytranslateuidtoclockdevice?language=objc)
pub const kAudioHardwarePropertyTranslateUIDToClockDevice: AudioObjectPropertySelector = 0x75696463;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertyprocessismain?language=objc)
pub const kAudioHardwarePropertyProcessIsMain: AudioObjectPropertySelector = 0x6d61696e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertyisinitingorexiting?language=objc)
pub const kAudioHardwarePropertyIsInitingOrExiting: AudioObjectPropertySelector = 0x696e6f74;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertyuseridchanged?language=objc)
pub const kAudioHardwarePropertyUserIDChanged: AudioObjectPropertySelector = 0x65756964;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertyprocessinputmute?language=objc)
pub const kAudioHardwarePropertyProcessInputMute: AudioObjectPropertySelector = 0x706d696e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertyprocessisaudible?language=objc)
pub const kAudioHardwarePropertyProcessIsAudible: AudioObjectPropertySelector = 0x706d7574;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertysleepingisallowed?language=objc)
pub const kAudioHardwarePropertySleepingIsAllowed: AudioObjectPropertySelector = 0x736c6570;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertyunloadingisallowed?language=objc)
pub const kAudioHardwarePropertyUnloadingIsAllowed: AudioObjectPropertySelector = 0x756e6c64;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertyhogmodeisallowed?language=objc)
pub const kAudioHardwarePropertyHogModeIsAllowed: AudioObjectPropertySelector = 0x686f6772;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertyusersessionisactiveorheadless?language=objc)
pub const kAudioHardwarePropertyUserSessionIsActiveOrHeadless: AudioObjectPropertySelector =
    0x75736572;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertyservicerestarted?language=objc)
pub const kAudioHardwarePropertyServiceRestarted: AudioObjectPropertySelector = 0x73727374;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertypowerhint?language=objc)
pub const kAudioHardwarePropertyPowerHint: AudioObjectPropertySelector = 0x706f7768;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertyprocessobjectlist?language=objc)
pub const kAudioHardwarePropertyProcessObjectList: AudioObjectPropertySelector = 0x70727323;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertytranslatepidtoprocessobject?language=objc)
pub const kAudioHardwarePropertyTranslatePIDToProcessObject: AudioObjectPropertySelector =
    0x69643270;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertytaplist?language=objc)
pub const kAudioHardwarePropertyTapList: AudioObjectPropertySelector = 0x74707323;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiohardwarepropertytranslateuidtotap?language=objc)
pub const kAudioHardwarePropertyTranslateUIDToTap: AudioObjectPropertySelector = 0x75696474;

extern "C-unwind" {
    /// When this routine is called, all IO on all devices within a process will be
    /// terminated and all resources capable of being released will be released. This
    /// routine essentially returns the HAL to its uninitialized state.
    ///
    /// Returns: An OSStatus indicating success or failure.
    pub fn AudioHardwareUnload() -> OSStatus;
}

extern "C-unwind" {
    /// This routine creates a new AudioAggregateDevice using the provided description.
    ///
    /// Parameter `inDescription`: The CFDictionary that specifies how to build the AudioAggregateDevice. The
    /// supported keys are described in the AudioAggregateDevice Constants section.
    ///
    /// Parameter `outDeviceID`: The AudioObjectID of the newly created AudioAggregateDevice.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// - `in_description` generics must be of the correct type.
    /// - `out_device_id` must be a valid pointer.
    pub fn AudioHardwareCreateAggregateDevice(
        in_description: &CFDictionary,
        out_device_id: NonNull<AudioObjectID>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// This routine destroys the given AudioAggregateDevice.
    ///
    /// The actual destruction of the device is asynchronous and may take place after
    /// the call to this routine has returned.
    ///
    /// Parameter `inDeviceID`: The AudioObjectID of the AudioAggregateDevice to destroy.
    ///
    /// Returns: An OSStatus indicating success or failure.
    pub fn AudioHardwareDestroyAggregateDevice(in_device_id: AudioObjectID) -> OSStatus;
}

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioplugincreateaggregatedevice?language=objc)
pub const kAudioPlugInCreateAggregateDevice: AudioObjectPropertySelector = 0x63616767;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioplugindestroyaggregatedevice?language=objc)
pub const kAudioPlugInDestroyAggregateDevice: AudioObjectPropertySelector = 0x64616767;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiotransportmanagercreateendpointdevice?language=objc)
pub const kAudioTransportManagerCreateEndPointDevice: AudioObjectPropertySelector = 0x63646576;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiotransportmanagerdestroyendpointdevice?language=objc)
pub const kAudioTransportManagerDestroyEndPointDevice: AudioObjectPropertySelector = 0x64646576;

/// An AudioDeviceIOProc is called by an AudioDevice to provide input data read from
/// the device and collect output data to be written to the device for the current
/// IO cycle.
///
/// Parameter `inDevice`: The AudioDevice doing the IO.
///
/// Parameter `inNow`: An AudioTimeStamp that indicates the IO cycle started. Note that this time
/// includes any scheduling latency that may have been incurred waking the
/// thread on which IO is being done.
///
/// Parameter `inInputData`: An AudioBufferList containing the input data for the current IO cycle. For
/// streams that are disabled, the AudioBuffer's mData field will be NULL but
/// the mDataByteSize field will still say how much data would have been there
/// if it was enabled. Note that the contents of this structure should never be
/// modified.
///
/// Parameter `inInputTime`: An AudioTimeStamp that indicates the time at which the first frame in the
/// data was acquired from the hardware. If the device has no input streams, the
/// time stamp will be zeroed out.
///
/// Parameter `outOutputData`: An AudioBufferList in which the output data for the current IO cycle is to
/// be placed. On entry, each AudioBuffer's mDataByteSize field indicates the
/// maximum amount of data that can be placed in the buffer and the buffer's
/// memory has been zeroed out. For formats where the number of bytes per packet
/// can vary (as with AC-3, for example), the client has to fill out on exit
/// each mDataByteSize field in each AudioBuffer with the amount of data that
/// was put in the buffer. Otherwise, the mDataByteSize field should not be
/// changed. For streams that are disabled, the AudioBuffer's mData field will
/// be NULL but the mDataByteSize field will still say how much data would have
/// been there if it was enabled. Except as noted above, the contents of this
/// structure should not other wise be modified.
///
/// Parameter `inOutputTime`: An AudioTimeStamp that indicates the time at which the first frame in the
/// data will be passed to the hardware. If the device has no output streams,
/// the time stamp will be zeroed out.
///
/// Parameter `inClientData`: A pointer to client data established when the AudioDeviceIOProc was
/// registered with the AudioDevice.
///
/// Returns: The return value is currently unused and should always be 0.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audiodeviceioproc?language=objc)
#[cfg(feature = "objc2-core-audio-types")]
pub type AudioDeviceIOProc = Option<
    unsafe extern "C-unwind" fn(
        AudioObjectID,
        NonNull<AudioTimeStamp>,
        NonNull<AudioBufferList>,
        NonNull<AudioTimeStamp>,
        NonNull<AudioBufferList>,
        NonNull<AudioTimeStamp>,
        *mut c_void,
    ) -> OSStatus,
>;

/// An AudioDeviceIOBlock is called by an AudioDevice to provide input data read
/// from the device and collect output data to be written to the device for the
/// current IO cycle.
///
/// Parameter `inNow`: An AudioTimeStamp that indicates the IO cycle started. Note that this time
/// includes any scheduling latency that may have been incurred waking the
/// thread on which IO is being done.
///
/// Parameter `inInputData`: An AudioBufferList containing the input data for the current IO cycle. For
/// streams that are disabled, the AudioBuffer's mData field will be NULL but
/// the mDataByteSize field will still say how much data would have been there
/// if it was enabled. Note that the contents of this structure should never be
/// modified.
///
/// Parameter `inInputTime`: An AudioTimeStamp that indicates the time at which the first frame in the
/// data was acquired from the hardware. If the device has no input streams, the
/// time stamp will be zeroed out.
///
/// Parameter `outOutputData`: An AudioBufferList in which the output data for the current IO cycle is to
/// be placed. On entry, each AudioBuffer's mDataByteSize field indicates the
/// maximum amount of data that can be placed in the buffer and the buffer's
/// memory has been zeroed out. For formats where the number of bytes per packet
/// can vary (as with AC-3, for example), the client has to fill out on exit
/// each mDataByteSize field in each AudioBuffer with the amount of data that
/// was put in the buffer. Otherwise, the mDataByteSize field should not be
/// changed. For streams that are disabled, the AudioBuffer's mData field will
/// be NULL but the mDataByteSize field will still say how much data would have
/// been there if it was enabled. Except as noted above, the contents of this
/// structure should not other wise be modified.
///
/// Parameter `inOutputTime`: An AudioTimeStamp that indicates the time at which the first frame in the
/// data will be passed to the hardware. If the device has no output streams,
/// the time stamp will be zeroed out.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audiodeviceioblock?language=objc)
#[cfg(all(feature = "block2", feature = "objc2-core-audio-types"))]
pub type AudioDeviceIOBlock = *mut block2::DynBlock<
    dyn Fn(
        NonNull<AudioTimeStamp>,
        NonNull<AudioBufferList>,
        NonNull<AudioTimeStamp>,
        NonNull<AudioBufferList>,
        NonNull<AudioTimeStamp>,
    ),
>;

/// An AudioDeviceIOProcID represents both an IOProc and the client data that goes
/// with it. Once created, an AudioDeviceIOProcID can be used everywhere one would
/// use a regular IOProc. The purpose for an AudioDeviceIOProcID is to allow a
/// client to register the same function pointer as an IOProc with a device multiple
/// times provided
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audiodeviceioprocid?language=objc)
#[cfg(feature = "objc2-core-audio-types")]
pub type AudioDeviceIOProcID = AudioDeviceIOProc;

/// This structure describes which streams a given AudioDeviceIOProc will use. It is
/// used in conjunction with kAudioDevicePropertyIOProcStreamUsage.
/// Field: mIOProc
/// The IOProc whose stream usage is being specified.
/// Field: mNumberStreams
/// The number of streams being specified.
/// Field: mStreamIsOn
/// An array of UInt32's whose length is specified by mNumberStreams. Each
/// element of the array corresponds to a stream. A value of 0 means the stream
/// is not to be enabled. Any other value means the stream is to be used.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/audiohardwareioprocstreamusage?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioHardwareIOProcStreamUsage {
    pub mIOProc: NonNull<c_void>,
    pub mNumberStreams: u32,
    pub mStreamIsOn: [u32; 1],
}

#[cfg(feature = "objc2")]
unsafe impl Encode for AudioHardwareIOProcStreamUsage {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioHardwareIOProcStreamUsage",
        &[
            <NonNull<c_void>>::ENCODING,
            <u32>::ENCODING,
            <[u32; 1]>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for AudioHardwareIOProcStreamUsage {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicestarttimeisinputflag?language=objc)
pub const kAudioDeviceStartTimeIsInputFlag: u32 = 1 << 0;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicestarttimedontconsultdeviceflag?language=objc)
pub const kAudioDeviceStartTimeDontConsultDeviceFlag: u32 = 1 << 1;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicestarttimedontconsulthalflag?language=objc)
pub const kAudioDeviceStartTimeDontConsultHALFlag: u32 = 1 << 2;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyplugin?language=objc)
pub const kAudioDevicePropertyPlugIn: AudioObjectPropertySelector = 0x706c7567;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertydevicehaschanged?language=objc)
pub const kAudioDevicePropertyDeviceHasChanged: AudioObjectPropertySelector = 0x64696666;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertydeviceisrunningsomewhere?language=objc)
pub const kAudioDevicePropertyDeviceIsRunningSomewhere: AudioObjectPropertySelector = 0x676f6e65;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodeviceprocessoroverload?language=objc)
pub const kAudioDeviceProcessorOverload: AudioObjectPropertySelector = 0x6f766572;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyiostoppedabnormally?language=objc)
pub const kAudioDevicePropertyIOStoppedAbnormally: AudioObjectPropertySelector = 0x73747064;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyhogmode?language=objc)
pub const kAudioDevicePropertyHogMode: AudioObjectPropertySelector = 0x6f696e6b;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertybufferframesize?language=objc)
pub const kAudioDevicePropertyBufferFrameSize: AudioObjectPropertySelector = 0x6673697a;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertybufferframesizerange?language=objc)
pub const kAudioDevicePropertyBufferFrameSizeRange: AudioObjectPropertySelector = 0x66737a23;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyusesvariablebufferframesizes?language=objc)
pub const kAudioDevicePropertyUsesVariableBufferFrameSizes: AudioObjectPropertySelector =
    0x7666737a;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyiocycleusage?language=objc)
pub const kAudioDevicePropertyIOCycleUsage: AudioObjectPropertySelector = 0x6e637963;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertystreamconfiguration?language=objc)
pub const kAudioDevicePropertyStreamConfiguration: AudioObjectPropertySelector = 0x736c6179;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyioprocstreamusage?language=objc)
pub const kAudioDevicePropertyIOProcStreamUsage: AudioObjectPropertySelector = 0x73757365;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyactualsamplerate?language=objc)
pub const kAudioDevicePropertyActualSampleRate: AudioObjectPropertySelector = 0x61737274;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyclockdevice?language=objc)
pub const kAudioDevicePropertyClockDevice: AudioObjectPropertySelector = 0x61706364;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyiothreadosworkgroup?language=objc)
pub const kAudioDevicePropertyIOThreadOSWorkgroup: AudioObjectPropertySelector = 0x6f737767;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyprocessmute?language=objc)
pub const kAudioDevicePropertyProcessMute: AudioObjectPropertySelector = 0x6170706d;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyjackisconnected?language=objc)
pub const kAudioDevicePropertyJackIsConnected: AudioObjectPropertySelector = 0x6a61636b;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyvolumescalar?language=objc)
pub const kAudioDevicePropertyVolumeScalar: AudioObjectPropertySelector = 0x766f6c6d;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyvolumedecibels?language=objc)
pub const kAudioDevicePropertyVolumeDecibels: AudioObjectPropertySelector = 0x766f6c64;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyvolumerangedecibels?language=objc)
pub const kAudioDevicePropertyVolumeRangeDecibels: AudioObjectPropertySelector = 0x76646223;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyvolumescalartodecibels?language=objc)
pub const kAudioDevicePropertyVolumeScalarToDecibels: AudioObjectPropertySelector = 0x76326462;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyvolumedecibelstoscalar?language=objc)
pub const kAudioDevicePropertyVolumeDecibelsToScalar: AudioObjectPropertySelector = 0x64623276;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertystereopan?language=objc)
pub const kAudioDevicePropertyStereoPan: AudioObjectPropertySelector = 0x7370616e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertystereopanchannels?language=objc)
pub const kAudioDevicePropertyStereoPanChannels: AudioObjectPropertySelector = 0x73706e23;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertymute?language=objc)
pub const kAudioDevicePropertyMute: AudioObjectPropertySelector = 0x6d757465;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertysolo?language=objc)
pub const kAudioDevicePropertySolo: AudioObjectPropertySelector = 0x736f6c6f;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyphantompower?language=objc)
pub const kAudioDevicePropertyPhantomPower: AudioObjectPropertySelector = 0x7068616e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyphaseinvert?language=objc)
pub const kAudioDevicePropertyPhaseInvert: AudioObjectPropertySelector = 0x70687369;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertycliplight?language=objc)
pub const kAudioDevicePropertyClipLight: AudioObjectPropertySelector = 0x636c6970;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertytalkback?language=objc)
pub const kAudioDevicePropertyTalkback: AudioObjectPropertySelector = 0x74616c62;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertylistenback?language=objc)
pub const kAudioDevicePropertyListenback: AudioObjectPropertySelector = 0x6c736e62;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertydatasource?language=objc)
pub const kAudioDevicePropertyDataSource: AudioObjectPropertySelector = 0x73737263;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertydatasources?language=objc)
pub const kAudioDevicePropertyDataSources: AudioObjectPropertySelector = 0x73736323;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertydatasourcenameforidcfstring?language=objc)
pub const kAudioDevicePropertyDataSourceNameForIDCFString: AudioObjectPropertySelector = 0x6c73636e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertydatasourcekindforid?language=objc)
pub const kAudioDevicePropertyDataSourceKindForID: AudioObjectPropertySelector = 0x7373636b;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyclocksource?language=objc)
pub const kAudioDevicePropertyClockSource: AudioObjectPropertySelector = 0x63737263;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyclocksources?language=objc)
pub const kAudioDevicePropertyClockSources: AudioObjectPropertySelector = 0x63736323;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyclocksourcenameforidcfstring?language=objc)
pub const kAudioDevicePropertyClockSourceNameForIDCFString: AudioObjectPropertySelector =
    0x6c63736e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyclocksourcekindforid?language=objc)
pub const kAudioDevicePropertyClockSourceKindForID: AudioObjectPropertySelector = 0x6373636b;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyplaythru?language=objc)
pub const kAudioDevicePropertyPlayThru: AudioObjectPropertySelector = 0x74687275;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyplaythrusolo?language=objc)
pub const kAudioDevicePropertyPlayThruSolo: AudioObjectPropertySelector = 0x74687273;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyplaythruvolumescalar?language=objc)
pub const kAudioDevicePropertyPlayThruVolumeScalar: AudioObjectPropertySelector = 0x6d767363;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyplaythruvolumedecibels?language=objc)
pub const kAudioDevicePropertyPlayThruVolumeDecibels: AudioObjectPropertySelector = 0x6d766462;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyplaythruvolumerangedecibels?language=objc)
pub const kAudioDevicePropertyPlayThruVolumeRangeDecibels: AudioObjectPropertySelector = 0x6d766423;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyplaythruvolumescalartodecibels?language=objc)
pub const kAudioDevicePropertyPlayThruVolumeScalarToDecibels: AudioObjectPropertySelector =
    0x6d763264;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyplaythruvolumedecibelstoscalar?language=objc)
pub const kAudioDevicePropertyPlayThruVolumeDecibelsToScalar: AudioObjectPropertySelector =
    0x6d763273;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyplaythrustereopan?language=objc)
pub const kAudioDevicePropertyPlayThruStereoPan: AudioObjectPropertySelector = 0x6d73706e;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyplaythrustereopanchannels?language=objc)
pub const kAudioDevicePropertyPlayThruStereoPanChannels: AudioObjectPropertySelector = 0x6d737023;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyplaythrudestination?language=objc)
pub const kAudioDevicePropertyPlayThruDestination: AudioObjectPropertySelector = 0x6d646473;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyplaythrudestinations?language=objc)
pub const kAudioDevicePropertyPlayThruDestinations: AudioObjectPropertySelector = 0x6d646423;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyplaythrudestinationnameforidcfstring?language=objc)
pub const kAudioDevicePropertyPlayThruDestinationNameForIDCFString: AudioObjectPropertySelector =
    0x6d646463;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertychannelnominallinelevel?language=objc)
pub const kAudioDevicePropertyChannelNominalLineLevel: AudioObjectPropertySelector = 0x6e6c766c;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertychannelnominallinelevels?language=objc)
pub const kAudioDevicePropertyChannelNominalLineLevels: AudioObjectPropertySelector = 0x6e6c7623;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertychannelnominallinelevelnameforidcfstring?language=objc)
pub const kAudioDevicePropertyChannelNominalLineLevelNameForIDCFString:
    AudioObjectPropertySelector = 0x6c636e6c;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyhighpassfiltersetting?language=objc)
pub const kAudioDevicePropertyHighPassFilterSetting: AudioObjectPropertySelector = 0x68697066;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyhighpassfiltersettings?language=objc)
pub const kAudioDevicePropertyHighPassFilterSettings: AudioObjectPropertySelector = 0x68697023;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyhighpassfiltersettingnameforidcfstring?language=objc)
pub const kAudioDevicePropertyHighPassFilterSettingNameForIDCFString: AudioObjectPropertySelector =
    0x6869706c;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertysubvolumescalar?language=objc)
pub const kAudioDevicePropertySubVolumeScalar: AudioObjectPropertySelector = 0x73766c6d;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertysubvolumedecibels?language=objc)
pub const kAudioDevicePropertySubVolumeDecibels: AudioObjectPropertySelector = 0x73766c64;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertysubvolumerangedecibels?language=objc)
pub const kAudioDevicePropertySubVolumeRangeDecibels: AudioObjectPropertySelector = 0x73766423;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertysubvolumescalartodecibels?language=objc)
pub const kAudioDevicePropertySubVolumeScalarToDecibels: AudioObjectPropertySelector = 0x73763264;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertysubvolumedecibelstoscalar?language=objc)
pub const kAudioDevicePropertySubVolumeDecibelsToScalar: AudioObjectPropertySelector = 0x73643276;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertysubmute?language=objc)
pub const kAudioDevicePropertySubMute: AudioObjectPropertySelector = 0x736d7574;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyvoiceactivitydetectionenable?language=objc)
pub const kAudioDevicePropertyVoiceActivityDetectionEnable: AudioObjectPropertySelector =
    0x7641642b;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertyvoiceactivitydetectionstate?language=objc)
pub const kAudioDevicePropertyVoiceActivityDetectionState: AudioObjectPropertySelector = 0x76416453;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertywantscontrolsrestored?language=objc)
pub const kAudioDevicePropertyWantsControlsRestored: AudioObjectPropertySelector = 0x72657363;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiodevicepropertywantsstreamformatsrestored?language=objc)
pub const kAudioDevicePropertyWantsStreamFormatsRestored: AudioObjectPropertySelector = 0x72657366;

extern "C-unwind" {
    /// Creates an AudioDeviceIOProcID from an AudioDeviceIOProc and a client data
    /// pointer.
    ///
    /// AudioDeviceIOProcIDs allow for the client to register the same function pointer
    /// with a device multiple times
    ///
    /// Parameter `inDevice`: The AudioDevice to register the IOProc with.
    ///
    /// Parameter `inProc`: The AudioDeviceIOProc to register.
    ///
    /// Parameter `inClientData`: A pointer to client data that is passed back to the IOProc when it is
    /// called.
    ///
    /// Parameter `outIOProcID`: The newly created AudioDeviceIOProcID.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// - `in_proc` must be implemented correctly.
    /// - `in_client_data` must be a valid pointer or null.
    /// - `out_io_proc_id` must be a valid pointer.
    #[cfg(feature = "objc2-core-audio-types")]
    pub fn AudioDeviceCreateIOProcID(
        in_device: AudioObjectID,
        in_proc: AudioDeviceIOProc,
        in_client_data: *mut c_void,
        out_io_proc_id: NonNull<AudioDeviceIOProcID>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Creates an AudioDeviceIOProcID from an AudioDeviceIOBlock
    ///
    /// Parameter `outIOProcID`: The newly created AudioDeviceIOProcID.
    ///
    /// Parameter `inDevice`: The AudioDevice to register the Block with.
    ///
    /// Parameter `inDispatchQueue`: The dispatch queue on which the IOBlock will be dispatched. All
    /// IOBlocks are dispatched synchronously. Note that this dispatch queue will be
    /// retained until a matching call to AudioDeviceDestroyIOProcID is made. If
    /// this value is NULL, then the IOBlock will be directly invoked.
    ///
    /// Parameter `inIOBlock`: The AudioDeviceIOBlock to register.  Note that this block will be
    /// Block_copy'd and the reference maintained until a matching call to
    /// AudioDeviceDestroyIOProcID is made.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// - `out_io_proc_id` must be a valid pointer.
    /// - `in_dispatch_queue` possibly has additional threading requirements.
    /// - `in_io_block` must be a valid pointer.
    #[cfg(all(
        feature = "block2",
        feature = "dispatch2",
        feature = "objc2-core-audio-types"
    ))]
    pub fn AudioDeviceCreateIOProcIDWithBlock(
        out_io_proc_id: NonNull<AudioDeviceIOProcID>,
        in_device: AudioObjectID,
        in_dispatch_queue: Option<&DispatchQueue>,
        in_io_block: AudioDeviceIOBlock,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Destroys an AudioDeviceIOProcID.
    ///
    /// AudioDeviceIOProcIDs allow for the client to register the same function pointer
    /// with a device multiple times
    ///
    /// Parameter `inDevice`: The AudioDevice from which the ID came.
    ///
    /// Parameter `inIOProcID`: The AudioDeviceIOProcID to get rid of.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// `in_io_proc_id` must be implemented correctly.
    #[cfg(feature = "objc2-core-audio-types")]
    pub fn AudioDeviceDestroyIOProcID(
        in_device: AudioObjectID,
        in_io_proc_id: AudioDeviceIOProcID,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Starts IO for the given AudioDeviceIOProcID.
    ///
    /// Parameter `inDevice`: The AudioDevice to start the IOProc on.
    ///
    /// Parameter `inProcID`: The AudioDeviceIOProcID to start. Note that this can be NULL, which starts
    /// the hardware regardless of whether or not there are any IOProcs registered.
    /// This is necessary if any of the AudioDevice's timing services are to be
    /// used. A balancing call to AudioDeviceStop with a NULL IOProc is required to
    /// stop the hardware.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// `in_proc_id` must be implemented correctly.
    #[cfg(feature = "objc2-core-audio-types")]
    pub fn AudioDeviceStart(in_device: AudioObjectID, in_proc_id: AudioDeviceIOProcID) -> OSStatus;
}

extern "C-unwind" {
    /// Starts IO for the given AudioDeviceIOProcID and aligns the IO cycle of the
    /// AudioDevice with the given time.
    ///
    /// Parameter `inDevice`: The AudioDevice to start the IOProc on.
    ///
    /// Parameter `inProcID`: The AudioDeviceIOProcID to start. Note that this can be NULL, which starts
    /// the hardware regardless of whether or not there are any IOProcs registered.
    ///
    /// Parameter `ioRequestedStartTime`: A pointer to an AudioTimeStamp that, on entry, is the requested time to
    /// start the IOProc. On exit, it will be the actual time the IOProc will start.
    ///
    /// Parameter `inFlags`: A UInt32 containing flags that modify how this function behaves.
    ///
    /// Returns: An OSStatus indicating success or failure.
    /// kAudioHardwareUnsupportedOperationError will be returned if the AudioDevice does
    /// not support starting at a specific time and inProc and ioRequestedStartTime are
    /// not NULL.
    ///
    /// # Safety
    ///
    /// - `in_proc_id` must be implemented correctly.
    /// - `io_requested_start_time` must be a valid pointer.
    #[cfg(feature = "objc2-core-audio-types")]
    pub fn AudioDeviceStartAtTime(
        in_device: AudioObjectID,
        in_proc_id: AudioDeviceIOProcID,
        io_requested_start_time: NonNull<AudioTimeStamp>,
        in_flags: u32,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Stops IO for the given AudioDeviceIOProcID.
    ///
    /// Parameter `inDevice`: The AudioDevice to stop the IOProc on.
    ///
    /// Parameter `inProcID`: The AudioDeviceIOProcID to stop.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// `in_proc_id` must be implemented correctly.
    #[cfg(feature = "objc2-core-audio-types")]
    pub fn AudioDeviceStop(in_device: AudioObjectID, in_proc_id: AudioDeviceIOProcID) -> OSStatus;
}

extern "C-unwind" {
    /// Retrieves the current time from an AudioDevice. Note that the device has to be
    /// running.
    ///
    /// Parameter `inDevice`: The AudioDevice to from which to get the time.
    ///
    /// Parameter `outTime`: An AudioTimeStamp into which the current time is put. On entry, the
    /// mFlags field specifies which representations to provide. Because not every
    /// device supports all time representations, on exit, the mFlags field will
    /// indicate what values are actually valid.
    ///
    /// Returns: An OSStatus indicating success or failure. kAudioHardwareNotRunningError will be
    /// returned if the AudioDevice isn't running.
    ///
    /// # Safety
    ///
    /// `out_time` must be a valid pointer.
    #[cfg(feature = "objc2-core-audio-types")]
    pub fn AudioDeviceGetCurrentTime(
        in_device: AudioObjectID,
        out_time: NonNull<AudioTimeStamp>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Translates the time in the AudioDevice's time base from one representation to
    /// another. Note that the device has to be running
    ///
    /// Parameter `inDevice`: The AudioDevice whose time base governs the translation.
    ///
    /// Parameter `inTime`: An AudioTimeStamp containing the time to be translated.
    ///
    /// Parameter `outTime`: An AudioTimeStamp into which the translated time is put. On entry, the
    /// mFlags field specifies which representations to translate the input time
    /// into. Because not every device supports all time representations, on exit,
    /// the mFlags field will indicate which translations were actually done.
    ///
    /// Returns: An OSStatus indicating success or failure. kAudioHardwareNotRunningError will be
    /// returned if the AudioDevice isn't running.
    ///
    /// # Safety
    ///
    /// - `in_time` must be a valid pointer.
    /// - `out_time` must be a valid pointer.
    #[cfg(feature = "objc2-core-audio-types")]
    pub fn AudioDeviceTranslateTime(
        in_device: AudioObjectID,
        in_time: NonNull<AudioTimeStamp>,
        out_time: NonNull<AudioTimeStamp>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Query an AudioDevice to get a time equal to or later than the given time that is
    /// the best time to start IO.
    ///
    /// The time that is returned is dictated by the constraints of the device and the
    /// system. For instance, the driver of a device that provides both audio and video
    /// data may only allow start times that coincide with the edge of a video frame.
    /// Also, if the device already has one or more active IOProcs, the start time will
    /// be shifted to the beginning of the next IO cycle so as not to cause
    /// discontinuities in the existing IOProcs. Another reason the start time may shift
    /// is to allow for aligning the buffer accesses in an optimal fashion. Note that
    /// the device must be running to use this function.
    ///
    /// Parameter `inDevice`: The AudioDevice to query.
    ///
    /// Parameter `ioRequestedStartTime`: A pointer to an AudioTimeStamp that, on entry, is the requested start time.
    /// On exit, it will have the a time equal to or later than the requested time,
    /// as dictated by the device's constraints.
    ///
    /// Parameter `inFlags`: A UInt32 containing flags that modify how this function behaves.
    ///
    /// Returns: An OSStatus indicating success or failure. kAudioHardwareNotRunningError will be
    /// returned if the AudioDevice isn't running.
    /// kAudioHardwareUnsupportedOperationError will be returned if the AudioDevice does
    /// not support starting at a specific time.
    ///
    /// # Safety
    ///
    /// `io_requested_start_time` must be a valid pointer.
    #[cfg(feature = "objc2-core-audio-types")]
    pub fn AudioDeviceGetNearestStartTime(
        in_device: AudioObjectID,
        io_requested_start_time: NonNull<AudioTimeStamp>,
        in_flags: u32,
    ) -> OSStatus;
}

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedeviceclassid?language=objc)
pub const kAudioAggregateDeviceClassID: AudioClassID = 0x61616767;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedevicepropertyfullsubdevicelist?language=objc)
pub const kAudioAggregateDevicePropertyFullSubDeviceList: AudioObjectPropertySelector = 0x67727570;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedevicepropertyactivesubdevicelist?language=objc)
pub const kAudioAggregateDevicePropertyActiveSubDeviceList: AudioObjectPropertySelector =
    0x61677270;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedevicepropertycomposition?language=objc)
pub const kAudioAggregateDevicePropertyComposition: AudioObjectPropertySelector = 0x61636f6d;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedevicepropertymainsubdevice?language=objc)
pub const kAudioAggregateDevicePropertyMainSubDevice: AudioObjectPropertySelector = 0x616d7374;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedevicepropertyclockdevice?language=objc)
pub const kAudioAggregateDevicePropertyClockDevice: AudioObjectPropertySelector = 0x61706364;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedevicepropertytaplist?language=objc)
pub const kAudioAggregateDevicePropertyTapList: AudioObjectPropertySelector = 0x74617023;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedevicepropertysubtaplist?language=objc)
pub const kAudioAggregateDevicePropertySubTapList: AudioObjectPropertySelector = 0x61746170;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedriftcompensationminquality?language=objc)
pub const kAudioAggregateDriftCompensationMinQuality: u32 = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedriftcompensationlowquality?language=objc)
pub const kAudioAggregateDriftCompensationLowQuality: u32 = 0x20;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedriftcompensationmediumquality?language=objc)
pub const kAudioAggregateDriftCompensationMediumQuality: u32 = 0x40;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedriftcompensationhighquality?language=objc)
pub const kAudioAggregateDriftCompensationHighQuality: u32 = 0x60;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioaggregatedriftcompensationmaxquality?language=objc)
pub const kAudioAggregateDriftCompensationMaxQuality: u32 = 0x7F;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubdeviceclassid?language=objc)
pub const kAudioSubDeviceClassID: AudioClassID = 0x61737562;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubdevicedriftcompensationminquality?language=objc)
#[deprecated]
pub const kAudioSubDeviceDriftCompensationMinQuality: u32 = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubdevicedriftcompensationlowquality?language=objc)
#[deprecated]
pub const kAudioSubDeviceDriftCompensationLowQuality: u32 = 0x20;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubdevicedriftcompensationmediumquality?language=objc)
#[deprecated]
pub const kAudioSubDeviceDriftCompensationMediumQuality: u32 = 0x40;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubdevicedriftcompensationhighquality?language=objc)
#[deprecated]
pub const kAudioSubDeviceDriftCompensationHighQuality: u32 = 0x60;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubdevicedriftcompensationmaxquality?language=objc)
#[deprecated]
pub const kAudioSubDeviceDriftCompensationMaxQuality: u32 = 0x7F;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubdevicepropertyextralatency?language=objc)
pub const kAudioSubDevicePropertyExtraLatency: AudioObjectPropertySelector = 0x786c7463;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubdevicepropertydriftcompensation?language=objc)
pub const kAudioSubDevicePropertyDriftCompensation: AudioObjectPropertySelector = 0x64726674;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubdevicepropertydriftcompensationquality?language=objc)
pub const kAudioSubDevicePropertyDriftCompensationQuality: AudioObjectPropertySelector = 0x64726671;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubtapclassid?language=objc)
pub const kAudioSubTapClassID: AudioClassID = 0x73746170;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubtappropertyextralatency?language=objc)
pub const kAudioSubTapPropertyExtraLatency: AudioObjectPropertySelector = 0x786c7463;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubtappropertydriftcompensation?language=objc)
pub const kAudioSubTapPropertyDriftCompensation: AudioObjectPropertySelector = 0x64726674;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiosubtappropertydriftcompensationquality?language=objc)
pub const kAudioSubTapPropertyDriftCompensationQuality: AudioObjectPropertySelector = 0x64726671;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioprocessclassid?language=objc)
pub const kAudioProcessClassID: AudioClassID = 0x636c6e74;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioprocesspropertypid?language=objc)
pub const kAudioProcessPropertyPID: AudioObjectPropertySelector = 0x70706964;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioprocesspropertybundleid?language=objc)
pub const kAudioProcessPropertyBundleID: AudioObjectPropertySelector = 0x70626964;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioprocesspropertydevices?language=objc)
pub const kAudioProcessPropertyDevices: AudioObjectPropertySelector = 0x70647623;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioprocesspropertyisrunning?language=objc)
pub const kAudioProcessPropertyIsRunning: AudioObjectPropertySelector = 0x7069723f;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioprocesspropertyisrunninginput?language=objc)
pub const kAudioProcessPropertyIsRunningInput: AudioObjectPropertySelector = 0x70697269;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudioprocesspropertyisrunningoutput?language=objc)
pub const kAudioProcessPropertyIsRunningOutput: AudioObjectPropertySelector = 0x7069726f;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiotapclassid?language=objc)
pub const kAudioTapClassID: AudioClassID = 0x74636c73;

/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiotappropertyuid?language=objc)
pub const kAudioTapPropertyUID: AudioObjectPropertySelector = 0x74756964;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiotappropertydescription?language=objc)
pub const kAudioTapPropertyDescription: AudioObjectPropertySelector = 0x74647363;
/// [Apple's documentation](https://developer.apple.com/documentation/coreaudio/kaudiotappropertyformat?language=objc)
pub const kAudioTapPropertyFormat: AudioObjectPropertySelector = 0x74666d74;

extern "C-unwind" {
    /// This routine creates a new Tap using the provided description.
    ///
    /// Parameter `inDescription`: The CATapDescription that specifies how to build the Tap.
    ///
    /// Parameter `outTapID`: The AudioObjectID of the newly created Tap.
    ///
    /// Returns: An OSStatus indicating success or failure.
    ///
    /// # Safety
    ///
    /// - `in_description` might not allow `None`.
    /// - `out_tap_id` must be a valid pointer.
    #[cfg(feature = "objc2")]
    pub fn AudioHardwareCreateProcessTap(
        in_description: Option<&CATapDescription>,
        out_tap_id: *mut AudioObjectID,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// This routine destroys the given Tap.
    ///
    /// Parameter `inTapID`: The AudioObjectID of the Tap to destroy.
    ///
    /// Returns: An OSStatus indicating success or failure.
    pub fn AudioHardwareDestroyProcessTap(in_tap_id: AudioObjectID) -> OSStatus;
}

/// CATapMuteBehavior describes the playback behavior of the process being tapped. The default value is CATapUnmuted.
///
/// Audio is captured by the tap and also sent to the audio hardware
///
/// Audio is captured by the tap but no audio is sent from the process to the audio hardware
///
/// Audio is captured by the tap and also sent to the audio hardware until the tap is read by another audio client.
/// For the duration of the read activity on the tap no audio is sent to the audio hardware.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/catapmutebehavior?language=objc)
// NS_ENUM
#[cfg(feature = "objc2")]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CATapMuteBehavior(pub NSInteger);
#[cfg(feature = "objc2")]
impl CATapMuteBehavior {
    #[doc(alias = "CATapUnmuted")]
    pub const Unmuted: Self = Self(0);
    #[doc(alias = "CATapMuted")]
    pub const Muted: Self = Self(1);
    #[doc(alias = "CATapMutedWhenTapped")]
    pub const MutedWhenTapped: Self = Self(2);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CATapMuteBehavior {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CATapMuteBehavior {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

#[cfg(feature = "objc2")]
extern_class!(
    /// This class describes a tap object that contains an input stream.  The input stream is a mix of all of the specified processes output audio.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreaudio/catapdescription?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "objc2")]
    pub struct CATapDescription;
);

#[cfg(feature = "objc2")]
extern_conformance!(
    unsafe impl NSObjectProtocol for CATapDescription {}
);

#[cfg(feature = "objc2")]
impl CATapDescription {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "objc2-foundation")]
        /// Mix all given process audio streams down to stereo.  Mono sources will be duplicated in
        /// both right and left channels.
        ///
        /// Parameter `processesObjectIDsToIncludeInTap`: An NSArray of NSNumbers where each NSNumber holds an AudioObjectID of the process object to include in the tap
        #[unsafe(method(initStereoMixdownOfProcesses:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initStereoMixdownOfProcesses(
            this: Allocated<Self>,
            processes_object_i_ds_to_include_in_tap: &NSArray<NSNumber>,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-foundation")]
        /// Mix all processes to a stereo stream except the given processes.  Mono sources will be
        /// duplicated in both right and left channels.
        ///
        /// Parameter `processesObjectIDsToExcludeFromTap`: An NSArray of NSNumbers where each NSNumber holds an AudioObjectID of the process object to exclude from the tap.
        /// All other processes that output audio will be included in the tap.
        #[unsafe(method(initStereoGlobalTapButExcludeProcesses:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initStereoGlobalTapButExcludeProcesses(
            this: Allocated<Self>,
            processes_object_i_ds_to_exclude_from_tap: &NSArray<NSNumber>,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-foundation")]
        /// Mix all given process audio streams audio to mono.
        ///
        /// Parameter `processesObjectIDsToIncludeInTap`: An NSArray of NSNumbers where each NSNumber holds an AudioObjectID of the process object to include in the tap
        #[unsafe(method(initMonoMixdownOfProcesses:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initMonoMixdownOfProcesses(
            this: Allocated<Self>,
            processes_object_i_ds_to_include_in_tap: &NSArray<NSNumber>,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-foundation")]
        /// Mix all processes to a mono stream except the given processes
        ///
        /// Parameter `processesObjectIDsToExcludeFromTap`: An NSArray of NSNumbers where each NSNumber holds an AudioObjectID of the process object to exclude from the tap.
        /// All other processes that output audio will be included in the tap.
        #[unsafe(method(initMonoGlobalTapButExcludeProcesses:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initMonoGlobalTapButExcludeProcesses(
            this: Allocated<Self>,
            processes_object_i_ds_to_exclude_from_tap: &NSArray<NSNumber>,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-foundation")]
        /// Mix all given process audio streams destined for the selected device stream
        ///
        /// Parameter `processesObjectIDsToIncludeInTap`: An NSArray of NSNumbers where each NSNumber holds an AudioObjectID of the process object to exclude from the tap.
        /// All other processes that output audio will be included in the tap.
        ///
        /// Parameter `deviceUID`: The device UID of the output device whose audio will be captured
        ///
        /// Parameter `stream`: NSInteger that represents the index of the stream on the device whose audio will be captured. The format of the tap
        /// will match the format of this stream.
        #[unsafe(method(initWithProcesses:andDeviceUID:withStream:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithProcesses_andDeviceUID_withStream(
            this: Allocated<Self>,
            processes_object_i_ds_to_include_in_tap: &NSArray<NSNumber>,
            device_uid: &NSString,
            stream: NSInteger,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-foundation")]
        /// Mix all process audio streams destined for the selected device stream except the given processes
        ///
        /// Parameter `processesObjectIDsToExcludeFromTap`: An NSArray of NSNumbers where each NSNumber holds an AudioObjectID of the process object to exclude from the tap.
        /// All other processes that output audio will be included in the tap.
        ///
        /// Parameter `deviceUID`: The device UID of the output device whose audio will be captured
        ///
        /// Parameter `stream`: NSInteger that represents the index of the stream on the device whose audio will be captured. The format of the tap
        /// will match the format of this stream.
        #[unsafe(method(initExcludingProcesses:andDeviceUID:withStream:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initExcludingProcesses_andDeviceUID_withStream(
            this: Allocated<Self>,
            processes_object_i_ds_to_exclude_from_tap: &NSArray<NSNumber>,
            device_uid: &NSString,
            stream: NSInteger,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-foundation")]
        /// Human readable name of this tap.
        #[unsafe(method(name))]
        #[unsafe(method_family = none)]
        pub unsafe fn name(&self) -> Retained<NSString>;

        #[cfg(feature = "objc2-foundation")]
        /// Setter for [`name`][Self::name].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setName(&self, name: &NSString);

        #[cfg(feature = "objc2-foundation")]
        /// UID of this tap.
        #[unsafe(method(UUID))]
        #[unsafe(method_family = none)]
        pub unsafe fn UUID(&self) -> Retained<NSUUID>;

        #[cfg(feature = "objc2-foundation")]
        /// Setter for [`UUID`][Self::UUID].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setUUID:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUUID(&self, uuid: &NSUUID);

        #[cfg(feature = "objc2-foundation")]
        /// An NSArray of NSNumbers where each NSNumber holds the AudioObjectID of a process object to tap or exclude.
        #[unsafe(method(processes))]
        #[unsafe(method_family = none)]
        pub unsafe fn processes(&self) -> Retained<NSArray<NSNumber>>;

        #[cfg(feature = "objc2-foundation")]
        /// Setter for [`processes`][Self::processes].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setProcesses:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setProcesses(&self, processes: &NSArray<NSNumber>);

        #[cfg(feature = "objc2-foundation")]
        /// An Array of Strings where each String holds the bundle ID of a process to tap or exclude.
        #[unsafe(method(bundleIDs))]
        #[unsafe(method_family = none)]
        pub unsafe fn bundleIDs(&self) -> Retained<NSArray<NSString>>;

        #[cfg(feature = "objc2-foundation")]
        /// Setter for [`bundleIDs`][Self::bundleIDs].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setBundleIDs:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBundleIDs(&self, bundle_i_ds: &NSArray<NSString>);

        /// True if this description is a mono mixdown of channels.
        #[unsafe(method(isMono))]
        #[unsafe(method_family = none)]
        pub unsafe fn isMono(&self) -> bool;

        /// Setter for [`isMono`][Self::isMono].
        #[unsafe(method(setMono:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMono(&self, mono: bool);

        /// True if this description should tap all processes except the process listed in the 'processes' property.
        #[unsafe(method(isExclusive))]
        #[unsafe(method_family = none)]
        pub unsafe fn isExclusive(&self) -> bool;

        /// Setter for [`isExclusive`][Self::isExclusive].
        #[unsafe(method(setExclusive:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setExclusive(&self, exclusive: bool);

        /// True if this description is a mono or stereo mix of the tapped device's channels.
        #[unsafe(method(isMixdown))]
        #[unsafe(method_family = none)]
        pub unsafe fn isMixdown(&self) -> bool;

        /// Setter for [`isMixdown`][Self::isMixdown].
        #[unsafe(method(setMixdown:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMixdown(&self, mixdown: bool);

        /// True if this tap is only visible to the client process that created the tap.
        #[unsafe(method(isPrivate))]
        #[unsafe(method_family = none)]
        pub unsafe fn isPrivate(&self) -> bool;

        /// Setter for [`isPrivate`][Self::isPrivate].
        #[unsafe(method(setPrivate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPrivate(&self, private_tap: bool);

        /// True if this tap should save tapped processes by bundle ID when they exit, and restore them to the tap when they start up again.
        #[unsafe(method(isProcessRestoreEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isProcessRestoreEnabled(&self) -> bool;

        /// Setter for [`isProcessRestoreEnabled`][Self::isProcessRestoreEnabled].
        #[unsafe(method(setProcessRestoreEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setProcessRestoreEnabled(&self, process_restore_enabled: bool);

        /// Set the tap's mute behavior. See CATapMuteBehavior above.
        #[unsafe(method(isMuted))]
        #[unsafe(method_family = none)]
        pub unsafe fn isMuted(&self) -> CATapMuteBehavior;

        /// Setter for [`isMuted`][Self::isMuted].
        #[unsafe(method(setMuteBehavior:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMuteBehavior(&self, mute_behavior: CATapMuteBehavior);

        #[cfg(feature = "objc2-foundation")]
        /// An optional deviceUID that will have a value if this tap only taps a specific hardware device
        #[unsafe(method(deviceUID))]
        #[unsafe(method_family = none)]
        pub unsafe fn deviceUID(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "objc2-foundation")]
        /// Setter for [`deviceUID`][Self::deviceUID].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setDeviceUID:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDeviceUID(&self, device_uid: Option<&NSString>);

        #[cfg(feature = "objc2-foundation")]
        /// An optional NSNumber that will have a value if this tap taps a specific device stream.
        /// The value represents the index of the hardware stream.
        #[unsafe(method(stream))]
        #[unsafe(method_family = none)]
        pub unsafe fn stream(&self) -> Option<Retained<NSNumber>>;

        #[cfg(feature = "objc2-foundation")]
        /// Setter for [`stream`][Self::stream].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setStream:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setStream(&self, stream: Option<&NSNumber>);
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "objc2")]
impl CATapDescription {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
