//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousb20bitratelow?language=objc)
pub const kIOUSB20BitrateLow: c_uint = 1500 * 1000;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousb20bitratefull?language=objc)
pub const kIOUSB20BitrateFull: c_uint = 12 * 1000 * 1000;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousb20bitratehigh?language=objc)
pub const kIOUSB20BitrateHigh: c_uint = 480 * 1000 * 1000;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbapplevendorid?language=objc)
pub const kIOUSBAppleVendorID: c_uint = 0x05AC;

/// Descriptor types defined by USB 2.0 Table 9-5 and USB 3.0 Table 9-6
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/tiousbdescriptortype?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct tIOUSBDescriptorType(pub c_uint);
impl tIOUSBDescriptorType {
    #[doc(alias = "kIOUSBDescriptorTypeDevice")]
    pub const IOUSBDescriptorTypeDevice: Self = Self(1);
    #[doc(alias = "kIOUSBDescriptorTypeConfiguration")]
    pub const IOUSBDescriptorTypeConfiguration: Self = Self(2);
    #[doc(alias = "kIOUSBDescriptorTypeString")]
    pub const IOUSBDescriptorTypeString: Self = Self(3);
    #[doc(alias = "kIOUSBDescriptorTypeInterface")]
    pub const IOUSBDescriptorTypeInterface: Self = Self(4);
    #[doc(alias = "kIOUSBDescriptorTypeEndpoint")]
    pub const IOUSBDescriptorTypeEndpoint: Self = Self(5);
    #[doc(alias = "kIOUSBDescriptorTypeDeviceQualifier")]
    pub const IOUSBDescriptorTypeDeviceQualifier: Self = Self(6);
    #[doc(alias = "kIOUSBDescriptorTypeOtherSpeedConfiguration")]
    pub const IOUSBDescriptorTypeOtherSpeedConfiguration: Self = Self(7);
    #[doc(alias = "kIOUSBDescriptorTypeInterfacePower")]
    pub const IOUSBDescriptorTypeInterfacePower: Self = Self(8);
    #[doc(alias = "kIOUSBDescriptorTypeOTG")]
    pub const IOUSBDescriptorTypeOTG: Self = Self(9);
    #[doc(alias = "kIOUSBDescriptorTypeDebug")]
    pub const IOUSBDescriptorTypeDebug: Self = Self(10);
    #[doc(alias = "kIOUSBDescriptorTypeInterfaceAssociation")]
    pub const IOUSBDescriptorTypeInterfaceAssociation: Self = Self(11);
    #[doc(alias = "kIOUSBDescriptorTypeBOS")]
    pub const IOUSBDescriptorTypeBOS: Self = Self(15);
    #[doc(alias = "kIOUSBDescriptorTypeDeviceCapability")]
    pub const IOUSBDescriptorTypeDeviceCapability: Self = Self(16);
    #[doc(alias = "kIOUSBDecriptorTypeHID")]
    pub const IOUSBDecriptorTypeHID: Self = Self(33);
    #[doc(alias = "kIOUSBDecriptorTypeReport")]
    pub const IOUSBDecriptorTypeReport: Self = Self(34);
    #[doc(alias = "kIOUSBDescriptorTypePhysical")]
    pub const IOUSBDescriptorTypePhysical: Self = Self(35);
    #[doc(alias = "kIOUSBDescriptorTypeHub")]
    pub const IOUSBDescriptorTypeHub: Self = Self(41);
    #[doc(alias = "kIOUSBDescriptorTypeSuperSpeedHub")]
    pub const IOUSBDescriptorTypeSuperSpeedHub: Self = Self(42);
    #[doc(alias = "kIOUSBDescriptorTypeSuperSpeedUSBEndpointCompanion")]
    pub const IOUSBDescriptorTypeSuperSpeedUSBEndpointCompanion: Self = Self(48);
    #[doc(alias = "kIOUSBDescriptorTypeSuperSpeedPlusIsochronousEndpointCompanion")]
    pub const IOUSBDescriptorTypeSuperSpeedPlusIsochronousEndpointCompanion: Self = Self(49);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for tIOUSBDescriptorType {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for tIOUSBDescriptorType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Size in bytes for descriptor structures
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/tiousbdescriptorsize?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct tIOUSBDescriptorSize(pub c_uint);
impl tIOUSBDescriptorSize {
    #[doc(alias = "kIOUSBDescriptorHeaderSize")]
    pub const IOUSBDescriptorHeaderSize: Self = Self(2);
    #[doc(alias = "kIOUSBDescriptorSizeDevice")]
    pub const IOUSBDescriptorSizeDevice: Self = Self(18);
    #[doc(alias = "kIOUSBDescriptorSizeConfiguration")]
    pub const IOUSBDescriptorSizeConfiguration: Self = Self(9);
    #[doc(alias = "kIOUSBDescriptorSizeInterface")]
    pub const IOUSBDescriptorSizeInterface: Self = Self(9);
    #[doc(alias = "kIOUSBDescriptorSizeEndpoint")]
    pub const IOUSBDescriptorSizeEndpoint: Self = Self(7);
    #[doc(alias = "kIOUSBDescriptorSizeStringMinimum")]
    pub const IOUSBDescriptorSizeStringMinimum: Self =
        Self(tIOUSBDescriptorSize::IOUSBDescriptorHeaderSize.0);
    #[doc(alias = "kIOUSBDescriptorSizeStringMaximum")]
    pub const IOUSBDescriptorSizeStringMaximum: Self = Self(255);
    #[doc(alias = "kIOUSBDescriptorSizeDeviceQualifier")]
    pub const IOUSBDescriptorSizeDeviceQualifier: Self = Self(10);
    #[doc(alias = "kIOUSBDescriptorSizeInterfaceAssociation")]
    pub const IOUSBDescriptorSizeInterfaceAssociation: Self = Self(8);
    #[doc(alias = "kIOUSBDescriptorSizeBOS")]
    pub const IOUSBDescriptorSizeBOS: Self = Self(5);
    #[doc(alias = "kIOUSBDescriptorSizeDeviceCapability")]
    pub const IOUSBDescriptorSizeDeviceCapability: Self = Self(3);
    #[doc(alias = "kIOUSBDescriptorSizeUSB20ExtensionCapability")]
    pub const IOUSBDescriptorSizeUSB20ExtensionCapability: Self = Self(7);
    #[doc(alias = "kIOUSBDescriptorSizeSuperSpeedUSBDeviceCapability")]
    pub const IOUSBDescriptorSizeSuperSpeedUSBDeviceCapability: Self = Self(10);
    #[doc(alias = "kIOUSBDescriptorSizeContainerIDCapability")]
    pub const IOUSBDescriptorSizeContainerIDCapability: Self = Self(20);
    #[doc(alias = "kIOUSBDescriptorSizeHubMinimum")]
    pub const IOUSBDescriptorSizeHubMinimum: Self = Self(9);
    #[doc(alias = "kIOUSBDescriptorSizeHubMaximum")]
    pub const IOUSBDescriptorSizeHubMaximum: Self = Self(21);
    #[doc(alias = "kIOUSBDescriptorSizeSuperSpeedHub")]
    pub const IOUSBDescriptorSizeSuperSpeedHub: Self = Self(12);
    #[doc(alias = "kIOUSBDescriptorSizeSuperSpeedUSBEndpointCompanion")]
    pub const IOUSBDescriptorSizeSuperSpeedUSBEndpointCompanion: Self = Self(6);
    #[doc(alias = "kIOUSBDescriptorSizeSuperSpeedPlusIsochronousEndpointCompanion")]
    pub const IOUSBDescriptorSizeSuperSpeedPlusIsochronousEndpointCompanion: Self = Self(8);
    #[doc(alias = "kIOUSBDescriptorSizeBillboardDeviceMinimum")]
    pub const IOUSBDescriptorSizeBillboardDeviceMinimum: Self = Self(44);
    #[doc(alias = "kIOUSBDescriptorSizeBillboardDeviceMaximum")]
    pub const IOUSBDescriptorSizeBillboardDeviceMaximum: Self = Self(256);
    #[doc(alias = "kIOUSBDescriptorSizePlatformECIDCapability")]
    pub const IOUSBDescriptorSizePlatformECIDCapability: Self = Self(28);
    #[doc(alias = "kIOUSBDescriptorSizePlatformCapability")]
    pub const IOUSBDescriptorSizePlatformCapability: Self = Self(20);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for tIOUSBDescriptorSize {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for tIOUSBDescriptorSize {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Base descriptor defined by USB 2.0 9.5
///
/// IOUSBDescriptorDefinitions declares structs to represent a variety of USB standard
/// descriptors.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdescriptorheader?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDescriptorHeader {
    pub bLength: u8,
    pub bDescriptorType: u8,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBDescriptorHeader {
    const ENCODING: Encoding =
        Encoding::Struct("IOUSBDescriptorHeader", &[<u8>::ENCODING, <u8>::ENCODING]);
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBDescriptorHeader {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Base descriptor defined by USB 2.0 9.5
///
/// Used to represent generic descriptor definitions
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdescriptor?language=objc)
pub type IOUSBDescriptor = IOUSBDescriptorHeader;

/// Descriptor for a USB Device.
/// See the USB Specification at
/// <a href="http://www.usb.org" target="_blank">
/// http://www.usb.org
/// </a>
/// .
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicedescriptor?language=objc)
#[repr(C, packed)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceDescriptor {
    pub bLength: u8,
    pub bDescriptorType: u8,
    pub bcdUSB: u16,
    pub bDeviceClass: u8,
    pub bDeviceSubClass: u8,
    pub bDeviceProtocol: u8,
    pub bMaxPacketSize0: u8,
    pub idVendor: u16,
    pub idProduct: u16,
    pub bcdDevice: u16,
    pub iManufacturer: u8,
    pub iProduct: u8,
    pub iSerialNumber: u8,
    pub bNumConfigurations: u8,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBDeviceDescriptor {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBDeviceDescriptor",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBDeviceDescriptor {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// USB Device Qualifier Descriptor.
/// See the USB Specification at
/// <a href="http://www.usb.org" target="_blank">
/// http://www.usb.org
/// </a>
/// .
/// USB 2.0 9.6.2: Device Qualifier
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicequalifierdescriptor?language=objc)
#[repr(C, packed)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceQualifierDescriptor {
    pub bLength: u8,
    pub bDescriptorType: u8,
    pub bcdUSB: u16,
    pub bDeviceClass: u8,
    pub bDeviceSubClass: u8,
    pub bDeviceProtocol: u8,
    pub bMaxPacketSize0: u8,
    pub bNumConfigurations: u8,
    pub bReserved: u8,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBDeviceQualifierDescriptor {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBDeviceQualifierDescriptor",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBDeviceQualifierDescriptor {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Header of a IOUSBConfigurationDescriptor.  Used to get the total length of the descriptor.
/// USB 2.0 9.6.3: Configuration
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbconfigurationdescheader?language=objc)
#[repr(C, packed)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBConfigurationDescHeader {
    pub bLength: u8,
    pub bDescriptorType: u8,
    pub wTotalLength: u16,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBConfigurationDescHeader {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBConfigurationDescHeader",
        &[<u8>::ENCODING, <u8>::ENCODING, <u16>::ENCODING],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBConfigurationDescHeader {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Standard USB Configuration Descriptor.  It is variable length, so this only specifies
/// the known fields.  We use the wTotalLength field to read the whole descriptor.
/// See the USB Specification at
/// <a href="http://www.usb.org" target="_blank">
/// http://www.usb.org
/// </a>
/// .
/// USB 2.0 9.6.3: Configuration
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbconfigurationdescriptor?language=objc)
#[repr(C, packed)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBConfigurationDescriptor {
    pub bLength: u8,
    pub bDescriptorType: u8,
    pub wTotalLength: u16,
    pub bNumInterfaces: u8,
    pub bConfigurationValue: u8,
    pub iConfiguration: u8,
    pub bmAttributes: u8,
    pub MaxPower: u8,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBConfigurationDescriptor {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBConfigurationDescriptor",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBConfigurationDescriptor {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbconfigurationdescriptorattributeremotewakecapable?language=objc)
pub const kIOUSBConfigurationDescriptorAttributeRemoteWakeCapable: c_uint = IOUSBBit!(5);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbconfigurationdescriptorattributeselfpowered?language=objc)
pub const kIOUSBConfigurationDescriptorAttributeSelfPowered: c_uint = IOUSBBit!(6);

/// Descriptor for a USB Interface.  See the USB Specification at
/// <a href="http://www.usb.org" target="_blank">
/// http://www.usb.org
/// </a>
/// .
/// USB 2.0 9.6.5: Interface
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfacedescriptor?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBInterfaceDescriptor {
    pub bLength: u8,
    pub bDescriptorType: u8,
    pub bInterfaceNumber: u8,
    pub bAlternateSetting: u8,
    pub bNumEndpoints: u8,
    pub bInterfaceClass: u8,
    pub bInterfaceSubClass: u8,
    pub bInterfaceProtocol: u8,
    pub iInterface: u8,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBInterfaceDescriptor {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBInterfaceDescriptor",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBInterfaceDescriptor {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Descriptor for a USB Endpoint.  See the USB Specification at
/// <a href="http://www.usb.org" target="_blank">
/// http://www.usb.org
/// </a>
/// .
/// USB 2.0 9.6.6: Endpoint
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbendpointdescriptor?language=objc)
#[repr(C, packed)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBEndpointDescriptor {
    pub bLength: u8,
    pub bDescriptorType: u8,
    pub bEndpointAddress: u8,
    pub bmAttributes: u8,
    pub wMaxPacketSize: u16,
    pub bInterval: u8,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBEndpointDescriptor {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBEndpointDescriptor",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
            <u8>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBEndpointDescriptor {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptornumber?language=objc)
pub const kIOUSBEndpointDescriptorNumber: c_uint = IOUSBBitRange!(0, 3);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptornumberphase?language=objc)
pub const kIOUSBEndpointDescriptorNumberPhase: c_uint = IOUSBBitRangePhase!(0, 3);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptorendpointaddressreserved?language=objc)
pub const kIOUSBEndpointDescriptorEndpointAddressReserved: c_uint = IOUSBBitRange!(4, 6);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptordirection?language=objc)
pub const kIOUSBEndpointDescriptorDirection: c_uint = IOUSBBit!(7);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptordirectionphase?language=objc)
pub const kIOUSBEndpointDescriptorDirectionPhase: c_uint = IOUSBBitRangePhase!(7, 7);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptordirectionout?language=objc)
pub const kIOUSBEndpointDescriptorDirectionOut: c_uint = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptordirectionin?language=objc)
pub const kIOUSBEndpointDescriptorDirectionIn: c_uint = IOUSBBit!(7);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptortransfertype?language=objc)
pub const kIOUSBEndpointDescriptorTransferType: c_uint = IOUSBBitRange!(0, 1);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptortransfertypephase?language=objc)
pub const kIOUSBEndpointDescriptorTransferTypePhase: c_uint = IOUSBBitRangePhase!(0, 1);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptortransfertypecontrol?language=objc)
pub const kIOUSBEndpointDescriptorTransferTypeControl: c_uint = 0 << IOUSBBitRangePhase!(0, 1);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptortransfertypeisochronous?language=objc)
pub const kIOUSBEndpointDescriptorTransferTypeIsochronous: c_uint = 1 << IOUSBBitRangePhase!(0, 1);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptortransfertypebulk?language=objc)
pub const kIOUSBEndpointDescriptorTransferTypeBulk: c_uint = 2 << IOUSBBitRangePhase!(0, 1);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptortransfertypeinterrupt?language=objc)
pub const kIOUSBEndpointDescriptorTransferTypeInterrupt: c_uint = 3 << IOUSBBitRangePhase!(0, 1);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptorsynchronizationtype?language=objc)
pub const kIOUSBEndpointDescriptorSynchronizationType: c_uint = IOUSBBitRange!(2, 3);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptorsynchronizationtypephase?language=objc)
pub const kIOUSBEndpointDescriptorSynchronizationTypePhase: c_uint = IOUSBBitRangePhase!(2, 3);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptorsynchronizationtypenone?language=objc)
pub const kIOUSBEndpointDescriptorSynchronizationTypeNone: c_uint = 0 << IOUSBBitRangePhase!(2, 3);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptorsynchronizationtypeasynchronous?language=objc)
pub const kIOUSBEndpointDescriptorSynchronizationTypeAsynchronous: c_uint =
    1 << IOUSBBitRangePhase!(2, 3);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptorsynchronizationtypeadaptive?language=objc)
pub const kIOUSBEndpointDescriptorSynchronizationTypeAdaptive: c_uint =
    2 << IOUSBBitRangePhase!(2, 3);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptorsynchronizationtypesynchronous?language=objc)
pub const kIOUSBEndpointDescriptorSynchronizationTypeSynchronous: c_uint =
    3 << IOUSBBitRangePhase!(2, 3);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptorusagetype?language=objc)
pub const kIOUSBEndpointDescriptorUsageType: c_uint = IOUSBBitRange!(4, 5);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptorusagetypephase?language=objc)
pub const kIOUSBEndpointDescriptorUsageTypePhase: c_uint = IOUSBBitRangePhase!(4, 5);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptorusagetypeinterruptperiodic?language=objc)
pub const kIOUSBEndpointDescriptorUsageTypeInterruptPeriodic: c_uint =
    0 << IOUSBBitRangePhase!(4, 5);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptorusagetypeinterruptnotification?language=objc)
pub const kIOUSBEndpointDescriptorUsageTypeInterruptNotification: c_uint =
    1 << IOUSBBitRangePhase!(4, 5);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptorusagetypeinterruptreserved1?language=objc)
pub const kIOUSBEndpointDescriptorUsageTypeInterruptReserved1: c_uint =
    2 << IOUSBBitRangePhase!(4, 5);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptorusagetypeinterruptreserved2?language=objc)
pub const kIOUSBEndpointDescriptorUsageTypeInterruptReserved2: c_uint =
    3 << IOUSBBitRangePhase!(4, 5);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptorusagetypeisocdata?language=objc)
pub const kIOUSBEndpointDescriptorUsageTypeIsocData: c_uint = 0 << IOUSBBitRangePhase!(4, 5);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptorusagetypeisocfeedback?language=objc)
pub const kIOUSBEndpointDescriptorUsageTypeIsocFeedback: c_uint = 1 << IOUSBBitRangePhase!(4, 5);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptorusagetypeisocimplicit?language=objc)
pub const kIOUSBEndpointDescriptorUsageTypeIsocImplicit: c_uint = 2 << IOUSBBitRangePhase!(4, 5);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptorusagetypeisocreserved?language=objc)
pub const kIOUSBEndpointDescriptorUsageTypeIsocReserved: c_uint = 3 << IOUSBBitRangePhase!(4, 5);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptorpacketsize?language=objc)
pub const kIOUSBEndpointDescriptorPacketSize: c_uint = IOUSBBitRange!(0, 10);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptorpacketsizephase?language=objc)
pub const kIOUSBEndpointDescriptorPacketSizePhase: c_uint = IOUSBBitRangePhase!(0, 10);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptorpacketsizemult?language=objc)
pub const kIOUSBEndpointDescriptorPacketSizeMult: c_uint = IOUSBBitRange!(11, 12);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptorpacketsizemultphase?language=objc)
pub const kIOUSBEndpointDescriptorPacketSizeMultPhase: c_uint = IOUSBBitRangePhase!(11, 12);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptorreserved?language=objc)
pub const kIOUSBEndpointDescriptorReserved: c_uint = IOUSBBitRange!(13, 15);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbendpointdescriptorreservedphase?language=objc)
pub const kIOUSBEndpointDescriptorReservedPhase: c_uint = IOUSBBitRangePhase!(13, 15);

/// IO Direction of an endpoint
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/tiousbendpointdirection?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct tIOUSBEndpointDirection(pub c_uint);
impl tIOUSBEndpointDirection {
    #[doc(alias = "kIOUSBEndpointDirectionOut")]
    pub const IOUSBEndpointDirectionOut: Self =
        Self(kIOUSBEndpointDescriptorDirectionOut >> kIOUSBEndpointDescriptorDirectionPhase);
    #[doc(alias = "kIOUSBEndpointDirectionIn")]
    pub const IOUSBEndpointDirectionIn: Self =
        Self(kIOUSBEndpointDescriptorDirectionIn >> kIOUSBEndpointDescriptorDirectionPhase);
    #[doc(alias = "kIOUSBEndpointDirectionUnknown")]
    pub const IOUSBEndpointDirectionUnknown: Self = Self(2);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for tIOUSBEndpointDirection {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for tIOUSBEndpointDirection {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Describes the type of endpoint
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/tiousbendpointtype?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct tIOUSBEndpointType(pub c_uint);
impl tIOUSBEndpointType {
    #[doc(alias = "kIOUSBEndpointTypeControl")]
    pub const IOUSBEndpointTypeControl: Self = Self(
        kIOUSBEndpointDescriptorTransferTypeControl >> kIOUSBEndpointDescriptorTransferTypePhase,
    );
    #[doc(alias = "kIOUSBEndpointTypeIsochronous")]
    pub const IOUSBEndpointTypeIsochronous: Self = Self(
        kIOUSBEndpointDescriptorTransferTypeIsochronous
            >> kIOUSBEndpointDescriptorTransferTypePhase,
    );
    #[doc(alias = "kIOUSBEndpointTypeBulk")]
    pub const IOUSBEndpointTypeBulk: Self =
        Self(kIOUSBEndpointDescriptorTransferTypeBulk >> kIOUSBEndpointDescriptorTransferTypePhase);
    #[doc(alias = "kIOUSBEndpointTypeInterrupt")]
    pub const IOUSBEndpointTypeInterrupt: Self = Self(
        kIOUSBEndpointDescriptorTransferTypeInterrupt >> kIOUSBEndpointDescriptorTransferTypePhase,
    );
}

#[cfg(feature = "objc2")]
unsafe impl Encode for tIOUSBEndpointType {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for tIOUSBEndpointType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/tiousbendpointsynchronizationtype?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct tIOUSBEndpointSynchronizationType(pub c_uint);
impl tIOUSBEndpointSynchronizationType {
    #[doc(alias = "kIOUSBEndpointSynchronizationTypeNone")]
    pub const IOUSBEndpointSynchronizationTypeNone: Self = Self(
        kIOUSBEndpointDescriptorSynchronizationTypeNone
            >> kIOUSBEndpointDescriptorSynchronizationTypePhase,
    );
    #[doc(alias = "kIOUSBEndpointSynchronizationTypeAsynchronous")]
    pub const IOUSBEndpointSynchronizationTypeAsynchronous: Self = Self(
        kIOUSBEndpointDescriptorSynchronizationTypeAsynchronous
            >> kIOUSBEndpointDescriptorSynchronizationTypePhase,
    );
    #[doc(alias = "kIOUSBEndpointSynchronizationTypeAdaptive")]
    pub const IOUSBEndpointSynchronizationTypeAdaptive: Self = Self(
        kIOUSBEndpointDescriptorSynchronizationTypeAdaptive
            >> kIOUSBEndpointDescriptorSynchronizationTypePhase,
    );
    #[doc(alias = "kIOUSBEndpointSynchronizationTypeSynchronous")]
    pub const IOUSBEndpointSynchronizationTypeSynchronous: Self = Self(
        kIOUSBEndpointDescriptorSynchronizationTypeSynchronous
            >> kIOUSBEndpointDescriptorSynchronizationTypePhase,
    );
}

#[cfg(feature = "objc2")]
unsafe impl Encode for tIOUSBEndpointSynchronizationType {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for tIOUSBEndpointSynchronizationType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/tiousbendpointusagetype?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct tIOUSBEndpointUsageType(pub c_uint);
impl tIOUSBEndpointUsageType {
    #[doc(alias = "kIOUSBEndpointUsageTypeIsocData")]
    pub const IOUSBEndpointUsageTypeIsocData: Self =
        Self(kIOUSBEndpointDescriptorUsageTypeIsocData >> kIOUSBEndpointDescriptorUsageTypePhase);
    #[doc(alias = "kIOUSBEndpointUsageTypeIsocFeedback")]
    pub const IOUSBEndpointUsageTypeIsocFeedback: Self = Self(
        kIOUSBEndpointDescriptorUsageTypeIsocFeedback >> kIOUSBEndpointDescriptorUsageTypePhase,
    );
    #[doc(alias = "kIOUSBEndpointUsageTypeIsocImplicit")]
    pub const IOUSBEndpointUsageTypeIsocImplicit: Self = Self(
        kIOUSBEndpointDescriptorUsageTypeIsocImplicit >> kIOUSBEndpointDescriptorUsageTypePhase,
    );
}

#[cfg(feature = "objc2")]
unsafe impl Encode for tIOUSBEndpointUsageType {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for tIOUSBEndpointUsageType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// USB Language Identifiers 1.0
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/tiousblanguageid?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct tIOUSBLanguageID(pub c_uint);
impl tIOUSBLanguageID {
    #[doc(alias = "kIOUSBLanguageIDEnglishUS")]
    pub const IOUSBLanguageIDEnglishUS: Self = Self(0x0409);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for tIOUSBLanguageID {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for tIOUSBLanguageID {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Descriptor for a USB Strings.  See the USB Specification at
/// <a href="http://www.usb.org" target="_blank">
/// http://www.usb.org
/// </a>
/// .
/// USB 2.0 9.6.7: String
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbstringdescriptor?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBStringDescriptor {
    pub bLength: u8,
    pub bDescriptorType: u8,
    pub bString: [u8; 1],
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBStringDescriptor {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBStringDescriptor",
        &[<u8>::ENCODING, <u8>::ENCODING, <[u8; 1]>::ENCODING],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBStringDescriptor {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/tiousbdevicecapabilitytype?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct tIOUSBDeviceCapabilityType(pub c_uint);
impl tIOUSBDeviceCapabilityType {
    #[doc(alias = "kIOUSBDeviceCapabilityTypeWireless")]
    pub const IOUSBDeviceCapabilityTypeWireless: Self = Self(1);
    #[doc(alias = "kIOUSBDeviceCapabilityTypeUSB20Extension")]
    pub const IOUSBDeviceCapabilityTypeUSB20Extension: Self = Self(2);
    #[doc(alias = "kIOUSBDeviceCapabilityTypeSuperSpeed")]
    pub const IOUSBDeviceCapabilityTypeSuperSpeed: Self = Self(3);
    #[doc(alias = "kIOUSBDeviceCapabilityTypeContainerID")]
    pub const IOUSBDeviceCapabilityTypeContainerID: Self = Self(4);
    #[doc(alias = "kIOUSBDeviceCapabilityTypePlatform")]
    pub const IOUSBDeviceCapabilityTypePlatform: Self = Self(5);
    #[doc(alias = "kIOUSBDeviceCapabilityTypePowerDelivery")]
    pub const IOUSBDeviceCapabilityTypePowerDelivery: Self = Self(6);
    #[doc(alias = "kIOUSBDeviceCapabilityTypeBatteryInfo")]
    pub const IOUSBDeviceCapabilityTypeBatteryInfo: Self = Self(7);
    #[doc(alias = "kIOUSBDeviceCapabilityTypePdConsumerPort")]
    pub const IOUSBDeviceCapabilityTypePdConsumerPort: Self = Self(8);
    #[doc(alias = "kIOUSBDeviceCapabilityTypePdProviderPort")]
    pub const IOUSBDeviceCapabilityTypePdProviderPort: Self = Self(9);
    #[doc(alias = "kIOUSBDeviceCapabilityTypeSuperSpeedPlus")]
    pub const IOUSBDeviceCapabilityTypeSuperSpeedPlus: Self = Self(10);
    #[doc(alias = "kIOUSBDeviceCapabilityTypePrecisionMeasurement")]
    pub const IOUSBDeviceCapabilityTypePrecisionMeasurement: Self = Self(11);
    #[doc(alias = "kIOUSBDeviceCapabilityTypeWirelessExt")]
    pub const IOUSBDeviceCapabilityTypeWirelessExt: Self = Self(12);
    #[doc(alias = "kIOUSBDeviceCapabilityTypeBillboard")]
    pub const IOUSBDeviceCapabilityTypeBillboard: Self = Self(13);
    #[doc(alias = "kIOUSBDeviceCapabilityTypeBillboardAltMode")]
    pub const IOUSBDeviceCapabilityTypeBillboardAltMode: Self = Self(15);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for tIOUSBDeviceCapabilityType {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for tIOUSBDeviceCapabilityType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// USB BOS descriptor. See the USB Specification at
/// <a href="http://www.usb.org" target="_blank">
/// http://www.usb.org
/// </a>
/// .
/// USB 3.0 9.6.2: Binary Device Object Store (BOS)
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbbosdescriptor?language=objc)
#[repr(C, packed)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBBOSDescriptor {
    pub bLength: u8,
    pub bDescriptorType: u8,
    pub wTotalLength: u16,
    pub bNumDeviceCaps: u8,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBBOSDescriptor {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBBOSDescriptor",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
            <u8>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBBOSDescriptor {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Device Capability descriptor.  See the USB Specification at
/// <a href="http://www.usb.org" target="_blank">
/// http://www.usb.org
/// </a>
/// .
/// USB 3.0 9.6.2: Binary Device Object Store (BOS)
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicecapabilitydescriptorheader?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceCapabilityDescriptorHeader {
    pub bLength: u8,
    pub bDescriptorType: u8,
    pub bDevCapabilityType: u8,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBDeviceCapabilityDescriptorHeader {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBDeviceCapabilityDescriptorHeader",
        &[<u8>::ENCODING, <u8>::ENCODING, <u8>::ENCODING],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBDeviceCapabilityDescriptorHeader {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Device Capability USB 2.0 Extension.
/// USB 3.0 9.6.2.1: USB 2.0 Extension
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicecapabilityusb2extension?language=objc)
#[repr(C, packed)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceCapabilityUSB2Extension {
    pub bLength: u8,
    pub bDescriptorType: u8,
    pub bDevCapabilityType: u8,
    pub bmAttributes: u32,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBDeviceCapabilityUSB2Extension {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBDeviceCapabilityUSB2Extension",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBDeviceCapabilityUSB2Extension {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbusb20extensioncapabilitylpm?language=objc)
pub const kIOUSBUSB20ExtensionCapabilityLPM: c_uint = IOUSBBit!(1);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbusb20extensioncapabilitybeslsupport?language=objc)
pub const kIOUSBUSB20ExtensionCapabilityBESLSupport: c_uint = IOUSBBit!(2);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbusb20extensioncapabilitybeslvalid?language=objc)
pub const kIOUSBUSB20ExtensionCapabilityBESLValid: c_uint = IOUSBBit!(3);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbusb20extensioncapabilitybesldvalid?language=objc)
pub const kIOUSBUSB20ExtensionCapabilityBESLDValid: c_uint = IOUSBBit!(4);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbusb20extensioncapabilitybesl?language=objc)
pub const kIOUSBUSB20ExtensionCapabilityBESL: c_uint = IOUSBBitRange!(8, 11);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbusb20extensioncapabilitybeslphase?language=objc)
pub const kIOUSBUSB20ExtensionCapabilityBESLPhase: c_uint = IOUSBBitRangePhase!(8, 11);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbusb20extensioncapabilitybesld?language=objc)
pub const kIOUSBUSB20ExtensionCapabilityBESLD: c_uint = IOUSBBitRange!(12, 15);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbusb20extensioncapabilitybesldphase?language=objc)
pub const kIOUSBUSB20ExtensionCapabilityBESLDPhase: c_uint = IOUSBBitRangePhase!(12, 15);

/// Device Capability SuperSpeed USB. USB 3.0 9.6.2.2: SuperSpeed USB Device Capability
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicecapabilitysuperspeedusb?language=objc)
#[repr(C, packed)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceCapabilitySuperSpeedUSB {
    pub bLength: u8,
    pub bDescriptorType: u8,
    pub bDevCapabilityType: u8,
    pub bmAttributes: u8,
    pub wSpeedsSupported: u16,
    pub bFunctionalitySupport: u8,
    pub bU1DevExitLat: u8,
    pub wU2DevExitLat: u16,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBDeviceCapabilitySuperSpeedUSB {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBDeviceCapabilitySuperSpeedUSB",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBDeviceCapabilitySuperSpeedUSB {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeeddevicecapabilityltm?language=objc)
pub const kIOUSBSuperSpeedDeviceCapabilityLTM: c_uint = IOUSBBit!(1);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeeddevicecapabilitylowspeed?language=objc)
pub const kIOUSBSuperSpeedDeviceCapabilityLowSpeed: c_uint = IOUSBBit!(0);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeeddevicecapabilityfullspeed?language=objc)
pub const kIOUSBSuperSpeedDeviceCapabilityFullSpeed: c_uint = IOUSBBit!(1);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeeddevicecapabilityhighspeed?language=objc)
pub const kIOUSBSuperSpeedDeviceCapabilityHighSpeed: c_uint = IOUSBBit!(2);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeeddevicecapability5gb?language=objc)
pub const kIOUSBSuperSpeedDeviceCapability5Gb: c_uint = IOUSBBit!(3);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeeddevicecapabilitysupportlowspeed?language=objc)
pub const kIOUSBSuperSpeedDeviceCapabilitySupportLowSpeed: c_uint = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeeddevicecapabilitysupportfullspeed?language=objc)
pub const kIOUSBSuperSpeedDeviceCapabilitySupportFullSpeed: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeeddevicecapabilitysupporthighspeed?language=objc)
pub const kIOUSBSuperSpeedDeviceCapabilitySupportHighSpeed: c_uint = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeeddevicecapabilitysupport5gb?language=objc)
pub const kIOUSBSuperSpeedDeviceCapabilitySupport5Gb: c_uint = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeeddevicecapabilityu1devexitlatmax?language=objc)
pub const kIOUSBSuperSpeedDeviceCapabilityU1DevExitLatMax: c_uint = 0xa;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeeddevicecapabilityu2devexitlatmax?language=objc)
pub const kIOUSBSuperSpeedDeviceCapabilityU2DevExitLatMax: c_uint = 0x7ff;

/// Device Capability SuperSpeedPlus USB.
/// USB 3.1 9.6.2.5: SuperSpeedPlus USB Device Capability
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicecapabilitysuperspeedplususb?language=objc)
#[repr(C, packed)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceCapabilitySuperSpeedPlusUSB {
    pub bLength: u8,
    pub bDescriptorType: u8,
    pub bDevCapabilityType: u8,
    pub bReserved: u8,
    pub bmAttributes: u32,
    pub wFunctionalitySupport: u16,
    pub wReserved: u16,
    pub bmSublinkSpeedAttr: *mut u32,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBDeviceCapabilitySuperSpeedPlusUSB {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBDeviceCapabilitySuperSpeedPlusUSB",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u32>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <*mut u32>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBDeviceCapabilitySuperSpeedPlusUSB {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinkspeedattrcount?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkSpeedAttrCount: c_uint = IOUSBBitRange!(0, 4);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinkspeedattrcountphase?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkSpeedAttrCountPhase: c_uint =
    IOUSBBitRangePhase!(0, 4);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinkspeedidcount?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkSpeedIdCount: c_uint = IOUSBBitRange!(5, 8);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinkspeedidcountphase?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkSpeedIdCountPhase: c_uint =
    IOUSBBitRangePhase!(5, 8);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinkminspeedid?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkMinSpeedId: c_uint = IOUSBBitRange!(0, 3);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinkminspeedidphase?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkMinSpeedIdPhase: c_uint =
    IOUSBBitRangePhase!(0, 3);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilityreserved?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilityReserved: c_uint = IOUSBBitRange!(4, 7);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilityreservedphase?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilityReservedPhase: c_uint = IOUSBBitRangePhase!(4, 7);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilityminrxlanecount?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilityMinRxLaneCount: c_uint = IOUSBBitRange!(8, 11);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilityminrxlanecountphase?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilityMinRxLaneCountPhase: c_uint =
    IOUSBBitRangePhase!(8, 11);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitymintxlanecount?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilityMinTxLaneCount: c_uint = IOUSBBitRange!(12, 15);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitymintxlanecountphase?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilityMinTxLaneCountPhase: c_uint =
    IOUSBBitRangePhase!(12, 15);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinkspeedid?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkSpeedId: c_uint = IOUSBBitRange!(0, 3);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinkspeedidphase?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkSpeedIdPhase: c_uint =
    IOUSBBitRangePhase!(0, 3);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinklse?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkLSE: c_uint = IOUSBBitRange!(4, 5);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinklsephase?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkLSEPhase: c_uint = IOUSBBitRangePhase!(4, 5);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinklsebits?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkLSEBits: c_uint =
    0 << kIOUSBSuperSpeedPlusDeviceCapabilitySublinkLSEPhase;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinklsekbits?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkLSEKbits: c_uint =
    1 << kIOUSBSuperSpeedPlusDeviceCapabilitySublinkLSEPhase;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinklsembits?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkLSEMbits: c_uint =
    2 << kIOUSBSuperSpeedPlusDeviceCapabilitySublinkLSEPhase;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinklsegbits?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkLSEGbits: c_uint =
    3 << kIOUSBSuperSpeedPlusDeviceCapabilitySublinkLSEPhase;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinktype?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkType: c_uint = IOUSBBitRange!(6, 7);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinktypephase?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkTypePhase: c_uint = IOUSBBitRangePhase!(6, 7);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinksymmetry?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkSymmetry: c_uint = IOUSBBit!(6);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinksymmetryphase?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkSymmetryPhase: c_uint =
    IOUSBBitRangePhase!(6, 6);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinksymmetric?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkSymmetric: c_uint =
    0 << kIOUSBSuperSpeedPlusDeviceCapabilitySublinkSymmetryPhase;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinkasymmetric?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkAsymmetric: c_uint =
    1 << kIOUSBSuperSpeedPlusDeviceCapabilitySublinkSymmetryPhase;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinkdirection?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkDirection: c_uint = IOUSBBit!(7);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinkdirectionphase?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkDirectionPhase: c_uint =
    IOUSBBitRangePhase!(7, 7);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinkdirectionrx?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkDirectionRx: c_uint =
    0 << kIOUSBSuperSpeedPlusDeviceCapabilitySublinkDirectionPhase;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinkdirectiontx?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkDirectionTx: c_uint =
    1 << kIOUSBSuperSpeedPlusDeviceCapabilitySublinkDirectionPhase;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinkreserved?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkReserved: c_uint = IOUSBBitRange!(8, 13);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinkreservedphase?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkReservedPhase: c_uint =
    IOUSBBitRangePhase!(8, 13);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinkprotocol?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkProtocol: c_uint = IOUSBBitRange!(14, 15);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinkprotocolphase?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkProtocolPhase: c_uint =
    IOUSBBitRangePhase!(14, 15);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinkspeedmantissa?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkSpeedMantissa: c_uint = IOUSBBitRange!(16, 31);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedplusdevicecapabilitysublinkspeedmantissaphase?language=objc)
pub const kIOUSBSuperSpeedPlusDeviceCapabilitySublinkSpeedMantissaPhase: c_uint =
    IOUSBBitRangePhase!(16, 31);

/// Device Capability Container ID.
/// USB 3.0 9.6.2.3: Container ID
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicecapabilitycontainerid?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceCapabilityContainerID {
    pub bLength: u8,
    pub bDescriptorType: u8,
    pub bDevCapabilityType: u8,
    pub bReservedID: u8,
    pub containerID: [u8; 16],
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBDeviceCapabilityContainerID {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBDeviceCapabilityContainerID",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <[u8; 16]>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBDeviceCapabilityContainerID {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Device Capability Platform Descriptor.
/// USB 3.1 9.6.2.4: Platform Descriptor
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbplatformcapabilitydescriptor?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBPlatformCapabilityDescriptor {
    pub bLength: u8,
    pub bDescriptorType: u8,
    pub bDevCapabilityType: u8,
    pub bReserved: u8,
    pub PlatformCapabilityUUID: uuid_t,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBPlatformCapabilityDescriptor {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBPlatformCapabilityDescriptor",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <uuid_t>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBPlatformCapabilityDescriptor {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Device Capability Billboard Alternate Setting Info.
/// USB Billboard 3.1.6.2: Billboard Capability Descriptor V1.2
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicecapabilitybillboardaltconfigcompatibility?language=objc)
#[repr(C, packed)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceCapabilityBillboardAltConfigCompatibility {
    pub wSVID: u16,
    pub dwAlternateMode: u32,
    pub iAlternateModeString: u8,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBDeviceCapabilityBillboardAltConfigCompatibility {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBDeviceCapabilityBillboardAltConfigCompatibility",
        &[<u16>::ENCODING, <u32>::ENCODING, <u8>::ENCODING],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBDeviceCapabilityBillboardAltConfigCompatibility {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Device Capability Billboard Alternate Setting Info.
/// USB Billboard 3.1.6.2: Billboard Capability Descriptor V1.1 and 1.21+
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicecapabilitybillboardaltconfig?language=objc)
#[repr(C, packed)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceCapabilityBillboardAltConfig {
    pub wSVID: u16,
    pub bAltenateMode: u8,
    pub iAlternateModeString: u8,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBDeviceCapabilityBillboardAltConfig {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBDeviceCapabilityBillboardAltConfig",
        &[<u16>::ENCODING, <u8>::ENCODING, <u8>::ENCODING],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBDeviceCapabilityBillboardAltConfig {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Device Capability Billboard.
/// USB Billboard 3.1.6.2: Billboard Capability Descriptor
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicecapabilitybillboard?language=objc)
#[repr(C, packed)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceCapabilityBillboard {
    pub bLength: u8,
    pub bDescriptorType: u8,
    pub bDevCapabilityType: u8,
    pub iAdditionalInfoURL: u8,
    pub bNumberOfAlternateModes: u8,
    pub bPreferredAlternateMode: u8,
    pub vCONNPower: u16,
    pub bmConfigured: [u8; 32],
    pub bcdVersion: u16,
    pub bAdditionalFailureInfo: u8,
    pub bReserved: u8,
    pub pAltConfigurations: *mut IOUSBDeviceCapabilityBillboardAltConfig,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBDeviceCapabilityBillboard {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBDeviceCapabilityBillboard",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
            <[u8; 32]>::ENCODING,
            <u16>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <*mut IOUSBDeviceCapabilityBillboardAltConfig>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBDeviceCapabilityBillboard {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Device Capability Billboard Alternate mode.
/// USB Billboard 3.1.6.3: Billboard Capability Descriptor V1.21
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicecapabilitybillboardaltmode?language=objc)
#[repr(C, packed)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceCapabilityBillboardAltMode {
    pub bLength: u8,
    pub bDescriptorType: u8,
    pub bDevCapabilityType: u8,
    pub bIndex: u8,
    pub dwAlternateModeVdo: u16,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBDeviceCapabilityBillboardAltMode {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBDeviceCapabilityBillboardAltMode",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBDeviceCapabilityBillboardAltMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// USB Inerface Association Descriptor.  ECN to the USB 2.0 Spec.
/// See the USB Specification at
/// <a href="http://www.usb.org" target="_blank">
/// http://www.usb.org
/// </a>
/// .
/// USB 3.0 9.6.4: Interface Association
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbinterfaceassociationdescriptor?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBInterfaceAssociationDescriptor {
    pub bLength: u8,
    pub bDescriptorType: u8,
    pub bFirstInterface: u8,
    pub bInterfaceCount: u8,
    pub bFunctionClass: u8,
    pub bFunctionSubClass: u8,
    pub bFunctionProtocol: u8,
    pub iFunction: u8,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBInterfaceAssociationDescriptor {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBInterfaceAssociationDescriptor",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBInterfaceAssociationDescriptor {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Descriptor for a SuperSpeed USB Endpoint Companion.
/// See the USB Specification at
/// <a href="http://www.usb.org" TARGET="_blank">
/// http://www.usb.org
/// </a>
/// .
/// USB 3.1 9.6.7: SuperSpeed Endpoint Companion
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbsuperspeedendpointcompaniondescriptor?language=objc)
#[repr(C, packed)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBSuperSpeedEndpointCompanionDescriptor {
    pub bLength: u8,
    pub bDescriptorType: u8,
    pub bMaxBurst: u8,
    pub bmAttributes: u8,
    pub wBytesPerInterval: u16,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBSuperSpeedEndpointCompanionDescriptor {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBSuperSpeedEndpointCompanionDescriptor",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBSuperSpeedEndpointCompanionDescriptor {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedendpointcompaniondescriptormaxburst?language=objc)
pub const kIOUSBSuperSpeedEndpointCompanionDescriptorMaxBurst: c_uint = IOUSBBitRange!(0, 4);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedendpointcompaniondescriptormaxburstphase?language=objc)
pub const kIOUSBSuperSpeedEndpointCompanionDescriptorMaxBurstPhase: c_uint =
    IOUSBBitRangePhase!(0, 4);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedendpointcompaniondescriptorbulkmaxstreams?language=objc)
pub const kIOUSBSuperSpeedEndpointCompanionDescriptorBulkMaxStreams: c_uint = IOUSBBitRange!(0, 4);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedendpointcompaniondescriptorbulkmaxstreamsphase?language=objc)
pub const kIOUSBSuperSpeedEndpointCompanionDescriptorBulkMaxStreamsPhase: c_uint =
    IOUSBBitRangePhase!(0, 4);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedendpointcompaniondescriptorbulkreserved?language=objc)
pub const kIOUSBSuperSpeedEndpointCompanionDescriptorBulkReserved: c_uint = IOUSBBitRange!(5, 7);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedendpointcompaniondescriptorbulkreservedphase?language=objc)
pub const kIOUSBSuperSpeedEndpointCompanionDescriptorBulkReservedPhase: c_uint =
    IOUSBBitRangePhase!(5, 7);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedendpointcompaniondescriptorisocmult?language=objc)
pub const kIOUSBSuperSpeedEndpointCompanionDescriptorIsocMult: c_uint = IOUSBBitRange!(0, 1);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedendpointcompaniondescriptorisocmultphase?language=objc)
pub const kIOUSBSuperSpeedEndpointCompanionDescriptorIsocMultPhase: c_uint =
    IOUSBBitRangePhase!(0, 1);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedendpointcompaniondescriptorisocreserved?language=objc)
pub const kIOUSBSuperSpeedEndpointCompanionDescriptorIsocReserved: c_uint = IOUSBBitRange!(2, 6);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedendpointcompaniondescriptorisocreservedphase?language=objc)
pub const kIOUSBSuperSpeedEndpointCompanionDescriptorIsocReservedPhase: c_uint =
    IOUSBBitRangePhase!(2, 6);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedendpointcompaniondescriptorsspisoccompanion?language=objc)
pub const kIOUSBSuperSpeedEndpointCompanionDescriptorSSPIsocCompanion: c_uint = IOUSBBit!(7);

/// Descriptor for a SuperSpeedPlus Isochronout USB Endpoint Companion.
/// See the USB Specification at
/// <a href="http://www.usb.org" TARGET="_blank">
/// http://www.usb.org
/// </a>
/// .
/// USB 3.1 9.6.8: SuperSpeedPlus Isochronous Endpoint Companion
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbsuperspeedplusisochronousendpointcompaniondescriptor?language=objc)
#[repr(C, packed)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBSuperSpeedPlusIsochronousEndpointCompanionDescriptor {
    pub bLength: u8,
    pub bDescriptorType: u8,
    pub wReserved: u16,
    pub dwBytesPerInterval: u32,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBSuperSpeedPlusIsochronousEndpointCompanionDescriptor {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBSuperSpeedPlusIsochronousEndpointCompanionDescriptor",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBSuperSpeedPlusIsochronousEndpointCompanionDescriptor {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Descriptor for a USB hub.
/// See the USB Specification at
/// <a href="http://www.usb.org" TARGET="_blank">
/// http://www.usb.org
/// </a>
/// .
/// USB 2.0 11.23.2.1: Hub Descriptor
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousb20hubdescriptor?language=objc)
#[repr(C, packed)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSB20HubDescriptor {
    pub bLength: u8,
    pub bDescriptorType: u8,
    pub bNumberPorts: u8,
    pub wHubCharacteristics: u16,
    pub bPowerOnToPowerGood: u8,
    pub bHubControllerCurrent: u8,
    pub deviceRemovable: [u8; 2],
    pub reserved: [u8; 2],
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSB20HubDescriptor {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSB20HubDescriptor",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <[u8; 2]>::ENCODING,
            <[u8; 2]>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSB20HubDescriptor {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Descriptor for a Super Speed USB hub.
/// See the USB Specification at
/// <a href="http://www.usb.org" TARGET="_blank">
/// http://www.usb.org
/// </a>
/// .
/// USB 3.0 10.13.2.1: SuperSpeed Hub Descriptor
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbsuperspeedhubdescriptor?language=objc)
#[repr(C, packed)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBSuperSpeedHubDescriptor {
    pub bLength: u8,
    pub bDescriptorType: u8,
    pub bNumberPorts: u8,
    pub wHubCharacteristics: u16,
    pub bPowerOnToPowerGood: u8,
    pub bHubControllerCurrent: u8,
    pub bHubDecodeLatency: u8,
    pub wHubDelay: u16,
    pub deviceRemovable: u16,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBSuperSpeedHubDescriptor {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBSuperSpeedHubDescriptor",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBSuperSpeedHubDescriptor {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedhubcharacteristicspowerswitchingmask?language=objc)
pub const kIOUSBSuperSpeedHubCharacteristicsPowerSwitchingMask: c_uint = IOUSBBitRange!(0, 1);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedhubcharacteristicspowerswitchingganged?language=objc)
pub const kIOUSBSuperSpeedHubCharacteristicsPowerSwitchingGanged: c_uint =
    0 << IOUSBBitRangePhase!(0, 1);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedhubcharacteristicspowerswitchingindividual?language=objc)
pub const kIOUSBSuperSpeedHubCharacteristicsPowerSwitchingIndividual: c_uint =
    1 << IOUSBBitRangePhase!(0, 1);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedhubcharacteristicscompounddevice?language=objc)
pub const kIOUSBSuperSpeedHubCharacteristicsCompoundDevice: c_uint = IOUSBBit!(2);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedhubcharacteristicsovercurrentmask?language=objc)
pub const kIOUSBSuperSpeedHubCharacteristicsOverCurrentMask: c_uint = IOUSBBitRange!(3, 4);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedhubcharacteristicsovercurrentglobal?language=objc)
pub const kIOUSBSuperSpeedHubCharacteristicsOverCurrentGlobal: c_uint =
    0 << IOUSBBitRangePhase!(3, 4);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedhubcharacteristicsovercurrentindividual?language=objc)
pub const kIOUSBSuperSpeedHubCharacteristicsOverCurrentIndividual: c_uint =
    1 << IOUSBBitRangePhase!(3, 4);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedhubcharacteristicsreserved?language=objc)
pub const kIOUSBSuperSpeedHubCharacteristicsReserved: c_uint = IOUSBBitRange!(5, 15);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedhubdecodelatencymax?language=objc)
pub const kIOUSBSuperSpeedHubDecodeLatencyMax: c_uint = 10;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbsuperspeedhubdelaymax?language=objc)
pub const kIOUSBSuperSpeedHubDelayMax: c_uint = 400;

/// Structure used to specify the Mass Storage Specific UAS pipe usage descriptor
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/uaspipedescriptor?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct UASPipeDescriptor {
    pub bLength: u8,
    pub bDescriptorType: u8,
    pub bPipeID: u8,
    pub bReserved: u8,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for UASPipeDescriptor {
    const ENCODING: Encoding = Encoding::Struct(
        "UASPipeDescriptor",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for UASPipeDescriptor {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// USB HID Descriptor.  See the USB HID Specification at
/// <a href="http://www.usb.org" target="_blank">
/// http://www.usb.org
/// </a>
/// .
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbhiddescriptor?language=objc)
#[repr(C, packed)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBHIDDescriptor {
    pub descLen: u8,
    pub descType: u8,
    pub descVersNum: u16,
    pub hidCountryCode: u8,
    pub hidNumDescriptors: u8,
    pub hidDescriptorType: u8,
    pub hidDescriptorLengthLo: u8,
    pub hidDescriptorLengthHi: u8,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBHIDDescriptor {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBHIDDescriptor",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBHIDDescriptor {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// USB HID Report Descriptor header.  See the USB HID Specification at
/// <a href="http://www.usb.org" target="_blank">
/// http://www.usb.org
/// </a>
/// .
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbhidreportdesc?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBHIDReportDesc {
    pub hidDescriptorType: u8,
    pub hidDescriptorLengthLo: u8,
    pub hidDescriptorLengthHi: u8,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBHIDReportDesc {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBHIDReportDesc",
        &[<u8>::ENCODING, <u8>::ENCODING, <u8>::ENCODING],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBHIDReportDesc {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// USB Device Firmware Update Descriptor. See the USB Device Firmware Update
/// Specification at
/// <a href="http://www.usb.org" target="_blank">
/// http://www.usb.org
/// </a>
/// .
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdfudescriptor?language=objc)
#[repr(C, packed)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDFUDescriptor {
    pub bLength: u8,
    pub bDescriptorType: u8,
    pub bmAttributes: u8,
    pub wDetachTimeout: u16,
    pub wTransferSize: u16,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBDFUDescriptor {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBDFUDescriptor",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBDFUDescriptor {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Standard device request.
/// See the USB Specification at
/// <a href="http://www.usb.org" TARGET="_blank">
/// http://www.usb.org
/// </a>
/// .
/// USB 2.0 9.3: USB Device Requests
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicerequest?language=objc)
#[repr(C, packed)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceRequest {
    pub bmRequestType: u8,
    pub bRequest: u8,
    pub wValue: u16,
    pub wIndex: u16,
    pub wLength: u16,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBDeviceRequest {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBDeviceRequest",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBDeviceRequest {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// See the USB Specification at
/// <a href="http://www.usb.org" TARGET="_blank">
/// http://www.usb.org
/// </a>
/// .
/// USB 3.0 9.4.12: Set SEL Standard Device Request
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbdevicerequestsetseldata?language=objc)
#[repr(C, packed)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSBDeviceRequestSetSELData {
    pub u1Sel: u8,
    pub u1Pel: u8,
    pub u2Sel: u16,
    pub u2Pel: u16,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSBDeviceRequestSetSELData {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSBDeviceRequestSetSELData",
        &[
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSBDeviceRequestSetSELData {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Values of 'direction' field of a device request
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/tiousbdevicerequestdirectionvalue?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct tIOUSBDeviceRequestDirectionValue(pub c_uint);
impl tIOUSBDeviceRequestDirectionValue {
    #[doc(alias = "kIOUSBDeviceRequestDirectionValueOut")]
    pub const IOUSBDeviceRequestDirectionValueOut: Self = Self(0);
    #[doc(alias = "kIOUSBDeviceRequestDirectionValueIn")]
    pub const IOUSBDeviceRequestDirectionValueIn: Self = Self(1);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for tIOUSBDeviceRequestDirectionValue {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for tIOUSBDeviceRequestDirectionValue {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Values of 'type' field of a device request
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/tiousbdevicerequesttypevalue?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct tIOUSBDeviceRequestTypeValue(pub c_uint);
impl tIOUSBDeviceRequestTypeValue {
    #[doc(alias = "kIOUSBDeviceRequestTypeValueStandard")]
    pub const IOUSBDeviceRequestTypeValueStandard: Self = Self(0);
    #[doc(alias = "kIOUSBDeviceRequestTypeValueClass")]
    pub const IOUSBDeviceRequestTypeValueClass: Self = Self(1);
    #[doc(alias = "kIOUSBDeviceRequestTypeValueVendor")]
    pub const IOUSBDeviceRequestTypeValueVendor: Self = Self(2);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for tIOUSBDeviceRequestTypeValue {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for tIOUSBDeviceRequestTypeValue {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Values of 'recipient' field of a device request
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/tiousbdevicerequestrecipientvalue?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct tIOUSBDeviceRequestRecipientValue(pub c_uint);
impl tIOUSBDeviceRequestRecipientValue {
    #[doc(alias = "kIOUSBDeviceRequestRecipientValueDevice")]
    pub const IOUSBDeviceRequestRecipientValueDevice: Self = Self(0);
    #[doc(alias = "kIOUSBDeviceRequestRecipientValueInterface")]
    pub const IOUSBDeviceRequestRecipientValueInterface: Self = Self(1);
    #[doc(alias = "kIOUSBDeviceRequestRecipientValueEndpoint")]
    pub const IOUSBDeviceRequestRecipientValueEndpoint: Self = Self(2);
    #[doc(alias = "kIOUSBDeviceRequestRecipientValueOther")]
    pub const IOUSBDeviceRequestRecipientValueOther: Self = Self(3);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for tIOUSBDeviceRequestRecipientValue {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for tIOUSBDeviceRequestRecipientValue {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/tiousbdevicerequest?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct tIOUSBDeviceRequest(pub c_uint);
impl tIOUSBDeviceRequest {
    #[doc(alias = "kIOUSBDeviceRequestSize")]
    pub const IOUSBDeviceRequestSize: Self = Self(8);
    #[doc(alias = "kIOUSBDeviceRequestDirectionMask")]
    pub const IOUSBDeviceRequestDirectionMask: Self = Self(IOUSBBit!(7));
    #[doc(alias = "kIOUSBDeviceRequestDirectionPhase")]
    pub const IOUSBDeviceRequestDirectionPhase: Self = Self(IOUSBBitRangePhase!(7, 7));
    #[doc(alias = "kIOUSBDeviceRequestDirectionOut")]
    pub const IOUSBDeviceRequestDirectionOut: Self = Self(
        tIOUSBDeviceRequestDirectionValue::IOUSBDeviceRequestDirectionValueOut.0
            << tIOUSBDeviceRequest::IOUSBDeviceRequestDirectionPhase.0,
    );
    #[doc(alias = "kIOUSBDeviceRequestDirectionIn")]
    pub const IOUSBDeviceRequestDirectionIn: Self = Self(
        tIOUSBDeviceRequestDirectionValue::IOUSBDeviceRequestDirectionValueIn.0
            << tIOUSBDeviceRequest::IOUSBDeviceRequestDirectionPhase.0,
    );
    #[doc(alias = "kIOUSBDeviceRequestTypeMask")]
    pub const IOUSBDeviceRequestTypeMask: Self = Self(IOUSBBitRange!(5, 6));
    #[doc(alias = "kIOUSBDeviceRequestTypePhase")]
    pub const IOUSBDeviceRequestTypePhase: Self = Self(IOUSBBitRangePhase!(5, 6));
    #[doc(alias = "kIOUSBDeviceRequestTypeStandard")]
    pub const IOUSBDeviceRequestTypeStandard: Self = Self(
        tIOUSBDeviceRequestTypeValue::IOUSBDeviceRequestTypeValueStandard.0
            << tIOUSBDeviceRequest::IOUSBDeviceRequestTypePhase.0,
    );
    #[doc(alias = "kIOUSBDeviceRequestTypeClass")]
    pub const IOUSBDeviceRequestTypeClass: Self = Self(
        tIOUSBDeviceRequestTypeValue::IOUSBDeviceRequestTypeValueClass.0
            << tIOUSBDeviceRequest::IOUSBDeviceRequestTypePhase.0,
    );
    #[doc(alias = "kIOUSBDeviceRequestTypeVendor")]
    pub const IOUSBDeviceRequestTypeVendor: Self = Self(
        tIOUSBDeviceRequestTypeValue::IOUSBDeviceRequestTypeValueVendor.0
            << tIOUSBDeviceRequest::IOUSBDeviceRequestTypePhase.0,
    );
    #[doc(alias = "kIOUSBDeviceRequestRecipientMask")]
    pub const IOUSBDeviceRequestRecipientMask: Self = Self(IOUSBBitRange!(0, 4));
    #[doc(alias = "kIOUSBDeviceRequestRecipientPhase")]
    pub const IOUSBDeviceRequestRecipientPhase: Self = Self(IOUSBBitRangePhase!(0, 4));
    #[doc(alias = "kIOUSBDeviceRequestRecipientDevice")]
    pub const IOUSBDeviceRequestRecipientDevice: Self = Self(
        tIOUSBDeviceRequestRecipientValue::IOUSBDeviceRequestRecipientValueDevice.0
            << tIOUSBDeviceRequest::IOUSBDeviceRequestRecipientPhase.0,
    );
    #[doc(alias = "kIOUSBDeviceRequestRecipientInterface")]
    pub const IOUSBDeviceRequestRecipientInterface: Self = Self(
        tIOUSBDeviceRequestRecipientValue::IOUSBDeviceRequestRecipientValueInterface.0
            << tIOUSBDeviceRequest::IOUSBDeviceRequestRecipientPhase.0,
    );
    #[doc(alias = "kIOUSBDeviceRequestRecipientEndpoint")]
    pub const IOUSBDeviceRequestRecipientEndpoint: Self = Self(
        tIOUSBDeviceRequestRecipientValue::IOUSBDeviceRequestRecipientValueEndpoint.0
            << tIOUSBDeviceRequest::IOUSBDeviceRequestRecipientPhase.0,
    );
    #[doc(alias = "kIOUSBDeviceRequestRecipientOther")]
    pub const IOUSBDeviceRequestRecipientOther: Self = Self(
        tIOUSBDeviceRequestRecipientValue::IOUSBDeviceRequestRecipientValueOther.0
            << tIOUSBDeviceRequest::IOUSBDeviceRequestRecipientPhase.0,
    );
}

#[cfg(feature = "objc2")]
unsafe impl Encode for tIOUSBDeviceRequest {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for tIOUSBDeviceRequest {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicerequestgetstatus?language=objc)
pub const kIOUSBDeviceRequestGetStatus: c_uint = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicerequestclearfeature?language=objc)
pub const kIOUSBDeviceRequestClearFeature: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicerequestgetstate?language=objc)
pub const kIOUSBDeviceRequestGetState: c_uint = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicerequestsetfeature?language=objc)
pub const kIOUSBDeviceRequestSetFeature: c_uint = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicerequestsetaddress?language=objc)
pub const kIOUSBDeviceRequestSetAddress: c_uint = 5;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicerequestgetdescriptor?language=objc)
pub const kIOUSBDeviceRequestGetDescriptor: c_uint = 6;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicerequestsetdescriptor?language=objc)
pub const kIOUSBDeviceRequestSetDescriptor: c_uint = 7;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicerequestgetconfiguration?language=objc)
pub const kIOUSBDeviceRequestGetConfiguration: c_uint = 8;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicerequestsetconfiguration?language=objc)
pub const kIOUSBDeviceRequestSetConfiguration: c_uint = 9;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicerequestgetinterface?language=objc)
pub const kIOUSBDeviceRequestGetInterface: c_uint = 10;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicerequestsetinterface?language=objc)
pub const kIOUSBDeviceRequestSetInterface: c_uint = 11;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicerequestsynchframe?language=objc)
pub const kIOUSBDeviceRequestSynchFrame: c_uint = 12;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicerequestsetsel?language=objc)
pub const kIOUSBDeviceRequestSetSel: c_uint = 48;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicerequestsetisochronousdelay?language=objc)
pub const kIOUSBDeviceRequestSetIsochronousDelay: c_uint = 49;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicestatusselfpowered?language=objc)
pub const kIOUSBDeviceStatusSelfPowered: c_uint = IOUSBBit!(0);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicestatusremotewakeenable?language=objc)
pub const kIOUSBDeviceStatusRemoteWakeEnable: c_uint = IOUSBBit!(1);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicestatusu1enable?language=objc)
pub const kIOUSBDeviceStatusU1Enable: c_uint = IOUSBBit!(2);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicestatusu2enable?language=objc)
pub const kIOUSBDeviceStatusU2Enable: c_uint = IOUSBBit!(3);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicestatusltmenable?language=objc)
pub const kIOUSBDeviceStatusLTMEnable: c_uint = IOUSBBit!(4);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbinterfacestatusremotewakecapable?language=objc)
pub const kIOUSBInterfaceStatusRemoteWakeCapable: c_uint = IOUSBBit!(0);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbinterfacestatusremotewakeenable?language=objc)
pub const kIOUSBInterfaceStatusRemoteWakeEnable: c_uint = IOUSBBit!(1);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbendpointstatushalt?language=objc)
pub const IOUSBEndpointStatusHalt: c_uint = IOUSBBit!(0);

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicefeatureselectorremotewakeup?language=objc)
pub const kIOUSBDeviceFeatureSelectorRemoteWakeup: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicefeatureselectortestmode?language=objc)
pub const kIOUSBDeviceFeatureSelectorTestMode: c_uint = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicefeatureselectoru1enable?language=objc)
pub const kIOUSBDeviceFeatureSelectorU1Enable: c_uint = 48;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicefeatureselectoru2enable?language=objc)
pub const kIOUSBDeviceFeatureSelectorU2Enable: c_uint = 49;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbdevicefeatureselectorltmenable?language=objc)
pub const kIOUSBDeviceFeatureSelectorLTMEnable: c_uint = 50;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbinterfacefeatureselectorsuspend?language=objc)
pub const kIOUSBInterfaceFeatureSelectorSuspend: c_uint = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/iousbendpointfeatureselectorstall?language=objc)
pub const IOUSBEndpointFeatureSelectorStall: c_uint = 0;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbinterfacesuspendlowpower?language=objc)
pub const kIOUSBInterfaceSuspendLowPower: c_uint = IOUSBBit!(0);
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbinterfacesuspendremotewakeenable?language=objc)
pub const kIOUSBInterfaceSuspendRemoteWakeEnable: c_uint = IOUSBBit!(1);

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbhubport2portexitlatencyns?language=objc)
pub const kIOUSBHubPort2PortExitLatencyNs: c_uint = 1000;
/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbhubdelayns?language=objc)
pub const kIOUSBHubDelayNs: c_uint = 400;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousbpingresponsetimens?language=objc)
pub const kIOUSBPingResponseTimeNs: c_uint = 400;

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/tiousbbusvoltage?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct tIOUSBBusVoltage(pub c_uint);
impl tIOUSBBusVoltage {
    #[doc(alias = "kIOUSBBusVoltageDefault")]
    pub const IOUSBBusVoltageDefault: Self = Self(5);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for tIOUSBBusVoltage {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for tIOUSBBusVoltage {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/tiousb20buscurrent?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct tIOUSB20BusCurrent(pub c_uint);
impl tIOUSB20BusCurrent {
    #[doc(alias = "kIOUSB20BusCurrentMinimum")]
    pub const IOUSB20BusCurrentMinimum: Self = Self(100);
    #[doc(alias = "kIOUSB20BusCurrentDefault")]
    pub const IOUSB20BusCurrentDefault: Self = Self(500);
    #[doc(alias = "kIOUSB20BusCurrentMaxPowerUnits")]
    pub const IOUSB20BusCurrentMaxPowerUnits: Self = Self(2);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for tIOUSB20BusCurrent {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for tIOUSB20BusCurrent {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/tiousb30buscurrent?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct tIOUSB30BusCurrent(pub c_uint);
impl tIOUSB30BusCurrent {
    #[doc(alias = "kIOUSB30BusCurrentMinimum")]
    pub const IOUSB30BusCurrentMinimum: Self = Self(150);
    #[doc(alias = "kIOUSB30BusCurrentDefault")]
    pub const IOUSB30BusCurrentDefault: Self = Self(900);
    #[doc(alias = "kIOUSB30BusCurrentMaxPowerUnits")]
    pub const IOUSB30BusCurrentMaxPowerUnits: Self = Self(8);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for tIOUSB30BusCurrent {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for tIOUSB30BusCurrent {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/tiousbtopology?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct tIOUSBTopology(pub c_uint);
impl tIOUSBTopology {
    #[doc(alias = "kIOUSBTopologyHost")]
    pub const IOUSBTopologyHost: Self = Self(1);
    #[doc(alias = "kIOUSBTopologyRootPort")]
    pub const IOUSBTopologyRootPort: Self = Self(2);
    #[doc(alias = "kIOUSBTopology1Hub")]
    pub const IOUSBTopology1Hub: Self = Self(3);
    #[doc(alias = "kIOUSBTopology2Hub")]
    pub const IOUSBTopology2Hub: Self = Self(4);
    #[doc(alias = "kIOUSBTopology3Hub")]
    pub const IOUSBTopology3Hub: Self = Self(5);
    #[doc(alias = "kIOUSBTopology4Hub")]
    pub const IOUSBTopology4Hub: Self = Self(6);
    #[doc(alias = "kIOUSBTopology5Hub")]
    pub const IOUSBTopology5Hub: Self = Self(7);
    #[doc(alias = "kIOUSBTopologyTierLimit")]
    pub const IOUSBTopologyTierLimit: Self = Self(tIOUSBTopology::IOUSBTopology5Hub.0);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for tIOUSBTopology {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for tIOUSBTopology {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/tiousb30resettimeout?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct tIOUSB30ResetTimeout(pub c_uint);
impl tIOUSB30ResetTimeout {
    #[doc(alias = "kIOUSB30ResetMinimumTimeout")]
    pub const IOUSB30ResetMinimumTimeout: Self = Self(80);
    #[doc(alias = "kIOUSB30ResetTypicalTimeout")]
    pub const IOUSB30ResetTypicalTimeout: Self = Self(100);
    #[doc(alias = "kIOUSB30ResetMaximumTimeout")]
    pub const IOUSB30ResetMaximumTimeout: Self = Self(120);
    #[doc(alias = "kIOUSB30ResetMaximumWithMarginTimeout")]
    pub const IOUSB30ResetMaximumWithMarginTimeout: Self = Self(150);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for tIOUSB30ResetTimeout {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for tIOUSB30ResetTimeout {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/tiousb30linkstatetimeout?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct tIOUSB30LinkStateTimeout(pub c_uint);
impl tIOUSB30LinkStateTimeout {
    #[doc(alias = "kIOUSB30LinkStateSSInactiveQuietTimeout")]
    pub const IOUSB30LinkStateSSInactiveQuietTimeout: Self = Self(12);
    #[doc(alias = "kIOUSB30LinkStateRxDetectQuietTimeout")]
    pub const IOUSB30LinkStateRxDetectQuietTimeout: Self = Self(12);
    #[doc(alias = "kIOUSB30LinkStatePollingLFPSTimeout")]
    pub const IOUSB30LinkStatePollingLFPSTimeout: Self = Self(360);
    #[doc(alias = "kIOUSB30LinkStatePollingActiveTimeout")]
    pub const IOUSB30LinkStatePollingActiveTimeout: Self = Self(12);
    #[doc(alias = "kIOUSB30LinkStatePollingConfigurationTimeout")]
    pub const IOUSB30LinkStatePollingConfigurationTimeout: Self = Self(12);
    #[doc(alias = "kIOUSB30LinkStatePollingIdleTimeout")]
    pub const IOUSB30LinkStatePollingIdleTimeout: Self = Self(2);
    #[doc(alias = "kIOUSB30LinkStateU0RecoveryTimeout")]
    pub const IOUSB30LinkStateU0RecoveryTimeout: Self = Self(1);
    #[doc(alias = "kIOUSB30LinkStateU0LTimeout")]
    pub const IOUSB30LinkStateU0LTimeout: Self = Self(0);
    #[doc(alias = "kIOUSB30LinkStateU1NoLFPSResponseTimeout")]
    pub const IOUSB30LinkStateU1NoLFPSResponseTimeout: Self = Self(2);
    #[doc(alias = "kIOUSB30LinkStateU1PingTimeout")]
    pub const IOUSB30LinkStateU1PingTimeout: Self = Self(300);
    #[doc(alias = "kIOUSB30LinkStateU2NoLFPSResponseTimeout")]
    pub const IOUSB30LinkStateU2NoLFPSResponseTimeout: Self = Self(2);
    #[doc(alias = "kIOUSB30LinKStateU2RxDetectDelay")]
    pub const IOUSB30LinKStateU2RxDetectDelay: Self = Self(100);
    #[doc(alias = "kIOUSB30LinkStateU3NoLFPSResponseTimeout")]
    pub const IOUSB30LinkStateU3NoLFPSResponseTimeout: Self = Self(10);
    #[doc(alias = "kIOUSB30LinkStateU3WakeupRetryDelay")]
    pub const IOUSB30LinkStateU3WakeupRetryDelay: Self = Self(100);
    #[doc(alias = "kIOUSB30LinkStateU3RxDetectDelay")]
    pub const IOUSB30LinkStateU3RxDetectDelay: Self = Self(100);
    #[doc(alias = "kIOUSB30LinkStateRecoveryActiveTimeout")]
    pub const IOUSB30LinkStateRecoveryActiveTimeout: Self = Self(12);
    #[doc(alias = "kIOUSB30LinkStateRecoveryConfigurationTimeout")]
    pub const IOUSB30LinkStateRecoveryConfigurationTimeout: Self = Self(6);
    #[doc(alias = "kIOUSB30LinkStateRecoveryIdleTimeout")]
    pub const IOUSB30LinkStateRecoveryIdleTimeout: Self = Self(2);
    #[doc(alias = "kIOUSB30LinkStateLoopbackExitTimeout")]
    pub const IOUSB30LinkStateLoopbackExitTimeout: Self = Self(2);
    #[doc(alias = "kIOUSB30LinkStateHotResetActiveTimeout")]
    pub const IOUSB30LinkStateHotResetActiveTimeout: Self = Self(12);
    #[doc(alias = "kIOUSB30LinkStateHotResetExitTimeout")]
    pub const IOUSB30LinkStateHotResetExitTimeout: Self = Self(2);
    #[doc(alias = "kIOUSB30LinkStatePollingDeadline")]
    pub const IOUSB30LinkStatePollingDeadline: Self = Self(
        tIOUSB30LinkStateTimeout::IOUSB30LinkStatePollingLFPSTimeout.0
            + 1
            + tIOUSB30LinkStateTimeout::IOUSB30LinkStatePollingActiveTimeout.0
            + tIOUSB30LinkStateTimeout::IOUSB30LinkStatePollingConfigurationTimeout.0
            + tIOUSB30LinkStateTimeout::IOUSB30LinkStatePollingIdleTimeout.0,
    );
    #[doc(alias = "kIOUSB30LinkStateSSResumeDeadline")]
    pub const IOUSB30LinkStateSSResumeDeadline: Self = Self(
        tIOUSB30LinkStateTimeout::IOUSB30LinkStateU3WakeupRetryDelay.0/* accomodation for retimer */+tIOUSB30LinkStateTimeout::IOUSB30LinkStateU3NoLFPSResponseTimeout.0+tIOUSB30LinkStateTimeout::IOUSB30LinkStateRecoveryActiveTimeout.0+tIOUSB30LinkStateTimeout::IOUSB30LinkStateRecoveryConfigurationTimeout.0+tIOUSB30LinkStateTimeout::IOUSB30LinkStateRecoveryIdleTimeout.0,
    );
    #[doc(alias = "kIOUSB30LinkStateRecoveryDeadline")]
    pub const IOUSB30LinkStateRecoveryDeadline: Self = Self(
        tIOUSB30LinkStateTimeout::IOUSB30LinkStateRecoveryActiveTimeout.0
            + tIOUSB30LinkStateTimeout::IOUSB30LinkStateRecoveryConfigurationTimeout.0
            + tIOUSB30LinkStateTimeout::IOUSB30LinkStateRecoveryIdleTimeout.0
            + 1, /* margin */
    );
    #[doc(alias = "kIOUSB30LinkStateHotResetDeadline")]
    pub const IOUSB30LinkStateHotResetDeadline: Self = Self(
        tIOUSB30LinkStateTimeout::IOUSB30LinkStateHotResetActiveTimeout.0
            + tIOUSB30LinkStateTimeout::IOUSB30LinkStateHotResetExitTimeout.0
            + 1,
    );
}

#[cfg(feature = "objc2")]
unsafe impl Encode for tIOUSB30LinkStateTimeout {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for tIOUSB30LinkStateTimeout {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/tiousb30devicenotificationtype?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct tIOUSB30DeviceNotificationType(pub c_uint);
impl tIOUSB30DeviceNotificationType {
    #[doc(alias = "kIOUSB30DeviceNotificationTypeFunctionWake")]
    pub const IOUSB30DeviceNotificationTypeFunctionWake: Self = Self(1);
    #[doc(alias = "kIOUSB30DeviceNotificationTypeLatencyTolerance")]
    pub const IOUSB30DeviceNotificationTypeLatencyTolerance: Self = Self(2);
    #[doc(alias = "kIOUSB30DeviceNotificationTypeBusIntervalAdjustment")]
    pub const IOUSB30DeviceNotificationTypeBusIntervalAdjustment: Self = Self(3);
    #[doc(alias = "kIOUSB30DeviceNotificationTypeHostRoleRequest")]
    pub const IOUSB30DeviceNotificationTypeHostRoleRequest: Self = Self(4);
    #[doc(alias = "kIOUSB30DeviceNotificationTypeSublinkSpeed")]
    pub const IOUSB30DeviceNotificationTypeSublinkSpeed: Self = Self(5);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for tIOUSB30DeviceNotificationType {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for tIOUSB30DeviceNotificationType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/tiousb30timingparameters?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct tIOUSB30TimingParameters(pub c_uint);
impl tIOUSB30TimingParameters {
    #[doc(alias = "kIOUSB30TimingParameterBELTDefaultNs")]
    pub const IOUSB30TimingParameterBELTDefaultNs: Self = Self(1 * 1000 * 1000);
    #[doc(alias = "kIOUSB30TimingParameterBELTMinNs")]
    pub const IOUSB30TimingParameterBELTMinNs: Self = Self(125 * 1000);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for tIOUSB30TimingParameters {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for tIOUSB30TimingParameters {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/tiousb30hubportstatuscode?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct tIOUSB30HubPortStatusCode(pub c_uint);
impl tIOUSB30HubPortStatusCode {
    #[doc(alias = "kIOUSB30HubPortStatusCodeStandard")]
    pub const IOUSB30HubPortStatusCodeStandard: Self = Self(0);
    #[doc(alias = "kIOUSB30HubPortStatusCodePD")]
    pub const IOUSB30HubPortStatusCodePD: Self = Self(1);
    #[doc(alias = "kIOUSB30HubPortStatusCodeExt")]
    pub const IOUSB30HubPortStatusCodeExt: Self = Self(2);
    #[doc(alias = "kIOUSB30HubPortStatusCodeCount")]
    pub const IOUSB30HubPortStatusCodeCount: Self = Self(3);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for tIOUSB30HubPortStatusCode {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for tIOUSB30HubPortStatusCode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/kiousb30retimerdepthlimit?language=objc)
pub const kIOUSB30RetimerDepthLimit: c_uint = 4;

/// See the USB Specification at
/// <a href="http://www.usb.org" TARGET="_blank">
/// http://www.usb.org
/// </a>
/// .
/// USB 3.1 10.16.2.6 Get Port Status
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/iokit/iousb30hubportstatusext?language=objc)
#[repr(C, packed)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct IOUSB30HubPortStatusExt {
    pub wPortStatus: u16,
    pub wPortChange: u16,
    pub dwExtPortStatus: u32,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for IOUSB30HubPortStatusExt {
    const ENCODING: Encoding = Encoding::Struct(
        "IOUSB30HubPortStatusExt",
        &[<u16>::ENCODING, <u16>::ENCODING, <u32>::ENCODING],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for IOUSB30HubPortStatusExt {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/iokit/tiousb30hubextstatus?language=objc)
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct tIOUSB30HubExtStatus(pub c_uint);
impl tIOUSB30HubExtStatus {
    #[doc(alias = "kIOUSB30HubExtStatusRxSublinkSpeedID")]
    pub const IOUSB30HubExtStatusRxSublinkSpeedID: Self = Self(IOUSBBitRange!(0, 3));
    #[doc(alias = "kIOUSB30HubExtStatusRxSublinkSpeedIDPhase")]
    pub const IOUSB30HubExtStatusRxSublinkSpeedIDPhase: Self = Self(IOUSBBitRangePhase!(0, 3));
    #[doc(alias = "kIOUSB30HubExtStatusTxSublinkSpeedID")]
    pub const IOUSB30HubExtStatusTxSublinkSpeedID: Self = Self(IOUSBBitRange!(4, 7));
    #[doc(alias = "kIOUSB30HubExtStatusTxSublinkSpeedIDPhase")]
    pub const IOUSB30HubExtStatusTxSublinkSpeedIDPhase: Self = Self(IOUSBBitRangePhase!(4, 7));
    #[doc(alias = "kIOUSB30HubExtStatusRxLaneCount")]
    pub const IOUSB30HubExtStatusRxLaneCount: Self = Self(IOUSBBitRange!(8, 11));
    #[doc(alias = "kIOUSB30HubExtStatusRxLaneCountPhase")]
    pub const IOUSB30HubExtStatusRxLaneCountPhase: Self = Self(IOUSBBitRangePhase!(8, 11));
    #[doc(alias = "kIOUSB30HubExtStatusTxLaneCount")]
    pub const IOUSB30HubExtStatusTxLaneCount: Self = Self(IOUSBBitRange!(12, 15));
    #[doc(alias = "kIOUSB30HubExtStatusTxLaneCountPhase")]
    pub const IOUSB30HubExtStatusTxLaneCountPhase: Self = Self(IOUSBBitRangePhase!(12, 15));
}

#[cfg(feature = "objc2")]
unsafe impl Encode for tIOUSB30HubExtStatus {
    const ENCODING: Encoding = c_uint::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for tIOUSB30HubExtStatus {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}
