/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.bytecode;

import java.io.IOException;
import org.gjt.jclasslib.bytecode.AbstractInstruction;
import org.gjt.jclasslib.io.ByteCodeInput;
import org.gjt.jclasslib.io.ByteCodeOutput;

public class ImmediateIntInstruction
extends AbstractInstruction {
    private int immediateInt;

    public ImmediateIntInstruction(int n) {
        super(n);
    }

    public ImmediateIntInstruction(int n, int n2) {
        super(n);
        this.immediateInt = n2;
    }

    public int getSize() {
        return super.getSize() + 4;
    }

    public int getImmediateInt() {
        return this.immediateInt;
    }

    public void setImmediateInt(int n) {
        this.immediateInt = n;
    }

    public void read(ByteCodeInput byteCodeInput) throws IOException {
        super.read(byteCodeInput);
        this.immediateInt = byteCodeInput.readInt();
    }

    public void write(ByteCodeOutput byteCodeOutput) throws IOException {
        super.write(byteCodeOutput);
        byteCodeOutput.writeInt(this.immediateInt);
    }
}

