/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.CopyUtils;
import org.eclipse.equinox.internal.p2.ui.dialogs.IUDetailsGroup;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ResolutionStatusPage;
import org.eclipse.equinox.internal.p2.ui.model.AvailableIUElement;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.internal.p2.ui.model.ProvElement;
import org.eclipse.equinox.internal.p2.ui.model.QueriedElement;
import org.eclipse.equinox.internal.p2.ui.viewers.IUComparator;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementComparer;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementContentProvider;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class ResolutionResultsWizardPage
extends ResolutionStatusPage {
    private static final String DIALOG_SETTINGS_SECTION = "ResolutionResultsPage";
    protected IUElementListRoot input;
    ProfileChangeOperation resolvedOperation;
    TreeViewer treeViewer;
    ProvElementContentProvider contentProvider;
    IUDetailsLabelProvider labelProvider;
    protected Display display;
    private IUDetailsGroup iuDetailsGroup;
    SashForm sashForm;

    protected ResolutionResultsWizardPage(ProvisioningUI ui, ProvisioningOperationWizard wizard, IUElementListRoot input, ProfileChangeOperation operation) {
        super("ResolutionPage", ui, wizard);
        this.resolvedOperation = operation;
        this.input = input == null ? new IUElementListRoot(ui) : input;
    }

    public void createControl(Composite parent) {
        this.display = parent.getDisplay();
        this.sashForm = new SashForm(parent, 512);
        FillLayout layout = new FillLayout();
        this.sashForm.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        this.sashForm.setLayoutData((Object)data);
        this.initializeDialogUnits((Control)this.sashForm);
        Composite composite = new Composite((Composite)this.sashForm, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        this.treeViewer = this.createTreeViewer(composite);
        data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)data);
        tree.setHeaderVisible(true);
        this.activateCopy((Control)tree);
        TreeViewerColumn nameColumn = new TreeViewerColumn(this.treeViewer, 16384);
        nameColumn.getColumn().setText(ProvUIMessages.ProvUI_NameColumnTitle);
        nameColumn.getColumn().setWidth(400);
        nameColumn.getColumn().setMoveable(true);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IInstallableUnit iu = ProvUI.getAdapter(element, IInstallableUnit.class);
                String label = iu.getProperty("org.eclipse.equinox.p2.name", null);
                if (label == null) {
                    label = iu.getId();
                }
                return label;
            }

            public Image getImage(Object element) {
                if (element instanceof ProvElement) {
                    return ((ProvElement)element).getImage(element);
                }
                if (ProvUI.getAdapter(element, IInstallableUnit.class) != null) {
                    return ProvUIImages.getImage("obj/iu_obj.svg");
                }
                return null;
            }

            public String getToolTipText(Object element) {
                if (element instanceof AvailableIUElement && ((AvailableIUElement)element).getImageOverlayId(null) == "obj/iu_info.svg") {
                    return ProvUIMessages.RemedyElementNotHighestVersion;
                }
                return super.getToolTipText(element);
            }
        });
        TreeViewerColumn versionColumn = new TreeViewerColumn(this.treeViewer, 16384);
        versionColumn.getColumn().setText(ProvUIMessages.ProvUI_VersionColumnTitle);
        versionColumn.getColumn().setWidth(200);
        versionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IInstallableUnit iu = ProvUI.getAdapter(element, IInstallableUnit.class);
                if (element instanceof IIUElement) {
                    if (((IIUElement)element).shouldShowVersion()) {
                        return iu.getVersion().toString();
                    }
                    return "";
                }
                return iu.getVersion().toString();
            }
        });
        TreeViewerColumn idColumn = new TreeViewerColumn(this.treeViewer, 16384);
        idColumn.getColumn().setText(ProvUIMessages.ProvUI_IdColumnTitle);
        idColumn.getColumn().setWidth(200);
        idColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IInstallableUnit iu = ProvUI.getAdapter(element, IInstallableUnit.class);
                return iu.getId();
            }
        });
        IUComparator comparator = new IUComparator(0);
        comparator.useColumnConfig(this.getColumnConfig());
        this.treeViewer.setComparator((ViewerComparator)comparator);
        this.treeViewer.setComparer((IElementComparer)new ProvElementComparer());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.contentProvider = new ProvElementContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.createSizingInfo(composite);
        this.iuDetailsGroup = new IUDetailsGroup((Composite)this.sashForm, (ISelectionProvider)this.treeViewer, this.convertWidthInCharsToPixels(80), true);
        this.setControl((Control)this.sashForm);
        this.sashForm.setWeights(this.getSashWeights());
        Dialog.applyDialogFont((Control)this.sashForm);
        Composite controlsComposite = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        controlsComposite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, false);
        controlsComposite.setLayoutData((Object)gd);
        Runnable runnable = () -> {
            this.treeViewer.addSelectionChangedListener(event -> this.setDetailText(this.resolvedOperation));
            this.setDrilldownElements(this.input, this.resolvedOperation);
            this.treeViewer.setInput((Object)this.input);
        };
        if (this.resolvedOperation != null && !this.resolvedOperation.hasResolved()) {
            try {
                this.getContainer().run(true, false, monitor -> {
                    this.resolvedOperation.resolveModal(monitor);
                    this.display.asyncExec(runnable);
                });
            }
            catch (Exception e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.equinox.p2.ui", e.getMessage(), (Throwable)e));
            }
        } else {
            runnable.run();
        }
    }

    @Override
    public void updateStatus(IUElementListRoot newRoot, ProfileChangeOperation op) {
        super.updateStatus(newRoot, op);
    }

    protected void createSizingInfo(Composite parent) {
    }

    public boolean performFinish() {
        if (this.resolvedOperation.getResolutionResult().getSeverity() != 4) {
            this.getProvisioningUI().schedule(this.resolvedOperation.getProvisioningJob(null), 3);
            return true;
        }
        return false;
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public IProvisioningPlan getCurrentPlan() {
        if (this.resolvedOperation != null) {
            return this.resolvedOperation.getProvisioningPlan();
        }
        return null;
    }

    @Override
    protected Object[] getSelectedElements() {
        return this.treeViewer.getStructuredSelection().toArray();
    }

    @Override
    protected IInstallableUnit getSelectedIU() {
        List<IInstallableUnit> units = ElementUtils.elementsToIUs(this.getSelectedElements());
        if (units.size() == 0) {
            return null;
        }
        return units.get(0);
    }

    @Override
    protected boolean shouldCompleteOnCancel() {
        return false;
    }

    protected Collection<IInstallableUnit> getIUs() {
        return ElementUtils.elementsToIUs(this.input.getChildren(this.input));
    }

    void setDrilldownElements(IUElementListRoot root, ProfileChangeOperation operation) {
        Object[] elements;
        if (operation == null || operation.getProvisioningPlan() == null) {
            return;
        }
        Object[] objectArray = elements = root.getChildren(root);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof QueriedElement) {
                ((QueriedElement)element).setQueryable(this.getQueryable(operation.getProvisioningPlan()));
            }
            ++n2;
        }
    }

    protected abstract String getOperationLabel();

    protected int getRestartPolicy() {
        return 2;
    }

    protected String getOperationTaskName() {
        return null;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        return new TreeViewer(parent, 67586);
    }

    protected abstract IQueryable<IInstallableUnit> getQueryable(IProvisioningPlan var1);

    @Override
    protected String getClipboardText(Control control) {
        return CopyUtils.getIndentedClipboardText(this.getSelectedElements(), this.labelProvider);
    }

    @Override
    protected IUDetailsGroup getDetailsGroup() {
        return this.iuDetailsGroup;
    }

    @Override
    protected boolean isCreated() {
        return this.treeViewer != null;
    }

    @Override
    protected void updateCaches(IUElementListRoot newRoot, ProfileChangeOperation op) {
        this.resolvedOperation = op;
        if (newRoot != null) {
            this.setDrilldownElements(newRoot, this.resolvedOperation);
            if (this.treeViewer != null) {
                if (this.input != newRoot) {
                    this.treeViewer.setInput((Object)newRoot);
                } else {
                    this.treeViewer.refresh();
                }
            }
            this.input = newRoot;
        }
    }

    @Override
    protected String getDialogSettingsName() {
        return this.getWizard().getClass().getName() + ".ResolutionResultsPage";
    }

    @Override
    protected int getColumnWidth(int index) {
        return this.treeViewer.getTree().getColumn(index).getWidth();
    }

    @Override
    protected SashForm getSashForm() {
        return this.sashForm;
    }
}

