package Locales::DB::Language::nl_be;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Language::nl_be::VERSION = '0.09';

$Locales::DB::Language::nl_be::cldr_version = '2.0';

%Locales::DB::Language::nl_be::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Taal\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ en\ \{1\}",
            'end'    => "\{0\}\ en\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Regio\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '”',
        'alternate_quotation_start' => '“',
        'quotation_end'             => '’',
        'quotation_start'           => '‘'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
            }
        }
    },
    'posix' => {
        'nostr'  => "nee\:n",
        'yesstr' => "ja\:j"
    },
);

%Locales::DB::Language::nl_be::code_to_name = (
    'aa'     => 'Afar',
    'ab'     => 'Abchazisch',
    'ace'    => 'Atjees',
    'ach'    => 'Akoli',
    'ada'    => 'Adangme',
    'ady'    => 'Adyghe',
    'ae'     => 'Avestisch',
    'af'     => 'Afrikaans',
    'afa'    => "Afro\-Aziatische\ taal",
    'afh'    => 'Afrihili',
    'agq'    => 'Aghem',
    'ain'    => 'Ainu',
    'ak'     => 'Akan',
    'akk'    => 'Akkadisch',
    'ale'    => 'Aleut',
    'alg'    => "Algonkium\-taal",
    'alt'    => "Zuid\-Altaïsch",
    'am'     => 'Amhaars',
    'an'     => 'Aragonees',
    'ang'    => 'Oudengels',
    'anp'    => 'Angika',
    'apa'    => "Apache\-taal",
    'ar'     => 'Arabisch',
    'arc'    => 'Aramees',
    'arn'    => 'Araukaans',
    'arp'    => 'Arapaho',
    'art'    => "Kunstmatige\ taal",
    'arw'    => 'Arawak',
    'as'     => 'Assamees',
    'asa'    => 'Asu',
    'ast'    => 'Asturisch',
    'ath'    => "Athapascaanse\ taal",
    'aus'    => "Australische\ taal",
    'av'     => 'Avarisch',
    'awa'    => 'Awadhi',
    'ay'     => 'Aymara',
    'az'     => 'Azeri',
    'ba'     => 'Basjkiers',
    'bad'    => 'Banda',
    'bai'    => "Bamileke\-taal",
    'bal'    => 'Baloetsji',
    'ban'    => 'Balinees',
    'bas'    => 'Basa',
    'bat'    => "Baltische\ taal",
    'be'     => "Wit\-Russisch",
    'bej'    => 'Beja',
    'bem'    => 'Bemba',
    'ber'    => 'Berber',
    'bez'    => 'Bena',
    'bg'     => 'Bulgaars',
    'bh'     => 'Bihari',
    'bho'    => 'Bhojpuri',
    'bi'     => 'Bislama',
    'bik'    => 'Bikol',
    'bin'    => 'Bini',
    'bla'    => 'Siksika',
    'bm'     => 'Bambara',
    'bn'     => 'Bengalees',
    'bnt'    => 'Bantoe',
    'bo'     => 'Tibetaans',
    'br'     => 'Bretons',
    'bra'    => 'Braj',
    'brx'    => 'Bodo',
    'bs'     => 'Bosnisch',
    'btk'    => 'Batak',
    'bua'    => 'Buriat',
    'bug'    => 'Buginees',
    'byn'    => 'Blin',
    'ca'     => 'Catalaans',
    'cad'    => 'Caddo',
    'cai'    => "Midden\-Amerikaans\ Indiaanse\ taal",
    'car'    => 'Caribisch',
    'cau'    => "Kaukasische\ taal",
    'cay'    => 'Cayuga',
    'cch'    => 'Atsam',
    'ce'     => 'Tsjetsjeens',
    'ceb'    => 'Cebuano',
    'cel'    => "Keltische\ taal",
    'cgg'    => 'Chiga',
    'ch'     => 'Chamorro',
    'chb'    => 'Chibcha',
    'chg'    => 'Chagatai',
    'chk'    => 'Chuukees',
    'chm'    => 'Mari',
    'chn'    => "Chinook\-jargon",
    'cho'    => 'Choctaw',
    'chp'    => 'Chipewyan',
    'chr'    => 'Cherokee',
    'chy'    => 'Cheyenne',
    'cmc'    => "Chamische\ taal",
    'co'     => 'Corsicaans',
    'cop'    => 'Koptisch',
    'cpe'    => "Op\ Engels\ gebaseerd\ Creools\ of\ Pidgin",
    'cpf'    => "Op\ Frans\ gebaseerd\ Creools\ of\ Pidgin",
    'cpp'    => "Op\ Portugees\ gebaseerd\ Creools\ of\ Pidgin",
    'cr'     => 'Cree',
    'crh'    => "Krim\-Tataars",
    'crp'    => "Creools\ of\ Pidgin",
    'cs'     => 'Tsjechisch',
    'csb'    => 'Kasjoebisch',
    'cu'     => 'Kerkslavisch',
    'cus'    => "Koesjitische\ taal",
    'cv'     => 'Tsjoevasjisch',
    'cy'     => 'Welsh',
    'da'     => 'Deens',
    'dak'    => 'Dakota',
    'dar'    => 'Dargwa',
    'dav'    => 'Taita',
    'day'    => 'Dajak',
    'de'     => 'Duits',
    'de_at'  => "Oostenrijks\ Duits",
    'de_ch'  => "Zwitsers\ Hoogduits",
    'del'    => 'Delaware',
    'den'    => 'Slave',
    'dgr'    => 'Dogrib',
    'din'    => 'Dinka',
    'dje'    => 'Zarma',
    'doi'    => 'Dogri',
    'dra'    => "Dravidische\ taal",
    'dsb'    => 'Nedersorbisch',
    'dua'    => 'Duala',
    'dum'    => 'Middelnederlands',
    'dv'     => 'Divehi',
    'dyo'    => "Jola\-Fonyi",
    'dyu'    => 'Dyula',
    'dz'     => 'Dzongkha',
    'ebu'    => 'Embu',
    'ee'     => 'Ewe',
    'efi'    => 'Efik',
    'egy'    => 'Oudegyptisch',
    'eka'    => 'Ekajuk',
    'el'     => 'Grieks',
    'elx'    => 'Elamitisch',
    'en'     => 'Engels',
    'en_au'  => "Australisch\ Engels",
    'en_ca'  => "Canadees\ Engels",
    'en_gb'  => "Brits\ Engels",
    'en_us'  => "Amerikaans\ Engels",
    'enm'    => 'Middelengels',
    'eo'     => 'Esperanto',
    'es'     => 'Spaans',
    'es_419' => "Latijns\-Amerikaans\ Spaans",
    'es_es'  => "Iberisch\ Spaans",
    'et'     => 'Estlands',
    'eu'     => 'Baskisch',
    'ewo'    => 'Ewondo',
    'fa'     => 'Perzisch',
    'fan'    => 'Fang',
    'fat'    => 'Fanti',
    'ff'     => 'Fulah',
    'fi'     => 'Fins',
    'fil'    => 'Filippijns',
    'fiu'    => "Fins\-Oegrische\ taal",
    'fj'     => 'Fijisch',
    'fo'     => 'Faeröers',
    'fon'    => 'Fon',
    'fr'     => 'Frans',
    'fr_ca'  => "Canadees\ Frans",
    'fr_ch'  => "Zwitsers\ Frans",
    'frm'    => 'Middelfrans',
    'fro'    => 'Oudfrans',
    'frr'    => "Noord\-Fries",
    'frs'    => "Oost\-Fries",
    'fur'    => 'Friulisch',
    'fy'     => "West\-Fries",
    'ga'     => 'Iers',
    'gaa'    => 'Ga',
    'gay'    => 'Gayo',
    'gba'    => 'Gbaya',
    'gd'     => "Schots\ Gaelic",
    'gem'    => "Germaanse\ taal",
    'gez'    => 'Geez',
    'gil'    => 'Gilbertees',
    'gl'     => 'Galicisch',
    'gmh'    => 'Middelhoogduits',
    'gn'     => 'Guarani',
    'goh'    => 'Oudhoogduits',
    'gon'    => 'Gondi',
    'gor'    => 'Gorontalo',
    'got'    => 'Gothisch',
    'grb'    => 'Grebo',
    'grc'    => 'Oudgrieks',
    'gsw'    => "Zwitsers\ Duits",
    'gu'     => 'Gujarati',
    'guz'    => 'Gusii',
    'gv'     => 'Manx',
    'gwi'    => 'Gwichʼin',
    'ha'     => 'Hausa',
    'hai'    => 'Haida',
    'haw'    => 'Hawaïaans',
    'he'     => 'Hebreeuws',
    'hi'     => 'Hindi',
    'hil'    => 'Hiligaynon',
    'him'    => 'Himachali',
    'hit'    => 'Hettitisch',
    'hmn'    => 'Hmong',
    'ho'     => "Hiri\ Motu",
    'hr'     => 'Kroatisch',
    'hsb'    => 'Oppersorbisch',
    'ht'     => 'Haïtiaans',
    'hu'     => 'Hongaars',
    'hup'    => 'Hupa',
    'hy'     => 'Armeens',
    'hz'     => 'Herero',
    'ia'     => 'Interlingua',
    'iba'    => 'Iban',
    'id'     => 'Indonesisch',
    'ie'     => 'Interlingue',
    'ig'     => 'Igbo',
    'ii'     => "Sichuan\ Yi",
    'ijo'    => 'Ijo',
    'ik'     => 'Inupiaq',
    'ilo'    => 'Iloko',
    'inc'    => "Indische\ taal",
    'ine'    => "Indo\-Europese\ taal",
    'inh'    => 'Ingoesj',
    'io'     => 'Ido',
    'ira'    => "Iraanse\ taal",
    'iro'    => "Irokese\ taal",
    'is'     => 'IJslands',
    'it'     => 'Italiaans',
    'iu'     => 'Inuktitut',
    'ja'     => 'Japans',
    'jbo'    => 'Lojban',
    'jmc'    => 'Machame',
    'jpr'    => "Judeo\-Perzisch",
    'jrb'    => "Judeo\-Arabisch",
    'jv'     => 'Javaans',
    'ka'     => 'Georgisch',
    'kaa'    => 'Karakalpaks',
    'kab'    => 'Kabyle',
    'kac'    => 'Kachin',
    'kaj'    => 'Jju',
    'kam'    => 'Kamba',
    'kar'    => 'Karen',
    'kaw'    => 'Kawi',
    'kbd'    => 'Kabardisch',
    'kcg'    => 'Tyap',
    'kde'    => 'Makonde',
    'kea'    => 'Kabuverdianu',
    'kfo'    => 'Koro',
    'kg'     => 'Kongo',
    'kha'    => 'Khasi',
    'khi'    => "Khoisan\-taal",
    'kho'    => 'Khotanees',
    'khq'    => "Koyra\ Chiini",
    'ki'     => 'Kikuyu',
    'kj'     => 'Kuanyama',
    'kk'     => 'Kazachs',
    'kl'     => 'Groenlands',
    'kln'    => 'Kalenjin',
    'km'     => 'Khmer',
    'kmb'    => 'Kimbundu',
    'kn'     => 'Kannada',
    'ko'     => 'Koreaans',
    'kok'    => 'Konkani',
    'kos'    => 'Kosraeaans',
    'kpe'    => 'Kpelle',
    'kr'     => 'Kanuri',
    'krc'    => "Karachay\-Balkar",
    'krl'    => 'Karelisch',
    'kro'    => 'Kru',
    'kru'    => 'Kurukh',
    'ks'     => 'Kasjmiri',
    'ksb'    => 'Shambala',
    'ksf'    => 'Bafia',
    'ksh'    => 'Colognian',
    'ku'     => 'Koerdisch',
    'kum'    => 'Koemuks',
    'kut'    => 'Kutenai',
    'kv'     => 'Komi',
    'kw'     => 'Cornish',
    'ky'     => 'Kirgizisch',
    'la'     => 'Latijn',
    'lad'    => 'Ladino',
    'lag'    => 'Langi',
    'lah'    => 'Lahnda',
    'lam'    => 'Lamba',
    'lb'     => 'Luxemburgs',
    'lez'    => 'Lezgisch',
    'lg'     => 'Ganda',
    'li'     => 'Limburgs',
    'ln'     => 'Lingala',
    'lo'     => 'Laotiaans',
    'lol'    => 'Mongo',
    'loz'    => 'Lozi',
    'lt'     => 'Litouws',
    'lu'     => "Luba\-Katanga",
    'lua'    => "Luba\-Lulua",
    'lui'    => 'Luiseno',
    'lun'    => 'Lunda',
    'luo'    => 'Luo',
    'lus'    => 'Lushai',
    'luy'    => 'Luhya',
    'lv'     => 'Lets',
    'mad'    => 'Madurees',
    'mag'    => 'Magahi',
    'mai'    => 'Maithili',
    'mak'    => 'Makassaars',
    'man'    => 'Mandingo',
    'map'    => 'Austronesisch',
    'mas'    => 'Masai',
    'mdf'    => 'Moksha',
    'mdr'    => 'Mandar',
    'men'    => 'Mende',
    'mer'    => 'Meru',
    'mfe'    => 'Morisyen',
    'mg'     => 'Malagasisch',
    'mga'    => 'Middeliers',
    'mgh'    => "Makhuwa\-Meetto",
    'mh'     => 'Marshallees',
    'mi'     => 'Maori',
    'mic'    => "Mi\'kmaq",
    'min'    => 'Minangkabau',
    'mis'    => "Diverse\ talen",
    'mk'     => 'Macedonisch',
    'mkh'    => "Mon\-Khmer\-taal",
    'ml'     => 'Malayalam',
    'mn'     => 'Mongools',
    'mnc'    => 'Mantsjoe',
    'mni'    => 'Manipoeri',
    'mno'    => "Manobo\-taal",
    'mo'     => 'Moldavisch',
    'moh'    => 'Mohawk',
    'mos'    => 'Mossi',
    'mr'     => 'Marathi',
    'ms'     => 'Maleis',
    'mt'     => 'Maltees',
    'mua'    => 'Mundang',
    'mul'    => "Meerdere\ talen",
    'mun'    => "Munda\-taal",
    'mus'    => 'Creek',
    'mwl'    => 'Mirandees',
    'mwr'    => 'Marwari',
    'my'     => 'Birmees',
    'myn'    => "Mayan\-taal",
    'myv'    => 'Erzja',
    'na'     => 'Nauruaans',
    'nah'    => 'Nahuatl',
    'nai'    => "Noord\-Amerikaans\ Indiaanse\ taal",
    'nap'    => 'Napolitaans',
    'naq'    => 'Nama',
    'nb'     => "Noors\ \-\ Bokmål",
    'nd'     => "Noord\-Ndbele",
    'nds'    => 'Laagduits',
    'ne'     => 'Nepalees',
    'new'    => 'Newari',
    'ng'     => 'Ndonga',
    'nia'    => 'Nias',
    'nic'    => "Niger\-Kordofanische\ taal",
    'niu'    => 'Niueaans',
    'nl'     => 'Nederlands',
    'nl_be'  => 'Vlaams',
    'nmg'    => 'Kwasio',
    'nn'     => "Noors\ \-\ Nynorsk",
    'no'     => 'Noors',
    'nog'    => 'Nogai',
    'non'    => 'Oudnoors',
    'nqo'    => 'N’ko',
    'nr'     => "Zuid\-Ndbele",
    'nso'    => "Noord\-Sotho",
    'nub'    => "Nubische\ taal",
    'nus'    => 'Nuer',
    'nv'     => 'Navajo',
    'nwc'    => "Klassiek\ Newari",
    'ny'     => 'Nyanja',
    'nym'    => 'Nyamwezi',
    'nyn'    => 'Nyankole',
    'nyo'    => 'Nyoro',
    'nzi'    => 'Nzima',
    'oc'     => "Occitaans\ \(na\ 1500\)\;\ Provençaals",
    'oj'     => 'Ojibwa',
    'om'     => 'Oromo',
    'or'     => 'Oriya',
    'os'     => 'Ossetisch',
    'osa'    => 'Osage',
    'ota'    => "Ottomaans\-Turks",
    'oto'    => "Otomi\-taal",
    'pa'     => 'Punjabi',
    'paa'    => 'Papoeataal',
    'pag'    => 'Pangasinan',
    'pal'    => 'Pahlavi',
    'pam'    => 'Pampanga',
    'pap'    => 'Papiaments',
    'pau'    => 'Palauaans',
    'peo'    => 'Oudperzisch',
    'phi'    => "Filippijnse\ taal",
    'phn'    => 'Foenicisch',
    'pi'     => 'Pali',
    'pl'     => 'Pools',
    'pon'    => 'Pohnpeiaans',
    'pra'    => "Prakrit\-taal",
    'pro'    => 'Oudprovençaals',
    'ps'     => 'Pashto',
    'pt'     => 'Portugees',
    'pt_br'  => "Braziliaans\ Portugees",
    'pt_pt'  => "Iberisch\ Portugees",
    'qu'     => 'Quechua',
    'raj'    => 'Rajasthani',
    'rap'    => 'Rapanui',
    'rar'    => 'Rarotongan',
    'rm'     => "Reto\-Romaans",
    'rn'     => 'Kirundi',
    'ro'     => 'Roemeens',
    'roa'    => "Romaanse\ taal",
    'rof'    => 'Rombo',
    'rom'    => 'Romani',
    'ru'     => 'Russisch',
    'rup'    => 'Aromaniaans',
    'rw'     => 'Kinyarwanda',
    'rwk'    => 'Rwa',
    'sa'     => 'Sanskriet',
    'sad'    => 'Sandawe',
    'sah'    => 'Jakoets',
    'sai'    => "Zuid\-Amerikaans\ Indiaanse\ taal",
    'sal'    => "Salishan\-taal",
    'sam'    => "Samaritaans\-Aramees",
    'saq'    => 'Samburu',
    'sas'    => 'Sasak',
    'sat'    => 'Santali',
    'sbp'    => 'Sangu',
    'sc'     => 'Sardinisch',
    'scn'    => 'Siciliaans',
    'sco'    => 'Schots',
    'sd'     => 'Sindhi',
    'se'     => "Noord\-Samisch",
    'see'    => 'Seneca',
    'seh'    => 'Sena',
    'sel'    => 'Selkup',
    'sem'    => "Semitische\ taal",
    'ses'    => "Koyraboro\ Senni",
    'sg'     => 'Sango',
    'sga'    => 'Oudiers',
    'sgn'    => 'Gebarentaal',
    'sh'     => "Servo\-Kroatisch",
    'shi'    => 'Tachelhit',
    'shn'    => 'Shan',
    'si'     => 'Singalees',
    'sid'    => 'Sidamo',
    'sio'    => "Siouaanse\ talen",
    'sit'    => "Sino\-Tibetaanse\ taal",
    'sk'     => 'Slowaaks',
    'sl'     => 'Sloveens',
    'sla'    => "Slavische\ taal",
    'sm'     => 'Samoaans',
    'sma'    => "Zuid\-Samisch",
    'smi'    => "Sami\-taal",
    'smj'    => "Lule\ Sami",
    'smn'    => "Inari\ Sami",
    'sms'    => "Skolt\ Sami",
    'sn'     => 'Shona',
    'snk'    => 'Soninke',
    'so'     => 'Somalisch',
    'sog'    => 'Sogdisch',
    'son'    => 'Songhai',
    'sq'     => 'Albanees',
    'sr'     => 'Servisch',
    'srn'    => 'Sranantongo',
    'srr'    => 'Serer',
    'ss'     => 'Swazi',
    'ssa'    => "Nilo\-Saharaans",
    'ssy'    => 'Saho',
    'st'     => "Zuid\-Sotho",
    'su'     => 'Soendanees',
    'suk'    => 'Sukuma',
    'sus'    => 'Soesoe',
    'sux'    => 'Soemerisch',
    'sv'     => 'Zweeds',
    'sw'     => 'Swahili',
    'swb'    => 'Shimaore',
    'swc'    => "Congo\ Swahili",
    'syc'    => "Klassiek\ Syrisch",
    'syr'    => 'Syriac',
    'ta'     => 'Tamil',
    'tai'    => "Tai\-taal",
    'te'     => 'Teloegoe',
    'tem'    => 'Timne',
    'teo'    => 'Teso',
    'ter'    => 'Tereno',
    'tet'    => 'Tetun',
    'tg'     => 'Tadzjieks',
    'th'     => 'Thais',
    'ti'     => 'Tigrinya',
    'tig'    => 'Tigre',
    'tiv'    => 'Tiv',
    'tk'     => 'Turkmeens',
    'tkl'    => 'Tokelaus',
    'tl'     => 'Tagalog',
    'tlh'    => 'Klingon',
    'tli'    => 'Tlingit',
    'tmh'    => 'Tamashek',
    'tn'     => 'Tswana',
    'to'     => 'Tongaans',
    'tog'    => "Nyasa\ Tonga",
    'tpi'    => "Tok\ Pisin",
    'tr'     => 'Turks',
    'trv'    => 'Taroko',
    'ts'     => 'Tsonga',
    'tsi'    => 'Tsimshian',
    'tt'     => 'Tataars',
    'tum'    => 'Toemboeka',
    'tup'    => "Tupi\-taal",
    'tut'    => "Altaïsche\ taal",
    'tvl'    => 'Tuvaluaans',
    'tw'     => 'Twi',
    'twq'    => 'Tasawaq',
    'ty'     => 'Tahitisch',
    'tyv'    => 'Tuvinisch',
    'tzm'    => "Central\ Morocco\ Tamazight",
    'udm'    => 'Oedmoerts',
    'ug'     => 'Oeigoers',
    'uga'    => 'Oegaritisch',
    'uk'     => 'Oekraïens',
    'umb'    => 'Umbundu',
    'und'    => "Onbekende\ taal",
    'ur'     => 'Urdu',
    'uz'     => 'Oezbeeks',
    'vai'    => 'Vai',
    've'     => 'Venda',
    'vi'     => 'Vietnamees',
    'vo'     => 'Volapük',
    'vot'    => 'Votisch',
    'vun'    => 'Vunjo',
    'wa'     => 'Waals',
    'wae'    => 'Walser',
    'wak'    => "Wakashan\-taal",
    'wal'    => 'Walamo',
    'war'    => 'Waray',
    'was'    => 'Washo',
    'wen'    => "Sorbische\ taal",
    'wo'     => 'Wolof',
    'xal'    => 'Kalmyk',
    'xh'     => 'Xhosa',
    'xog'    => 'Soga',
    'yao'    => 'Yao',
    'yap'    => 'Yapees',
    'yav'    => 'Yangben',
    'yi'     => 'Jiddisch',
    'yo'     => 'Yoruba',
    'ypk'    => "Yupik\-talen",
    'yue'    => 'Kantonees',
    'za'     => 'Zhuang',
    'zap'    => 'Zapotec',
    'zbl'    => 'Blissymbolen',
    'zen'    => 'Zenaga',
    'zh'     => 'Chinees',
    'znd'    => 'Zande',
    'zu'     => 'Zulu',
    'zun'    => 'Zuni',
    'zxx'    => "Geen\ linguïstische\ inhoud",
    'zza'    => 'Zaza',
);

%Locales::DB::Language::nl_be::name_to_code = (
    'abchazisch'                          => 'ab',
    'adangme'                             => 'ada',
    'adyghe'                              => 'ady',
    'afar'                                => 'aa',
    'afrihili'                            => 'afh',
    'afrikaans'                           => 'af',
    'afroaziatischetaal'                  => 'afa',
    'aghem'                               => 'agq',
    'ainu'                                => 'ain',
    'akan'                                => 'ak',
    'akkadisch'                           => 'akk',
    'akoli'                               => 'ach',
    'albanees'                            => 'sq',
    'aleut'                               => 'ale',
    'algonkiumtaal'                       => 'alg',
    'altaïschetaal'                      => 'tut',
    'amerikaansengels'                    => 'en_us',
    'amhaars'                             => 'am',
    'angika'                              => 'anp',
    'apachetaal'                          => 'apa',
    'arabisch'                            => 'ar',
    'aragonees'                           => 'an',
    'aramees'                             => 'arc',
    'arapaho'                             => 'arp',
    'araukaans'                           => 'arn',
    'arawak'                              => 'arw',
    'armeens'                             => 'hy',
    'aromaniaans'                         => 'rup',
    'assamees'                            => 'as',
    'asturisch'                           => 'ast',
    'asu'                                 => 'asa',
    'athapascaansetaal'                   => 'ath',
    'atjees'                              => 'ace',
    'atsam'                               => 'cch',
    'australischengels'                   => 'en_au',
    'australischetaal'                    => 'aus',
    'austronesisch'                       => 'map',
    'avarisch'                            => 'av',
    'avestisch'                           => 'ae',
    'awadhi'                              => 'awa',
    'aymara'                              => 'ay',
    'azeri'                               => 'az',
    'bafia'                               => 'ksf',
    'balinees'                            => 'ban',
    'baloetsji'                           => 'bal',
    'baltischetaal'                       => 'bat',
    'bambara'                             => 'bm',
    'bamileketaal'                        => 'bai',
    'banda'                               => 'bad',
    'bantoe'                              => 'bnt',
    'basa'                                => 'bas',
    'basjkiers'                           => 'ba',
    'baskisch'                            => 'eu',
    'batak'                               => 'btk',
    'beja'                                => 'bej',
    'bemba'                               => 'bem',
    'bena'                                => 'bez',
    'bengalees'                           => 'bn',
    'berber'                              => 'ber',
    'bhojpuri'                            => 'bho',
    'bihari'                              => 'bh',
    'bikol'                               => 'bik',
    'bini'                                => 'bin',
    'birmees'                             => 'my',
    'bislama'                             => 'bi',
    'blin'                                => 'byn',
    'blissymbolen'                        => 'zbl',
    'bodo'                                => 'brx',
    'bosnisch'                            => 'bs',
    'braj'                                => 'bra',
    'braziliaansportugees'                => 'pt_br',
    'bretons'                             => 'br',
    'britsengels'                         => 'en_gb',
    'buginees'                            => 'bug',
    'bulgaars'                            => 'bg',
    'buriat'                              => 'bua',
    'caddo'                               => 'cad',
    'canadeesengels'                      => 'en_ca',
    'canadeesfrans'                       => 'fr_ca',
    'caribisch'                           => 'car',
    'catalaans'                           => 'ca',
    'cayuga'                              => 'cay',
    'cebuano'                             => 'ceb',
    'centralmoroccotamazight'             => 'tzm',
    'chagatai'                            => 'chg',
    'chamischetaal'                       => 'cmc',
    'chamorro'                            => 'ch',
    'cherokee'                            => 'chr',
    'cheyenne'                            => 'chy',
    'chibcha'                             => 'chb',
    'chiga'                               => 'cgg',
    'chinees'                             => 'zh',
    'chinookjargon'                       => 'chn',
    'chipewyan'                           => 'chp',
    'choctaw'                             => 'cho',
    'chuukees'                            => 'chk',
    'colognian'                           => 'ksh',
    'congoswahili'                        => 'swc',
    'cornish'                             => 'kw',
    'corsicaans'                          => 'co',
    'cree'                                => 'cr',
    'creek'                               => 'mus',
    'creoolsofpidgin'                     => 'crp',
    'dajak'                               => 'day',
    'dakota'                              => 'dak',
    'dargwa'                              => 'dar',
    'deens'                               => 'da',
    'delaware'                            => 'del',
    'dinka'                               => 'din',
    'divehi'                              => 'dv',
    'diversetalen'                        => 'mis',
    'dogri'                               => 'doi',
    'dogrib'                              => 'dgr',
    'dravidischetaal'                     => 'dra',
    'duala'                               => 'dua',
    'duits'                               => 'de',
    'dyula'                               => 'dyu',
    'dzongkha'                            => 'dz',
    'efik'                                => 'efi',
    'ekajuk'                              => 'eka',
    'elamitisch'                          => 'elx',
    'embu'                                => 'ebu',
    'engels'                              => 'en',
    'erzja'                               => 'myv',
    'esperanto'                           => 'eo',
    'estlands'                            => 'et',
    'ewe'                                 => 'ee',
    'ewondo'                              => 'ewo',
    'faeröers'                           => 'fo',
    'fang'                                => 'fan',
    'fanti'                               => 'fat',
    'fijisch'                             => 'fj',
    'filippijns'                          => 'fil',
    'filippijnsetaal'                     => 'phi',
    'fins'                                => 'fi',
    'finsoegrischetaal'                   => 'fiu',
    'foenicisch'                          => 'phn',
    'fon'                                 => 'fon',
    'frans'                               => 'fr',
    'friulisch'                           => 'fur',
    'fulah'                               => 'ff',
    'ga'                                  => 'gaa',
    'galicisch'                           => 'gl',
    'ganda'                               => 'lg',
    'gayo'                                => 'gay',
    'gbaya'                               => 'gba',
    'gebarentaal'                         => 'sgn',
    'geenlinguïstischeinhoud'            => 'zxx',
    'geez'                                => 'gez',
    'georgisch'                           => 'ka',
    'germaansetaal'                       => 'gem',
    'gilbertees'                          => 'gil',
    'gondi'                               => 'gon',
    'gorontalo'                           => 'gor',
    'gothisch'                            => 'got',
    'grebo'                               => 'grb',
    'grieks'                              => 'el',
    'groenlands'                          => 'kl',
    'guarani'                             => 'gn',
    'gujarati'                            => 'gu',
    'gusii'                               => 'guz',
    'gwichʼin'                           => 'gwi',
    'haida'                               => 'hai',
    'hausa'                               => 'ha',
    'hawaïaans'                          => 'haw',
    'haïtiaans'                          => 'ht',
    'hebreeuws'                           => 'he',
    'herero'                              => 'hz',
    'hettitisch'                          => 'hit',
    'hiligaynon'                          => 'hil',
    'himachali'                           => 'him',
    'hindi'                               => 'hi',
    'hirimotu'                            => 'ho',
    'hmong'                               => 'hmn',
    'hongaars'                            => 'hu',
    'hupa'                                => 'hup',
    'iban'                                => 'iba',
    'iberischportugees'                   => 'pt_pt',
    'iberischspaans'                      => 'es_es',
    'ido'                                 => 'io',
    'iers'                                => 'ga',
    'igbo'                                => 'ig',
    'ijo'                                 => 'ijo',
    'ijslands'                            => 'is',
    'iloko'                               => 'ilo',
    'inarisami'                           => 'smn',
    'indischetaal'                        => 'inc',
    'indoeuropesetaal'                    => 'ine',
    'indonesisch'                         => 'id',
    'ingoesj'                             => 'inh',
    'interlingua'                         => 'ia',
    'interlingue'                         => 'ie',
    'inuktitut'                           => 'iu',
    'inupiaq'                             => 'ik',
    'iraansetaal'                         => 'ira',
    'irokesetaal'                         => 'iro',
    'italiaans'                           => 'it',
    'jakoets'                             => 'sah',
    'japans'                              => 'ja',
    'javaans'                             => 'jv',
    'jiddisch'                            => 'yi',
    'jju'                                 => 'kaj',
    'jolafonyi'                           => 'dyo',
    'judeoarabisch'                       => 'jrb',
    'judeoperzisch'                       => 'jpr',
    'kabardisch'                          => 'kbd',
    'kabuverdianu'                        => 'kea',
    'kabyle'                              => 'kab',
    'kachin'                              => 'kac',
    'kalenjin'                            => 'kln',
    'kalmyk'                              => 'xal',
    'kamba'                               => 'kam',
    'kannada'                             => 'kn',
    'kantonees'                           => 'yue',
    'kanuri'                              => 'kr',
    'karachaybalkar'                      => 'krc',
    'karakalpaks'                         => 'kaa',
    'karelisch'                           => 'krl',
    'karen'                               => 'kar',
    'kasjmiri'                            => 'ks',
    'kasjoebisch'                         => 'csb',
    'kaukasischetaal'                     => 'cau',
    'kawi'                                => 'kaw',
    'kazachs'                             => 'kk',
    'keltischetaal'                       => 'cel',
    'kerkslavisch'                        => 'cu',
    'khasi'                               => 'kha',
    'khmer'                               => 'km',
    'khoisantaal'                         => 'khi',
    'khotanees'                           => 'kho',
    'kikuyu'                              => 'ki',
    'kimbundu'                            => 'kmb',
    'kinyarwanda'                         => 'rw',
    'kirgizisch'                          => 'ky',
    'kirundi'                             => 'rn',
    'klassieknewari'                      => 'nwc',
    'klassieksyrisch'                     => 'syc',
    'klingon'                             => 'tlh',
    'koemuks'                             => 'kum',
    'koerdisch'                           => 'ku',
    'koesjitischetaal'                    => 'cus',
    'komi'                                => 'kv',
    'kongo'                               => 'kg',
    'konkani'                             => 'kok',
    'koptisch'                            => 'cop',
    'koreaans'                            => 'ko',
    'koro'                                => 'kfo',
    'kosraeaans'                          => 'kos',
    'koyraborosenni'                      => 'ses',
    'koyrachiini'                         => 'khq',
    'kpelle'                              => 'kpe',
    'krimtataars'                         => 'crh',
    'kroatisch'                           => 'hr',
    'kru'                                 => 'kro',
    'kuanyama'                            => 'kj',
    'kunstmatigetaal'                     => 'art',
    'kurukh'                              => 'kru',
    'kutenai'                             => 'kut',
    'kwasio'                              => 'nmg',
    'laagduits'                           => 'nds',
    'ladino'                              => 'lad',
    'lahnda'                              => 'lah',
    'lamba'                               => 'lam',
    'langi'                               => 'lag',
    'laotiaans'                           => 'lo',
    'latijn'                              => 'la',
    'latijnsamerikaansspaans'             => 'es_419',
    'lets'                                => 'lv',
    'lezgisch'                            => 'lez',
    'limburgs'                            => 'li',
    'lingala'                             => 'ln',
    'litouws'                             => 'lt',
    'lojban'                              => 'jbo',
    'lozi'                                => 'loz',
    'lubakatanga'                         => 'lu',
    'lubalulua'                           => 'lua',
    'luhya'                               => 'luy',
    'luiseno'                             => 'lui',
    'lulesami'                            => 'smj',
    'lunda'                               => 'lun',
    'luo'                                 => 'luo',
    'lushai'                              => 'lus',
    'luxemburgs'                          => 'lb',
    'macedonisch'                         => 'mk',
    'machame'                             => 'jmc',
    'madurees'                            => 'mad',
    'magahi'                              => 'mag',
    'maithili'                            => 'mai',
    'makassaars'                          => 'mak',
    'makhuwameetto'                       => 'mgh',
    'makonde'                             => 'kde',
    'malagasisch'                         => 'mg',
    'malayalam'                           => 'ml',
    'maleis'                              => 'ms',
    'maltees'                             => 'mt',
    'mandar'                              => 'mdr',
    'mandingo'                            => 'man',
    'manipoeri'                           => 'mni',
    'manobotaal'                          => 'mno',
    'mantsjoe'                            => 'mnc',
    'manx'                                => 'gv',
    'maori'                               => 'mi',
    'marathi'                             => 'mr',
    'mari'                                => 'chm',
    'marshallees'                         => 'mh',
    'marwari'                             => 'mwr',
    'masai'                               => 'mas',
    'mayantaal'                           => 'myn',
    'meerderetalen'                       => 'mul',
    'mende'                               => 'men',
    'meru'                                => 'mer',
    'middelengels'                        => 'enm',
    'middelfrans'                         => 'frm',
    'middelhoogduits'                     => 'gmh',
    'middeliers'                          => 'mga',
    'middelnederlands'                    => 'dum',
    'middenamerikaansindiaansetaal'       => 'cai',
    'mikmaq'                              => 'mic',
    'minangkabau'                         => 'min',
    'mirandees'                           => 'mwl',
    'mohawk'                              => 'moh',
    'moksha'                              => 'mdf',
    'moldavisch'                          => 'mo',
    'mongo'                               => 'lol',
    'mongools'                            => 'mn',
    'monkhmertaal'                        => 'mkh',
    'morisyen'                            => 'mfe',
    'mossi'                               => 'mos',
    'mundang'                             => 'mua',
    'mundataal'                           => 'mun',
    'nahuatl'                             => 'nah',
    'nama'                                => 'naq',
    'napolitaans'                         => 'nap',
    'nauruaans'                           => 'na',
    'navajo'                              => 'nv',
    'ndonga'                              => 'ng',
    'nederlands'                          => 'nl',
    'nedersorbisch'                       => 'dsb',
    'nepalees'                            => 'ne',
    'newari'                              => 'new',
    'nias'                                => 'nia',
    'nigerkordofanischetaal'              => 'nic',
    'nilosaharaans'                       => 'ssa',
    'niueaans'                            => 'niu',
    'nogai'                               => 'nog',
    'noordamerikaansindiaansetaal'        => 'nai',
    'noordfries'                          => 'frr',
    'noordndbele'                         => 'nd',
    'noordsamisch'                        => 'se',
    'noordsotho'                          => 'nso',
    'noors'                               => 'no',
    'noorsbokmål'                        => 'nb',
    'noorsnynorsk'                        => 'nn',
    'nubischetaal'                        => 'nub',
    'nuer'                                => 'nus',
    'nyamwezi'                            => 'nym',
    'nyanja'                              => 'ny',
    'nyankole'                            => 'nyn',
    'nyasatonga'                          => 'tog',
    'nyoro'                               => 'nyo',
    'nzima'                               => 'nzi',
    'n’ko'                              => 'nqo',
    "occitaansna1500\;provençaals"       => 'oc',
    'oedmoerts'                           => 'udm',
    'oegaritisch'                         => 'uga',
    'oeigoers'                            => 'ug',
    'oekraïens'                          => 'uk',
    'oezbeeks'                            => 'uz',
    'ojibwa'                              => 'oj',
    'onbekendetaal'                       => 'und',
    'oostenrijksduits'                    => 'de_at',
    'oostfries'                           => 'frs',
    'opengelsgebaseerdcreoolsofpidgin'    => 'cpe',
    'opfransgebaseerdcreoolsofpidgin'     => 'cpf',
    'oppersorbisch'                       => 'hsb',
    'opportugeesgebaseerdcreoolsofpidgin' => 'cpp',
    'oriya'                               => 'or',
    'oromo'                               => 'om',
    'osage'                               => 'osa',
    'ossetisch'                           => 'os',
    'otomitaal'                           => 'oto',
    'ottomaansturks'                      => 'ota',
    'oudegyptisch'                        => 'egy',
    'oudengels'                           => 'ang',
    'oudfrans'                            => 'fro',
    'oudgrieks'                           => 'grc',
    'oudhoogduits'                        => 'goh',
    'oudiers'                             => 'sga',
    'oudnoors'                            => 'non',
    'oudperzisch'                         => 'peo',
    'oudprovençaals'                     => 'pro',
    'pahlavi'                             => 'pal',
    'palauaans'                           => 'pau',
    'pali'                                => 'pi',
    'pampanga'                            => 'pam',
    'pangasinan'                          => 'pag',
    'papiaments'                          => 'pap',
    'papoeataal'                          => 'paa',
    'pashto'                              => 'ps',
    'perzisch'                            => 'fa',
    'pohnpeiaans'                         => 'pon',
    'pools'                               => 'pl',
    'portugees'                           => 'pt',
    'prakrittaal'                         => 'pra',
    'punjabi'                             => 'pa',
    'quechua'                             => 'qu',
    'rajasthani'                          => 'raj',
    'rapanui'                             => 'rap',
    'rarotongan'                          => 'rar',
    'retoromaans'                         => 'rm',
    'roemeens'                            => 'ro',
    'romaansetaal'                        => 'roa',
    'romani'                              => 'rom',
    'rombo'                               => 'rof',
    'russisch'                            => 'ru',
    'rwa'                                 => 'rwk',
    'saho'                                => 'ssy',
    'salishantaal'                        => 'sal',
    'samaritaansaramees'                  => 'sam',
    'samburu'                             => 'saq',
    'samitaal'                            => 'smi',
    'samoaans'                            => 'sm',
    'sandawe'                             => 'sad',
    'sango'                               => 'sg',
    'sangu'                               => 'sbp',
    'sanskriet'                           => 'sa',
    'santali'                             => 'sat',
    'sardinisch'                          => 'sc',
    'sasak'                               => 'sas',
    'schots'                              => 'sco',
    'schotsgaelic'                        => 'gd',
    'selkup'                              => 'sel',
    'semitischetaal'                      => 'sem',
    'sena'                                => 'seh',
    'seneca'                              => 'see',
    'serer'                               => 'srr',
    'servisch'                            => 'sr',
    'servokroatisch'                      => 'sh',
    'shambala'                            => 'ksb',
    'shan'                                => 'shn',
    'shimaore'                            => 'swb',
    'shona'                               => 'sn',
    'sichuanyi'                           => 'ii',
    'siciliaans'                          => 'scn',
    'sidamo'                              => 'sid',
    'siksika'                             => 'bla',
    'sindhi'                              => 'sd',
    'singalees'                           => 'si',
    'sinotibetaansetaal'                  => 'sit',
    'siouaansetalen'                      => 'sio',
    'skoltsami'                           => 'sms',
    'slave'                               => 'den',
    'slavischetaal'                       => 'sla',
    'sloveens'                            => 'sl',
    'slowaaks'                            => 'sk',
    'soemerisch'                          => 'sux',
    'soendanees'                          => 'su',
    'soesoe'                              => 'sus',
    'soga'                                => 'xog',
    'sogdisch'                            => 'sog',
    'somalisch'                           => 'so',
    'songhai'                             => 'son',
    'soninke'                             => 'snk',
    'sorbischetaal'                       => 'wen',
    'spaans'                              => 'es',
    'sranantongo'                         => 'srn',
    'sukuma'                              => 'suk',
    'swahili'                             => 'sw',
    'swazi'                               => 'ss',
    'syriac'                              => 'syr',
    'tachelhit'                           => 'shi',
    'tadzjieks'                           => 'tg',
    'tagalog'                             => 'tl',
    'tahitisch'                           => 'ty',
    'taita'                               => 'dav',
    'taitaal'                             => 'tai',
    'tamashek'                            => 'tmh',
    'tamil'                               => 'ta',
    'taroko'                              => 'trv',
    'tasawaq'                             => 'twq',
    'tataars'                             => 'tt',
    'teloegoe'                            => 'te',
    'tereno'                              => 'ter',
    'teso'                                => 'teo',
    'tetun'                               => 'tet',
    'thais'                               => 'th',
    'tibetaans'                           => 'bo',
    'tigre'                               => 'tig',
    'tigrinya'                            => 'ti',
    'timne'                               => 'tem',
    'tiv'                                 => 'tiv',
    'tlingit'                             => 'tli',
    'toemboeka'                           => 'tum',
    'tokelaus'                            => 'tkl',
    'tokpisin'                            => 'tpi',
    'tongaans'                            => 'to',
    'tsimshian'                           => 'tsi',
    'tsjechisch'                          => 'cs',
    'tsjetsjeens'                         => 'ce',
    'tsjoevasjisch'                       => 'cv',
    'tsonga'                              => 'ts',
    'tswana'                              => 'tn',
    'tupitaal'                            => 'tup',
    'turkmeens'                           => 'tk',
    'turks'                               => 'tr',
    'tuvaluaans'                          => 'tvl',
    'tuvinisch'                           => 'tyv',
    'twi'                                 => 'tw',
    'tyap'                                => 'kcg',
    'umbundu'                             => 'umb',
    'urdu'                                => 'ur',
    'vai'                                 => 'vai',
    'venda'                               => 've',
    'vietnamees'                          => 'vi',
    'vlaams'                              => 'nl_be',
    'volapük'                            => 'vo',
    'votisch'                             => 'vot',
    'vunjo'                               => 'vun',
    'waals'                               => 'wa',
    'wakashantaal'                        => 'wak',
    'walamo'                              => 'wal',
    'walser'                              => 'wae',
    'waray'                               => 'war',
    'washo'                               => 'was',
    'welsh'                               => 'cy',
    'westfries'                           => 'fy',
    'witrussisch'                         => 'be',
    'wolof'                               => 'wo',
    'xhosa'                               => 'xh',
    'yangben'                             => 'yav',
    'yao'                                 => 'yao',
    'yapees'                              => 'yap',
    'yoruba'                              => 'yo',
    'yupiktalen'                          => 'ypk',
    'zande'                               => 'znd',
    'zapotec'                             => 'zap',
    'zarma'                               => 'dje',
    'zaza'                                => 'zza',
    'zenaga'                              => 'zen',
    'zhuang'                              => 'za',
    'zuidaltaïsch'                       => 'alt',
    'zuidamerikaansindiaansetaal'         => 'sai',
    'zuidndbele'                          => 'nr',
    'zuidsamisch'                         => 'sma',
    'zuidsotho'                           => 'st',
    'zulu'                                => 'zu',
    'zuni'                                => 'zun',
    'zweeds'                              => 'sv',
    'zwitsersduits'                       => 'gsw',
    'zwitsersfrans'                       => 'fr_ch',
    'zwitsershoogduits'                   => 'de_ch',
);

1;
