/*****************************************************************************

	unsort - reorder files semi-randomly
	Copyright (C) 2007  Wessel Dankers <wsl@fruit.je>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.

*****************************************************************************/

#include <stdbool.h>
#include <stdint.h>
#include <time.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include "mt19937ar.h"
#include "mt19937ar_init.h"

bool mt_init_urandom(void) {
	int fd;
	size_t len = 0;
	ssize_t r;
	uint32_t buf[4];

	fd = open("/dev/urandom", O_RDONLY);
	if(fd == -1)
		return false;

	while(len < sizeof buf) {
		errno = EAGAIN;
		r = read(fd, buf + len, sizeof buf - len);
		if(!r || r < 0)
			break;
		len += (size_t)r;
	}
	close(fd);

	if(len < sizeof buf)
		return false;

	mt_seed_array(buf, (unsigned int)(sizeof buf / sizeof *buf));

	return true;
}

void mt_init(void) {
	uint32_t buf[4];
	bool success = false;
	struct timespec ts;

	if(mt_init_urandom())
		return;

	if(!clock_gettime(CLOCK_REALTIME, &ts)) {
		success = true;
		buf[0] = (uint32_t)ts.tv_sec;
		buf[1] = (uint32_t)ts.tv_nsec;
	}

	if(!clock_gettime(CLOCK_MONOTONIC, &ts)) {
		success = true;
		buf[2] = (uint32_t)ts.tv_sec;
		buf[3] = (uint32_t)ts.tv_nsec;
	}

	if(success) {
		mt_seed_array(buf, (unsigned int)(sizeof buf / sizeof *buf));
		return;
	}

	mt_seed((uint32_t)time(NULL));
}
