#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 498
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 250
#define ALIAS_COUNT 0
#define TOKEN_COUNT 110
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 45
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 104

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_module = 2,
  anon_sym_version = 3,
  anon_sym_is = 4,
  anon_sym_end = 5,
  anon_sym_import = 6,
  anon_sym_LBRACK = 7,
  anon_sym_RBRACK = 8,
  anon_sym_as = 9,
  anon_sym_COLON = 10,
  anon_sym_AT = 11,
  anon_sym_EQ = 12,
  anon_sym_assert = 13,
  sym_controlled_language_tag = 14,
  anon_sym_LPAREN = 15,
  anon_sym_RPAREN = 16,
  anon_sym_SLASH_EQ = 17,
  anon_sym_u2260 = 18,
  sym_less_than = 19,
  sym_greater_than = 20,
  anon_sym_LT_EQ = 21,
  anon_sym_u2264 = 22,
  anon_sym_GT_EQ = 23,
  anon_sym_u2265 = 24,
  anon_sym_not = 25,
  anon_sym_u00ac = 26,
  anon_sym_and = 27,
  anon_sym_u2227 = 28,
  anon_sym_or = 29,
  anon_sym_u2228 = 30,
  anon_sym_xor = 31,
  anon_sym_u22bb = 32,
  anon_sym_implies = 33,
  anon_sym_EQ_EQ_GT = 34,
  anon_sym_u21d2 = 35,
  anon_sym_iff = 36,
  anon_sym_LT_EQ_EQ_GT = 37,
  anon_sym_u21d4 = 38,
  anon_sym_COMMA = 39,
  anon_sym_forall = 40,
  anon_sym_u2200 = 41,
  anon_sym_exists = 42,
  anon_sym_u2203 = 43,
  anon_sym_in = 44,
  anon_sym_u2208 = 45,
  anon_sym_DOT = 46,
  anon_sym_u2205 = 47,
  sym_reserved_self = 48,
  anon_sym_def = 49,
  anon_sym_COLON_EQ = 50,
  anon_sym_u2254 = 51,
  anon_sym_LBRACE = 52,
  anon_sym_RBRACE = 53,
  sym_optional = 54,
  anon_sym_PIPE = 55,
  anon_sym_boolean = 56,
  anon_sym_unsigned = 57,
  anon_sym_integer = 58,
  anon_sym_decimal = 59,
  anon_sym_double = 60,
  anon_sym_string = 61,
  anon_sym_iri = 62,
  anon_sym_binary = 63,
  sym_quoted_string = 64,
  sym_language_tag = 65,
  anon_sym_LT = 66,
  aux_sym_iri_token1 = 67,
  anon_sym_GT = 68,
  anon_sym_POUND_LBRACK = 69,
  sym_hex_byte = 70,
  sym_double = 71,
  sym_decimal = 72,
  sym_integer = 73,
  sym_unsigned = 74,
  anon_sym_true = 75,
  anon_sym_u22a4 = 76,
  anon_sym_false = 77,
  anon_sym_u22a5 = 78,
  anon_sym_datatype = 79,
  sym_opaque = 80,
  anon_sym_dimension = 81,
  anon_sym_source = 82,
  anon_sym_with = 83,
  anon_sym_parent = 84,
  anon_sym_entity = 85,
  anon_sym_enum = 86,
  anon_sym_of = 87,
  anon_sym_event = 88,
  anon_sym_property = 89,
  anon_sym_structure = 90,
  anon_sym_union = 91,
  anon_sym_rdf = 92,
  anon_sym_type = 93,
  anon_sym_class = 94,
  anon_sym_PLUS = 95,
  sym_wildcard = 96,
  anon_sym_identity = 97,
  anon_sym_ref = 98,
  sym_unknown_type = 99,
  anon_sym_ordered = 100,
  anon_sym_unordered = 101,
  anon_sym_unique = 102,
  anon_sym_nonunique = 103,
  anon_sym_DOT_DOT = 104,
  anon_sym_u2192 = 105,
  anon_sym_DASH_GT = 106,
  anon_sym_u2190 = 107,
  anon_sym_LT_DASH = 108,
  sym_line_comment = 109,
  sym_module = 110,
  sym__module_locations = 111,
  sym_module_body = 112,
  sym_import_statement = 113,
  sym__import = 114,
  sym__rename_import = 115,
  sym_member_import = 116,
  sym_module_import = 117,
  sym_qualified_identifier = 118,
  sym_identifier_reference = 119,
  sym_annotation = 120,
  sym_annotation_property = 121,
  sym_constraint = 122,
  sym_informal_constraint = 123,
  sym_formal_constraint = 124,
  sym_constraint_sentence = 125,
  sym_simple_sentence = 126,
  sym_atomic_sentence = 127,
  sym_actual_arguments = 128,
  sym_equation = 129,
  sym_inequation = 130,
  sym_not_equal = 131,
  sym_less_than_or_equal = 132,
  sym_greater_than_or_equal = 133,
  sym_boolean_sentence = 134,
  sym_unary_boolean_sentence = 135,
  sym_binary_boolean_sentence = 136,
  sym_negation = 137,
  sym__logical_connective = 138,
  sym_conjunction = 139,
  sym_disjunction = 140,
  sym_exclusive_disjunction = 141,
  sym_implication = 142,
  sym_biconditional = 143,
  sym_quantified_sentence = 144,
  sym_quantified_variable_binding = 145,
  sym_universal = 146,
  sym_existential = 147,
  sym_quantified_variable = 148,
  sym_term = 149,
  sym_functional_term = 150,
  sym_function_composition = 151,
  sym_predicate_value = 152,
  sym_sequence_of_predicate_values = 153,
  sym_constraint_environment = 154,
  sym_environment_def = 155,
  sym_constraint_environment_end = 156,
  sym_function_def = 157,
  sym_function_body = 158,
  sym__by_definition = 159,
  sym_function_signature = 160,
  sym_function_parameter = 161,
  sym__function_type = 162,
  sym_function_cardinality_expression = 163,
  sym_function_type_reference = 164,
  sym_constant_def = 165,
  sym_sequence_builder = 166,
  sym_named_variable_set = 167,
  sym_mapping_variable = 168,
  sym_sequence_builder_body = 169,
  sym_value = 170,
  sym_sequence_of_values = 171,
  sym__sequence_value_constraints = 172,
  sym_value_constructor = 173,
  sym_mapping_value = 174,
  sym_builtin_simple_type = 175,
  sym_simple_value = 176,
  sym_string = 177,
  sym_iri = 178,
  sym_binary = 179,
  sym_boolean = 180,
  sym_boolean_truth = 181,
  sym_boolean_falsity = 182,
  sym_definition = 183,
  sym_data_type_def = 184,
  sym__data_type_base = 185,
  sym_annotation_only_body = 186,
  sym_dimension_def = 187,
  sym_dimension_body = 188,
  sym_source_entity = 189,
  sym__identifier_or_list = 190,
  sym_dimension_parent = 191,
  sym_entity_def = 192,
  sym_entity_body = 193,
  sym_enum_def = 194,
  sym_enum_body = 195,
  sym_event_def = 196,
  sym_event_body = 197,
  sym_property_def = 198,
  sym_structure_def = 199,
  sym_structure_body = 200,
  sym_union_def = 201,
  sym_union_body = 202,
  sym_rdf_def = 203,
  sym_rdf_types = 204,
  sym_type_class_def = 205,
  sym_type_variable = 206,
  sym__type_variable_restriction = 207,
  sym_type_class_reference = 208,
  sym_type_class_arguments = 209,
  sym_type_class_body = 210,
  sym_method_def = 211,
  sym_entity_identity = 212,
  sym_member = 213,
  sym_member_def = 214,
  sym_property_ref = 215,
  sym__type_expression_to = 216,
  sym_type_reference = 217,
  sym_mapping_type = 218,
  sym_cardinality_expression = 219,
  sym__cardinality_inner = 220,
  sym_sequence_ordering = 221,
  sym_sequence_uniqueness = 222,
  sym_cardinality_range = 223,
  sym__has_type = 224,
  sym__type_restriction = 225,
  sym_value_variant = 226,
  sym_type_variant = 227,
  aux_sym_module_body_repeat1 = 228,
  aux_sym_module_body_repeat2 = 229,
  aux_sym_module_body_repeat3 = 230,
  aux_sym_import_statement_repeat1 = 231,
  aux_sym_actual_arguments_repeat1 = 232,
  aux_sym_function_composition_repeat1 = 233,
  aux_sym_sequence_of_predicate_values_repeat1 = 234,
  aux_sym_constraint_environment_repeat1 = 235,
  aux_sym_function_signature_repeat1 = 236,
  aux_sym_named_variable_set_repeat1 = 237,
  aux_sym_sequence_of_values_repeat1 = 238,
  aux_sym_binary_repeat1 = 239,
  aux_sym_dimension_body_repeat1 = 240,
  aux_sym_dimension_body_repeat2 = 241,
  aux_sym__identifier_or_list_repeat1 = 242,
  aux_sym_enum_body_repeat1 = 243,
  aux_sym_union_body_repeat1 = 244,
  aux_sym_rdf_types_repeat1 = 245,
  aux_sym_type_class_def_repeat1 = 246,
  aux_sym__type_variable_restriction_repeat1 = 247,
  aux_sym_type_class_arguments_repeat1 = 248,
  aux_sym_type_class_body_repeat1 = 249,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_module] = "module",
  [anon_sym_version] = "version",
  [anon_sym_is] = "is",
  [anon_sym_end] = "end",
  [anon_sym_import] = "import",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_as] = "as",
  [anon_sym_COLON] = ":",
  [anon_sym_AT] = "@",
  [anon_sym_EQ] = "=",
  [anon_sym_assert] = "assert",
  [sym_controlled_language_tag] = "controlled_language_tag",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_u2260] = "\u2260",
  [sym_less_than] = "less_than",
  [sym_greater_than] = "greater_than",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_u2264] = "\u2264",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_u2265] = "\u2265",
  [anon_sym_not] = "not",
  [anon_sym_u00ac] = "\u00ac",
  [anon_sym_and] = "and",
  [anon_sym_u2227] = "\u2227",
  [anon_sym_or] = "or",
  [anon_sym_u2228] = "\u2228",
  [anon_sym_xor] = "xor",
  [anon_sym_u22bb] = "\u22bb",
  [anon_sym_implies] = "implies",
  [anon_sym_EQ_EQ_GT] = "==>",
  [anon_sym_u21d2] = "\u21d2",
  [anon_sym_iff] = "iff",
  [anon_sym_LT_EQ_EQ_GT] = "<==>",
  [anon_sym_u21d4] = "\u21d4",
  [anon_sym_COMMA] = ",",
  [anon_sym_forall] = "forall",
  [anon_sym_u2200] = "\u2200",
  [anon_sym_exists] = "exists",
  [anon_sym_u2203] = "\u2203",
  [anon_sym_in] = "in",
  [anon_sym_u2208] = "\u2208",
  [anon_sym_DOT] = ".",
  [anon_sym_u2205] = "\u2205",
  [sym_reserved_self] = "reserved_self",
  [anon_sym_def] = "def",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_u2254] = "\u2254",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [sym_optional] = "optional",
  [anon_sym_PIPE] = "|",
  [anon_sym_boolean] = "boolean",
  [anon_sym_unsigned] = "unsigned",
  [anon_sym_integer] = "integer",
  [anon_sym_decimal] = "decimal",
  [anon_sym_double] = "double",
  [anon_sym_string] = "string",
  [anon_sym_iri] = "iri",
  [anon_sym_binary] = "binary",
  [sym_quoted_string] = "quoted_string",
  [sym_language_tag] = "language_tag",
  [anon_sym_LT] = "<",
  [aux_sym_iri_token1] = "iri_token1",
  [anon_sym_GT] = ">",
  [anon_sym_POUND_LBRACK] = "#[",
  [sym_hex_byte] = "hex_byte",
  [sym_double] = "double",
  [sym_decimal] = "decimal",
  [sym_integer] = "integer",
  [sym_unsigned] = "unsigned",
  [anon_sym_true] = "true",
  [anon_sym_u22a4] = "\u22a4",
  [anon_sym_false] = "false",
  [anon_sym_u22a5] = "\u22a5",
  [anon_sym_datatype] = "datatype",
  [sym_opaque] = "opaque",
  [anon_sym_dimension] = "dimension",
  [anon_sym_source] = "source",
  [anon_sym_with] = "with",
  [anon_sym_parent] = "parent",
  [anon_sym_entity] = "entity",
  [anon_sym_enum] = "enum",
  [anon_sym_of] = "of",
  [anon_sym_event] = "event",
  [anon_sym_property] = "property",
  [anon_sym_structure] = "structure",
  [anon_sym_union] = "union",
  [anon_sym_rdf] = "rdf",
  [anon_sym_type] = "type",
  [anon_sym_class] = "class",
  [anon_sym_PLUS] = "+",
  [sym_wildcard] = "wildcard",
  [anon_sym_identity] = "identity",
  [anon_sym_ref] = "ref",
  [sym_unknown_type] = "unknown_type",
  [anon_sym_ordered] = "ordered",
  [anon_sym_unordered] = "unordered",
  [anon_sym_unique] = "unique",
  [anon_sym_nonunique] = "nonunique",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_u2192] = "\u2192",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_u2190] = "\u2190",
  [anon_sym_LT_DASH] = "<-",
  [sym_line_comment] = "line_comment",
  [sym_module] = "module",
  [sym__module_locations] = "_module_locations",
  [sym_module_body] = "module_body",
  [sym_import_statement] = "import_statement",
  [sym__import] = "_import",
  [sym__rename_import] = "_rename_import",
  [sym_member_import] = "member_import",
  [sym_module_import] = "module_import",
  [sym_qualified_identifier] = "qualified_identifier",
  [sym_identifier_reference] = "identifier_reference",
  [sym_annotation] = "annotation",
  [sym_annotation_property] = "annotation_property",
  [sym_constraint] = "constraint",
  [sym_informal_constraint] = "informal_constraint",
  [sym_formal_constraint] = "formal_constraint",
  [sym_constraint_sentence] = "constraint_sentence",
  [sym_simple_sentence] = "simple_sentence",
  [sym_atomic_sentence] = "atomic_sentence",
  [sym_actual_arguments] = "actual_arguments",
  [sym_equation] = "equation",
  [sym_inequation] = "inequation",
  [sym_not_equal] = "not_equal",
  [sym_less_than_or_equal] = "less_than_or_equal",
  [sym_greater_than_or_equal] = "greater_than_or_equal",
  [sym_boolean_sentence] = "boolean_sentence",
  [sym_unary_boolean_sentence] = "unary_boolean_sentence",
  [sym_binary_boolean_sentence] = "binary_boolean_sentence",
  [sym_negation] = "negation",
  [sym__logical_connective] = "_logical_connective",
  [sym_conjunction] = "conjunction",
  [sym_disjunction] = "disjunction",
  [sym_exclusive_disjunction] = "exclusive_disjunction",
  [sym_implication] = "implication",
  [sym_biconditional] = "biconditional",
  [sym_quantified_sentence] = "quantified_sentence",
  [sym_quantified_variable_binding] = "quantified_variable_binding",
  [sym_universal] = "universal",
  [sym_existential] = "existential",
  [sym_quantified_variable] = "quantified_variable",
  [sym_term] = "term",
  [sym_functional_term] = "functional_term",
  [sym_function_composition] = "function_composition",
  [sym_predicate_value] = "predicate_value",
  [sym_sequence_of_predicate_values] = "sequence_of_predicate_values",
  [sym_constraint_environment] = "constraint_environment",
  [sym_environment_def] = "environment_def",
  [sym_constraint_environment_end] = "constraint_environment_end",
  [sym_function_def] = "function_def",
  [sym_function_body] = "function_body",
  [sym__by_definition] = "_by_definition",
  [sym_function_signature] = "function_signature",
  [sym_function_parameter] = "function_parameter",
  [sym__function_type] = "_function_type",
  [sym_function_cardinality_expression] = "function_cardinality_expression",
  [sym_function_type_reference] = "function_type_reference",
  [sym_constant_def] = "constant_def",
  [sym_sequence_builder] = "sequence_builder",
  [sym_named_variable_set] = "named_variable_set",
  [sym_mapping_variable] = "mapping_variable",
  [sym_sequence_builder_body] = "sequence_builder_body",
  [sym_value] = "value",
  [sym_sequence_of_values] = "sequence_of_values",
  [sym__sequence_value_constraints] = "_sequence_value_constraints",
  [sym_value_constructor] = "value_constructor",
  [sym_mapping_value] = "mapping_value",
  [sym_builtin_simple_type] = "builtin_simple_type",
  [sym_simple_value] = "simple_value",
  [sym_string] = "string",
  [sym_iri] = "iri",
  [sym_binary] = "binary",
  [sym_boolean] = "boolean",
  [sym_boolean_truth] = "boolean_truth",
  [sym_boolean_falsity] = "boolean_falsity",
  [sym_definition] = "definition",
  [sym_data_type_def] = "data_type_def",
  [sym__data_type_base] = "_data_type_base",
  [sym_annotation_only_body] = "annotation_only_body",
  [sym_dimension_def] = "dimension_def",
  [sym_dimension_body] = "dimension_body",
  [sym_source_entity] = "source_entity",
  [sym__identifier_or_list] = "_identifier_or_list",
  [sym_dimension_parent] = "dimension_parent",
  [sym_entity_def] = "entity_def",
  [sym_entity_body] = "entity_body",
  [sym_enum_def] = "enum_def",
  [sym_enum_body] = "enum_body",
  [sym_event_def] = "event_def",
  [sym_event_body] = "event_body",
  [sym_property_def] = "property_def",
  [sym_structure_def] = "structure_def",
  [sym_structure_body] = "structure_body",
  [sym_union_def] = "union_def",
  [sym_union_body] = "union_body",
  [sym_rdf_def] = "rdf_def",
  [sym_rdf_types] = "rdf_types",
  [sym_type_class_def] = "type_class_def",
  [sym_type_variable] = "type_variable",
  [sym__type_variable_restriction] = "_type_variable_restriction",
  [sym_type_class_reference] = "type_class_reference",
  [sym_type_class_arguments] = "type_class_arguments",
  [sym_type_class_body] = "type_class_body",
  [sym_method_def] = "method_def",
  [sym_entity_identity] = "entity_identity",
  [sym_member] = "member",
  [sym_member_def] = "member_def",
  [sym_property_ref] = "property_ref",
  [sym__type_expression_to] = "_type_expression_to",
  [sym_type_reference] = "type_reference",
  [sym_mapping_type] = "mapping_type",
  [sym_cardinality_expression] = "cardinality_expression",
  [sym__cardinality_inner] = "_cardinality_inner",
  [sym_sequence_ordering] = "sequence_ordering",
  [sym_sequence_uniqueness] = "sequence_uniqueness",
  [sym_cardinality_range] = "cardinality_range",
  [sym__has_type] = "_has_type",
  [sym__type_restriction] = "_type_restriction",
  [sym_value_variant] = "value_variant",
  [sym_type_variant] = "type_variant",
  [aux_sym_module_body_repeat1] = "module_body_repeat1",
  [aux_sym_module_body_repeat2] = "module_body_repeat2",
  [aux_sym_module_body_repeat3] = "module_body_repeat3",
  [aux_sym_import_statement_repeat1] = "import_statement_repeat1",
  [aux_sym_actual_arguments_repeat1] = "actual_arguments_repeat1",
  [aux_sym_function_composition_repeat1] = "function_composition_repeat1",
  [aux_sym_sequence_of_predicate_values_repeat1] = "sequence_of_predicate_values_repeat1",
  [aux_sym_constraint_environment_repeat1] = "constraint_environment_repeat1",
  [aux_sym_function_signature_repeat1] = "function_signature_repeat1",
  [aux_sym_named_variable_set_repeat1] = "named_variable_set_repeat1",
  [aux_sym_sequence_of_values_repeat1] = "sequence_of_values_repeat1",
  [aux_sym_binary_repeat1] = "binary_repeat1",
  [aux_sym_dimension_body_repeat1] = "dimension_body_repeat1",
  [aux_sym_dimension_body_repeat2] = "dimension_body_repeat2",
  [aux_sym__identifier_or_list_repeat1] = "_identifier_or_list_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_union_body_repeat1] = "union_body_repeat1",
  [aux_sym_rdf_types_repeat1] = "rdf_types_repeat1",
  [aux_sym_type_class_def_repeat1] = "type_class_def_repeat1",
  [aux_sym__type_variable_restriction_repeat1] = "_type_variable_restriction_repeat1",
  [aux_sym_type_class_arguments_repeat1] = "type_class_arguments_repeat1",
  [aux_sym_type_class_body_repeat1] = "type_class_body_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_version] = anon_sym_version,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_assert] = anon_sym_assert,
  [sym_controlled_language_tag] = sym_controlled_language_tag,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_u2260] = anon_sym_u2260,
  [sym_less_than] = sym_less_than,
  [sym_greater_than] = sym_greater_than,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_u2264] = anon_sym_u2264,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_u2265] = anon_sym_u2265,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_u00ac] = anon_sym_u00ac,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_u2227] = anon_sym_u2227,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_u2228] = anon_sym_u2228,
  [anon_sym_xor] = anon_sym_xor,
  [anon_sym_u22bb] = anon_sym_u22bb,
  [anon_sym_implies] = anon_sym_implies,
  [anon_sym_EQ_EQ_GT] = anon_sym_EQ_EQ_GT,
  [anon_sym_u21d2] = anon_sym_u21d2,
  [anon_sym_iff] = anon_sym_iff,
  [anon_sym_LT_EQ_EQ_GT] = anon_sym_LT_EQ_EQ_GT,
  [anon_sym_u21d4] = anon_sym_u21d4,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_forall] = anon_sym_forall,
  [anon_sym_u2200] = anon_sym_u2200,
  [anon_sym_exists] = anon_sym_exists,
  [anon_sym_u2203] = anon_sym_u2203,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_u2208] = anon_sym_u2208,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_u2205] = anon_sym_u2205,
  [sym_reserved_self] = sym_reserved_self,
  [anon_sym_def] = anon_sym_def,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_u2254] = anon_sym_u2254,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [sym_optional] = sym_optional,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_boolean] = anon_sym_boolean,
  [anon_sym_unsigned] = anon_sym_unsigned,
  [anon_sym_integer] = anon_sym_integer,
  [anon_sym_decimal] = anon_sym_decimal,
  [anon_sym_double] = anon_sym_double,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_iri] = anon_sym_iri,
  [anon_sym_binary] = anon_sym_binary,
  [sym_quoted_string] = sym_quoted_string,
  [sym_language_tag] = sym_language_tag,
  [anon_sym_LT] = anon_sym_LT,
  [aux_sym_iri_token1] = aux_sym_iri_token1,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_POUND_LBRACK] = anon_sym_POUND_LBRACK,
  [sym_hex_byte] = sym_hex_byte,
  [sym_double] = sym_double,
  [sym_decimal] = sym_decimal,
  [sym_integer] = sym_integer,
  [sym_unsigned] = sym_unsigned,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_u22a4] = anon_sym_u22a4,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_u22a5] = anon_sym_u22a5,
  [anon_sym_datatype] = anon_sym_datatype,
  [sym_opaque] = sym_opaque,
  [anon_sym_dimension] = anon_sym_dimension,
  [anon_sym_source] = anon_sym_source,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_parent] = anon_sym_parent,
  [anon_sym_entity] = anon_sym_entity,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_event] = anon_sym_event,
  [anon_sym_property] = anon_sym_property,
  [anon_sym_structure] = anon_sym_structure,
  [anon_sym_union] = anon_sym_union,
  [anon_sym_rdf] = anon_sym_rdf,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [sym_wildcard] = sym_wildcard,
  [anon_sym_identity] = anon_sym_identity,
  [anon_sym_ref] = anon_sym_ref,
  [sym_unknown_type] = sym_unknown_type,
  [anon_sym_ordered] = anon_sym_ordered,
  [anon_sym_unordered] = anon_sym_unordered,
  [anon_sym_unique] = anon_sym_unique,
  [anon_sym_nonunique] = anon_sym_nonunique,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_u2192] = anon_sym_u2192,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_u2190] = anon_sym_u2190,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [sym_line_comment] = sym_line_comment,
  [sym_module] = sym_module,
  [sym__module_locations] = sym__module_locations,
  [sym_module_body] = sym_module_body,
  [sym_import_statement] = sym_import_statement,
  [sym__import] = sym__import,
  [sym__rename_import] = sym__rename_import,
  [sym_member_import] = sym_member_import,
  [sym_module_import] = sym_module_import,
  [sym_qualified_identifier] = sym_qualified_identifier,
  [sym_identifier_reference] = sym_identifier_reference,
  [sym_annotation] = sym_annotation,
  [sym_annotation_property] = sym_annotation_property,
  [sym_constraint] = sym_constraint,
  [sym_informal_constraint] = sym_informal_constraint,
  [sym_formal_constraint] = sym_formal_constraint,
  [sym_constraint_sentence] = sym_constraint_sentence,
  [sym_simple_sentence] = sym_simple_sentence,
  [sym_atomic_sentence] = sym_atomic_sentence,
  [sym_actual_arguments] = sym_actual_arguments,
  [sym_equation] = sym_equation,
  [sym_inequation] = sym_inequation,
  [sym_not_equal] = sym_not_equal,
  [sym_less_than_or_equal] = sym_less_than_or_equal,
  [sym_greater_than_or_equal] = sym_greater_than_or_equal,
  [sym_boolean_sentence] = sym_boolean_sentence,
  [sym_unary_boolean_sentence] = sym_unary_boolean_sentence,
  [sym_binary_boolean_sentence] = sym_binary_boolean_sentence,
  [sym_negation] = sym_negation,
  [sym__logical_connective] = sym__logical_connective,
  [sym_conjunction] = sym_conjunction,
  [sym_disjunction] = sym_disjunction,
  [sym_exclusive_disjunction] = sym_exclusive_disjunction,
  [sym_implication] = sym_implication,
  [sym_biconditional] = sym_biconditional,
  [sym_quantified_sentence] = sym_quantified_sentence,
  [sym_quantified_variable_binding] = sym_quantified_variable_binding,
  [sym_universal] = sym_universal,
  [sym_existential] = sym_existential,
  [sym_quantified_variable] = sym_quantified_variable,
  [sym_term] = sym_term,
  [sym_functional_term] = sym_functional_term,
  [sym_function_composition] = sym_function_composition,
  [sym_predicate_value] = sym_predicate_value,
  [sym_sequence_of_predicate_values] = sym_sequence_of_predicate_values,
  [sym_constraint_environment] = sym_constraint_environment,
  [sym_environment_def] = sym_environment_def,
  [sym_constraint_environment_end] = sym_constraint_environment_end,
  [sym_function_def] = sym_function_def,
  [sym_function_body] = sym_function_body,
  [sym__by_definition] = sym__by_definition,
  [sym_function_signature] = sym_function_signature,
  [sym_function_parameter] = sym_function_parameter,
  [sym__function_type] = sym__function_type,
  [sym_function_cardinality_expression] = sym_function_cardinality_expression,
  [sym_function_type_reference] = sym_function_type_reference,
  [sym_constant_def] = sym_constant_def,
  [sym_sequence_builder] = sym_sequence_builder,
  [sym_named_variable_set] = sym_named_variable_set,
  [sym_mapping_variable] = sym_mapping_variable,
  [sym_sequence_builder_body] = sym_sequence_builder_body,
  [sym_value] = sym_value,
  [sym_sequence_of_values] = sym_sequence_of_values,
  [sym__sequence_value_constraints] = sym__sequence_value_constraints,
  [sym_value_constructor] = sym_value_constructor,
  [sym_mapping_value] = sym_mapping_value,
  [sym_builtin_simple_type] = sym_builtin_simple_type,
  [sym_simple_value] = sym_simple_value,
  [sym_string] = sym_string,
  [sym_iri] = sym_iri,
  [sym_binary] = sym_binary,
  [sym_boolean] = sym_boolean,
  [sym_boolean_truth] = sym_boolean_truth,
  [sym_boolean_falsity] = sym_boolean_falsity,
  [sym_definition] = sym_definition,
  [sym_data_type_def] = sym_data_type_def,
  [sym__data_type_base] = sym__data_type_base,
  [sym_annotation_only_body] = sym_annotation_only_body,
  [sym_dimension_def] = sym_dimension_def,
  [sym_dimension_body] = sym_dimension_body,
  [sym_source_entity] = sym_source_entity,
  [sym__identifier_or_list] = sym__identifier_or_list,
  [sym_dimension_parent] = sym_dimension_parent,
  [sym_entity_def] = sym_entity_def,
  [sym_entity_body] = sym_entity_body,
  [sym_enum_def] = sym_enum_def,
  [sym_enum_body] = sym_enum_body,
  [sym_event_def] = sym_event_def,
  [sym_event_body] = sym_event_body,
  [sym_property_def] = sym_property_def,
  [sym_structure_def] = sym_structure_def,
  [sym_structure_body] = sym_structure_body,
  [sym_union_def] = sym_union_def,
  [sym_union_body] = sym_union_body,
  [sym_rdf_def] = sym_rdf_def,
  [sym_rdf_types] = sym_rdf_types,
  [sym_type_class_def] = sym_type_class_def,
  [sym_type_variable] = sym_type_variable,
  [sym__type_variable_restriction] = sym__type_variable_restriction,
  [sym_type_class_reference] = sym_type_class_reference,
  [sym_type_class_arguments] = sym_type_class_arguments,
  [sym_type_class_body] = sym_type_class_body,
  [sym_method_def] = sym_method_def,
  [sym_entity_identity] = sym_entity_identity,
  [sym_member] = sym_member,
  [sym_member_def] = sym_member_def,
  [sym_property_ref] = sym_property_ref,
  [sym__type_expression_to] = sym__type_expression_to,
  [sym_type_reference] = sym_type_reference,
  [sym_mapping_type] = sym_mapping_type,
  [sym_cardinality_expression] = sym_cardinality_expression,
  [sym__cardinality_inner] = sym__cardinality_inner,
  [sym_sequence_ordering] = sym_sequence_ordering,
  [sym_sequence_uniqueness] = sym_sequence_uniqueness,
  [sym_cardinality_range] = sym_cardinality_range,
  [sym__has_type] = sym__has_type,
  [sym__type_restriction] = sym__type_restriction,
  [sym_value_variant] = sym_value_variant,
  [sym_type_variant] = sym_type_variant,
  [aux_sym_module_body_repeat1] = aux_sym_module_body_repeat1,
  [aux_sym_module_body_repeat2] = aux_sym_module_body_repeat2,
  [aux_sym_module_body_repeat3] = aux_sym_module_body_repeat3,
  [aux_sym_import_statement_repeat1] = aux_sym_import_statement_repeat1,
  [aux_sym_actual_arguments_repeat1] = aux_sym_actual_arguments_repeat1,
  [aux_sym_function_composition_repeat1] = aux_sym_function_composition_repeat1,
  [aux_sym_sequence_of_predicate_values_repeat1] = aux_sym_sequence_of_predicate_values_repeat1,
  [aux_sym_constraint_environment_repeat1] = aux_sym_constraint_environment_repeat1,
  [aux_sym_function_signature_repeat1] = aux_sym_function_signature_repeat1,
  [aux_sym_named_variable_set_repeat1] = aux_sym_named_variable_set_repeat1,
  [aux_sym_sequence_of_values_repeat1] = aux_sym_sequence_of_values_repeat1,
  [aux_sym_binary_repeat1] = aux_sym_binary_repeat1,
  [aux_sym_dimension_body_repeat1] = aux_sym_dimension_body_repeat1,
  [aux_sym_dimension_body_repeat2] = aux_sym_dimension_body_repeat2,
  [aux_sym__identifier_or_list_repeat1] = aux_sym__identifier_or_list_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_union_body_repeat1] = aux_sym_union_body_repeat1,
  [aux_sym_rdf_types_repeat1] = aux_sym_rdf_types_repeat1,
  [aux_sym_type_class_def_repeat1] = aux_sym_type_class_def_repeat1,
  [aux_sym__type_variable_restriction_repeat1] = aux_sym__type_variable_restriction_repeat1,
  [aux_sym_type_class_arguments_repeat1] = aux_sym_type_class_arguments_repeat1,
  [aux_sym_type_class_body_repeat1] = aux_sym_type_class_body_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_version] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [sym_controlled_language_tag] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2260] = {
    .visible = true,
    .named = false,
  },
  [sym_less_than] = {
    .visible = true,
    .named = true,
  },
  [sym_greater_than] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2264] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2265] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u00ac] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2227] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2228] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u22bb] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implies] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u21d2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iff] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u21d4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_forall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2200] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exists] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2203] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2208] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2205] = {
    .visible = true,
    .named = false,
  },
  [sym_reserved_self] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_def] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2254] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym_optional] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_boolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsigned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_integer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_decimal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_double] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iri] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_binary] = {
    .visible = true,
    .named = false,
  },
  [sym_quoted_string] = {
    .visible = true,
    .named = true,
  },
  [sym_language_tag] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_iri_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym_hex_byte] = {
    .visible = true,
    .named = true,
  },
  [sym_double] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_unsigned] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u22a4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u22a5] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_datatype] = {
    .visible = true,
    .named = false,
  },
  [sym_opaque] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_dimension] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_source] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_parent] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_entity] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_event] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_property] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_structure] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_union] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rdf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [sym_wildcard] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_identity] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ref] = {
    .visible = true,
    .named = false,
  },
  [sym_unknown_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ordered] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unordered] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unique] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonunique] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2192] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2190] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym__module_locations] = {
    .visible = false,
    .named = true,
  },
  [sym_module_body] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__import] = {
    .visible = false,
    .named = true,
  },
  [sym__rename_import] = {
    .visible = false,
    .named = true,
  },
  [sym_member_import] = {
    .visible = true,
    .named = true,
  },
  [sym_module_import] = {
    .visible = true,
    .named = true,
  },
  [sym_qualified_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_property] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_informal_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint_sentence] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_sentence] = {
    .visible = true,
    .named = true,
  },
  [sym_atomic_sentence] = {
    .visible = true,
    .named = true,
  },
  [sym_actual_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_equation] = {
    .visible = true,
    .named = true,
  },
  [sym_inequation] = {
    .visible = true,
    .named = true,
  },
  [sym_not_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_less_than_or_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_greater_than_or_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_sentence] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_boolean_sentence] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_boolean_sentence] = {
    .visible = true,
    .named = true,
  },
  [sym_negation] = {
    .visible = true,
    .named = true,
  },
  [sym__logical_connective] = {
    .visible = false,
    .named = true,
  },
  [sym_conjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_disjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_exclusive_disjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_implication] = {
    .visible = true,
    .named = true,
  },
  [sym_biconditional] = {
    .visible = true,
    .named = true,
  },
  [sym_quantified_sentence] = {
    .visible = true,
    .named = true,
  },
  [sym_quantified_variable_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_universal] = {
    .visible = true,
    .named = true,
  },
  [sym_existential] = {
    .visible = true,
    .named = true,
  },
  [sym_quantified_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_term] = {
    .visible = true,
    .named = true,
  },
  [sym_functional_term] = {
    .visible = true,
    .named = true,
  },
  [sym_function_composition] = {
    .visible = true,
    .named = true,
  },
  [sym_predicate_value] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_of_predicate_values] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint_environment] = {
    .visible = true,
    .named = true,
  },
  [sym_environment_def] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym_function_def] = {
    .visible = true,
    .named = true,
  },
  [sym_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym__by_definition] = {
    .visible = false,
    .named = true,
  },
  [sym_function_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__function_type] = {
    .visible = false,
    .named = true,
  },
  [sym_function_cardinality_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_def] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_builder] = {
    .visible = true,
    .named = true,
  },
  [sym_named_variable_set] = {
    .visible = true,
    .named = true,
  },
  [sym_mapping_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_builder_body] = {
    .visible = true,
    .named = true,
  },
  [sym_value] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_of_values] = {
    .visible = true,
    .named = true,
  },
  [sym__sequence_value_constraints] = {
    .visible = false,
    .named = true,
  },
  [sym_value_constructor] = {
    .visible = true,
    .named = true,
  },
  [sym_mapping_value] = {
    .visible = true,
    .named = true,
  },
  [sym_builtin_simple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_value] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_iri] = {
    .visible = true,
    .named = true,
  },
  [sym_binary] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_truth] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_falsity] = {
    .visible = true,
    .named = true,
  },
  [sym_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_data_type_def] = {
    .visible = true,
    .named = true,
  },
  [sym__data_type_base] = {
    .visible = false,
    .named = true,
  },
  [sym_annotation_only_body] = {
    .visible = true,
    .named = true,
  },
  [sym_dimension_def] = {
    .visible = true,
    .named = true,
  },
  [sym_dimension_body] = {
    .visible = true,
    .named = true,
  },
  [sym_source_entity] = {
    .visible = true,
    .named = true,
  },
  [sym__identifier_or_list] = {
    .visible = false,
    .named = true,
  },
  [sym_dimension_parent] = {
    .visible = true,
    .named = true,
  },
  [sym_entity_def] = {
    .visible = true,
    .named = true,
  },
  [sym_entity_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_def] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_event_def] = {
    .visible = true,
    .named = true,
  },
  [sym_event_body] = {
    .visible = true,
    .named = true,
  },
  [sym_property_def] = {
    .visible = true,
    .named = true,
  },
  [sym_structure_def] = {
    .visible = true,
    .named = true,
  },
  [sym_structure_body] = {
    .visible = true,
    .named = true,
  },
  [sym_union_def] = {
    .visible = true,
    .named = true,
  },
  [sym_union_body] = {
    .visible = true,
    .named = true,
  },
  [sym_rdf_def] = {
    .visible = true,
    .named = true,
  },
  [sym_rdf_types] = {
    .visible = true,
    .named = true,
  },
  [sym_type_class_def] = {
    .visible = true,
    .named = true,
  },
  [sym_type_variable] = {
    .visible = true,
    .named = true,
  },
  [sym__type_variable_restriction] = {
    .visible = false,
    .named = true,
  },
  [sym_type_class_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_type_class_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_type_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_method_def] = {
    .visible = true,
    .named = true,
  },
  [sym_entity_identity] = {
    .visible = true,
    .named = true,
  },
  [sym_member] = {
    .visible = true,
    .named = true,
  },
  [sym_member_def] = {
    .visible = true,
    .named = true,
  },
  [sym_property_ref] = {
    .visible = true,
    .named = true,
  },
  [sym__type_expression_to] = {
    .visible = false,
    .named = true,
  },
  [sym_type_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_mapping_type] = {
    .visible = true,
    .named = true,
  },
  [sym_cardinality_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__cardinality_inner] = {
    .visible = false,
    .named = true,
  },
  [sym_sequence_ordering] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_uniqueness] = {
    .visible = true,
    .named = true,
  },
  [sym_cardinality_range] = {
    .visible = true,
    .named = true,
  },
  [sym__has_type] = {
    .visible = false,
    .named = true,
  },
  [sym__type_restriction] = {
    .visible = false,
    .named = true,
  },
  [sym_value_variant] = {
    .visible = true,
    .named = true,
  },
  [sym_type_variant] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_module_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_body_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_body_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_actual_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_composition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sequence_of_predicate_values_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constraint_environment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_signature_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_variable_set_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sequence_of_values_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_binary_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimension_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimension_body_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__identifier_or_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_rdf_types_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_class_def_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__type_variable_restriction_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_class_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_argument = 1,
  field_arguments = 2,
  field_base = 3,
  field_binding = 4,
  field_body = 5,
  field_byte = 6,
  field_cardinality = 7,
  field_domain = 8,
  field_element = 9,
  field_empty = 10,
  field_entity = 11,
  field_environment = 12,
  field_function = 13,
  field_identity = 14,
  field_language = 15,
  field_lhs = 16,
  field_max = 17,
  field_member = 18,
  field_method = 19,
  field_min = 20,
  field_module = 21,
  field_name = 22,
  field_opaque = 23,
  field_operator = 24,
  field_ordering = 25,
  field_parameter = 26,
  field_predicate = 27,
  field_property = 28,
  field_quantifier = 29,
  field_range = 30,
  field_relation = 31,
  field_rename = 32,
  field_rhs = 33,
  field_signature = 34,
  field_source = 35,
  field_subject = 36,
  field_target = 37,
  field_type = 38,
  field_types = 39,
  field_uniqueness = 40,
  field_value = 41,
  field_variable = 42,
  field_version_info = 43,
  field_version_uri = 44,
  field_wildcard = 45,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_base] = "base",
  [field_binding] = "binding",
  [field_body] = "body",
  [field_byte] = "byte",
  [field_cardinality] = "cardinality",
  [field_domain] = "domain",
  [field_element] = "element",
  [field_empty] = "empty",
  [field_entity] = "entity",
  [field_environment] = "environment",
  [field_function] = "function",
  [field_identity] = "identity",
  [field_language] = "language",
  [field_lhs] = "lhs",
  [field_max] = "max",
  [field_member] = "member",
  [field_method] = "method",
  [field_min] = "min",
  [field_module] = "module",
  [field_name] = "name",
  [field_opaque] = "opaque",
  [field_operator] = "operator",
  [field_ordering] = "ordering",
  [field_parameter] = "parameter",
  [field_predicate] = "predicate",
  [field_property] = "property",
  [field_quantifier] = "quantifier",
  [field_range] = "range",
  [field_relation] = "relation",
  [field_rename] = "rename",
  [field_rhs] = "rhs",
  [field_signature] = "signature",
  [field_source] = "source",
  [field_subject] = "subject",
  [field_target] = "target",
  [field_type] = "type",
  [field_types] = "types",
  [field_uniqueness] = "uniqueness",
  [field_value] = "value",
  [field_variable] = "variable",
  [field_version_info] = "version_info",
  [field_version_uri] = "version_uri",
  [field_wildcard] = "wildcard",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
  [2] = {.index = 2, .length = 1},
  [3] = {.index = 3, .length = 5},
  [4] = {.index = 8, .length = 1},
  [5] = {.index = 9, .length = 1},
  [6] = {.index = 10, .length = 1},
  [7] = {.index = 11, .length = 2},
  [8] = {.index = 13, .length = 2},
  [9] = {.index = 15, .length = 2},
  [10] = {.index = 17, .length = 3},
  [11] = {.index = 20, .length = 3},
  [12] = {.index = 23, .length = 1},
  [13] = {.index = 24, .length = 2},
  [14] = {.index = 26, .length = 3},
  [15] = {.index = 29, .length = 1},
  [16] = {.index = 30, .length = 2},
  [17] = {.index = 32, .length = 1},
  [18] = {.index = 33, .length = 2},
  [19] = {.index = 35, .length = 4},
  [20] = {.index = 39, .length = 1},
  [21] = {.index = 40, .length = 1},
  [22] = {.index = 41, .length = 3},
  [23] = {.index = 44, .length = 1},
  [24] = {.index = 45, .length = 1},
  [25] = {.index = 46, .length = 1},
  [26] = {.index = 47, .length = 1},
  [27] = {.index = 48, .length = 1},
  [28] = {.index = 49, .length = 2},
  [29] = {.index = 51, .length = 1},
  [30] = {.index = 52, .length = 2},
  [31] = {.index = 54, .length = 1},
  [32] = {.index = 55, .length = 2},
  [33] = {.index = 57, .length = 1},
  [34] = {.index = 58, .length = 1},
  [35] = {.index = 59, .length = 2},
  [36] = {.index = 61, .length = 3},
  [37] = {.index = 64, .length = 3},
  [38] = {.index = 67, .length = 1},
  [39] = {.index = 68, .length = 1},
  [40] = {.index = 69, .length = 2},
  [41] = {.index = 71, .length = 1},
  [42] = {.index = 72, .length = 2},
  [43] = {.index = 74, .length = 1},
  [44] = {.index = 75, .length = 1},
  [45] = {.index = 76, .length = 1},
  [46] = {.index = 77, .length = 2},
  [47] = {.index = 79, .length = 2},
  [48] = {.index = 81, .length = 2},
  [49] = {.index = 83, .length = 2},
  [50] = {.index = 85, .length = 1},
  [51] = {.index = 86, .length = 2},
  [52] = {.index = 88, .length = 1},
  [53] = {.index = 89, .length = 1},
  [54] = {.index = 90, .length = 1},
  [55] = {.index = 91, .length = 2},
  [56] = {.index = 93, .length = 2},
  [57] = {.index = 95, .length = 2},
  [58] = {.index = 97, .length = 2},
  [59] = {.index = 99, .length = 2},
  [60] = {.index = 101, .length = 3},
  [61] = {.index = 104, .length = 2},
  [62] = {.index = 106, .length = 2},
  [63] = {.index = 108, .length = 1},
  [64] = {.index = 109, .length = 3},
  [65] = {.index = 112, .length = 2},
  [66] = {.index = 114, .length = 4},
  [67] = {.index = 118, .length = 1},
  [68] = {.index = 119, .length = 2},
  [69] = {.index = 121, .length = 2},
  [70] = {.index = 123, .length = 2},
  [71] = {.index = 125, .length = 1},
  [72] = {.index = 126, .length = 2},
  [73] = {.index = 128, .length = 2},
  [74] = {.index = 130, .length = 1},
  [75] = {.index = 131, .length = 3},
  [76] = {.index = 134, .length = 2},
  [77] = {.index = 136, .length = 2},
  [78] = {.index = 138, .length = 3},
  [79] = {.index = 141, .length = 1},
  [80] = {.index = 142, .length = 2},
  [81] = {.index = 144, .length = 2},
  [82] = {.index = 146, .length = 1},
  [83] = {.index = 147, .length = 2},
  [84] = {.index = 149, .length = 1},
  [85] = {.index = 150, .length = 2},
  [86] = {.index = 152, .length = 1},
  [87] = {.index = 153, .length = 3},
  [88] = {.index = 156, .length = 3},
  [89] = {.index = 159, .length = 3},
  [90] = {.index = 162, .length = 3},
  [91] = {.index = 165, .length = 2},
  [92] = {.index = 167, .length = 2},
  [93] = {.index = 169, .length = 2},
  [94] = {.index = 171, .length = 2},
  [95] = {.index = 173, .length = 2},
  [96] = {.index = 175, .length = 2},
  [97] = {.index = 177, .length = 4},
  [98] = {.index = 181, .length = 3},
  [99] = {.index = 184, .length = 1},
  [100] = {.index = 185, .length = 2},
  [101] = {.index = 187, .length = 3},
  [102] = {.index = 190, .length = 1},
  [103] = {.index = 191, .length = 1},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_body, 2},
    {field_name, 1},
  [2] =
    {field_base, 0},
  [3] =
    {field_base, 2, .inherited = true},
    {field_body, 3},
    {field_name, 1},
    {field_version_info, 2, .inherited = true},
    {field_version_uri, 2, .inherited = true},
  [8] =
    {field_name, 0},
  [9] =
    {field_name, 1},
  [10] =
    {field_member, 1},
  [11] =
    {field_base, 0},
    {field_version_uri, 2},
  [13] =
    {field_name, 0},
    {field_rename, 1, .inherited = true},
  [15] =
    {field_name, 0},
    {field_version_uri, 1},
  [17] =
    {field_cardinality, 1, .inherited = true},
    {field_name, 0},
    {field_target, 1, .inherited = true},
  [20] =
    {field_base, 0},
    {field_version_info, 2},
    {field_version_uri, 3},
  [23] =
    {field_rename, 1},
  [24] =
    {field_member, 2},
    {field_module, 0},
  [26] =
    {field_name, 0},
    {field_rename, 2, .inherited = true},
    {field_version_uri, 1},
  [29] =
    {field_empty, 0},
  [30] =
    {field_name, 1},
    {field_value, 3},
  [32] =
    {field_value, 1},
  [33] =
    {field_base, 3},
    {field_name, 1},
  [35] =
    {field_body, 2},
    {field_cardinality, 1, .inherited = true},
    {field_name, 0},
    {field_target, 1, .inherited = true},
  [39] =
    {field_target, 1},
  [40] =
    {field_type, 1},
  [41] =
    {field_body, 3},
    {field_name, 1},
    {field_types, 2},
  [44] =
    {field_method, 0},
  [45] =
    {field_variable, 0},
  [46] =
    {field_element, 0},
  [47] =
    {field_language, 1},
  [48] =
    {field_byte, 0},
  [49] =
    {field_name, 1, .inherited = true},
    {field_subject, 0},
  [51] =
    {field_body, 1},
  [52] =
    {field_operator, 0},
    {field_rhs, 1},
  [54] =
    {field_source, 0},
  [55] =
    {field_binding, 1},
    {field_quantifier, 0},
  [57] =
    {field_predicate, 0},
  [58] =
    {field_function, 0},
  [59] =
    {field_language, 2},
    {field_value, 1},
  [61] =
    {field_base, 4},
    {field_name, 1},
    {field_opaque, 3},
  [64] =
    {field_base, 3},
    {field_body, 4},
    {field_name, 1},
  [67] =
    {field_entity, 1},
  [68] =
    {field_identity, 1},
  [69] =
    {field_body, 1},
    {field_name, 0},
  [71] =
    {field_min, 0},
  [72] =
    {field_cardinality, 1},
    {field_target, 2},
  [74] =
    {field_property, 1},
  [75] =
    {field_type, 0},
  [76] =
    {field_method, 1, .inherited = true},
  [77] =
    {field_method, 0, .inherited = true},
    {field_method, 1, .inherited = true},
  [79] =
    {field_cardinality, 0},
    {field_name, 1},
  [81] =
    {field_name, 1},
    {field_variable, 3, .inherited = true},
  [83] =
    {field_variable, 0, .inherited = true},
    {field_variable, 1, .inherited = true},
  [85] =
    {field_element, 1, .inherited = true},
  [86] =
    {field_element, 0, .inherited = true},
    {field_element, 1, .inherited = true},
  [88] =
    {field_ordering, 1},
  [89] =
    {field_uniqueness, 1},
  [90] =
    {field_byte, 1, .inherited = true},
  [91] =
    {field_byte, 0, .inherited = true},
    {field_byte, 1, .inherited = true},
  [93] =
    {field_ordering, 0, .inherited = true},
    {field_uniqueness, 0, .inherited = true},
  [95] =
    {field_domain, 0},
    {field_range, 2},
  [97] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [99] =
    {field_cardinality, 0, .inherited = true},
    {field_target, 0, .inherited = true},
  [101] =
    {field_lhs, 0},
    {field_operator, 1},
    {field_rhs, 2},
  [104] =
    {field_binding, 0},
    {field_body, 2},
  [106] =
    {field_lhs, 0},
    {field_rhs, 2},
  [108] =
    {field_argument, 0},
  [109] =
    {field_lhs, 0},
    {field_relation, 1},
    {field_rhs, 2},
  [112] =
    {field_body, 2},
    {field_environment, 1},
  [114] =
    {field_base, 4},
    {field_body, 5},
    {field_name, 1},
    {field_opaque, 3},
  [118] =
    {field_identity, 2},
  [119] =
    {field_min, 0},
    {field_range, 1},
  [121] =
    {field_min, 1, .inherited = true},
    {field_range, 1, .inherited = true},
  [123] =
    {field_name, 0},
    {field_rename, 2},
  [125] =
    {field_type, 2, .inherited = true},
  [126] =
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [128] =
    {field_name, 1},
    {field_signature, 2},
  [130] =
    {field_method, 2, .inherited = true},
  [131] =
    {field_body, 5},
    {field_name, 1},
    {field_variable, 3, .inherited = true},
  [134] =
    {field_ordering, 1},
    {field_uniqueness, 2},
  [136] =
    {field_name, 0},
    {field_value, 2},
  [138] =
    {field_element, 2, .inherited = true},
    {field_ordering, 0, .inherited = true},
    {field_uniqueness, 0, .inherited = true},
  [141] =
    {field_parameter, 0},
  [142] =
    {field_body, 1},
    {field_signature, 0},
  [144] =
    {field_name, 0},
    {field_source, 2},
  [146] =
    {field_argument, 1, .inherited = true},
  [147] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [149] =
    {field_member, 0},
  [150] =
    {field_entity, 1},
    {field_member, 3, .inherited = true},
  [152] =
    {field_max, 1},
  [153] =
    {field_min, 2, .inherited = true},
    {field_ordering, 1},
    {field_range, 2, .inherited = true},
  [156] =
    {field_min, 2, .inherited = true},
    {field_range, 2, .inherited = true},
    {field_uniqueness, 1},
  [159] =
    {field_body, 3},
    {field_name, 0},
    {field_rename, 2},
  [162] =
    {field_body, 3},
    {field_name, 1},
    {field_signature, 2},
  [165] =
    {field_arguments, 1},
    {field_name, 0},
  [167] =
    {field_cardinality, 2, .inherited = true},
    {field_target, 2, .inherited = true},
  [169] =
    {field_parameter, 0, .inherited = true},
    {field_parameter, 1, .inherited = true},
  [171] =
    {field_body, 3},
    {field_variable, 1},
  [173] =
    {field_entity, 3},
    {field_name, 1},
  [175] =
    {field_domain, 1},
    {field_range, 3},
  [177] =
    {field_min, 3, .inherited = true},
    {field_ordering, 1},
    {field_range, 3, .inherited = true},
    {field_uniqueness, 2},
  [181] =
    {field_cardinality, 3, .inherited = true},
    {field_parameter, 1, .inherited = true},
    {field_target, 3, .inherited = true},
  [184] =
    {field_member, 1, .inherited = true},
  [185] =
    {field_member, 0, .inherited = true},
    {field_member, 1, .inherited = true},
  [187] =
    {field_body, 4},
    {field_entity, 3},
    {field_name, 1},
  [190] =
    {field_wildcard, 1},
  [191] =
    {field_variable, 1, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'A', 'Z'}, {'a', 'z'}, {0xb5, 0xb5}, {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x1ba}, {0x1bc, 0x1bf}, {0x1c4, 0x1c4},
  {0x1c6, 0x1c7}, {0x1c9, 0x1ca}, {0x1cc, 0x1f1}, {0x1f3, 0x293}, {0x295, 0x2af}, {0x370, 0x373}, {0x376, 0x377}, {0x37b, 0x37d},
  {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481}, {0x48a, 0x52f},
  {0x531, 0x556}, {0x560, 0x588}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fd, 0x10ff}, {0x13a0, 0x13f5},
  {0x13f8, 0x13fd}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1d00, 0x1d2b}, {0x1d6b, 0x1d77}, {0x1d79, 0x1d9a}, {0x1e00, 0x1f15},
  {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d},
  {0x1f80, 0x1f87}, {0x1f90, 0x1f97}, {0x1fa0, 0x1fa7}, {0x1fb0, 0x1fb4}, {0x1fb6, 0x1fbb}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcb},
  {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffb}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113},
  {0x2115, 0x2115}, {0x2119, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x212d}, {0x212f, 0x2134}, {0x2139, 0x2139},
  {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2183, 0x2184}, {0x2c00, 0x2c7b}, {0x2c7e, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3},
  {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0xa640, 0xa66d}, {0xa680, 0xa69b}, {0xa722, 0xa76f}, {0xa771, 0xa787}, {0xa78b, 0xa78e},
  {0xa790, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f5, 0xa7f6}, {0xa7fa, 0xa7fa}, {0xab30, 0xab5a}, {0xab60, 0xab68},
  {0xab70, 0xabbf}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0x10400, 0x1044f}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb},
  {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'0', '9'}, {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xb5, 0xb5}, {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x1ba},
  {0x1bc, 0x1bf}, {0x1c4, 0x1c4}, {0x1c6, 0x1c7}, {0x1c9, 0x1ca}, {0x1cc, 0x1f1}, {0x1f3, 0x293}, {0x295, 0x2af}, {0x370, 0x373},
  {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5},
  {0x3f7, 0x481}, {0x48a, 0x52f}, {0x531, 0x556}, {0x560, 0x588}, {0x660, 0x669}, {0x6f0, 0x6f9}, {0x7c0, 0x7c9}, {0x966, 0x96f},
  {0x9e6, 0x9ef}, {0xa66, 0xa6f}, {0xae6, 0xaef}, {0xb66, 0xb6f}, {0xbe6, 0xbef}, {0xc66, 0xc6f}, {0xce6, 0xcef}, {0xd66, 0xd6f},
  {0xde6, 0xdef}, {0xe50, 0xe59}, {0xed0, 0xed9}, {0xf20, 0xf29}, {0x1040, 0x1049}, {0x1090, 0x1099}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7},
  {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fd, 0x10ff}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x17e0, 0x17e9}, {0x1810, 0x1819}, {0x1946, 0x194f},
  {0x19d0, 0x19d9}, {0x1a80, 0x1a89}, {0x1a90, 0x1a99}, {0x1b50, 0x1b59}, {0x1bb0, 0x1bb9}, {0x1c40, 0x1c49}, {0x1c50, 0x1c59}, {0x1c80, 0x1c88},
  {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1d00, 0x1d2b}, {0x1d6b, 0x1d77}, {0x1d79, 0x1d9a}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45},
  {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1f87}, {0x1f90, 0x1f97},
  {0x1fa0, 0x1fa7}, {0x1fb0, 0x1fb4}, {0x1fb6, 0x1fbb}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcb}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb},
  {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffb}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2119, 0x211d},
  {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x212d}, {0x212f, 0x2134}, {0x2139, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149},
  {0x214e, 0x214e}, {0x2183, 0x2184}, {0x2c00, 0x2c7b}, {0x2c7e, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27},
  {0x2d2d, 0x2d2d}, {0xa620, 0xa629}, {0xa640, 0xa66d}, {0xa680, 0xa69b}, {0xa722, 0xa76f}, {0xa771, 0xa787}, {0xa78b, 0xa78e}, {0xa790, 0xa7ca},
  {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f5, 0xa7f6}, {0xa7fa, 0xa7fa}, {0xa8d0, 0xa8d9}, {0xa900, 0xa909}, {0xa9d0, 0xa9d9},
  {0xa9f0, 0xa9f9}, {0xaa50, 0xaa59}, {0xab30, 0xab5a}, {0xab60, 0xab68}, {0xab70, 0xabbf}, {0xabf0, 0xabf9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17},
  {0xff10, 0xff19}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0x10400, 0x1044f}, {0x104a0, 0x104a9}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10570, 0x1057a},
  {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(66);
      ADVANCE_MAP(
        '"', 5,
        '#', 25,
        '(', 88,
        ')', 89,
        '+', 156,
        ',', 107,
        '-', 12,
        '.', 112,
        '/', 19,
        '0', 150,
        ':', 71,
        ';', 172,
        '<', 92,
        '=', 76,
        '>', 94,
        '?', 118,
        '@', 73,
        '[', 67,
        '\\', 13,
        ']', 68,
        '_', 157,
        '{', 116,
        '|', 119,
        '}', 117,
        0xac, 99,
        0x2190, 161,
        0x2192, 159,
        0x21d2, 104,
        0x21d4, 106,
        0x2200, 108,
        0x2203, 109,
        0x2205, 113,
        0x2208, 110,
        0x2227, 100,
        0x2228, 101,
        0x2254, 115,
        0x2260, 91,
        0x2264, 96,
        0x2265, 98,
        0x22a4, 153,
        0x22a5, 154,
        0x22bb, 102,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(65);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(149);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(69);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '"', 5,
        '#', 25,
        '(', 88,
        ')', 89,
        '-', 12,
        '.', 111,
        '0', 147,
        ':', 71,
        ';', 172,
        '<', 136,
        '=', 75,
        '>', 140,
        '@', 72,
        '[', 67,
        ']', 68,
        '_', 157,
        '{', 116,
        '|', 119,
        '}', 117,
        0xac, 99,
        0x2192, 159,
        0x2200, 108,
        0x2203, 109,
        0x2205, 113,
        0x2208, 110,
        0x2254, 115,
        0x22a4, 153,
        0x22a5, 154,
        '+', 13,
        '\\', 13,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(148);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '"', 5,
        '#', 25,
        '(', 88,
        ')', 89,
        '-', 12,
        '0', 147,
        ':', 20,
        ';', 172,
        '<', 136,
        '=', 75,
        '@', 72,
        '[', 67,
        ']', 68,
        '_', 157,
        '{', 116,
        '|', 119,
        '}', 117,
        0xac, 99,
        0x2192, 159,
        0x2200, 108,
        0x2203, 109,
        0x2205, 113,
        0x2208, 110,
        0x2254, 115,
        0x22a4, 153,
        0x22a5, 154,
        '+', 13,
        '\\', 13,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(148);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '"', 5,
        '#', 25,
        '(', 88,
        ')', 89,
        '-', 12,
        '0', 147,
        ';', 172,
        '<', 136,
        '@', 61,
        '[', 67,
        ']', 68,
        '{', 116,
        0x2192, 159,
        0x2205, 113,
        0x22a4, 153,
        0x22a5, 154,
        '+', 13,
        '\\', 13,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(148);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '"', 5,
        '#', 25,
        '(', 88,
        ')', 89,
        '-', 12,
        '0', 147,
        ';', 172,
        '<', 136,
        '[', 67,
        ']', 68,
        '{', 116,
        0x2192, 159,
        0x2205, 113,
        0x22a4, 153,
        0x22a5, 154,
        '+', 13,
        '\\', 13,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(148);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(120);
      if (lookahead == '\\') ADVANCE(27);
      if (lookahead > 0x08 &&
          (lookahead < 0x0b || 0x1f < lookahead) &&
          lookahead != 0x7f) ADVANCE(5);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '(', 88,
        ')', 89,
        '+', 155,
        ',', 107,
        '-', 21,
        '.', 111,
        '/', 19,
        '0', 151,
        ':', 71,
        ';', 172,
        '<', 93,
        '=', 76,
        '>', 94,
        '@', 72,
        ']', 68,
        '{', 116,
        '}', 117,
        0x2192, 159,
        0x21d2, 104,
        0x21d4, 106,
        0x2227, 100,
        0x2228, 101,
        0x2254, 115,
        0x2260, 91,
        0x2264, 96,
        0x2265, 98,
        0x22bb, 102,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(7);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(152);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '(', 88,
        ')', 89,
        '+', 155,
        ',', 107,
        '-', 21,
        '/', 19,
        '0', 151,
        ':', 20,
        ';', 172,
        '<', 93,
        '=', 76,
        '>', 94,
        '@', 72,
        ']', 68,
        '{', 116,
        '}', 117,
        0x2192, 159,
        0x21d2, 104,
        0x21d4, 106,
        0x2227, 100,
        0x2228, 101,
        0x2254, 115,
        0x2260, 91,
        0x2264, 96,
        0x2265, 98,
        0x22bb, 102,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(7);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(152);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '(', 88,
        ')', 89,
        ',', 107,
        '-', 21,
        '.', 11,
        '/', 19,
        ';', 172,
        '<', 93,
        '=', 76,
        '>', 94,
        '@', 72,
        '}', 117,
        0x2192, 159,
        0x21d2, 104,
        0x21d4, 106,
        0x2227, 100,
        0x2228, 101,
        0x2260, 91,
        0x2264, 96,
        0x2265, 98,
        0x22bb, 102,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(8);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '(', 88,
        ')', 89,
        ',', 107,
        '-', 21,
        '.', 11,
        '/', 19,
        ';', 172,
        '<', 93,
        '=', 76,
        '>', 94,
        '@', 74,
        '}', 117,
        0x2192, 159,
        0x21d2, 104,
        0x21d4, 106,
        0x2227, 100,
        0x2228, 101,
        0x2260, 91,
        0x2264, 96,
        0x2265, 98,
        0x22bb, 102,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(8);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 10:
      if (lookahead == '-') ADVANCE(162);
      END_STATE();
    case 11:
      if (lookahead == '.') ADVANCE(158);
      END_STATE();
    case 12:
      if (lookahead == '0') ADVANCE(147);
      if (lookahead == '>') ADVANCE(160);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(148);
      END_STATE();
    case 13:
      if (lookahead == '0') ADVANCE(147);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(148);
      END_STATE();
    case 14:
      if (lookahead == '0') ADVANCE(144);
      if (lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '\\') ADVANCE(15);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(145);
      END_STATE();
    case 15:
      if (lookahead == '0') ADVANCE(144);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(145);
      END_STATE();
    case 16:
      if (lookahead == ';') ADVANCE(172);
      if (lookahead == '<') ADVANCE(10);
      if (lookahead == '@') ADVANCE(73);
      if (lookahead == 0x2190) ADVANCE(161);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(17);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 17:
      if (lookahead == ';') ADVANCE(172);
      if (lookahead == '<') ADVANCE(10);
      if (lookahead == '@') ADVANCE(72);
      if (lookahead == 0x2190) ADVANCE(161);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(17);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 18:
      if (lookahead == ';') ADVANCE(172);
      if (lookahead == ']') ADVANCE(68);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(18);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(42);
      END_STATE();
    case 19:
      if (lookahead == '=') ADVANCE(90);
      END_STATE();
    case 20:
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 21:
      if (lookahead == '>') ADVANCE(160);
      END_STATE();
    case 22:
      if (lookahead == '>') ADVANCE(103);
      END_STATE();
    case 23:
      if (lookahead == '>') ADVANCE(105);
      END_STATE();
    case 24:
      if (lookahead == 'U') ADVANCE(52);
      if (lookahead == 'u') ADVANCE(48);
      END_STATE();
    case 25:
      if (lookahead == '[') ADVANCE(141);
      END_STATE();
    case 26:
      if (lookahead == '_') ADVANCE(26);
      if (set_contains(sym_identifier_character_set_2, 151, lookahead)) ADVANCE(70);
      END_STATE();
    case 27:
      ADVANCE_MAP(
        'u', 28,
        '"', 5,
        '/', 5,
        '\\', 5,
        'a', 5,
        'b', 5,
        'e', 5,
        'f', 5,
        'n', 5,
        'r', 5,
        't', 5,
        'v', 5,
      );
      END_STATE();
    case 28:
      if (lookahead == '{') ADVANCE(45);
      END_STATE();
    case 29:
      if (lookahead == '}') ADVANCE(5);
      END_STATE();
    case 30:
      if (lookahead == '}') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(29);
      END_STATE();
    case 31:
      if (lookahead == '}') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(30);
      END_STATE();
    case 32:
      if (lookahead == '}') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(31);
      END_STATE();
    case 33:
      if (lookahead == '}') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(32);
      END_STATE();
    case 34:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(146);
      END_STATE();
    case 35:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(121);
      END_STATE();
    case 36:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(41);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(54);
      END_STATE();
    case 37:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(41);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(55);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(41);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(56);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(41);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(57);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(41);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(58);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(35);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(142);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(33);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(138);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(50);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 53:
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(64);
      END_STATE();
    case 54:
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(133);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(63);
      END_STATE();
    case 55:
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(121);
      END_STATE();
    case 56:
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(121);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(63);
      END_STATE();
    case 57:
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(134);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(63);
      END_STATE();
    case 58:
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(135);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(63);
      END_STATE();
    case 59:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(79);
      END_STATE();
    case 60:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(127);
      END_STATE();
    case 61:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(60);
      END_STATE();
    case 62:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(129);
      END_STATE();
    case 63:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(62);
      END_STATE();
    case 64:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 65:
      if (eof) ADVANCE(66);
      ADVANCE_MAP(
        '"', 5,
        '#', 25,
        '(', 88,
        ')', 89,
        '+', 156,
        ',', 107,
        '-', 12,
        '.', 11,
        '/', 19,
        '0', 150,
        ':', 20,
        ';', 172,
        '<', 92,
        '=', 76,
        '>', 94,
        '?', 118,
        '@', 72,
        '[', 67,
        '\\', 13,
        ']', 68,
        '_', 157,
        '{', 116,
        '|', 119,
        '}', 117,
        0xac, 99,
        0x2190, 161,
        0x2192, 159,
        0x21d2, 104,
        0x21d4, 106,
        0x2200, 108,
        0x2203, 109,
        0x2205, 113,
        0x2208, 110,
        0x2227, 100,
        0x2228, 101,
        0x2254, 115,
        0x2260, 91,
        0x2264, 96,
        0x2265, 98,
        0x22a4, 153,
        0x22a5, 154,
        0x22bb, 102,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(65);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(149);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(69);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(70);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(26);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(70);
      if (set_contains(sym_identifier_character_set_2, 151, lookahead)) ADVANCE(70);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(26);
      if (set_contains(sym_identifier_character_set_2, 151, lookahead)) ADVANCE(70);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_AT);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(59);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_AT);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(60);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(22);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (lookahead == '-') ADVANCE(53);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (lookahead == '-') ADVANCE(53);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(78);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(77);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(80);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(81);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(82);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(83);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(85);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(86);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_u2260);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_less_than);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_less_than);
      if (lookahead == '=') ADVANCE(95);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_greater_than);
      if (lookahead == '=') ADVANCE(97);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (lookahead == '=') ADVANCE(23);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_u2264);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_u2265);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_u00ac);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_u2227);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_u2228);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_u22bb);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_GT);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_u21d2);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_LT_EQ_EQ_GT);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_u21d4);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_u2200);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_u2203);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_u2208);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(158);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_u2205);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_u2254);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_optional);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_quoted_string);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_language_tag);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(36);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(36);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(128);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(36);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(123);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(36);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(124);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(36);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(125);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(36);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(126);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(36);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(122);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(37);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(38);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(39);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(40);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(132);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(130);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(131);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(aux_sym_iri_token1);
      if (lookahead == ';') ADVANCE(139);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead > ' ' &&
          lookahead != '"' &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(138);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(aux_sym_iri_token1);
      if (lookahead == '\\') ADVANCE(24);
      if (lookahead > ' ' &&
          lookahead != '"' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(138);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym_iri_token1);
      if (lookahead == '\\') ADVANCE(163);
      if ((!eof && lookahead <= '\t') ||
          (0x0b <= lookahead && lookahead <= ' ') ||
          lookahead == '"' ||
          lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '^' ||
          lookahead == '`' ||
          ('{' <= lookahead && lookahead <= '}')) ADVANCE(172);
      if (lookahead > ' ') ADVANCE(139);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_POUND_LBRACK);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_hex_byte);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_hex_byte);
      if (lookahead == '.') ADVANCE(34);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(148);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_double);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_double);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(145);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_decimal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(14);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(146);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(34);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(34);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(148);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(34);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(143);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(142);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(34);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(142);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_unsigned);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_unsigned);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(152);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_u22a4);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_u22a5);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '0') ADVANCE(147);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(148);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_wildcard);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_u2192);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_u2190);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead == 'U') ADVANCE(171);
      if (lookahead == 'u') ADVANCE(167);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(139);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(164);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(165);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(166);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(167);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(168);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(169);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(170);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(172);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'b', 2,
        'c', 3,
        'd', 4,
        'e', 5,
        'f', 6,
        'i', 7,
        'm', 8,
        'n', 9,
        'o', 10,
        'p', 11,
        'r', 12,
        's', 13,
        't', 14,
        'u', 15,
        'v', 16,
        'w', 17,
        'x', 18,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'n') ADVANCE(19);
      if (lookahead == 's') ADVANCE(20);
      END_STATE();
    case 2:
      if (lookahead == 'i') ADVANCE(21);
      if (lookahead == 'o') ADVANCE(22);
      END_STATE();
    case 3:
      if (lookahead == 'l') ADVANCE(23);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(24);
      if (lookahead == 'e') ADVANCE(25);
      if (lookahead == 'i') ADVANCE(26);
      if (lookahead == 'o') ADVANCE(27);
      END_STATE();
    case 5:
      if (lookahead == 'n') ADVANCE(28);
      if (lookahead == 'v') ADVANCE(29);
      if (lookahead == 'x') ADVANCE(30);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(32);
      END_STATE();
    case 7:
      if (lookahead == 'd') ADVANCE(33);
      if (lookahead == 'f') ADVANCE(34);
      if (lookahead == 'm') ADVANCE(35);
      if (lookahead == 'n') ADVANCE(36);
      if (lookahead == 'r') ADVANCE(37);
      if (lookahead == 's') ADVANCE(38);
      END_STATE();
    case 8:
      if (lookahead == 'o') ADVANCE(39);
      END_STATE();
    case 9:
      if (lookahead == 'o') ADVANCE(40);
      END_STATE();
    case 10:
      if (lookahead == 'f') ADVANCE(41);
      if (lookahead == 'p') ADVANCE(42);
      if (lookahead == 'r') ADVANCE(43);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(44);
      if (lookahead == 'r') ADVANCE(45);
      END_STATE();
    case 12:
      if (lookahead == 'd') ADVANCE(46);
      if (lookahead == 'e') ADVANCE(47);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(48);
      if (lookahead == 'o') ADVANCE(49);
      if (lookahead == 't') ADVANCE(50);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(51);
      if (lookahead == 'y') ADVANCE(52);
      END_STATE();
    case 15:
      if (lookahead == 'n') ADVANCE(53);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(54);
      END_STATE();
    case 17:
      if (lookahead == 'i') ADVANCE(55);
      END_STATE();
    case 18:
      if (lookahead == 'o') ADVANCE(56);
      END_STATE();
    case 19:
      if (lookahead == 'd') ADVANCE(57);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(58);
      END_STATE();
    case 21:
      if (lookahead == 'n') ADVANCE(59);
      END_STATE();
    case 22:
      if (lookahead == 'o') ADVANCE(60);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(61);
      END_STATE();
    case 24:
      if (lookahead == 't') ADVANCE(62);
      END_STATE();
    case 25:
      if (lookahead == 'c') ADVANCE(63);
      if (lookahead == 'f') ADVANCE(64);
      END_STATE();
    case 26:
      if (lookahead == 'm') ADVANCE(65);
      END_STATE();
    case 27:
      if (lookahead == 'u') ADVANCE(66);
      END_STATE();
    case 28:
      if (lookahead == 'd') ADVANCE(67);
      if (lookahead == 't') ADVANCE(68);
      if (lookahead == 'u') ADVANCE(69);
      END_STATE();
    case 29:
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 30:
      if (lookahead == 'i') ADVANCE(71);
      END_STATE();
    case 31:
      if (lookahead == 'l') ADVANCE(72);
      END_STATE();
    case 32:
      if (lookahead == 'r') ADVANCE(73);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(74);
      END_STATE();
    case 34:
      if (lookahead == 'f') ADVANCE(75);
      END_STATE();
    case 35:
      if (lookahead == 'p') ADVANCE(76);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 't') ADVANCE(77);
      END_STATE();
    case 37:
      if (lookahead == 'i') ADVANCE(78);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 39:
      if (lookahead == 'd') ADVANCE(79);
      END_STATE();
    case 40:
      if (lookahead == 'n') ADVANCE(80);
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 42:
      if (lookahead == 'a') ADVANCE(82);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == 'd') ADVANCE(83);
      END_STATE();
    case 44:
      if (lookahead == 'r') ADVANCE(84);
      END_STATE();
    case 45:
      if (lookahead == 'o') ADVANCE(85);
      END_STATE();
    case 46:
      if (lookahead == 'f') ADVANCE(86);
      END_STATE();
    case 47:
      if (lookahead == 'f') ADVANCE(87);
      END_STATE();
    case 48:
      if (lookahead == 'l') ADVANCE(88);
      END_STATE();
    case 49:
      if (lookahead == 'u') ADVANCE(89);
      END_STATE();
    case 50:
      if (lookahead == 'r') ADVANCE(90);
      END_STATE();
    case 51:
      if (lookahead == 'u') ADVANCE(91);
      END_STATE();
    case 52:
      if (lookahead == 'p') ADVANCE(92);
      END_STATE();
    case 53:
      if (lookahead == 'i') ADVANCE(93);
      if (lookahead == 'k') ADVANCE(94);
      if (lookahead == 'o') ADVANCE(95);
      if (lookahead == 's') ADVANCE(96);
      END_STATE();
    case 54:
      if (lookahead == 'r') ADVANCE(97);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(98);
      END_STATE();
    case 56:
      if (lookahead == 'r') ADVANCE(99);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(100);
      END_STATE();
    case 59:
      if (lookahead == 'a') ADVANCE(101);
      END_STATE();
    case 60:
      if (lookahead == 'l') ADVANCE(102);
      END_STATE();
    case 61:
      if (lookahead == 's') ADVANCE(103);
      END_STATE();
    case 62:
      if (lookahead == 'a') ADVANCE(104);
      END_STATE();
    case 63:
      if (lookahead == 'i') ADVANCE(105);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_def);
      END_STATE();
    case 65:
      if (lookahead == 'e') ADVANCE(106);
      END_STATE();
    case 66:
      if (lookahead == 'b') ADVANCE(107);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 68:
      if (lookahead == 'i') ADVANCE(108);
      END_STATE();
    case 69:
      if (lookahead == 'm') ADVANCE(109);
      END_STATE();
    case 70:
      if (lookahead == 'n') ADVANCE(110);
      END_STATE();
    case 71:
      if (lookahead == 's') ADVANCE(111);
      END_STATE();
    case 72:
      if (lookahead == 's') ADVANCE(112);
      END_STATE();
    case 73:
      if (lookahead == 'a') ADVANCE(113);
      END_STATE();
    case 74:
      if (lookahead == 'n') ADVANCE(114);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_iff);
      END_STATE();
    case 76:
      if (lookahead == 'l') ADVANCE(115);
      if (lookahead == 'o') ADVANCE(116);
      END_STATE();
    case 77:
      if (lookahead == 'e') ADVANCE(117);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_iri);
      END_STATE();
    case 79:
      if (lookahead == 'u') ADVANCE(118);
      END_STATE();
    case 80:
      if (lookahead == 'u') ADVANCE(119);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 82:
      if (lookahead == 'q') ADVANCE(120);
      END_STATE();
    case 83:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(122);
      END_STATE();
    case 85:
      if (lookahead == 'p') ADVANCE(123);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_rdf);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_ref);
      END_STATE();
    case 88:
      if (lookahead == 'f') ADVANCE(124);
      END_STATE();
    case 89:
      if (lookahead == 'r') ADVANCE(125);
      END_STATE();
    case 90:
      if (lookahead == 'i') ADVANCE(126);
      if (lookahead == 'u') ADVANCE(127);
      END_STATE();
    case 91:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(129);
      END_STATE();
    case 93:
      if (lookahead == 'o') ADVANCE(130);
      if (lookahead == 'q') ADVANCE(131);
      END_STATE();
    case 94:
      if (lookahead == 'n') ADVANCE(132);
      END_STATE();
    case 95:
      if (lookahead == 'r') ADVANCE(133);
      END_STATE();
    case 96:
      if (lookahead == 'i') ADVANCE(134);
      END_STATE();
    case 97:
      if (lookahead == 's') ADVANCE(135);
      END_STATE();
    case 98:
      if (lookahead == 'h') ADVANCE(136);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_xor);
      END_STATE();
    case 100:
      if (lookahead == 'r') ADVANCE(137);
      END_STATE();
    case 101:
      if (lookahead == 'r') ADVANCE(138);
      END_STATE();
    case 102:
      if (lookahead == 'e') ADVANCE(139);
      END_STATE();
    case 103:
      if (lookahead == 's') ADVANCE(140);
      END_STATE();
    case 104:
      if (lookahead == 't') ADVANCE(141);
      END_STATE();
    case 105:
      if (lookahead == 'm') ADVANCE(142);
      END_STATE();
    case 106:
      if (lookahead == 'n') ADVANCE(143);
      END_STATE();
    case 107:
      if (lookahead == 'l') ADVANCE(144);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(145);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 110:
      if (lookahead == 't') ADVANCE(146);
      END_STATE();
    case 111:
      if (lookahead == 't') ADVANCE(147);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(148);
      END_STATE();
    case 113:
      if (lookahead == 'l') ADVANCE(149);
      END_STATE();
    case 114:
      if (lookahead == 't') ADVANCE(150);
      END_STATE();
    case 115:
      if (lookahead == 'i') ADVANCE(151);
      END_STATE();
    case 116:
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 117:
      if (lookahead == 'g') ADVANCE(153);
      END_STATE();
    case 118:
      if (lookahead == 'l') ADVANCE(154);
      END_STATE();
    case 119:
      if (lookahead == 'n') ADVANCE(155);
      END_STATE();
    case 120:
      if (lookahead == 'u') ADVANCE(156);
      END_STATE();
    case 121:
      if (lookahead == 'r') ADVANCE(157);
      END_STATE();
    case 122:
      if (lookahead == 'n') ADVANCE(158);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(159);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_reserved_self);
      END_STATE();
    case 125:
      if (lookahead == 'c') ADVANCE(160);
      END_STATE();
    case 126:
      if (lookahead == 'n') ADVANCE(161);
      END_STATE();
    case 127:
      if (lookahead == 'c') ADVANCE(162);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 130:
      if (lookahead == 'n') ADVANCE(163);
      END_STATE();
    case 131:
      if (lookahead == 'u') ADVANCE(164);
      END_STATE();
    case 132:
      if (lookahead == 'o') ADVANCE(165);
      END_STATE();
    case 133:
      if (lookahead == 'd') ADVANCE(166);
      END_STATE();
    case 134:
      if (lookahead == 'g') ADVANCE(167);
      END_STATE();
    case 135:
      if (lookahead == 'i') ADVANCE(168);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 137:
      if (lookahead == 't') ADVANCE(169);
      END_STATE();
    case 138:
      if (lookahead == 'y') ADVANCE(170);
      END_STATE();
    case 139:
      if (lookahead == 'a') ADVANCE(171);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 141:
      if (lookahead == 'y') ADVANCE(172);
      END_STATE();
    case 142:
      if (lookahead == 'a') ADVANCE(173);
      END_STATE();
    case 143:
      if (lookahead == 's') ADVANCE(174);
      END_STATE();
    case 144:
      if (lookahead == 'e') ADVANCE(175);
      END_STATE();
    case 145:
      if (lookahead == 'y') ADVANCE(176);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_event);
      END_STATE();
    case 147:
      if (lookahead == 's') ADVANCE(177);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 149:
      if (lookahead == 'l') ADVANCE(178);
      END_STATE();
    case 150:
      if (lookahead == 'i') ADVANCE(179);
      END_STATE();
    case 151:
      if (lookahead == 'e') ADVANCE(180);
      END_STATE();
    case 152:
      if (lookahead == 't') ADVANCE(181);
      END_STATE();
    case 153:
      if (lookahead == 'e') ADVANCE(182);
      END_STATE();
    case 154:
      if (lookahead == 'e') ADVANCE(183);
      END_STATE();
    case 155:
      if (lookahead == 'i') ADVANCE(184);
      END_STATE();
    case 156:
      if (lookahead == 'e') ADVANCE(185);
      END_STATE();
    case 157:
      if (lookahead == 'e') ADVANCE(186);
      END_STATE();
    case 158:
      if (lookahead == 't') ADVANCE(187);
      END_STATE();
    case 159:
      if (lookahead == 'r') ADVANCE(188);
      END_STATE();
    case 160:
      if (lookahead == 'e') ADVANCE(189);
      END_STATE();
    case 161:
      if (lookahead == 'g') ADVANCE(190);
      END_STATE();
    case 162:
      if (lookahead == 't') ADVANCE(191);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_union);
      END_STATE();
    case 164:
      if (lookahead == 'e') ADVANCE(192);
      END_STATE();
    case 165:
      if (lookahead == 'w') ADVANCE(193);
      END_STATE();
    case 166:
      if (lookahead == 'e') ADVANCE(194);
      END_STATE();
    case 167:
      if (lookahead == 'n') ADVANCE(195);
      END_STATE();
    case 168:
      if (lookahead == 'o') ADVANCE(196);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_binary);
      END_STATE();
    case 171:
      if (lookahead == 'n') ADVANCE(197);
      END_STATE();
    case 172:
      if (lookahead == 'p') ADVANCE(198);
      END_STATE();
    case 173:
      if (lookahead == 'l') ADVANCE(199);
      END_STATE();
    case 174:
      if (lookahead == 'i') ADVANCE(200);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_double);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_entity);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_exists);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_forall);
      END_STATE();
    case 179:
      if (lookahead == 't') ADVANCE(201);
      END_STATE();
    case 180:
      if (lookahead == 's') ADVANCE(202);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 182:
      if (lookahead == 'r') ADVANCE(203);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 184:
      if (lookahead == 'q') ADVANCE(204);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_opaque);
      END_STATE();
    case 186:
      if (lookahead == 'd') ADVANCE(205);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_parent);
      END_STATE();
    case 188:
      if (lookahead == 't') ADVANCE(206);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_source);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 191:
      if (lookahead == 'u') ADVANCE(207);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_unique);
      END_STATE();
    case 193:
      if (lookahead == 'n') ADVANCE(208);
      END_STATE();
    case 194:
      if (lookahead == 'r') ADVANCE(209);
      END_STATE();
    case 195:
      if (lookahead == 'e') ADVANCE(210);
      END_STATE();
    case 196:
      if (lookahead == 'n') ADVANCE(211);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_boolean);
      END_STATE();
    case 198:
      if (lookahead == 'e') ADVANCE(212);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_decimal);
      END_STATE();
    case 200:
      if (lookahead == 'o') ADVANCE(213);
      END_STATE();
    case 201:
      if (lookahead == 'y') ADVANCE(214);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_implies);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_integer);
      END_STATE();
    case 204:
      if (lookahead == 'u') ADVANCE(215);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_ordered);
      END_STATE();
    case 206:
      if (lookahead == 'y') ADVANCE(216);
      END_STATE();
    case 207:
      if (lookahead == 'r') ADVANCE(217);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_unknown_type);
      END_STATE();
    case 209:
      if (lookahead == 'e') ADVANCE(218);
      END_STATE();
    case 210:
      if (lookahead == 'd') ADVANCE(219);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_version);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_datatype);
      END_STATE();
    case 213:
      if (lookahead == 'n') ADVANCE(220);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_identity);
      END_STATE();
    case 215:
      if (lookahead == 'e') ADVANCE(221);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_property);
      END_STATE();
    case 217:
      if (lookahead == 'e') ADVANCE(222);
      END_STATE();
    case 218:
      if (lookahead == 'd') ADVANCE(223);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_unsigned);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_dimension);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_nonunique);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_structure);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_unordered);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 1},
  [2] = {.lex_state = 1},
  [3] = {.lex_state = 6},
  [4] = {.lex_state = 6},
  [5] = {.lex_state = 1},
  [6] = {.lex_state = 1},
  [7] = {.lex_state = 1},
  [8] = {.lex_state = 1},
  [9] = {.lex_state = 1},
  [10] = {.lex_state = 1},
  [11] = {.lex_state = 1},
  [12] = {.lex_state = 6},
  [13] = {.lex_state = 9},
  [14] = {.lex_state = 6},
  [15] = {.lex_state = 6},
  [16] = {.lex_state = 6},
  [17] = {.lex_state = 6},
  [18] = {.lex_state = 6},
  [19] = {.lex_state = 6},
  [20] = {.lex_state = 6},
  [21] = {.lex_state = 1},
  [22] = {.lex_state = 1},
  [23] = {.lex_state = 1},
  [24] = {.lex_state = 1},
  [25] = {.lex_state = 1},
  [26] = {.lex_state = 1},
  [27] = {.lex_state = 1},
  [28] = {.lex_state = 1},
  [29] = {.lex_state = 1},
  [30] = {.lex_state = 1},
  [31] = {.lex_state = 1},
  [32] = {.lex_state = 1},
  [33] = {.lex_state = 1},
  [34] = {.lex_state = 1},
  [35] = {.lex_state = 1},
  [36] = {.lex_state = 6},
  [37] = {.lex_state = 1},
  [38] = {.lex_state = 1},
  [39] = {.lex_state = 6},
  [40] = {.lex_state = 1},
  [41] = {.lex_state = 1},
  [42] = {.lex_state = 6},
  [43] = {.lex_state = 6},
  [44] = {.lex_state = 6},
  [45] = {.lex_state = 1},
  [46] = {.lex_state = 1},
  [47] = {.lex_state = 1},
  [48] = {.lex_state = 1},
  [49] = {.lex_state = 1},
  [50] = {.lex_state = 1},
  [51] = {.lex_state = 1},
  [52] = {.lex_state = 1},
  [53] = {.lex_state = 6},
  [54] = {.lex_state = 1},
  [55] = {.lex_state = 6},
  [56] = {.lex_state = 1},
  [57] = {.lex_state = 6},
  [58] = {.lex_state = 6},
  [59] = {.lex_state = 6},
  [60] = {.lex_state = 6},
  [61] = {.lex_state = 6},
  [62] = {.lex_state = 6},
  [63] = {.lex_state = 6},
  [64] = {.lex_state = 1},
  [65] = {.lex_state = 6},
  [66] = {.lex_state = 1},
  [67] = {.lex_state = 6},
  [68] = {.lex_state = 1},
  [69] = {.lex_state = 6},
  [70] = {.lex_state = 1},
  [71] = {.lex_state = 6},
  [72] = {.lex_state = 1},
  [73] = {.lex_state = 1},
  [74] = {.lex_state = 1},
  [75] = {.lex_state = 1},
  [76] = {.lex_state = 1},
  [77] = {.lex_state = 6},
  [78] = {.lex_state = 6},
  [79] = {.lex_state = 6},
  [80] = {.lex_state = 1},
  [81] = {.lex_state = 1},
  [82] = {.lex_state = 1},
  [83] = {.lex_state = 1},
  [84] = {.lex_state = 1},
  [85] = {.lex_state = 1},
  [86] = {.lex_state = 1},
  [87] = {.lex_state = 1},
  [88] = {.lex_state = 1},
  [89] = {.lex_state = 1},
  [90] = {.lex_state = 1},
  [91] = {.lex_state = 1},
  [92] = {.lex_state = 3},
  [93] = {.lex_state = 1},
  [94] = {.lex_state = 1},
  [95] = {.lex_state = 1},
  [96] = {.lex_state = 1},
  [97] = {.lex_state = 6},
  [98] = {.lex_state = 1},
  [99] = {.lex_state = 1},
  [100] = {.lex_state = 1},
  [101] = {.lex_state = 1},
  [102] = {.lex_state = 1},
  [103] = {.lex_state = 1},
  [104] = {.lex_state = 1},
  [105] = {.lex_state = 1},
  [106] = {.lex_state = 1},
  [107] = {.lex_state = 1},
  [108] = {.lex_state = 1},
  [109] = {.lex_state = 1},
  [110] = {.lex_state = 6},
  [111] = {.lex_state = 6},
  [112] = {.lex_state = 6},
  [113] = {.lex_state = 6},
  [114] = {.lex_state = 1},
  [115] = {.lex_state = 1},
  [116] = {.lex_state = 1},
  [117] = {.lex_state = 1},
  [118] = {.lex_state = 1},
  [119] = {.lex_state = 6},
  [120] = {.lex_state = 1},
  [121] = {.lex_state = 1},
  [122] = {.lex_state = 1},
  [123] = {.lex_state = 1},
  [124] = {.lex_state = 1},
  [125] = {.lex_state = 6},
  [126] = {.lex_state = 1},
  [127] = {.lex_state = 1},
  [128] = {.lex_state = 6},
  [129] = {.lex_state = 1},
  [130] = {.lex_state = 16},
  [131] = {.lex_state = 1},
  [132] = {.lex_state = 6},
  [133] = {.lex_state = 1},
  [134] = {.lex_state = 1},
  [135] = {.lex_state = 6},
  [136] = {.lex_state = 6},
  [137] = {.lex_state = 1},
  [138] = {.lex_state = 1},
  [139] = {.lex_state = 1},
  [140] = {.lex_state = 6},
  [141] = {.lex_state = 1},
  [142] = {.lex_state = 1},
  [143] = {.lex_state = 1},
  [144] = {.lex_state = 6},
  [145] = {.lex_state = 1},
  [146] = {.lex_state = 1},
  [147] = {.lex_state = 6},
  [148] = {.lex_state = 1},
  [149] = {.lex_state = 1},
  [150] = {.lex_state = 1},
  [151] = {.lex_state = 1},
  [152] = {.lex_state = 1},
  [153] = {.lex_state = 1},
  [154] = {.lex_state = 1},
  [155] = {.lex_state = 1},
  [156] = {.lex_state = 1},
  [157] = {.lex_state = 1},
  [158] = {.lex_state = 1},
  [159] = {.lex_state = 1},
  [160] = {.lex_state = 1},
  [161] = {.lex_state = 1},
  [162] = {.lex_state = 1},
  [163] = {.lex_state = 1},
  [164] = {.lex_state = 1},
  [165] = {.lex_state = 1},
  [166] = {.lex_state = 1},
  [167] = {.lex_state = 1},
  [168] = {.lex_state = 1},
  [169] = {.lex_state = 1},
  [170] = {.lex_state = 1},
  [171] = {.lex_state = 1},
  [172] = {.lex_state = 1},
  [173] = {.lex_state = 1},
  [174] = {.lex_state = 1},
  [175] = {.lex_state = 1},
  [176] = {.lex_state = 6},
  [177] = {.lex_state = 1},
  [178] = {.lex_state = 1},
  [179] = {.lex_state = 1},
  [180] = {.lex_state = 1},
  [181] = {.lex_state = 1},
  [182] = {.lex_state = 1},
  [183] = {.lex_state = 1},
  [184] = {.lex_state = 1},
  [185] = {.lex_state = 1},
  [186] = {.lex_state = 1},
  [187] = {.lex_state = 1},
  [188] = {.lex_state = 1},
  [189] = {.lex_state = 1},
  [190] = {.lex_state = 1},
  [191] = {.lex_state = 1},
  [192] = {.lex_state = 1},
  [193] = {.lex_state = 1},
  [194] = {.lex_state = 1},
  [195] = {.lex_state = 1},
  [196] = {.lex_state = 1},
  [197] = {.lex_state = 6},
  [198] = {.lex_state = 1},
  [199] = {.lex_state = 1},
  [200] = {.lex_state = 1},
  [201] = {.lex_state = 1},
  [202] = {.lex_state = 1},
  [203] = {.lex_state = 1},
  [204] = {.lex_state = 1},
  [205] = {.lex_state = 1},
  [206] = {.lex_state = 1},
  [207] = {.lex_state = 1},
  [208] = {.lex_state = 1},
  [209] = {.lex_state = 1},
  [210] = {.lex_state = 0},
  [211] = {.lex_state = 1},
  [212] = {.lex_state = 1},
  [213] = {.lex_state = 1},
  [214] = {.lex_state = 1},
  [215] = {.lex_state = 1},
  [216] = {.lex_state = 1},
  [217] = {.lex_state = 1},
  [218] = {.lex_state = 1},
  [219] = {.lex_state = 1},
  [220] = {.lex_state = 1},
  [221] = {.lex_state = 1},
  [222] = {.lex_state = 1},
  [223] = {.lex_state = 1},
  [224] = {.lex_state = 1},
  [225] = {.lex_state = 1},
  [226] = {.lex_state = 1},
  [227] = {.lex_state = 1},
  [228] = {.lex_state = 1},
  [229] = {.lex_state = 1},
  [230] = {.lex_state = 1},
  [231] = {.lex_state = 1},
  [232] = {.lex_state = 1},
  [233] = {.lex_state = 1},
  [234] = {.lex_state = 1},
  [235] = {.lex_state = 1},
  [236] = {.lex_state = 1},
  [237] = {.lex_state = 1},
  [238] = {.lex_state = 1},
  [239] = {.lex_state = 1},
  [240] = {.lex_state = 1},
  [241] = {.lex_state = 1},
  [242] = {.lex_state = 1},
  [243] = {.lex_state = 1},
  [244] = {.lex_state = 1},
  [245] = {.lex_state = 1},
  [246] = {.lex_state = 1},
  [247] = {.lex_state = 1},
  [248] = {.lex_state = 1},
  [249] = {.lex_state = 1},
  [250] = {.lex_state = 1},
  [251] = {.lex_state = 1},
  [252] = {.lex_state = 1},
  [253] = {.lex_state = 1},
  [254] = {.lex_state = 1},
  [255] = {.lex_state = 1},
  [256] = {.lex_state = 1},
  [257] = {.lex_state = 1},
  [258] = {.lex_state = 1},
  [259] = {.lex_state = 1},
  [260] = {.lex_state = 1},
  [261] = {.lex_state = 1},
  [262] = {.lex_state = 1},
  [263] = {.lex_state = 1},
  [264] = {.lex_state = 1},
  [265] = {.lex_state = 1},
  [266] = {.lex_state = 6},
  [267] = {.lex_state = 1},
  [268] = {.lex_state = 6},
  [269] = {.lex_state = 1},
  [270] = {.lex_state = 1},
  [271] = {.lex_state = 1},
  [272] = {.lex_state = 1},
  [273] = {.lex_state = 1},
  [274] = {.lex_state = 1},
  [275] = {.lex_state = 1},
  [276] = {.lex_state = 1},
  [277] = {.lex_state = 1},
  [278] = {.lex_state = 1},
  [279] = {.lex_state = 1},
  [280] = {.lex_state = 1},
  [281] = {.lex_state = 1},
  [282] = {.lex_state = 1},
  [283] = {.lex_state = 1},
  [284] = {.lex_state = 1},
  [285] = {.lex_state = 1},
  [286] = {.lex_state = 1},
  [287] = {.lex_state = 1},
  [288] = {.lex_state = 1},
  [289] = {.lex_state = 1},
  [290] = {.lex_state = 1},
  [291] = {.lex_state = 1},
  [292] = {.lex_state = 1},
  [293] = {.lex_state = 1},
  [294] = {.lex_state = 1},
  [295] = {.lex_state = 1},
  [296] = {.lex_state = 1},
  [297] = {.lex_state = 1},
  [298] = {.lex_state = 1},
  [299] = {.lex_state = 1},
  [300] = {.lex_state = 1},
  [301] = {.lex_state = 1},
  [302] = {.lex_state = 1},
  [303] = {.lex_state = 1},
  [304] = {.lex_state = 1},
  [305] = {.lex_state = 1},
  [306] = {.lex_state = 1},
  [307] = {.lex_state = 1},
  [308] = {.lex_state = 1},
  [309] = {.lex_state = 0},
  [310] = {.lex_state = 1},
  [311] = {.lex_state = 1},
  [312] = {.lex_state = 6},
  [313] = {.lex_state = 1},
  [314] = {.lex_state = 6},
  [315] = {.lex_state = 1},
  [316] = {.lex_state = 1},
  [317] = {.lex_state = 1},
  [318] = {.lex_state = 6},
  [319] = {.lex_state = 1},
  [320] = {.lex_state = 1},
  [321] = {.lex_state = 1},
  [322] = {.lex_state = 6},
  [323] = {.lex_state = 1},
  [324] = {.lex_state = 1},
  [325] = {.lex_state = 6},
  [326] = {.lex_state = 1},
  [327] = {.lex_state = 1},
  [328] = {.lex_state = 1},
  [329] = {.lex_state = 1},
  [330] = {.lex_state = 6},
  [331] = {.lex_state = 1},
  [332] = {.lex_state = 6},
  [333] = {.lex_state = 0},
  [334] = {.lex_state = 1},
  [335] = {.lex_state = 1},
  [336] = {.lex_state = 1},
  [337] = {.lex_state = 1},
  [338] = {.lex_state = 6},
  [339] = {.lex_state = 0},
  [340] = {.lex_state = 1},
  [341] = {.lex_state = 1},
  [342] = {.lex_state = 1},
  [343] = {.lex_state = 0},
  [344] = {.lex_state = 1},
  [345] = {.lex_state = 1},
  [346] = {.lex_state = 6},
  [347] = {.lex_state = 1},
  [348] = {.lex_state = 6},
  [349] = {.lex_state = 1},
  [350] = {.lex_state = 1},
  [351] = {.lex_state = 1},
  [352] = {.lex_state = 1},
  [353] = {.lex_state = 1},
  [354] = {.lex_state = 1},
  [355] = {.lex_state = 1},
  [356] = {.lex_state = 1},
  [357] = {.lex_state = 1},
  [358] = {.lex_state = 1},
  [359] = {.lex_state = 1},
  [360] = {.lex_state = 0},
  [361] = {.lex_state = 1},
  [362] = {.lex_state = 1},
  [363] = {.lex_state = 0},
  [364] = {.lex_state = 1},
  [365] = {.lex_state = 1},
  [366] = {.lex_state = 6},
  [367] = {.lex_state = 1},
  [368] = {.lex_state = 1},
  [369] = {.lex_state = 1},
  [370] = {.lex_state = 1},
  [371] = {.lex_state = 1},
  [372] = {.lex_state = 18},
  [373] = {.lex_state = 6},
  [374] = {.lex_state = 1},
  [375] = {.lex_state = 1},
  [376] = {.lex_state = 18},
  [377] = {.lex_state = 1},
  [378] = {.lex_state = 1},
  [379] = {.lex_state = 0},
  [380] = {.lex_state = 1},
  [381] = {.lex_state = 16},
  [382] = {.lex_state = 1},
  [383] = {.lex_state = 9},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 1},
  [386] = {.lex_state = 1},
  [387] = {.lex_state = 18},
  [388] = {.lex_state = 1},
  [389] = {.lex_state = 0},
  [390] = {.lex_state = 0},
  [391] = {.lex_state = 1},
  [392] = {.lex_state = 1},
  [393] = {.lex_state = 6},
  [394] = {.lex_state = 18},
  [395] = {.lex_state = 18},
  [396] = {.lex_state = 1},
  [397] = {.lex_state = 1},
  [398] = {.lex_state = 1},
  [399] = {.lex_state = 1},
  [400] = {.lex_state = 1},
  [401] = {.lex_state = 1},
  [402] = {.lex_state = 1},
  [403] = {.lex_state = 6},
  [404] = {.lex_state = 1},
  [405] = {.lex_state = 1},
  [406] = {.lex_state = 1},
  [407] = {.lex_state = 1},
  [408] = {.lex_state = 1},
  [409] = {.lex_state = 6},
  [410] = {.lex_state = 1},
  [411] = {.lex_state = 1},
  [412] = {.lex_state = 1},
  [413] = {.lex_state = 1},
  [414] = {.lex_state = 1},
  [415] = {.lex_state = 6},
  [416] = {.lex_state = 18},
  [417] = {.lex_state = 1},
  [418] = {.lex_state = 1},
  [419] = {.lex_state = 6},
  [420] = {.lex_state = 1},
  [421] = {.lex_state = 1},
  [422] = {.lex_state = 1},
  [423] = {.lex_state = 1},
  [424] = {.lex_state = 0},
  [425] = {.lex_state = 1},
  [426] = {.lex_state = 0},
  [427] = {.lex_state = 0},
  [428] = {.lex_state = 0},
  [429] = {.lex_state = 0},
  [430] = {.lex_state = 0},
  [431] = {.lex_state = 0},
  [432] = {.lex_state = 0},
  [433] = {.lex_state = 0},
  [434] = {.lex_state = 0},
  [435] = {.lex_state = 1},
  [436] = {.lex_state = 1},
  [437] = {.lex_state = 0},
  [438] = {.lex_state = 0},
  [439] = {.lex_state = 0},
  [440] = {.lex_state = 0},
  [441] = {.lex_state = 0},
  [442] = {.lex_state = 0},
  [443] = {.lex_state = 1},
  [444] = {.lex_state = 1},
  [445] = {.lex_state = 1},
  [446] = {.lex_state = 1},
  [447] = {.lex_state = 0},
  [448] = {.lex_state = 0},
  [449] = {.lex_state = 1},
  [450] = {.lex_state = 0},
  [451] = {.lex_state = 1},
  [452] = {.lex_state = 0},
  [453] = {.lex_state = 1},
  [454] = {.lex_state = 1},
  [455] = {.lex_state = 1},
  [456] = {.lex_state = 1},
  [457] = {.lex_state = 0},
  [458] = {.lex_state = 0},
  [459] = {.lex_state = 1},
  [460] = {.lex_state = 0},
  [461] = {.lex_state = 0},
  [462] = {.lex_state = 0},
  [463] = {.lex_state = 0},
  [464] = {.lex_state = 0},
  [465] = {.lex_state = 0},
  [466] = {.lex_state = 0},
  [467] = {.lex_state = 1},
  [468] = {.lex_state = 1},
  [469] = {.lex_state = 1},
  [470] = {.lex_state = 1},
  [471] = {.lex_state = 1},
  [472] = {.lex_state = 0},
  [473] = {.lex_state = 1},
  [474] = {.lex_state = 1},
  [475] = {.lex_state = 1},
  [476] = {.lex_state = 1},
  [477] = {.lex_state = 1},
  [478] = {.lex_state = 1},
  [479] = {.lex_state = 1},
  [480] = {.lex_state = 1},
  [481] = {.lex_state = 0},
  [482] = {.lex_state = 0},
  [483] = {.lex_state = 1},
  [484] = {.lex_state = 0},
  [485] = {.lex_state = 0},
  [486] = {.lex_state = 1},
  [487] = {.lex_state = 0},
  [488] = {.lex_state = 0},
  [489] = {.lex_state = 0},
  [490] = {.lex_state = 137},
  [491] = {.lex_state = 0},
  [492] = {.lex_state = 137},
  [493] = {.lex_state = 0},
  [494] = {.lex_state = 0},
  [495] = {.lex_state = 1},
  [496] = {.lex_state = 0},
  [497] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_version] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [sym_controlled_language_tag] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_u2260] = ACTIONS(1),
    [sym_less_than] = ACTIONS(1),
    [sym_greater_than] = ACTIONS(1),
    [anon_sym_u2264] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_u2265] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_u00ac] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_u2227] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_u2228] = ACTIONS(1),
    [anon_sym_xor] = ACTIONS(1),
    [anon_sym_u22bb] = ACTIONS(1),
    [anon_sym_implies] = ACTIONS(1),
    [anon_sym_EQ_EQ_GT] = ACTIONS(1),
    [anon_sym_u21d2] = ACTIONS(1),
    [anon_sym_iff] = ACTIONS(1),
    [anon_sym_u21d4] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_forall] = ACTIONS(1),
    [anon_sym_u2200] = ACTIONS(1),
    [anon_sym_exists] = ACTIONS(1),
    [anon_sym_u2203] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_u2208] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_u2205] = ACTIONS(1),
    [sym_reserved_self] = ACTIONS(1),
    [anon_sym_def] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_u2254] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [sym_optional] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_boolean] = ACTIONS(1),
    [anon_sym_unsigned] = ACTIONS(1),
    [anon_sym_integer] = ACTIONS(1),
    [anon_sym_decimal] = ACTIONS(1),
    [anon_sym_double] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_iri] = ACTIONS(1),
    [anon_sym_binary] = ACTIONS(1),
    [sym_quoted_string] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_POUND_LBRACK] = ACTIONS(1),
    [sym_hex_byte] = ACTIONS(1),
    [sym_double] = ACTIONS(1),
    [sym_decimal] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_unsigned] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_u22a4] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_u22a5] = ACTIONS(1),
    [anon_sym_datatype] = ACTIONS(1),
    [sym_opaque] = ACTIONS(1),
    [anon_sym_dimension] = ACTIONS(1),
    [anon_sym_source] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_parent] = ACTIONS(1),
    [anon_sym_entity] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_event] = ACTIONS(1),
    [anon_sym_property] = ACTIONS(1),
    [anon_sym_structure] = ACTIONS(1),
    [anon_sym_union] = ACTIONS(1),
    [anon_sym_rdf] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [sym_wildcard] = ACTIONS(1),
    [anon_sym_identity] = ACTIONS(1),
    [anon_sym_ref] = ACTIONS(1),
    [sym_unknown_type] = ACTIONS(1),
    [anon_sym_ordered] = ACTIONS(1),
    [anon_sym_unordered] = ACTIONS(1),
    [anon_sym_unique] = ACTIONS(1),
    [anon_sym_nonunique] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_u2192] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_u2190] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_module] = STATE(497),
    [anon_sym_module] = ACTIONS(5),
    [sym_line_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 36,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_u2205,
    ACTIONS(21), 1,
      sym_reserved_self,
    ACTIONS(23), 1,
      anon_sym_def,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(7), 1,
      sym_negation,
    STATE(10), 1,
      sym_constraint_environment,
    STATE(125), 1,
      sym_constraint_sentence,
    STATE(132), 1,
      sym_simple_sentence,
    STATE(135), 1,
      sym_boolean_sentence,
    STATE(140), 1,
      sym_quantified_sentence,
    STATE(176), 1,
      sym_term,
    STATE(448), 1,
      sym__sequence_value_constraints,
    STATE(465), 1,
      sym_quantified_variable_binding,
    ACTIONS(13), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(15), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(17), 2,
      anon_sym_exists,
      anon_sym_u2203,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(17), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(57), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(136), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(328), 2,
      sym_environment_def,
      aux_sym_constraint_environment_repeat1,
    STATE(380), 2,
      sym_universal,
      sym_existential,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(147), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(58), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [130] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(41), 6,
      anon_sym_as,
      sym_identifier,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(43), 50,
      anon_sym_is,
      anon_sym_end,
      anon_sym_import,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_with,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_PLUS,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [194] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(45), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(47), 49,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_with,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_PLUS,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [256] = 33,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_u2205,
    ACTIONS(21), 1,
      sym_reserved_self,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(7), 1,
      sym_negation,
    STATE(77), 1,
      sym_constraint_sentence,
    STATE(132), 1,
      sym_simple_sentence,
    STATE(135), 1,
      sym_boolean_sentence,
    STATE(140), 1,
      sym_quantified_sentence,
    STATE(176), 1,
      sym_term,
    STATE(448), 1,
      sym__sequence_value_constraints,
    STATE(465), 1,
      sym_quantified_variable_binding,
    ACTIONS(13), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(15), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(17), 2,
      anon_sym_exists,
      anon_sym_u2203,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(17), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(57), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(136), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(380), 2,
      sym_universal,
      sym_existential,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(147), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(58), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [376] = 33,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_u2205,
    ACTIONS(21), 1,
      sym_reserved_self,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(7), 1,
      sym_negation,
    STATE(97), 1,
      sym_constraint_sentence,
    STATE(132), 1,
      sym_simple_sentence,
    STATE(135), 1,
      sym_boolean_sentence,
    STATE(140), 1,
      sym_quantified_sentence,
    STATE(176), 1,
      sym_term,
    STATE(448), 1,
      sym__sequence_value_constraints,
    STATE(465), 1,
      sym_quantified_variable_binding,
    ACTIONS(13), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(15), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(17), 2,
      anon_sym_exists,
      anon_sym_u2203,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(17), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(57), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(136), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(380), 2,
      sym_universal,
      sym_existential,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(147), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(58), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [496] = 33,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_u2205,
    ACTIONS(21), 1,
      sym_reserved_self,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(7), 1,
      sym_negation,
    STATE(78), 1,
      sym_constraint_sentence,
    STATE(132), 1,
      sym_simple_sentence,
    STATE(135), 1,
      sym_boolean_sentence,
    STATE(140), 1,
      sym_quantified_sentence,
    STATE(176), 1,
      sym_term,
    STATE(448), 1,
      sym__sequence_value_constraints,
    STATE(465), 1,
      sym_quantified_variable_binding,
    ACTIONS(13), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(15), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(17), 2,
      anon_sym_exists,
      anon_sym_u2203,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(17), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(57), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(136), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(380), 2,
      sym_universal,
      sym_existential,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(147), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(58), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [616] = 33,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_u2205,
    ACTIONS(21), 1,
      sym_reserved_self,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(7), 1,
      sym_negation,
    STATE(79), 1,
      sym_constraint_sentence,
    STATE(132), 1,
      sym_simple_sentence,
    STATE(135), 1,
      sym_boolean_sentence,
    STATE(140), 1,
      sym_quantified_sentence,
    STATE(176), 1,
      sym_term,
    STATE(448), 1,
      sym__sequence_value_constraints,
    STATE(465), 1,
      sym_quantified_variable_binding,
    ACTIONS(13), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(15), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(17), 2,
      anon_sym_exists,
      anon_sym_u2203,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(17), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(57), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(136), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(380), 2,
      sym_universal,
      sym_existential,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(147), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(58), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [736] = 33,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_u2205,
    ACTIONS(21), 1,
      sym_reserved_self,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(7), 1,
      sym_negation,
    STATE(128), 1,
      sym_constraint_sentence,
    STATE(132), 1,
      sym_simple_sentence,
    STATE(135), 1,
      sym_boolean_sentence,
    STATE(140), 1,
      sym_quantified_sentence,
    STATE(176), 1,
      sym_term,
    STATE(448), 1,
      sym__sequence_value_constraints,
    STATE(465), 1,
      sym_quantified_variable_binding,
    ACTIONS(13), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(15), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(17), 2,
      anon_sym_exists,
      anon_sym_u2203,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(17), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(57), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(136), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(380), 2,
      sym_universal,
      sym_existential,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(147), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(58), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [856] = 33,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_u2205,
    ACTIONS(21), 1,
      sym_reserved_self,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(7), 1,
      sym_negation,
    STATE(119), 1,
      sym_constraint_sentence,
    STATE(132), 1,
      sym_simple_sentence,
    STATE(135), 1,
      sym_boolean_sentence,
    STATE(140), 1,
      sym_quantified_sentence,
    STATE(176), 1,
      sym_term,
    STATE(448), 1,
      sym__sequence_value_constraints,
    STATE(465), 1,
      sym_quantified_variable_binding,
    ACTIONS(13), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(15), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(17), 2,
      anon_sym_exists,
      anon_sym_u2203,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(17), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(57), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(136), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(380), 2,
      sym_universal,
      sym_existential,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(147), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(58), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [976] = 34,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(19), 1,
      anon_sym_u2205,
    ACTIONS(21), 1,
      sym_reserved_self,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(7), 1,
      sym_negation,
    STATE(113), 1,
      sym_constraint_sentence,
    STATE(132), 1,
      sym_simple_sentence,
    STATE(135), 1,
      sym_boolean_sentence,
    STATE(140), 1,
      sym_quantified_sentence,
    STATE(176), 1,
      sym_term,
    STATE(197), 1,
      sym_predicate_value,
    STATE(448), 1,
      sym__sequence_value_constraints,
    STATE(465), 1,
      sym_quantified_variable_binding,
    ACTIONS(13), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(15), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(17), 2,
      anon_sym_exists,
      anon_sym_u2203,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(17), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(57), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(136), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(380), 2,
      sym_universal,
      sym_existential,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(147), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(58), 4,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_sequence_builder,
  [1098] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(49), 6,
      anon_sym_as,
      sym_identifier,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(51), 44,
      anon_sym_version,
      anon_sym_is,
      anon_sym_end,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [1156] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(57), 1,
      sym_language_tag,
    ACTIONS(53), 6,
      sym_identifier,
      anon_sym_AT,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(55), 41,
      anon_sym_is,
      anon_sym_end,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [1214] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(59), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(61), 42,
      anon_sym_is,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [1269] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(63), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(65), 42,
      anon_sym_is,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [1324] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(67), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(69), 42,
      anon_sym_is,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [1379] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(71), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(73), 42,
      anon_sym_is,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [1434] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(75), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(77), 42,
      anon_sym_is,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [1489] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(81), 42,
      anon_sym_is,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [1544] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(83), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(85), 42,
      anon_sym_is,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [1599] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(87), 1,
      sym_identifier,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_RPAREN,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(95), 1,
      sym_reserved_self,
    ACTIONS(97), 1,
      anon_sym_LBRACE,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    STATE(26), 1,
      aux_sym_actual_arguments_repeat1,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(123), 1,
      sym_term,
    STATE(494), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(107), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(129), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(102), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(139), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [1679] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(87), 1,
      sym_identifier,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(95), 1,
      sym_reserved_self,
    ACTIONS(97), 1,
      anon_sym_LBRACE,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(113), 1,
      anon_sym_RPAREN,
    STATE(25), 1,
      aux_sym_actual_arguments_repeat1,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(123), 1,
      sym_term,
    STATE(494), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(107), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(129), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(102), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(139), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [1759] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(119), 1,
      anon_sym_LPAREN,
    ACTIONS(115), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(117), 29,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_u2205,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [1803] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(87), 1,
      sym_identifier,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(95), 1,
      sym_reserved_self,
    ACTIONS(97), 1,
      anon_sym_LBRACE,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(121), 1,
      anon_sym_RPAREN,
    STATE(22), 1,
      aux_sym_actual_arguments_repeat1,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(123), 1,
      sym_term,
    STATE(494), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(107), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(129), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(102), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(139), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [1883] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(123), 1,
      sym_identifier,
    ACTIONS(126), 1,
      anon_sym_LBRACK,
    ACTIONS(129), 1,
      anon_sym_RPAREN,
    ACTIONS(131), 1,
      anon_sym_u2205,
    ACTIONS(134), 1,
      sym_reserved_self,
    ACTIONS(137), 1,
      anon_sym_LBRACE,
    ACTIONS(140), 1,
      sym_quoted_string,
    ACTIONS(143), 1,
      anon_sym_LT,
    ACTIONS(146), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(149), 1,
      sym_double,
    STATE(25), 1,
      aux_sym_actual_arguments_repeat1,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(123), 1,
      sym_term,
    STATE(494), 1,
      sym__sequence_value_constraints,
    ACTIONS(155), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(158), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(107), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(129), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(152), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(102), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(139), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [1963] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(87), 1,
      sym_identifier,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(95), 1,
      sym_reserved_self,
    ACTIONS(97), 1,
      anon_sym_LBRACE,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(161), 1,
      anon_sym_RPAREN,
    STATE(25), 1,
      aux_sym_actual_arguments_repeat1,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(123), 1,
      sym_term,
    STATE(494), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(107), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(129), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(102), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(139), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [2043] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(163), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(165), 29,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_u2205,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [2084] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(167), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(169), 29,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_u2205,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [2125] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(171), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(173), 29,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_u2205,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [2166] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(115), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(117), 29,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_u2205,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [2207] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(175), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(177), 29,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_u2205,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [2248] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(179), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(181), 29,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_u2205,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [2289] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(183), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(185), 29,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_u2205,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [2330] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(187), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(189), 29,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_u2205,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [2371] = 20,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_u2205,
    ACTIONS(21), 1,
      sym_reserved_self,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(390), 1,
      sym_term,
    STATE(448), 1,
      sym__sequence_value_constraints,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(17), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(57), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(58), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [2445] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(45), 1,
      sym_identifier,
    ACTIONS(191), 1,
      anon_sym_COLON,
    ACTIONS(47), 30,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
      anon_sym_LBRACE,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_with,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_PLUS,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [2487] = 20,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_u2205,
    ACTIONS(21), 1,
      sym_reserved_self,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(112), 1,
      sym_term,
    STATE(448), 1,
      sym__sequence_value_constraints,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(17), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(57), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(58), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [2561] = 20,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym_LBRACK,
    ACTIONS(19), 1,
      anon_sym_u2205,
    ACTIONS(21), 1,
      sym_reserved_self,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(111), 1,
      sym_term,
    STATE(448), 1,
      sym__sequence_value_constraints,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(17), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(57), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(58), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [2635] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(193), 1,
      anon_sym_COLON,
    ACTIONS(195), 1,
      anon_sym_DOT,
    STATE(42), 1,
      aux_sym_function_composition_repeat1,
    ACTIONS(45), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(47), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [2681] = 20,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(197), 1,
      anon_sym_end,
    ACTIONS(199), 1,
      anon_sym_import,
    ACTIONS(201), 1,
      anon_sym_AT,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(205), 1,
      anon_sym_datatype,
    ACTIONS(207), 1,
      anon_sym_dimension,
    ACTIONS(209), 1,
      anon_sym_entity,
    ACTIONS(211), 1,
      anon_sym_enum,
    ACTIONS(213), 1,
      anon_sym_event,
    ACTIONS(215), 1,
      anon_sym_property,
    ACTIONS(217), 1,
      anon_sym_structure,
    ACTIONS(219), 1,
      anon_sym_union,
    ACTIONS(221), 1,
      anon_sym_rdf,
    ACTIONS(223), 1,
      anon_sym_class,
    STATE(66), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(91), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(141), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(161), 2,
      sym_import_statement,
      aux_sym_module_body_repeat1,
    STATE(204), 10,
      sym_data_type_def,
      sym_dimension_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_structure_def,
      sym_union_def,
      sym_rdf_def,
      sym_type_class_def,
  [2755] = 20,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(199), 1,
      anon_sym_import,
    ACTIONS(201), 1,
      anon_sym_AT,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(205), 1,
      anon_sym_datatype,
    ACTIONS(207), 1,
      anon_sym_dimension,
    ACTIONS(209), 1,
      anon_sym_entity,
    ACTIONS(211), 1,
      anon_sym_enum,
    ACTIONS(213), 1,
      anon_sym_event,
    ACTIONS(215), 1,
      anon_sym_property,
    ACTIONS(217), 1,
      anon_sym_structure,
    ACTIONS(219), 1,
      anon_sym_union,
    ACTIONS(221), 1,
      anon_sym_rdf,
    ACTIONS(223), 1,
      anon_sym_class,
    ACTIONS(225), 1,
      anon_sym_end,
    STATE(40), 2,
      sym_import_statement,
      aux_sym_module_body_repeat1,
    STATE(64), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(85), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(141), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(204), 10,
      sym_data_type_def,
      sym_dimension_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_structure_def,
      sym_union_def,
      sym_rdf_def,
      sym_type_class_def,
  [2829] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(195), 1,
      anon_sym_DOT,
    STATE(53), 1,
      aux_sym_function_composition_repeat1,
    ACTIONS(229), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(227), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [2872] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(195), 1,
      anon_sym_DOT,
    STATE(53), 1,
      aux_sym_function_composition_repeat1,
    ACTIONS(229), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(227), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [2915] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(195), 1,
      anon_sym_DOT,
    STATE(43), 1,
      aux_sym_function_composition_repeat1,
    ACTIONS(233), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(231), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [2958] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(235), 1,
      sym_identifier,
    ACTIONS(238), 1,
      anon_sym_LBRACK,
    ACTIONS(241), 1,
      anon_sym_RBRACK,
    ACTIONS(243), 1,
      anon_sym_u2205,
    ACTIONS(246), 1,
      anon_sym_LBRACE,
    ACTIONS(249), 1,
      sym_quoted_string,
    ACTIONS(252), 1,
      anon_sym_LT,
    ACTIONS(255), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(258), 1,
      sym_double,
    STATE(45), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(127), 1,
      sym_simple_value,
    STATE(129), 1,
      sym_sequence_of_predicate_values,
    STATE(154), 1,
      sym_identifier_reference,
    STATE(494), 1,
      sym__sequence_value_constraints,
    ACTIONS(264), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(267), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(107), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(261), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(158), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(102), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [3035] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(270), 1,
      sym_identifier,
    ACTIONS(272), 1,
      anon_sym_RBRACK,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    STATE(50), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(127), 1,
      sym_simple_value,
    STATE(129), 1,
      sym_sequence_of_predicate_values,
    STATE(154), 1,
      sym_identifier_reference,
    STATE(494), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(107), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(158), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(102), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [3112] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(270), 1,
      sym_identifier,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(276), 1,
      anon_sym_RBRACK,
    STATE(49), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(127), 1,
      sym_simple_value,
    STATE(129), 1,
      sym_sequence_of_predicate_values,
    STATE(154), 1,
      sym_identifier_reference,
    STATE(494), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(107), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(158), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(102), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [3189] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(270), 1,
      sym_identifier,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(278), 1,
      anon_sym_RBRACK,
    STATE(45), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(127), 1,
      sym_simple_value,
    STATE(129), 1,
      sym_sequence_of_predicate_values,
    STATE(154), 1,
      sym_identifier_reference,
    STATE(494), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(107), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(158), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(102), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [3266] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(270), 1,
      sym_identifier,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(280), 1,
      anon_sym_RBRACK,
    STATE(45), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(127), 1,
      sym_simple_value,
    STATE(129), 1,
      sym_sequence_of_predicate_values,
    STATE(154), 1,
      sym_identifier_reference,
    STATE(494), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(107), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(158), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(102), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [3343] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(270), 1,
      sym_identifier,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(282), 1,
      anon_sym_RBRACK,
    STATE(45), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(127), 1,
      sym_simple_value,
    STATE(129), 1,
      sym_sequence_of_predicate_values,
    STATE(154), 1,
      sym_identifier_reference,
    STATE(494), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(107), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(158), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(102), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [3420] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(270), 1,
      sym_identifier,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(284), 1,
      anon_sym_RBRACK,
    STATE(54), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(127), 1,
      sym_simple_value,
    STATE(129), 1,
      sym_sequence_of_predicate_values,
    STATE(154), 1,
      sym_identifier_reference,
    STATE(494), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(107), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(158), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(102), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [3497] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(270), 1,
      sym_identifier,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(286), 1,
      anon_sym_RBRACK,
    STATE(48), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(127), 1,
      sym_simple_value,
    STATE(129), 1,
      sym_sequence_of_predicate_values,
    STATE(154), 1,
      sym_identifier_reference,
    STATE(494), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(107), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(158), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(102), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [3574] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(292), 1,
      anon_sym_DOT,
    STATE(53), 1,
      aux_sym_function_composition_repeat1,
    ACTIONS(290), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(288), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [3617] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_u2205,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(270), 1,
      sym_identifier,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(295), 1,
      anon_sym_RBRACK,
    STATE(45), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(127), 1,
      sym_simple_value,
    STATE(129), 1,
      sym_sequence_of_predicate_values,
    STATE(154), 1,
      sym_identifier_reference,
    STATE(494), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(107), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(158), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(102), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [3694] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(299), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(297), 26,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_DOT,
      anon_sym_def,
      anon_sym_RBRACE,
  [3732] = 20,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      anon_sym_u2205,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(23), 1,
      sym_identifier_reference,
    STATE(29), 1,
      sym_value,
    STATE(98), 1,
      sym_simple_value,
    STATE(447), 1,
      sym__sequence_value_constraints,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(17), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(30), 3,
      sym_sequence_of_values,
      sym_value_constructor,
      sym_mapping_value,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [3803] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(309), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(307), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [3840] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(233), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(231), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [3877] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(313), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(311), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [3914] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(317), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(315), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [3951] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(321), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(319), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [3988] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(325), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(323), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [4025] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(329), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(327), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [4062] = 18,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(197), 1,
      anon_sym_end,
    ACTIONS(201), 1,
      anon_sym_AT,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(205), 1,
      anon_sym_datatype,
    ACTIONS(207), 1,
      anon_sym_dimension,
    ACTIONS(209), 1,
      anon_sym_entity,
    ACTIONS(211), 1,
      anon_sym_enum,
    ACTIONS(213), 1,
      anon_sym_event,
    ACTIONS(215), 1,
      anon_sym_property,
    ACTIONS(217), 1,
      anon_sym_structure,
    ACTIONS(219), 1,
      anon_sym_union,
    ACTIONS(221), 1,
      anon_sym_rdf,
    ACTIONS(223), 1,
      anon_sym_class,
    STATE(91), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(96), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(141), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(204), 10,
      sym_data_type_def,
      sym_dimension_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_structure_def,
      sym_union_def,
      sym_rdf_def,
      sym_type_class_def,
  [4129] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(333), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(331), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [4166] = 18,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(201), 1,
      anon_sym_AT,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(205), 1,
      anon_sym_datatype,
    ACTIONS(207), 1,
      anon_sym_dimension,
    ACTIONS(209), 1,
      anon_sym_entity,
    ACTIONS(211), 1,
      anon_sym_enum,
    ACTIONS(213), 1,
      anon_sym_event,
    ACTIONS(215), 1,
      anon_sym_property,
    ACTIONS(217), 1,
      anon_sym_structure,
    ACTIONS(219), 1,
      anon_sym_union,
    ACTIONS(221), 1,
      anon_sym_rdf,
    ACTIONS(223), 1,
      anon_sym_class,
    ACTIONS(335), 1,
      anon_sym_end,
    STATE(90), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(96), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(141), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(204), 10,
      sym_data_type_def,
      sym_dimension_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_structure_def,
      sym_union_def,
      sym_rdf_def,
      sym_type_class_def,
  [4233] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(339), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(337), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [4270] = 20,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(270), 1,
      sym_identifier,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      anon_sym_u2205,
    STATE(23), 1,
      sym_identifier_reference,
    STATE(29), 1,
      sym_value,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(117), 1,
      sym_simple_value,
    STATE(447), 1,
      sym__sequence_value_constraints,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(107), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(30), 3,
      sym_sequence_of_values,
      sym_value_constructor,
      sym_mapping_value,
    STATE(102), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [4341] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(343), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(341), 25,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [4378] = 20,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(303), 1,
      anon_sym_LBRACK,
    ACTIONS(305), 1,
      anon_sym_u2205,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(23), 1,
      sym_identifier_reference,
    STATE(98), 1,
      sym_simple_value,
    STATE(149), 1,
      sym_value,
    STATE(447), 1,
      sym__sequence_value_constraints,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(17), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(30), 3,
      sym_sequence_of_values,
      sym_value_constructor,
      sym_mapping_value,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [4449] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(347), 4,
      anon_sym_EQ,
      sym_less_than,
      sym_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(349), 6,
      anon_sym_LPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
    ACTIONS(345), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [4487] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(351), 1,
      sym_identifier,
    ACTIONS(354), 1,
      anon_sym_RBRACK,
    ACTIONS(356), 1,
      sym_quoted_string,
    ACTIONS(359), 1,
      anon_sym_LT,
    ACTIONS(362), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(365), 1,
      sym_double,
    STATE(72), 1,
      aux_sym_sequence_of_values_repeat1,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(156), 1,
      sym_simple_value,
    STATE(178), 1,
      sym_identifier_reference,
    ACTIONS(371), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(374), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(107), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(184), 2,
      sym_value_constructor,
      sym_mapping_value,
    ACTIONS(368), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(102), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [4548] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(270), 1,
      sym_identifier,
    ACTIONS(377), 1,
      anon_sym_RBRACK,
    STATE(76), 1,
      aux_sym_sequence_of_values_repeat1,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(156), 1,
      sym_simple_value,
    STATE(178), 1,
      sym_identifier_reference,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(107), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(184), 2,
      sym_value_constructor,
      sym_mapping_value,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(102), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [4609] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(270), 1,
      sym_identifier,
    ACTIONS(379), 1,
      anon_sym_RBRACK,
    STATE(75), 1,
      aux_sym_sequence_of_values_repeat1,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(156), 1,
      sym_simple_value,
    STATE(178), 1,
      sym_identifier_reference,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(107), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(184), 2,
      sym_value_constructor,
      sym_mapping_value,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(102), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [4670] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(270), 1,
      sym_identifier,
    ACTIONS(381), 1,
      anon_sym_RBRACK,
    STATE(72), 1,
      aux_sym_sequence_of_values_repeat1,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(156), 1,
      sym_simple_value,
    STATE(178), 1,
      sym_identifier_reference,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(107), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(184), 2,
      sym_value_constructor,
      sym_mapping_value,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(102), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [4731] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(99), 1,
      sym_quoted_string,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(103), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(105), 1,
      sym_double,
    ACTIONS(270), 1,
      sym_identifier,
    ACTIONS(383), 1,
      anon_sym_RBRACK,
    STATE(72), 1,
      aux_sym_sequence_of_values_repeat1,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(156), 1,
      sym_simple_value,
    STATE(178), 1,
      sym_identifier_reference,
    ACTIONS(109), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(111), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(107), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(184), 2,
      sym_value_constructor,
      sym_mapping_value,
    ACTIONS(107), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(102), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [4792] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(5), 6,
      sym__logical_connective,
      sym_conjunction,
      sym_disjunction,
      sym_exclusive_disjunction,
      sym_implication,
      sym_biconditional,
    ACTIONS(385), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [4824] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(5), 6,
      sym__logical_connective,
      sym_conjunction,
      sym_disjunction,
      sym_exclusive_disjunction,
      sym_implication,
      sym_biconditional,
    ACTIONS(387), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [4856] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(391), 2,
      anon_sym_and,
      anon_sym_u2227,
    ACTIONS(393), 2,
      anon_sym_or,
      anon_sym_u2228,
    ACTIONS(395), 2,
      anon_sym_xor,
      anon_sym_u22bb,
    ACTIONS(397), 3,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
    ACTIONS(399), 3,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
    ACTIONS(389), 6,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
    STATE(5), 6,
      sym__logical_connective,
      sym_conjunction,
      sym_disjunction,
      sym_exclusive_disjunction,
      sym_implication,
      sym_biconditional,
  [4898] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(401), 1,
      anon_sym_end,
    ACTIONS(403), 1,
      anon_sym_datatype,
    ACTIONS(406), 1,
      anon_sym_dimension,
    ACTIONS(409), 1,
      anon_sym_entity,
    ACTIONS(412), 1,
      anon_sym_enum,
    ACTIONS(415), 1,
      anon_sym_event,
    ACTIONS(418), 1,
      anon_sym_property,
    ACTIONS(421), 1,
      anon_sym_structure,
    ACTIONS(424), 1,
      anon_sym_union,
    ACTIONS(427), 1,
      anon_sym_rdf,
    ACTIONS(430), 1,
      anon_sym_class,
    STATE(80), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(204), 10,
      sym_data_type_def,
      sym_dimension_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_structure_def,
      sym_union_def,
      sym_rdf_def,
      sym_type_class_def,
  [4951] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(433), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(435), 19,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_not,
      anon_sym_u00ac,
      anon_sym_forall,
      anon_sym_u2200,
      anon_sym_exists,
      anon_sym_u2203,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [4982] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(437), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(439), 19,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_not,
      anon_sym_u00ac,
      anon_sym_forall,
      anon_sym_u2200,
      anon_sym_exists,
      anon_sym_u2203,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [5013] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(441), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(443), 19,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_not,
      anon_sym_u00ac,
      anon_sym_forall,
      anon_sym_u2200,
      anon_sym_exists,
      anon_sym_u2203,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [5044] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(445), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(447), 19,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_not,
      anon_sym_u00ac,
      anon_sym_forall,
      anon_sym_u2200,
      anon_sym_exists,
      anon_sym_u2203,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [5075] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(197), 1,
      anon_sym_end,
    ACTIONS(205), 1,
      anon_sym_datatype,
    ACTIONS(207), 1,
      anon_sym_dimension,
    ACTIONS(209), 1,
      anon_sym_entity,
    ACTIONS(211), 1,
      anon_sym_enum,
    ACTIONS(213), 1,
      anon_sym_event,
    ACTIONS(215), 1,
      anon_sym_property,
    ACTIONS(217), 1,
      anon_sym_structure,
    ACTIONS(219), 1,
      anon_sym_union,
    ACTIONS(221), 1,
      anon_sym_rdf,
    ACTIONS(223), 1,
      anon_sym_class,
    STATE(80), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(204), 10,
      sym_data_type_def,
      sym_dimension_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_structure_def,
      sym_union_def,
      sym_rdf_def,
      sym_type_class_def,
  [5128] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(449), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(451), 19,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_not,
      anon_sym_u00ac,
      anon_sym_forall,
      anon_sym_u2200,
      anon_sym_exists,
      anon_sym_u2203,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [5159] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(453), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(455), 19,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_not,
      anon_sym_u00ac,
      anon_sym_forall,
      anon_sym_u2200,
      anon_sym_exists,
      anon_sym_u2203,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [5190] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(457), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(459), 19,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_not,
      anon_sym_u00ac,
      anon_sym_forall,
      anon_sym_u2200,
      anon_sym_exists,
      anon_sym_u2203,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [5221] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(461), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(463), 19,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_not,
      anon_sym_u00ac,
      anon_sym_forall,
      anon_sym_u2200,
      anon_sym_exists,
      anon_sym_u2203,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [5252] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(205), 1,
      anon_sym_datatype,
    ACTIONS(207), 1,
      anon_sym_dimension,
    ACTIONS(209), 1,
      anon_sym_entity,
    ACTIONS(211), 1,
      anon_sym_enum,
    ACTIONS(213), 1,
      anon_sym_event,
    ACTIONS(215), 1,
      anon_sym_property,
    ACTIONS(217), 1,
      anon_sym_structure,
    ACTIONS(219), 1,
      anon_sym_union,
    ACTIONS(221), 1,
      anon_sym_rdf,
    ACTIONS(223), 1,
      anon_sym_class,
    ACTIONS(465), 1,
      anon_sym_end,
    STATE(80), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(204), 10,
      sym_data_type_def,
      sym_dimension_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_structure_def,
      sym_union_def,
      sym_rdf_def,
      sym_type_class_def,
  [5305] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(205), 1,
      anon_sym_datatype,
    ACTIONS(207), 1,
      anon_sym_dimension,
    ACTIONS(209), 1,
      anon_sym_entity,
    ACTIONS(211), 1,
      anon_sym_enum,
    ACTIONS(213), 1,
      anon_sym_event,
    ACTIONS(215), 1,
      anon_sym_property,
    ACTIONS(217), 1,
      anon_sym_structure,
    ACTIONS(219), 1,
      anon_sym_union,
    ACTIONS(221), 1,
      anon_sym_rdf,
    ACTIONS(223), 1,
      anon_sym_class,
    ACTIONS(335), 1,
      anon_sym_end,
    STATE(80), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(204), 10,
      sym_data_type_def,
      sym_dimension_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_structure_def,
      sym_union_def,
      sym_rdf_def,
      sym_type_class_def,
  [5358] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(467), 1,
      sym_language_tag,
    ACTIONS(53), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(55), 17,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [5390] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(41), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(43), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_as,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [5420] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(49), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(51), 18,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_as,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [5450] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(45), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(47), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_as,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [5480] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(469), 1,
      sym_identifier,
    ACTIONS(473), 1,
      anon_sym_AT,
    ACTIONS(476), 1,
      anon_sym_assert,
    STATE(96), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(141), 2,
      sym_annotation_property,
      sym_constraint,
    ACTIONS(471), 15,
      anon_sym_end,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [5518] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(391), 2,
      anon_sym_and,
      anon_sym_u2227,
    ACTIONS(393), 2,
      anon_sym_or,
      anon_sym_u2228,
    ACTIONS(395), 2,
      anon_sym_xor,
      anon_sym_u22bb,
    ACTIONS(397), 3,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
    ACTIONS(399), 3,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
    ACTIONS(479), 4,
      anon_sym_is,
      anon_sym_end,
      anon_sym_in,
      anon_sym_def,
    STATE(5), 6,
      sym__logical_connective,
      sym_conjunction,
      sym_disjunction,
      sym_exclusive_disjunction,
      sym_implication,
      sym_biconditional,
  [5558] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(115), 1,
      sym_identifier,
    STATE(56), 1,
      sym__has_type,
    ACTIONS(481), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
    ACTIONS(117), 17,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [5591] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(483), 1,
      anon_sym_COLON,
    ACTIONS(485), 1,
      anon_sym_DOT,
    STATE(116), 1,
      aux_sym_function_composition_repeat1,
    ACTIONS(45), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(47), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [5626] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(487), 1,
      sym_identifier,
    ACTIONS(489), 20,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [5655] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(81), 17,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [5684] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(67), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(69), 17,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [5713] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(83), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(85), 17,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [5742] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(63), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(65), 17,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [5771] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(491), 1,
      sym_identifier,
    ACTIONS(493), 20,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [5800] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(59), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(61), 17,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [5829] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(71), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(73), 17,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [5858] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(75), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(77), 17,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [5887] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(495), 1,
      anon_sym_DOT,
    STATE(109), 1,
      aux_sym_function_composition_repeat1,
    ACTIONS(290), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(288), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [5919] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(349), 20,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_COMMA,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [5945] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(500), 1,
      anon_sym_LPAREN,
    STATE(110), 1,
      sym_actual_arguments,
    ACTIONS(498), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [5975] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(500), 1,
      anon_sym_LPAREN,
    STATE(110), 1,
      sym_actual_arguments,
    ACTIONS(502), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [6005] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(391), 2,
      anon_sym_and,
      anon_sym_u2227,
    ACTIONS(393), 2,
      anon_sym_or,
      anon_sym_u2228,
    ACTIONS(395), 2,
      anon_sym_xor,
      anon_sym_u22bb,
    ACTIONS(504), 2,
      anon_sym_in,
      anon_sym_def,
    ACTIONS(397), 3,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
    ACTIONS(399), 3,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
    STATE(5), 6,
      sym__logical_connective,
      sym_conjunction,
      sym_disjunction,
      sym_exclusive_disjunction,
      sym_implication,
      sym_biconditional,
  [6043] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(485), 1,
      anon_sym_DOT,
    STATE(115), 1,
      aux_sym_function_composition_repeat1,
    ACTIONS(233), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(231), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6075] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(485), 1,
      anon_sym_DOT,
    STATE(109), 1,
      aux_sym_function_composition_repeat1,
    ACTIONS(229), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(227), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6107] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(485), 1,
      anon_sym_DOT,
    STATE(109), 1,
      aux_sym_function_composition_repeat1,
    ACTIONS(229), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(227), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6139] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(68), 1,
      sym__has_type,
    ACTIONS(506), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
    ACTIONS(115), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(117), 12,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_u2205,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6170] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(343), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(341), 15,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6197] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(508), 1,
      anon_sym_end,
    ACTIONS(391), 2,
      anon_sym_and,
      anon_sym_u2227,
    ACTIONS(393), 2,
      anon_sym_or,
      anon_sym_u2228,
    ACTIONS(395), 2,
      anon_sym_xor,
      anon_sym_u22bb,
    ACTIONS(397), 3,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
    ACTIONS(399), 3,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
    STATE(5), 6,
      sym__logical_connective,
      sym_conjunction,
      sym_disjunction,
      sym_exclusive_disjunction,
      sym_implication,
      sym_biconditional,
  [6234] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(321), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(319), 15,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6261] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(313), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(311), 15,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6288] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(193), 1,
      anon_sym_COLON,
    ACTIONS(512), 1,
      anon_sym_as,
    STATE(162), 1,
      sym__rename_import,
    STATE(164), 1,
      sym_iri,
    ACTIONS(510), 14,
      anon_sym_end,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [6323] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(518), 1,
      anon_sym_LPAREN,
    STATE(146), 1,
      sym_actual_arguments,
    ACTIONS(514), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(516), 13,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6354] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(299), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(297), 15,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6381] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(520), 1,
      anon_sym_end,
    ACTIONS(391), 2,
      anon_sym_and,
      anon_sym_u2227,
    ACTIONS(393), 2,
      anon_sym_or,
      anon_sym_u2228,
    ACTIONS(395), 2,
      anon_sym_xor,
      anon_sym_u22bb,
    ACTIONS(397), 3,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
    ACTIONS(399), 3,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
    STATE(5), 6,
      sym__logical_connective,
      sym_conjunction,
      sym_disjunction,
      sym_exclusive_disjunction,
      sym_implication,
      sym_biconditional,
  [6418] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(329), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(327), 15,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6445] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(68), 1,
      sym__has_type,
    ACTIONS(506), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
    ACTIONS(309), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(307), 12,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_u2205,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6476] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(522), 1,
      anon_sym_RPAREN,
    ACTIONS(391), 2,
      anon_sym_and,
      anon_sym_u2227,
    ACTIONS(393), 2,
      anon_sym_or,
      anon_sym_u2228,
    ACTIONS(395), 2,
      anon_sym_xor,
      anon_sym_u22bb,
    ACTIONS(397), 3,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
    ACTIONS(399), 3,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
    STATE(5), 6,
      sym__logical_connective,
      sym_conjunction,
      sym_disjunction,
      sym_exclusive_disjunction,
      sym_implication,
      sym_biconditional,
  [6513] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(309), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(307), 15,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6540] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(528), 1,
      sym_controlled_language_tag,
    ACTIONS(524), 2,
      sym_identifier,
      anon_sym_AT,
    ACTIONS(526), 16,
      anon_sym_end,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [6569] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(325), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(323), 15,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6596] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(530), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [6620] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(339), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(337), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6646] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(483), 1,
      anon_sym_COLON,
    ACTIONS(45), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(47), 13,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_u2205,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6674] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(530), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [6698] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(532), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [6722] = 11,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(27), 1,
      sym_quoted_string,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(31), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(33), 1,
      sym_double,
    STATE(424), 1,
      sym_simple_value,
    ACTIONS(37), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(39), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(17), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(35), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(16), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [6764] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(536), 17,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [6790] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(233), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(231), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6816] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(530), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [6840] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(538), 1,
      sym_identifier,
    ACTIONS(540), 17,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [6866] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(542), 1,
      sym_identifier,
    ACTIONS(544), 17,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [6892] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(546), 1,
      anon_sym_LPAREN,
    ACTIONS(548), 1,
      anon_sym_LBRACE,
    ACTIONS(552), 1,
      sym_unknown_type,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(157), 1,
      sym_cardinality_expression,
    STATE(172), 1,
      sym_type_reference,
    STATE(152), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym_mapping_type,
    ACTIONS(550), 8,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [6932] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(554), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [6956] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(333), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(331), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [6982] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(347), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(349), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [7008] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(556), 18,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_def,
      anon_sym_RBRACE,
  [7032] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(317), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(315), 14,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [7058] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(558), 1,
      sym_identifier,
    ACTIONS(560), 17,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [7084] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(562), 1,
      sym_identifier,
    ACTIONS(564), 17,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [7110] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(566), 1,
      sym_identifier,
    ACTIONS(568), 17,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_identity,
      anon_sym_ref,
  [7136] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(570), 1,
      sym_identifier,
    ACTIONS(572), 17,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [7162] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(546), 1,
      anon_sym_LPAREN,
    ACTIONS(574), 1,
      anon_sym_LBRACE,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(171), 1,
      sym_function_cardinality_expression,
    STATE(297), 1,
      sym_function_type_reference,
    STATE(275), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym_mapping_type,
    ACTIONS(550), 8,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [7199] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(119), 1,
      anon_sym_LPAREN,
    ACTIONS(576), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(578), 12,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_u2205,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [7226] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(512), 1,
      anon_sym_as,
    STATE(167), 1,
      sym__rename_import,
    ACTIONS(580), 14,
      anon_sym_end,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [7252] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(68), 1,
      sym__has_type,
    ACTIONS(506), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
    ACTIONS(582), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(584), 9,
      anon_sym_RBRACK,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [7280] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(546), 1,
      anon_sym_LPAREN,
    ACTIONS(552), 1,
      sym_unknown_type,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(174), 1,
      sym_type_reference,
    STATE(152), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym_mapping_type,
    ACTIONS(550), 8,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [7314] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(576), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(578), 12,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_u2205,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [7338] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(586), 1,
      sym_identifier,
    ACTIONS(588), 15,
      anon_sym_end,
      anon_sym_import,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [7362] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(590), 1,
      sym_identifier,
    ACTIONS(592), 15,
      anon_sym_end,
      anon_sym_import,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [7386] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(596), 1,
      anon_sym_import,
    STATE(161), 2,
      sym_import_statement,
      aux_sym_module_body_repeat1,
    ACTIONS(594), 13,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [7412] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(599), 1,
      sym_identifier,
    ACTIONS(601), 15,
      anon_sym_end,
      anon_sym_import,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [7436] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(546), 1,
      anon_sym_LPAREN,
    ACTIONS(552), 1,
      sym_unknown_type,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(379), 1,
      sym_type_reference,
    STATE(152), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym_mapping_type,
    ACTIONS(550), 8,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [7470] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(512), 1,
      anon_sym_as,
    STATE(159), 1,
      sym__rename_import,
    ACTIONS(603), 14,
      anon_sym_end,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [7496] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(546), 1,
      anon_sym_LPAREN,
    ACTIONS(552), 1,
      sym_unknown_type,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(472), 1,
      sym_type_reference,
    STATE(152), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym_mapping_type,
    ACTIONS(550), 8,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [7530] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(605), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(607), 12,
      anon_sym_LBRACK,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [7554] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(609), 1,
      sym_identifier,
    ACTIONS(611), 15,
      anon_sym_end,
      anon_sym_import,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [7578] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(613), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(615), 12,
      anon_sym_LBRACK,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [7602] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(617), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(619), 12,
      anon_sym_LBRACK,
      anon_sym_u2205,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [7626] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(621), 1,
      sym_identifier,
    ACTIONS(623), 1,
      anon_sym_is,
    STATE(179), 1,
      sym_annotation_only_body,
    ACTIONS(625), 13,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_ref,
  [7654] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(546), 1,
      anon_sym_LPAREN,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(284), 1,
      sym_function_type_reference,
    STATE(275), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym_mapping_type,
    ACTIONS(550), 8,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [7685] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(627), 1,
      sym_identifier,
    ACTIONS(629), 14,
      anon_sym_is,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_ref,
  [7708] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(631), 1,
      sym_identifier,
    ACTIONS(633), 14,
      anon_sym_end,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_ref,
  [7731] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(635), 1,
      sym_identifier,
    ACTIONS(637), 14,
      anon_sym_is,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_ref,
  [7754] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(639), 14,
      anon_sym_end,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [7774] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(500), 1,
      anon_sym_LPAREN,
    ACTIONS(641), 1,
      anon_sym_EQ,
    STATE(71), 1,
      sym_actual_arguments,
    ACTIONS(643), 2,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
    ACTIONS(645), 2,
      sym_less_than,
      sym_greater_than,
    ACTIONS(647), 2,
      anon_sym_LT_EQ,
      anon_sym_u2264,
    ACTIONS(649), 2,
      anon_sym_GT_EQ,
      anon_sym_u2265,
    STATE(38), 3,
      sym_not_equal,
      sym_less_than_or_equal,
      sym_greater_than_or_equal,
  [7808] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(651), 14,
      anon_sym_end,
      anon_sym_import,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [7828] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(119), 1,
      anon_sym_LPAREN,
    ACTIONS(582), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(584), 9,
      anon_sym_RBRACK,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [7852] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(653), 1,
      sym_identifier,
    ACTIONS(655), 13,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
      anon_sym_ref,
  [7874] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(657), 1,
      anon_sym_is,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    STATE(229), 1,
      sym_type_class_body,
    ACTIONS(659), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [7900] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(301), 1,
      sym_identifier,
    ACTIONS(663), 1,
      sym_opaque,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(188), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym__data_type_base,
    ACTIONS(550), 8,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [7928] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(665), 1,
      anon_sym_is,
    STATE(242), 1,
      sym_dimension_body,
    ACTIONS(667), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [7951] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(669), 1,
      anon_sym_is,
    STATE(234), 1,
      sym_structure_body,
    ACTIONS(671), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [7974] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(582), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(584), 9,
      anon_sym_RBRACK,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [7995] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(201), 1,
      anon_sym_AT,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(673), 1,
      sym_identifier,
    ACTIONS(675), 1,
      anon_sym_end,
    ACTIONS(677), 1,
      anon_sym_ref,
    STATE(141), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(189), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(278), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(353), 2,
      sym_member_def,
      sym_property_ref,
  [8030] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(657), 1,
      anon_sym_is,
    STATE(221), 1,
      sym_type_class_body,
    ACTIONS(679), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8053] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(623), 1,
      anon_sym_is,
    STATE(205), 1,
      sym_annotation_only_body,
    ACTIONS(681), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8076] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(623), 1,
      anon_sym_is,
    STATE(240), 1,
      sym_annotation_only_body,
    ACTIONS(683), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8099] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(201), 1,
      anon_sym_AT,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(673), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_ref,
    ACTIONS(685), 1,
      anon_sym_end,
    STATE(96), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(141), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(295), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(353), 2,
      sym_member_def,
      sym_property_ref,
  [8134] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(689), 1,
      anon_sym_of,
    STATE(233), 1,
      sym_union_body,
    ACTIONS(687), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8157] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(301), 1,
      sym_identifier,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(187), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym__data_type_base,
    ACTIONS(550), 8,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [8182] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(691), 1,
      anon_sym_is,
    STATE(235), 1,
      sym_event_body,
    ACTIONS(693), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8205] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(697), 1,
      anon_sym_of,
    STATE(238), 1,
      sym_enum_body,
    ACTIONS(695), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8228] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(699), 1,
      anon_sym_is,
    STATE(239), 1,
      sym_entity_body,
    ACTIONS(701), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8251] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(201), 1,
      anon_sym_AT,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(703), 1,
      sym_identifier,
    ACTIONS(705), 1,
      anon_sym_end,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(326), 1,
      sym_identifier_reference,
    STATE(141), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(196), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(308), 2,
      sym_type_variant,
      aux_sym_union_body_repeat1,
  [8285] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(201), 1,
      anon_sym_AT,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(703), 1,
      sym_identifier,
    ACTIONS(707), 1,
      anon_sym_end,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(326), 1,
      sym_identifier_reference,
    STATE(96), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(141), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(302), 2,
      sym_type_variant,
      aux_sym_union_body_repeat1,
  [8319] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(233), 2,
      sym_less_than,
      sym_greater_than,
    ACTIONS(504), 2,
      anon_sym_in,
      anon_sym_def,
    ACTIONS(231), 8,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_LT_EQ,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
  [8341] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(709), 1,
      sym_identifier,
    ACTIONS(711), 10,
      anon_sym_LPAREN,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
      sym_unknown_type,
  [8360] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(713), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8377] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(715), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8394] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(717), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8411] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(719), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8428] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(721), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8445] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(723), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8462] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(725), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8479] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(727), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8496] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(729), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8513] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(731), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8530] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(733), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8547] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(735), 1,
      anon_sym_LPAREN,
    STATE(11), 1,
      sym__by_definition,
    STATE(153), 1,
      sym__has_type,
    STATE(319), 1,
      sym__function_type,
    STATE(343), 1,
      sym_function_signature,
    ACTIONS(737), 2,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
    ACTIONS(739), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
    STATE(407), 2,
      sym_function_def,
      sym_constant_def,
  [8578] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(741), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8595] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(743), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8612] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(745), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8629] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(747), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8646] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(749), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8663] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(751), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8680] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(753), 1,
      sym_identifier,
    ACTIONS(755), 10,
      anon_sym_LPAREN,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
      sym_unknown_type,
  [8699] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(757), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8716] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(759), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8733] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(761), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8750] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(763), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8767] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(765), 1,
      sym_identifier,
    ACTIONS(767), 1,
      anon_sym_LPAREN,
    STATE(336), 1,
      sym_sequence_ordering,
    STATE(392), 1,
      aux_sym_named_variable_set_repeat1,
    STATE(493), 1,
      sym_sequence_uniqueness,
    ACTIONS(769), 2,
      anon_sym_ordered,
      anon_sym_unordered,
    ACTIONS(771), 2,
      anon_sym_unique,
      anon_sym_nonunique,
    STATE(461), 2,
      sym_named_variable_set,
      sym_mapping_variable,
  [8798] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(773), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8815] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(765), 1,
      sym_identifier,
    ACTIONS(767), 1,
      anon_sym_LPAREN,
    STATE(336), 1,
      sym_sequence_ordering,
    STATE(392), 1,
      aux_sym_named_variable_set_repeat1,
    STATE(493), 1,
      sym_sequence_uniqueness,
    ACTIONS(769), 2,
      anon_sym_ordered,
      anon_sym_unordered,
    ACTIONS(771), 2,
      anon_sym_unique,
      anon_sym_nonunique,
    STATE(496), 2,
      sym_named_variable_set,
      sym_mapping_variable,
  [8846] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(775), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8863] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(777), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8880] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(779), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8897] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(781), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8914] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(783), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8931] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(785), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8948] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(787), 1,
      sym_identifier,
    ACTIONS(789), 10,
      anon_sym_LPAREN,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
      sym_unknown_type,
  [8967] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(791), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [8984] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(793), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [9001] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(795), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [9018] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(797), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [9035] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(799), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [9052] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(801), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [9069] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(803), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [9086] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(805), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [9103] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(807), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [9120] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(809), 1,
      sym_identifier,
    ACTIONS(811), 10,
      anon_sym_LPAREN,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
      sym_unknown_type,
  [9139] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(813), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [9156] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(815), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [9173] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(817), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [9190] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(819), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_structure,
      anon_sym_union,
      anon_sym_rdf,
      anon_sym_class,
  [9207] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(673), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_ref,
    ACTIONS(821), 1,
      anon_sym_end,
    ACTIONS(823), 1,
      anon_sym_parent,
    STATE(265), 2,
      sym_dimension_parent,
      aux_sym_dimension_body_repeat1,
    STATE(292), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(353), 2,
      sym_member_def,
      sym_property_ref,
  [9235] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(201), 1,
      anon_sym_AT,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(825), 1,
      anon_sym_source,
    ACTIONS(827), 1,
      anon_sym_identity,
    STATE(141), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(251), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(258), 2,
      sym_source_entity,
      sym_entity_identity,
  [9263] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    STATE(442), 1,
      sym_quantified_sentence,
    STATE(465), 1,
      sym_quantified_variable_binding,
    STATE(491), 1,
      sym_sequence_builder_body,
    ACTIONS(15), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(17), 2,
      anon_sym_exists,
      anon_sym_u2203,
    STATE(380), 2,
      sym_universal,
      sym_existential,
  [9291] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(673), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_ref,
    ACTIONS(823), 1,
      anon_sym_parent,
    ACTIONS(831), 1,
      anon_sym_end,
    STATE(286), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(301), 2,
      sym_dimension_parent,
      aux_sym_dimension_body_repeat1,
    STATE(353), 2,
      sym_member_def,
      sym_property_ref,
  [9319] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(833), 1,
      sym_identifier,
    ACTIONS(835), 9,
      anon_sym_LPAREN,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [9337] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(201), 1,
      anon_sym_AT,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(825), 1,
      anon_sym_source,
    ACTIONS(827), 1,
      anon_sym_identity,
    STATE(96), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(141), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(246), 2,
      sym_source_entity,
      sym_entity_identity,
  [9365] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(837), 1,
      sym_identifier,
    ACTIONS(839), 9,
      anon_sym_LPAREN,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [9383] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(201), 1,
      anon_sym_AT,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(841), 1,
      anon_sym_end,
    ACTIONS(843), 1,
      anon_sym_def,
    STATE(354), 1,
      aux_sym_type_class_body_repeat1,
    STATE(398), 1,
      sym_method_def,
    STATE(96), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(141), 2,
      sym_annotation_property,
      sym_constraint,
  [9413] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(845), 1,
      sym_identifier,
    ACTIONS(847), 9,
      anon_sym_LPAREN,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [9431] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(849), 1,
      sym_identifier,
    ACTIONS(851), 9,
      anon_sym_LPAREN,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [9449] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(853), 1,
      sym_identifier,
    ACTIONS(855), 9,
      anon_sym_LPAREN,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [9467] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    STATE(441), 1,
      sym_sequence_builder_body,
    STATE(442), 1,
      sym_quantified_sentence,
    STATE(465), 1,
      sym_quantified_variable_binding,
    ACTIONS(15), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(17), 2,
      anon_sym_exists,
      anon_sym_u2203,
    STATE(380), 2,
      sym_universal,
      sym_existential,
  [9495] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(673), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_ref,
    ACTIONS(823), 1,
      anon_sym_parent,
    ACTIONS(857), 1,
      anon_sym_end,
    STATE(249), 2,
      sym_dimension_parent,
      aux_sym_dimension_body_repeat1,
    STATE(291), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(353), 2,
      sym_member_def,
      sym_property_ref,
  [9523] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(201), 1,
      anon_sym_AT,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(859), 1,
      sym_identifier,
    ACTIONS(861), 1,
      anon_sym_end,
    STATE(141), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(261), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(355), 2,
      sym_value_variant,
      aux_sym_enum_body_repeat1,
  [9551] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(863), 1,
      sym_identifier,
    ACTIONS(865), 9,
      anon_sym_LPAREN,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [9569] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(201), 1,
      anon_sym_AT,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(859), 1,
      sym_identifier,
    ACTIONS(867), 1,
      anon_sym_end,
    STATE(96), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(141), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(334), 2,
      sym_value_variant,
      aux_sym_enum_body_repeat1,
  [9597] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(869), 1,
      sym_identifier,
    ACTIONS(871), 9,
      anon_sym_LPAREN,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [9615] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(873), 1,
      sym_identifier,
    ACTIONS(875), 9,
      anon_sym_LPAREN,
      anon_sym_boolean,
      anon_sym_unsigned,
      anon_sym_integer,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_string,
      anon_sym_iri,
      anon_sym_binary,
  [9633] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(201), 1,
      anon_sym_AT,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(843), 1,
      anon_sym_def,
    ACTIONS(877), 1,
      anon_sym_end,
    STATE(347), 1,
      aux_sym_type_class_body_repeat1,
    STATE(398), 1,
      sym_method_def,
    STATE(141), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(253), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
  [9663] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(673), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_ref,
    ACTIONS(823), 1,
      anon_sym_parent,
    ACTIONS(879), 1,
      anon_sym_end,
    STATE(293), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(301), 2,
      sym_dimension_parent,
      aux_sym_dimension_body_repeat1,
    STATE(353), 2,
      sym_member_def,
      sym_property_ref,
  [9691] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(881), 1,
      anon_sym_RBRACE,
    ACTIONS(883), 1,
      sym_unsigned,
    STATE(314), 1,
      sym_sequence_ordering,
    STATE(393), 1,
      sym_sequence_uniqueness,
    STATE(426), 1,
      sym__cardinality_inner,
    ACTIONS(769), 2,
      anon_sym_ordered,
      anon_sym_unordered,
    ACTIONS(771), 2,
      anon_sym_unique,
      anon_sym_nonunique,
  [9718] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(431), 1,
      sym_quantified_sentence,
    STATE(465), 1,
      sym_quantified_variable_binding,
    ACTIONS(15), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(17), 2,
      anon_sym_exists,
      anon_sym_u2203,
    STATE(380), 2,
      sym_universal,
      sym_existential,
  [9740] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(883), 1,
      sym_unsigned,
    STATE(322), 1,
      sym_sequence_ordering,
    STATE(409), 1,
      sym_sequence_uniqueness,
    STATE(450), 1,
      sym__cardinality_inner,
    ACTIONS(769), 2,
      anon_sym_ordered,
      anon_sym_unordered,
    ACTIONS(771), 2,
      anon_sym_unique,
      anon_sym_nonunique,
  [9764] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(201), 1,
      anon_sym_AT,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(825), 1,
      anon_sym_source,
    STATE(289), 1,
      sym_source_entity,
    STATE(141), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(270), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
  [9788] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(201), 1,
      anon_sym_AT,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(825), 1,
      anon_sym_source,
    STATE(283), 1,
      sym_source_entity,
    STATE(96), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(141), 2,
      sym_annotation_property,
      sym_constraint,
  [9812] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(623), 1,
      anon_sym_is,
    STATE(6), 1,
      sym__by_definition,
    STATE(364), 1,
      sym_function_body,
    STATE(412), 1,
      sym_annotation_only_body,
    ACTIONS(885), 2,
      anon_sym_end,
      anon_sym_def,
    ACTIONS(887), 2,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
  [9836] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(201), 1,
      anon_sym_AT,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(827), 1,
      anon_sym_identity,
    STATE(280), 1,
      sym_entity_identity,
    STATE(141), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(273), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
  [9860] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(201), 1,
      anon_sym_AT,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(827), 1,
      anon_sym_identity,
    STATE(277), 1,
      sym_entity_identity,
    STATE(96), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(141), 2,
      sym_annotation_property,
      sym_constraint,
  [9884] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(673), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_ref,
    ACTIONS(889), 1,
      anon_sym_end,
    STATE(296), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(353), 2,
      sym_member_def,
      sym_property_ref,
  [9905] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(891), 1,
      sym_identifier,
    ACTIONS(893), 6,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
  [9920] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(673), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_ref,
    ACTIONS(895), 1,
      anon_sym_end,
    STATE(296), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(353), 2,
      sym_member_def,
      sym_property_ref,
  [9941] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(673), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_ref,
    ACTIONS(897), 1,
      anon_sym_end,
    STATE(290), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(353), 2,
      sym_member_def,
      sym_property_ref,
  [9962] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(673), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_ref,
    ACTIONS(685), 1,
      anon_sym_end,
    STATE(296), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(353), 2,
      sym_member_def,
      sym_property_ref,
  [9983] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(201), 1,
      anon_sym_AT,
    ACTIONS(203), 1,
      anon_sym_assert,
    ACTIONS(899), 1,
      anon_sym_end,
    STATE(96), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(141), 2,
      sym_annotation_property,
      sym_constraint,
  [10004] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(673), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_ref,
    ACTIONS(901), 1,
      anon_sym_end,
    STATE(276), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(353), 2,
      sym_member_def,
      sym_property_ref,
  [10025] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(361), 1,
      sym__has_type,
    STATE(370), 1,
      sym__type_variable_restriction,
    ACTIONS(905), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
    ACTIONS(903), 3,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
  [10044] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(673), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_ref,
    ACTIONS(907), 1,
      anon_sym_end,
    STATE(296), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(353), 2,
      sym_member_def,
      sym_property_ref,
  [10065] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(673), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_ref,
    ACTIONS(909), 1,
      anon_sym_end,
    STATE(274), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(353), 2,
      sym_member_def,
      sym_property_ref,
  [10086] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(911), 1,
      sym_identifier,
    ACTIONS(913), 6,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
  [10101] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(915), 1,
      sym_identifier,
    ACTIONS(917), 1,
      anon_sym_RBRACK,
    STATE(344), 1,
      sym_qualified_identifier,
    STATE(294), 4,
      sym__import,
      sym_member_import,
      sym_module_import,
      aux_sym_import_statement_repeat1,
  [10120] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(673), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_ref,
    ACTIONS(919), 1,
      anon_sym_end,
    STATE(296), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(353), 2,
      sym_member_def,
      sym_property_ref,
  [10141] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(101), 1,
      anon_sym_LT,
    ACTIONS(483), 1,
      anon_sym_COLON,
    ACTIONS(510), 1,
      anon_sym_RBRACK,
    ACTIONS(921), 1,
      sym_identifier,
    ACTIONS(923), 1,
      anon_sym_as,
    STATE(162), 1,
      sym__rename_import,
    STATE(342), 1,
      sym_iri,
  [10166] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(361), 1,
      sym__has_type,
    STATE(375), 1,
      sym__type_variable_restriction,
    ACTIONS(905), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
    ACTIONS(925), 3,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
  [10185] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(673), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_ref,
    ACTIONS(927), 1,
      anon_sym_end,
    STATE(282), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(353), 2,
      sym_member_def,
      sym_property_ref,
  [10206] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(673), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_ref,
    ACTIONS(929), 1,
      anon_sym_end,
    STATE(296), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(353), 2,
      sym_member_def,
      sym_property_ref,
  [10227] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(673), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_ref,
    ACTIONS(831), 1,
      anon_sym_end,
    STATE(296), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(353), 2,
      sym_member_def,
      sym_property_ref,
  [10248] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(673), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_ref,
    ACTIONS(879), 1,
      anon_sym_end,
    STATE(296), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(353), 2,
      sym_member_def,
      sym_property_ref,
  [10269] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(673), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_ref,
    ACTIONS(931), 1,
      anon_sym_end,
    STATE(296), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(353), 2,
      sym_member_def,
      sym_property_ref,
  [10290] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(933), 1,
      sym_identifier,
    ACTIONS(936), 1,
      anon_sym_RBRACK,
    STATE(344), 1,
      sym_qualified_identifier,
    STATE(294), 4,
      sym__import,
      sym_member_import,
      sym_module_import,
      aux_sym_import_statement_repeat1,
  [10309] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(673), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_ref,
    ACTIONS(938), 1,
      anon_sym_end,
    STATE(296), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(353), 2,
      sym_member_def,
      sym_property_ref,
  [10330] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(940), 1,
      sym_identifier,
    ACTIONS(943), 1,
      anon_sym_end,
    ACTIONS(945), 1,
      anon_sym_ref,
    STATE(296), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(353), 2,
      sym_member_def,
      sym_property_ref,
  [10351] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(948), 1,
      sym_identifier,
    ACTIONS(950), 6,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
  [10366] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(952), 1,
      sym_identifier,
    ACTIONS(954), 1,
      sym_wildcard,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(307), 1,
      aux_sym_type_class_arguments_repeat1,
    STATE(312), 1,
      sym_identifier_reference,
    STATE(397), 1,
      sym_type_class_reference,
  [10388] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(623), 1,
      anon_sym_is,
    ACTIONS(956), 1,
      sym_identifier,
    STATE(349), 1,
      sym_annotation_only_body,
    ACTIONS(958), 3,
      anon_sym_end,
      anon_sym_parent,
      anon_sym_ref,
  [10406] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(336), 1,
      sym_sequence_ordering,
    STATE(493), 1,
      sym_sequence_uniqueness,
    ACTIONS(769), 2,
      anon_sym_ordered,
      anon_sym_unordered,
    ACTIONS(771), 2,
      anon_sym_unique,
      anon_sym_nonunique,
  [10424] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(960), 1,
      sym_identifier,
    ACTIONS(964), 1,
      anon_sym_parent,
    ACTIONS(962), 2,
      anon_sym_end,
      anon_sym_ref,
    STATE(301), 2,
      sym_dimension_parent,
      aux_sym_dimension_body_repeat1,
  [10442] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(703), 1,
      sym_identifier,
    ACTIONS(967), 1,
      anon_sym_end,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(326), 1,
      sym_identifier_reference,
    STATE(304), 2,
      sym_type_variant,
      aux_sym_union_body_repeat1,
  [10462] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(969), 1,
      sym_identifier,
    ACTIONS(972), 1,
      anon_sym_RPAREN,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(303), 1,
      aux_sym_type_class_arguments_repeat1,
    STATE(312), 1,
      sym_identifier_reference,
    STATE(397), 1,
      sym_type_class_reference,
  [10484] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(974), 1,
      sym_identifier,
    ACTIONS(977), 1,
      anon_sym_end,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(326), 1,
      sym_identifier_reference,
    STATE(304), 2,
      sym_type_variant,
      aux_sym_union_body_repeat1,
  [10504] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(979), 1,
      sym_identifier,
    ACTIONS(982), 1,
      anon_sym_RPAREN,
    ACTIONS(984), 1,
      anon_sym_LBRACE,
    STATE(305), 1,
      aux_sym_type_class_def_repeat1,
    STATE(382), 1,
      sym_type_variable,
    STATE(451), 1,
      sym_function_cardinality_expression,
  [10526] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(574), 1,
      anon_sym_LBRACE,
    ACTIONS(987), 1,
      sym_identifier,
    ACTIONS(989), 1,
      anon_sym_RPAREN,
    STATE(305), 1,
      aux_sym_type_class_def_repeat1,
    STATE(382), 1,
      sym_type_variable,
    STATE(451), 1,
      sym_function_cardinality_expression,
  [10548] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(952), 1,
      sym_identifier,
    ACTIONS(991), 1,
      anon_sym_RPAREN,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(303), 1,
      aux_sym_type_class_arguments_repeat1,
    STATE(312), 1,
      sym_identifier_reference,
    STATE(397), 1,
      sym_type_class_reference,
  [10570] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(703), 1,
      sym_identifier,
    ACTIONS(707), 1,
      anon_sym_end,
    STATE(95), 1,
      sym_qualified_identifier,
    STATE(326), 1,
      sym_identifier_reference,
    STATE(304), 2,
      sym_type_variant,
      aux_sym_union_body_repeat1,
  [10590] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(735), 1,
      anon_sym_LPAREN,
    STATE(153), 1,
      sym__has_type,
    STATE(271), 1,
      sym_function_signature,
    STATE(319), 1,
      sym__function_type,
    ACTIONS(739), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [10610] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(993), 1,
      sym_identifier,
    ACTIONS(995), 1,
      anon_sym_LBRACK,
    STATE(155), 1,
      sym_qualified_identifier,
    STATE(177), 3,
      sym__import,
      sym_member_import,
      sym_module_import,
  [10628] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(915), 1,
      sym_identifier,
    STATE(344), 1,
      sym_qualified_identifier,
    STATE(285), 4,
      sym__import,
      sym_member_import,
      sym_module_import,
      aux_sym_import_statement_repeat1,
  [10644] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    STATE(366), 1,
      sym_type_class_arguments,
    ACTIONS(997), 4,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_PLUS,
  [10660] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(201), 1,
      anon_sym_AT,
    ACTIONS(203), 1,
      anon_sym_assert,
    STATE(141), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(279), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
  [10678] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(883), 1,
      sym_unsigned,
    ACTIONS(1001), 1,
      anon_sym_RBRACE,
    STATE(373), 1,
      sym_sequence_uniqueness,
    STATE(437), 1,
      sym__cardinality_inner,
    ACTIONS(771), 2,
      anon_sym_unique,
      anon_sym_nonunique,
  [10698] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1003), 5,
      anon_sym_is,
      anon_sym_end,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
  [10709] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1005), 1,
      sym_identifier,
    ACTIONS(1008), 1,
      anon_sym_RBRACK,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(316), 1,
      aux_sym_rdf_types_repeat1,
    STATE(421), 1,
      sym_identifier_reference,
  [10728] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(574), 1,
      anon_sym_LBRACE,
    ACTIONS(987), 1,
      sym_identifier,
    STATE(306), 1,
      aux_sym_type_class_def_repeat1,
    STATE(382), 1,
      sym_type_variable,
    STATE(451), 1,
      sym_function_cardinality_expression,
  [10747] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1012), 1,
      anon_sym_PLUS,
    STATE(325), 1,
      aux_sym__type_variable_restriction_repeat1,
    ACTIONS(1010), 3,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
  [10762] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1014), 5,
      anon_sym_is,
      anon_sym_end,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
  [10773] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(1016), 1,
      anon_sym_is,
    STATE(401), 1,
      sym__module_locations,
    STATE(402), 1,
      sym_iri,
    STATE(488), 1,
      sym_module_body,
  [10792] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(673), 1,
      sym_identifier,
    ACTIONS(677), 1,
      anon_sym_ref,
    STATE(352), 1,
      sym_member,
    STATE(353), 2,
      sym_member_def,
      sym_property_ref,
  [10809] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(883), 1,
      sym_unsigned,
    STATE(419), 1,
      sym_sequence_uniqueness,
    STATE(429), 1,
      sym__cardinality_inner,
    ACTIONS(771), 2,
      anon_sym_unique,
      anon_sym_nonunique,
  [10826] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(952), 1,
      sym_identifier,
    ACTIONS(1018), 1,
      anon_sym_RBRACK,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(324), 1,
      aux_sym_rdf_types_repeat1,
    STATE(421), 1,
      sym_identifier_reference,
  [10845] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(952), 1,
      sym_identifier,
    ACTIONS(1020), 1,
      anon_sym_RBRACK,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(316), 1,
      aux_sym_rdf_types_repeat1,
    STATE(421), 1,
      sym_identifier_reference,
  [10864] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1012), 1,
      anon_sym_PLUS,
    STATE(330), 1,
      aux_sym__type_variable_restriction_repeat1,
    ACTIONS(1022), 3,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
  [10879] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(623), 1,
      anon_sym_is,
    ACTIONS(1024), 1,
      sym_identifier,
    ACTIONS(1026), 1,
      anon_sym_end,
    ACTIONS(1028), 1,
      anon_sym_as,
    STATE(423), 1,
      sym_annotation_only_body,
  [10898] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(45), 1,
      sym_identifier,
    ACTIONS(483), 1,
      anon_sym_COLON,
    ACTIONS(47), 3,
      anon_sym_is,
      anon_sym_end,
      anon_sym_as,
  [10913] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      anon_sym_def,
    ACTIONS(1030), 1,
      anon_sym_in,
    STATE(87), 1,
      sym_constraint_environment_end,
    STATE(351), 2,
      sym_environment_def,
      aux_sym_constraint_environment_repeat1,
  [10930] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1032), 5,
      anon_sym_is,
      anon_sym_end,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
  [10941] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1036), 1,
      anon_sym_PLUS,
    STATE(330), 1,
      aux_sym__type_variable_restriction_repeat1,
    ACTIONS(1034), 3,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
  [10956] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1039), 1,
      sym_identifier,
    ACTIONS(1043), 1,
      anon_sym_with,
    ACTIONS(1041), 3,
      anon_sym_end,
      anon_sym_parent,
      anon_sym_ref,
  [10971] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1034), 4,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_PLUS,
  [10981] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(153), 1,
      sym__has_type,
    STATE(417), 1,
      sym__function_type,
    ACTIONS(739), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [10995] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(859), 1,
      sym_identifier,
    ACTIONS(1045), 1,
      anon_sym_end,
    STATE(335), 2,
      sym_value_variant,
      aux_sym_enum_body_repeat1,
  [11009] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1047), 1,
      sym_identifier,
    ACTIONS(1050), 1,
      anon_sym_end,
    STATE(335), 2,
      sym_value_variant,
      aux_sym_enum_body_repeat1,
  [11023] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1052), 1,
      anon_sym_RBRACE,
    STATE(487), 1,
      sym_sequence_uniqueness,
    ACTIONS(771), 2,
      anon_sym_unique,
      anon_sym_nonunique,
  [11037] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1054), 1,
      anon_sym_is,
    ACTIONS(1056), 1,
      anon_sym_EQ,
    STATE(138), 2,
      sym_informal_constraint,
      sym_formal_constraint,
  [11051] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1058), 4,
      anon_sym_RBRACE,
      sym_unsigned,
      anon_sym_unique,
      anon_sym_nonunique,
  [11061] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(143), 1,
      sym__has_type,
    STATE(170), 1,
      sym__type_expression_to,
    ACTIONS(1060), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [11075] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1062), 1,
      sym_identifier,
    ACTIONS(1064), 1,
      anon_sym_RPAREN,
    STATE(365), 1,
      aux_sym_function_signature_repeat1,
    STATE(404), 1,
      sym_function_parameter,
  [11091] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(623), 1,
      anon_sym_is,
    ACTIONS(1066), 1,
      anon_sym_type,
    STATE(232), 1,
      sym_annotation_only_body,
    STATE(420), 1,
      sym_rdf_types,
  [11107] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(603), 1,
      anon_sym_RBRACK,
    ACTIONS(923), 1,
      anon_sym_as,
    ACTIONS(1068), 1,
      sym_identifier,
    STATE(159), 1,
      sym__rename_import,
  [11123] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(6), 1,
      sym__by_definition,
    STATE(406), 1,
      sym_function_body,
    ACTIONS(887), 2,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
  [11137] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(580), 1,
      anon_sym_RBRACK,
    ACTIONS(923), 1,
      anon_sym_as,
    ACTIONS(1070), 1,
      sym_identifier,
    STATE(167), 1,
      sym__rename_import,
  [11153] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1072), 1,
      sym_identifier,
    ACTIONS(1074), 3,
      anon_sym_end,
      anon_sym_parent,
      anon_sym_ref,
  [11165] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1076), 4,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_PLUS,
  [11175] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(843), 1,
      anon_sym_def,
    ACTIONS(1078), 1,
      anon_sym_end,
    STATE(358), 1,
      aux_sym_type_class_body_repeat1,
    STATE(398), 1,
      sym_method_def,
  [11191] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1080), 4,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_PLUS,
  [11201] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1082), 1,
      sym_identifier,
    ACTIONS(1084), 3,
      anon_sym_end,
      anon_sym_parent,
      anon_sym_ref,
  [11213] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1086), 1,
      sym_identifier,
    ACTIONS(1088), 3,
      anon_sym_end,
      anon_sym_parent,
      anon_sym_ref,
  [11225] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 1,
      anon_sym_in,
    ACTIONS(1092), 1,
      anon_sym_def,
    STATE(351), 2,
      sym_environment_def,
      aux_sym_constraint_environment_repeat1,
  [11239] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1095), 1,
      sym_identifier,
    ACTIONS(1097), 3,
      anon_sym_end,
      anon_sym_parent,
      anon_sym_ref,
  [11251] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1099), 1,
      sym_identifier,
    ACTIONS(1101), 3,
      anon_sym_end,
      anon_sym_parent,
      anon_sym_ref,
  [11263] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(843), 1,
      anon_sym_def,
    ACTIONS(1103), 1,
      anon_sym_end,
    STATE(358), 1,
      aux_sym_type_class_body_repeat1,
    STATE(398), 1,
      sym_method_def,
  [11279] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(859), 1,
      sym_identifier,
    ACTIONS(867), 1,
      anon_sym_end,
    STATE(335), 2,
      sym_value_variant,
      aux_sym_enum_body_repeat1,
  [11293] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(623), 1,
      anon_sym_is,
    ACTIONS(1105), 1,
      sym_identifier,
    ACTIONS(1107), 1,
      anon_sym_end,
    STATE(399), 1,
      sym_annotation_only_body,
  [11309] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(952), 1,
      sym_identifier,
    ACTIONS(1109), 1,
      anon_sym_LBRACK,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(443), 1,
      sym_identifier_reference,
  [11325] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1111), 1,
      anon_sym_end,
    ACTIONS(1113), 1,
      anon_sym_def,
    STATE(358), 1,
      aux_sym_type_class_body_repeat1,
    STATE(398), 1,
      sym_method_def,
  [11341] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1116), 1,
      sym_identifier,
    ACTIONS(1119), 1,
      anon_sym_RPAREN,
    STATE(359), 1,
      aux_sym_function_signature_repeat1,
    STATE(404), 1,
      sym_function_parameter,
  [11357] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(153), 1,
      sym__has_type,
    STATE(329), 1,
      sym__function_type,
    ACTIONS(739), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [11371] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(952), 1,
      sym_identifier,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(312), 1,
      sym_identifier_reference,
    STATE(318), 1,
      sym_type_class_reference,
  [11387] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(623), 1,
      anon_sym_is,
    ACTIONS(1121), 1,
      sym_identifier,
    ACTIONS(1123), 1,
      anon_sym_end,
    STATE(411), 1,
      sym_annotation_only_body,
  [11403] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(153), 1,
      sym__has_type,
    STATE(315), 1,
      sym__function_type,
    ACTIONS(739), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [11417] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(623), 1,
      anon_sym_is,
    STATE(422), 1,
      sym_annotation_only_body,
    ACTIONS(1125), 2,
      anon_sym_end,
      anon_sym_def,
  [11431] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1062), 1,
      sym_identifier,
    ACTIONS(1127), 1,
      anon_sym_RPAREN,
    STATE(359), 1,
      aux_sym_function_signature_repeat1,
    STATE(404), 1,
      sym_function_parameter,
  [11447] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1129), 4,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_PLUS,
  [11457] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(952), 1,
      sym_identifier,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(312), 1,
      sym_identifier_reference,
    STATE(332), 1,
      sym_type_class_reference,
  [11473] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1131), 1,
      sym_identifier,
    ACTIONS(1133), 3,
      anon_sym_end,
      anon_sym_parent,
      anon_sym_ref,
  [11485] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1135), 1,
      sym_identifier,
    ACTIONS(1137), 3,
      anon_sym_end,
      anon_sym_parent,
      anon_sym_ref,
  [11497] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1139), 3,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
  [11506] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1141), 1,
      sym_identifier,
    ACTIONS(1143), 1,
      anon_sym_RBRACK,
    STATE(386), 1,
      aux_sym__identifier_or_list_repeat1,
  [11519] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1145), 1,
      anon_sym_RBRACK,
    ACTIONS(1147), 1,
      sym_hex_byte,
    STATE(387), 1,
      aux_sym_binary_repeat1,
  [11532] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(883), 1,
      sym_unsigned,
    ACTIONS(1149), 1,
      anon_sym_RBRACE,
    STATE(427), 1,
      sym__cardinality_inner,
  [11545] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(952), 1,
      sym_identifier,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(463), 1,
      sym_identifier_reference,
  [11558] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1151), 3,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
  [11567] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1147), 1,
      sym_hex_byte,
    ACTIONS(1153), 1,
      anon_sym_RBRACK,
    STATE(372), 1,
      aux_sym_binary_repeat1,
  [11580] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(952), 1,
      sym_identifier,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(331), 1,
      sym_identifier_reference,
  [11593] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(29), 1,
      anon_sym_LT,
    ACTIONS(1155), 1,
      sym_quoted_string,
    STATE(456), 1,
      sym_iri,
  [11606] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(165), 1,
      sym__has_type,
    ACTIONS(1157), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [11617] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1159), 1,
      sym_identifier,
    ACTIONS(1161), 1,
      sym_reserved_self,
    STATE(438), 1,
      sym_quantified_variable,
  [11630] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(181), 1,
      sym__type_restriction,
    ACTIONS(1163), 2,
      anon_sym_u2190,
      anon_sym_LT_DASH,
  [11641] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1165), 3,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
  [11650] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1167), 1,
      anon_sym_RBRACE,
    ACTIONS(1169), 1,
      anon_sym_DOT_DOT,
    STATE(432), 1,
      sym_cardinality_range,
  [11663] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(446), 1,
      sym__has_type,
    ACTIONS(1171), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [11674] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1173), 1,
      sym_identifier,
    ACTIONS(1176), 1,
      anon_sym_PIPE,
    STATE(385), 1,
      aux_sym_named_variable_set_repeat1,
  [11687] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1178), 1,
      sym_identifier,
    ACTIONS(1181), 1,
      anon_sym_RBRACK,
    STATE(386), 1,
      aux_sym__identifier_or_list_repeat1,
  [11700] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1183), 1,
      anon_sym_RBRACK,
    ACTIONS(1185), 1,
      sym_hex_byte,
    STATE(387), 1,
      aux_sym_binary_repeat1,
  [11713] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1188), 1,
      sym_identifier,
    ACTIONS(1190), 1,
      anon_sym_LBRACK,
    STATE(369), 1,
      sym__identifier_or_list,
  [11726] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(396), 1,
      sym__has_type,
    ACTIONS(1192), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [11737] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(500), 1,
      anon_sym_LPAREN,
    ACTIONS(1194), 1,
      anon_sym_COMMA,
    STATE(110), 1,
      sym_actual_arguments,
  [11750] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(952), 1,
      sym_identifier,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(345), 1,
      sym_identifier_reference,
  [11763] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1196), 1,
      sym_identifier,
    ACTIONS(1198), 1,
      anon_sym_PIPE,
    STATE(385), 1,
      aux_sym_named_variable_set_repeat1,
  [11776] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(883), 1,
      sym_unsigned,
    ACTIONS(1200), 1,
      anon_sym_RBRACE,
    STATE(484), 1,
      sym__cardinality_inner,
  [11789] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1147), 1,
      sym_hex_byte,
    ACTIONS(1202), 1,
      anon_sym_RBRACK,
    STATE(395), 1,
      aux_sym_binary_repeat1,
  [11802] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1147), 1,
      sym_hex_byte,
    ACTIONS(1204), 1,
      anon_sym_RBRACK,
    STATE(387), 1,
      aux_sym_binary_repeat1,
  [11815] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(952), 1,
      sym_identifier,
    STATE(4), 1,
      sym_qualified_identifier,
    STATE(299), 1,
      sym_identifier_reference,
  [11828] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1206), 2,
      sym_identifier,
      anon_sym_RPAREN,
  [11836] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1208), 2,
      anon_sym_end,
      anon_sym_def,
  [11844] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1210), 1,
      sym_identifier,
    ACTIONS(1212), 1,
      anon_sym_end,
  [11854] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1141), 1,
      sym_identifier,
    STATE(371), 1,
      aux_sym__identifier_or_list_repeat1,
  [11864] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1016), 1,
      anon_sym_is,
    STATE(466), 1,
      sym_module_body,
  [11874] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1214), 1,
      anon_sym_version,
    ACTIONS(1216), 1,
      anon_sym_is,
  [11884] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1218), 2,
      anon_sym_RBRACE,
      sym_unsigned,
  [11892] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1220), 2,
      sym_identifier,
      anon_sym_RPAREN,
  [11900] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1222), 1,
      sym_identifier,
    STATE(212), 1,
      sym_member_def,
  [11910] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1224), 2,
      anon_sym_in,
      anon_sym_def,
  [11918] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1226), 2,
      anon_sym_in,
      anon_sym_def,
  [11926] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(29), 1,
      anon_sym_LT,
    STATE(483), 1,
      sym_iri,
  [11936] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(883), 1,
      sym_unsigned,
    STATE(428), 1,
      sym__cardinality_inner,
  [11946] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1228), 1,
      sym_identifier,
    ACTIONS(1230), 1,
      sym_reserved_self,
  [11956] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1232), 1,
      sym_identifier,
    ACTIONS(1234), 1,
      anon_sym_end,
  [11966] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1236), 2,
      anon_sym_end,
      anon_sym_def,
  [11974] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1238), 2,
      anon_sym_RBRACK,
      sym_identifier,
  [11982] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1240), 2,
      anon_sym_in,
      anon_sym_u2208,
  [11990] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1242), 1,
      anon_sym_RBRACE,
    ACTIONS(1244), 1,
      sym_unsigned,
  [12000] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1246), 2,
      anon_sym_RBRACK,
      sym_hex_byte,
  [12008] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1248), 2,
      sym_identifier,
      anon_sym_RPAREN,
  [12016] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1250), 1,
      sym_identifier,
    ACTIONS(1252), 1,
      sym_reserved_self,
  [12026] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(883), 1,
      sym_unsigned,
    STATE(457), 1,
      sym__cardinality_inner,
  [12036] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(623), 1,
      anon_sym_is,
    STATE(207), 1,
      sym_annotation_only_body,
  [12046] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1254), 2,
      anon_sym_RBRACK,
      sym_identifier,
  [12054] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1256), 2,
      anon_sym_end,
      anon_sym_def,
  [12062] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1258), 1,
      sym_identifier,
    ACTIONS(1260), 1,
      anon_sym_end,
  [12072] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1262), 1,
      anon_sym_RPAREN,
  [12079] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1264), 1,
      sym_identifier,
  [12086] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1266), 1,
      anon_sym_RBRACE,
  [12093] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1268), 1,
      anon_sym_RBRACE,
  [12100] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1270), 1,
      anon_sym_RBRACE,
  [12107] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1272), 1,
      anon_sym_RBRACE,
  [12114] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1274), 1,
      anon_sym_RPAREN,
  [12121] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1276), 1,
      anon_sym_RPAREN,
  [12128] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1278), 1,
      anon_sym_RBRACE,
  [12135] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1280), 1,
      anon_sym_COMMA,
  [12142] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1282), 1,
      anon_sym_RPAREN,
  [12149] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1284), 1,
      anon_sym_is,
  [12156] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1286), 1,
      anon_sym_is,
  [12163] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1288), 1,
      anon_sym_RBRACE,
  [12170] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1290), 1,
      anon_sym_COMMA,
  [12177] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1292), 1,
      anon_sym_PIPE,
  [12184] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1294), 1,
      anon_sym_RBRACE,
  [12191] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1296), 1,
      anon_sym_RBRACE,
  [12198] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1298), 1,
      anon_sym_RBRACE,
  [12205] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1300), 1,
      anon_sym_is,
  [12212] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1302), 1,
      sym_identifier,
  [12219] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1304), 1,
      sym_identifier,
  [12226] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1306), 1,
      sym_identifier,
  [12233] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1308), 1,
      anon_sym_LBRACK,
  [12240] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1310), 1,
      anon_sym_LBRACK,
  [12247] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1312), 1,
      sym_identifier,
  [12254] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1314), 1,
      anon_sym_RBRACE,
  [12261] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1316), 1,
      sym_identifier,
  [12268] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1318), 1,
      sym_quoted_string,
  [12275] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1320), 1,
      sym_identifier,
  [12282] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1322), 1,
      sym_identifier,
  [12289] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1324), 1,
      sym_identifier,
  [12296] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1326), 1,
      anon_sym_is,
  [12303] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1328), 1,
      anon_sym_RBRACE,
  [12310] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1330), 1,
      ts_builtin_sym_end,
  [12317] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1332), 1,
      sym_identifier,
  [12324] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1334), 1,
      anon_sym_LBRACK,
  [12331] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1336), 1,
      anon_sym_PIPE,
  [12338] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1338), 1,
      ts_builtin_sym_end,
  [12345] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1340), 1,
      anon_sym_EQ,
  [12352] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1342), 1,
      anon_sym_RBRACE,
  [12359] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1344), 1,
      anon_sym_COMMA,
  [12366] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1346), 1,
      ts_builtin_sym_end,
  [12373] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1348), 1,
      anon_sym_GT,
  [12380] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1350), 1,
      sym_identifier,
  [12387] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1352), 1,
      sym_identifier,
  [12394] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1354), 1,
      sym_identifier,
  [12401] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1356), 1,
      sym_identifier,
  [12408] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1358), 1,
      anon_sym_RPAREN,
  [12415] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1360), 1,
      sym_identifier,
  [12422] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1362), 1,
      sym_identifier,
  [12429] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1364), 1,
      sym_identifier,
  [12436] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1366), 1,
      sym_identifier,
  [12443] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1368), 1,
      sym_identifier,
  [12450] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1370), 1,
      sym_identifier,
  [12457] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1372), 1,
      anon_sym_GT,
  [12464] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1374), 1,
      sym_identifier,
  [12471] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1376), 1,
      ts_builtin_sym_end,
  [12478] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1378), 1,
      anon_sym_LBRACK,
  [12485] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1380), 1,
      anon_sym_is,
  [12492] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1382), 1,
      anon_sym_RBRACE,
  [12499] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1384), 1,
      ts_builtin_sym_end,
  [12506] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1386), 1,
      sym_identifier,
  [12513] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1388), 1,
      anon_sym_RBRACE,
  [12520] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1390), 1,
      ts_builtin_sym_end,
  [12527] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1392), 1,
      anon_sym_LBRACK,
  [12534] = 2,
    ACTIONS(1394), 1,
      aux_sym_iri_token1,
    ACTIONS(1396), 1,
      sym_line_comment,
  [12541] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1398), 1,
      anon_sym_RBRACE,
  [12548] = 2,
    ACTIONS(1396), 1,
      sym_line_comment,
    ACTIONS(1400), 1,
      aux_sym_iri_token1,
  [12555] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1402), 1,
      anon_sym_RBRACE,
  [12562] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1404), 1,
      anon_sym_LBRACK,
  [12569] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1406), 1,
      sym_identifier,
  [12576] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1408), 1,
      anon_sym_PIPE,
  [12583] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1410), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 130,
  [SMALL_STATE(4)] = 194,
  [SMALL_STATE(5)] = 256,
  [SMALL_STATE(6)] = 376,
  [SMALL_STATE(7)] = 496,
  [SMALL_STATE(8)] = 616,
  [SMALL_STATE(9)] = 736,
  [SMALL_STATE(10)] = 856,
  [SMALL_STATE(11)] = 976,
  [SMALL_STATE(12)] = 1098,
  [SMALL_STATE(13)] = 1156,
  [SMALL_STATE(14)] = 1214,
  [SMALL_STATE(15)] = 1269,
  [SMALL_STATE(16)] = 1324,
  [SMALL_STATE(17)] = 1379,
  [SMALL_STATE(18)] = 1434,
  [SMALL_STATE(19)] = 1489,
  [SMALL_STATE(20)] = 1544,
  [SMALL_STATE(21)] = 1599,
  [SMALL_STATE(22)] = 1679,
  [SMALL_STATE(23)] = 1759,
  [SMALL_STATE(24)] = 1803,
  [SMALL_STATE(25)] = 1883,
  [SMALL_STATE(26)] = 1963,
  [SMALL_STATE(27)] = 2043,
  [SMALL_STATE(28)] = 2084,
  [SMALL_STATE(29)] = 2125,
  [SMALL_STATE(30)] = 2166,
  [SMALL_STATE(31)] = 2207,
  [SMALL_STATE(32)] = 2248,
  [SMALL_STATE(33)] = 2289,
  [SMALL_STATE(34)] = 2330,
  [SMALL_STATE(35)] = 2371,
  [SMALL_STATE(36)] = 2445,
  [SMALL_STATE(37)] = 2487,
  [SMALL_STATE(38)] = 2561,
  [SMALL_STATE(39)] = 2635,
  [SMALL_STATE(40)] = 2681,
  [SMALL_STATE(41)] = 2755,
  [SMALL_STATE(42)] = 2829,
  [SMALL_STATE(43)] = 2872,
  [SMALL_STATE(44)] = 2915,
  [SMALL_STATE(45)] = 2958,
  [SMALL_STATE(46)] = 3035,
  [SMALL_STATE(47)] = 3112,
  [SMALL_STATE(48)] = 3189,
  [SMALL_STATE(49)] = 3266,
  [SMALL_STATE(50)] = 3343,
  [SMALL_STATE(51)] = 3420,
  [SMALL_STATE(52)] = 3497,
  [SMALL_STATE(53)] = 3574,
  [SMALL_STATE(54)] = 3617,
  [SMALL_STATE(55)] = 3694,
  [SMALL_STATE(56)] = 3732,
  [SMALL_STATE(57)] = 3803,
  [SMALL_STATE(58)] = 3840,
  [SMALL_STATE(59)] = 3877,
  [SMALL_STATE(60)] = 3914,
  [SMALL_STATE(61)] = 3951,
  [SMALL_STATE(62)] = 3988,
  [SMALL_STATE(63)] = 4025,
  [SMALL_STATE(64)] = 4062,
  [SMALL_STATE(65)] = 4129,
  [SMALL_STATE(66)] = 4166,
  [SMALL_STATE(67)] = 4233,
  [SMALL_STATE(68)] = 4270,
  [SMALL_STATE(69)] = 4341,
  [SMALL_STATE(70)] = 4378,
  [SMALL_STATE(71)] = 4449,
  [SMALL_STATE(72)] = 4487,
  [SMALL_STATE(73)] = 4548,
  [SMALL_STATE(74)] = 4609,
  [SMALL_STATE(75)] = 4670,
  [SMALL_STATE(76)] = 4731,
  [SMALL_STATE(77)] = 4792,
  [SMALL_STATE(78)] = 4824,
  [SMALL_STATE(79)] = 4856,
  [SMALL_STATE(80)] = 4898,
  [SMALL_STATE(81)] = 4951,
  [SMALL_STATE(82)] = 4982,
  [SMALL_STATE(83)] = 5013,
  [SMALL_STATE(84)] = 5044,
  [SMALL_STATE(85)] = 5075,
  [SMALL_STATE(86)] = 5128,
  [SMALL_STATE(87)] = 5159,
  [SMALL_STATE(88)] = 5190,
  [SMALL_STATE(89)] = 5221,
  [SMALL_STATE(90)] = 5252,
  [SMALL_STATE(91)] = 5305,
  [SMALL_STATE(92)] = 5358,
  [SMALL_STATE(93)] = 5390,
  [SMALL_STATE(94)] = 5420,
  [SMALL_STATE(95)] = 5450,
  [SMALL_STATE(96)] = 5480,
  [SMALL_STATE(97)] = 5518,
  [SMALL_STATE(98)] = 5558,
  [SMALL_STATE(99)] = 5591,
  [SMALL_STATE(100)] = 5626,
  [SMALL_STATE(101)] = 5655,
  [SMALL_STATE(102)] = 5684,
  [SMALL_STATE(103)] = 5713,
  [SMALL_STATE(104)] = 5742,
  [SMALL_STATE(105)] = 5771,
  [SMALL_STATE(106)] = 5800,
  [SMALL_STATE(107)] = 5829,
  [SMALL_STATE(108)] = 5858,
  [SMALL_STATE(109)] = 5887,
  [SMALL_STATE(110)] = 5919,
  [SMALL_STATE(111)] = 5945,
  [SMALL_STATE(112)] = 5975,
  [SMALL_STATE(113)] = 6005,
  [SMALL_STATE(114)] = 6043,
  [SMALL_STATE(115)] = 6075,
  [SMALL_STATE(116)] = 6107,
  [SMALL_STATE(117)] = 6139,
  [SMALL_STATE(118)] = 6170,
  [SMALL_STATE(119)] = 6197,
  [SMALL_STATE(120)] = 6234,
  [SMALL_STATE(121)] = 6261,
  [SMALL_STATE(122)] = 6288,
  [SMALL_STATE(123)] = 6323,
  [SMALL_STATE(124)] = 6354,
  [SMALL_STATE(125)] = 6381,
  [SMALL_STATE(126)] = 6418,
  [SMALL_STATE(127)] = 6445,
  [SMALL_STATE(128)] = 6476,
  [SMALL_STATE(129)] = 6513,
  [SMALL_STATE(130)] = 6540,
  [SMALL_STATE(131)] = 6569,
  [SMALL_STATE(132)] = 6596,
  [SMALL_STATE(133)] = 6620,
  [SMALL_STATE(134)] = 6646,
  [SMALL_STATE(135)] = 6674,
  [SMALL_STATE(136)] = 6698,
  [SMALL_STATE(137)] = 6722,
  [SMALL_STATE(138)] = 6764,
  [SMALL_STATE(139)] = 6790,
  [SMALL_STATE(140)] = 6816,
  [SMALL_STATE(141)] = 6840,
  [SMALL_STATE(142)] = 6866,
  [SMALL_STATE(143)] = 6892,
  [SMALL_STATE(144)] = 6932,
  [SMALL_STATE(145)] = 6956,
  [SMALL_STATE(146)] = 6982,
  [SMALL_STATE(147)] = 7008,
  [SMALL_STATE(148)] = 7032,
  [SMALL_STATE(149)] = 7058,
  [SMALL_STATE(150)] = 7084,
  [SMALL_STATE(151)] = 7110,
  [SMALL_STATE(152)] = 7136,
  [SMALL_STATE(153)] = 7162,
  [SMALL_STATE(154)] = 7199,
  [SMALL_STATE(155)] = 7226,
  [SMALL_STATE(156)] = 7252,
  [SMALL_STATE(157)] = 7280,
  [SMALL_STATE(158)] = 7314,
  [SMALL_STATE(159)] = 7338,
  [SMALL_STATE(160)] = 7362,
  [SMALL_STATE(161)] = 7386,
  [SMALL_STATE(162)] = 7412,
  [SMALL_STATE(163)] = 7436,
  [SMALL_STATE(164)] = 7470,
  [SMALL_STATE(165)] = 7496,
  [SMALL_STATE(166)] = 7530,
  [SMALL_STATE(167)] = 7554,
  [SMALL_STATE(168)] = 7578,
  [SMALL_STATE(169)] = 7602,
  [SMALL_STATE(170)] = 7626,
  [SMALL_STATE(171)] = 7654,
  [SMALL_STATE(172)] = 7685,
  [SMALL_STATE(173)] = 7708,
  [SMALL_STATE(174)] = 7731,
  [SMALL_STATE(175)] = 7754,
  [SMALL_STATE(176)] = 7774,
  [SMALL_STATE(177)] = 7808,
  [SMALL_STATE(178)] = 7828,
  [SMALL_STATE(179)] = 7852,
  [SMALL_STATE(180)] = 7874,
  [SMALL_STATE(181)] = 7900,
  [SMALL_STATE(182)] = 7928,
  [SMALL_STATE(183)] = 7951,
  [SMALL_STATE(184)] = 7974,
  [SMALL_STATE(185)] = 7995,
  [SMALL_STATE(186)] = 8030,
  [SMALL_STATE(187)] = 8053,
  [SMALL_STATE(188)] = 8076,
  [SMALL_STATE(189)] = 8099,
  [SMALL_STATE(190)] = 8134,
  [SMALL_STATE(191)] = 8157,
  [SMALL_STATE(192)] = 8182,
  [SMALL_STATE(193)] = 8205,
  [SMALL_STATE(194)] = 8228,
  [SMALL_STATE(195)] = 8251,
  [SMALL_STATE(196)] = 8285,
  [SMALL_STATE(197)] = 8319,
  [SMALL_STATE(198)] = 8341,
  [SMALL_STATE(199)] = 8360,
  [SMALL_STATE(200)] = 8377,
  [SMALL_STATE(201)] = 8394,
  [SMALL_STATE(202)] = 8411,
  [SMALL_STATE(203)] = 8428,
  [SMALL_STATE(204)] = 8445,
  [SMALL_STATE(205)] = 8462,
  [SMALL_STATE(206)] = 8479,
  [SMALL_STATE(207)] = 8496,
  [SMALL_STATE(208)] = 8513,
  [SMALL_STATE(209)] = 8530,
  [SMALL_STATE(210)] = 8547,
  [SMALL_STATE(211)] = 8578,
  [SMALL_STATE(212)] = 8595,
  [SMALL_STATE(213)] = 8612,
  [SMALL_STATE(214)] = 8629,
  [SMALL_STATE(215)] = 8646,
  [SMALL_STATE(216)] = 8663,
  [SMALL_STATE(217)] = 8680,
  [SMALL_STATE(218)] = 8699,
  [SMALL_STATE(219)] = 8716,
  [SMALL_STATE(220)] = 8733,
  [SMALL_STATE(221)] = 8750,
  [SMALL_STATE(222)] = 8767,
  [SMALL_STATE(223)] = 8798,
  [SMALL_STATE(224)] = 8815,
  [SMALL_STATE(225)] = 8846,
  [SMALL_STATE(226)] = 8863,
  [SMALL_STATE(227)] = 8880,
  [SMALL_STATE(228)] = 8897,
  [SMALL_STATE(229)] = 8914,
  [SMALL_STATE(230)] = 8931,
  [SMALL_STATE(231)] = 8948,
  [SMALL_STATE(232)] = 8967,
  [SMALL_STATE(233)] = 8984,
  [SMALL_STATE(234)] = 9001,
  [SMALL_STATE(235)] = 9018,
  [SMALL_STATE(236)] = 9035,
  [SMALL_STATE(237)] = 9052,
  [SMALL_STATE(238)] = 9069,
  [SMALL_STATE(239)] = 9086,
  [SMALL_STATE(240)] = 9103,
  [SMALL_STATE(241)] = 9120,
  [SMALL_STATE(242)] = 9139,
  [SMALL_STATE(243)] = 9156,
  [SMALL_STATE(244)] = 9173,
  [SMALL_STATE(245)] = 9190,
  [SMALL_STATE(246)] = 9207,
  [SMALL_STATE(247)] = 9235,
  [SMALL_STATE(248)] = 9263,
  [SMALL_STATE(249)] = 9291,
  [SMALL_STATE(250)] = 9319,
  [SMALL_STATE(251)] = 9337,
  [SMALL_STATE(252)] = 9365,
  [SMALL_STATE(253)] = 9383,
  [SMALL_STATE(254)] = 9413,
  [SMALL_STATE(255)] = 9431,
  [SMALL_STATE(256)] = 9449,
  [SMALL_STATE(257)] = 9467,
  [SMALL_STATE(258)] = 9495,
  [SMALL_STATE(259)] = 9523,
  [SMALL_STATE(260)] = 9551,
  [SMALL_STATE(261)] = 9569,
  [SMALL_STATE(262)] = 9597,
  [SMALL_STATE(263)] = 9615,
  [SMALL_STATE(264)] = 9633,
  [SMALL_STATE(265)] = 9663,
  [SMALL_STATE(266)] = 9691,
  [SMALL_STATE(267)] = 9718,
  [SMALL_STATE(268)] = 9740,
  [SMALL_STATE(269)] = 9764,
  [SMALL_STATE(270)] = 9788,
  [SMALL_STATE(271)] = 9812,
  [SMALL_STATE(272)] = 9836,
  [SMALL_STATE(273)] = 9860,
  [SMALL_STATE(274)] = 9884,
  [SMALL_STATE(275)] = 9905,
  [SMALL_STATE(276)] = 9920,
  [SMALL_STATE(277)] = 9941,
  [SMALL_STATE(278)] = 9962,
  [SMALL_STATE(279)] = 9983,
  [SMALL_STATE(280)] = 10004,
  [SMALL_STATE(281)] = 10025,
  [SMALL_STATE(282)] = 10044,
  [SMALL_STATE(283)] = 10065,
  [SMALL_STATE(284)] = 10086,
  [SMALL_STATE(285)] = 10101,
  [SMALL_STATE(286)] = 10120,
  [SMALL_STATE(287)] = 10141,
  [SMALL_STATE(288)] = 10166,
  [SMALL_STATE(289)] = 10185,
  [SMALL_STATE(290)] = 10206,
  [SMALL_STATE(291)] = 10227,
  [SMALL_STATE(292)] = 10248,
  [SMALL_STATE(293)] = 10269,
  [SMALL_STATE(294)] = 10290,
  [SMALL_STATE(295)] = 10309,
  [SMALL_STATE(296)] = 10330,
  [SMALL_STATE(297)] = 10351,
  [SMALL_STATE(298)] = 10366,
  [SMALL_STATE(299)] = 10388,
  [SMALL_STATE(300)] = 10406,
  [SMALL_STATE(301)] = 10424,
  [SMALL_STATE(302)] = 10442,
  [SMALL_STATE(303)] = 10462,
  [SMALL_STATE(304)] = 10484,
  [SMALL_STATE(305)] = 10504,
  [SMALL_STATE(306)] = 10526,
  [SMALL_STATE(307)] = 10548,
  [SMALL_STATE(308)] = 10570,
  [SMALL_STATE(309)] = 10590,
  [SMALL_STATE(310)] = 10610,
  [SMALL_STATE(311)] = 10628,
  [SMALL_STATE(312)] = 10644,
  [SMALL_STATE(313)] = 10660,
  [SMALL_STATE(314)] = 10678,
  [SMALL_STATE(315)] = 10698,
  [SMALL_STATE(316)] = 10709,
  [SMALL_STATE(317)] = 10728,
  [SMALL_STATE(318)] = 10747,
  [SMALL_STATE(319)] = 10762,
  [SMALL_STATE(320)] = 10773,
  [SMALL_STATE(321)] = 10792,
  [SMALL_STATE(322)] = 10809,
  [SMALL_STATE(323)] = 10826,
  [SMALL_STATE(324)] = 10845,
  [SMALL_STATE(325)] = 10864,
  [SMALL_STATE(326)] = 10879,
  [SMALL_STATE(327)] = 10898,
  [SMALL_STATE(328)] = 10913,
  [SMALL_STATE(329)] = 10930,
  [SMALL_STATE(330)] = 10941,
  [SMALL_STATE(331)] = 10956,
  [SMALL_STATE(332)] = 10971,
  [SMALL_STATE(333)] = 10981,
  [SMALL_STATE(334)] = 10995,
  [SMALL_STATE(335)] = 11009,
  [SMALL_STATE(336)] = 11023,
  [SMALL_STATE(337)] = 11037,
  [SMALL_STATE(338)] = 11051,
  [SMALL_STATE(339)] = 11061,
  [SMALL_STATE(340)] = 11075,
  [SMALL_STATE(341)] = 11091,
  [SMALL_STATE(342)] = 11107,
  [SMALL_STATE(343)] = 11123,
  [SMALL_STATE(344)] = 11137,
  [SMALL_STATE(345)] = 11153,
  [SMALL_STATE(346)] = 11165,
  [SMALL_STATE(347)] = 11175,
  [SMALL_STATE(348)] = 11191,
  [SMALL_STATE(349)] = 11201,
  [SMALL_STATE(350)] = 11213,
  [SMALL_STATE(351)] = 11225,
  [SMALL_STATE(352)] = 11239,
  [SMALL_STATE(353)] = 11251,
  [SMALL_STATE(354)] = 11263,
  [SMALL_STATE(355)] = 11279,
  [SMALL_STATE(356)] = 11293,
  [SMALL_STATE(357)] = 11309,
  [SMALL_STATE(358)] = 11325,
  [SMALL_STATE(359)] = 11341,
  [SMALL_STATE(360)] = 11357,
  [SMALL_STATE(361)] = 11371,
  [SMALL_STATE(362)] = 11387,
  [SMALL_STATE(363)] = 11403,
  [SMALL_STATE(364)] = 11417,
  [SMALL_STATE(365)] = 11431,
  [SMALL_STATE(366)] = 11447,
  [SMALL_STATE(367)] = 11457,
  [SMALL_STATE(368)] = 11473,
  [SMALL_STATE(369)] = 11485,
  [SMALL_STATE(370)] = 11497,
  [SMALL_STATE(371)] = 11506,
  [SMALL_STATE(372)] = 11519,
  [SMALL_STATE(373)] = 11532,
  [SMALL_STATE(374)] = 11545,
  [SMALL_STATE(375)] = 11558,
  [SMALL_STATE(376)] = 11567,
  [SMALL_STATE(377)] = 11580,
  [SMALL_STATE(378)] = 11593,
  [SMALL_STATE(379)] = 11606,
  [SMALL_STATE(380)] = 11617,
  [SMALL_STATE(381)] = 11630,
  [SMALL_STATE(382)] = 11641,
  [SMALL_STATE(383)] = 11650,
  [SMALL_STATE(384)] = 11663,
  [SMALL_STATE(385)] = 11674,
  [SMALL_STATE(386)] = 11687,
  [SMALL_STATE(387)] = 11700,
  [SMALL_STATE(388)] = 11713,
  [SMALL_STATE(389)] = 11726,
  [SMALL_STATE(390)] = 11737,
  [SMALL_STATE(391)] = 11750,
  [SMALL_STATE(392)] = 11763,
  [SMALL_STATE(393)] = 11776,
  [SMALL_STATE(394)] = 11789,
  [SMALL_STATE(395)] = 11802,
  [SMALL_STATE(396)] = 11815,
  [SMALL_STATE(397)] = 11828,
  [SMALL_STATE(398)] = 11836,
  [SMALL_STATE(399)] = 11844,
  [SMALL_STATE(400)] = 11854,
  [SMALL_STATE(401)] = 11864,
  [SMALL_STATE(402)] = 11874,
  [SMALL_STATE(403)] = 11884,
  [SMALL_STATE(404)] = 11892,
  [SMALL_STATE(405)] = 11900,
  [SMALL_STATE(406)] = 11910,
  [SMALL_STATE(407)] = 11918,
  [SMALL_STATE(408)] = 11926,
  [SMALL_STATE(409)] = 11936,
  [SMALL_STATE(410)] = 11946,
  [SMALL_STATE(411)] = 11956,
  [SMALL_STATE(412)] = 11966,
  [SMALL_STATE(413)] = 11974,
  [SMALL_STATE(414)] = 11982,
  [SMALL_STATE(415)] = 11990,
  [SMALL_STATE(416)] = 12000,
  [SMALL_STATE(417)] = 12008,
  [SMALL_STATE(418)] = 12016,
  [SMALL_STATE(419)] = 12026,
  [SMALL_STATE(420)] = 12036,
  [SMALL_STATE(421)] = 12046,
  [SMALL_STATE(422)] = 12054,
  [SMALL_STATE(423)] = 12062,
  [SMALL_STATE(424)] = 12072,
  [SMALL_STATE(425)] = 12079,
  [SMALL_STATE(426)] = 12086,
  [SMALL_STATE(427)] = 12093,
  [SMALL_STATE(428)] = 12100,
  [SMALL_STATE(429)] = 12107,
  [SMALL_STATE(430)] = 12114,
  [SMALL_STATE(431)] = 12121,
  [SMALL_STATE(432)] = 12128,
  [SMALL_STATE(433)] = 12135,
  [SMALL_STATE(434)] = 12142,
  [SMALL_STATE(435)] = 12149,
  [SMALL_STATE(436)] = 12156,
  [SMALL_STATE(437)] = 12163,
  [SMALL_STATE(438)] = 12170,
  [SMALL_STATE(439)] = 12177,
  [SMALL_STATE(440)] = 12184,
  [SMALL_STATE(441)] = 12191,
  [SMALL_STATE(442)] = 12198,
  [SMALL_STATE(443)] = 12205,
  [SMALL_STATE(444)] = 12212,
  [SMALL_STATE(445)] = 12219,
  [SMALL_STATE(446)] = 12226,
  [SMALL_STATE(447)] = 12233,
  [SMALL_STATE(448)] = 12240,
  [SMALL_STATE(449)] = 12247,
  [SMALL_STATE(450)] = 12254,
  [SMALL_STATE(451)] = 12261,
  [SMALL_STATE(452)] = 12268,
  [SMALL_STATE(453)] = 12275,
  [SMALL_STATE(454)] = 12282,
  [SMALL_STATE(455)] = 12289,
  [SMALL_STATE(456)] = 12296,
  [SMALL_STATE(457)] = 12303,
  [SMALL_STATE(458)] = 12310,
  [SMALL_STATE(459)] = 12317,
  [SMALL_STATE(460)] = 12324,
  [SMALL_STATE(461)] = 12331,
  [SMALL_STATE(462)] = 12338,
  [SMALL_STATE(463)] = 12345,
  [SMALL_STATE(464)] = 12352,
  [SMALL_STATE(465)] = 12359,
  [SMALL_STATE(466)] = 12366,
  [SMALL_STATE(467)] = 12373,
  [SMALL_STATE(468)] = 12380,
  [SMALL_STATE(469)] = 12387,
  [SMALL_STATE(470)] = 12394,
  [SMALL_STATE(471)] = 12401,
  [SMALL_STATE(472)] = 12408,
  [SMALL_STATE(473)] = 12415,
  [SMALL_STATE(474)] = 12422,
  [SMALL_STATE(475)] = 12429,
  [SMALL_STATE(476)] = 12436,
  [SMALL_STATE(477)] = 12443,
  [SMALL_STATE(478)] = 12450,
  [SMALL_STATE(479)] = 12457,
  [SMALL_STATE(480)] = 12464,
  [SMALL_STATE(481)] = 12471,
  [SMALL_STATE(482)] = 12478,
  [SMALL_STATE(483)] = 12485,
  [SMALL_STATE(484)] = 12492,
  [SMALL_STATE(485)] = 12499,
  [SMALL_STATE(486)] = 12506,
  [SMALL_STATE(487)] = 12513,
  [SMALL_STATE(488)] = 12520,
  [SMALL_STATE(489)] = 12527,
  [SMALL_STATE(490)] = 12534,
  [SMALL_STATE(491)] = 12541,
  [SMALL_STATE(492)] = 12548,
  [SMALL_STATE(493)] = 12555,
  [SMALL_STATE(494)] = 12562,
  [SMALL_STATE(495)] = 12569,
  [SMALL_STATE(496)] = 12576,
  [SMALL_STATE(497)] = 12583,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(39),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(455),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(490),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(16),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [41] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_qualified_identifier, 3, 0, 13),
  [43] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_qualified_identifier, 3, 0, 13),
  [45] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_identifier_reference, 1, 0, 0),
  [47] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_identifier_reference, 1, 0, 0),
  [49] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_iri, 3, 0, 0),
  [51] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_iri, 3, 0, 0),
  [53] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 1, 0, 0),
  [55] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 1, 0, 0),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [59] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean_falsity, 1, 0, 0),
  [61] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean_falsity, 1, 0, 0),
  [63] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean_truth, 1, 0, 0),
  [65] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean_truth, 1, 0, 0),
  [67] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_simple_value, 1, 0, 0),
  [69] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_simple_value, 1, 0, 0),
  [71] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean, 1, 0, 0),
  [73] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1, 0, 0),
  [75] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2, 0, 26),
  [77] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2, 0, 26),
  [79] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary, 2, 0, 0),
  [81] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary, 2, 0, 0),
  [83] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary, 3, 0, 54),
  [85] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary, 3, 0, 54),
  [87] = {.entry = {.count = 1, .reusable = false}}, SHIFT(99),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(492),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [107] = {.entry = {.count = 1, .reusable = false}}, SHIFT(102),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [115] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value, 1, 0, 0),
  [117] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value, 1, 0, 0),
  [119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [123] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 83), SHIFT_REPEAT(99),
  [126] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 83), SHIFT_REPEAT(47),
  [129] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 83),
  [131] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 83), SHIFT_REPEAT(121),
  [134] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 83), SHIFT_REPEAT(114),
  [137] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 83), SHIFT_REPEAT(224),
  [140] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 83), SHIFT_REPEAT(92),
  [143] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 83), SHIFT_REPEAT(492),
  [146] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 83), SHIFT_REPEAT(376),
  [149] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 83), SHIFT_REPEAT(102),
  [152] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 83), SHIFT_REPEAT(102),
  [155] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 83), SHIFT_REPEAT(104),
  [158] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 2, 0, 83), SHIFT_REPEAT(106),
  [161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [163] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_values, 3, 0, 50),
  [165] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_values, 3, 0, 50),
  [167] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_values, 3, 0, 56),
  [169] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_values, 3, 0, 56),
  [171] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mapping_value, 3, 0, 57),
  [173] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mapping_value, 3, 0, 57),
  [175] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_values, 2, 0, 0),
  [177] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_values, 2, 0, 0),
  [179] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_values, 1, 0, 15),
  [181] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_values, 1, 0, 15),
  [183] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_constructor, 4, 0, 77),
  [185] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_constructor, 4, 0, 77),
  [187] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_values, 4, 0, 78),
  [189] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_values, 4, 0, 78),
  [191] = {.entry = {.count = 1, .reusable = false}}, SHIFT(453),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(453),
  [195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(495),
  [197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(478),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(475),
  [211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(474),
  [213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(473),
  [215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [227] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_composition, 2, 0, 28),
  [229] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_composition, 2, 0, 28),
  [231] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 1, 0, 0),
  [233] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 1, 0, 0),
  [235] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 51), SHIFT_REPEAT(134),
  [238] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 51), SHIFT_REPEAT(47),
  [241] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 51),
  [243] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 51), SHIFT_REPEAT(121),
  [246] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 51), SHIFT_REPEAT(300),
  [249] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 51), SHIFT_REPEAT(92),
  [252] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 51), SHIFT_REPEAT(492),
  [255] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 51), SHIFT_REPEAT(376),
  [258] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 51), SHIFT_REPEAT(102),
  [261] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 51), SHIFT_REPEAT(102),
  [264] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 51), SHIFT_REPEAT(104),
  [267] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 51), SHIFT_REPEAT(106),
  [270] = {.entry = {.count = 1, .reusable = false}}, SHIFT(134),
  [272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [278] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [288] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_composition_repeat1, 2, 0, 58),
  [290] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_function_composition_repeat1, 2, 0, 58),
  [292] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_composition_repeat1, 2, 0, 58), SHIFT_REPEAT(495),
  [295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [297] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_composition_repeat1, 2, 0, 5),
  [299] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_function_composition_repeat1, 2, 0, 5),
  [301] = {.entry = {.count = 1, .reusable = false}}, SHIFT(36),
  [303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_predicate_value, 1, 0, 0),
  [309] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_predicate_value, 1, 0, 0),
  [311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_predicate_values, 1, 0, 15),
  [313] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_predicate_values, 1, 0, 15),
  [315] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_actual_arguments, 3, 0, 82),
  [317] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_actual_arguments, 3, 0, 82),
  [319] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_predicate_values, 4, 0, 78),
  [321] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_predicate_values, 4, 0, 78),
  [323] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_predicate_values, 2, 0, 0),
  [325] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_predicate_values, 2, 0, 0),
  [327] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_predicate_values, 3, 0, 56),
  [329] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_predicate_values, 3, 0, 56),
  [331] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_actual_arguments, 2, 0, 0),
  [333] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_actual_arguments, 2, 0, 0),
  [335] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [337] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_builder, 5, 0, 94),
  [339] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_builder, 5, 0, 94),
  [341] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_predicate_values, 3, 0, 50),
  [343] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_predicate_values, 3, 0, 50),
  [345] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_atomic_sentence, 2, 0, 33),
  [347] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_functional_term, 2, 0, 34),
  [349] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_functional_term, 2, 0, 34),
  [351] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 51), SHIFT_REPEAT(134),
  [354] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 51),
  [356] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 51), SHIFT_REPEAT(92),
  [359] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 51), SHIFT_REPEAT(492),
  [362] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 51), SHIFT_REPEAT(376),
  [365] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 51), SHIFT_REPEAT(102),
  [368] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 51), SHIFT_REPEAT(102),
  [371] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 51), SHIFT_REPEAT(104),
  [374] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 51), SHIFT_REPEAT(106),
  [377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [381] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [385] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_boolean_sentence, 3, 0, 60),
  [387] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_boolean_sentence, 2, 0, 30),
  [389] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quantified_sentence, 3, 0, 61),
  [391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [395] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [401] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0),
  [403] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(477),
  [406] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(476),
  [409] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(475),
  [412] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(474),
  [415] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(473),
  [418] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(405),
  [421] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(471),
  [424] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(470),
  [427] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(469),
  [430] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(468),
  [433] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_biconditional, 1, 0, 0),
  [435] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_biconditional, 1, 0, 0),
  [437] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_implication, 1, 0, 0),
  [439] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_implication, 1, 0, 0),
  [441] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_exclusive_disjunction, 1, 0, 0),
  [443] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exclusive_disjunction, 1, 0, 0),
  [445] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_negation, 1, 0, 0),
  [447] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_negation, 1, 0, 0),
  [449] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_disjunction, 1, 0, 0),
  [451] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_disjunction, 1, 0, 0),
  [453] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constraint_environment, 2, 0, 0),
  [455] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constraint_environment, 2, 0, 0),
  [457] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constraint_environment_end, 1, 0, 0),
  [459] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constraint_environment_end, 1, 0, 0),
  [461] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_conjunction, 1, 0, 0),
  [463] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_conjunction, 1, 0, 0),
  [465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(462),
  [467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [469] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_module_body_repeat2, 2, 0, 0),
  [471] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_module_body_repeat2, 2, 0, 0),
  [473] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat2, 2, 0, 0), SHIFT_REPEAT(374),
  [476] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat2, 2, 0, 0), SHIFT_REPEAT(478),
  [479] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_body, 2, 0, 0),
  [481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [487] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_builtin_simple_type, 1, 0, 0),
  [489] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_builtin_simple_type, 1, 0, 0),
  [491] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mapping_type, 5, 0, 96),
  [493] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mapping_type, 5, 0, 96),
  [495] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_composition_repeat1, 2, 0, 58), SHIFT_REPEAT(486),
  [498] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inequation, 3, 0, 64),
  [500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [502] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_equation, 3, 0, 62),
  [504] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constant_def, 2, 0, 29),
  [506] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [510] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_import, 1, 0, 4),
  [512] = {.entry = {.count = 1, .reusable = false}}, SHIFT(454),
  [514] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_actual_arguments_repeat1, 1, 0, 63),
  [516] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_actual_arguments_repeat1, 1, 0, 63),
  [518] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [520] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [522] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [524] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_informal_constraint, 2, 0, 17),
  [526] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_informal_constraint, 2, 0, 17),
  [528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [530] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constraint_sentence, 1, 0, 0),
  [532] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean_sentence, 1, 0, 0),
  [534] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constraint, 3, 0, 1),
  [536] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constraint, 3, 0, 1),
  [538] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation, 1, 0, 0),
  [540] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation, 1, 0, 0),
  [542] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_informal_constraint, 3, 0, 35),
  [544] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_informal_constraint, 3, 0, 35),
  [546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [552] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [554] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constraint_sentence, 3, 0, 0),
  [556] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_simple_sentence, 1, 0, 0),
  [558] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation_property, 4, 0, 16),
  [560] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation_property, 4, 0, 16),
  [562] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_formal_constraint, 3, 0, 29),
  [564] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formal_constraint, 3, 0, 29),
  [566] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_formal_constraint, 4, 0, 65),
  [568] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formal_constraint, 4, 0, 65),
  [570] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_reference, 1, 0, 0),
  [572] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_reference, 1, 0, 0),
  [574] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [576] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 1, 0, 25),
  [578] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 1, 0, 25),
  [580] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_member_import, 1, 0, 4),
  [582] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_sequence_of_values_repeat1, 1, 0, 25),
  [584] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 1, 0, 25),
  [586] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_import, 3, 0, 14),
  [588] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_import, 3, 0, 14),
  [590] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__rename_import, 2, 0, 12),
  [592] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__rename_import, 2, 0, 12),
  [594] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_module_body_repeat1, 2, 0, 0),
  [596] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat1, 2, 0, 0), SHIFT_REPEAT(310),
  [599] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_import, 2, 0, 8),
  [601] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_import, 2, 0, 8),
  [603] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_import, 2, 0, 9),
  [605] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_not_equal, 1, 0, 0),
  [607] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_not_equal, 1, 0, 0),
  [609] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_member_import, 2, 0, 8),
  [611] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_member_import, 2, 0, 8),
  [613] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_less_than_or_equal, 1, 0, 0),
  [615] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_less_than_or_equal, 1, 0, 0),
  [617] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_greater_than_or_equal, 1, 0, 0),
  [619] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_greater_than_or_equal, 1, 0, 0),
  [621] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_member_def, 2, 0, 10),
  [623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [625] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_member_def, 2, 0, 10),
  [627] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__type_expression_to, 2, 0, 20),
  [629] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__type_expression_to, 2, 0, 20),
  [631] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation_only_body, 3, 0, 0),
  [633] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation_only_body, 3, 0, 0),
  [635] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__type_expression_to, 3, 0, 42),
  [637] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__type_expression_to, 3, 0, 42),
  [639] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 4, 0, 0),
  [641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [645] = {.entry = {.count = 1, .reusable = false}}, SHIFT(38),
  [647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [651] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 2, 0, 0),
  [653] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_member_def, 3, 0, 19),
  [655] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_member_def, 3, 0, 19),
  [657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [659] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_def, 2, 0, 5),
  [661] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [667] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimension_def, 2, 0, 5),
  [669] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [671] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_structure_def, 2, 0, 5),
  [673] = {.entry = {.count = 1, .reusable = false}}, SHIFT(339),
  [675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [679] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_def, 5, 0, 48),
  [681] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_data_type_def, 5, 0, 36),
  [683] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_data_type_def, 4, 0, 18),
  [685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [687] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_def, 2, 0, 5),
  [689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [693] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event_def, 2, 0, 5),
  [695] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_def, 2, 0, 5),
  [697] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [701] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_def, 2, 0, 5),
  [703] = {.entry = {.count = 1, .reusable = false}}, SHIFT(327),
  [705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [709] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cardinality_expression, 4, 0, 87),
  [711] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_expression, 4, 0, 87),
  [713] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_body, 2, 0, 0),
  [715] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 4, 0, 0),
  [717] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_body, 4, 0, 67),
  [719] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_structure_body, 2, 0, 0),
  [721] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimension_body, 4, 0, 39),
  [723] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_definition, 1, 0, 0),
  [725] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_data_type_def, 6, 0, 66),
  [727] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimension_body, 4, 0, 67),
  [729] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rdf_def, 4, 0, 22),
  [731] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 3, 0, 0),
  [733] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_body, 2, 0, 0),
  [735] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [739] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [741] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_body, 4, 0, 39),
  [743] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property_def, 2, 0, 6),
  [745] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_body, 3, 0, 45),
  [747] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event_body, 4, 0, 39),
  [749] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event_body, 4, 0, 67),
  [751] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 2, 0, 0),
  [753] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cardinality_expression, 3, 0, 69),
  [755] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_expression, 3, 0, 69),
  [757] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_structure_body, 4, 0, 0),
  [759] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_body, 4, 0, 0),
  [761] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_body, 4, 0, 74),
  [763] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_def, 6, 0, 75),
  [765] = {.entry = {.count = 1, .reusable = false}}, SHIFT(392),
  [767] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [769] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [771] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [773] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_body, 3, 0, 0),
  [775] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_body, 3, 0, 0),
  [777] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimension_body, 5, 0, 39),
  [779] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimension_body, 5, 0, 67),
  [781] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_body, 5, 0, 67),
  [783] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_def, 3, 0, 1),
  [785] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event_body, 5, 0, 67),
  [787] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cardinality_expression, 4, 0, 88),
  [789] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_expression, 4, 0, 88),
  [791] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rdf_def, 3, 0, 1),
  [793] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_def, 3, 0, 1),
  [795] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_structure_def, 3, 0, 1),
  [797] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event_def, 3, 0, 1),
  [799] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimension_body, 6, 0, 67),
  [801] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_structure_body, 3, 0, 0),
  [803] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_def, 3, 0, 1),
  [805] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_def, 3, 0, 1),
  [807] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_data_type_def, 5, 0, 37),
  [809] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cardinality_expression, 5, 0, 97),
  [811] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_expression, 5, 0, 97),
  [813] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimension_def, 3, 0, 1),
  [815] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimension_body, 3, 0, 39),
  [817] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_body, 3, 0, 39),
  [819] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event_body, 3, 0, 39),
  [821] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [823] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [825] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [829] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [831] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [833] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_cardinality_expression, 3, 0, 53),
  [835] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_cardinality_expression, 3, 0, 53),
  [837] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_cardinality_expression, 3, 0, 52),
  [839] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_cardinality_expression, 3, 0, 52),
  [841] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [843] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [845] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_cardinality_expression, 3, 0, 69),
  [847] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_cardinality_expression, 3, 0, 69),
  [849] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_cardinality_expression, 4, 0, 76),
  [851] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_cardinality_expression, 4, 0, 76),
  [853] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_cardinality_expression, 4, 0, 88),
  [855] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_cardinality_expression, 4, 0, 88),
  [857] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [859] = {.entry = {.count = 1, .reusable = false}}, SHIFT(356),
  [861] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [863] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_cardinality_expression, 4, 0, 87),
  [865] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_cardinality_expression, 4, 0, 87),
  [867] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [869] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_cardinality_expression, 2, 0, 0),
  [871] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_cardinality_expression, 2, 0, 0),
  [873] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_cardinality_expression, 5, 0, 97),
  [875] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_cardinality_expression, 5, 0, 97),
  [877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [879] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [881] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [883] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [885] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_def, 3, 0, 73),
  [887] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [889] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [891] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_type_reference, 1, 0, 0),
  [893] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_type_reference, 1, 0, 0),
  [895] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [897] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [899] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [901] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [903] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_variable, 1, 0, 4),
  [905] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [907] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [909] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [911] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_type, 3, 0, 42),
  [913] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_type, 3, 0, 42),
  [915] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [917] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [919] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [921] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_import, 1, 0, 4),
  [923] = {.entry = {.count = 1, .reusable = true}}, SHIFT(454),
  [925] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_variable, 2, 0, 47),
  [927] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [929] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [931] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [933] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_import_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(287),
  [936] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_import_statement_repeat1, 2, 0, 0),
  [938] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [940] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_dimension_body_repeat2, 2, 0, 0), SHIFT_REPEAT(339),
  [943] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_dimension_body_repeat2, 2, 0, 0),
  [945] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dimension_body_repeat2, 2, 0, 0), SHIFT_REPEAT(391),
  [948] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_type, 2, 0, 20),
  [950] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_type, 2, 0, 20),
  [952] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [954] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [956] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dimension_parent, 4, 0, 95),
  [958] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimension_parent, 4, 0, 95),
  [960] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_dimension_body_repeat1, 2, 0, 0),
  [962] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_dimension_body_repeat1, 2, 0, 0),
  [964] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dimension_body_repeat1, 2, 0, 0), SHIFT_REPEAT(459),
  [967] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [969] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_class_arguments_repeat1, 2, 0, 49), SHIFT_REPEAT(36),
  [972] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_class_arguments_repeat1, 2, 0, 49),
  [974] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_body_repeat1, 2, 0, 0), SHIFT_REPEAT(327),
  [977] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_union_body_repeat1, 2, 0, 0),
  [979] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_class_def_repeat1, 2, 0, 49), SHIFT_REPEAT(281),
  [982] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_class_def_repeat1, 2, 0, 49),
  [984] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_class_def_repeat1, 2, 0, 49), SHIFT_REPEAT(266),
  [987] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [989] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [991] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [993] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [995] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [997] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_reference, 1, 0, 4),
  [999] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [1001] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [1003] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_signature, 3, 0, 92),
  [1005] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_rdf_types_repeat1, 2, 0, 72), SHIFT_REPEAT(36),
  [1008] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_rdf_types_repeat1, 2, 0, 72),
  [1010] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__type_variable_restriction, 2, 0, 0),
  [1012] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [1014] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_signature, 1, 0, 59),
  [1016] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1018] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [1020] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [1022] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__type_variable_restriction, 3, 0, 0),
  [1024] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_variant, 1, 0, 4),
  [1026] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_variant, 1, 0, 4),
  [1028] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [1030] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [1032] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_signature, 4, 0, 98),
  [1034] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__type_variable_restriction_repeat1, 2, 0, 0),
  [1036] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__type_variable_restriction_repeat1, 2, 0, 0), SHIFT_REPEAT(367),
  [1039] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_source_entity, 2, 0, 38),
  [1041] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_entity, 2, 0, 38),
  [1043] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [1045] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [1047] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_enum_body_repeat1, 2, 0, 0), SHIFT_REPEAT(356),
  [1050] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_body_repeat1, 2, 0, 0),
  [1052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [1054] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [1056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [1058] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_ordering, 1, 0, 0),
  [1060] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [1062] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [1064] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [1066] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [1068] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_import, 2, 0, 9),
  [1070] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_member_import, 1, 0, 4),
  [1072] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property_ref, 2, 0, 43),
  [1074] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property_ref, 2, 0, 43),
  [1076] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_arguments, 3, 0, 103),
  [1078] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [1080] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_arguments, 3, 0, 102),
  [1082] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dimension_parent, 5, 0, 101),
  [1084] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimension_parent, 5, 0, 101),
  [1086] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__identifier_or_list, 3, 0, 99),
  [1088] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__identifier_or_list, 3, 0, 99),
  [1090] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_constraint_environment_repeat1, 2, 0, 0),
  [1092] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_constraint_environment_repeat1, 2, 0, 0), SHIFT_REPEAT(455),
  [1095] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_entity_identity, 2, 0, 39),
  [1097] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_identity, 2, 0, 39),
  [1099] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_member, 1, 0, 0),
  [1101] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_member, 1, 0, 0),
  [1103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [1105] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_variant, 1, 0, 4),
  [1107] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_variant, 1, 0, 4),
  [1109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [1111] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_class_body_repeat1, 2, 0, 46),
  [1113] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_class_body_repeat1, 2, 0, 46), SHIFT_REPEAT(444),
  [1116] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_signature_repeat1, 2, 0, 93), SHIFT_REPEAT(333),
  [1119] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_signature_repeat1, 2, 0, 93),
  [1121] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_variant, 3, 0, 70),
  [1123] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_variant, 3, 0, 70),
  [1125] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_def, 4, 0, 90),
  [1127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [1129] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_reference, 2, 0, 91),
  [1131] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__identifier_or_list, 1, 0, 84),
  [1133] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__identifier_or_list, 1, 0, 84),
  [1135] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_source_entity, 4, 0, 85),
  [1137] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_entity, 4, 0, 85),
  [1139] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_variable, 2, 0, 4),
  [1141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [1143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [1145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [1147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [1149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [1151] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_variable, 3, 0, 47),
  [1153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [1155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [1157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [1159] = {.entry = {.count = 1, .reusable = false}}, SHIFT(414),
  [1161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [1163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [1165] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_class_def_repeat1, 1, 0, 24),
  [1167] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__cardinality_inner, 1, 0, 41),
  [1169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [1171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [1173] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_named_variable_set_repeat1, 2, 0, 0), SHIFT_REPEAT(385),
  [1176] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_named_variable_set_repeat1, 2, 0, 0),
  [1178] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__identifier_or_list_repeat1, 2, 0, 100), SHIFT_REPEAT(413),
  [1181] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__identifier_or_list_repeat1, 2, 0, 100),
  [1183] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_binary_repeat1, 2, 0, 55),
  [1185] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_binary_repeat1, 2, 0, 55), SHIFT_REPEAT(416),
  [1188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [1190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [1192] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [1194] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quantified_variable, 3, 0, 81),
  [1196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [1198] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_variable_set, 1, 0, 0),
  [1200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [1202] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [1204] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [1206] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_class_arguments_repeat1, 1, 0, 24),
  [1208] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_class_body_repeat1, 1, 0, 23),
  [1210] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_variant, 2, 0, 40),
  [1212] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_variant, 2, 0, 40),
  [1214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [1216] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__module_locations, 1, 0, 2),
  [1218] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_uniqueness, 1, 0, 0),
  [1220] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_signature_repeat1, 1, 0, 79),
  [1222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [1224] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_def, 2, 0, 80),
  [1226] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_environment_def, 3, 0, 1),
  [1228] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_universal, 1, 0, 0),
  [1230] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_universal, 1, 0, 0),
  [1232] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_variant, 4, 0, 89),
  [1234] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_variant, 4, 0, 89),
  [1236] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_def, 4, 0, 73),
  [1238] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__identifier_or_list_repeat1, 1, 0, 84),
  [1240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [1242] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_range, 1, 0, 0),
  [1244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [1246] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_binary_repeat1, 1, 0, 27),
  [1248] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameter, 2, 0, 10),
  [1250] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_existential, 1, 0, 0),
  [1252] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_existential, 1, 0, 0),
  [1254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_rdf_types_repeat1, 1, 0, 44),
  [1256] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_def, 5, 0, 90),
  [1258] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_variant, 2, 0, 40),
  [1260] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_variant, 2, 0, 40),
  [1262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [1264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [1266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [1268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [1270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [1272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [1274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [1276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [1278] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__cardinality_inner, 2, 0, 68),
  [1280] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quantified_variable, 1, 0, 31),
  [1282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [1284] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rdf_types, 4, 0, 71),
  [1286] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rdf_types, 3, 0, 0),
  [1288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [1290] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quantified_variable_binding, 2, 0, 32),
  [1292] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mapping_variable, 5, 0, 96),
  [1294] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_builder_body, 3, 0, 0),
  [1296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [1298] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_builder_body, 1, 0, 0),
  [1300] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rdf_types, 2, 0, 21),
  [1302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [1304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [1306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [1308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [1310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [1312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [1314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [1316] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [1318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [1320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [1322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [1324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [1326] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__module_locations, 3, 0, 7),
  [1328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [1330] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_body, 3, 0, 0),
  [1332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [1334] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__sequence_value_constraints, 3, 0, 52),
  [1336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [1338] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_body, 5, 0, 0),
  [1340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [1342] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_range, 2, 0, 86),
  [1344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [1346] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module, 4, 0, 3),
  [1348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [1350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [1352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [1354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [1356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [1358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [1360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [1362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [1364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [1366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [1368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [1370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [1372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [1374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [1376] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_body, 4, 0, 0),
  [1378] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__sequence_value_constraints, 4, 0, 76),
  [1380] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__module_locations, 4, 0, 11),
  [1382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [1384] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_body, 2, 0, 0),
  [1386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [1388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [1390] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module, 3, 0, 1),
  [1392] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__sequence_value_constraints, 3, 0, 53),
  [1394] = {.entry = {.count = 1, .reusable = false}}, SHIFT(467),
  [1396] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [1398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [1400] = {.entry = {.count = 1, .reusable = false}}, SHIFT(479),
  [1402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [1404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [1406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [1408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [1410] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_sdml(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
