// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{ffi, Annotation, HoverDisplay};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, pin::Pin};

glib::wrapper! {
    #[doc(alias = "GtkSourceAnnotationProvider")]
    pub struct AnnotationProvider(Object<ffi::GtkSourceAnnotationProvider, ffi::GtkSourceAnnotationProviderClass>);

    match fn {
        type_ => || ffi::gtk_source_annotation_provider_get_type(),
    }
}

impl AnnotationProvider {
    pub const NONE: Option<&'static AnnotationProvider> = None;

    #[doc(alias = "gtk_source_annotation_provider_new")]
    pub fn new() -> AnnotationProvider {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_source_annotation_provider_new()) }
    }
}

#[cfg(feature = "v5_18")]
#[cfg_attr(docsrs, doc(cfg(feature = "v5_18")))]
impl Default for AnnotationProvider {
    fn default() -> Self {
        Self::new()
    }
}

pub trait AnnotationProviderExt: IsA<AnnotationProvider> + 'static {
    #[doc(alias = "gtk_source_annotation_provider_add_annotation")]
    fn add_annotation(&self, annotation: &Annotation) {
        unsafe {
            ffi::gtk_source_annotation_provider_add_annotation(
                self.as_ref().to_glib_none().0,
                annotation.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_annotation_provider_populate_hover_async")]
    fn populate_hover_async<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        annotation: &Annotation,
        display: &HoverDisplay,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn populate_hover_async_trampoline<
            P: FnOnce(Result<(), glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = std::ptr::null_mut();
            ffi::gtk_source_annotation_provider_populate_hover_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = populate_hover_async_trampoline::<P>;
        unsafe {
            ffi::gtk_source_annotation_provider_populate_hover_async(
                self.as_ref().to_glib_none().0,
                annotation.to_glib_none().0,
                display.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    fn populate_hover_future(
        &self,
        annotation: &Annotation,
        display: &HoverDisplay,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        let annotation = annotation.clone();
        let display = display.clone();
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.populate_hover_async(&annotation, &display, Some(cancellable), move |res| {
                send.resolve(res);
            });
        }))
    }

    #[doc(alias = "gtk_source_annotation_provider_remove_all")]
    fn remove_all(&self) {
        unsafe {
            ffi::gtk_source_annotation_provider_remove_all(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_source_annotation_provider_remove_annotation")]
    fn remove_annotation(&self, annotation: &Annotation) -> bool {
        unsafe {
            from_glib(ffi::gtk_source_annotation_provider_remove_annotation(
                self.as_ref().to_glib_none().0,
                annotation.to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v5_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v5_18")))]
    #[doc(alias = "changed")]
    fn connect_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn changed_trampoline<P: IsA<AnnotationProvider>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceAnnotationProvider,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(AnnotationProvider::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"changed".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<AnnotationProvider>> AnnotationProviderExt for O {}
