# Announce: Rakudo compiler, Release #146 (2021.05)

On behalf of the Rakudo development team, I’m very happy to announce the
May 2021 release of Rakudo #146. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2021.05:

  + Additions:
    + Add support for `∊` and `∍` as aliases for `∈` and `∋` [d00c7e35]
  + Changes:
    + Make `lc`, `uc`, `tc`, `tclc`, `fc`, `flip` methods on `Allomorph` return `Str` instance
      to make it consistent on subclassing [bb069a99]
  + Efficiency:
    + Make infix `(elem)` operator about 30x as fast on native arrays [e6a7bfe7]
    + Make `DateTime.posix` about 12x as fast [17c55f3c,ec8b1ae7]
  + Fixes:
    + Fix `$*EXECUTABLE` with non `_m` suffix executables and on Windows with `raku`, `raku-debug`, `rakuw` [b13542e8,a37f9790]
    + Fix copying of empty shaped array [0bf10e26,ede453e1]
    + Fix `substr_rw` method on `Allomorph` [1d8d05f5]
    + Improve error messages text [5c78fb7a,5331a1d8]
  + Internals:
    + Replace use of `P6EX` hllsym with `Metamodel::Configuration.throw_or_die` method [ca2753b7,a524c3de,8427afe9,2c4a0062]
    + Remove special cases for hash constants for JVM [4dab8405]
    + Move opening of standard handles into `Rakudo::Internals` [b1e4350f]
    + Fix a test for reproducible builds [21a60e17]
    + Use "#!/usr/bin/env rakudo" instead of `perl6` in module scripts [adc89e2a]
    + Add tests for REPL correctly handling junctions and incomplete regexes [45e8e8d9,cbf12d22,21100c91]


The following people contributed to this release:

Nicholas Clark, Elizabeth Mattijsen, Stoned Elipot, Christian Bartolomäus,
Stefan Seifert, Daniel Green, Alexander Kiryuhin, Patrick Böker, Vadim Belman,
Will "Coke" Coleda, Juan Julián Merelo Guervós, Tom Browder, Fernando Santagata,
Suman Khanal, karl yerkes, Andreas Voegele, Jonathan Worthington,
Maxim Kolodyazhny, Tony O'Dell, Will Coleda, raydiak, rir

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2021 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#147), is tentatively scheduled for 2021-06-19.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
