% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRupdate.r
\name{LRupdate}
\alias{LRupdate}
\title{LRupdate}
\usage{
LRupdate(fit, anova)
}
\arguments{
\item{fit}{an \code{rms} fit object}

\item{anova}{the result of \code{processMI(..., 'anova')}}
}
\value{
new fit object like \code{fit} but with the substitutions made
}
\description{
Update Model LR Statistics After Multiple Imputation
}
\details{
For fits from \verb{orm, lrm, orm, cph, psm} that were created using \code{fit.mult.impute} with \code{lrt=TRUE} or equivalent options and for which \code{anova} was obtained using \code{processMI(fit, 'anova')} to compute imputation-adjusted LR statistics.  \code{LRupdate} uses the last line of the \code{anova} result (containing the overall model LR chi-square) to update \verb{Model L.R.} in the fit \code{stats} component, and to adjust any of the new R-square measures in \code{stats}.

For models using Nagelkerke's R-squared, these are set to \code{NA} as they would need to be recomputed with a new intercept-only log-likelihood, which is not computed by \code{anova}.  For \code{ols} models, R-squared is left alone as it is sample-size-independent and \code{print.ols} prints the correct adjusted R-squared due to \code{fit.mult.impute} correcting the residual d.f. in stacked fits.
}
\examples{
\dontrun{
a <- aregImpute(~ y + x1 + x2, n.impute=30, data=d)
f <- fit.mult.impute(y ~ x1 + x2, lrm, a, data=d, lrt=TRUE)
a <- processMI(f, 'anova')
f <- LRupdate(f, a)
print(f, r2=1:4)   # print all imputation-corrected R2 measures
}
}
\seealso{
\code{\link[=processMI.fit.mult.impute]{processMI.fit.mult.impute()}}, \code{\link[Hmisc:R2Measures]{Hmisc::R2Measures()}}
}
\author{
Frank Harrell
}
