% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multcompLetters.R
\name{multcompLetters}
\alias{multcompLetters}
\alias{multcompLetters2}
\alias{multcompLetters3}
\alias{multcompLetters4}
\title{Letter summary of similarities and differences}
\usage{
multcompLetters(
  x,
  compare = "<",
  threshold = 0.05,
  Letters = c(letters, LETTERS, "."),
  reversed = FALSE
)

multcompLetters2(formula, x, data, ...)

multcompLetters3(z, y, x, data, ...)

multcompLetters4(object, comp, ...)
}
\arguments{
\item{x}{One of the following: (1) A square, symmetric matrix with row
names.  (2) A vector with hyphenated names, which identify individual items
or factor levels after "strsplit".  (3) An object of class "dist".  If x (or
x[1]) is not already of class "logical", it is replaced with
do.call(compare, list(x, threshold)), which by default converts numbers
(typically p-values) less than 0.05 to TRUE and everything else to FALSE.
If x is a matrix, its diagonal must be or must convert to FALSE.}

\item{compare}{function or binary operator; not used if class(x) is
"logical".}

\item{threshold}{Second (reference) argument to "compare".}

\item{Letters}{Vector of distinct characters (or character strings) used to
connect levels that are not significantly different.  They should be
recogizable when concatonated.  The last element of "Letters" is used as a
prefix for a reuse of "Letters" if more are needed than are provided.  For
example, with the default "Letters", if 53 distinct connection colums are
required, they will be "a", ..., "z", "A", ..., "Z", and ".a".  If 54 are
required, the last one will be ".b".  If 105 are required, the last one will
be "..a", etc.  (If the algorithm generates that many distinct groups, the
display may be too busy to be useful, but the algorithm shouldn't break.)}

\item{reversed}{A logical value indicating whether the order of the letters
should be reversed. Defaults to FALSE.}

\item{formula}{The formula used to make the test (lm, aov, glm, etc.).  Like
y ~ x.}

\item{data}{Data used to make the test.}

\item{...}{Extra arguments passed to multcompLetters.}

\item{z}{Categorical variables used in the test.}

\item{y}{Value of the response variable.}

\item{object}{An object of class aov or lm for the time being.}

\item{comp}{A object with multiple comparison or a function name to perform
a multiple comparison.}
}
\value{
An object of class 'multcompLetters', which is a list with the
following components: \item{Letters }{character vector with names = the
names of the levels or groups compared and with values = character strings
in which common values of the function argument "Letters" identify levels or
groups that are not significantly different (or more precisely for which the
corresponding element of "x" was FALSE or was converted to FALSE by
"compare").  } \item{monospacedLetters }{ Same as "Letters" but with spaces
so the individual grouping letters will line up with a monspaced type font.
} \item{LetterMatrix }{Logical matrix with one row for each level compared
and one column for each "Letter" in the "letter-based representation".  The
output component "Letters" is obtained by concatonating the column names of
all columns with TRUE in that row.  } multcompLetters4 will return a named
list with the terms containing a object of class 'multcompLetters' as
produced by \code{multcompLetters}.
}
\description{
Convert a logical vector or a vector of p-values or a correlation or
distance matrix into a character-based display in which common characters
identify levels or groups that are not significantly different.  Designed
for use with the output of functions like TukeyHSD, diststats, simint,
simtest, csimint, csimtestmultcomp, friedmanmc, kruskalmcpgirmess.
}
\details{
Produces a "Letter-Based Representation of All- Pairwise Comparisons" as
described by Piepho (2004).  (The present algorithm does NOT perform his
"sweeping" step.)  \code{multcompLettersx} are wrapper of multcompLetters
that will reorder the levels of the data so that the letters appear in a
descending order of the mean. \code{mulcompletters3} is similar to
\code{multcompletters2} except that it uses vector names to separte and the
later has an formula interface. \code{multcompLetters4} will take a aov or
lm object and a comparison test and will produce all the letters for the
terms and interactions.
}
\section{Functions}{
\itemize{
\item \code{multcompLetters2()}: 

\item \code{multcompLetters3()}: create a compact letters display and order the 
letters

\item \code{multcompLetters4()}: create a compact letters display using a aov object

}}
\examples{

##
## 1.  a logical vector indicating signficant differences
##
dif3 <- c(FALSE, FALSE, TRUE)
names(dif3) <- c("A-B", "A-C", "B-C")
dif3L <- multcompLetters(dif3)
dif3L
print(dif3L)
print(dif3L, TRUE)

##
## 2.  numeric vector indicating statistical significance
##
dif4 <- c(.01, .02, .03, 1)
names(dif4) <- c("a-b", "a-c", "b-d", "a-d")
(diff4.T <- multcompLetters(dif4))

(dif4.L1 <- multcompLetters(dif4,
       Letters=c("*", ".")))
# "Letters" can be any character strings,
# but they should be recognizable when
# concatonated.

##
## 3.  distance matrix
##
dJudge <- dist(USJudgeRatings)
dJl <- multcompLetters(dJudge, compare='>', threshold = median(dJudge))
# comparison of 43 judges;  compact but undecipherable:
dJl

x <- array(1:9, dim=c(3,3),
   dimnames=list(LETTERS[1:3], NULL) )
d3 <- dist(x)
dxLtrs <- multcompLetters(d3, compare=">", threshold=2)

d3d <- dist(x, diag=TRUE)
dxdLtrs <- multcompLetters(d3d, compare=">", threshold=2)

\dontshow{stopifnot(}
all.equal(dxLtrs, dxdLtrs)
\dontshow{)}

d3u <- dist(x, upper=TRUE)
dxuLtrs <- multcompLetters(d3d, compare=">", threshold=2)

\dontshow{stopifnot(}
all.equal(dxLtrs, dxuLtrs)
\dontshow{)}

##
## 4.  cor matrix
##
set.seed(4)
x100 <- matrix(rnorm(100), ncol=5,
               dimnames=list(NULL, LETTERS[1:5]) )
cx <- cor(x100)
cxLtrs <- multcompLetters(abs(cx), threshold=.3)


##
##5. reversed
##

dif3 <- c(FALSE, FALSE, TRUE)
names(dif3) <- c("A-B", "A-C", "B-C")
dif3L <- multcompLetters(dif3)
dif3L.R <- multcompLetters(dif3, rev = TRUE)
dif3L
dif3L.R


##
##6. multcompletters2 usage

experiment <- data.frame(treatments = gl(11, 20, labels = c("dtl", "ctrl", "treat1", 
              "treat2", "treatA2", "treatB", "treatB2",
              "treatC", "treatD", "treatA1", "treatX")),
              y = c(rnorm(20, 10, 5), rnorm(20, 20, 5), rnorm(20, 22, 5), rnorm(20, 24, 5),
               rnorm(20, 35, 5), rnorm(20, 37, 5), rnorm(20, 40, 5), rnorm(20, 43, 5),
               rnorm(20, 45, 5), rnorm(20, 60, 5), rnorm(20, 60, 5)))
exp_tukey <- TukeyHSD(exp_aov <- aov(y  ~ treatments, data = experiment))
exp_letters1 <- multcompLetters(exp_tukey$treatments[,4])
exp_letters1
#Notice lowest mean treatments gets a "e"
#Ordered letters
multcompLetters2(y ~ treatments, exp_tukey$treatments[,"p adj"], experiment)
multcompLetters2(y ~ treatments, exp_tukey$treatments[,"p adj"], experiment, reversed = TRUE)

##7. multcompletters3 usage

multcompLetters3("treatments", "y", exp_tukey$treatments[,"p adj"], experiment)

##8. multcompletters4 usage


multcompLetters4(exp_aov, exp_tukey)


}
\references{
Piepho, Hans-Peter (2004) "An Algorithm for a Letter-Based
Representation of All-Pairwise Comparisons", Journal of Computational and
Graphical Statistics, 13(2)456-466.
}
\seealso{
\code{\link{multcompBoxplot}} \code{\link{plot.multcompLetters}}
\code{\link{print.multcompLetters}} \code{\link{multcompTs}}
\code{\link{vec2mat}}
}
\author{
Spencer Graves, Hans-Peter Piepho and Luciano Selzer
}
\keyword{dplot}
