% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrc.R
\name{setLimits}
\alias{setLimits}
\title{Set security limits}
\usage{
setLimits(
  maxCon = NULL,
  storageSize = NULL,
  storedMsg = NULL,
  varSize = NULL,
  msgPerSec = NULL,
  msgSize = NULL,
  bytesPerSec = NULL
)
}
\arguments{
\item{maxCon}{Maximal allowed number of web socket connections simultaneously. A new
connection is established whenever someone requests an HTML page from the server
or when the \code{openPage} method of class \code{\link{App}} is used. If number of
the allowed connections is reached the newly opened web socked will be immediately
closed and the user will see a warning.}

\item{storageSize}{Maximal total size of all stored messages in bytes.}

\item{storedMsg}{Maximal number of messages that can be stored simultaneously.}

\item{varSize}{Maximal size of a variable that can be received from a web page. 
Attempt to assign data of larger size to a variable will be ignored.}

\item{msgPerSec}{Maximal number of messages that can be received per second. 
All extra messages will be disposed of immediately without any attempt to 
process their content.}

\item{msgSize}{Maximal allowed size of a message in bytes. Note, that here a
size of character string that contains all the received information is estimated.
All larger messages will be ignored.}

\item{bytesPerSec}{Number of bytes that can be received per second. After the 
limit is reached, all the incoming messages will be ignored.}
}
\description{
This function allows to control memory usage and limit number of messages processed per
second or simultaneously active connections to the app. 
 
If an app is deployed on a server and is publicly available, it may be useful to limit
resources that are available to each user. There are various things that can be
controlled by this function: storage size and number of stored messages, 
maximal variable size, number of messages processed per second and bytes received
per second.
 
Messages are all the communication received via web socket from an opened web page.
Each message contains a command that is to be evaluated in the R session, name
of a function to call or variable to store. If number or size of messages exceeds
the preset limit, they are completely ignored by the app.
}
\details{
For security reasons, some messages has to be first authorized by the 
\code{\link{authorize}} function, before they can be processed. Such messages
are saved until they are manually removed or authorized. If number or total 
size of the stored messages exceeds the limits, new messages are still saved, 
but the older ones are removed from the memory. If storage size is set to zero
no messages can be stored and every message that requires authorization will 
be automatically discarded.

Size of variables or messages is estimated in \code{\link[utils]{object.size}}
and is always measured in byte.

The limits are set for the entire app and are applied for each new connection.
One can also change security limits for any connection separately by using
method \code{setLimits} of a corresponding object of class \code{\link{Session}}.

This function is a wrapper for method \code{setLimits} of class \code{\link{App}}.
}
\examples{
\donttest{
openPage()
setLimits(maxCon = 10)
setLimits(varSize = 10 * 1024^2)
closePage()}

}
\seealso{
\code{\link{authorize}}, \code{\link{allowFunctions}}, \code{\link{allowVariables}}.
}
