# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.apimanagement.aio import ApiManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApiManagementTenantConfigurationOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApiManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_tenant_configuration_begin_deploy(self, resource_group):
        response = await (
            await self.client.tenant_configuration.begin_deploy(
                resource_group_name=resource_group.name,
                service_name="str",
                configuration_name="str",
                parameters={"branch": "str", "force": bool},
                api_version="2024-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_tenant_configuration_begin_save(self, resource_group):
        response = await (
            await self.client.tenant_configuration.begin_save(
                resource_group_name=resource_group.name,
                service_name="str",
                configuration_name="str",
                parameters={"branch": "str", "force": bool},
                api_version="2024-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_tenant_configuration_begin_validate(self, resource_group):
        response = await (
            await self.client.tenant_configuration.begin_validate(
                resource_group_name=resource_group.name,
                service_name="str",
                configuration_name="str",
                parameters={"branch": "str", "force": bool},
                api_version="2024-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_tenant_configuration_get_sync_state(self, resource_group):
        response = await self.client.tenant_configuration.get_sync_state(
            resource_group_name=resource_group.name,
            service_name="str",
            configuration_name="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...
