# mypy: allow-untyped-defs
"""
Fully populated mypy stub for M2Crypto's C bindings (_m2crypto)
Generated based on _m2crypto_wrap.c
"""

from typing import Any, Callable, List, Optional, Tuple, overload

# char * is str and it is for string constants only; NO R/W!

from M2Crypto import ASN1, BIO, types as C

# --- Constants ---

OPENSSL_VERSION_NUMBER: int
bio_close: int
bio_noclose: int
encrypt: int
decrypt: int
no_padding: int
pkcs1_padding: int
pkcs1_oaep_padding: int
sslv2_padding: int

# PKCS7 flags
PKCS7_BINARY: int
PKCS7_NOCERTS: int
PKCS7_NOCHAIN: int
PKCS7_NOINTERN: int
PKCS7_NOSIGS: int
PKCS7_NOVERIFY: int
PKCS7_TEXT: int
PKCS7_DETACHED: int
PKCS7_NOATTR: int
PKCS7_SIGNED: int
PKCS7_ENVELOPED: int
PKCS7_SIGNED_ENVELOPED: int
PKCS7_DATA: int
PKCS5_SALT_LEN: int

# SSL verify modes
SSL_VERIFY_NONE: int
SSL_VERIFY_PEER: int
SSL_VERIFY_FAIL_IF_NO_PEER_CERT: int
SSL_VERIFY_CLIENT_ONCE: int

# SSL options
SSL_OP_ALL: int
SSL_OP_NO_SSLv2: int
SSL_OP_NO_SSLv3: int
SSL_OP_NO_TLSv1: int

# SSL state flags
SSL_ST_CONNECT: int
SSL_ST_ACCEPT: int
SSL_ST_MASK: int
SSL_ST_INIT: int
SSL_ST_BEFORE: int
SSL_ST_OK: int
SSL_ST_RENEGOTIATE: int

# SSL callback flags
SSL_CB_LOOP: int
SSL_CB_EXIT: int
SSL_CB_READ: int
SSL_CB_WRITE: int
SSL_CB_ALERT: int
SSL_CB_READ_ALERT: int
SSL_CB_WRITE_ALERT: int
SSL_CB_ACCEPT_LOOP: int
SSL_CB_ACCEPT_EXIT: int
SSL_CB_CONNECT_LOOP: int
SSL_CB_CONNECT_EXIT: int
SSL_CB_HANDSHAKE_START: int
SSL_CB_HANDSHAKE_DONE: int

SSL_SENT_SHUTDOWN: int
SSL_RECEIVED_SHUTDOWN: int

# DH Generators
DH_GENERATOR_2: int
DH_GENERATOR_5: int

# EC constants
NID_secp112r1: int
NID_secp112r2: int
NID_secp128r1: int
NID_secp128r2: int
NID_secp160k1: int
NID_secp160r1: int
NID_secp160r2: int
NID_secp192k1: int
NID_secp224k1: int
NID_secp224r1: int
NID_secp256k1: int
NID_secp384r1: int
NID_secp521r1: int
NID_sect113r1: int
NID_sect113r2: int
NID_sect131r1: int
NID_sect131r2: int
NID_sect163k1: int
NID_sect163r1: int
NID_sect163r2: int
NID_sect193r1: int
NID_sect193r2: int
NID_sect233k1: int
NID_sect233r1: int
NID_sect239k1: int
NID_sect283k1: int
NID_sect283r1: int
NID_sect409k1: int
NID_sect409r1: int
NID_sect571k1: int
NID_sect571r1: int
NID_X9_62_prime192v1: int
NID_X9_62_prime192v2: int
NID_X9_62_prime192v3: int
NID_X9_62_prime239v1: int
NID_X9_62_prime239v2: int
NID_X9_62_prime239v3: int
NID_X9_62_prime256v1: int
NID_X9_62_c2pnb163v1: int
NID_X9_62_c2pnb163v2: int
NID_X9_62_c2pnb163v3: int
NID_X9_62_c2pnb176v1: int
NID_X9_62_c2tnb191v1: int
NID_X9_62_c2tnb191v2: int
NID_X9_62_c2tnb191v3: int
NID_X9_62_c2pnb208w1: int
NID_X9_62_c2tnb239v1: int
NID_X9_62_c2tnb239v2: int
NID_X9_62_c2tnb239v3: int
NID_X9_62_c2pnb272w1: int
NID_X9_62_c2pnb304w1: int
NID_X9_62_c2tnb359v1: int
NID_X9_62_c2pnb368w1: int
NID_X9_62_c2tnb431r1: int
NID_wap_wsg_idm_ecid_wtls1: int
NID_wap_wsg_idm_ecid_wtls3: int
NID_wap_wsg_idm_ecid_wtls4: int
NID_wap_wsg_idm_ecid_wtls5: int
NID_wap_wsg_idm_ecid_wtls6: int
NID_wap_wsg_idm_ecid_wtls7: int
NID_wap_wsg_idm_ecid_wtls8: int
NID_wap_wsg_idm_ecid_wtls9: int
NID_wap_wsg_idm_ecid_wtls10: int
NID_wap_wsg_idm_ecid_wtls11: int
NID_wap_wsg_idm_ecid_wtls12: int
NID_ipsec3: int
NID_ipsec4: int

# X509 constants
NID_commonName: int
NID_countryName: int
NID_localityName: int
NID_stateOrProvinceName: int
NID_organizationName: int
NID_organizationalUnitName: int
NID_serialNumber: int
NID_surname: int
NID_givenName: int
NID_pkcs9_emailAddress: int

X509_V_OK: int
X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT: int
X509_V_ERR_UNABLE_TO_GET_CRL: int
X509_V_ERR_UNABLE_TO_DECRYPT_CERT_SIGNATURE: int
X509_V_ERR_UNABLE_TO_DECRYPT_CRL_SIGNATURE: int
X509_V_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY: int
X509_V_ERR_CERT_SIGNATURE_FAILURE: int
X509_V_ERR_CRL_SIGNATURE_FAILURE: int
X509_V_ERR_CERT_NOT_YET_VALID: int
X509_V_ERR_CERT_HAS_EXPIRED: int
X509_V_ERR_CRL_NOT_YET_VALID: int
X509_V_ERR_CRL_HAS_EXPIRED: int
X509_V_ERR_ERROR_IN_CERT_NOT_BEFORE_FIELD: int
X509_V_ERR_ERROR_IN_CERT_NOT_AFTER_FIELD: int
X509_V_ERR_ERROR_IN_CRL_LAST_UPDATE_FIELD: int
X509_V_ERR_ERROR_IN_CRL_NEXT_UPDATE_FIELD: int
X509_V_ERR_OUT_OF_MEM: int
X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT: int
X509_V_ERR_SELF_SIGNED_CERT_IN_CHAIN: int
X509_V_ERR_UNABLE_TO_GET_ISSUER_CERT_LOCALLY: int
X509_V_ERR_UNABLE_TO_VERIFY_LEAF_SIGNATURE: int
X509_V_ERR_CERT_CHAIN_TOO_LONG: int
X509_V_ERR_CERT_REVOKED: int
X509_V_ERR_INVALID_CA: int
X509_V_ERR_PATH_LENGTH_EXCEEDED: int
X509_V_ERR_INVALID_PURPOSE: int
X509_V_ERR_CERT_UNTRUSTED: int
X509_V_ERR_CERT_REJECTED: int
X509_V_ERR_APPLICATION_VERIFICATION: int
VERIFY_ALLOW_PROXY_CERTS: int
VERIFY_CB_ISSUER_CHECK: int
VERIFY_CHECK_SS_SIGNATURE: int
VERIFY_CRL_CHECK: int
VERIFY_CRL_CHECK_ALL: int
VERIFY_CRL_CHECK_CHAIN: int
VERIFY_CRL_CHECK_LEAF: int
VERIFY_EXPLICIT_POLICY: int
VERIFY_EXTENDED_CRL_SUPPORT: int
VERIFY_IGNORE_CRITICAL: int
VERIFY_INHIBIT_ANY: int
VERIFY_INHIBIT_MAP: int
VERIFY_NO_ALT_CHAINS: int
VERIFY_NO_CHECK_TIME: int
VERIFY_NOTIFY_POLICY: int
VERIFY_PARTIAL_CHAIN: int
VERIFY_POLICY_CHECK: int
VERIFY_TRUSTED_FIRST: int
VERIFY_USE_DELTAS: int
VERIFY_X509_STRICT: int
XN_FLAG_COMPAT: int
XN_FLAG_SEP_COMMA_PLUS: int
XN_FLAG_SEP_CPLUS_SPC: int
XN_FLAG_SEP_MULTILINE: int
XN_FLAG_DN_REV: int
XN_FLAG_FN_LN: int
XN_FLAG_SPC_EQ: int
XN_FLAG_DUMP_UNKNOWN_FIELDS: int
XN_FLAG_FN_ALIGN: int
XN_FLAG_ONELINE: int
XN_FLAG_MULTILINE: int
XN_FLAG_RFC2253: int
RSA_3: int
RSA_F4: int

# --- Library Initialization and Utility Functions ---

def lib_init() -> None: ...
def time_t_bits() -> int: ...
def threading_init() -> None: ...
def threading_cleanup() -> None: ...

# --- Error Handling ---

def err_print_errors(bio: C.BIO) -> None: ...
def err_clear_error() -> None: ...
def err_get_error() -> int: ...
def err_peek_error() -> int: ...
def err_lib_error_string(err: int) -> str: ...
def err_func_error_string(err: int) -> str: ...
def err_reason_error_string(err: int) -> str: ...
def x509_get_verify_error(err: int) -> str: ...

# --- ASN.1 Functions ---

def asn1_integer_new() -> C.ASN1_Integer: ...
def asn1_integer_cmp(a1: C.ASN1_Integer, a2: C.ASN1_Integer) -> int: ...
def asn1_integer_free(a: C.ASN1_Integer) -> None: ...
def asn1_integer_get(a: C.ASN1_Integer) -> Optional[int]: ...
def asn1_integer_set(a: C.ASN1_Integer, v: int) -> int: ...
def asn1_string_new() -> C.ASN1_String: ...
def asn1_string_free(a: C.ASN1_String) -> None: ...
def asn1_string_print(out: C.BIO, s: C.ASN1_String) -> int: ...
def asn1_string_print_ex(out: C.BIO, s: C.ASN1_String, flags: int) -> int: ...
def asn1_string_set(s: C.ASN1_String, data: bytes) -> int: ...
def asn1_time_free(a: C.ASN1_Time) -> None: ...
def asn1_time_new() -> C.ASN1_Time: ...
def asn1_time_print(out: C.BIO, s: C.ASN1_Time) -> int: ...
def asn1_time_set(a: C.ASN1_Time, t: int) -> C.ASN1_Time: ...
def asn1_time_set_string(a: C.ASN1_Time, s: str) -> int: ...
def asn1_time_type_check(a: C.ASN1_Time) -> int: ...
def asn1_object_free(a: C.ASN1_Object) -> None: ...

# --- BIO (Basic I/O) Functions ---
def bio_ctrl_get_write_guarantee(b: C.BIO) -> int: ...
def bio_ctrl_pending(b: C.BIO) -> int: ...
def bio_ctrl_wpending(b: C.BIO) -> int: ...
def bio_do_handshake(b: C.BIO) -> int: ...
def bio_eof(b: C.BIO) -> int: ...
def bio_f_buffer() -> C.BIO_METHOD: ...
def bio_f_cipher() -> C.BIO_METHOD: ...
def bio_flush(b: C.BIO) -> int: ...
def bio_free_all(b: C.BIO) -> None: ...
def bio_free(b: C.BIO) -> int: ...
def bio_f_ssl() -> C.BIO_METHOD: ...
def bio_get_fd(b: C.BIO) -> int: ...
def bio_gets(b: C.BIO, size: int) -> bytes: ...
def bio_init(err: Any) -> None: ...
def bio_new_file(filename: str, mode: str) -> C.BIO: ...
def bio_new(method: C.BIO_METHOD) -> C.BIO: ...
def bio_new_pyfile(pyfile: Any, close_on_del: int) -> C.BIO: ...
def bio_new_socket(sock: int, close_flag: int) -> C.BIO: ...
def bio_pop(b: C.BIO) -> C.BIO: ...
def bio_push(b: C.BIO, append: C.BIO) -> C.BIO: ...
def bio_read(b: C.BIO, size: int) -> bytes: ...
def bio_reset(b: C.BIO) -> int: ...
def bio_seek(b: C.BIO, offset: int) -> int: ...
def bio_set_cipher(
    b: C.BIO, c: C.EVP_CIPHER, key: bytes, iv: bytes, op: int
) -> None: ...
def bio_set_flags(b: C.BIO, flags: int) -> None: ...
def bio_set_mem_eof_return(b: C.BIO, v: int) -> int: ...
def bio_set_ssl(b: C.BIO, ssl: C.SSL, flag: int) -> int: ...
def bio_set_write_buf_size(b: C.BIO, size: int) -> int: ...
def bio_should_read(b: C.BIO) -> int: ...
def bio_should_retry(b: C.BIO) -> int: ...
def bio_should_write(b: C.BIO) -> int: ...
def bio_s_mem() -> C.BIO_METHOD: ...
def bio_s_socket() -> C.BIO_METHOD: ...
def bio_write(b: C.BIO, data: bytes) -> int: ...

# --- Big Number (BIGNUM) Functions ---
def bn_to_mpi(bn: C.BIGNUM) -> bytes: ...
def mpi_to_bn(s: bytes) -> C.BIGNUM: ...
def bn_to_bin(bn: C.BIGNUM) -> bytes: ...
def bin_to_bn(s: bytes) -> C.BIGNUM: ...
def bn_to_hex(bn: C.BIGNUM) -> str: ...
def hex_to_bn(s: str) -> C.BIGNUM: ...
def dec_to_bn(s: str) -> C.BIGNUM: ...
def bn_rand(bits: int, top: int, bottom: int) -> int: ...
def bn_rand_range(range_bn: int) -> int: ...

# --- DH (Diffie-Hellman) Functions ---
def dh_compute_key(dh: C.DH, pubkey: bytes) -> bytes: ...
def dh_free(dh: C.DH) -> None: ...
def dh_generate_key(dh: C.DH) -> int: ...
def dh_generate_parameters(
    plen: int, g: int, pyfunc: Callable[[int, int], int]
) -> C.DH: ...
def dh_check(dh: C.DH) -> int: ...
def dh_init(err: Any) -> None: ...
def dh_new() -> C.DH: ...
def dhparams_print(bio: C.BIO, dh: C.DH) -> int: ...
def dh_read_parameters(bio: C.BIO) -> Optional[C.DH]: ...
def dh_set_pg(dh: C.DH, p: bytes, g: bytes) -> int: ...
def dh_size(dh: C.DH) -> int: ...
def dh_type_check(dh: C.DH) -> int: ...

# --- DSA Functions ---
def dsa_free(dsa: C.DSA) -> None: ...
def dsa_generate_key(dsa: C.DSA) -> int: ...
def dsa_generate_parameters(bits: int, pyfunc: Callable[[int, int], int]) -> C.DSA: ...
def dsa_gen_key(dsa: C.DSA) -> int: ...
def dsa_check_pub_key(dsa: C.DSA) -> int: ...
def dsa_init(err: Any) -> None: ...
def dsa_keylen(dsa: C.DSA) -> int: ...
def dsa_new() -> C.DSA: ...
def dsa_read_key(
    bio: C.BIO, pyfunc: Optional[Callable[[int], bytes]] = None
) -> Optional[C.DSA]: ...
def dsa_read_params(
    bio: C.BIO, pyfunc: Optional[Callable[[int], bytes]] = None
) -> Optional[C.DSA]: ...
def dsa_read_pub_key(
    bio: C.BIO, pyfunc: Optional[Callable[[int], bytes]] = None
) -> Optional[C.DSA]: ...
def dsa_set_pqg(dsa: C.DSA, p: bytes, q: bytes, g: bytes) -> int: ...
def dsa_set_pub(dsa: C.DSA, pub_key: bytes) -> int: ...
def dsa_sign_asn1(dsa: C.DSA, data: bytes) -> bytes: ...
def dsa_sign(dsa: C.DSA, data: bytes) -> Tuple[bytes, bytes]: ...
def dsa_type_check(dsa: C.DSA) -> int: ...
def dsa_verify_asn1(dsa: C.DSA, data: bytes, sig: bytes) -> int: ...
def dsa_verify(dsa: C.DSA, data: bytes, r: bytes, s: bytes) -> int: ...
def dsa_write_key_bio(
    dsa: C.DSA,
    bio: C.BIO,
    cipher: Optional[C.EVP_CIPHER],
    pyfunc: Callable[[int], bytes],
) -> int: ...
def dsa_write_key_bio_no_cipher(
    dsa: C.DSA, bio: C.BIO, pyfunc: Callable[[int], bytes]
) -> int: ...
def dsa_write_params_bio(dsa: C.DSA, bio: C.BIO) -> int: ...
def dsa_write_pub_key_bio(dsa: C.DSA, bio: C.BIO) -> int: ...

# --- EC (Elliptic Curve) Functions ---
def ecdh_compute_key(keypairA: C.EC_KEY, pubkeyB: C.EC_KEY) -> bytes: ...
def ecdsa_sign_asn1(key: C.EC_KEY, data: bytes) -> bytes: ...
def ecdsa_sign(key: C.EC_KEY, data: bytes) -> Tuple[bytes, bytes]: ...
def ecdsa_verify_asn1(key: C.EC_KEY, data: bytes, sig: bytes) -> int: ...
def ecdsa_verify(key: C.EC_KEY, data: bytes, r: bytes, s: bytes) -> int: ...
def ec_get_builtin_curves() -> List[Any]: ...
def ec_init(err: Any) -> None: ...
def ec_key_free(key: C.EC_KEY) -> None: ...
def ec_key_from_pubkey_der(pubkey: bytes) -> C.EC_KEY: ...
def ec_key_from_pubkey_params(nid: int, pubkey: bytes) -> C.EC_KEY: ...
def ec_key_gen_key(key: C.EC_KEY) -> int: ...
def ec_key_get_public_der(key: C.EC_KEY) -> bytes: ...
def ec_key_get_public_key(key: C.EC_KEY) -> bytes: ...
def ec_key_check_key(key: C.EC_KEY) -> int: ...
def ec_key_keylen(key: C.EC_KEY) -> int: ...
def ec_key_new_by_curve_name(nid: int) -> C.EC_KEY: ...
def ec_key_new() -> C.EC_KEY: ...
def ec_key_read_bio(
    bio: C.BIO, pyfunc: Optional[Callable[[int], bytes]] = None
) -> Optional[C.EC_KEY]: ...
def ec_key_read_pubkey(bio: C.BIO) -> Optional[C.EC_KEY]: ...
def ec_key_type_check(key: C.EC_KEY) -> int: ...
def ec_key_write_bio(
    key: C.EC_KEY,
    bio: C.BIO,
    cipher: Optional[C.EVP_CIPHER],
    pyfunc: Callable[[int], bytes],
) -> int: ...
def ec_key_write_bio_no_cipher(
    key: C.EC_KEY, bio: C.BIO, pyfunc: Callable[[int], bytes]
) -> int: ...
def ec_key_write_pubkey(key: C.EC_KEY, bio: C.BIO) -> int: ...

# --- EVP (High-level Crypto) Functions ---
def aes_128_cbc() -> C.EVP_CIPHER: ...
def aes_192_cbc() -> C.EVP_CIPHER: ...
def aes_256_cbc() -> C.EVP_CIPHER: ...
def bf_cbc() -> C.EVP_CIPHER: ...
def bytes_to_key(
    cipher: C.EVP_CIPHER,
    md: C.EVP_MD,
    data: bytes,
    salt: Optional[bytes],
    iv: Any,
    iter: int,
) -> bytes: ...
def cast5_cbc() -> C.EVP_CIPHER: ...
def cipher_ctx_free(ctx: C.EVP_CIPHER_CTX) -> None: ...
def cipher_ctx_new() -> C.EVP_CIPHER_CTX: ...
def cipher_final(ctx: C.EVP_CIPHER_CTX) -> bytes: ...
def cipher_init(
    ctx: C.EVP_CIPHER_CTX,
    cipher: C.EVP_CIPHER,
    key: Optional[bytes],
    iv: Optional[bytes],
    op: int,
) -> None: ...
def cipher_set_padding(ctx: C.EVP_CIPHER_CTX, padding: int) -> int: ...
def cipher_update(ctx: C.EVP_CIPHER_CTX, data: bytes) -> bytes: ...
def des_cbc() -> C.EVP_CIPHER: ...
def des_ecb() -> C.EVP_CIPHER: ...
def des_ede_cbc() -> C.EVP_CIPHER: ...
def des_ede3_cbc() -> C.EVP_CIPHER: ...
def digest_final(ctx: C.EVP_MD_CTX) -> bytes: ...
def digest_init(ctx: C.EVP_MD_CTX, md: C.EVP_MD) -> int: ...
def digest_sign(ctx: C.EVP_MD_CTX, msg: bytes) -> bytes: ...
def digest_sign_final(ctx: C.EVP_MD_CTX) -> bytes: ...
@overload
def digest_sign_init(ctx: C.EVP_MD_CTX, pkey: C.EVP_PKEY) -> int: ...
@overload
def digest_sign_init(
    ctx: C.EVP_MD_CTX,
    pctx: Optional[C.EVP_PKEY_CTX],
    md: C.EVP_MD,
    e: Optional[C.ENGINE],
    pkey: C.EVP_PKEY,
) -> int: ...
def digest_sign_update(ctx: C.EVP_MD_CTX, data: bytes) -> None: ...
def digest_update(ctx: C.EVP_MD_CTX, data: bytes) -> int: ...
def digest_verify(ctx: C.EVP_MD_CTX, sig: bytes, msg: bytes) -> int: ...
def digest_verify_final(ctx: C.EVP_MD_CTX, sig: bytes) -> int: ...
@overload
def digest_verify_init(ctx: C.EVP_MD_CTX, pkey: C.EVP_PKEY) -> int: ...
@overload
def digest_verify_init(
    ctx: C.EVP_MD_CTX,
    pctx: Optional[C.EVP_PKEY_CTX],
    md: C.EVP_MD,
    e: Optional[C.ENGINE],
    pkey: C.EVP_PKEY,
) -> int: ...
def digest_verify_update(ctx: C.EVP_MD_CTX, data: bytes) -> int: ...
def evp_init(err: Any) -> None: ...
def get_digestbyname(name: str) -> Optional[C.EVP_MD]: ...
def hmac_ctx_free(ctx: C.HMAC_CTX) -> None: ...
def hmac_ctx_new() -> C.HMAC_CTX: ...
def hmac_final(ctx: C.HMAC_CTX) -> bytes: ...
def hmac_init(ctx: C.HMAC_CTX, key: bytes, md: C.EVP_MD) -> None: ...
def hmac(key: bytes, data: bytes, md: C.EVP_MD) -> bytes: ...
def hmac_update(ctx: C.HMAC_CTX, data: bytes) -> None: ...
def md_ctx_free(ctx: C.EVP_MD_CTX) -> None: ...
def md_ctx_new() -> C.EVP_MD_CTX: ...
def md5() -> C.EVP_MD: ...
def pkcs5_pbkdf2_hmac_sha1(
    password: bytes, salt: bytes, iterations: int, key_len: int
) -> bytes: ...
def pkey_as_der(pkey: C.EVP_PKEY) -> bytes: ...
def pkey_assign_ec(pkey: C.EVP_PKEY, ec: C.EC_KEY) -> int: ...
def pkey_assign_rsa(pkey: C.EVP_PKEY, rsa: C.RSA) -> int: ...
def pkey_free(pkey: C.EVP_PKEY) -> None: ...
def pkey_get_modulus(pkey: C.EVP_PKEY) -> bytes: ...
def pkey_get_raw_pub_key_sha1(pkey: C.EVP_PKEY) -> bytes: ...
def pkey_get1_ec(pkey: C.EVP_PKEY) -> Optional[C.EC_KEY]: ...
def pkey_get1_rsa(pkey: C.EVP_PKEY) -> Optional[C.RSA]: ...
def pkey_new() -> C.EVP_PKEY: ...
def pkey_read_pem(bio: C.BIO, pyfunc: Callable[[], bytes]) -> C.EVP_PKEY: ...
def pkey_read_pem_pubkey(bio: C.BIO, pyfunc: Callable[[], bytes]) -> C.EVP_PKEY: ...
def pkey_set1_ec(pkey: C.EVP_PKEY, ec: C.EC_KEY) -> int: ...
def pkey_set1_rsa(pkey: C.EVP_PKEY, rsa: C.RSA) -> int: ...
def pkey_size(pkey: C.EVP_PKEY) -> int: ...
def pkey_write_pem_no_cipher(
    pkey: C.EVP_PKEY, bio: C.BIO, pyfunc: Callable[[], bytes]
) -> int: ...
def pkey_write_pem(
    pkey: C.EVP_PKEY, bio: C.BIO, cipher: C.EVP_CIPHER, pyfunc: Callable[[], bytes]
) -> int: ...
def rc2_40_cbc() -> C.EVP_CIPHER: ...
def rc4() -> C.EVP_CIPHER: ...
def ripemd160() -> C.EVP_MD: ...
def sha1() -> C.EVP_MD: ...
def sha224() -> C.EVP_MD: ...
def sha256() -> C.EVP_MD: ...
def sha384() -> C.EVP_MD: ...
def sha512() -> C.EVP_MD: ...
def sign_final(ctx: C.EVP_MD_CTX, pkey: C.EVP_PKEY) -> bytes: ...
def sign_init(ctx: C.EVP_MD_CTX, md: C.EVP_MD) -> int: ...
def sign_update(ctx: C.EVP_MD_CTX, data: bytes) -> None: ...
def verify_final(ctx: C.EVP_MD_CTX, sig: bytes, pkey: C.EVP_PKEY) -> int: ...
def verify_init(ctx: C.EVP_MD_CTX, md: C.EVP_MD) -> int: ...
def verify_update(ctx: C.EVP_MD_CTX, data: bytes) -> int: ...

# --- Misc Utility Functions ---
def util_init(err: Any) -> None: ...
def util_hex_to_string(data: bytes) -> str: ...
def util_string_to_hex(data: str) -> bytes: ...
def obj_obj2txt(obj: C.ASN1_Object, no_name: int) -> str: ...
def obj_ln2nid(ln: str) -> int: ...
def obj_nid2sn(nid: int) -> str: ...
def obj_sn2nid(sn: str) -> int: ...
def obj_txt2nid(txt: str) -> int: ...

# --- RSA ---
def rsa_init(err: Any) -> None: ...
def rsa_new() -> C.RSA: ...
def rsa_generate_key(
    bits: int, e: int, callback: Callable[[int, int], int]
) -> C.RSA: ...
def rsa_free(rsa: C.RSA) -> None: ...
def rsa_get_e(rsa: C.RSA) -> bytes: ...
def rsa_get_ex_data(rsa: C.RSA, index: int) -> Any: ...
def rsa_get_n(rsa: C.RSA) -> bytes: ...
def rsa_check_key(rsa: C.RSA) -> int: ...
def rsa_check_pub_key(rsa: C.RSA) -> int: ...
def rsa_padding_add_pkcs1_pss(
    rsa: C.RSA, digest: bytes, hash_obj: C.EVP_MD, salt_length: int
) -> bytes: ...
def rsa_private_decrypt(rsa: C.RSA, data: bytes, padding: int) -> Optional[bytes]: ...
def rsa_private_encrypt(rsa: C.RSA, data: bytes, padding: int) -> bytes: ...
def rsa_public_decrypt(rsa: C.RSA, data: bytes, padding: int) -> Optional[bytes]: ...
def rsa_public_encrypt(rsa: C.RSA, data: bytes, padding: int) -> bytes: ...
def rsa_read_key(bio: C.BIO, pyfunc: Callable[[int], bytes]) -> C.RSA: ...
def rsa_read_pub_key(bio: C.BIO) -> C.RSA: ...
def rsa_set_en(rsa: C.RSA, e: bytes, n: bytes) -> None: ...
def rsa_set_ex_data(rsa: C.RSA, index: int, data: Any) -> int: ...
def rsa_sign(rsa: C.RSA, digest: bytes, method_type: int) -> bytes: ...
def rsa_size(rsa: C.RSA) -> int: ...
def rsa_type_check(rsa: C.RSA) -> int: ...
def rsa_write_key(
    rsa: C.RSA, bio: C.BIO, cipher: C.EVP_CIPHER, pyfunc: Callable[[int], bytes]
) -> int: ...
def rsa_write_key_no_cipher(
    rsa: C.RSA, bio: C.BIO, pyfunc: Callable[[int], bytes]
) -> int: ...
def rsa_verify_pkcs1_pss(
    rsa: C.RSA, digest: bytes, signature: bytes, hash_obj: C.EVP_MD, salt_length: int
) -> int: ...
def rsa_verify(
    rsa: C.RSA, digest: bytes, signature: bytes, method_type: int
) -> int: ...
def rsa_write_key_der(rsa: C.RSA, bio: C.BIO) -> int: ...
def rsa_write_pub_key(rsa: C.RSA, bio: C.BIO) -> int: ...

# --- RC4 ---
def rc4_new() -> C.RC4_KEY: ...
def rc4_free(key: C.RC4_KEY) -> None: ...
def rc4_set_key(key: C.RC4_KEY, data: bytes) -> None: ...
def rc4_update(key: C.RC4_KEY, data: bytes) -> bytes: ...

# --- SSL / TLS ---
def i2d_ssl_session(bio: C.BIO, sess: C.SSL_SESSION) -> None: ...
def sk_ssl_cipher_num(stack: C.STACK_OF_SSL_CIPHER) -> int: ...
def sk_ssl_cipher_value(stack: C.STACK_OF_SSL_CIPHER, idx: int) -> C.SSL_CIPHER: ...
def ssl_accept(ssl: C.SSL, timeout: float = -1.0) -> int: ...
def ssl_cipher_get_bits(c: C.SSL_CIPHER) -> int: ...
def ssl_cipher_get_name(c: C.SSL_CIPHER) -> str: ...
def ssl_cipher_get_version(c: C.SSL_CIPHER) -> str: ...
def ssl_clear(ssl: C.SSL) -> int: ...
def ssl_connect(ssl: C.SSL, timeout: float = -1.0) -> int: ...
def ssl_ctx_add_session(ctx: C.SSL_CTX, sess: C.SSL_SESSION) -> int: ...
def ssl_ctx_free(ctx: C.SSL_CTX) -> None: ...
def ssl_ctx_get_cert_store(ctx: C.SSL_CTX) -> C.X509_STORE: ...
def ssl_ctx_get_session_cache_mode(ctx: C.SSL_CTX) -> int: ...
def ssl_ctx_get_session_timeout(ctx: C.SSL_CTX) -> int: ...
def ssl_ctx_get_verify_depth(ctx: C.SSL_CTX) -> int: ...
def ssl_ctx_get_verify_mode(ctx: C.SSL_CTX) -> int: ...
def ssl_ctx_check_privkey(ctx: C.SSL_CTX) -> int: ...
def ssl_ctx_load_verify_locations(
    ctx: C.SSL_CTX, cafile: Optional[str], capath: Optional[str]
) -> int: ...
def ssl_ctx_new(method: C.SSL_METHOD) -> C.SSL_CTX: ...
def ssl_ctx_passphrase_callback(
    ctx: C.SSL_CTX, pyfunc: Callable[[], bytes]
) -> None: ...
def ssl_ctx_remove_session(ctx: C.SSL_CTX, sess: C.SSL_SESSION) -> int: ...
def ssl_ctx_set_cache_size(ctx: C.SSL_CTX, size: int) -> int: ...
def ssl_ctx_set_cipher_list(ctx: C.SSL_CTX, ciphers: str) -> int: ...
def ssl_ctx_set_client_CA_list_from_file(ctx: C.SSL_CTX, ca_file: str) -> None: ...
def ssl_ctx_set_default_verify_paths(ctx: C.SSL_CTX) -> int: ...
def ssl_ctx_set_info_callback(ctx: C.SSL_CTX, callback: Callable) -> None: ...
def ssl_ctx_set_options(ctx: C.SSL_CTX, op: int) -> int: ...
def ssl_ctx_set_session_cache_mode(ctx: C.SSL_CTX, mode: int) -> int: ...
def ssl_ctx_set_session_id_context(ctx: C.SSL_CTX, sid_ctx: bytes) -> int: ...
def ssl_ctx_set_session_timeout(ctx: C.SSL_CTX, t: int) -> int: ...
def ssl_ctx_set_tmp_dh(ctx: C.SSL_CTX, dh: C.DH) -> int: ...
def ssl_ctx_set_tmp_dh_callback(ctx: C.SSL_CTX, callback: Callable) -> None: ...
def ssl_ctx_set_tmp_rsa(ctx: C.SSL_CTX, rsa: C.RSA) -> int: ...
def ssl_ctx_set_tmp_rsa_callback(ctx: C.SSL_CTX, callback: Callable) -> None: ...
def ssl_ctx_set_verify(
    ctx: C.SSL_CTX, mode: int, callback: Callable[[int, C.X509_STORE_CTX], int]
) -> None: ...
def ssl_ctx_set_verify_default(ctx: C.SSL_CTX, mode: int) -> None: ...
def ssl_ctx_set_verify_depth(ctx: C.SSL_CTX, depth: int) -> None: ...
def ssl_ctx_use_cert(ctx: C.SSL_CTX, cert_file: str) -> int: ...
def ssl_ctx_use_cert_chain(ctx: C.SSL_CTX, chain_file: str) -> int: ...
def ssl_ctx_use_pkey_privkey(ctx: C.SSL_CTX, pkey: C.EVP_PKEY) -> int: ...
def ssl_ctx_use_privkey(ctx: C.SSL_CTX, key_file: str) -> int: ...
def ssl_free(ssl: C.SSL) -> None: ...
def ssl_get_cipher_list(ssl: C.SSL, n: int) -> str: ...
def ssl_get_ciphers(ssl: C.SSL) -> C.STACK_OF_SSL_CIPHER: ...
def ssl_get_current_cipher(ssl: C.SSL) -> Optional[C.SSL_CIPHER]: ...
def ssl_get_default_session_timeout(ssl: C.SSL) -> int: ...
def ssl_get_error(ssl: C.SSL, ret: int) -> int: ...
def ssl_get_peer_cert_chain(ssl: C.SSL) -> Optional[C.STACK_OF_X509]: ...
def ssl_get_session(ssl: C.SSL) -> Optional[C.SSL_SESSION]: ...
def ssl_get_shutdown(ssl: C.SSL) -> int: ...
def ssl_get_verify_mode(ssl: C.SSL) -> int: ...
def ssl_get_verify_depth(ssl: C.SSL) -> int: ...
def ssl_get_peer_cert(ssl: C.SSL) -> Optional[C.X509]: ...
def ssl_get_ssl_ctx(ssl: C.SSL) -> C.SSL_CTX: ...
def ssl_get_state(ssl: C.SSL) -> str: ...
def ssl_get_state_v(ssl: C.SSL) -> str: ...
def ssl_get_verify_result(ssl: C.SSL) -> int: ...
def ssl_get_version(ssl: C.SSL) -> str: ...
def ssl_get_alert_type_v(err: int) -> str: ...
def ssl_get_alert_desc_v(err: int) -> str: ...
def ssl_init(ssl_err: Any, ssl_timeout_err: Any) -> None: ...
def ssl_is_init_finished(ssl: C.SSL) -> int: ...
def ssl_new(ctx: C.SSL_CTX) -> C.SSL: ...
def ssl_pending(ssl: C.SSL) -> int: ...
def ssl_read_nbio(ssl: C.SSL, num: int) -> Optional[bytes]: ...
def ssl_read(ssl: C.SSL, num: int, timeout: float = -1.0) -> Optional[bytes]: ...
def ssl_renegotiate(ssl: C.SSL) -> int: ...
def ssl_session_free(sess: C.SSL_SESSION) -> None: ...
def ssl_session_get_timeout(sess: C.SSL_SESSION) -> int: ...
def ssl_session_get_time(sess: C.SSL_SESSION) -> int: ...
def ssl_session_print(bio: C.BIO, sess: C.SSL_SESSION) -> int: ...
def ssl_session_read_pem(bio: C.BIO) -> Optional[C.SSL_SESSION]: ...
def ssl_session_set_timeout(sess: C.SSL_SESSION, t: int) -> int: ...
def ssl_session_set_time(sess: C.SSL_SESSION, t: int) -> int: ...
def ssl_session_write_pem(sess: C.SSL_SESSION, bio: C.BIO) -> int: ...
def ssl_set_accept_state(ssl: C.SSL) -> None: ...
def ssl_set_bio(ssl: C.SSL, rbio: C.BIO, wbio: C.BIO) -> None: ...
def ssl_set_cipher_list(ssl: C.SSL, ciphers: str) -> int: ...
def ssl_set_client_CA_list_from_context(ssl: C.SSL, ctx: C.SSL_CTX) -> None: ...
def ssl_set_client_CA_list_from_file(ssl: C.SSL, ca_file: str) -> None: ...
def ssl_set_connect_state(ssl: C.SSL) -> None: ...
def ssl_set_session_id_context(ssl: C.SSL, sid_ctx: bytes) -> int: ...
def ssl_set_session(ssl: C.SSL, sess: C.SSL_SESSION) -> int: ...
def ssl_set_shutdown1(ssl: C.SSL, mode: int) -> None: ...
def ssl_set_tlsext_host_name(ssl: C.SSL, name: str) -> int: ...
def ssl_shutdown(ssl: C.SSL) -> int: ...
def sslv23_method() -> C.SSL_METHOD: ...
def ssl_write_nbio(ssl: C.SSL, data: bytes) -> int: ...
def ssl_write(ssl: C.SSL, data: bytes, timeout: float = -1.0) -> int: ...
def set_client_CA_list_from_file(ssl: C.SSL, ca_file: str) -> None: ...
def tlsv1_method() -> C.SSL_METHOD: ...

# --- X509 ---
def d2i_x509(bio: C.BIO) -> Optional[C.X509]: ...
def d2i_x509_req(bio: C.BIO) -> Optional[C.X509_REQ]: ...
def get_der_encoding_stack(stack: C.STACK_OF_X509) -> bytes: ...
def i2d_x509_bio(bio: C.BIO, x509: C.X509) -> int: ...
def i2d_x509_req_bio(bio: C.BIO, req: C.X509_REQ) -> int: ...
def i2d_x509(x: C.X509) -> bytes: ...
def make_stack_from_der_sequence(der: bytes) -> C.STACK_OF_X509: ...
def sk_x509_extension_free(stack: C.STACK_OF_X509_EXTENSION) -> None: ...
def sk_x509_extension_new_null() -> C.STACK_OF_X509_EXTENSION: ...
def sk_x509_extension_num(stack: C.STACK_OF_X509_EXTENSION) -> int: ...
def sk_x509_extension_pop(stack: C.STACK_OF_X509_EXTENSION) -> C.X509_EXTENSION: ...
def sk_x509_extension_push(
    stack: C.STACK_OF_X509_EXTENSION, ext: C.X509_EXTENSION
) -> int: ...
def sk_x509_extension_value(
    stack: C.STACK_OF_X509_EXTENSION, idx: int
) -> C.X509_EXTENSION: ...
def sk_x509_free(stack: C.STACK_OF_X509) -> None: ...
def sk_x509_new_null() -> C.STACK_OF_X509: ...
def sk_x509_num(stack: C.STACK_OF_X509) -> int: ...
def sk_x509_pop(stack: C.STACK_OF_X509) -> Optional[C.X509]: ...
def sk_x509_push(stack: C.STACK_OF_X509, cert: C.X509) -> int: ...
def sk_x509_value(stack: C.STACK_OF_X509, idx: int) -> C.X509: ...
def x509_add_ext(x: C.X509, ext: C.X509_EXTENSION, loc: int) -> int: ...
def x509_crl_free(crl: C.X509_CRL) -> None: ...
def x509_crl_new() -> C.X509_CRL: ...
def x509_crl_print(bio: C.BIO, crl: C.X509_CRL) -> int: ...
def x509_crl_read_pem(bio: C.BIO) -> Optional[C.X509_CRL]: ...
def x509_extension_free(ext: C.X509_EXTENSION) -> None: ...
def x509_extension_get_critical(ext: C.X509_EXTENSION) -> int: ...
def x509_extension_get_name(ext: C.X509_EXTENSION) -> bytes: ...
def x509_extension_set_critical(ext: C.X509_EXTENSION, crit: int) -> int: ...
def x509_ext_print(
    bio: C.BIO, ext: C.X509_EXTENSION, flags: int, indent: int
) -> int: ...
def x509_free(x: C.X509) -> None: ...
def x509_get_ext_count(x: C.X509) -> int: ...
def x509_get_ext(x: C.X509, loc: int) -> C.X509_EXTENSION: ...
def x509_get_issuer_name(x: C.X509) -> C.X509_NAME: ...
def x509_get_not_after(x509: C.X509) -> C.ASN1_Time: ...
def x509_get_not_before(x509: C.X509) -> C.ASN1_Time: ...
def x509_get_pubkey(x: C.X509) -> Optional[C.EVP_PKEY]: ...
def x509_get_serial_number(x: C.X509) -> C.ASN1_Integer: ...
def x509_get_subject_name(x: C.X509) -> C.X509_NAME: ...
def x509_get_version(x: C.X509) -> int: ...
def x509_check_ca(x: C.X509) -> int: ...
def x509_check_purpose(x: C.X509, id: int, ca: int) -> int: ...
def x509_init(err: Any) -> None: ...
def x509_name_add_entry_by_txt(
    name: C.X509_NAME,
    field: str,
    type: int,
    value: str,
    length: int,
    loc: int,
    set: int,
) -> int: ...
def x509_name_by_nid(name: C.X509_NAME, nid: int) -> Optional[bytes]: ...
def x509_name_entry_count(name: C.X509_NAME) -> int: ...
def x509_name_entry_create_by_txt(
    ne: C.X509_NAME_ENTRY, field: str, type: int, bytes: bytes, len: int
) -> C.X509_NAME_ENTRY: ...
def x509_name_entry_free(entry: C.X509_NAME_ENTRY) -> None: ...
def x509_name_entry_get_data(entry: C.X509_NAME_ENTRY) -> C.ASN1_String: ...
def x509_name_entry_get_object(entry: C.X509_NAME_ENTRY) -> C.ASN1_Object: ...
def x509_name_entry_set_data(
    entry: C.X509_NAME_ENTRY, type: int, data: bytes
) -> int: ...
def x509_name_entry_set_object(entry: C.X509_NAME_ENTRY, obj: C.ASN1_Object) -> int: ...
def x509_name_free(name: C.X509_NAME) -> None: ...
def x509_name_get_der(name: C.X509_NAME) -> bytes: ...
def x509_name_get_entry(name: C.X509_NAME, loc: int) -> C.X509_NAME_ENTRY: ...
def x509_name_get_index_by_nid(name: C.X509_NAME, nid: int, lastpos: int) -> int: ...
def x509_name_hash(name: C.X509_NAME) -> int: ...
def x509_name_new() -> C.X509_NAME: ...
def x509_name_oneline(name: C.X509_NAME) -> str: ...
def x509_name_print_ex(
    bio: C.BIO, name: C.X509_NAME, indent: int, flags: int
) -> int: ...
def x509_name_set_by_nid(name: C.X509_NAME, nid: int, value: str) -> int: ...
def x509_name_type_check(name: C.X509_NAME) -> int: ...
def x509_new() -> C.X509: ...
def x509_print(bio: C.BIO, x509: C.X509) -> int: ...
def x509_read_pem(bio: C.BIO) -> Optional[C.X509]: ...
def x509_req_add_extensions(
    req: C.X509_REQ, exts: C.STACK_OF_X509_EXTENSION
) -> int: ...
def x509_req_free(req: C.X509_REQ) -> None: ...
def x509_req_get_pubkey(req: C.X509_REQ) -> Optional[C.EVP_PKEY]: ...
def x509_req_get_subject_name(req: C.X509_REQ) -> C.X509_NAME: ...
def x509_req_get_version(req: C.X509_REQ) -> int: ...
def x509_req_new() -> C.X509_REQ: ...
def x509_req_print(bio: C.BIO, req: C.X509_REQ) -> int: ...
def x509_req_read_pem(bio: C.BIO) -> Optional[C.X509_REQ]: ...
def x509_req_set_pubkey(req: C.X509_REQ, pkey: C.EVP_PKEY) -> int: ...
def x509_req_set_subject_name(req: C.X509_REQ, name: C.X509_NAME) -> int: ...
def x509_req_set_version(req: C.X509_REQ, ver: int) -> int: ...
def x509_req_sign(req: C.X509_REQ, pkey: C.EVP_PKEY, md: C.EVP_MD) -> int: ...
def x509_req_verify(req: C.X509_REQ, pkey: C.EVP_PKEY) -> int: ...
def x509_req_write_pem(bio: C.BIO, req: C.X509_REQ) -> int: ...
def x509_set_issuer_name(x: C.X509, name: C.X509_NAME) -> int: ...
def x509_set_not_after(x509: C.X509, tm: C.ASN1_Time) -> int: ...
def x509_set_not_before(x509: C.X509, tm: C.ASN1_Time) -> int: ...
def x509_set_pubkey(x: C.X509, pkey: C.EVP_PKEY) -> int: ...
def x509_set_serial_number(x: C.X509, bn: C.ASN1_Integer) -> int: ...
def x509_set_subject_name(x: C.X509, name: C.X509_NAME) -> int: ...
def x509_set_version(x: C.X509, version: int) -> int: ...
def x509_sign(x: C.X509, pkey: C.EVP_PKEY, md: C.EVP_MD) -> int: ...
def x509_store_add_cert(store: C.X509_STORE, x: C.X509) -> int: ...
def x509_store_ctx_free(ctx: C.X509_STORE_CTX) -> None: ...
def x509_store_ctx_get_current_cert(ctx: C.X509_STORE_CTX) -> C.X509: ...
def x509_store_ctx_get_error(ctx: C.X509_STORE_CTX) -> int: ...
def x509_store_ctx_get_error_depth(ctx: C.X509_STORE_CTX) -> int: ...
def x509_store_ctx_get1_chain(ctx: C.X509_STORE_CTX) -> C.STACK_OF_X509: ...
def x509_store_free(store: C.X509_STORE) -> None: ...
def x509_store_load_locations(store: C.X509_STORE, cafile: str) -> int: ...
def x509_store_new() -> C.X509_STORE: ...
def x509_store_set_flags(store: C.X509_STORE, flags: int) -> int: ...
def x509_store_ctx_set_error(ctx: C.X509_STORE_CTX, err: int) -> None: ...
def x509_store_ctx_get_ex_data(ctx: C.X509_STORE_CTX, idx: int) -> C.SSL: ...
def x509_store_set_verify_cb(
    store: C.X509_STORE, cb: Callable[[int, C.X509_STORE_CTX], int]
) -> None: ...
def x509_type_check(x509: C.X509) -> int: ...
def x509_verify(x: C.X509, pkey: C.EVP_PKEY) -> int: ...
def x509v3_ext_conf(
    conf: Any, ctx: C.X509V3_CTX, name: str, value: str
) -> C.X509_EXTENSION: ...
def x509v3_set_nconf() -> C.X509V3_CTX: ...
def x509_write_pem(bio: C.BIO, x: C.X509) -> int: ...
def x509v3_ctx_free(ctx: C.X509V3_CTX) -> None: ...
def X509V3_CTX_set_nconf_pkey(ctx: C.X509V3_CTX, pkey: C.EVP_PKEY) -> None: ...

# --- S/MIME and PKCS7 ---
def smime_init(err: Any) -> None: ...
def pkcs7_init(err: Any) -> None: ...
def pkcs7_new() -> C.PKCS7: ...
def pkcs7_free(p7: C.PKCS7) -> None: ...
def pkcs7_sign0(
    signer_cert: C.X509,
    signer_key: C.EVP_PKEY,
    data: C.BIO,
    hash_obj: C.EVP_MD,
    flags: int,
) -> Optional[C.PKCS7]: ...
def pkcs7_sign1(
    signer_cert: C.X509,
    signer_key: C.EVP_PKEY,
    certs: C.STACK_OF_X509,
    data: C.BIO,
    hash_obj: C.EVP_MD,
    flags: int,
) -> Optional[C.PKCS7]: ...
def pkcs7_verify0(
    p7: C.PKCS7, certs: C.STACK_OF_X509, store: C.X509_STORE, flags: int
) -> bytes: ...
def pkcs7_verify1(
    p7: C.PKCS7, certs: C.STACK_OF_X509, store: C.X509_STORE, data: C.BIO, flags: int
) -> bytes: ...
def pkcs7_encrypt(
    certs: C.STACK_OF_X509, data: C.BIO, cipher: C.EVP_CIPHER, flags: int
) -> Optional[C.PKCS7]: ...
def pkcs7_decrypt(p7: C.PKCS7, pkey: C.EVP_PKEY, cert: C.X509, flags: int) -> bytes: ...
def pkcs7_read_bio(bio: C.BIO) -> Optional[C.PKCS7]: ...
def pkcs7_read_bio_der(bio: C.BIO) -> Optional[C.PKCS7]: ...
def pkcs7_write_bio(p7: C.PKCS7, bio: C.BIO) -> int: ...
def pkcs7_write_bio_der(p7: C.PKCS7, bio: C.BIO) -> int: ...
def smime_read_pkcs7(bio: C.BIO) -> Tuple[Optional[C.PKCS7], Optional[C.BIO]]: ...
def smime_write_pkcs7(bio: C.BIO, p7: C.PKCS7, flags: int) -> int: ...
def smime_write_pkcs7_multi(
    bio: C.BIO, p7: C.PKCS7, data: C.BIO, flags: int
) -> int: ...
def smime_crlf_copy(in_bio: C.BIO, out_bio: C.BIO) -> int: ...
def pkcs7_get0_signers(
    p7: C.PKCS7, certs: C.STACK_OF_X509, flags: int
) -> C.STACK_OF_X509: ...
def pkcs7_type_nid(p7: C.PKCS7) -> int: ...
def pkcs7_type_sn(p7: C.PKCS7) -> str: ...
def pkcs7_add_certificate(p7: C.PKCS7, cert: C.X509) -> None: ...

# --- Rand ---
def rand_init(err: Any) -> None: ...
def rand_add(blob: bytes, entropy: float) -> None: ...
def rand_seed(seed: bytes) -> None: ...
def rand_status() -> int: ...
def rand_file_name() -> bytes: ...
def rand_load_file(filename: str, max_bytes: int) -> int: ...
def rand_save_file(filename: str) -> int: ...
def rand_bytes(n: int) -> bytes: ...
def rand_pseudo_bytes(n: int) -> Tuple[bytes, int]: ...
