# Use these commands to generate the LAMMPS input script and data file
# (and other auxilliary files):

# First, generate the coordinates (the "system.xyz" file) this way
# (This can be a very slow process.)
cd packmol_files

  # You must run each packmol commend one after the other
  # NOTE: If PACKMOL gets stuck in an endless loop, then edit the corresponding
  # "inp" file.  This should not happen.  You can also usually interrupt
  # packmol after 30 minutes, and the solution at that point should be good
  # enough for use.
  packmol < step1_proteins.inp   # This step determines the protein's location
                                 # It takes ~20 minutes (on an intel i7)
  packmol < step2_innerlayer.inp # this step builds the inner monolayer
                                 # It takes ~90 minutes
  packmol < step3_outerlayer.inp # this step builds the outer monolayer
                                 # It takes ~4 hours

  # Running these three commands will probably take about an hour.
  # (It depends on how uniformly you need the packing to be.)

  mv -f step3_outerlayer.xyz ../system.xyz
cd ..


# Create LAMMPS input files this way:
cd moltemplate_files

  # run moltemplate

  moltemplate.sh -xyz ../system.xyz system.lt

  # This will generate various files with names ending in *.in* and *.data. 
  # These files are the input files directly read by LAMMPS.  Move them to 
  # the parent directory (or wherever you plan to run the simulation).

  mv -f system.in* system.data ../

  # The "table_int.dat" file contains tabular data for the lipid INT-INT atom 
  # 1/r^2 interaction.  We need it too. (This slows down the simulation by x2,
  # so I might look for a way to get rid of it later.)
  cp -f table_int.dat ../

  # Optional:
  # The "./output_ttree/" directory is full of temporary files generated by 
  # moltemplate.  They can be useful for debugging, but are usually thrown away.
  rm -rf output_ttree/

cd ../
