# notification.py
#
# Copyright 2024 Christopher Talbot
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# SPDX-License-Identifier: GPL-3.0-or-later

from gi.repository import Gtk, Gio, Adw

def _new_message_notification(channel, content):
    app = Gtk.Application.get_default()
    notification = Gio.Notification.new ("New Message in: " + str(channel))

    Gio.Notification.set_body (notification, str(content));
    Gio.Notification.set_priority (notification, Gio.NotificationPriority.HIGH)

    Gtk.Application.send_notification (app, "new-message", notification)

def _lost_connection_notification(reconnect):
    app = Gtk.Application.get_default()
    notification = Gio.Notification.new ("Lost connection to device")

    if reconnect:
        Gio.Notification.set_body (notification, "Attempting to reconnect")

    Gio.Notification.set_priority (notification, Gio.NotificationPriority.HIGH)

    Gtk.Application.withdraw_notification (app, "lost-connection")
    Gtk.Application.send_notification (app, "lost-connnection", notification)

def _withdraw_lost_connection_notification():
    app = Gtk.Application.get_default()
    Gtk.Application.withdraw_notification (app, "lost-connection")
