package avs

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AddonProvisioningState enumerates the values for addon provisioning state.
type AddonProvisioningState string

const (
	// AddonProvisioningStateBuilding ...
	AddonProvisioningStateBuilding AddonProvisioningState = "Building"
	// AddonProvisioningStateCancelled ...
	AddonProvisioningStateCancelled AddonProvisioningState = "Cancelled"
	// AddonProvisioningStateDeleting ...
	AddonProvisioningStateDeleting AddonProvisioningState = "Deleting"
	// AddonProvisioningStateFailed ...
	AddonProvisioningStateFailed AddonProvisioningState = "Failed"
	// AddonProvisioningStateSucceeded ...
	AddonProvisioningStateSucceeded AddonProvisioningState = "Succeeded"
	// AddonProvisioningStateUpdating ...
	AddonProvisioningStateUpdating AddonProvisioningState = "Updating"
)

// PossibleAddonProvisioningStateValues returns an array of possible values for the AddonProvisioningState const type.
func PossibleAddonProvisioningStateValues() []AddonProvisioningState {
	return []AddonProvisioningState{AddonProvisioningStateBuilding, AddonProvisioningStateCancelled, AddonProvisioningStateDeleting, AddonProvisioningStateFailed, AddonProvisioningStateSucceeded, AddonProvisioningStateUpdating}
}

// AddonType enumerates the values for addon type.
type AddonType string

const (
	// AddonTypeAddonProperties ...
	AddonTypeAddonProperties AddonType = "AddonProperties"
	// AddonTypeHCX ...
	AddonTypeHCX AddonType = "HCX"
	// AddonTypeSRM ...
	AddonTypeSRM AddonType = "SRM"
	// AddonTypeVR ...
	AddonTypeVR AddonType = "VR"
)

// PossibleAddonTypeValues returns an array of possible values for the AddonType const type.
func PossibleAddonTypeValues() []AddonType {
	return []AddonType{AddonTypeAddonProperties, AddonTypeHCX, AddonTypeSRM, AddonTypeVR}
}

// AffinityType enumerates the values for affinity type.
type AffinityType string

const (
	// AffinityTypeAffinity ...
	AffinityTypeAffinity AffinityType = "Affinity"
	// AffinityTypeAntiAffinity ...
	AffinityTypeAntiAffinity AffinityType = "AntiAffinity"
)

// PossibleAffinityTypeValues returns an array of possible values for the AffinityType const type.
func PossibleAffinityTypeValues() []AffinityType {
	return []AffinityType{AffinityTypeAffinity, AffinityTypeAntiAffinity}
}

// AvailabilityStrategy enumerates the values for availability strategy.
type AvailabilityStrategy string

const (
	// AvailabilityStrategyDualZone ...
	AvailabilityStrategyDualZone AvailabilityStrategy = "DualZone"
	// AvailabilityStrategySingleZone ...
	AvailabilityStrategySingleZone AvailabilityStrategy = "SingleZone"
)

// PossibleAvailabilityStrategyValues returns an array of possible values for the AvailabilityStrategy const type.
func PossibleAvailabilityStrategyValues() []AvailabilityStrategy {
	return []AvailabilityStrategy{AvailabilityStrategyDualZone, AvailabilityStrategySingleZone}
}

// CloudLinkStatus enumerates the values for cloud link status.
type CloudLinkStatus string

const (
	// CloudLinkStatusActive ...
	CloudLinkStatusActive CloudLinkStatus = "Active"
	// CloudLinkStatusBuilding ...
	CloudLinkStatusBuilding CloudLinkStatus = "Building"
	// CloudLinkStatusDeleting ...
	CloudLinkStatusDeleting CloudLinkStatus = "Deleting"
	// CloudLinkStatusDisconnected ...
	CloudLinkStatusDisconnected CloudLinkStatus = "Disconnected"
	// CloudLinkStatusFailed ...
	CloudLinkStatusFailed CloudLinkStatus = "Failed"
)

// PossibleCloudLinkStatusValues returns an array of possible values for the CloudLinkStatus const type.
func PossibleCloudLinkStatusValues() []CloudLinkStatus {
	return []CloudLinkStatus{CloudLinkStatusActive, CloudLinkStatusBuilding, CloudLinkStatusDeleting, CloudLinkStatusDisconnected, CloudLinkStatusFailed}
}

// ClusterProvisioningState enumerates the values for cluster provisioning state.
type ClusterProvisioningState string

const (
	// ClusterProvisioningStateCancelled ...
	ClusterProvisioningStateCancelled ClusterProvisioningState = "Cancelled"
	// ClusterProvisioningStateDeleting ...
	ClusterProvisioningStateDeleting ClusterProvisioningState = "Deleting"
	// ClusterProvisioningStateFailed ...
	ClusterProvisioningStateFailed ClusterProvisioningState = "Failed"
	// ClusterProvisioningStateSucceeded ...
	ClusterProvisioningStateSucceeded ClusterProvisioningState = "Succeeded"
	// ClusterProvisioningStateUpdating ...
	ClusterProvisioningStateUpdating ClusterProvisioningState = "Updating"
)

// PossibleClusterProvisioningStateValues returns an array of possible values for the ClusterProvisioningState const type.
func PossibleClusterProvisioningStateValues() []ClusterProvisioningState {
	return []ClusterProvisioningState{ClusterProvisioningStateCancelled, ClusterProvisioningStateDeleting, ClusterProvisioningStateFailed, ClusterProvisioningStateSucceeded, ClusterProvisioningStateUpdating}
}

// DatastoreProvisioningState enumerates the values for datastore provisioning state.
type DatastoreProvisioningState string

const (
	// DatastoreProvisioningStateCancelled ...
	DatastoreProvisioningStateCancelled DatastoreProvisioningState = "Cancelled"
	// DatastoreProvisioningStateCreating ...
	DatastoreProvisioningStateCreating DatastoreProvisioningState = "Creating"
	// DatastoreProvisioningStateDeleting ...
	DatastoreProvisioningStateDeleting DatastoreProvisioningState = "Deleting"
	// DatastoreProvisioningStateFailed ...
	DatastoreProvisioningStateFailed DatastoreProvisioningState = "Failed"
	// DatastoreProvisioningStatePending ...
	DatastoreProvisioningStatePending DatastoreProvisioningState = "Pending"
	// DatastoreProvisioningStateSucceeded ...
	DatastoreProvisioningStateSucceeded DatastoreProvisioningState = "Succeeded"
	// DatastoreProvisioningStateUpdating ...
	DatastoreProvisioningStateUpdating DatastoreProvisioningState = "Updating"
)

// PossibleDatastoreProvisioningStateValues returns an array of possible values for the DatastoreProvisioningState const type.
func PossibleDatastoreProvisioningStateValues() []DatastoreProvisioningState {
	return []DatastoreProvisioningState{DatastoreProvisioningStateCancelled, DatastoreProvisioningStateCreating, DatastoreProvisioningStateDeleting, DatastoreProvisioningStateFailed, DatastoreProvisioningStatePending, DatastoreProvisioningStateSucceeded, DatastoreProvisioningStateUpdating}
}

// DatastoreStatus enumerates the values for datastore status.
type DatastoreStatus string

const (
	// DatastoreStatusAccessible ...
	DatastoreStatusAccessible DatastoreStatus = "Accessible"
	// DatastoreStatusAttached ...
	DatastoreStatusAttached DatastoreStatus = "Attached"
	// DatastoreStatusDeadOrError ...
	DatastoreStatusDeadOrError DatastoreStatus = "DeadOrError"
	// DatastoreStatusDetached ...
	DatastoreStatusDetached DatastoreStatus = "Detached"
	// DatastoreStatusInaccessible ...
	DatastoreStatusInaccessible DatastoreStatus = "Inaccessible"
	// DatastoreStatusLostCommunication ...
	DatastoreStatusLostCommunication DatastoreStatus = "LostCommunication"
	// DatastoreStatusUnknown ...
	DatastoreStatusUnknown DatastoreStatus = "Unknown"
)

// PossibleDatastoreStatusValues returns an array of possible values for the DatastoreStatus const type.
func PossibleDatastoreStatusValues() []DatastoreStatus {
	return []DatastoreStatus{DatastoreStatusAccessible, DatastoreStatusAttached, DatastoreStatusDeadOrError, DatastoreStatusDetached, DatastoreStatusInaccessible, DatastoreStatusLostCommunication, DatastoreStatusUnknown}
}

// DhcpType enumerates the values for dhcp type.
type DhcpType string

const (
	// DhcpTypeRELAY ...
	DhcpTypeRELAY DhcpType = "RELAY"
	// DhcpTypeSERVER ...
	DhcpTypeSERVER DhcpType = "SERVER"
	// DhcpTypeWorkloadNetworkDhcpEntity ...
	DhcpTypeWorkloadNetworkDhcpEntity DhcpType = "WorkloadNetworkDhcpEntity"
)

// PossibleDhcpTypeValues returns an array of possible values for the DhcpType const type.
func PossibleDhcpTypeValues() []DhcpType {
	return []DhcpType{DhcpTypeRELAY, DhcpTypeSERVER, DhcpTypeWorkloadNetworkDhcpEntity}
}

// DNSServiceLogLevelEnum enumerates the values for dns service log level enum.
type DNSServiceLogLevelEnum string

const (
	// DNSServiceLogLevelEnumDEBUG ...
	DNSServiceLogLevelEnumDEBUG DNSServiceLogLevelEnum = "DEBUG"
	// DNSServiceLogLevelEnumERROR ...
	DNSServiceLogLevelEnumERROR DNSServiceLogLevelEnum = "ERROR"
	// DNSServiceLogLevelEnumFATAL ...
	DNSServiceLogLevelEnumFATAL DNSServiceLogLevelEnum = "FATAL"
	// DNSServiceLogLevelEnumINFO ...
	DNSServiceLogLevelEnumINFO DNSServiceLogLevelEnum = "INFO"
	// DNSServiceLogLevelEnumWARNING ...
	DNSServiceLogLevelEnumWARNING DNSServiceLogLevelEnum = "WARNING"
)

// PossibleDNSServiceLogLevelEnumValues returns an array of possible values for the DNSServiceLogLevelEnum const type.
func PossibleDNSServiceLogLevelEnumValues() []DNSServiceLogLevelEnum {
	return []DNSServiceLogLevelEnum{DNSServiceLogLevelEnumDEBUG, DNSServiceLogLevelEnumERROR, DNSServiceLogLevelEnumFATAL, DNSServiceLogLevelEnumINFO, DNSServiceLogLevelEnumWARNING}
}

// DNSServiceStatusEnum enumerates the values for dns service status enum.
type DNSServiceStatusEnum string

const (
	// DNSServiceStatusEnumFAILURE ...
	DNSServiceStatusEnumFAILURE DNSServiceStatusEnum = "FAILURE"
	// DNSServiceStatusEnumSUCCESS ...
	DNSServiceStatusEnumSUCCESS DNSServiceStatusEnum = "SUCCESS"
)

// PossibleDNSServiceStatusEnumValues returns an array of possible values for the DNSServiceStatusEnum const type.
func PossibleDNSServiceStatusEnumValues() []DNSServiceStatusEnum {
	return []DNSServiceStatusEnum{DNSServiceStatusEnumFAILURE, DNSServiceStatusEnumSUCCESS}
}

// EncryptionKeyStatus enumerates the values for encryption key status.
type EncryptionKeyStatus string

const (
	// EncryptionKeyStatusAccessDenied ...
	EncryptionKeyStatusAccessDenied EncryptionKeyStatus = "AccessDenied"
	// EncryptionKeyStatusConnected ...
	EncryptionKeyStatusConnected EncryptionKeyStatus = "Connected"
)

// PossibleEncryptionKeyStatusValues returns an array of possible values for the EncryptionKeyStatus const type.
func PossibleEncryptionKeyStatusValues() []EncryptionKeyStatus {
	return []EncryptionKeyStatus{EncryptionKeyStatusAccessDenied, EncryptionKeyStatusConnected}
}

// EncryptionState enumerates the values for encryption state.
type EncryptionState string

const (
	// EncryptionStateDisabled ...
	EncryptionStateDisabled EncryptionState = "Disabled"
	// EncryptionStateEnabled ...
	EncryptionStateEnabled EncryptionState = "Enabled"
)

// PossibleEncryptionStateValues returns an array of possible values for the EncryptionState const type.
func PossibleEncryptionStateValues() []EncryptionState {
	return []EncryptionState{EncryptionStateDisabled, EncryptionStateEnabled}
}

// EncryptionVersionType enumerates the values for encryption version type.
type EncryptionVersionType string

const (
	// EncryptionVersionTypeAutoDetected ...
	EncryptionVersionTypeAutoDetected EncryptionVersionType = "AutoDetected"
	// EncryptionVersionTypeFixed ...
	EncryptionVersionTypeFixed EncryptionVersionType = "Fixed"
)

// PossibleEncryptionVersionTypeValues returns an array of possible values for the EncryptionVersionType const type.
func PossibleEncryptionVersionTypeValues() []EncryptionVersionType {
	return []EncryptionVersionType{EncryptionVersionTypeAutoDetected, EncryptionVersionTypeFixed}
}

// ExpressRouteAuthorizationProvisioningState enumerates the values for express route authorization
// provisioning state.
type ExpressRouteAuthorizationProvisioningState string

const (
	// ExpressRouteAuthorizationProvisioningStateFailed ...
	ExpressRouteAuthorizationProvisioningStateFailed ExpressRouteAuthorizationProvisioningState = "Failed"
	// ExpressRouteAuthorizationProvisioningStateSucceeded ...
	ExpressRouteAuthorizationProvisioningStateSucceeded ExpressRouteAuthorizationProvisioningState = "Succeeded"
	// ExpressRouteAuthorizationProvisioningStateUpdating ...
	ExpressRouteAuthorizationProvisioningStateUpdating ExpressRouteAuthorizationProvisioningState = "Updating"
)

// PossibleExpressRouteAuthorizationProvisioningStateValues returns an array of possible values for the ExpressRouteAuthorizationProvisioningState const type.
func PossibleExpressRouteAuthorizationProvisioningStateValues() []ExpressRouteAuthorizationProvisioningState {
	return []ExpressRouteAuthorizationProvisioningState{ExpressRouteAuthorizationProvisioningStateFailed, ExpressRouteAuthorizationProvisioningStateSucceeded, ExpressRouteAuthorizationProvisioningStateUpdating}
}

// GlobalReachConnectionProvisioningState enumerates the values for global reach connection provisioning state.
type GlobalReachConnectionProvisioningState string

const (
	// GlobalReachConnectionProvisioningStateFailed ...
	GlobalReachConnectionProvisioningStateFailed GlobalReachConnectionProvisioningState = "Failed"
	// GlobalReachConnectionProvisioningStateSucceeded ...
	GlobalReachConnectionProvisioningStateSucceeded GlobalReachConnectionProvisioningState = "Succeeded"
	// GlobalReachConnectionProvisioningStateUpdating ...
	GlobalReachConnectionProvisioningStateUpdating GlobalReachConnectionProvisioningState = "Updating"
)

// PossibleGlobalReachConnectionProvisioningStateValues returns an array of possible values for the GlobalReachConnectionProvisioningState const type.
func PossibleGlobalReachConnectionProvisioningStateValues() []GlobalReachConnectionProvisioningState {
	return []GlobalReachConnectionProvisioningState{GlobalReachConnectionProvisioningStateFailed, GlobalReachConnectionProvisioningStateSucceeded, GlobalReachConnectionProvisioningStateUpdating}
}

// GlobalReachConnectionStatus enumerates the values for global reach connection status.
type GlobalReachConnectionStatus string

const (
	// GlobalReachConnectionStatusConnected ...
	GlobalReachConnectionStatusConnected GlobalReachConnectionStatus = "Connected"
	// GlobalReachConnectionStatusConnecting ...
	GlobalReachConnectionStatusConnecting GlobalReachConnectionStatus = "Connecting"
	// GlobalReachConnectionStatusDisconnected ...
	GlobalReachConnectionStatusDisconnected GlobalReachConnectionStatus = "Disconnected"
)

// PossibleGlobalReachConnectionStatusValues returns an array of possible values for the GlobalReachConnectionStatus const type.
func PossibleGlobalReachConnectionStatusValues() []GlobalReachConnectionStatus {
	return []GlobalReachConnectionStatus{GlobalReachConnectionStatusConnected, GlobalReachConnectionStatusConnecting, GlobalReachConnectionStatusDisconnected}
}

// HcxEnterpriseSiteStatus enumerates the values for hcx enterprise site status.
type HcxEnterpriseSiteStatus string

const (
	// HcxEnterpriseSiteStatusAvailable ...
	HcxEnterpriseSiteStatusAvailable HcxEnterpriseSiteStatus = "Available"
	// HcxEnterpriseSiteStatusConsumed ...
	HcxEnterpriseSiteStatusConsumed HcxEnterpriseSiteStatus = "Consumed"
	// HcxEnterpriseSiteStatusDeactivated ...
	HcxEnterpriseSiteStatusDeactivated HcxEnterpriseSiteStatus = "Deactivated"
	// HcxEnterpriseSiteStatusDeleted ...
	HcxEnterpriseSiteStatusDeleted HcxEnterpriseSiteStatus = "Deleted"
)

// PossibleHcxEnterpriseSiteStatusValues returns an array of possible values for the HcxEnterpriseSiteStatus const type.
func PossibleHcxEnterpriseSiteStatusValues() []HcxEnterpriseSiteStatus {
	return []HcxEnterpriseSiteStatus{HcxEnterpriseSiteStatusAvailable, HcxEnterpriseSiteStatusConsumed, HcxEnterpriseSiteStatusDeactivated, HcxEnterpriseSiteStatusDeleted}
}

// InternetEnum enumerates the values for internet enum.
type InternetEnum string

const (
	// InternetEnumDisabled ...
	InternetEnumDisabled InternetEnum = "Disabled"
	// InternetEnumEnabled ...
	InternetEnumEnabled InternetEnum = "Enabled"
)

// PossibleInternetEnumValues returns an array of possible values for the InternetEnum const type.
func PossibleInternetEnumValues() []InternetEnum {
	return []InternetEnum{InternetEnumDisabled, InternetEnumEnabled}
}

// MountOptionEnum enumerates the values for mount option enum.
type MountOptionEnum string

const (
	// MountOptionEnumATTACH ...
	MountOptionEnumATTACH MountOptionEnum = "ATTACH"
	// MountOptionEnumMOUNT ...
	MountOptionEnumMOUNT MountOptionEnum = "MOUNT"
)

// PossibleMountOptionEnumValues returns an array of possible values for the MountOptionEnum const type.
func PossibleMountOptionEnumValues() []MountOptionEnum {
	return []MountOptionEnum{MountOptionEnumATTACH, MountOptionEnumMOUNT}
}

// OptionalParamEnum enumerates the values for optional param enum.
type OptionalParamEnum string

const (
	// OptionalParamEnumOptional ...
	OptionalParamEnumOptional OptionalParamEnum = "Optional"
	// OptionalParamEnumRequired ...
	OptionalParamEnumRequired OptionalParamEnum = "Required"
)

// PossibleOptionalParamEnumValues returns an array of possible values for the OptionalParamEnum const type.
func PossibleOptionalParamEnumValues() []OptionalParamEnum {
	return []OptionalParamEnum{OptionalParamEnumOptional, OptionalParamEnumRequired}
}

// PlacementPolicyProvisioningState enumerates the values for placement policy provisioning state.
type PlacementPolicyProvisioningState string

const (
	// PlacementPolicyProvisioningStateBuilding ...
	PlacementPolicyProvisioningStateBuilding PlacementPolicyProvisioningState = "Building"
	// PlacementPolicyProvisioningStateDeleting ...
	PlacementPolicyProvisioningStateDeleting PlacementPolicyProvisioningState = "Deleting"
	// PlacementPolicyProvisioningStateFailed ...
	PlacementPolicyProvisioningStateFailed PlacementPolicyProvisioningState = "Failed"
	// PlacementPolicyProvisioningStateSucceeded ...
	PlacementPolicyProvisioningStateSucceeded PlacementPolicyProvisioningState = "Succeeded"
	// PlacementPolicyProvisioningStateUpdating ...
	PlacementPolicyProvisioningStateUpdating PlacementPolicyProvisioningState = "Updating"
)

// PossiblePlacementPolicyProvisioningStateValues returns an array of possible values for the PlacementPolicyProvisioningState const type.
func PossiblePlacementPolicyProvisioningStateValues() []PlacementPolicyProvisioningState {
	return []PlacementPolicyProvisioningState{PlacementPolicyProvisioningStateBuilding, PlacementPolicyProvisioningStateDeleting, PlacementPolicyProvisioningStateFailed, PlacementPolicyProvisioningStateSucceeded, PlacementPolicyProvisioningStateUpdating}
}

// PlacementPolicyState enumerates the values for placement policy state.
type PlacementPolicyState string

const (
	// PlacementPolicyStateDisabled ...
	PlacementPolicyStateDisabled PlacementPolicyState = "Disabled"
	// PlacementPolicyStateEnabled ...
	PlacementPolicyStateEnabled PlacementPolicyState = "Enabled"
)

// PossiblePlacementPolicyStateValues returns an array of possible values for the PlacementPolicyState const type.
func PossiblePlacementPolicyStateValues() []PlacementPolicyState {
	return []PlacementPolicyState{PlacementPolicyStateDisabled, PlacementPolicyStateEnabled}
}

// PortMirroringDirectionEnum enumerates the values for port mirroring direction enum.
type PortMirroringDirectionEnum string

const (
	// PortMirroringDirectionEnumBIDIRECTIONAL ...
	PortMirroringDirectionEnumBIDIRECTIONAL PortMirroringDirectionEnum = "BIDIRECTIONAL"
	// PortMirroringDirectionEnumEGRESS ...
	PortMirroringDirectionEnumEGRESS PortMirroringDirectionEnum = "EGRESS"
	// PortMirroringDirectionEnumINGRESS ...
	PortMirroringDirectionEnumINGRESS PortMirroringDirectionEnum = "INGRESS"
)

// PossiblePortMirroringDirectionEnumValues returns an array of possible values for the PortMirroringDirectionEnum const type.
func PossiblePortMirroringDirectionEnumValues() []PortMirroringDirectionEnum {
	return []PortMirroringDirectionEnum{PortMirroringDirectionEnumBIDIRECTIONAL, PortMirroringDirectionEnumEGRESS, PortMirroringDirectionEnumINGRESS}
}

// PortMirroringStatusEnum enumerates the values for port mirroring status enum.
type PortMirroringStatusEnum string

const (
	// PortMirroringStatusEnumFAILURE ...
	PortMirroringStatusEnumFAILURE PortMirroringStatusEnum = "FAILURE"
	// PortMirroringStatusEnumSUCCESS ...
	PortMirroringStatusEnumSUCCESS PortMirroringStatusEnum = "SUCCESS"
)

// PossiblePortMirroringStatusEnumValues returns an array of possible values for the PortMirroringStatusEnum const type.
func PossiblePortMirroringStatusEnumValues() []PortMirroringStatusEnum {
	return []PortMirroringStatusEnum{PortMirroringStatusEnumFAILURE, PortMirroringStatusEnumSUCCESS}
}

// PrivateCloudProvisioningState enumerates the values for private cloud provisioning state.
type PrivateCloudProvisioningState string

const (
	// PrivateCloudProvisioningStateBuilding ...
	PrivateCloudProvisioningStateBuilding PrivateCloudProvisioningState = "Building"
	// PrivateCloudProvisioningStateCancelled ...
	PrivateCloudProvisioningStateCancelled PrivateCloudProvisioningState = "Cancelled"
	// PrivateCloudProvisioningStateDeleting ...
	PrivateCloudProvisioningStateDeleting PrivateCloudProvisioningState = "Deleting"
	// PrivateCloudProvisioningStateFailed ...
	PrivateCloudProvisioningStateFailed PrivateCloudProvisioningState = "Failed"
	// PrivateCloudProvisioningStatePending ...
	PrivateCloudProvisioningStatePending PrivateCloudProvisioningState = "Pending"
	// PrivateCloudProvisioningStateSucceeded ...
	PrivateCloudProvisioningStateSucceeded PrivateCloudProvisioningState = "Succeeded"
	// PrivateCloudProvisioningStateUpdating ...
	PrivateCloudProvisioningStateUpdating PrivateCloudProvisioningState = "Updating"
)

// PossiblePrivateCloudProvisioningStateValues returns an array of possible values for the PrivateCloudProvisioningState const type.
func PossiblePrivateCloudProvisioningStateValues() []PrivateCloudProvisioningState {
	return []PrivateCloudProvisioningState{PrivateCloudProvisioningStateBuilding, PrivateCloudProvisioningStateCancelled, PrivateCloudProvisioningStateDeleting, PrivateCloudProvisioningStateFailed, PrivateCloudProvisioningStatePending, PrivateCloudProvisioningStateSucceeded, PrivateCloudProvisioningStateUpdating}
}

// QuotaEnabled enumerates the values for quota enabled.
type QuotaEnabled string

const (
	// QuotaEnabledDisabled ...
	QuotaEnabledDisabled QuotaEnabled = "Disabled"
	// QuotaEnabledEnabled ...
	QuotaEnabledEnabled QuotaEnabled = "Enabled"
)

// PossibleQuotaEnabledValues returns an array of possible values for the QuotaEnabled const type.
func PossibleQuotaEnabledValues() []QuotaEnabled {
	return []QuotaEnabled{QuotaEnabledDisabled, QuotaEnabledEnabled}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeNone ...
	ResourceIdentityTypeNone ResourceIdentityType = "None"
	// ResourceIdentityTypeSystemAssigned ...
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeNone, ResourceIdentityTypeSystemAssigned}
}

// ScriptExecutionProvisioningState enumerates the values for script execution provisioning state.
type ScriptExecutionProvisioningState string

const (
	// ScriptExecutionProvisioningStateCancelled ...
	ScriptExecutionProvisioningStateCancelled ScriptExecutionProvisioningState = "Cancelled"
	// ScriptExecutionProvisioningStateCancelling ...
	ScriptExecutionProvisioningStateCancelling ScriptExecutionProvisioningState = "Cancelling"
	// ScriptExecutionProvisioningStateDeleting ...
	ScriptExecutionProvisioningStateDeleting ScriptExecutionProvisioningState = "Deleting"
	// ScriptExecutionProvisioningStateFailed ...
	ScriptExecutionProvisioningStateFailed ScriptExecutionProvisioningState = "Failed"
	// ScriptExecutionProvisioningStatePending ...
	ScriptExecutionProvisioningStatePending ScriptExecutionProvisioningState = "Pending"
	// ScriptExecutionProvisioningStateRunning ...
	ScriptExecutionProvisioningStateRunning ScriptExecutionProvisioningState = "Running"
	// ScriptExecutionProvisioningStateSucceeded ...
	ScriptExecutionProvisioningStateSucceeded ScriptExecutionProvisioningState = "Succeeded"
)

// PossibleScriptExecutionProvisioningStateValues returns an array of possible values for the ScriptExecutionProvisioningState const type.
func PossibleScriptExecutionProvisioningStateValues() []ScriptExecutionProvisioningState {
	return []ScriptExecutionProvisioningState{ScriptExecutionProvisioningStateCancelled, ScriptExecutionProvisioningStateCancelling, ScriptExecutionProvisioningStateDeleting, ScriptExecutionProvisioningStateFailed, ScriptExecutionProvisioningStatePending, ScriptExecutionProvisioningStateRunning, ScriptExecutionProvisioningStateSucceeded}
}

// ScriptOutputStreamType enumerates the values for script output stream type.
type ScriptOutputStreamType string

const (
	// ScriptOutputStreamTypeError ...
	ScriptOutputStreamTypeError ScriptOutputStreamType = "Error"
	// ScriptOutputStreamTypeInformation ...
	ScriptOutputStreamTypeInformation ScriptOutputStreamType = "Information"
	// ScriptOutputStreamTypeOutput ...
	ScriptOutputStreamTypeOutput ScriptOutputStreamType = "Output"
	// ScriptOutputStreamTypeWarning ...
	ScriptOutputStreamTypeWarning ScriptOutputStreamType = "Warning"
)

// PossibleScriptOutputStreamTypeValues returns an array of possible values for the ScriptOutputStreamType const type.
func PossibleScriptOutputStreamTypeValues() []ScriptOutputStreamType {
	return []ScriptOutputStreamType{ScriptOutputStreamTypeError, ScriptOutputStreamTypeInformation, ScriptOutputStreamTypeOutput, ScriptOutputStreamTypeWarning}
}

// ScriptParameterTypes enumerates the values for script parameter types.
type ScriptParameterTypes string

const (
	// ScriptParameterTypesBool ...
	ScriptParameterTypesBool ScriptParameterTypes = "Bool"
	// ScriptParameterTypesCredential ...
	ScriptParameterTypesCredential ScriptParameterTypes = "Credential"
	// ScriptParameterTypesFloat ...
	ScriptParameterTypesFloat ScriptParameterTypes = "Float"
	// ScriptParameterTypesInt ...
	ScriptParameterTypesInt ScriptParameterTypes = "Int"
	// ScriptParameterTypesSecureString ...
	ScriptParameterTypesSecureString ScriptParameterTypes = "SecureString"
	// ScriptParameterTypesString ...
	ScriptParameterTypesString ScriptParameterTypes = "String"
)

// PossibleScriptParameterTypesValues returns an array of possible values for the ScriptParameterTypes const type.
func PossibleScriptParameterTypesValues() []ScriptParameterTypes {
	return []ScriptParameterTypes{ScriptParameterTypesBool, ScriptParameterTypesCredential, ScriptParameterTypesFloat, ScriptParameterTypesInt, ScriptParameterTypesSecureString, ScriptParameterTypesString}
}

// SegmentStatusEnum enumerates the values for segment status enum.
type SegmentStatusEnum string

const (
	// SegmentStatusEnumFAILURE ...
	SegmentStatusEnumFAILURE SegmentStatusEnum = "FAILURE"
	// SegmentStatusEnumSUCCESS ...
	SegmentStatusEnumSUCCESS SegmentStatusEnum = "SUCCESS"
)

// PossibleSegmentStatusEnumValues returns an array of possible values for the SegmentStatusEnum const type.
func PossibleSegmentStatusEnumValues() []SegmentStatusEnum {
	return []SegmentStatusEnum{SegmentStatusEnumFAILURE, SegmentStatusEnumSUCCESS}
}

// SslEnum enumerates the values for ssl enum.
type SslEnum string

const (
	// SslEnumDisabled ...
	SslEnumDisabled SslEnum = "Disabled"
	// SslEnumEnabled ...
	SslEnumEnabled SslEnum = "Enabled"
)

// PossibleSslEnumValues returns an array of possible values for the SslEnum const type.
func PossibleSslEnumValues() []SslEnum {
	return []SslEnum{SslEnumDisabled, SslEnumEnabled}
}

// TrialStatus enumerates the values for trial status.
type TrialStatus string

const (
	// TrialStatusTrialAvailable ...
	TrialStatusTrialAvailable TrialStatus = "TrialAvailable"
	// TrialStatusTrialDisabled ...
	TrialStatusTrialDisabled TrialStatus = "TrialDisabled"
	// TrialStatusTrialUsed ...
	TrialStatusTrialUsed TrialStatus = "TrialUsed"
)

// PossibleTrialStatusValues returns an array of possible values for the TrialStatus const type.
func PossibleTrialStatusValues() []TrialStatus {
	return []TrialStatus{TrialStatusTrialAvailable, TrialStatusTrialDisabled, TrialStatusTrialUsed}
}

// Type enumerates the values for type.
type Type string

const (
	// TypePlacementPolicyProperties ...
	TypePlacementPolicyProperties Type = "PlacementPolicyProperties"
	// TypeVMHost ...
	TypeVMHost Type = "VmHost"
	// TypeVMVM ...
	TypeVMVM Type = "VmVm"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypePlacementPolicyProperties, TypeVMHost, TypeVMVM}
}

// TypeBasicScriptExecutionParameter enumerates the values for type basic script execution parameter.
type TypeBasicScriptExecutionParameter string

const (
	// TypeBasicScriptExecutionParameterTypeCredential ...
	TypeBasicScriptExecutionParameterTypeCredential TypeBasicScriptExecutionParameter = "Credential"
	// TypeBasicScriptExecutionParameterTypeScriptExecutionParameter ...
	TypeBasicScriptExecutionParameterTypeScriptExecutionParameter TypeBasicScriptExecutionParameter = "ScriptExecutionParameter"
	// TypeBasicScriptExecutionParameterTypeSecureValue ...
	TypeBasicScriptExecutionParameterTypeSecureValue TypeBasicScriptExecutionParameter = "SecureValue"
	// TypeBasicScriptExecutionParameterTypeValue ...
	TypeBasicScriptExecutionParameterTypeValue TypeBasicScriptExecutionParameter = "Value"
)

// PossibleTypeBasicScriptExecutionParameterValues returns an array of possible values for the TypeBasicScriptExecutionParameter const type.
func PossibleTypeBasicScriptExecutionParameterValues() []TypeBasicScriptExecutionParameter {
	return []TypeBasicScriptExecutionParameter{TypeBasicScriptExecutionParameterTypeCredential, TypeBasicScriptExecutionParameterTypeScriptExecutionParameter, TypeBasicScriptExecutionParameterTypeSecureValue, TypeBasicScriptExecutionParameterTypeValue}
}

// VirtualMachineRestrictMovementState enumerates the values for virtual machine restrict movement state.
type VirtualMachineRestrictMovementState string

const (
	// VirtualMachineRestrictMovementStateDisabled ...
	VirtualMachineRestrictMovementStateDisabled VirtualMachineRestrictMovementState = "Disabled"
	// VirtualMachineRestrictMovementStateEnabled ...
	VirtualMachineRestrictMovementStateEnabled VirtualMachineRestrictMovementState = "Enabled"
)

// PossibleVirtualMachineRestrictMovementStateValues returns an array of possible values for the VirtualMachineRestrictMovementState const type.
func PossibleVirtualMachineRestrictMovementStateValues() []VirtualMachineRestrictMovementState {
	return []VirtualMachineRestrictMovementState{VirtualMachineRestrictMovementStateDisabled, VirtualMachineRestrictMovementStateEnabled}
}

// VisibilityParameterEnum enumerates the values for visibility parameter enum.
type VisibilityParameterEnum string

const (
	// VisibilityParameterEnumHidden ...
	VisibilityParameterEnumHidden VisibilityParameterEnum = "Hidden"
	// VisibilityParameterEnumVisible ...
	VisibilityParameterEnumVisible VisibilityParameterEnum = "Visible"
)

// PossibleVisibilityParameterEnumValues returns an array of possible values for the VisibilityParameterEnum const type.
func PossibleVisibilityParameterEnumValues() []VisibilityParameterEnum {
	return []VisibilityParameterEnum{VisibilityParameterEnumHidden, VisibilityParameterEnumVisible}
}

// VMGroupStatusEnum enumerates the values for vm group status enum.
type VMGroupStatusEnum string

const (
	// VMGroupStatusEnumFAILURE ...
	VMGroupStatusEnumFAILURE VMGroupStatusEnum = "FAILURE"
	// VMGroupStatusEnumSUCCESS ...
	VMGroupStatusEnumSUCCESS VMGroupStatusEnum = "SUCCESS"
)

// PossibleVMGroupStatusEnumValues returns an array of possible values for the VMGroupStatusEnum const type.
func PossibleVMGroupStatusEnumValues() []VMGroupStatusEnum {
	return []VMGroupStatusEnum{VMGroupStatusEnumFAILURE, VMGroupStatusEnumSUCCESS}
}

// VMTypeEnum enumerates the values for vm type enum.
type VMTypeEnum string

const (
	// VMTypeEnumEDGE ...
	VMTypeEnumEDGE VMTypeEnum = "EDGE"
	// VMTypeEnumREGULAR ...
	VMTypeEnumREGULAR VMTypeEnum = "REGULAR"
	// VMTypeEnumSERVICE ...
	VMTypeEnumSERVICE VMTypeEnum = "SERVICE"
)

// PossibleVMTypeEnumValues returns an array of possible values for the VMTypeEnum const type.
func PossibleVMTypeEnumValues() []VMTypeEnum {
	return []VMTypeEnum{VMTypeEnumEDGE, VMTypeEnumREGULAR, VMTypeEnumSERVICE}
}

// WorkloadNetworkDhcpProvisioningState enumerates the values for workload network dhcp provisioning state.
type WorkloadNetworkDhcpProvisioningState string

const (
	// WorkloadNetworkDhcpProvisioningStateBuilding ...
	WorkloadNetworkDhcpProvisioningStateBuilding WorkloadNetworkDhcpProvisioningState = "Building"
	// WorkloadNetworkDhcpProvisioningStateDeleting ...
	WorkloadNetworkDhcpProvisioningStateDeleting WorkloadNetworkDhcpProvisioningState = "Deleting"
	// WorkloadNetworkDhcpProvisioningStateFailed ...
	WorkloadNetworkDhcpProvisioningStateFailed WorkloadNetworkDhcpProvisioningState = "Failed"
	// WorkloadNetworkDhcpProvisioningStateSucceeded ...
	WorkloadNetworkDhcpProvisioningStateSucceeded WorkloadNetworkDhcpProvisioningState = "Succeeded"
	// WorkloadNetworkDhcpProvisioningStateUpdating ...
	WorkloadNetworkDhcpProvisioningStateUpdating WorkloadNetworkDhcpProvisioningState = "Updating"
)

// PossibleWorkloadNetworkDhcpProvisioningStateValues returns an array of possible values for the WorkloadNetworkDhcpProvisioningState const type.
func PossibleWorkloadNetworkDhcpProvisioningStateValues() []WorkloadNetworkDhcpProvisioningState {
	return []WorkloadNetworkDhcpProvisioningState{WorkloadNetworkDhcpProvisioningStateBuilding, WorkloadNetworkDhcpProvisioningStateDeleting, WorkloadNetworkDhcpProvisioningStateFailed, WorkloadNetworkDhcpProvisioningStateSucceeded, WorkloadNetworkDhcpProvisioningStateUpdating}
}

// WorkloadNetworkDNSServiceProvisioningState enumerates the values for workload network dns service
// provisioning state.
type WorkloadNetworkDNSServiceProvisioningState string

const (
	// WorkloadNetworkDNSServiceProvisioningStateBuilding ...
	WorkloadNetworkDNSServiceProvisioningStateBuilding WorkloadNetworkDNSServiceProvisioningState = "Building"
	// WorkloadNetworkDNSServiceProvisioningStateDeleting ...
	WorkloadNetworkDNSServiceProvisioningStateDeleting WorkloadNetworkDNSServiceProvisioningState = "Deleting"
	// WorkloadNetworkDNSServiceProvisioningStateFailed ...
	WorkloadNetworkDNSServiceProvisioningStateFailed WorkloadNetworkDNSServiceProvisioningState = "Failed"
	// WorkloadNetworkDNSServiceProvisioningStateSucceeded ...
	WorkloadNetworkDNSServiceProvisioningStateSucceeded WorkloadNetworkDNSServiceProvisioningState = "Succeeded"
	// WorkloadNetworkDNSServiceProvisioningStateUpdating ...
	WorkloadNetworkDNSServiceProvisioningStateUpdating WorkloadNetworkDNSServiceProvisioningState = "Updating"
)

// PossibleWorkloadNetworkDNSServiceProvisioningStateValues returns an array of possible values for the WorkloadNetworkDNSServiceProvisioningState const type.
func PossibleWorkloadNetworkDNSServiceProvisioningStateValues() []WorkloadNetworkDNSServiceProvisioningState {
	return []WorkloadNetworkDNSServiceProvisioningState{WorkloadNetworkDNSServiceProvisioningStateBuilding, WorkloadNetworkDNSServiceProvisioningStateDeleting, WorkloadNetworkDNSServiceProvisioningStateFailed, WorkloadNetworkDNSServiceProvisioningStateSucceeded, WorkloadNetworkDNSServiceProvisioningStateUpdating}
}

// WorkloadNetworkDNSZoneProvisioningState enumerates the values for workload network dns zone provisioning
// state.
type WorkloadNetworkDNSZoneProvisioningState string

const (
	// WorkloadNetworkDNSZoneProvisioningStateBuilding ...
	WorkloadNetworkDNSZoneProvisioningStateBuilding WorkloadNetworkDNSZoneProvisioningState = "Building"
	// WorkloadNetworkDNSZoneProvisioningStateDeleting ...
	WorkloadNetworkDNSZoneProvisioningStateDeleting WorkloadNetworkDNSZoneProvisioningState = "Deleting"
	// WorkloadNetworkDNSZoneProvisioningStateFailed ...
	WorkloadNetworkDNSZoneProvisioningStateFailed WorkloadNetworkDNSZoneProvisioningState = "Failed"
	// WorkloadNetworkDNSZoneProvisioningStateSucceeded ...
	WorkloadNetworkDNSZoneProvisioningStateSucceeded WorkloadNetworkDNSZoneProvisioningState = "Succeeded"
	// WorkloadNetworkDNSZoneProvisioningStateUpdating ...
	WorkloadNetworkDNSZoneProvisioningStateUpdating WorkloadNetworkDNSZoneProvisioningState = "Updating"
)

// PossibleWorkloadNetworkDNSZoneProvisioningStateValues returns an array of possible values for the WorkloadNetworkDNSZoneProvisioningState const type.
func PossibleWorkloadNetworkDNSZoneProvisioningStateValues() []WorkloadNetworkDNSZoneProvisioningState {
	return []WorkloadNetworkDNSZoneProvisioningState{WorkloadNetworkDNSZoneProvisioningStateBuilding, WorkloadNetworkDNSZoneProvisioningStateDeleting, WorkloadNetworkDNSZoneProvisioningStateFailed, WorkloadNetworkDNSZoneProvisioningStateSucceeded, WorkloadNetworkDNSZoneProvisioningStateUpdating}
}

// WorkloadNetworkPortMirroringProvisioningState enumerates the values for workload network port mirroring
// provisioning state.
type WorkloadNetworkPortMirroringProvisioningState string

const (
	// WorkloadNetworkPortMirroringProvisioningStateBuilding ...
	WorkloadNetworkPortMirroringProvisioningStateBuilding WorkloadNetworkPortMirroringProvisioningState = "Building"
	// WorkloadNetworkPortMirroringProvisioningStateDeleting ...
	WorkloadNetworkPortMirroringProvisioningStateDeleting WorkloadNetworkPortMirroringProvisioningState = "Deleting"
	// WorkloadNetworkPortMirroringProvisioningStateFailed ...
	WorkloadNetworkPortMirroringProvisioningStateFailed WorkloadNetworkPortMirroringProvisioningState = "Failed"
	// WorkloadNetworkPortMirroringProvisioningStateSucceeded ...
	WorkloadNetworkPortMirroringProvisioningStateSucceeded WorkloadNetworkPortMirroringProvisioningState = "Succeeded"
	// WorkloadNetworkPortMirroringProvisioningStateUpdating ...
	WorkloadNetworkPortMirroringProvisioningStateUpdating WorkloadNetworkPortMirroringProvisioningState = "Updating"
)

// PossibleWorkloadNetworkPortMirroringProvisioningStateValues returns an array of possible values for the WorkloadNetworkPortMirroringProvisioningState const type.
func PossibleWorkloadNetworkPortMirroringProvisioningStateValues() []WorkloadNetworkPortMirroringProvisioningState {
	return []WorkloadNetworkPortMirroringProvisioningState{WorkloadNetworkPortMirroringProvisioningStateBuilding, WorkloadNetworkPortMirroringProvisioningStateDeleting, WorkloadNetworkPortMirroringProvisioningStateFailed, WorkloadNetworkPortMirroringProvisioningStateSucceeded, WorkloadNetworkPortMirroringProvisioningStateUpdating}
}

// WorkloadNetworkPublicIPProvisioningState enumerates the values for workload network public ip provisioning
// state.
type WorkloadNetworkPublicIPProvisioningState string

const (
	// WorkloadNetworkPublicIPProvisioningStateBuilding ...
	WorkloadNetworkPublicIPProvisioningStateBuilding WorkloadNetworkPublicIPProvisioningState = "Building"
	// WorkloadNetworkPublicIPProvisioningStateDeleting ...
	WorkloadNetworkPublicIPProvisioningStateDeleting WorkloadNetworkPublicIPProvisioningState = "Deleting"
	// WorkloadNetworkPublicIPProvisioningStateFailed ...
	WorkloadNetworkPublicIPProvisioningStateFailed WorkloadNetworkPublicIPProvisioningState = "Failed"
	// WorkloadNetworkPublicIPProvisioningStateSucceeded ...
	WorkloadNetworkPublicIPProvisioningStateSucceeded WorkloadNetworkPublicIPProvisioningState = "Succeeded"
	// WorkloadNetworkPublicIPProvisioningStateUpdating ...
	WorkloadNetworkPublicIPProvisioningStateUpdating WorkloadNetworkPublicIPProvisioningState = "Updating"
)

// PossibleWorkloadNetworkPublicIPProvisioningStateValues returns an array of possible values for the WorkloadNetworkPublicIPProvisioningState const type.
func PossibleWorkloadNetworkPublicIPProvisioningStateValues() []WorkloadNetworkPublicIPProvisioningState {
	return []WorkloadNetworkPublicIPProvisioningState{WorkloadNetworkPublicIPProvisioningStateBuilding, WorkloadNetworkPublicIPProvisioningStateDeleting, WorkloadNetworkPublicIPProvisioningStateFailed, WorkloadNetworkPublicIPProvisioningStateSucceeded, WorkloadNetworkPublicIPProvisioningStateUpdating}
}

// WorkloadNetworkSegmentProvisioningState enumerates the values for workload network segment provisioning
// state.
type WorkloadNetworkSegmentProvisioningState string

const (
	// WorkloadNetworkSegmentProvisioningStateBuilding ...
	WorkloadNetworkSegmentProvisioningStateBuilding WorkloadNetworkSegmentProvisioningState = "Building"
	// WorkloadNetworkSegmentProvisioningStateDeleting ...
	WorkloadNetworkSegmentProvisioningStateDeleting WorkloadNetworkSegmentProvisioningState = "Deleting"
	// WorkloadNetworkSegmentProvisioningStateFailed ...
	WorkloadNetworkSegmentProvisioningStateFailed WorkloadNetworkSegmentProvisioningState = "Failed"
	// WorkloadNetworkSegmentProvisioningStateSucceeded ...
	WorkloadNetworkSegmentProvisioningStateSucceeded WorkloadNetworkSegmentProvisioningState = "Succeeded"
	// WorkloadNetworkSegmentProvisioningStateUpdating ...
	WorkloadNetworkSegmentProvisioningStateUpdating WorkloadNetworkSegmentProvisioningState = "Updating"
)

// PossibleWorkloadNetworkSegmentProvisioningStateValues returns an array of possible values for the WorkloadNetworkSegmentProvisioningState const type.
func PossibleWorkloadNetworkSegmentProvisioningStateValues() []WorkloadNetworkSegmentProvisioningState {
	return []WorkloadNetworkSegmentProvisioningState{WorkloadNetworkSegmentProvisioningStateBuilding, WorkloadNetworkSegmentProvisioningStateDeleting, WorkloadNetworkSegmentProvisioningStateFailed, WorkloadNetworkSegmentProvisioningStateSucceeded, WorkloadNetworkSegmentProvisioningStateUpdating}
}

// WorkloadNetworkVMGroupProvisioningState enumerates the values for workload network vm group provisioning
// state.
type WorkloadNetworkVMGroupProvisioningState string

const (
	// WorkloadNetworkVMGroupProvisioningStateBuilding ...
	WorkloadNetworkVMGroupProvisioningStateBuilding WorkloadNetworkVMGroupProvisioningState = "Building"
	// WorkloadNetworkVMGroupProvisioningStateDeleting ...
	WorkloadNetworkVMGroupProvisioningStateDeleting WorkloadNetworkVMGroupProvisioningState = "Deleting"
	// WorkloadNetworkVMGroupProvisioningStateFailed ...
	WorkloadNetworkVMGroupProvisioningStateFailed WorkloadNetworkVMGroupProvisioningState = "Failed"
	// WorkloadNetworkVMGroupProvisioningStateSucceeded ...
	WorkloadNetworkVMGroupProvisioningStateSucceeded WorkloadNetworkVMGroupProvisioningState = "Succeeded"
	// WorkloadNetworkVMGroupProvisioningStateUpdating ...
	WorkloadNetworkVMGroupProvisioningStateUpdating WorkloadNetworkVMGroupProvisioningState = "Updating"
)

// PossibleWorkloadNetworkVMGroupProvisioningStateValues returns an array of possible values for the WorkloadNetworkVMGroupProvisioningState const type.
func PossibleWorkloadNetworkVMGroupProvisioningStateValues() []WorkloadNetworkVMGroupProvisioningState {
	return []WorkloadNetworkVMGroupProvisioningState{WorkloadNetworkVMGroupProvisioningStateBuilding, WorkloadNetworkVMGroupProvisioningStateDeleting, WorkloadNetworkVMGroupProvisioningStateFailed, WorkloadNetworkVMGroupProvisioningStateSucceeded, WorkloadNetworkVMGroupProvisioningStateUpdating}
}
