/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.util.ArrayList;
import org.cojen.classfile.TypeDesc;
import org.cojen.classfile.attribute.Annotation;

public class AnnotationDescParser {
    private final String mStr;
    private int mPos;

    public AnnotationDescParser(String annotationString) {
        this.mStr = annotationString;
    }

    public Annotation parse(Annotation rootAnnotation) {
        this.mPos = 0;
        if (this.parseTag() != '@') {
            throw this.error("Malformed");
        }
        TypeDesc rootAnnotationType = this.parseTypeDesc();
        if (rootAnnotation == null) {
            rootAnnotation = this.buildRootAnnotation(rootAnnotationType);
        } else if (!rootAnnotationType.equals(rootAnnotation.getType())) {
            throw new IllegalArgumentException("Annotation type of \"" + rootAnnotationType + "\" does not match expected type of \"" + rootAnnotation.getType());
        }
        this.parseAnnotation(rootAnnotation, rootAnnotationType);
        return rootAnnotation;
    }

    protected Annotation buildRootAnnotation(TypeDesc rootAnnotationType) {
        throw new UnsupportedOperationException();
    }

    private void parseAnnotation(Annotation dest, TypeDesc annType) {
        while (true) {
            Annotation.MemberValue mv;
            try {
                if (this.mStr.charAt(this.mPos) == ';') {
                    ++this.mPos;
                    break;
                }
            }
            catch (IndexOutOfBoundsException e) {
                this.error("Missing terminator");
            }
            if (this.mPos >= this.mStr.length()) break;
            String propName = this.parseName();
            char propTag = this.peekTag();
            if (propTag == '[') {
                ++this.mPos;
                mv = this.parseArray(dest, this.peekTag(), this.parseTypeDesc());
            } else {
                mv = this.parseProperty(dest, propTag, this.parseTypeDesc());
            }
            dest.putMemberValue(propName, mv);
        }
    }

    private Annotation.MemberValue parseArray(Annotation dest, char compTag, TypeDesc compType) {
        ArrayList<Annotation.MemberValue> mvList = new ArrayList<Annotation.MemberValue>();
        while (true) {
            try {
                if (this.mStr.charAt(this.mPos) == ';') {
                    ++this.mPos;
                    break;
                }
            }
            catch (IndexOutOfBoundsException e) {
                this.error("Missing terminator");
            }
            mvList.add(this.parseProperty(dest, compTag, compType));
        }
        Annotation.MemberValue[] mvArray = new Annotation.MemberValue[mvList.size()];
        return dest.makeMemberValue(mvList.toArray(mvArray));
    }

    private Annotation.MemberValue parseProperty(Annotation dest, char propTag, TypeDesc propType) {
        Annotation.MemberValue mv;
        try {
            if (propTag == 's') {
                char c;
                StringBuilder b = new StringBuilder();
                while ((c = this.mStr.charAt(this.mPos++)) != ';') {
                    if (c == '\\') {
                        c = this.mStr.charAt(this.mPos++);
                    }
                    b.append(c);
                }
                mv = dest.makeMemberValue(b.toString());
            } else if (propTag == 'Z') {
                mv = dest.makeMemberValue(this.mStr.charAt(this.mPos++) != '0');
            } else if (propTag == 'C') {
                mv = dest.makeMemberValue(this.mStr.charAt(this.mPos++));
            } else if (propTag == '@') {
                Annotation propAnn = dest.makeAnnotation();
                propAnn.setType(propType);
                this.parseAnnotation(propAnn, propType);
                mv = dest.makeMemberValue(propAnn);
            } else if (propTag == 'c') {
                mv = dest.makeMemberValue(this.parseTypeDesc());
            } else {
                int endPos = this.nextTerminator();
                String valueStr = this.mStr.substring(this.mPos, endPos);
                switch (propTag) {
                    default: {
                        throw this.error("Invalid tag");
                    }
                    case 'B': {
                        mv = dest.makeMemberValue(Byte.parseByte(valueStr));
                        break;
                    }
                    case 'S': {
                        mv = dest.makeMemberValue(Short.parseShort(valueStr));
                        break;
                    }
                    case 'I': {
                        mv = dest.makeMemberValue(Integer.parseInt(valueStr));
                        break;
                    }
                    case 'J': {
                        mv = dest.makeMemberValue(Long.parseLong(valueStr));
                        break;
                    }
                    case 'F': {
                        mv = dest.makeMemberValue(Float.parseFloat(valueStr));
                        break;
                    }
                    case 'D': {
                        mv = dest.makeMemberValue(Double.parseDouble(valueStr));
                        break;
                    }
                    case 'e': {
                        mv = dest.makeMemberValue(propType, valueStr);
                    }
                }
                this.mPos = endPos + 1;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw this.error("Invalid property value");
        }
        return mv;
    }

    private TypeDesc parseTypeDesc() {
        try {
            int endPos2;
            switch (this.mStr.charAt(this.mPos)) {
                default: {
                    throw this.error("Invalid tag");
                }
                case '[': {
                    ++this.mPos;
                    return this.parseTypeDesc().toArrayType();
                }
                case 's': {
                    ++this.mPos;
                    return TypeDesc.STRING;
                }
                case 'c': {
                    ++this.mPos;
                    return TypeDesc.forClass(Class.class);
                }
                case '@': {
                    ++this.mPos;
                    return this.parseTypeDesc();
                }
                case 'e': {
                    ++this.mPos;
                    int endPos2 = this.nextTerminator();
                    int dot = this.mStr.lastIndexOf(46, endPos2);
                    if (dot < this.mPos) {
                        throw this.error("Invalid enumeration");
                    }
                    TypeDesc type = TypeDesc.forClass(this.mStr.substring(this.mPos, dot));
                    this.mPos = dot + 1;
                    return type;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    endPos2 = this.mPos + 1;
                    break;
                }
                case 'L': {
                    endPos2 = this.nextTerminator() + 1;
                }
            }
            TypeDesc type = TypeDesc.forDescriptor(this.mStr.substring(this.mPos, endPos2));
            this.mPos = endPos2;
            return type;
        }
        catch (IndexOutOfBoundsException e) {
            throw this.error("Invalid type descriptor");
        }
    }

    private char peekTag() {
        char tag = this.parseTag();
        --this.mPos;
        return tag;
    }

    private char parseTag() {
        try {
            return this.mStr.charAt(this.mPos++);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.error("Too short");
        }
    }

    private String parseName() {
        int index = this.mStr.indexOf(61, this.mPos);
        if (index < 0) {
            throw this.error("Incomplete assignment");
        }
        String name = this.mStr.substring(this.mPos, index);
        this.mPos = index + 1;
        return name;
    }

    private int nextTerminator() {
        int index = this.mStr.indexOf(59, this.mPos);
        if (index < 0) {
            throw this.error("Missing terminator");
        }
        return index;
    }

    private IllegalArgumentException error(String message) {
        message = "Illegal annotation descriptor: " + message + " at position " + this.mPos + " of " + this.mStr;
        return new IllegalArgumentException(message);
    }
}

