#ifndef GUI_H
#define GUI_H

#include <stdio.h>
#include <stdlib.h>
#include <QtWidgets/QWidget>
#include <QtWidgets/QHBoxLayout>
#include <QtWidgets/QVBoxLayout>
#include <QtWidgets/QTabWidget>
#include <QtWidgets/QButtonGroup>
#include <QtWidgets/QSlider>
#include <QtWidgets/QLabel>
#include <QtWidgets/QCheckBox>
#include <QtWidgets/QComboBox>
#include <QtWidgets/QTreeWidget>
#include <QtWidgets/QLineEdit>
#include <QtWidgets/QPushButton>
#include <QtWidgets/QSpinBox>
#include <QtWidgets/QTextEdit>
#include <QtWidgets/QGroupBox>
#include <QtWidgets/QRadioButton>
#include <QtWidgets/QButtonGroup>
#include <QtCore/QString>
#include "model.h"
#include "synth.h"
#include "multislider.h"
#include "modslider.h"
#include "harmonics.h"
#include "filter.h"
#include "jackprocessor.h"
#include "xmlhandler.h"
#include "textedit.h"
#include "scaladialog.h"

class Gui : public QWidget
{
  Q_OBJECT

  private:
    Model *model;
    JackProcessor *jackProcessor;
    Synth *synth;
    TextEdit *textEditor;
    ScalaDialog *scalaDialog;
    Harmonics *harmonics[MAX_PARAMS];
    Filter *filter[2];
    MultiSlider *harmonicScale[MAX_PARAMS];
    QSlider *lowerHarmonicRandomLevelSlider, *upperHarmonicRandomLevelSlider;
    QPushButton *randomizeHarmonicsButton;
    QCheckBox *addRandomCheck;
    QCheckBox *showPolygonCheck;
    ModSlider *pitchLFOfreq, *pitchLFOdepth, *morphingSlider, *masterVolume, *detuneSlider, *offsetDetuneSlider, *randomSlider;
    ModSlider *spectrumOffset[4], *spectrumSpacing[4], *evenOddSlider[3], *osc3FreqDiffusionSlider, *noiseFreqDiffusionSlider;
    ModSlider *filterCutoff[4], *filterSpacing[4], *filterKeyTracking[2], *filterDepth[2];
    ModSlider *filterMixSlider[MAX_SOURCES][6];
    QCheckBox *filterMixCheckBox[MAX_SOURCES][3];
    ModSlider *filterModSlider[2][13];
    QCheckBox *filterModCheckBox[2][7];
    ModSlider *noiseSlider[4];
    QCheckBox *noiseSubHarmonicCheck;
    ModSlider *compressorSlider[4];
    ModSlider *panSlider[2];
    ModSlider *volumeTrackingSlider, *velocityDepthSlider;
    QComboBox *panMode; 
    QComboBox *spectrumOffsetCombo[2], *spectrumSpacingCombo[2];
    QComboBox *filterCutoffCombo[2], *filterSpacingCombo[2], *filterTrackingCombo[2];
    QComboBox *osc3ModeCombo;
    QComboBox *midiGroupCombo;
    QSlider *modDepthSlider;
    QLabel *modDepthLabel;
    QCheckBox *modFullToggle, *modInverseToggle;
    QTabWidget *mainTab;
    QTabWidget *harmonicTab;
    QButtonGroup *groupSelector;
    QRadioButton *radio[MAX_SCENES][MAX_SOURCES];
    QGroupBox *groupBox[MAX_SCENES];
    QHBoxLayout *radioLayout[MAX_SCENES];
    QTreeWidget *midiControllerTree, *controlObjectTree;
    QLabel *voiceFileLabel;
    QString voiceFileName;
    QPushButton *voiceRangeSetButton;
    QSpinBox *voiceRangeStart, *voiceRangeEnd, *voiceChannel;
    QTreeWidget *voiceTree;
    QString comment;
    bool addRandomFlag, showPolygonFlag;
    int lowerRandomLevel, upperRandomLevel;
    bool followMidi, modifiedFlag;
    bool systemMode; 
    QString presetPrefix;
    int presetFolder, presetBank, presetNum;
    void addControlFolder(QString name);
    void addControlObject(QString name, int objectType, int objectIndex);
    void setFilter(int index, int voiceIndex, double modValue, int value);
    void setMixer(int index, int voiceIndex, double modValue, int value);
    void setModulation(int filterIndex, int paramIndex, int voiceIndex, double modValue, int value);
    int getDisplayGroupIndex(int index);

  public:
    Gui(Model *p_model, QWidget* parent=0);
    ~Gui();
     bool hasMidiController(int type, unsigned char eventChannel,
                            unsigned int eventParam, int value, int voiceIndex);
     int getCommon(int objectType, int objectIndex, int voiceIndex);
     int getOscillators(int objectType, int objectIndex, int voiceIndex);
     int getNoise(int objectType, int objectIndex, int voiceIndex);
     int getMixer(int objectIndex, int voiceIndex);
     int getFilter(int objectIndex, int voiceIndex);
     int getModulation(int filterIndex, int objectIndex, int voiceIndex);
     int getVolume(int objectType, int objectIndex, int voiceIndex);
     void loadXML(bool loadDefault, QString fileName);
     void saveXML(QString fileName);
     void loadMidi(bool loadDefault);
     void updatePresetLEDs();
     void updateSwitches();
     void loadPreset();
     void savePreset();
     void presetIOsuccess();
 
  public slots: 
    void showAbout();
    void editVoice(int voiceIndex);
    void loadVoiceXML(int voiceIndex);
    void saveVoiceXML(int voiceIndex);
    void mainTabChanged(int index);
    void voiceTreeChanged(QTreeWidgetItem *item, QTreeWidgetItem *previous);
    void loadXML();
    void saveXML();
    void loadMidi();
    void saveMidi();
    void addComment();
    void editComment();
    void showComment();
    void cancelComment();
    void commentOK();
    void showScalaDialog();
    void reScale(int value);
    void selectGroup(int p_group);
    void updateTab(int id);
    void updateMainTab(int groupSwitchState);
    void updateMidiController(int radioGroup);
    void closeGui();
    void setCommon(int objectType, int objectIndex, int voiceIndex, double modValue, int value);
    void setOscillators(int objectType, int objectIndex, int voiceIndex, double modValue, int value);
    void setGlobalScale(int objectType, int objectIndex, int voiceIndex, double modValue, int value);
    void setPitchLFOfreq(int value);
    void setPitchLFOdepth(int value);
    void setEvenOdd(int value);
    void setMasterVolume(int value);
    void setSpectrumOffset(int value);
    void setSpectrumSpacing(int value);
    void setSpectrumOffsetCombo(int index);
    void setSpectrumSpacingCombo(int index);
    void setMorphing(int value);
    void setCompressor(int value);
    void setPan(int value);
    void setPanMode(int index);
    void setFilterCutoff(int value);
    void setFilterSpacing(int value);
    void setFilterCutoffCombo(int index);
    void setFilterSpacingCombo(int index);
    void setFilterKeyTracking(int value); 
    void setFilterTrackingCombo(int value); 
    void setFilterDepth(int value);
    void setFilterMix(int value);
    void filterMixToggled(int value);
    void setFilterMod(int value);
    void filterModToggled(int value);
    void setNoise(int value);
    void setNoise(int objectType, int objectIndex, int voiceIndex, double modValue, int value);
    void setNoiseFreqDiffusion(int value);
    void noiseSubHarmonicToggled(int value);
    void setOsc3ModeCombo(int index);
    void setOsc3FreqDiffusion(int value);
    void setDetune(int value);
    void setOffsetDetune(int value);
    void setVoiceRandom(int value);
    void setModDepth(int value);
    void modFullToggled(int value);
    void modInverseToggled(int value);
    void lowerRandomLevelChanged(int value);
    void upperRandomLevelChanged(int value);
    void randomizeHarmonics();
    void addRandomToggled(int value);
    void showPolygonToggled(int value);
    void connectController();
    void connectController(QTreeWidgetItem *midiControllerItem, int objectType, int objectIndex, int groupIndex, int modDepth, bool full, bool inverse);
    void disconnectController();
    void processMidiController(int type, unsigned char eventChannel,
                               unsigned int eventParam, int value, int voiceIndex);
    void addMidiController(int type, unsigned char eventChannel,
                           unsigned int eventParam); 
    void addGroupSwitch(int radioGroupID, int radioGroupIndex);                       
    void setToggle(int objectIndex, int val);
    void setSourceSwitch(int objectIndex, int val);
    void setFilterSwitch(int objectIndex, int val);
    void setGroupSwitch(int objectIndex, int val); 
    void midiCurrentItemChanged(QTreeWidgetItem *current, QTreeWidgetItem *previous);
    void voiceRangeSet();
    void voiceRangeStartChanged(int value);
    void voiceRangeEndChanged(int value);
    void voiceChannelChanged(int value);
    void xmlInput(tokenCodeEnum code, int index1, int index2, int index3, int voiceIndex, double value);
    void process_MidiNoteOn(int voiceIndex);
    void setMidiGroup(int index);
    void setVolumeTracking(int value);
    void setVelocityDepth(int value);
    void setVolumeTrackingMidi(int voiceIndex, int value);
    void setVelocityDepthMidi(int voiceIndex, int value);
};

#endif
