/*
 *  Copyright (c) 1994, Riley Rainey,  riley@netcon.com
 *
 *  Permission to use, copy, modify and distribute (without charge) this
 *  software, documentation, images, etc. is granted, provided that this 
 *  comment and the author's name is retained.
 *
 *  This software is provided by the author as is, and without any expressed
 *  or implied warranties, including, but not limited to, the implied
 *  warranties of merchantability and fitness for a particular purpose.  In no
 *  event shall the author be liable for any direct, indirect, incidental, or
 *  consequential damages arising in any way out of the use of this software.
 */

#ifndef cell_H
#define cell_H

#ifdef cell_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

struct cell {
	int     id;
	char    *prompt;
	char    *initial_value;
	int     field_width;
	Widget  field;
	Widget  label;
	};

EXTERN int LocateCell (struct cell *p, int id);

EXTERN double GetCellValueDouble (struct cell *p, int n, double *value);

EXTERN void SetCellValueDouble (struct cell *p, int n, double value);

EXTERN char * GetCellValueString (struct cell *p, int n, char *value);

EXTERN void SetCellValueString (struct cell *p, int n, char *value);

#undef EXTERN
#endif
