/*
 *  acm : an aerial combat simulator for X
 *  Copyright (C) 2007  Umberto Salsi
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

/**
 * Simple one-line text feedback on the virtual terminal.
 * @file
 */

#ifndef _prompt_h
#define _prompt_h

#include "pm.h"

#ifdef prompt_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/** Release u->prompt data. */
EXTERN void prompt_free(viewer *u);

EXTERN void prompt_viewer_print(viewer *u, char *s);

/**
 * Displays the given string in the cockpit area of the given
 * viewer. Intended to provide to the user some feedback about events
 * internal to the program that otherwise would not be noticed. The
 * message get cleared after some seconds. A new message clears the
 * old one.
 */
EXTERN void prompt_craft_print(craft *c, char *s);

/**
 * Broadcast the message to all the viewers.
 */
EXTERN void prompt_broadcast_print(char *s);

/**
 * The renderer module must call this to draw the current message.
 */
EXTERN void prompt_draw(viewer *u);

#undef EXTERN
#endif
