#
# PySNMP MIB module TN3270E-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/TN3270E-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:31:36 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( SingleValueConstraint, ValueRangeConstraint, ConstraintsUnion, ConstraintsIntersection, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "SingleValueConstraint", "ValueRangeConstraint", "ConstraintsUnion", "ConstraintsIntersection", "ValueSizeConstraint")
( IANATn3270DeviceType, IANATn3270eAddrType, IANATn3270ResourceType, IANATn3270Functions, IANATn3270eLogData, IANATn3270eClientType, IANATn3270eAddress, ) = mibBuilder.importSymbols("IANATn3270eTC-MIB", "IANATn3270DeviceType", "IANATn3270eAddrType", "IANATn3270ResourceType", "IANATn3270Functions", "IANATn3270eLogData", "IANATn3270eClientType", "IANATn3270eAddress")
( snanauMIB, ) = mibBuilder.importSymbols("SNA-NAU-MIB", "snanauMIB")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, ObjectGroup, NotificationGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup", "NotificationGroup")
( Counter32, Bits, MibScalar, MibTable, MibTableRow, MibTableColumn, iso, Unsigned32, Integer32, Gauge32, NotificationType, ObjectIdentity, TimeTicks, MibIdentifier, Counter64, ModuleIdentity, IpAddress, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Counter32", "Bits", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "iso", "Unsigned32", "Integer32", "Gauge32", "NotificationType", "ObjectIdentity", "TimeTicks", "MibIdentifier", "Counter64", "ModuleIdentity", "IpAddress")
( DisplayString, TestAndIncr, DateAndTime, TextualConvention, RowStatus, TimeStamp, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "TestAndIncr", "DateAndTime", "TextualConvention", "RowStatus", "TimeStamp")
( Utf8String, ) = mibBuilder.importSymbols("SYSAPPL-MIB", "Utf8String")
tn3270eMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 34, 8)).setRevisions(("1998-07-27 00:00",))
if mibBuilder.loadTexts: tn3270eMIB.setLastUpdated('9807270000Z')
if mibBuilder.loadTexts: tn3270eMIB.setOrganization('TN3270E Working Group')
if mibBuilder.loadTexts: tn3270eMIB.setContactInfo('Kenneth White (kennethw@vnet.ibm.com)\n             IBM Corp. - Dept. BRQA/Bldg. 501/G114\n             P.O. Box 12195\n             3039 Cornwallis\n             RTP, NC 27709-2195\n             USA\n\n             Robert Moore (remoore@us.ibm.com)\n             IBM Corp. - Dept. BRQA/Bldg. 501/G114\n             P.O. Box 12195\n             3039 Cornwallis\n             RTP, NC 27709-2195\n             USA\n             +1-919-254-4436')
if mibBuilder.loadTexts: tn3270eMIB.setDescription('This module defines a portion of the management\n            information base (MIB) for managing TN3270E servers.')
class SnaResourceName(OctetString, TextualConvention):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,17)

class Tn3270eTraceData(OctetString, TextualConvention):
    subtypeSpec = OctetString.subtypeSpec+ConstraintsUnion(ValueSizeConstraint(0,0),ValueSizeConstraint(3,4096),)
tn3270eNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 8, 0))
tn3270eObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 8, 1))
tn3270eConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 8, 3))
tn3270eSrvrConfTable = MibTable((1, 3, 6, 1, 2, 1, 34, 8, 1, 1), )
if mibBuilder.loadTexts: tn3270eSrvrConfTable.setDescription('This table defines the configuration elements for\n          TN3270E servers.  The number of entries in this table\n          is expected to vary depending on the location of the\n          table.  A particular TN3270E server is expected to\n          have a single entry.  Modeling of the configuration\n          elements as a table allows multiple TN3270E\n          servers to be serviced by the same SNMP agent.\n          An implementation SHOULD NOT retain an SNMP-created\n          entry in this table across re-IPLs (Initial Program\n          Loads) of the corresponding TN3270E server.')
tn3270eSrvrConfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1), ).setIndexNames((0, "TN3270E-MIB", "tn3270eSrvrConfIndex"))
if mibBuilder.loadTexts: tn3270eSrvrConfEntry.setDescription('Definition of the configuration elements for a single\n          TN3270E server.')
tn3270eSrvrConfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: tn3270eSrvrConfIndex.setDescription('Identifier for a single TN3270E server.\n\n         tn3270eSrvrConfIndex values need not be\n         contiguous.')
tn3270eSrvrConfInactivityTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,99999999))).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eSrvrConfInactivityTimeout.setDescription('The inactivity time-out specified in seconds.  When a\n          connection has been inactive for the number of seconds\n          specified by this object it is closed.  Only user traffic\n          is considered when determining whether there has been\n          activity on a connection.\n\n          The default value 0 means that no inactivity time-out is\n          in effect.')
tn3270eSrvrConfConnectivityChk = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("timingMark", 1), ("nop", 2), ("noCheck", 3),)).clone('noCheck')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eSrvrConfConnectivityChk.setDescription('This object enables TIMING-MARK processing, NOP\n          processing, or neither for a TN3270E server.')
tn3270eSrvrConfTmNopInactTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 4), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,86400)).clone(600)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eSrvrConfTmNopInactTime.setDescription('The amount of time a connection must have had no\n         traffic on it in order for a TIMING-MARK or NOP request\n         to be sent on the connection.  This value applies only\n         when connections are being examined for recent activity\n         on a scan interval controlled by the value of the\n         tn3270eSrvrConfTmNopInterval object.')
tn3270eSrvrConfTmNopInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 5), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,86400)).clone(120)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eSrvrConfTmNopInterval.setDescription('The scan interval to be used by a TN3270E server when\n         it examines its Telnet connections for recent activity.\n         The server scans its Telnet connections on the interval\n         provided by this object, looking for ones that have been\n         idle for more than the value provided by the\n         tn3270eSrvrConfTmNopInactTime object.  A TIMING-MARK or\n         NOP request is sent for each connection that has\n         exhibited no activity for this period of time.')
tn3270eSrvrFunctionsSupported = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 6), IANATn3270Functions().clone(namedValues=NamedValues(("scsCtlCodes", 5), ("dataStreamCtl", 6), ("responses", 7), ("bindImage", 8), ("sysreq", 9),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrFunctionsSupported.setDescription('This object indicates the functions supported by a\n          TN3270E server.')
tn3270eSrvrConfAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("up", 1), ("down", 2), ("stopImmediate", 3),)).clone('up')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eSrvrConfAdminStatus.setDescription('The desired state of the TN3270E server represented\n           by this entry in the table:\n\n           up(1)            - Activate this TN3270E server.\n           down(2)          - Informs the associated TN3270E\n                              server to gracefully terminate\n                              its processing.\n           stopImmediate(3) - Informs the associated TN3270E\n                              server to terminate itself\n                              immediately.\n\n           When a managed system creates an entry in this table,\n           tn3270eSrvrConfAdminStatus and tn3270eSrvrConfOperStatus\n           are initialized as up(1) by default.\n\n           The exact behavior of a server in response to a down(2)\n           or stopImmediate(3) command is left implementation-\n           dependent.  A TN3270E server that is capable of it\n           SHOULD close all of its TN3270 and TN3270E sessions\n           during a graceful termination.\n\n           Often the function enabled via stopImmediate(3) is used\n           as a last resort by a system administrator, to attempt\n           to either bring down a hung TN3270E server or free up\n           its resources immediately to aid in general system\n           availability, or to shut down a TN3270E server that is\n           not recognizing a down(2) request.\n\n           A TN3270E server that does not distinguish between\n           down(2) or stopImmediate(3) transitions should not\n           support stopImmediate(3).')
tn3270eSrvrConfOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 8), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("up", 1), ("down", 2), ("busy", 3), ("shuttingDown", 4),)).clone('up')).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrConfOperStatus.setDescription('The current operational state of a TN3270E server.\n         The following values are defined:\n\n          up(1)            - the server is active and accepting\n                             new client connections\n          down(2)          - the server is not active\n          busy(3)          - the server is active, but is not\n                             accepting new client connections\n                             because it lacks the resources to\n                             do so\n          shuttingDown(4)  - the server is active, but is not\n                             accepting new client connections\n                             because it is in the process of\n                             performing a graceful shutdown.')
tn3270eSrvrConfSessionTermState = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 9), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("terminate", 1), ("luSessionPend", 2), ("queueSession", 3),)).clone('terminate')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eSrvrConfSessionTermState.setDescription("This object determines what a TN3270E server\n          should do when a TN3270 Session terminates:\n         terminate(1)     => Terminate the TCP connection.\n         luSessionPend(2) => Do not drop the TCP connection\n                             associated with a client when its\n                             TN3270 session ends.  Processing\n                             should redrive session initialization\n                             as if the client were first connecting.\n         queueSession(3)  => This value relates to the Close\n                             Destination PASS (CLSDST PASS) operation\n                             in VTAM.  An example provides the\n                             easiest explanation.  Suppose a TN3270E\n                             client is in session with APPL1, and\n                             APPL1 does a CLSDST PASS of the client's\n                             session to APPL2.  queueSession(3)\n                             specifies that the TN3270E server must\n                             keep the TCP connection with the client\n                             active after it receives the UNBIND from\n                             APPL1, waiting for the BIND from APPL2.")
tn3270eSrvrConfSrvrType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 10), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("host", 1), ("gateway", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrConfSrvrType.setDescription('This object indicates the type of TN3270E server.\n          The existence of MIB tables and objects that will be\n          defined by follow-on MIBs may be predicated on whether\n          the TN3270E server can be local to the same host as a\n          target application (host(1)) or will always be remote\n          (gateway(2)).\n\n          A host TN3270E server refers to an implementation where\n          the TN3270E server is collocated with the Systems\n          Network Architecture (SNA) System Services Control Point\n          (SSCP) for the dependent Secondary Logical Units (SLUs)\n          that the server makes available to its clients for\n          connecting into an SNA network.\n          A gateway TN3270E server resides on an SNA node other\n          than an SSCP, either an SNA type 2.0 node or an APPN node\n          acting in the role of a Dependent LU Requester (DLUR).\n\n          Host and gateway TN3270E server implementations typically\n          differ greatly as to their internal implementation and\n          system definition (SYSDEF) requirements.')
tn3270eSrvrConfContact = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 11), SnmpAdminString().clone(hexValue="")).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eSrvrConfContact.setDescription('This object provides a scratch pad for a TN3270E\n          server administrator for storing information for\n          later retrieval.')
tn3270eSrvrConfRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 12), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eSrvrConfRowStatus.setDescription('This object allows entries to be created and deleted\n          in the tn3270eSrvrConfTable.  Entries may also be\n          created and deleted as a result of implementation-\n          dependent operations.\n\n          With the exception of tn3270eSrvrConfSrvrType, which\n          an implementation can easily fill in for itself, all\n          the columnar objects in this table have DEFVALs\n          associated with them.  Consequently, a Management\n          Station can create a conceptual row via a SET\n          operation that specifies a value only for this object.\n\n          When a tn3270eSrvrConfEntry is deleted (by setting\n          this object to destroy(6)), this has the side-effect\n          of removing all the associated entries (i.e., those\n          having the same tn3270eSrvrConfIndex) from the\n          tn3270eSrvrPortTable, the tn3270eSrvrStatsTable, the\n          tn3270eClientGroupTable, the tn3270eResPoolTable,\n          the tn3270eSnaMapTable, the tn3270eClientResMapTable,\n          and the tn3270eResMapTable.  All entries in the\n          tn3270eTcpConnTable that belong to a TN3270E server\n          that has been deleted MUST also be removed.\n          In other words, a tn3270eSrvrConfEntry must exist for\n          a TN3270E server in order for it to have entries in\n          any of the other tables defined by this MIB.')
tn3270eSrvrConfLastActTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 13), DateAndTime().clone(hexValue="0000000000000000")).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrConfLastActTime.setDescription("This object reports the DateAndTime when a TN3270E\n          server was most recently activated.\n\n          The special value of all '00'Hs indicates that the\n          server has never been active, i.e., that the value of\n          tn3270eSrvrOperStatus has never been anything other\n          than down(2).")
tn3270eSrvrConfTmTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 1, 1, 14), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,600)).clone(5)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eSrvrConfTmTimeout.setDescription('The TIMING-MARK time-out, specified in seconds.')
tn3270eSrvrPortTable = MibTable((1, 3, 6, 1, 2, 1, 34, 8, 1, 2), )
if mibBuilder.loadTexts: tn3270eSrvrPortTable.setDescription('This table defines the TCP ports associated with\n          TN3270E servers.  No entry in this table shall exist\n          without a corresponding (same tn3270eSrvrConfIndex)\n          entry in the tn3270eSrvrConfTable existing.\n\n          An implementation SHOULD NOT retain SNMP-created\n          entries in this table across re-IPLs (Initial Program\n          Loads) of the corresponding TN3270E server.')
tn3270eSrvrPortEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 8, 1, 2, 1), ).setIndexNames((0, "TN3270E-MIB", "tn3270eSrvrConfIndex"), (0, "TN3270E-MIB", "tn3270eSrvrPort"), (0, "TN3270E-MIB", "tn3270eSrvrPortAddrType"), (0, "TN3270E-MIB", "tn3270eSrvrPortAddress"))
if mibBuilder.loadTexts: tn3270eSrvrPortEntry.setDescription('Definition of a single TCP port assignment to a\n           TN3270E server.  Assignment of a port on a local\n           address basis is enabled though use of\n           tn3270eSrvrPortAddrType and tn3270eSrvrPortAddress.\n\n           A TCP port assignment that is not restricted to\n           a local address SHALL specify a tn3270eSrvrPortAddrType\n           of unknown(0), and SHALL use a zero-length octet string\n           for the tn3270eSrvrPortAddress.')
tn3270eSrvrPort = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 2, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,65535)))
if mibBuilder.loadTexts: tn3270eSrvrPort.setDescription('Indicates a port assigned to a server.')
tn3270eSrvrPortAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 2, 1, 2), IANATn3270eAddrType())
if mibBuilder.loadTexts: tn3270eSrvrPortAddrType.setDescription('Indicates the type of an address local to the host on\n          which the TN3270E server resides that is represented\n          in tn3270eSrvrPortAddress.  A value of unknown(0)\n          SHALL be used for this object when the port is not\n          to be restricted to a local address.')
tn3270eSrvrPortAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 2, 1, 3), IANATn3270eAddress())
if mibBuilder.loadTexts: tn3270eSrvrPortAddress.setDescription("A local address on the host that a TN3270E server\n           resides on that is associated with a TCP port that\n           is to be used or is in use by a TN3270E server.\n           tn3270eClientGroupAddrType indicates the\n           address type (IPv4 or IPv6, for example).\n\n           A zero-length octet string SHALL be used as the\n           value of this object when a local address isn't\n           being specified.")
tn3270eSrvrPortRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 2, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eSrvrPortRowStatus.setDescription('This object allows entries to be created and deleted\n          in the tn3270eSrvrPortTable.  Entries may also be\n          created and deleted as a result of implementation-\n          dependent operations.\n\n          Since this is the only accessible object in this table,\n          a Management Station can create a conceptual row via a SET\n          operation that specifies a value only for this object.\n\n          An entry in this table is deleted by setting this object\n          to destroy(6).  Deletion of a tn3270eSrvrPortEntry has\n          no effect on any other table entry defined by this MIB.')
tn3270eSrvrStatsTable = MibTable((1, 3, 6, 1, 2, 1, 34, 8, 1, 3), )
if mibBuilder.loadTexts: tn3270eSrvrStatsTable.setDescription('This table defines a set of statistics concerning\n          TN3270E server performance.\n\n          No entry in this table shall exist without\n          a corresponding (same tn3270eSrvrConfIndex) entry in\n          the tn3270eSrvrConfTable existing.')
tn3270eSrvrStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1), ).setIndexNames((0, "TN3270E-MIB", "tn3270eSrvrConfIndex"), (0, "TN3270E-MIB", "tn3270eSrvrPort"), (0, "TN3270E-MIB", "tn3270eSrvrPortAddrType"), (0, "TN3270E-MIB", "tn3270eSrvrPortAddress"))
if mibBuilder.loadTexts: tn3270eSrvrStatsEntry.setDescription('A collection of statistical and maximum usage objects\n          for a single TN3270 server.  An entry can represent the total\n          activity of the server, or it can represent the activity\n          occurring at the server on either a port or a\n          port-and-local-address basis.\n\n          Collection of the statistics represented by the objects\n          in this table is not mandatory.   An implementation\n          of this table MUST use only one of the three levels of\n          refinement that this table supports for the entries\n          associated with each TN3270E server.\n\n          The indexing for a row that represents total server\n          statistics is as follows:\n\n               tn3270eSrvrConfIndex      value identifying the server\n               tn3270eSrvrPort           0\n               tn3270eSrvrPortAddrType   unknown(0)\n               tn3270eSrvrPortAddress    zero-length octet string.\n\n          On a port basis:\n\n               tn3270eSrvrConfIndex      value identifying the server\n               tn3270eSrvrPort           > 0\n               tn3270eSrvrPortAddrType   unknown(0)\n               tn3270eSrvrPortAddress    zero-length octet string.\n\n          On a port-and-local-address basis:\n\n               tn3270eSrvrConfIndex      value identifying the server\n               tn3270eSrvrPort           > 0\n               tn3270eSrvrPortAddrType   valid value other than unknown(0)\n               tn3270eSrvrPortAddress    non-zero-length octet string.\n\n         ')
tn3270eSrvrStatsUpTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 2), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsUpTime.setDescription('The value of the sysUpTime object the last time\n          the TN3270E server was re-initialized.\n\n          Server re-initialization is the only discontinuity\n          event for the counters in this table.  Even if table\n          entries are on a port or port-and-local-address\n          basis, port deactivation and reactivation do not\n          result in counter discontinuities.')
tn3270eSrvrStatsMaxTerms = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 3), Unsigned32()).setUnits('LUs').setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsMaxTerms.setDescription('Indicates the maximum number of terminal LUs available\n         for use at a TN3270E server for the granularity of this\n         conceptual row (server-wide, port, or\n         port-and-local-address).')
tn3270eSrvrStatsInUseTerms = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 4), Gauge32()).setUnits('LUs').setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsInUseTerms.setDescription('Indicates the number of terminal LUs currently in\n         use at a TN3270E server for the granularity of this\n         conceptual row (server-wide, port, or\n         port-and-local-address).')
tn3270eSrvrStatsSpareTerms = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 5), Gauge32()).setUnits('LUs').setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsSpareTerms.setDescription('Indicates the number of free terminal LUs at a TN3270E\n         server for the granularity of this conceptual row\n         (server-wide, port, or port-and-local-address).\n\n         It is possible that the difference between\n         tn3270eSrvrStatsMaxTerms and tn3270eSrvrStatsInUseTerms\n         in a conceptual row does not equal the value of\n         tn3270eSrvrStatsSpareTerms in that row:  an LU may\n         exist but not be usable by a client connection.\n\n         Alternatively, the administrative ceiling represented\n         by tn3270eSrvrStatsMaxTerms may have been lowered to\n         a point where it is less than the current value of\n         tn3270eSrvrStatsInUseTerms.  In this case\n         tn3270eSrvrStatsSpareTerms returns the value 0.')
tn3270eSrvrStatsMaxPtrs = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 6), Unsigned32()).setUnits('Printer Resources').setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsMaxPtrs.setDescription('Indicates the maximum number of printer resources\n         available for use by a TN3270E server for the\n         granularity of this conceptual row (server-wide,\n         port, or port-and-local-address).')
tn3270eSrvrStatsInUsePtrs = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 7), Gauge32()).setUnits('Printer Resources').setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsInUsePtrs.setDescription('Indicates the number of printer resources\n         currently in use by a TN3270E server for the\n         granularity of this conceptual row (server-wide,\n         port, or port-and-local-address).')
tn3270eSrvrStatsSparePtrs = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 8), Gauge32()).setUnits('Spare Printer Resources').setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsSparePtrs.setDescription('Indicates the number of free printer resources at\n         a TN3270E server for the granularity of this conceptual\n         row (server-wide, port, or port-and-local-address).\n\n         It is possible that the difference between\n         tn3270eSrvrStatsMaxPtrs and tn3270eSrvrStatsInUsePtrs\n         in a conceptual row does not equal the value of\n         tn3270eSrvrStatsSparePtrs in that row:  a printer\n         resource may exist but not be usable by a client\n         connection.\n\n         Alternatively, the administrative ceiling represented\n         by tn3270eSrvrStatsMaxPtrs may have been lowered to\n         a point where it is less than the current value of\n         tn3270eSrvrStatsInUsePtrs.  In this case\n         tn3270eSrvrStatsSparePtrs returns the value 0.')
tn3270eSrvrStatsInConnects = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 9), Counter32()).setUnits('connections').setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsInConnects.setDescription('Indicates the number of client (TCP) connections\n         that succeeded at a TN3270E server for the\n         granularity of this conceptual row (server-wide,\n         port, or port-and-local-address).\n\n         The tn3270eSrvrStatsConnResrceRejs and\n         tn3270eSrvrStatsConnErrorRejs objects provide a count\n         of failed connection attempts.\n\n         A Management Station can detect discontinuities in\n         this counter by monitoring the tn3270eSrvrStatsUpTime\n         object.')
tn3270eSrvrStatsConnResrceRejs = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 10), Counter32()).setUnits('connection attempts').setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsConnResrceRejs.setDescription("Indicates the number of (TCP) connections rejected\n         during connection setup at a TN3270E server for the\n         granularity of this conceptual row (server-wide,\n         port, or port-and-local-address) due to a lack of\n         resources at the server.  An example of when this\n         counter would be incremented is when no terminal\n         or printer resource is available to associate with a\n         client's TCP connection.\n\n         A Management Station can detect discontinuities in\n         this counter by monitoring the tn3270eSrvrStatsUpTime\n         object.")
tn3270eSrvrStatsDisconnects = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 11), Counter32()).setUnits('disconnections').setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsDisconnects.setDescription('Indicates the number of (TCP) connections that were\n         disconnected at a TN3270E server for the\n         granularity of this conceptual row (server-wide,\n         port, or port-and-local-address).\n\n         A Management Station can detect discontinuities in\n         this counter by monitoring the tn3270eSrvrStatsUpTime\n         object.')
tn3270eSrvrStatsHCInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 12), Counter64()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsHCInOctets.setDescription('Indicates the number of octets received from TN3270\n         and TN3270E clients for the granularity of this\n         conceptual row (server-wide, port, or\n         port-and-local-address).\n\n         A Management Station can detect discontinuities in\n         this counter by monitoring the tn3270eSrvrStatsUpTime\n         object.')
tn3270eSrvrStatsInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 13), Counter32()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsInOctets.setDescription('Low-order 32 bits of tn3270eSrvrStatsHCInOctets for\n         this conceptual row.\n\n         A Management Station can detect discontinuities in\n         this counter by monitoring the tn3270eSrvrStatsUpTime\n         object.')
tn3270eSrvrStatsHCOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 14), Counter64()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsHCOutOctets.setDescription('Indicates the number of octets sent to TN3270\n         and TN3270E clients for the granularity of this\n         conceptual row (server-wide, port, or\n         port-and-local-address).\n\n         A Management Station can detect discontinuities in\n         this counter by monitoring the tn3270eSrvrStatsUpTime\n         object.')
tn3270eSrvrStatsOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 15), Counter32()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsOutOctets.setDescription('Low-order 32 bits of tn3270eSrvrStatsHCOutOctets for\n         this conceptual row.\n\n         A Management Station can detect discontinuities in\n         this counter by monitoring the tn3270eSrvrStatsUpTime\n         object.')
tn3270eSrvrStatsConnErrorRejs = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 3, 1, 16), Counter32()).setUnits('connection attempts').setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSrvrStatsConnErrorRejs.setDescription('Indicates the number of (TCP) connections rejected\n         during connection setup at a TN3270E server for the\n         granularity of this conceptual row (server-wide,\n         port, or port-and-local-address) due to an error\n         of some type.  An example of when this counter would\n         be incremented is when the client and the server\n         cannot agree on a common set of TN3270E functions for\n         the connection.\n\n         A Management Station can detect discontinuities in\n         this counter by monitoring the tn3270eSrvrStatsUpTime\n         object.')
tn3270eClientGroupTable = MibTable((1, 3, 6, 1, 2, 1, 34, 8, 1, 4), )
if mibBuilder.loadTexts: tn3270eClientGroupTable.setDescription('This table defines client address groupings for use\n          by a TN3270E server.\n\n          No entry in this table shall exist without\n          a corresponding (same tn3270eSrvrConfIndex) entry in\n          the tn3270eSrvrConfTable existing.\n\n          An implementation SHOULD NOT retain SNMP-created\n          entries in this table across re-IPLs (Initial Program\n          Loads) of the corresponding TN3270E server.')
tn3270eClientGroupEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 8, 1, 4, 1), ).setIndexNames((0, "TN3270E-MIB", "tn3270eSrvrConfIndex"), (0, "TN3270E-MIB", "tn3270eClientGroupName"), (0, "TN3270E-MIB", "tn3270eClientGroupAddrType"), (0, "TN3270E-MIB", "tn3270eClientGroupAddress"))
if mibBuilder.loadTexts: tn3270eClientGroupEntry.setDescription('Definition of a single client address entry.  All\n          entries with the same first two indexes,\n          tn3270eSrvrConfIndex and tn3270eClientGroupName, are\n          considered to be in the same client group.')
tn3270eClientGroupName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 4, 1, 1), Utf8String().subtype(subtypeSpec=ValueSizeConstraint(1,24)))
if mibBuilder.loadTexts: tn3270eClientGroupName.setDescription('The name of a client group.  Note: client group\n          names are required to be unique only with respect\n          to a single TN3270E server.')
tn3270eClientGroupAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 4, 1, 2), IANATn3270eAddrType())
if mibBuilder.loadTexts: tn3270eClientGroupAddrType.setDescription('Indicates the type of the address represented in\n           tn3270eClientGroupAddress.')
tn3270eClientGroupAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 4, 1, 3), IANATn3270eAddress())
if mibBuilder.loadTexts: tn3270eClientGroupAddress.setDescription('The client address of a member of a client group.\n          The value of tn3270eClientGroupAddrType indicates\n          the address type (IPv4 or IPv6, for example).')
tn3270eClientGroupSubnetMask = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 4, 1, 4), IpAddress().clone(hexValue="FFFFFFFF")).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eClientGroupSubnetMask.setDescription("The corresponding subnet mask associated with\n           tn3270eClientGroupAddress.  A single IP address is\n           represented by having this object contain the value\n           of 255.255.255.255.\n\n           This object's value is meaningful only if\n           tn3270eClientGroupAddrType has a value of ipv4(1).")
tn3270eClientGroupPfxLength = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 4, 1, 5), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,128))).setUnits('bits').setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eClientGroupPfxLength.setDescription("The corresponding IPv6 network prefix length.\n\n          This object's value is meaningful only if\n          tn3270eClientGroupAddrType  has a value of ipv6(2).")
tn3270eClientGroupRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 4, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eClientGroupRowStatus.setDescription('This object allows entries to be created and deleted\n          in the tn3270eClientGroupTable.  Entries may also be\n          created and deleted as a result of implementation-\n          dependent operations.\n\n          An entry in this table is deleted by setting this object\n          to destroy(6).  When the number of entries in this table\n          for a given client group becomes 0, this has the side-\n          effect of removing any entries for the group in the\n          tn3270eClientResMapTable.')
tn3270eResPoolTable = MibTable((1, 3, 6, 1, 2, 1, 34, 8, 1, 5), )
if mibBuilder.loadTexts: tn3270eResPoolTable.setDescription("This table defines resource groupings; the term\n          'pool' is used as it is defined by RFC 2355.\n\n          No entry in this table shall exist without\n          a corresponding (same tn3270eSrvrConfIndex) entry in\n          the tn3270eSrvrConfTable existing.\n\n          An implementation SHOULD NOT retain SNMP-created\n          entries in this table across re-IPLs (Initial Program\n          Loads) of the corresponding TN3270E server.")
tn3270eResPoolEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 8, 1, 5, 1), ).setIndexNames((0, "TN3270E-MIB", "tn3270eSrvrConfIndex"), (0, "TN3270E-MIB", "tn3270eResPoolName"), (0, "TN3270E-MIB", "tn3270eResPoolElementName"))
if mibBuilder.loadTexts: tn3270eResPoolEntry.setDescription('Definition of a single resource pool member.  All entries\n          with the same first two indexes, tn3270eSrvrConfIndex and\n          tn3270eResPoolName, are considered to be in the same pool.')
tn3270eResPoolName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 5, 1, 1), Utf8String().subtype(subtypeSpec=ValueSizeConstraint(1,24)))
if mibBuilder.loadTexts: tn3270eResPoolName.setDescription('The name of a resource pool.')
tn3270eResPoolElementName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 5, 1, 2), SnaResourceName())
if mibBuilder.loadTexts: tn3270eResPoolElementName.setDescription('The name of a member of a resource pool.')
tn3270eResPoolElementType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 5, 1, 3), IANATn3270ResourceType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eResPoolElementType.setDescription('The type of the entity in a resource pool.')
tn3270eResPoolRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 5, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eResPoolRowStatus.setDescription('This object allows entries to be created and deleted\n          in the tn3270eResPoolTable.  Entries may also be\n          created and deleted as a result of implementation-\n          dependent operations.\n\n          An entry in this table is deleted by setting this object\n          to destroy(6).  When all entries in this table associated\n          with the same tn3270eResPoolElementName have been removed,\n          then any associated (tn3270eResPoolElementName matching\n          tn3270eClientResMapPoolName with same tn3270eSrvrConfIndex\n          values) entries in the tn3270eClientResMapTable SHALL\n          also be removed.')
tn3270eSnaMapTable = MibTable((1, 3, 6, 1, 2, 1, 34, 8, 1, 6), )
if mibBuilder.loadTexts: tn3270eSnaMapTable.setDescription('This table provide a mapping from the name by which\n          a secondary LU is known in the SNA network to the\n          name by which it is known locally at the TN3270e\n          server.  This latter name serves as an index into\n          the tn3270eResPoolTable and the tn3270eResMapTable.\n          No entry in this table shall exist without\n          a corresponding (same tn3270eSrvrConfIndex) entry in\n          the tn3270eSrvrConfTable existing.')
tn3270eSnaMapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 8, 1, 6, 1), ).setIndexNames((0, "TN3270E-MIB", "tn3270eSrvrConfIndex"), (0, "TN3270E-MIB", "tn3270eSnaMapSscpSuppliedName"))
if mibBuilder.loadTexts: tn3270eSnaMapEntry.setDescription('Definition of a single mapping from an SSCP-supplied\n          SLU name to a local SLU name.\n\n          Note:  In certain pathological cases, it is possible\n          that an SSCP will send on an ACTLU for a local LU an\n          SLU name currently represented by an entry in this\n          table that associates it with a different local LU.\n          In these cases the association from the newer ACTLU\n          SHOULD be the one represented in this table.')
tn3270eSnaMapSscpSuppliedName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 6, 1, 1), SnaResourceName())
if mibBuilder.loadTexts: tn3270eSnaMapSscpSuppliedName.setDescription('The name of the secondary LU (SLU) as it is known in\n           the SNA network.  This name is sent by the SSCP on\n           the Activate Logical Unit (ACTLU) request.')
tn3270eSnaMapLocalName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 6, 1, 2), SnaResourceName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSnaMapLocalName.setDescription('The local name of the secondary LU (SLU).')
tn3270eSnaMapPrimaryLuName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 6, 1, 3), SnaResourceName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eSnaMapPrimaryLuName.setDescription('When there is a currently active LU-LU session for\n          this connection, this object returns the primary LU\n          (PLU) name from the BIND.  When there is no active\n          LU-LU session, or when the PLU name is unavailable\n          for some other reason, this object returns a\n          zero-length octet string.')
tn3270eClientResMapTable = MibTable((1, 3, 6, 1, 2, 1, 34, 8, 1, 7), )
if mibBuilder.loadTexts: tn3270eClientResMapTable.setDescription('This table defines resource-pool to client-group\n          mappings.  Since both the resource pool name and client\n          group name are included in the index clause of this\n          table, multiple resource pools can be assigned to the\n          same client group.  This enables use of multiple\n          resource pools for use in client to resource mapping.\n          Assigning multiple client groups to the same resource\n          pool is also allowed, but is not the primary purpose\n          for how the indexing is structured.\n\n          Assignment of a resource pool to client group can be\n          restricted based on TCP port.  An index value of 0 for\n          tn3270eClientResMapClientPort disables restriction of\n          resource assignment based on client target port\n          selection.\n\n          No entry in this table shall exist without\n          a corresponding (same tn3270eSrvrConfIndex) entry in\n          the tn3270eSrvrConfTable existing.\n\n          An implementation SHOULD NOT retain SNMP-created\n          entries in this table across re-IPLs (Initial Program\n          Loads) of the corresponding TN3270E server.')
tn3270eClientResMapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 8, 1, 7, 1), ).setIndexNames((0, "TN3270E-MIB", "tn3270eSrvrConfIndex"), (0, "TN3270E-MIB", "tn3270eClientResMapPoolName"), (0, "TN3270E-MIB", "tn3270eClientResMapClientGroupName"), (0, "TN3270E-MIB", "tn3270eClientResMapClientPort"))
if mibBuilder.loadTexts: tn3270eClientResMapEntry.setDescription('Definition of a single resource pool to client group\n          mapping.')
tn3270eClientResMapPoolName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 7, 1, 1), Utf8String().subtype(subtypeSpec=ValueSizeConstraint(1,24)))
if mibBuilder.loadTexts: tn3270eClientResMapPoolName.setDescription('The name of a resource pool.')
tn3270eClientResMapClientGroupName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 7, 1, 2), Utf8String().subtype(subtypeSpec=ValueSizeConstraint(1,24)))
if mibBuilder.loadTexts: tn3270eClientResMapClientGroupName.setDescription('The name of the client group that is mapped to a\n           resource pool.')
tn3270eClientResMapClientPort = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 7, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,65535)))
if mibBuilder.loadTexts: tn3270eClientResMapClientPort.setDescription('A port number restricting the scope of a mapping\n          from a resource pool to a client group.  The\n          value 0 for this object indicates that the scope\n          of the mapping is not restricted.')
tn3270eClientResMapRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 7, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: tn3270eClientResMapRowStatus.setDescription("This object allows entries to be created and deleted\n          in the tn3270eClientResMapTable.  Entries may also be\n          created and deleted as a result of implementation-\n          dependent operations.\n\n          An entry in this table is deleted by setting this object\n          to destroy(6).  Removing an entry from this table doesn't\n          affect any other table entry defined in this MIB.")
tn3270eResMapTable = MibTable((1, 3, 6, 1, 2, 1, 34, 8, 1, 8), )
if mibBuilder.loadTexts: tn3270eResMapTable.setDescription('This table defines the actual mapping of a resource\n          to a client address.\n\n          No entry in this table shall exist without\n          a corresponding (same tn3270eSrvrConfIndex) entry in\n          the tn3270eSrvrConfTable existing.')
tn3270eResMapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 8, 1, 8, 1), ).setIndexNames((0, "TN3270E-MIB", "tn3270eSrvrConfIndex"), (0, "TN3270E-MIB", "tn3270eResMapElementName"))
if mibBuilder.loadTexts: tn3270eResMapEntry.setDescription('Definition of the mapping of a Resource Element to\n           a client address.')
tn3270eResMapElementName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 8, 1, 1), SnaResourceName())
if mibBuilder.loadTexts: tn3270eResMapElementName.setDescription('The name of a resource element.  This is the name by\n          which the server implementing this table knows the\n          resource.  It may be different from the name by which\n          the resource is known in the SNA network.  This latter\n          name is returned in the tn3270eResMapSscpSuppliedName\n          object.')
tn3270eResMapAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 8, 1, 2), IANATn3270eAddrType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eResMapAddrType.setDescription('Indicates the type of the client address represented\n          in tn3270eResMapAddress.')
tn3270eResMapAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 8, 1, 3), IANATn3270eAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eResMapAddress.setDescription('A client address.')
tn3270eResMapPort = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 8, 1, 4), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eResMapPort.setDescription('A client port.')
tn3270eResMapElementType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 8, 1, 5), IANATn3270ResourceType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eResMapElementType.setDescription('The type of the associated resource element.')
tn3270eResMapSscpSuppliedName = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 8, 1, 6), SnaResourceName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eResMapSscpSuppliedName.setDescription('The name of the secondary LU (SLU) as it is known\n          in a SNA network.  This name is sent by the SSCP on\n          the Activate Logical Unit (ACTLU) request.  If this\n          name is not known, this object returns a zero-length\n          octet string.')
tn3270eTcpConnTable = MibTable((1, 3, 6, 1, 2, 1, 34, 8, 1, 9), )
if mibBuilder.loadTexts: tn3270eTcpConnTable.setDescription('This table has an entry for each TN3270(E) client\n           connection that is currently active at a TN3270E server.\n           An implementation MAY retain entries for connections\n           that have been terminated, but which entries are\n           retained, how many entries are retained, and how long\n           they are retained is entirely implementation-dependent.\n\n           The indexing for this table is designed to support the\n           use of an SNMP GET-NEXT operation using only the remote\n           address type, remote address, and remote port, as a way\n           for a Management Station to retrieve the table entries\n           related to a particular TN3270(E) client.')
tn3270eTcpConnEntry = MibTableRow((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1), ).setIndexNames((0, "TN3270E-MIB", "tn3270eTcpConnRemAddrType"), (0, "TN3270E-MIB", "tn3270eTcpConnRemAddress"), (0, "TN3270E-MIB", "tn3270eTcpConnRemPort"), (0, "TN3270E-MIB", "tn3270eTcpConnLocalAddrType"), (0, "TN3270E-MIB", "tn3270eTcpConnLocalAddress"), (0, "TN3270E-MIB", "tn3270eTcpConnLocalPort"))
if mibBuilder.loadTexts: tn3270eTcpConnEntry.setDescription('Provides information about a single TN3270/TN3270E\n          session.  Note: a tn3270eSrvrConfIndex is not needed\n          in this table, since the combination of remote and\n          local addresses and ports is sufficient to\n          guarantee uniqueness across the TN3270E servers\n          serviced by an SNMP agent.  Because of this indexing\n          structure, however, this table does not support\n          view-based access control policies that provide\n          access to table rows on a per-server basis.')
tn3270eTcpConnRemAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 1), IANATn3270eAddrType())
if mibBuilder.loadTexts: tn3270eTcpConnRemAddrType.setDescription('Indicates the type of the value of the\n          tn3270eTcpConnRemAddress object.  For example,\n          ipv4(1) or ipv6(2).')
tn3270eTcpConnRemAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 2), IANATn3270eAddress())
if mibBuilder.loadTexts: tn3270eTcpConnRemAddress.setDescription("The remote address associated with a TN3270E client.\n           tn3270eTcpConnRemAddrType indicates the address type\n           (IPv4 or IPv6, for example).\n\n           If a TN3270(E) client is connected to its\n           server via a proxy client the address represented by\n           the value of this object shall be the remote client's\n           address, not the proxy client's address.")
tn3270eTcpConnRemPort = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,65535)))
if mibBuilder.loadTexts: tn3270eTcpConnRemPort.setDescription("The remote port associated with a TN3270E client.  The value 0\n          is used if the tn3270eTcpConnRemAddrType identifies an address\n          type that does not support ports.\n\n          If a TN3270(E) client is connected to its server via a proxy\n          client, the port represented by the value of this object shall\n          be the remote client's port, not the proxy client's port.")
tn3270eTcpConnLocalAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 4), IANATn3270eAddrType())
if mibBuilder.loadTexts: tn3270eTcpConnLocalAddrType.setDescription('Indicates the type of the value of the\n          tn3270eTcpConnLocalAddress object.  For example,\n          ipv4(1) or ipv6(2).')
tn3270eTcpConnLocalAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 5), IANATn3270eAddress())
if mibBuilder.loadTexts: tn3270eTcpConnLocalAddress.setDescription('The local address associated with a TN3270E client.\n           tn3270eTcpConnRemAddrType indicates the address type\n           (IPv4 or IPv6, for example).')
tn3270eTcpConnLocalPort = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 6), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,65535)))
if mibBuilder.loadTexts: tn3270eTcpConnLocalPort.setDescription('The remote port associated with a TN3270E client.')
tn3270eTcpConnLastActivity = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 7), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnLastActivity.setDescription('The number of 100ths of seconds since any data was\n           transferred for the associated TCP Connection.')
tn3270eTcpConnBytesIn = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 8), Counter32()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnBytesIn.setDescription('The number of bytes received by the server from TCP\n          for this connection.\n\n          A Management Station can detect discontinuities in\n          this counter by monitoring the\n          tn3270eTcpConnActivationTime object.')
tn3270eTcpConnBytesOut = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 9), Counter32()).setUnits('octets').setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnBytesOut.setDescription('The number of bytes sent to TCP for this connection.\n\n          A Management Station can detect discontinuities in\n          this counter by monitoring the\n          tn3270eTcpConnActivationTime object.')
tn3270eTcpConnResourceElement = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 10), SnaResourceName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnResourceElement.setDescription('LU/Print secondary name for connecting an client\n           into an SNA network.')
tn3270eTcpConnResourceType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 11), IANATn3270ResourceType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnResourceType.setDescription('Indicates the type of resource identified by\n           tn3270eTcpConnResourceElement.')
tn3270eTcpConnDeviceType = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 12), IANATn3270DeviceType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnDeviceType.setDescription('Indicates the device type if negotiated with the\n          client.  A value of unknown(100) should be used as\n          the value of this object when a device type is not\n          negotiated.  Refer to RFC 2355 for how device types\n          can be negotiated.')
tn3270eTcpConnFunctions = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 13), IANATn3270Functions()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnFunctions.setDescription('This object indicates which of the TN3270 and TN3270E\n          functions were negotiated by the server and the client\n          for this TCP connection.\n\n          Refer to tn3270eSrvrFunctionsSupported for the list of\n          these functions supported by the server.')
tn3270eTcpConnId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 14), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnId.setDescription("The connection identifier associated with a TN3270 or\n           a TN3270E session's TCP connection.  TCP implementations\n           often assign a unique (with respect to itself) unsigned\n           integer as an identifier for a TCP connection.\n\n           The value 0 indicates that a connection does not have\n           a valid connection identifier.")
tn3270eTcpConnClientIdFormat = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 15), IANATn3270eClientType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnClientIdFormat.setDescription('The format of a corresponding tn3270eTcpConnClientId\n          object as defined by the IANSTn3270eClientType textual\n          convention imported from the IANATn3270eTC-MIB.')
tn3270eTcpConnClientId = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 16), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,512))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnClientId.setDescription('Additional client identification information.  The\n          type of this information is indicated by the value of\n          the corresponding tn3270eTcpConnClientIdFormat object.\n          All values are returned in network-byte order.\n\n          The purpose of this object is to provide an alternate\n          means of identifying a client, other than though the\n          remote address returned in tn3270eTcpConnRemAddress.')
tn3270eTcpConnTraceData = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 17), Tn3270eTraceData()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnTraceData.setDescription('Trace data for this session.')
tn3270eTcpConnLogInfo = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 18), IANATn3270eLogData()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnLogInfo.setDescription('Log information, encoded as specified in the\n          IANATn3270eLogData textual convention from the\n          IANAtn3270eTC-MIB.')
tn3270eTcpConnLuLuBindImage = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 19), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0,256))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnLuLuBindImage.setDescription("When there is a currently active LU-LU session for\n          this connection, this object returns the BIND Image\n          (defined to be bytes 1-p of the complete BIND Request\n          Unit -- see 'SNA Formats' for more information)\n          that was received from the PLU during session\n          activation.  When there is no active LU-LU session,\n          or when a BIND image is unavailable for some other\n          reason, this object returns a zero-length octet\n          string.")
tn3270eTcpConnSnaState = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 20), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("unknown", 1), ("noSluSession", 2), ("sscpLuSession", 3), ("luLuSession", 4), ("sscpLuSessionAndLuLuSession", 5),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnSnaState.setDescription('The current state of the SNA side of the end-to-end\n          TN3270 connection.  The following states are defined:\n\n              unknown(1)          - The true state is not known.\n              noSluSession(2)     - The SLU has neither an SSCP-LU\n                                    nor an LU-LU session active.\n              sscpLuSession(3)    - The SSCP-LU session for the SLU\n                                    is active, but the SLU is not\n                                    currently in session with a PLU.\n              luLuSession(4)      - The SLU is currently in session\n                                    with a PLU, but the SSCP-LU\n                                    session for the LU is not active.\n              sscpLuSessionAndLuLuSession(5) - The SLU currently has\n                                    an active session with a PLU,\n                                    and the SSCP-LU session for the\n                                    SLU is active.')
tn3270eTcpConnStateLastDiscReason = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 21), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13,))).clone(namedValues=NamedValues(("unknown", 1), ("hostSendsUnbind", 2), ("hostDontAcceptConnection", 3), ("outOfResource", 4), ("clientProtocolError", 5), ("invalidDeviceName", 6), ("deviceInUse", 7), ("inactivityTimeout", 8), ("hostNotResponding", 9), ("clientNotResponding", 10), ("serverClose", 11), ("sysreqLogoff", 12), ("serverSpecificHexCode", 13),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnStateLastDiscReason.setDescription('The last disconnect reason.  A session that has not\n          experienced a disconnect shall use the value unknown(1)\n          for this object.  Depending on when an implementation\n          removes entries from this table, certain states may\n          never be returned.')
tn3270eTcpConnSrvrConfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 22), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295))).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnSrvrConfIndex.setDescription('tn3270eSrvrConfIndex of the tn3270eSrvrConfEntry\n          belonging to the TN3270E server to which this entry\n          belongs.')
tn3270eTcpConnActivationTime = MibTableColumn((1, 3, 6, 1, 2, 1, 34, 8, 1, 9, 1, 23), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: tn3270eTcpConnActivationTime.setDescription('The value of the sysUpTime object the last time\n          this TCP connection became active.')
tn3270eConfSpinLock = MibScalar((1, 3, 6, 1, 2, 1, 34, 8, 1, 10), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: tn3270eConfSpinLock.setDescription('An advisory lock used to allow cooperating\n        TN3270E-MIB applications to coordinate their use\n        of the tn3270eSrvrConfTable, the tn3270eSrvrPortTable,\n        the tn3270eClientGroupTable, the tn3270eResPoolTable,\n        and the tn3270eClientResMapTable.\n\n        When creating a new entry or altering an existing entry\n        in the any of the tables mentioned above, an application\n        should make use of tn3270eRtSpinLock to serialize\n        application changes or additions.\n\n        Since this is an advisory lock, the use of this lock is\n        not enforced.')
tn3270eGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 8, 3, 1))
tn3270eCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 34, 8, 3, 2))
tn3270eCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 34, 8, 3, 2, 1)).setObjects(*(("TN3270E-MIB", "tn3270eBasicGroup"), ("TN3270E-MIB", "tn3270eSessionGroup"), ("TN3270E-MIB", "tn3270eResMapGroup"), ("TN3270E-MIB", "tn3270eHiCapacityGroup"),))
if mibBuilder.loadTexts: tn3270eCompliance.setDescription('The compliance statement for agents that support the\n          TN3270E-MIB.')
tn3270eBasicGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 8, 3, 1, 1)).setObjects(*(("TN3270E-MIB", "tn3270eSrvrConfInactivityTimeout"), ("TN3270E-MIB", "tn3270eSrvrConfConnectivityChk"), ("TN3270E-MIB", "tn3270eSrvrConfTmNopInactTime"), ("TN3270E-MIB", "tn3270eSrvrConfTmNopInterval"), ("TN3270E-MIB", "tn3270eSrvrFunctionsSupported"), ("TN3270E-MIB", "tn3270eSrvrConfAdminStatus"), ("TN3270E-MIB", "tn3270eSrvrConfOperStatus"), ("TN3270E-MIB", "tn3270eSrvrConfSessionTermState"), ("TN3270E-MIB", "tn3270eSrvrConfSrvrType"), ("TN3270E-MIB", "tn3270eSrvrConfContact"), ("TN3270E-MIB", "tn3270eSrvrConfRowStatus"), ("TN3270E-MIB", "tn3270eSrvrConfLastActTime"), ("TN3270E-MIB", "tn3270eSrvrConfTmTimeout"), ("TN3270E-MIB", "tn3270eSrvrPortRowStatus"), ("TN3270E-MIB", "tn3270eSrvrStatsUpTime"), ("TN3270E-MIB", "tn3270eSrvrStatsMaxTerms"), ("TN3270E-MIB", "tn3270eSrvrStatsInUseTerms"), ("TN3270E-MIB", "tn3270eSrvrStatsSpareTerms"), ("TN3270E-MIB", "tn3270eSrvrStatsMaxPtrs"), ("TN3270E-MIB", "tn3270eSrvrStatsInUsePtrs"), ("TN3270E-MIB", "tn3270eSrvrStatsSparePtrs"), ("TN3270E-MIB", "tn3270eSrvrStatsInConnects"), ("TN3270E-MIB", "tn3270eSrvrStatsConnResrceRejs"), ("TN3270E-MIB", "tn3270eSrvrStatsDisconnects"), ("TN3270E-MIB", "tn3270eSrvrStatsInOctets"), ("TN3270E-MIB", "tn3270eSrvrStatsOutOctets"), ("TN3270E-MIB", "tn3270eSrvrStatsConnErrorRejs"), ("TN3270E-MIB", "tn3270eClientGroupSubnetMask"), ("TN3270E-MIB", "tn3270eClientGroupPfxLength"), ("TN3270E-MIB", "tn3270eClientGroupRowStatus"), ("TN3270E-MIB", "tn3270eSnaMapLocalName"), ("TN3270E-MIB", "tn3270eSnaMapPrimaryLuName"), ("TN3270E-MIB", "tn3270eConfSpinLock"),))
if mibBuilder.loadTexts: tn3270eBasicGroup.setDescription('This group is mandatory for all hosts supporting the\n           TN3270E-MIB.')
tn3270eSessionGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 8, 3, 1, 2)).setObjects(*(("TN3270E-MIB", "tn3270eResMapAddrType"), ("TN3270E-MIB", "tn3270eResMapAddress"), ("TN3270E-MIB", "tn3270eResMapPort"), ("TN3270E-MIB", "tn3270eResMapElementType"), ("TN3270E-MIB", "tn3270eResMapSscpSuppliedName"), ("TN3270E-MIB", "tn3270eTcpConnLastActivity"), ("TN3270E-MIB", "tn3270eTcpConnBytesIn"), ("TN3270E-MIB", "tn3270eTcpConnBytesOut"), ("TN3270E-MIB", "tn3270eTcpConnResourceElement"), ("TN3270E-MIB", "tn3270eTcpConnResourceType"), ("TN3270E-MIB", "tn3270eTcpConnDeviceType"), ("TN3270E-MIB", "tn3270eTcpConnFunctions"), ("TN3270E-MIB", "tn3270eTcpConnSrvrConfIndex"), ("TN3270E-MIB", "tn3270eTcpConnActivationTime"),))
if mibBuilder.loadTexts: tn3270eSessionGroup.setDescription('This group is mandatory for all hosts supporting the\n           TN3270E-MIB.')
tn3270eResMapGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 8, 3, 1, 3)).setObjects(*(("TN3270E-MIB", "tn3270eResPoolElementType"), ("TN3270E-MIB", "tn3270eResPoolRowStatus"), ("TN3270E-MIB", "tn3270eClientResMapRowStatus"), ("TN3270E-MIB", "tn3270eTcpConnId"), ("TN3270E-MIB", "tn3270eTcpConnClientIdFormat"), ("TN3270E-MIB", "tn3270eTcpConnClientId"), ("TN3270E-MIB", "tn3270eTcpConnTraceData"), ("TN3270E-MIB", "tn3270eTcpConnLogInfo"), ("TN3270E-MIB", "tn3270eTcpConnLuLuBindImage"), ("TN3270E-MIB", "tn3270eTcpConnSnaState"), ("TN3270E-MIB", "tn3270eTcpConnStateLastDiscReason"),))
if mibBuilder.loadTexts: tn3270eResMapGroup.setDescription('This group is optional for all hosts supporting the\n           TN3270E-MIB.')
tn3270eHiCapacityGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 34, 8, 3, 1, 4)).setObjects(*(("TN3270E-MIB", "tn3270eSrvrStatsHCInOctets"), ("TN3270E-MIB", "tn3270eSrvrStatsHCOutOctets"),))
if mibBuilder.loadTexts: tn3270eHiCapacityGroup.setDescription("Support of these objects is REQUIRED when the\n           Counter32 versions can potentially wrap too\n           frequently.  This group is optional for all other\n           hosts supporting the TN3270E-MIB.\n\n           The IF-MIB (RFC 2233) requires that the 64-bit\n           versions of its counters be implemented when an\n           interface can support rates of around 20 million\n           bits per second or greater.  This implies a minimum\n           wrap rate of just over 28 minutes.  It is recommended\n           that this same guideline be used for determining\n           whether an implementation implements these objects.\n\n           This group contains two objects with the syntax\n           Counter64.  An implementation that doesn't support\n           these objects should return noSuchObject, since\n           returning a zero is misleading.")
mibBuilder.exportSymbols("TN3270E-MIB", tn3270eClientResMapTable=tn3270eClientResMapTable, tn3270eSnaMapLocalName=tn3270eSnaMapLocalName, tn3270eSrvrConfConnectivityChk=tn3270eSrvrConfConnectivityChk, tn3270eSrvrStatsInOctets=tn3270eSrvrStatsInOctets, tn3270eSnaMapTable=tn3270eSnaMapTable, tn3270eTcpConnBytesOut=tn3270eTcpConnBytesOut, tn3270eResPoolEntry=tn3270eResPoolEntry, tn3270eSrvrStatsSpareTerms=tn3270eSrvrStatsSpareTerms, tn3270eTcpConnResourceElement=tn3270eTcpConnResourceElement, tn3270eClientGroupName=tn3270eClientGroupName, tn3270eNotifications=tn3270eNotifications, tn3270eResPoolElementType=tn3270eResPoolElementType, tn3270eTcpConnFunctions=tn3270eTcpConnFunctions, tn3270eResMapElementType=tn3270eResMapElementType, tn3270eSrvrConfContact=tn3270eSrvrConfContact, tn3270eTcpConnActivationTime=tn3270eTcpConnActivationTime, tn3270eSrvrConfTable=tn3270eSrvrConfTable, tn3270eSrvrStatsUpTime=tn3270eSrvrStatsUpTime, tn3270eSrvrStatsConnErrorRejs=tn3270eSrvrStatsConnErrorRejs, tn3270eSnaMapEntry=tn3270eSnaMapEntry, tn3270eTcpConnTraceData=tn3270eTcpConnTraceData, tn3270eSrvrConfOperStatus=tn3270eSrvrConfOperStatus, tn3270eSrvrFunctionsSupported=tn3270eSrvrFunctionsSupported, tn3270eClientGroupTable=tn3270eClientGroupTable, tn3270eSrvrPort=tn3270eSrvrPort, tn3270eTcpConnDeviceType=tn3270eTcpConnDeviceType, tn3270eClientGroupAddrType=tn3270eClientGroupAddrType, tn3270eSrvrStatsSparePtrs=tn3270eSrvrStatsSparePtrs, tn3270eSessionGroup=tn3270eSessionGroup, tn3270eResPoolName=tn3270eResPoolName, tn3270eCompliance=tn3270eCompliance, tn3270eSrvrPortAddrType=tn3270eSrvrPortAddrType, tn3270eSrvrConfRowStatus=tn3270eSrvrConfRowStatus, tn3270eSrvrConfLastActTime=tn3270eSrvrConfLastActTime, tn3270eSrvrConfInactivityTimeout=tn3270eSrvrConfInactivityTimeout, tn3270eCompliances=tn3270eCompliances, tn3270eResPoolRowStatus=tn3270eResPoolRowStatus, tn3270eTcpConnClientId=tn3270eTcpConnClientId, tn3270eClientGroupPfxLength=tn3270eClientGroupPfxLength, tn3270eSrvrConfTmNopInactTime=tn3270eSrvrConfTmNopInactTime, tn3270eTcpConnResourceType=tn3270eTcpConnResourceType, tn3270eSrvrStatsHCOutOctets=tn3270eSrvrStatsHCOutOctets, tn3270eSrvrPortRowStatus=tn3270eSrvrPortRowStatus, tn3270eTcpConnLastActivity=tn3270eTcpConnLastActivity, tn3270eResPoolTable=tn3270eResPoolTable, tn3270eTcpConnClientIdFormat=tn3270eTcpConnClientIdFormat, tn3270eSrvrPortEntry=tn3270eSrvrPortEntry, tn3270eResMapPort=tn3270eResMapPort, tn3270eTcpConnStateLastDiscReason=tn3270eTcpConnStateLastDiscReason, tn3270eSrvrStatsInUsePtrs=tn3270eSrvrStatsInUsePtrs, tn3270eSrvrConfIndex=tn3270eSrvrConfIndex, tn3270eSrvrStatsInUseTerms=tn3270eSrvrStatsInUseTerms, tn3270eConfSpinLock=tn3270eConfSpinLock, tn3270eSrvrPortTable=tn3270eSrvrPortTable, tn3270eSrvrConfTmNopInterval=tn3270eSrvrConfTmNopInterval, tn3270eResMapEntry=tn3270eResMapEntry, tn3270eTcpConnRemAddress=tn3270eTcpConnRemAddress, tn3270eTcpConnLogInfo=tn3270eTcpConnLogInfo, tn3270eSrvrStatsInConnects=tn3270eSrvrStatsInConnects, tn3270eSrvrStatsDisconnects=tn3270eSrvrStatsDisconnects, tn3270eSrvrStatsEntry=tn3270eSrvrStatsEntry, tn3270eTcpConnRemAddrType=tn3270eTcpConnRemAddrType, tn3270eResMapAddrType=tn3270eResMapAddrType, tn3270eSrvrConfSrvrType=tn3270eSrvrConfSrvrType, tn3270eTcpConnLocalPort=tn3270eTcpConnLocalPort, tn3270eMIB=tn3270eMIB, tn3270eConformance=tn3270eConformance, tn3270eSrvrStatsOutOctets=tn3270eSrvrStatsOutOctets, tn3270eTcpConnLuLuBindImage=tn3270eTcpConnLuLuBindImage, tn3270eResMapElementName=tn3270eResMapElementName, tn3270eResPoolElementName=tn3270eResPoolElementName, tn3270eSnaMapPrimaryLuName=tn3270eSnaMapPrimaryLuName, tn3270eTcpConnRemPort=tn3270eTcpConnRemPort, tn3270eClientGroupEntry=tn3270eClientGroupEntry, tn3270eBasicGroup=tn3270eBasicGroup, tn3270eSrvrStatsTable=tn3270eSrvrStatsTable, tn3270eTcpConnBytesIn=tn3270eTcpConnBytesIn, tn3270eSrvrConfEntry=tn3270eSrvrConfEntry, tn3270eClientGroupRowStatus=tn3270eClientGroupRowStatus, tn3270eTcpConnLocalAddress=tn3270eTcpConnLocalAddress, tn3270eHiCapacityGroup=tn3270eHiCapacityGroup, tn3270eClientResMapEntry=tn3270eClientResMapEntry, tn3270eSrvrConfTmTimeout=tn3270eSrvrConfTmTimeout, tn3270eTcpConnLocalAddrType=tn3270eTcpConnLocalAddrType, tn3270eClientGroupSubnetMask=tn3270eClientGroupSubnetMask, tn3270eResMapGroup=tn3270eResMapGroup, tn3270eResMapAddress=tn3270eResMapAddress, PYSNMP_MODULE_ID=tn3270eMIB, Tn3270eTraceData=Tn3270eTraceData, tn3270eTcpConnEntry=tn3270eTcpConnEntry, tn3270eClientGroupAddress=tn3270eClientGroupAddress, tn3270eTcpConnSrvrConfIndex=tn3270eTcpConnSrvrConfIndex, tn3270eClientResMapPoolName=tn3270eClientResMapPoolName, tn3270eSrvrStatsMaxPtrs=tn3270eSrvrStatsMaxPtrs, tn3270eSrvrConfAdminStatus=tn3270eSrvrConfAdminStatus, tn3270eSrvrPortAddress=tn3270eSrvrPortAddress, tn3270eGroups=tn3270eGroups, tn3270eClientResMapClientGroupName=tn3270eClientResMapClientGroupName, tn3270eSrvrStatsMaxTerms=tn3270eSrvrStatsMaxTerms, tn3270eResMapTable=tn3270eResMapTable, tn3270eSrvrConfSessionTermState=tn3270eSrvrConfSessionTermState, tn3270eResMapSscpSuppliedName=tn3270eResMapSscpSuppliedName, tn3270eClientResMapRowStatus=tn3270eClientResMapRowStatus, SnaResourceName=SnaResourceName, tn3270eObjects=tn3270eObjects, tn3270eClientResMapClientPort=tn3270eClientResMapClientPort, tn3270eSnaMapSscpSuppliedName=tn3270eSnaMapSscpSuppliedName, tn3270eSrvrStatsHCInOctets=tn3270eSrvrStatsHCInOctets, tn3270eTcpConnSnaState=tn3270eTcpConnSnaState, tn3270eTcpConnId=tn3270eTcpConnId, tn3270eSrvrStatsConnResrceRejs=tn3270eSrvrStatsConnResrceRejs, tn3270eTcpConnTable=tn3270eTcpConnTable)
