#
# PySNMP MIB module ADSL-LINE-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/ADSL-LINE-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:04:05 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( AdslLineCodingType, AdslPerfPrevDayCount, AdslPerfCurrDayCount, AdslPerfTimeElapsed, ) = mibBuilder.importSymbols("ADSL-TC-MIB", "AdslLineCodingType", "AdslPerfPrevDayCount", "AdslPerfCurrDayCount", "AdslPerfTimeElapsed")
( ObjectIdentifier, OctetString, Integer, ) = mibBuilder.importSymbols("ASN1", "ObjectIdentifier", "OctetString", "Integer")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ValueRangeConstraint, SingleValueConstraint, ConstraintsUnion, ValueSizeConstraint, ConstraintsIntersection, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ValueRangeConstraint", "SingleValueConstraint", "ConstraintsUnion", "ValueSizeConstraint", "ConstraintsIntersection")
( ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "ifIndex")
( PerfIntervalCount, PerfCurrentCount, ) = mibBuilder.importSymbols("PerfHist-TC-MIB", "PerfIntervalCount", "PerfCurrentCount")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ObjectGroup, NotificationGroup, ModuleCompliance, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ObjectGroup", "NotificationGroup", "ModuleCompliance")
( Counter64, ObjectIdentity, transmission, TimeTicks, iso, Integer32, MibIdentifier, Gauge32, Bits, MibScalar, MibTable, MibTableRow, MibTableColumn, IpAddress, Counter32, Unsigned32, NotificationType, ModuleIdentity, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Counter64", "ObjectIdentity", "transmission", "TimeTicks", "iso", "Integer32", "MibIdentifier", "Gauge32", "Bits", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "IpAddress", "Counter32", "Unsigned32", "NotificationType", "ModuleIdentity")
( RowStatus, TextualConvention, TruthValue, VariablePointer, DisplayString, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "TextualConvention", "TruthValue", "VariablePointer", "DisplayString")
adslMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 94)).setRevisions(("1999-08-19 00:00",))
if mibBuilder.loadTexts: adslMIB.setLastUpdated('9908190000Z')
if mibBuilder.loadTexts: adslMIB.setOrganization('IETF ADSL MIB Working Group')
if mibBuilder.loadTexts: adslMIB.setContactInfo('\n       Gregory Bathrick\n       AG Communication Systems\n       A Subsidiary of Lucent Technologies\n       2500 W Utopia Rd.\n       Phoenix, AZ 85027 USA\n       Tel: +1 602-582-7679\n       Fax: +1 602-582-7697\n       E-mail: bathricg@agcs.com\n\n       Faye Ly\n       Copper Mountain Networks\n       Norcal Office\n       2470 Embarcadero Way\n       Palo Alto, CA 94303\n       Tel: +1 650-858-8500\n       Fax: +1 650-858-8085\n       E-Mail: faye@coppermountain.com\n\n       (ADSL Forum input only)\n       John Burgess\n       Predictive Systems, Inc.\n       25A Vreeland Rd.\n       Florham Park, NJ 07932 USA\n       Tel: +1 973-301-5610\n       Fax: +1 973-301-5699\n       E-mail: jtburgess@predictive.com\n\n       IETF ADSL MIB Working Group (adsl@xlist.agcs.com)\n       ')
if mibBuilder.loadTexts: adslMIB.setDescription('The MIB module defining objects for the management of a pair of\n       ADSL modems at each end of the ADSL line.  Each such line has\n       an entry in an ifTable which may include multiple modem lines.\n       An agent may reside at either end of the ADSL line however the\n       MIB is designed to require no management communication between\n       them beyond that inherent in the low-level ADSL line protocol.\n       The agent may monitor and control this protocol for its needs.\n\n       ADSL lines may support optional Fast or Interleaved channels.\n       If these are supported, additional entries corresponding to the\n       supported channels must be created in the ifTable. Thus an ADSL\n       line that supports both channels will have three entries in the\n       ifTable, one for each physical, fast, and interleaved, whose\n       ifType values are equal to adsl(94), fast(125), and\n       interleaved(124), respectively. The ifStackTable is used to\n       represent the relationship between the entries.\n\n       Naming Conventions:\n                 Atuc -- (ATUC) modem at near (Central) end of line\n                 Atur -- (ATUR) modem at Remote end of line\n                 Curr -- Current\n                 Prev -- Previous\n                 Atn -- Attenuation\n                 ES  -- Errored Second.\n                 LCS -- Line Code Specific\n                 Lof -- Loss of Frame\n                 Lol -- Loss of Link\n                 Los -- Loss of Signal\n                 Lpr -- Loss of Power\n                 xxxs-- interval of Seconds in which xxx occurs\n                         (e.g., xxx=Lof, Los, Lpr)\n                 Max -- Maximum\n                 Mgn -- Margin\n                 Min -- Minimum\n                 Psd -- Power Spectral Density\n                 Snr -- Signal to Noise Ratio\n                 Tx  -- Transmit\n                 Blks-- Blocks, a data unit, see\n                        adslAtuXChanCrcBlockLength\n         ')
adslLineMib = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 94, 1))
adslMibObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 94, 1, 1))
adslLineTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 1), )
if mibBuilder.loadTexts: adslLineTable.setDescription('This table includes common attributes describing\n                 both ends of the line.  It is required for all ADSL\n                 physical interfaces.  ADSL physical interfaces are\n                 those ifEntries where ifType is equal to adsl(94).')
adslLineEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 1, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: adslLineEntry.setDescription('An entry in adslLineTable.')
adslLineCoding = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 1, 1, 1), AdslLineCodingType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslLineCoding.setDescription('Specifies the ADSL coding type used on this\n                 line.')
adslLineType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 1, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("noChannel", 1), ("fastOnly", 2), ("interleavedOnly", 3), ("fastOrInterleaved", 4), ("fastAndInterleaved", 5),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslLineType.setDescription('Defines the type of ADSL physical line\n                 entity that exists, by defining whether and how\n                 the line is channelized.  If the line is channelized,\n                 the value will be other than noChannel(1).  This\n                 object defines which channel type(s) are supported.\n\n                 In the case that the line is channelized, the manager\n                 can use the ifStackTable to determine the ifIndex for\n                 the associated channel(s).')
adslLineSpecific = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 1, 1, 3), VariablePointer()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslLineSpecific.setDescription('OID instance in vendor-specific MIB. The Instance may\n                 be used to determine shelf/slot/port of the ATUC\n                 interface in a DSLAM.')
adslLineConfProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 1, 1, 4), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(1,32))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: adslLineConfProfile.setDescription("The value of this object identifies the row\n                 in the ADSL Line Configuration Profile Table,\n                 (adslLineConfProfileTable), which applies for this\n                 ADSL line, and channels if applicable.\n\n                 For `dynamic' mode, in the case which the\n                 configuration profile has not been set, the\n                 value will be set to `DEFVAL'.\n\n                 If the implementator of this MIB has chosen not\n                 to implement `dynamic assignment' of profiles, this\n                 object's MIN-ACCESS is read-only.")
adslLineAlarmConfProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 1, 1, 5), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(1,32))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: adslLineAlarmConfProfile.setDescription("The value of this object identifies the row\n                 in the ADSL Line Alarm Configuration Profile Table,\n                 (adslLineAlarmConfProfileTable), which applies to this\n                 ADSL line, and channels if applicable.\n\n                 For `dynamic' mode, in the case which the\n                 alarm profile has not been set, the\n                 value will be set to `DEFVAL'.\n\n                 If the implementator of this MIB has chosen not\n                 to implement `dynamic assignment' of profiles, this\n                 object's MIN-ACCESS is read-only.")
adslAtucPhysTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 2), )
if mibBuilder.loadTexts: adslAtucPhysTable.setDescription('This table provides one row for each ATUC.\n                 Each row contains the Physical Layer Parameters\n                 table for that ATUC. ADSL physical interfaces are\n                 those ifEntries where ifType is equal to adsl(94).')
adslAtucPhysEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 2, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: adslAtucPhysEntry.setDescription('An entry in the adslAtucPhysTable.')
adslAtucInvSerialNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 2, 1, 1), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucInvSerialNumber.setDescription('The vendor specific string that identifies the\n                 vendor equipment.')
adslAtucInvVendorID = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 2, 1, 2), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucInvVendorID.setDescription('The vendor ID code is a copy of the binary\n                 vendor identification field defined by the\n                 PHY[10] and expressed as readable characters.')
adslAtucInvVersionNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 2, 1, 3), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucInvVersionNumber.setDescription('The vendor specific version number sent by this ATU\n                 as part of the initialization messages.  It is a copy\n                 of the binary version number field defined by the\n                 PHY[10] and expressed as readable characters.')
adslAtucCurrSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 2, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-640,640))).setUnits('tenth dB').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucCurrSnrMgn.setDescription('Noise Margin as seen by this ATU with respect to its\n                 received signal in tenth dB.')
adslAtucCurrAtn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 2, 1, 5), Gauge32().subtype(subtypeSpec=ValueRangeConstraint(0,630))).setUnits('tenth dB').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucCurrAtn.setDescription('Measured difference in the total power transmitted by\n                 the peer ATU and the total power received by this ATU.')
adslAtucCurrStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 2, 1, 6), Bits().clone(namedValues=NamedValues(("noDefect", 0), ("lossOfFraming", 1), ("lossOfSignal", 2), ("lossOfPower", 3), ("lossOfSignalQuality", 4), ("lossOfLink", 5), ("dataInitFailure", 6), ("configInitFailure", 7), ("protocolInitFailure", 8), ("noPeerAtuPresent", 9),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucCurrStatus.setDescription('Indicates current state of the ATUC line.  This is a\n                 bit-map of possible conditions.  The various bit\n                 positions are:\n\n          0      noDefect             There no defects on the line\n\n          1      lossOfFraming        ATUC failure due to not\n                                      receiving valid frame.\n\n          2      lossOfSignal         ATUC failure due to not\n                                      receiving signal.\n\n          3      lossOfPower          ATUC failure due to loss of\n                                      power.\n                                      Note: the Agent may still\n                                      function.\n\n          4      lossOfSignalQuality  Loss of Signal Quality is\n                                      declared when the Noise Margin\n                                      falls below the Minimum Noise\n                                      Margin, or the bit-error-rate\n                                      exceeds 10^-7.\n\n          5      lossOfLink           ATUC failure due to inability\n                                      to link with ATUR.\n\n          6      dataInitFailure      ATUC failure during\n                                      initialization due to bit\n                                      errors corrupting startup\n                                      exchange data.\n\n          7      configInitFailure    ATUC failure during\n                                      initialization due to peer\n                                      ATU not able to support\n                                      requested configuration\n\n          8      protocolInitFailure  ATUC failure during\n                                      initialization due to\n                                      incompatible protocol used by\n                                      the peer ATU.\n\n          9      noPeerAtuPresent     ATUC failure during\n                                      initialization due to no\n                                      activation sequence detected\n                                      from peer ATU.\n\n                 This is intended to supplement ifOperStatus.')
adslAtucCurrOutputPwr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 2, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-310,310))).setUnits('tenth dBm').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucCurrOutputPwr.setDescription('Measured total output power transmitted by this ATU.\n                 This is the measurement that was reported during\n                 the last activation sequence.')
adslAtucCurrAttainableRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 2, 1, 8), Gauge32()).setUnits('bps').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucCurrAttainableRate.setDescription('Indicates the maximum currently attainable data rate\n                 by the ATU.  This value will be equal or greater than\n                 the current line rate.')
adslAturPhysTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 3), )
if mibBuilder.loadTexts: adslAturPhysTable.setDescription('This table provides one row for each ATUR\n                 Each row contains the Physical Layer Parameters\n                 table for that ATUR. ADSL physical interfaces are\n                 those ifEntries where ifType is equal to adsl(94).')
adslAturPhysEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 3, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: adslAturPhysEntry.setDescription('An entry in the adslAturPhysTable.')
adslAturInvSerialNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 3, 1, 1), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturInvSerialNumber.setDescription('The vendor specific string that identifies the\n                 vendor equipment.')
adslAturInvVendorID = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 3, 1, 2), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturInvVendorID.setDescription('The vendor ID code is a copy of the binary\n                 vendor identification field defined by the\n                 PHY[10] and expressed as readable characters.')
adslAturInvVersionNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 3, 1, 3), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0,16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturInvVersionNumber.setDescription('The vendor specific version number sent by this ATU\n                 as part of the initialization messages.  It is a copy\n                 of the binary version number field defined by the\n                 PHY[10] and expressed as readable characters.')
adslAturCurrSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 3, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-640,640))).setUnits('tenth dB').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturCurrSnrMgn.setDescription('Noise Margin as seen by this ATU with respect to its\n                 received signal in tenth dB.')
adslAturCurrAtn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 3, 1, 5), Gauge32().subtype(subtypeSpec=ValueRangeConstraint(0,630))).setUnits('tenth dB').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturCurrAtn.setDescription('Measured difference in the total power transmitted by\n                 the peer ATU and the total power received by this ATU.')
adslAturCurrStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 3, 1, 6), Bits().clone(namedValues=NamedValues(("noDefect", 0), ("lossOfFraming", 1), ("lossOfSignal", 2), ("lossOfPower", 3), ("lossOfSignalQuality", 4),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturCurrStatus.setDescription('Indicates current state of the ATUR line.  This is a\n                 bit-map of possible conditions.  Due to the isolation\n                 of the ATUR when line problems occur, many state\n                 conditions like loss of power, loss of quality signal,\n                 and initialization errors,  can not be determined.\n                 While trouble shooting ATUR, also use object,\n                 adslAtucCurrStatus.  The various bit positions are:\n\n          0      noDefect             There no defects on the line\n\n          1      lossOfFraming        ATUR failure due to not\n                                      receiving valid frame\n\n          2      lossOfSignal         ATUR failure due to not\n                                      receiving signal\n\n          3      lossOfPower          ATUR failure due to loss of\n                                      power\n\n          4      lossOfSignalQuality  Loss of Signal Quality is\n                                      declared when the Noise Margin\n                                      falls below the Minimum Noise\n                                      Margin, or the\n                                      bit-error-rate exceeds 10^-7.\n\n                 This is intended to supplement ifOperStatus.')
adslAturCurrOutputPwr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 3, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-310,310))).setUnits('tenth dBm').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturCurrOutputPwr.setDescription('Measured total output power transmitted by this ATU.\n                 This is the measurement that was reported during\n                 the last activation sequence.')
adslAturCurrAttainableRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 3, 1, 8), Gauge32()).setUnits('bps').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturCurrAttainableRate.setDescription('Indicates the maximum currently attainable data rate\n                 by the ATU.  This value will be equal or greater than\n                 the current line rate.')
adslAtucChanTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 4), )
if mibBuilder.loadTexts: adslAtucChanTable.setDescription('This table provides one row for each ATUC channel.\n                 ADSL channel interfaces are those ifEntries\n                 where ifType is equal to adslInterleave(124)\n                 or adslFast(125).')
adslAtucChanEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 4, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: adslAtucChanEntry.setDescription('An entry in the adslAtucChanTable.')
adslAtucChanInterleaveDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 4, 1, 1), Gauge32()).setUnits('milli-seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanInterleaveDelay.setDescription('Interleave Delay for this channel.\n\n                 Interleave delay applies only to the\n                 interleave channel and defines the mapping\n                 (relative spacing) between subsequent input\n                 bytes at the interleaver input and their placement\n                 in the bit stream at the interleaver output.\n                 Larger numbers provide greater separation between\n                 consecutive input bytes in the output bit stream\n                 allowing for improved impulse noise immunity at\n                 the expense of payload latency.\n\n                 In the case where the ifType is Fast(125), use\n                 noSuchObject.')
adslAtucChanCurrTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 4, 1, 2), Gauge32()).setUnits('bps').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanCurrTxRate.setDescription('Actual transmit rate on this channel.')
adslAtucChanPrevTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 4, 1, 3), Gauge32()).setUnits('bps').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPrevTxRate.setDescription('The rate at the time of the last\n                 adslAtucRateChangeTrap event. It is also set at\n                 initialization to prevent a trap being sent.\n\n                 Rate changes less than adslAtucThresh(*)RateDown\n                 or less than adslAtucThresh(*)RateUp will not\n                 cause a trap or cause this object to change.\n                 (*) == Fast or Interleave.\n                 See AdslLineAlarmConfProfileEntry.')
adslAtucChanCrcBlockLength = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 4, 1, 4), Gauge32()).setUnits('byte').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanCrcBlockLength.setDescription('Indicates the length of the channel data-block\n                 on which the CRC operates.  Refer to Line Code\n                 Specific MIBs, [11] and [12] for more\n                 information.')
adslAturChanTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 5), )
if mibBuilder.loadTexts: adslAturChanTable.setDescription('This table provides one row for each ATUR channel.\n                 ADSL channel interfaces are those ifEntries\n                 where ifType is equal to adslInterleave(124)\n                 or adslFast(125).')
adslAturChanEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 5, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: adslAturChanEntry.setDescription('An entry in the adslAturChanTable.')
adslAturChanInterleaveDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 5, 1, 1), Gauge32()).setUnits('milli-seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanInterleaveDelay.setDescription('Interleave Delay for this channel.\n\n                 Interleave delay applies only to the\n                 interleave channel and defines the mapping\n                 (relative spacing) between subsequent input\n                 bytes at the interleaver input and their placement\n                 in the bit stream at the interleaver output.\n                 Larger numbers provide greater separation between\n                 consecutive input bytes in the output bit stream\n                 allowing for improved impulse noise immunity at\n                 the expense of payload latency.\n\n                 In the case where the ifType is Fast(125), use\n                 noSuchObject.')
adslAturChanCurrTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 5, 1, 2), Gauge32()).setUnits('bps').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanCurrTxRate.setDescription('Actual transmit rate on this channel.')
adslAturChanPrevTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 5, 1, 3), Gauge32()).setUnits('bps').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPrevTxRate.setDescription('The rate at the time of the last\n                 adslAturRateChangeTrap event. It is also set at\n                 initialization to prevent a trap being sent.\n                 Rate changes less than adslAturThresh(*)RateDown\n                 or less than adslAturThresh(*)RateUp will not\n                 cause a trap or cause this object to change.\n                 (*) == Fast or Interleave.\n                 See AdslLineAlarmConfProfileEntry.')
adslAturChanCrcBlockLength = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 5, 1, 4), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanCrcBlockLength.setDescription('Indicates the length of the channel data-block\n                 on which the CRC operates.  Refer to Line Code\n                 Specific MIBs, [11] and [12] for more\n                 information.')
adslAtucPerfDataTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6), )
if mibBuilder.loadTexts: adslAtucPerfDataTable.setDescription('This table provides one row for each ATUC.\n                 ADSL physical interfaces are\n                 those ifEntries where ifType is equal to adsl(94).')
adslAtucPerfDataEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: adslAtucPerfDataEntry.setDescription('An entry in adslAtucPerfDataTable.')
adslAtucPerfLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfLofs.setDescription('Count of the number of Loss of Framing failures since\n                 agent reset.')
adslAtucPerfLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfLoss.setDescription('Count of the number of Loss of Signal failures since\n                 agent reset.')
adslAtucPerfLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfLols.setDescription('Count of the number of Loss of Link failures since\n                 agent reset.')
adslAtucPerfLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfLprs.setDescription('Count of the number of Loss of Power failures since\n                 agent reset.')
adslAtucPerfESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfESs.setDescription('Count of the number of Errored Seconds since agent\n                 reset.  The errored second parameter is a count of\n                 one-second intervals containing one or more crc\n                 anomalies, or one or more los or sef defects.')
adslAtucPerfInits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfInits.setDescription('Count of the line initialization attempts since\n                 agent reset. Includes both successful and failed\n                 attempts.')
adslAtucPerfValidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfValidIntervals.setDescription('The number of previous 15-minute intervals in the\n                 interval table for which data was collected.  Given\n                 that <n> is the maximum # of intervals supported.\n                 The value will be <n> unless the measurement was\n                 (re-)started within the last (<n>*15) minutes, in which\n                 case the value will be the number of complete 15\n                 minute intervals for which the agent has at least\n                 some data. In certain cases (e.g., in the case\n                 where the agent is a proxy) it is possible that some\n                 intervals are unavailable.  In this case, this\n                 interval is the maximum interval number for\n                 which data is available.')
adslAtucPerfInvalidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfInvalidIntervals.setDescription('The number of intervals in the range from\n                 0 to the value of adslAtucPerfValidIntervals\n                 for which no data is available. This object\n                 will typically be zero except in cases where\n                 the data for some intervals are not available\n                 (e.g., in proxy situations).')
adslAtucPerfCurr15MinTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 9), AdslPerfTimeElapsed().subtype(subtypeSpec=ValueRangeConstraint(0,899))).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr15MinTimeElapsed.setDescription('Total elapsed seconds in this interval.')
adslAtucPerfCurr15MinLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 10), PerfCurrentCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr15MinLofs.setDescription('Count of seconds in the current 15 minute interval\n                 when there was Loss of Framing.')
adslAtucPerfCurr15MinLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 11), PerfCurrentCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr15MinLoss.setDescription('Count of seconds in the current 15 minute interval\n                 when there was Loss of Signal.')
adslAtucPerfCurr15MinLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 12), PerfCurrentCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr15MinLols.setDescription('Count of seconds in the current 15 minute interval\n                 when there was Loss of Link.')
adslAtucPerfCurr15MinLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 13), PerfCurrentCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr15MinLprs.setDescription('Count of seconds in the current 15 minute interval\n                 when there was Loss of Power.')
adslAtucPerfCurr15MinESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 14), PerfCurrentCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr15MinESs.setDescription('Count of Errored Seconds in the current 15 minute\n                 interval.  The errored second parameter is a count of\n                 one-second intervals containing one or more crc\n                 anomalies, or one or more los or sef defects.')
adslAtucPerfCurr15MinInits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 15), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr15MinInits.setDescription('Count of the line initialization attempts in the\n                 current 15 minute interval. Includes both successful\n                 and failed attempts.')
adslAtucPerfCurr1DayTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 16), AdslPerfTimeElapsed().subtype(subtypeSpec=ValueRangeConstraint(0,86399))).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr1DayTimeElapsed.setDescription('Number of seconds that have elapsed since the\n                 beginning of the current 1-day interval.')
adslAtucPerfCurr1DayLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 17), AdslPerfCurrDayCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr1DayLofs.setDescription('Count of the number of seconds when there was Loss of\n                 Framing during the current day as measured by\n                 adslAtucPerfCurr1DayTimeElapsed.')
adslAtucPerfCurr1DayLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 18), AdslPerfCurrDayCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr1DayLoss.setDescription('Count of the number of seconds when there was Loss of\n                 Signal during the current day as measured by\n                 adslAtucPerfCurr1DayTimeElapsed.')
adslAtucPerfCurr1DayLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 19), AdslPerfCurrDayCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr1DayLols.setDescription('Count of the number of seconds when there was Loss of\n                 Link during the current day as measured by\n                 adslAtucPerfCurr1DayTimeElapsed.')
adslAtucPerfCurr1DayLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 20), AdslPerfCurrDayCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr1DayLprs.setDescription('Count of the number of seconds when there was Loss of\n                 Power during the current day as measured by\n                 adslAtucPerfCurr1DayTimeElapsed.')
adslAtucPerfCurr1DayESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 21), AdslPerfCurrDayCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr1DayESs.setDescription('Count of Errored Seconds during the current day as\n                 measured by adslAtucPerfCurr1DayTimeElapsed.\n                 The errored second parameter is a count of\n                 one-second intervals containing one or more crc\n                 anomalies, or one or more los or sef defects.')
adslAtucPerfCurr1DayInits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 22), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr1DayInits.setDescription('Count of the line initialization attempts in the\n                 day as measured by adslAtucPerfCurr1DayTimeElapsed.\n                 Includes both successful and failed attempts.')
adslAtucPerfPrev1DayMoniSecs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 23), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,86400))).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfPrev1DayMoniSecs.setDescription('The amount of time in the previous 1-day interval\n                 over which the performance monitoring information\n                 is actually counted. This value will be the same as\n                 the interval duration except in a situation where\n                 performance monitoring data could not be collected\n                 for any reason.')
adslAtucPerfPrev1DayLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 24), AdslPerfPrevDayCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfPrev1DayLofs.setDescription('Count of seconds in the interval when there was\n                 Loss of Framing within the most recent previous\n                 1-day period.')
adslAtucPerfPrev1DayLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 25), AdslPerfPrevDayCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfPrev1DayLoss.setDescription('Count of seconds in the interval when there was\n                 Loss of Signal within the most recent previous\n                 1-day period.')
adslAtucPerfPrev1DayLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 26), AdslPerfPrevDayCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfPrev1DayLols.setDescription('Count of seconds in the interval when there was\n                 Loss of Link within the most recent previous\n                 1-day period.')
adslAtucPerfPrev1DayLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 27), AdslPerfPrevDayCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfPrev1DayLprs.setDescription('Count of seconds in the interval when there was\n                 Loss of Power within the most recent previous\n                 1-day period.')
adslAtucPerfPrev1DayESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 28), AdslPerfPrevDayCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfPrev1DayESs.setDescription('Count of Errored Seconds within the most recent\n                 previous 1-day period. The errored second parameter is\n                 a count of one-second intervals containing one or more\n                 crc anomalies, or one or more los or sef defects.')
adslAtucPerfPrev1DayInits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 29), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfPrev1DayInits.setDescription('Count of the line initialization attempts in the most\n                 recent previous 1-day period. Includes both successful\n                 and failed attempts.')
adslAturPerfDataTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7), )
if mibBuilder.loadTexts: adslAturPerfDataTable.setDescription('This table provides one row for each ATUR.\n                 ADSL physical interfaces are\n                 those ifEntries where ifType is equal to adsl(94).')
adslAturPerfDataEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: adslAturPerfDataEntry.setDescription('An entry in adslAturPerfDataTable.')
adslAturPerfLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 1), Counter32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfLofs.setDescription('Count of the number of Loss of Framing failures since\n                 agent reset.')
adslAturPerfLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 2), Counter32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfLoss.setDescription('Count of the number of Loss of Signal failures since\n                 agent reset.')
adslAturPerfLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 3), Counter32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfLprs.setDescription('Count of the number of Loss of Power failures since\n                 agent reset.')
adslAturPerfESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 4), Counter32()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfESs.setDescription('Count of the number of Errored Seconds since agent\n                 reset.  The errored second parameter is a count of\n                 one-second intervals containing one or more crc\n                 anomalies, or one or more los or sef defects.')
adslAturPerfValidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfValidIntervals.setDescription('The number of previous 15-minute intervals in the\n                 interval table for which data was collected.  Given\n                 that <n> is the maximum # of intervals supported.\n                 The value will be <n> unless the measurement was\n                 (re-)started within the last (<n>*15) minutes, in which\n                 case the value will be the number of complete 15\n                 minute intervals for which the agent has at least\n                 some data. In certain cases (e.g., in the case\n                 where the agent is a proxy) it is possible that some\n                 intervals are unavailable.  In this case, this\n                 interval is the maximum interval number for\n                 which data is available.')
adslAturPerfInvalidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfInvalidIntervals.setDescription('The number of intervals in the range from\n                 0 to the value of adslAturPerfValidIntervals\n                 for which no data is available. This object\n                 will typically be zero except in cases where\n                 the data for some intervals are not available\n                 (e.g., in proxy situations).')
adslAturPerfCurr15MinTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 7), AdslPerfTimeElapsed().subtype(subtypeSpec=ValueRangeConstraint(0,899))).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfCurr15MinTimeElapsed.setDescription('Total elapsed seconds in this interval.')
adslAturPerfCurr15MinLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 8), PerfCurrentCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfCurr15MinLofs.setDescription('Count of seconds in the current 15 minute interval\n                 when there was Loss of Framing.')
adslAturPerfCurr15MinLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 9), PerfCurrentCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfCurr15MinLoss.setDescription('Count of seconds in the current 15 minute interval\n                 when there was Loss of Signal.')
adslAturPerfCurr15MinLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 10), PerfCurrentCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfCurr15MinLprs.setDescription('Count of seconds in the current 15 minute interval\n                 when there was Loss of Power.')
adslAturPerfCurr15MinESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 11), PerfCurrentCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfCurr15MinESs.setDescription('Count of Errored Seconds in the current 15 minute\n                interval.  The errored second parameter is a count of\n                one-second intervals containing one or more crc\n                anomalies, or one or more los or sef defects.')
adslAturPerfCurr1DayTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 12), AdslPerfTimeElapsed().subtype(subtypeSpec=ValueRangeConstraint(0,86399))).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfCurr1DayTimeElapsed.setDescription('Number of seconds that have elapsed since the\n                 beginning of the current 1-day interval.')
adslAturPerfCurr1DayLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 13), AdslPerfCurrDayCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfCurr1DayLofs.setDescription('Count of the number of seconds when there was Loss\n                 of Framing during the current day as measured by\n                 adslAturPerfCurr1DayTimeElapsed.')
adslAturPerfCurr1DayLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 14), AdslPerfCurrDayCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfCurr1DayLoss.setDescription('Count of the number of seconds when there was Loss\n                 of Signal during the current day as measured by\n                 adslAturPerfCurr1DayTimeElapsed.')
adslAturPerfCurr1DayLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 15), AdslPerfCurrDayCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfCurr1DayLprs.setDescription('Count of the number of seconds when there was Loss\n                 of Power during the current day as measured by\n                 adslAturPerfCurr1DayTimeElapsed.')
adslAturPerfCurr1DayESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 16), AdslPerfCurrDayCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfCurr1DayESs.setDescription('Count of Errored Seconds during the current day as\n                 measured by adslAturPerfCurr1DayTimeElapsed.\n                 The errored second parameter is a count of\n                 one-second intervals containing one or more crc\n                 anomalies, or one or more los or sef defects.')
adslAturPerfPrev1DayMoniSecs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 17), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,86400))).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfPrev1DayMoniSecs.setDescription('The amount of time in the previous 1-day interval\n                 over which the performance monitoring information\n                 is actually counted. This value will be the same as\n                 the interval duration except in a situation where\n                 performance monitoring data could not be collected\n                 for any reason.')
adslAturPerfPrev1DayLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 18), AdslPerfPrevDayCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfPrev1DayLofs.setDescription('Count of seconds in the interval when there was\n                 Loss of Framing within the most recent previous\n                 1-day period.')
adslAturPerfPrev1DayLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 19), AdslPerfPrevDayCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfPrev1DayLoss.setDescription('Count of seconds in the interval when there was\n                 Loss of Signal within the most recent previous\n                 1-day period.')
adslAturPerfPrev1DayLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 20), AdslPerfPrevDayCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfPrev1DayLprs.setDescription('Count of seconds in the interval when there was\n                 Loss of Power within the most recent previous\n                 1-day period.')
adslAturPerfPrev1DayESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 21), AdslPerfPrevDayCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfPrev1DayESs.setDescription('Count of Errored Seconds within the most recent\n                 previous 1-day period. The errored second parameter is\n                 a count of one-second intervals containing one or more\n                 crc anomalies, or one or more los or sef defects.')
adslAtucIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 8), )
if mibBuilder.loadTexts: adslAtucIntervalTable.setDescription('This table provides one row for each ATUC\n                 performance data collection interval.\n                 ADSL physical interfaces are\n                 those ifEntries where ifType is equal to adsl(94).')
adslAtucIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 8, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "ADSL-LINE-MIB", "adslAtucIntervalNumber"))
if mibBuilder.loadTexts: adslAtucIntervalEntry.setDescription('An entry in the adslAtucIntervalTable.')
adslAtucIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 8, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,96)))
if mibBuilder.loadTexts: adslAtucIntervalNumber.setDescription('Performance Data Interval number 1 is the\n                 the most recent previous interval; interval\n                 96 is 24 hours ago.  Intervals 2..96 are\n                 optional.')
adslAtucIntervalLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 8, 1, 2), PerfIntervalCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucIntervalLofs.setDescription('Count of seconds in the interval when there was Loss\n                 of Framing.')
adslAtucIntervalLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 8, 1, 3), PerfIntervalCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucIntervalLoss.setDescription('Count of seconds in the interval when there was Loss\n                 of Signal.')
adslAtucIntervalLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 8, 1, 4), PerfIntervalCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucIntervalLols.setDescription('Count of seconds in the interval when there was Loss\n                 of Link.')
adslAtucIntervalLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 8, 1, 5), PerfIntervalCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucIntervalLprs.setDescription('Count of seconds in the interval when there was Loss\n                 of Power.')
adslAtucIntervalESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 8, 1, 6), PerfIntervalCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucIntervalESs.setDescription('Count of Errored Seconds in the interval.\n                 The errored second parameter is a count of\n                 one-second intervals containing one or more crc\n                 anomalies, or one or more los or sef defects.')
adslAtucIntervalInits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 8, 1, 7), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucIntervalInits.setDescription('Count of the line initialization attempts\n                 during the interval. Includes both successful\n                 and failed attempts.')
adslAtucIntervalValidData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 8, 1, 8), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucIntervalValidData.setDescription('This variable indicates if the data for this\n                 interval is valid.')
adslAturIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 9), )
if mibBuilder.loadTexts: adslAturIntervalTable.setDescription('This table provides one row for each ATUR\n                 performance data collection interval.\n                 ADSL physical interfaces are those\n                 ifEntries where ifType is equal to adsl(94).')
adslAturIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 9, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "ADSL-LINE-MIB", "adslAturIntervalNumber"))
if mibBuilder.loadTexts: adslAturIntervalEntry.setDescription('An entry in the adslAturIntervalTable.')
adslAturIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 9, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,96)))
if mibBuilder.loadTexts: adslAturIntervalNumber.setDescription('Performance Data Interval number 1 is the\n                 the most recent previous interval; interval\n                 96 is 24 hours ago.  Intervals 2..96 are\n                 optional.')
adslAturIntervalLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 9, 1, 2), PerfIntervalCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturIntervalLofs.setDescription('Count of seconds in the interval when there was\n                 Loss of Framing.')
adslAturIntervalLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 9, 1, 3), PerfIntervalCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturIntervalLoss.setDescription('Count of seconds in the interval when there was\n                 Loss of Signal.')
adslAturIntervalLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 9, 1, 4), PerfIntervalCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturIntervalLprs.setDescription('Count of seconds in the interval when there was\n                 Loss of Power.')
adslAturIntervalESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 9, 1, 5), PerfIntervalCount()).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturIntervalESs.setDescription('Count of Errored Seconds in the interval.\n                 The errored second parameter is a count of\n                 one-second intervals containing one or more crc\n                 anomalies, or one or more los or sef defects.')
adslAturIntervalValidData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 9, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturIntervalValidData.setDescription('This variable indicates if the data for this\n                 interval is valid.')
adslAtucChanPerfDataTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10), )
if mibBuilder.loadTexts: adslAtucChanPerfDataTable.setDescription('This table provides one row for each ATUC channel.\n                 ADSL channel interfaces are those ifEntries\n                 where ifType is equal to adslInterleave(124)\n                 or adslFast(125).')
adslAtucChanPerfDataEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: adslAtucChanPerfDataEntry.setDescription('An entry in adslAtucChanPerfDataTable.')
adslAtucChanReceivedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanReceivedBlks.setDescription('Count of all encoded blocks received on this channel\n                 since agent reset.')
adslAtucChanTransmittedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanTransmittedBlks.setDescription('Count of all encoded blocks transmitted on this\n                 channel since agent reset.')
adslAtucChanCorrectedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanCorrectedBlks.setDescription('Count of all blocks received with errors that were\n                 corrected since agent reset.  These blocks are passed\n                 on as good data.')
adslAtucChanUncorrectBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanUncorrectBlks.setDescription('Count of all blocks received with uncorrectable\n                 errors since agent reset.')
adslAtucChanPerfValidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfValidIntervals.setDescription('The number of previous 15-minute intervals in the\n                 interval table for which data was collected.  Given\n                 that <n> is the maximum # of intervals supported.\n                 The value will be <n> unless the measurement was\n                 (re-)started within the last (<n>*15) minutes, in which\n                 case the value will be the number of complete 15\n                 minute intervals for which the agent has at least\n                 some data. In certain cases (e.g., in the case\n                 where the agent is a proxy) it is possible that some\n                 intervals are unavailable.  In this case, this\n                 interval is the maximum interval number for\n                 which data is available.')
adslAtucChanPerfInvalidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfInvalidIntervals.setDescription('The number of intervals in the range from\n                 0 to the value of adslAtucChanPerfValidIntervals\n                 for which no data is available. This object\n                 will typically be zero except in cases where\n                 the data for some intervals are not available\n                 (e.g., in proxy situations).')
adslAtucChanPerfCurr15MinTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 7), AdslPerfTimeElapsed().subtype(subtypeSpec=ValueRangeConstraint(0,899))).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfCurr15MinTimeElapsed.setDescription('Total elapsed seconds in this interval.')
adslAtucChanPerfCurr15MinReceivedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 8), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfCurr15MinReceivedBlks.setDescription('Count of all encoded blocks received on this channel\n                 within the current 15 minute interval.')
adslAtucChanPerfCurr15MinTransmittedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 9), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfCurr15MinTransmittedBlks.setDescription('Count of all encoded blocks transmitted on this\n                 channel within the current 15 minute interval.')
adslAtucChanPerfCurr15MinCorrectedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 10), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfCurr15MinCorrectedBlks.setDescription('Count of all blocks received with errors that were\n                 corrected on this channel within the current 15 minute\n                 interval.')
adslAtucChanPerfCurr15MinUncorrectBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 11), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfCurr15MinUncorrectBlks.setDescription('Count of all blocks received with uncorrectable\n                 errors on this channel within the current 15 minute\n                 interval.')
adslAtucChanPerfCurr1DayTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 12), AdslPerfTimeElapsed().subtype(subtypeSpec=ValueRangeConstraint(0,86399))).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfCurr1DayTimeElapsed.setDescription('Number of seconds that have elapsed since the\n                 beginning of the current 1-day interval.')
adslAtucChanPerfCurr1DayReceivedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 13), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfCurr1DayReceivedBlks.setDescription('Count of all encoded blocks received on this\n                 channel during the current day as measured by\n                 adslAtucChanPerfCurr1DayTimeElapsed.')
adslAtucChanPerfCurr1DayTransmittedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 14), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfCurr1DayTransmittedBlks.setDescription('Count of all encoded blocks transmitted on this\n                 channel during the current day as measured by\n                 adslAtucChanPerfCurr1DayTimeElapsed.')
adslAtucChanPerfCurr1DayCorrectedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 15), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfCurr1DayCorrectedBlks.setDescription('Count of all blocks received with errors that were\n                 corrected on this channel during the current day as\n                 measured by adslAtucChanPerfCurr1DayTimeElapsed.')
adslAtucChanPerfCurr1DayUncorrectBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 16), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfCurr1DayUncorrectBlks.setDescription('Count of all blocks received with uncorrectable\n                 errors on this channel during the current day as\n                 measured by adslAtucChanPerfCurr1DayTimeElapsed.')
adslAtucChanPerfPrev1DayMoniSecs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 17), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,86400))).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfPrev1DayMoniSecs.setDescription('The amount of time in the previous 1-day interval\n                 over which the performance monitoring information\n                 is actually counted. This value will be the same as\n                 the interval duration except in a situation where\n                 performance monitoring data could not be collected\n                 for any reason.')
adslAtucChanPerfPrev1DayReceivedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 18), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfPrev1DayReceivedBlks.setDescription('Count of all encoded blocks received on this\n                 channel within the most recent previous 1-day\n                 period.')
adslAtucChanPerfPrev1DayTransmittedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 19), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfPrev1DayTransmittedBlks.setDescription('Count of all encoded blocks transmitted on this\n                 channel within the most recent previous 1-day\n                 period.')
adslAtucChanPerfPrev1DayCorrectedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 20), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfPrev1DayCorrectedBlks.setDescription('Count of all blocks received with errors that were\n                 corrected on this channel within the most recent\n                 previous 1-day period.')
adslAtucChanPerfPrev1DayUncorrectBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 21), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfPrev1DayUncorrectBlks.setDescription('Count of all blocks received with uncorrectable\n                 errors on this channel within the most recent previous\n                 1-day period.')
adslAturChanPerfDataTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11), )
if mibBuilder.loadTexts: adslAturChanPerfDataTable.setDescription('This table provides one row for each ATUR channel.\n                 ADSL channel interfaces are those ifEntries\n                 where ifType is equal to adslInterleave(124)\n                 or adslFast(125).')
adslAturChanPerfDataEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: adslAturChanPerfDataEntry.setDescription('An entry in adslAturChanPerfDataTable.')
adslAturChanReceivedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanReceivedBlks.setDescription('Count of all encoded blocks received on this channel\n                 since agent reset.')
adslAturChanTransmittedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanTransmittedBlks.setDescription('Count of all encoded blocks transmitted on this\n                 channel since agent reset.')
adslAturChanCorrectedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanCorrectedBlks.setDescription('Count of all blocks received with errors that were\n                 corrected since agent reset.  These blocks are passed\n                 on as good data.')
adslAturChanUncorrectBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanUncorrectBlks.setDescription('Count of all blocks received with uncorrectable\n                 errors since agent reset.')
adslAturChanPerfValidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfValidIntervals.setDescription('The number of previous 15-minute intervals in the\n                 interval table for which data was collected.  Given\n                 that <n> is the maximum # of intervals supported.\n                 The value will be <n> unless the measurement was\n                 (re-)started within the last (<n>*15) minutes, in which\n                 case the value will be the number of complete 15\n                 minute intervals for which the agent has at least\n                 some data. In certain cases (e.g., in the case\n                 where the agent is a proxy) it is possible that some\n                 intervals are unavailable.  In this case, this\n                 interval is the maximum interval number for\n                 which data is available.')
adslAturChanPerfInvalidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfInvalidIntervals.setDescription('The number of intervals in the range from\n                 0 to the value of adslAturChanPerfValidIntervals\n                 for which no data is available. This object\n                 will typically be zero except in cases where\n                 the data for some intervals are not available\n                 (e.g., in proxy situations).')
adslAturChanPerfCurr15MinTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 7), AdslPerfTimeElapsed().subtype(subtypeSpec=ValueRangeConstraint(0,899))).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfCurr15MinTimeElapsed.setDescription('Total elapsed seconds in this interval.\n                 A full interval is 900 seconds.')
adslAturChanPerfCurr15MinReceivedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 8), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfCurr15MinReceivedBlks.setDescription('Count of all encoded blocks received on this\n                 channel within the current 15 minute interval.')
adslAturChanPerfCurr15MinTransmittedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 9), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfCurr15MinTransmittedBlks.setDescription('Count of all encoded blocks transmitted on this\n                 channel within the current 15 minute interval.')
adslAturChanPerfCurr15MinCorrectedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 10), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfCurr15MinCorrectedBlks.setDescription('Count of all blocks received with errors that were\n                 corrected on this channel within the current 15 minute\n                 interval.')
adslAturChanPerfCurr15MinUncorrectBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 11), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfCurr15MinUncorrectBlks.setDescription('Count of all blocks received with uncorrectable\n                 errors on this channel within the current 15 minute\n                 interval.')
adslAturChanPerfCurr1DayTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 12), AdslPerfTimeElapsed().subtype(subtypeSpec=ValueRangeConstraint(0,86399))).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfCurr1DayTimeElapsed.setDescription('Number of seconds that have elapsed since the\n                 beginning of the current 1-day interval.')
adslAturChanPerfCurr1DayReceivedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 13), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfCurr1DayReceivedBlks.setDescription('Count of all encoded blocks received on this\n                 channel during the current day as measured by\n                 adslAturChanPerfCurr1DayTimeElapsed.')
adslAturChanPerfCurr1DayTransmittedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 14), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfCurr1DayTransmittedBlks.setDescription('Count of all encoded blocks transmitted on this\n                 channel during the current day as measured by\n                 adslAturChanPerfCurr1DayTimeElapsed.')
adslAturChanPerfCurr1DayCorrectedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 15), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfCurr1DayCorrectedBlks.setDescription('Count of all blocks received with errors that were\n                 corrected on this channel during the current day as\n                 measured by adslAturChanPerfCurr1DayTimeElapsed.')
adslAturChanPerfCurr1DayUncorrectBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 16), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfCurr1DayUncorrectBlks.setDescription('Count of all blocks received with uncorrectable\n                 errors on this channel during the current day as\n                 measured by adslAturChanPerfCurr1DayTimeElapsed.')
adslAturChanPerfPrev1DayMoniSecs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 17), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,86400))).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfPrev1DayMoniSecs.setDescription('The amount of time in the previous 1-day interval\n                 over which the performance monitoring information\n                 is actually counted. This value will be the same as\n                 the interval duration except in a situation where\n                 performance monitoring data could not be collected\n                 for any reason.')
adslAturChanPerfPrev1DayReceivedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 18), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfPrev1DayReceivedBlks.setDescription('Count of all encoded blocks received on this\n                 channel within the most recent previous 1-day\n                 period.')
adslAturChanPerfPrev1DayTransmittedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 19), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfPrev1DayTransmittedBlks.setDescription('Count of all encoded blocks transmitted on this\n                 channel within the most recent previous 1-day\n                 period.')
adslAturChanPerfPrev1DayCorrectedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 20), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfPrev1DayCorrectedBlks.setDescription('Count of all blocks received with errors that were\n                 corrected on this channel within the most recent\n                 previous 1-day period.')
adslAturChanPerfPrev1DayUncorrectBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 21), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfPrev1DayUncorrectBlks.setDescription('Count of all blocks received with uncorrectable\n                 errors on this channel within the most recent previous\n                 1-day period.')
adslAtucChanIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 12), )
if mibBuilder.loadTexts: adslAtucChanIntervalTable.setDescription("This table provides one row for each ATUC channel's\n                 performance data collection interval.\n                 ADSL channel interfaces are those ifEntries\n                 where ifType is equal to adslInterleave(124)\n                 or adslFast(125).")
adslAtucChanIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 12, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "ADSL-LINE-MIB", "adslAtucChanIntervalNumber"))
if mibBuilder.loadTexts: adslAtucChanIntervalEntry.setDescription('An entry in the adslAtucIntervalTable.')
adslAtucChanIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 12, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,96)))
if mibBuilder.loadTexts: adslAtucChanIntervalNumber.setDescription('Performance Data Interval number 1 is the\n                 the most recent previous interval; interval\n                 96 is 24 hours ago.  Intervals 2..96 are\n                 optional.')
adslAtucChanIntervalReceivedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 12, 1, 2), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanIntervalReceivedBlks.setDescription('Count of all encoded blocks received on this channel\n                 during this interval.')
adslAtucChanIntervalTransmittedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 12, 1, 3), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanIntervalTransmittedBlks.setDescription('Count of all encoded blocks transmitted on this\n                 channel during this interval.')
adslAtucChanIntervalCorrectedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 12, 1, 4), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanIntervalCorrectedBlks.setDescription('Count of all blocks received with errors that were\n                 corrected on this channel during this interval.')
adslAtucChanIntervalUncorrectBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 12, 1, 5), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanIntervalUncorrectBlks.setDescription('Count of all blocks received with uncorrectable\n                 errors on this channel during this interval.')
adslAtucChanIntervalValidData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 12, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanIntervalValidData.setDescription('This variable indicates if the data for this\n                 interval is valid.')
adslAturChanIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 13), )
if mibBuilder.loadTexts: adslAturChanIntervalTable.setDescription("This table provides one row for each ATUR channel's\n                 performance data collection interval.\n                 ADSL channel interfaces are those ifEntries\n                 where ifType is equal to adslInterleave(124)\n                 or adslFast(125).")
adslAturChanIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 13, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "ADSL-LINE-MIB", "adslAturChanIntervalNumber"))
if mibBuilder.loadTexts: adslAturChanIntervalEntry.setDescription('An entry in the adslAturIntervalTable.')
adslAturChanIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 13, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,96)))
if mibBuilder.loadTexts: adslAturChanIntervalNumber.setDescription('Performance Data Interval number 1 is the\n                 the most recent previous interval; interval\n                 96 is 24 hours ago.  Intervals 2..96 are\n                 optional.')
adslAturChanIntervalReceivedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 13, 1, 2), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanIntervalReceivedBlks.setDescription('Count of all encoded blocks received on this channel\n                 during this interval.')
adslAturChanIntervalTransmittedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 13, 1, 3), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanIntervalTransmittedBlks.setDescription('Count of all encoded blocks transmitted on this\n                 channel during this interval.')
adslAturChanIntervalCorrectedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 13, 1, 4), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanIntervalCorrectedBlks.setDescription('Count of all blocks received with errors that were\n                 corrected on this channel during this interval.')
adslAturChanIntervalUncorrectBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 13, 1, 5), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanIntervalUncorrectBlks.setDescription('Count of all blocks received with uncorrectable\n                 errors on this channel during this interval.')
adslAturChanIntervalValidData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 13, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanIntervalValidData.setDescription('This variable indicates if the data for this\n                 interval is valid.')
adslLineConfProfileTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14), )
if mibBuilder.loadTexts: adslLineConfProfileTable.setDescription('This table contains information on the ADSL line\n                 configuration.  One entry in this table reflects a\n                 profile defined by a manager which can be used to\n                 configure the ADSL line.')
adslLineConfProfileEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1), ).setIndexNames((1, "ADSL-LINE-MIB", "adslLineConfProfileName"))
if mibBuilder.loadTexts: adslLineConfProfileEntry.setDescription("Each entry consists of a list of parameters that\n                 represents the configuration of an ADSL modem.\n\n                 When `dynamic' profiles are implemented, a default\n                 profile will always exist.  This profile's name will\n                 be set to `DEFVAL' and its parameters will be set\n                 to vendor specific values, unless otherwise specified\n                 in this document.\n\n                 When `static' profiles are implemented, profiles\n                 are automaticly created or destroyed as ADSL\n                 physical lines are discovered and removed by\n                 the system.  The name of the profile will be\n                 equivalent to the decimal value of the line's\n                 interface index.\n                 ")
adslLineConfProfileName = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 1), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(1,32)))
if mibBuilder.loadTexts: adslLineConfProfileName.setDescription("This object is used by the line configuration table\n                 in order to identify a row of this table.\n\n                 When `dynamic' profiles are implemented, the profile\n                 name is user specified.  Also, the system will always\n                 provide a default profile whose name is `DEFVAL'.\n\n                 When `static' profiles are implemented, there is an\n                 one-to-one relationship between each line and its\n                 profile.  In which case, the profile name will\n                 need to algorithmicly represent the Line's ifIndex.\n                 Therefore, the profile's name is a decimalized string\n                 of the ifIndex that is fixed-length (i.e., 10) with\n                 leading zero(s).  For example, the profile name for\n                 ifIndex which equals '15' will be '0000000015'.")
adslAtucConfRateMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("fixed", 1), ("adaptAtStartup", 2), ("adaptAtRuntime", 3),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucConfRateMode.setDescription('Defines what form of transmit rate adaptation is\n                 configured on this modem.  See ADSL Forum TR-005 [3]\n                 for more information.')
adslAtucConfRateChanRatio = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,100))).setUnits('%').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucConfRateChanRatio.setDescription('Configured allocation ratio of excess transmit\n                 bandwidth between fast and interleaved channels.  Only\n                 applies when two channel mode and RADSL are supported.\n                 Distribute bandwidth on each channel in excess of the\n                 corresponding ChanConfMinTxRate so that:\n                 adslAtucConfRateChanRatio =\n\n                         [Fast / (Fast + Interleaved)] * 100\n\n                 In other words this value is the fast channel\n                 percentage.')
adslAtucConfTargetSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,310))).setUnits('tenth dB').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucConfTargetSnrMgn.setDescription('Configured Target Signal/Noise Margin.\n                 This is the Noise Margin the modem must achieve\n                 with a BER of 10-7 or better to successfully complete\n                 initialization.')
adslAtucConfMaxSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,310))).setUnits('tenth dB').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucConfMaxSnrMgn.setDescription('Configured Maximum acceptable Signal/Noise Margin.\n                 If the Noise Margin is above this the modem should\n                 attempt to reduce its power output to optimize its\n                 operation.')
adslAtucConfMinSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,310))).setUnits('tenth dB').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucConfMinSnrMgn.setDescription('Configured Minimum acceptable Signal/Noise Margin.\n                 If the noise margin falls below this level, the modem\n                 should attempt to increase its power output.  If that\n                 is not possible the modem will attempt to\n                 re-initialize or shut down.')
adslAtucConfDownshiftSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,310))).setUnits('tenth dB').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucConfDownshiftSnrMgn.setDescription("Configured Signal/Noise Margin for rate downshift.\n                 If the noise margin falls below this level, the modem\n                 should attempt to decrease its transmit rate.  In\n                 the case that RADSL mode is not present,\n                 the value will be `0'.")
adslAtucConfUpshiftSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,310))).setUnits('tenth dB').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucConfUpshiftSnrMgn.setDescription("Configured Signal/Noise Margin for rate upshift.\n                 If the noise margin rises above this level, the modem\n                 should attempt to increase its transmit rate.    In\n                 the case that RADSL is not present, the value will\n                 be `0'.")
adslAtucConfMinUpshiftTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,16383))).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucConfMinUpshiftTime.setDescription("Minimum time that the current margin is above\n                 UpshiftSnrMgn before an upshift occurs.\n                 In the case that RADSL is not present, the value will\n                 be `0'.")
adslAtucConfMinDownshiftTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,16383))).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucConfMinDownshiftTime.setDescription("Minimum time that the current margin is below\n                 DownshiftSnrMgn before a downshift occurs.\n                 In the case that RADSL mode is not present,\n                 the value will be `0'.")
adslAtucChanConfFastMinTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 11), Unsigned32()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucChanConfFastMinTxRate.setDescription("Configured Minimum Transmit rate for `Fast' channels,\n                 in bps.  See adslAtucConfRateChanRatio for information\n                 regarding RADSL mode and ATUR transmit rate for\n                 ATUC receive rates.")
adslAtucChanConfInterleaveMinTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 12), Unsigned32()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucChanConfInterleaveMinTxRate.setDescription("Configured Minimum Transmit rate for `Interleave'\n                 channels, in bps.  See adslAtucConfRateChanRatio for\n                 information regarding RADSL mode and see\n                 ATUR transmit rate for receive rates.")
adslAtucChanConfFastMaxTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 13), Unsigned32()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucChanConfFastMaxTxRate.setDescription("Configured Maximum Transmit rate for `Fast' channels,\n                 in bps.  See adslAtucConfRateChanRatio for information\n                 regarding RADSL mode and see ATUR transmit rate for\n                 ATUC receive rates.")
adslAtucChanConfInterleaveMaxTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 14), Unsigned32()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucChanConfInterleaveMaxTxRate.setDescription("Configured Maximum Transmit rate for `Interleave'\n                 channels, in bps.  See adslAtucConfRateChanRatio for\n                 information regarding RADSL mode and ATUR transmit\n                 rate for ATUC receive rates.")
adslAtucChanConfMaxInterleaveDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setUnits('milli-seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucChanConfMaxInterleaveDelay.setDescription('Configured maximum Interleave Delay for this channel.\n\n                 Interleave delay applies only to the interleave channel\n                 and defines the mapping (relative spacing) between\n                 subsequent input bytes at the interleaver input and\n                 their placement in the bit stream at the interleaver\n                 output.  Larger numbers provide greater separation\n                 between consecutive input bytes in the output bit\n                 stream allowing for improved impulse noise immunity\n                 at the expense of payload latency.')
adslAturConfRateMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 16), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("fixed", 1), ("adaptAtStartup", 2), ("adaptAtRuntime", 3),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturConfRateMode.setDescription('Defines what form of transmit rate adaptation is\n                 configured on this modem.  See ADSL Forum TR-005 [3]\n                 for more information.')
adslAturConfRateChanRatio = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 17), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,100))).setUnits('%').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturConfRateChanRatio.setDescription('Configured allocation ratio of excess transmit\n                 bandwidth between fast and interleaved channels.  Only\n                 applies when two channel mode and RADSL are supported.\n                 Distribute bandwidth on each channel in excess of the\n                 corresponding ChanConfMinTxRate so that:\n                 adslAturConfRateChanRatio =\n\n                         [Fast / (Fast + Interleaved)] * 100\n\n                 In other words this value is the fast channel\n                 percentage.')
adslAturConfTargetSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 18), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,310))).setUnits('tenth dB').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturConfTargetSnrMgn.setDescription('Configured Target Signal/Noise Margin.\n                 This is the Noise Margin the modem must achieve\n                 with a BER of 10-7 or better to successfully complete\n                 initialization.')
adslAturConfMaxSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 19), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,310))).setUnits('tenth dB').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturConfMaxSnrMgn.setDescription('Configured Maximum acceptable Signal/Noise Margin.\n                 If the Noise Margin is above this the modem should\n                 attempt to reduce its power output to optimize its\n                 operation.')
adslAturConfMinSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 20), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,310))).setUnits('tenth dB').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturConfMinSnrMgn.setDescription('Configured Minimum acceptable Signal/Noise Margin.\n                 If the noise margin falls below this level, the modem\n                 should attempt to increase its power output.  If that\n                 is not possible the modem will attempt to\n                 re-initialize or shut down.')
adslAturConfDownshiftSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 21), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,310))).setUnits('tenth dB').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturConfDownshiftSnrMgn.setDescription("Configured Signal/Noise Margin for rate downshift.\n                 If the noise margin falls below this level, the modem\n                 should attempt to decrease its transmit rate.\n                 In the case that RADSL mode is not present,\n                 the value will be `0'.")
adslAturConfUpshiftSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 22), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,310))).setUnits('tenth dB').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturConfUpshiftSnrMgn.setDescription("Configured Signal/Noise Margin for rate upshift.\n                 If the noise margin rises above this level, the modem\n                 should attempt to increase its transmit rate.\n                 In the case that RADSL is not present,\n                 the value will be `0'.")
adslAturConfMinUpshiftTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 23), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,16383))).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturConfMinUpshiftTime.setDescription("Minimum time that the current margin is above\n                 UpshiftSnrMgn before an upshift occurs.\n                 In the case that RADSL is not present, the value will\n                 be `0'.")
adslAturConfMinDownshiftTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 24), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,16383))).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturConfMinDownshiftTime.setDescription("Minimum time that the current margin is below\n                 DownshiftSnrMgn before a downshift occurs.\n                 In the case that RADSL mode is not present,\n                 the value will be `0'.")
adslAturChanConfFastMinTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 25), Unsigned32()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturChanConfFastMinTxRate.setDescription("Configured Minimum Transmit rate for `Fast' channels,\n                 in bps.  See adslAturConfRateChanRatio for information\n                 regarding RADSL mode and ATUC transmit rate\n                 for ATUR receive rates.")
adslAturChanConfInterleaveMinTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 26), Unsigned32()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturChanConfInterleaveMinTxRate.setDescription("Configured Minimum Transmit rate for `Interleave'\n                 channels, in bps.  See adslAturConfRateChanRatio for\n                 information regarding RADSL mode and ATUC transmit rate\n                 for ATUR receive rates.")
adslAturChanConfFastMaxTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 27), Unsigned32()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturChanConfFastMaxTxRate.setDescription("Configured Maximum Transmit rate for `Fast' channels,\n                 in bps.  See adslAturConfRateChanRatio for information\n                 regarding RADSL mode and ATUC transmit rate\n                 for ATUR receive rates.")
adslAturChanConfInterleaveMaxTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 28), Unsigned32()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturChanConfInterleaveMaxTxRate.setDescription("Configured Maximum Transmit rate for `Interleave'\n                 channels, in bps.  See adslAturConfRateChanRatio for\n                 information regarding RADSL mode and see\n                 ATUC transmit rate for ATUR receive rates.")
adslAturChanConfMaxInterleaveDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 29), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setUnits('milli-seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturChanConfMaxInterleaveDelay.setDescription('Configured maximum Interleave Delay for this channel.\n\n                 Interleave delay applies only to the interleave channel\n                 and defines the mapping (relative spacing) between\n                 subsequent input bytes at the interleaver input and\n                 their placement in the bit stream at the interleaver\n                 output.  Larger numbers provide greater separation\n                 between consecutive input bytes in the output bit\n                 stream allowing for improved impulse noise immunity\n                 at the expense of payload latency.')
adslLineConfProfileRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 30), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslLineConfProfileRowStatus.setDescription("This object is used to create a new row or modify or\n                 delete an existing row in this table.\n                 A profile activated by setting this object to\n                 `active'.  When `active' is set, the system\n                 will validate the profile.\n\n                 Before a profile can be deleted or taken out of\n                 service, (by setting this object to `destroy' or\n                 `outOfService') it must be first unreferenced\n                 from all associated lines.\n\n                 If the implementator of this MIB has chosen not\n                 to implement `dynamic assignment' of profiles, this\n                 object's MIN-ACCESS is read-only and its value\n                 is always to be `active'.")
adslLineAlarmConfProfileTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15), )
if mibBuilder.loadTexts: adslLineAlarmConfProfileTable.setDescription('This table contains information on the ADSL line\n                 configuration.  One entry in this table reflects a\n                 profile defined by a manager which can be used to\n                 configure the modem for a physical line')
adslLineAlarmConfProfileEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1), ).setIndexNames((1, "ADSL-LINE-MIB", "adslLineAlarmConfProfileName"))
if mibBuilder.loadTexts: adslLineAlarmConfProfileEntry.setDescription("Each entry consists of a list of parameters that\n                 represents the configuration of an ADSL modem.\n\n                 When `dynamic' profiles are implemented, a default\n                 profile will always exist.  This profile's name will\n                 be set to `DEFVAL' and its parameters will be set to\n                 vendor specific values, unless otherwise specified\n                 in this document.\n\n                 When `static' profiles are implemented, profiles\n                 are automaticly created or destroyed as ADSL\n                 physical lines are discovered and removed by\n                 the system.  The name of the profile will be\n                 equivalent to the decimal value of the line's\n                 interface index.\n                 ")
adslLineAlarmConfProfileName = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 1), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(1,32)))
if mibBuilder.loadTexts: adslLineAlarmConfProfileName.setDescription("This object is used by the line alarm configuration\n                 table in order to identify a row of this table.\n\n                 When `dynamic' profiles are implemented, the profile\n                 name is user specified.  Also, the system will always\n                 provide a default profile whose name is `DEFVAL'.\n\n                 When `static' profiles are implemented, there is an\n                 one-to-one relationship between each line and its\n                 profile.  In which case, the profile name will\n                 need to algorithmicly represent the Line's ifIndex.\n                 Therefore, the profile's name is a decimalized string\n                 of the ifIndex that is fixed-length (i.e., 10) with\n                 leading zero(s).  For example, the profile name for\n                 ifIndex which equals '15' will be '0000000015'.")
adslAtucThresh15MinLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,900))).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucThresh15MinLofs.setDescription("The number of Loss of Frame Seconds\n                 encountered by an ADSL interface within any given 15\n                 minutes performance data collection period, which\n                 causes the SNMP agent to send an\n                 adslAtucPerfLofsThreshTrap.\n                 One trap will be sent per interval per interface.\n                 A value of `0' will disable the trap.")
adslAtucThresh15MinLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,900))).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucThresh15MinLoss.setDescription("The number of Loss of Signal Seconds\n                 encountered by an ADSL interface within any given 15\n                 minutes performance data collection period, which\n                 causes the SNMP agent to send an\n                 adslAtucPerfLossThreshTrap.\n                 One trap will be sent per interval per interface.\n                 A value of `0' will disable the trap.")
adslAtucThresh15MinLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,900))).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucThresh15MinLols.setDescription("The number of Loss of Link Seconds\n                 encountered by an ADSL interface within any given 15\n                 minutes performance data collection period, which\n                 causes the SNMP agent to send an\n                 adslAtucPerfLolsThreshTrap.\n                 One trap will be sent per interval per interface.\n                 A value of `0' will disable the trap.")
adslAtucThresh15MinLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,900))).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucThresh15MinLprs.setDescription("The number of Loss of Power Seconds\n                 encountered by an ADSL interface within any given 15\n                 minutes performance data collection period, which\n                 causes the SNMP agent to send an\n                 adslAtucPerfLprsThreshTrap.\n                 One trap will be sent per interval per interface.\n                 A value of `0' will disable the trap.")
adslAtucThresh15MinESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,900))).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucThresh15MinESs.setDescription("The number of Errored Seconds\n                 encountered by an ADSL interface within any given 15\n                 minutes performance data collection period, which\n                 causes the SNMP agent to send an\n                 adslAtucPerfESsThreshTrap.\n                 One trap will be sent per interval per interface.\n                 A value of `0' will disable the trap.")
adslAtucThreshFastRateUp = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 7), Unsigned32()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucThreshFastRateUp.setDescription("Applies to `Fast' channels only.\n                 Configured change in rate causing an\n                 adslAtucRateChangeTrap. A trap is produced when:\n                 ChanCurrTxRate >= ChanPrevTxRate plus the value of\n                 this object. A value of `0' will disable the trap.")
adslAtucThreshInterleaveRateUp = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 8), Unsigned32()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucThreshInterleaveRateUp.setDescription("Applies to `Interleave' channels only.\n                 Configured change in rate causing an\n                 adslAtucRateChangeTrap.  A trap is produced when:\n                 ChanCurrTxRate >= ChanPrevTxRate plus the value of\n                 this object. A value of `0' will disable the trap.")
adslAtucThreshFastRateDown = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 9), Unsigned32()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucThreshFastRateDown.setDescription("Applies to `Fast' channels only.\n                 Configured change in rate causing an\n                 adslAtucRateChangeTrap.  A trap is produced when:\n                 ChanCurrTxRate <= ChanPrevTxRate minus the value of\n                 this object. A value of `0' will disable the trap.")
adslAtucThreshInterleaveRateDown = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 10), Unsigned32()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucThreshInterleaveRateDown.setDescription("Applies to `Interleave' channels only.\n                 Configured change in rate causing an\n                 adslAtucRateChangeTrap.  A trap is produced when:\n                 ChanCurrTxRate <= ChanPrevTxRate minus the value of\n                 this object. A value of `0' will disable the trap.")
adslAtucInitFailureTrapEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 11), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("enable", 1), ("disable", 2),)).clone('disable')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucInitFailureTrapEnable.setDescription('Enables and disables the InitFailureTrap.  This\n                 object is defaulted disable(2).')
adslAturThresh15MinLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 12), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,900))).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturThresh15MinLofs.setDescription("The number of Loss of Frame Seconds\n                 encountered by an ADSL interface within any given 15\n                 minutes performance data collection period, which\n                 causes the SNMP agent to send an\n                 adslAturPerfLofsThreshTrap.\n                 One trap will be sent per interval per interface.\n                 A value of `0' will disable the trap.")
adslAturThresh15MinLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 13), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,900))).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturThresh15MinLoss.setDescription("The number of Loss of Signal Seconds\n                 encountered by an ADSL interface within any given 15\n                 minutes performance data collection period, which\n                 causes the SNMP agent to send an\n                 adslAturPerfLossThreshTrap.\n                 One trap will be sent per interval per interface.\n                 A value of `0' will disable the trap.")
adslAturThresh15MinLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 14), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,900))).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturThresh15MinLprs.setDescription("The number of Loss of Power Seconds\n                 encountered by an ADSL interface within any given 15\n                 minutes performance data collection period, which\n                 causes the SNMP agent to send an\n                 adslAturPerfLprsThreshTrap.\n                 One trap will be sent per interval per interface.\n                 A value of `0' will disable the trap.")
adslAturThresh15MinESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,900))).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturThresh15MinESs.setDescription("The number of Errored Seconds\n                 encountered by an ADSL interface within any given 15\n                 minutes performance data collection period, which\n                 causes the SNMP agent to send an\n                 adslAturPerfESsThreshTrap.\n                 One trap will be sent per interval per interface.\n                 A value of `0' will disable the trap.")
adslAturThreshFastRateUp = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 16), Unsigned32()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturThreshFastRateUp.setDescription("Applies to `Fast' channels only.\n                 Configured change in rate causing an\n                 adslAturRateChangeTrap.  A trap is produced when:\n                 ChanCurrTxRate >= ChanPrevTxRate plus the value of\n                 this object. A value of `0' will disable the trap.")
adslAturThreshInterleaveRateUp = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 17), Unsigned32()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturThreshInterleaveRateUp.setDescription("Applies to `Interleave' channels only.\n                 configured change in rate causing an\n                 adslAturRateChangeTrap.  A trap is produced when:\n                 ChanCurrTxRate >= ChanPrevTxRate plus the value of\n                 this object. A value of `0' will disable the trap.")
adslAturThreshFastRateDown = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 18), Unsigned32()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturThreshFastRateDown.setDescription("Applies to `Fast' channels only.\n                 Configured change in rate causing an\n                 adslAturRateChangeTrap.  A trap is produced when:\n                 ChanCurrTxRate <= ChanPrevTxRate minus the value of\n                 this object. A value of `0' will disable the trap.")
adslAturThreshInterleaveRateDown = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 19), Unsigned32()).setUnits('bps').setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturThreshInterleaveRateDown.setDescription("Applies to `Interleave' channels only.\n                 Configured change in rate causing an\n                 adslAturRateChangeTrap.  A trap is produced when:\n                 ChanCurrTxRate <= ChanPrevTxRate minus the value of\n                 this object. A value of `0' will disable the trap.")
adslLineAlarmConfProfileRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 20), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslLineAlarmConfProfileRowStatus.setDescription("This object is used to create a new row or modify or\n                 delete an existing row in this table.\n\n                 A profile activated by setting this object to\n                 `active'.  When `active' is set, the system\n                 will validate the profile.\n\n                 Before a profile can be deleted or taken out of\n                 service, (by setting this object to `destroy' or\n                 `outOfService') it must be first unreferenced\n                 from all associated lines.\n\n                 If the implementator of this MIB has chosen not\n                 to implement `dynamic assignment' of profiles, this\n                 object's MIN-ACCESS is read-only and its value\n                 is always to be `active'.")
adslLCSMib = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 16))
adslTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 94, 1, 2))
adslAtucTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 1))
adslAtucPerfLofsThreshTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 1, 0, 1)).setObjects(*(("ADSL-LINE-MIB", "adslAtucPerfCurr15MinLofs"), ("ADSL-LINE-MIB", "adslAtucThresh15MinLofs"),))
if mibBuilder.loadTexts: adslAtucPerfLofsThreshTrap.setDescription('Loss of Framing 15-minute interval threshold reached.')
adslAtucPerfLossThreshTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 1, 0, 2)).setObjects(*(("ADSL-LINE-MIB", "adslAtucPerfCurr15MinLoss"), ("ADSL-LINE-MIB", "adslAtucThresh15MinLoss"),))
if mibBuilder.loadTexts: adslAtucPerfLossThreshTrap.setDescription('Loss of Signal 15-minute interval threshold reached.')
adslAtucPerfLprsThreshTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 1, 0, 3)).setObjects(*(("ADSL-LINE-MIB", "adslAtucPerfCurr15MinLprs"), ("ADSL-LINE-MIB", "adslAtucThresh15MinLprs"),))
if mibBuilder.loadTexts: adslAtucPerfLprsThreshTrap.setDescription('Loss of Power 15-minute interval threshold reached.')
adslAtucPerfESsThreshTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 1, 0, 4)).setObjects(*(("ADSL-LINE-MIB", "adslAtucPerfCurr15MinESs"), ("ADSL-LINE-MIB", "adslAtucThresh15MinESs"),))
if mibBuilder.loadTexts: adslAtucPerfESsThreshTrap.setDescription('Errored Second 15-minute interval threshold reached.')
adslAtucRateChangeTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 1, 0, 5)).setObjects(*(("ADSL-LINE-MIB", "adslAtucChanCurrTxRate"), ("ADSL-LINE-MIB", "adslAtucChanPrevTxRate"),))
if mibBuilder.loadTexts: adslAtucRateChangeTrap.setDescription('The ATUCs transmit rate has changed (RADSL mode only)')
adslAtucPerfLolsThreshTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 1, 0, 6)).setObjects(*(("ADSL-LINE-MIB", "adslAtucPerfCurr15MinLols"), ("ADSL-LINE-MIB", "adslAtucThresh15MinLols"),))
if mibBuilder.loadTexts: adslAtucPerfLolsThreshTrap.setDescription('Loss of Link 15-minute interval threshold reached.')
adslAtucInitFailureTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 1, 0, 7)).setObjects(*(("ADSL-LINE-MIB", "adslAtucCurrStatus"),))
if mibBuilder.loadTexts: adslAtucInitFailureTrap.setDescription('ATUC initialization failed. See adslAtucCurrStatus\n                 for potential reasons.')
adslAturTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 2))
adslAturPerfLofsThreshTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 2, 0, 1)).setObjects(*(("ADSL-LINE-MIB", "adslAturPerfCurr15MinLofs"), ("ADSL-LINE-MIB", "adslAturThresh15MinLofs"),))
if mibBuilder.loadTexts: adslAturPerfLofsThreshTrap.setDescription('Loss of Framing 15-minute interval threshold reached.')
adslAturPerfLossThreshTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 2, 0, 2)).setObjects(*(("ADSL-LINE-MIB", "adslAturPerfCurr15MinLoss"), ("ADSL-LINE-MIB", "adslAturThresh15MinLoss"),))
if mibBuilder.loadTexts: adslAturPerfLossThreshTrap.setDescription('Loss of Signal 15-minute interval threshold reached.')
adslAturPerfLprsThreshTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 2, 0, 3)).setObjects(*(("ADSL-LINE-MIB", "adslAturPerfCurr15MinLprs"), ("ADSL-LINE-MIB", "adslAturThresh15MinLprs"),))
if mibBuilder.loadTexts: adslAturPerfLprsThreshTrap.setDescription('Loss of Power 15-minute interval threshold reached.')
adslAturPerfESsThreshTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 2, 0, 4)).setObjects(*(("ADSL-LINE-MIB", "adslAturPerfCurr15MinESs"), ("ADSL-LINE-MIB", "adslAturThresh15MinESs"),))
if mibBuilder.loadTexts: adslAturPerfESsThreshTrap.setDescription('Errored Second 15-minute interval threshold reached.')
adslAturRateChangeTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 2, 0, 5)).setObjects(*(("ADSL-LINE-MIB", "adslAturChanCurrTxRate"), ("ADSL-LINE-MIB", "adslAturChanPrevTxRate"),))
if mibBuilder.loadTexts: adslAturRateChangeTrap.setDescription('The ATURs transmit rate has changed (RADSL mode only)')
adslConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 94, 1, 3))
adslGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1))
adslCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 2))
adslLineMibAtucCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 2, 1)).setObjects(*(("ADSL-LINE-MIB", "adslLineGroup"), ("ADSL-LINE-MIB", "adslPhysicalGroup"), ("ADSL-LINE-MIB", "adslChannelGroup"), ("ADSL-LINE-MIB", "adslAtucPhysPerfIntervalGroup"), ("ADSL-LINE-MIB", "adslAturPhysPerfIntervalGroup"), ("ADSL-LINE-MIB", "adslLineConfProfileGroup"), ("ADSL-LINE-MIB", "adslLineAlarmConfProfileGroup"), ("ADSL-LINE-MIB", "adslLineConfProfileControlGroup"), ("ADSL-LINE-MIB", "adslAtucPhysPerfRawCounterGroup"), ("ADSL-LINE-MIB", "adslAturPhysPerfRawCounterGroup"), ("ADSL-LINE-MIB", "adslAtucChanPerformanceGroup"), ("ADSL-LINE-MIB", "adslAturChanPerformanceGroup"),))
if mibBuilder.loadTexts: adslLineMibAtucCompliance.setDescription('The compliance statement for SNMP entities\n                  which manage ADSL ATU-C interfaces.')
adslLineMibAturCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 2, 2)).setObjects(*(("ADSL-LINE-MIB", "adslAturLineGroup"), ("ADSL-LINE-MIB", "adslAturPhysicalGroup"), ("ADSL-LINE-MIB", "adslAturChannelGroup"), ("ADSL-LINE-MIB", "adslAturAtucPhysPerfIntervalGroup"), ("ADSL-LINE-MIB", "adslAturAturPhysPerfIntervalGroup"), ("ADSL-LINE-MIB", "adslAturLineAlarmConfProfileGroup"), ("ADSL-LINE-MIB", "adslAturLineConfProfileControlGroup"), ("ADSL-LINE-MIB", "adslAturAtucPhysPerfRawCounterGroup"), ("ADSL-LINE-MIB", "adslAturAturPhysPerfRawCounterGroup"), ("ADSL-LINE-MIB", "adslAturAtucChanPerformanceGroup"), ("ADSL-LINE-MIB", "adslAturAturChanPerformanceGroup"),))
if mibBuilder.loadTexts: adslLineMibAturCompliance.setDescription('The compliance statement for SNMP entities\n                  which manage ADSL ATU-R interfaces.')
adslLineGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 1)).setObjects(*(("ADSL-LINE-MIB", "adslLineCoding"), ("ADSL-LINE-MIB", "adslLineType"), ("ADSL-LINE-MIB", "adslLineSpecific"),))
if mibBuilder.loadTexts: adslLineGroup.setDescription('A collection of objects providing configuration\n                 information about an ADSL Line.')
adslPhysicalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 2)).setObjects(*(("ADSL-LINE-MIB", "adslAtucInvSerialNumber"), ("ADSL-LINE-MIB", "adslAtucInvVendorID"), ("ADSL-LINE-MIB", "adslAtucInvVersionNumber"), ("ADSL-LINE-MIB", "adslAtucCurrSnrMgn"), ("ADSL-LINE-MIB", "adslAtucCurrAtn"), ("ADSL-LINE-MIB", "adslAtucCurrStatus"), ("ADSL-LINE-MIB", "adslAtucCurrOutputPwr"), ("ADSL-LINE-MIB", "adslAtucCurrAttainableRate"), ("ADSL-LINE-MIB", "adslAturInvSerialNumber"), ("ADSL-LINE-MIB", "adslAturInvVendorID"), ("ADSL-LINE-MIB", "adslAturInvVersionNumber"), ("ADSL-LINE-MIB", "adslAturCurrSnrMgn"), ("ADSL-LINE-MIB", "adslAturCurrAtn"), ("ADSL-LINE-MIB", "adslAturCurrStatus"), ("ADSL-LINE-MIB", "adslAturCurrOutputPwr"), ("ADSL-LINE-MIB", "adslAturCurrAttainableRate"),))
if mibBuilder.loadTexts: adslPhysicalGroup.setDescription('A collection of objects providing physical\n                 configuration information of the ADSL Line.')
adslChannelGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 3)).setObjects(*(("ADSL-LINE-MIB", "adslAtucChanInterleaveDelay"), ("ADSL-LINE-MIB", "adslAtucChanCurrTxRate"), ("ADSL-LINE-MIB", "adslAtucChanPrevTxRate"), ("ADSL-LINE-MIB", "adslAtucChanCrcBlockLength"), ("ADSL-LINE-MIB", "adslAturChanInterleaveDelay"), ("ADSL-LINE-MIB", "adslAturChanCurrTxRate"), ("ADSL-LINE-MIB", "adslAturChanPrevTxRate"), ("ADSL-LINE-MIB", "adslAturChanCrcBlockLength"),))
if mibBuilder.loadTexts: adslChannelGroup.setDescription('A collection of objects providing configuration\n                 information about an ADSL channel.')
adslAtucPhysPerfRawCounterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 4)).setObjects(*(("ADSL-LINE-MIB", "adslAtucPerfLofs"), ("ADSL-LINE-MIB", "adslAtucPerfLoss"), ("ADSL-LINE-MIB", "adslAtucPerfLols"), ("ADSL-LINE-MIB", "adslAtucPerfLprs"), ("ADSL-LINE-MIB", "adslAtucPerfESs"), ("ADSL-LINE-MIB", "adslAtucPerfInits"),))
if mibBuilder.loadTexts: adslAtucPhysPerfRawCounterGroup.setDescription('A collection of objects providing raw performance\n                 counts on an ADSL Line (ATU-C end).')
adslAtucPhysPerfIntervalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 5)).setObjects(*(("ADSL-LINE-MIB", "adslAtucPerfValidIntervals"), ("ADSL-LINE-MIB", "adslAtucPerfInvalidIntervals"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinTimeElapsed"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinLofs"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinLoss"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinLols"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinLprs"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinESs"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinInits"), ("ADSL-LINE-MIB", "adslAtucPerfCurr1DayLofs"), ("ADSL-LINE-MIB", "adslAtucPerfCurr1DayLoss"), ("ADSL-LINE-MIB", "adslAtucPerfCurr1DayLols"), ("ADSL-LINE-MIB", "adslAtucPerfCurr1DayLprs"), ("ADSL-LINE-MIB", "adslAtucPerfCurr1DayESs"), ("ADSL-LINE-MIB", "adslAtucPerfCurr1DayInits"), ("ADSL-LINE-MIB", "adslAtucPerfPrev1DayMoniSecs"), ("ADSL-LINE-MIB", "adslAtucPerfPrev1DayLofs"), ("ADSL-LINE-MIB", "adslAtucPerfPrev1DayLoss"), ("ADSL-LINE-MIB", "adslAtucPerfPrev1DayLols"), ("ADSL-LINE-MIB", "adslAtucPerfPrev1DayLprs"), ("ADSL-LINE-MIB", "adslAtucPerfPrev1DayESs"), ("ADSL-LINE-MIB", "adslAtucPerfPrev1DayInits"), ("ADSL-LINE-MIB", "adslAtucIntervalLofs"), ("ADSL-LINE-MIB", "adslAtucIntervalLoss"), ("ADSL-LINE-MIB", "adslAtucIntervalLols"), ("ADSL-LINE-MIB", "adslAtucIntervalLprs"), ("ADSL-LINE-MIB", "adslAtucIntervalESs"), ("ADSL-LINE-MIB", "adslAtucIntervalInits"), ("ADSL-LINE-MIB", "adslAtucIntervalValidData"),))
if mibBuilder.loadTexts: adslAtucPhysPerfIntervalGroup.setDescription('A collection of objects providing current 15-minute,\n                 1-day; and previous 1-day performance counts on\n                 ADSL Line (ATU-C end) .')
adslAturPhysPerfRawCounterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 6)).setObjects(*(("ADSL-LINE-MIB", "adslAturPerfLofs"), ("ADSL-LINE-MIB", "adslAturPerfLoss"), ("ADSL-LINE-MIB", "adslAturPerfLprs"), ("ADSL-LINE-MIB", "adslAturPerfESs"),))
if mibBuilder.loadTexts: adslAturPhysPerfRawCounterGroup.setDescription('A collection of objects providing raw performance\n                 counts on an ADSL Line (ATU-R end).')
adslAturPhysPerfIntervalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 7)).setObjects(*(("ADSL-LINE-MIB", "adslAturPerfValidIntervals"), ("ADSL-LINE-MIB", "adslAturPerfInvalidIntervals"), ("ADSL-LINE-MIB", "adslAturPerfCurr15MinTimeElapsed"), ("ADSL-LINE-MIB", "adslAturPerfCurr15MinLofs"), ("ADSL-LINE-MIB", "adslAturPerfCurr15MinLoss"), ("ADSL-LINE-MIB", "adslAturPerfCurr15MinLprs"), ("ADSL-LINE-MIB", "adslAturPerfCurr15MinESs"), ("ADSL-LINE-MIB", "adslAturPerfCurr1DayTimeElapsed"), ("ADSL-LINE-MIB", "adslAturPerfCurr1DayLofs"), ("ADSL-LINE-MIB", "adslAturPerfCurr1DayLoss"), ("ADSL-LINE-MIB", "adslAturPerfCurr1DayLprs"), ("ADSL-LINE-MIB", "adslAturPerfCurr1DayESs"), ("ADSL-LINE-MIB", "adslAturPerfPrev1DayMoniSecs"), ("ADSL-LINE-MIB", "adslAturPerfPrev1DayLofs"), ("ADSL-LINE-MIB", "adslAturPerfPrev1DayLoss"), ("ADSL-LINE-MIB", "adslAturPerfPrev1DayLprs"), ("ADSL-LINE-MIB", "adslAturPerfPrev1DayESs"), ("ADSL-LINE-MIB", "adslAturIntervalLofs"), ("ADSL-LINE-MIB", "adslAturIntervalLoss"), ("ADSL-LINE-MIB", "adslAturIntervalLprs"), ("ADSL-LINE-MIB", "adslAturIntervalESs"), ("ADSL-LINE-MIB", "adslAturIntervalValidData"),))
if mibBuilder.loadTexts: adslAturPhysPerfIntervalGroup.setDescription('A collection of objects providing current 15-minute,\n                 1-day; and previous 1-day performance counts on\n                 ADSL Line (ATU-R end).')
adslAtucChanPerformanceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 8)).setObjects(*(("ADSL-LINE-MIB", "adslAtucChanReceivedBlks"), ("ADSL-LINE-MIB", "adslAtucChanTransmittedBlks"), ("ADSL-LINE-MIB", "adslAtucChanCorrectedBlks"), ("ADSL-LINE-MIB", "adslAtucChanUncorrectBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfValidIntervals"), ("ADSL-LINE-MIB", "adslAtucChanPerfInvalidIntervals"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr15MinTimeElapsed"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr15MinReceivedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr15MinTransmittedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr15MinCorrectedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr15MinUncorrectBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr1DayTimeElapsed"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr1DayReceivedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr1DayTransmittedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr1DayCorrectedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr1DayUncorrectBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfPrev1DayMoniSecs"), ("ADSL-LINE-MIB", "adslAtucChanPerfPrev1DayReceivedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfPrev1DayTransmittedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfPrev1DayCorrectedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfPrev1DayUncorrectBlks"), ("ADSL-LINE-MIB", "adslAtucChanIntervalReceivedBlks"), ("ADSL-LINE-MIB", "adslAtucChanIntervalTransmittedBlks"), ("ADSL-LINE-MIB", "adslAtucChanIntervalCorrectedBlks"), ("ADSL-LINE-MIB", "adslAtucChanIntervalUncorrectBlks"), ("ADSL-LINE-MIB", "adslAtucChanIntervalValidData"),))
if mibBuilder.loadTexts: adslAtucChanPerformanceGroup.setDescription('A collection of objects providing channel block\n                 performance information on an ADSL channel\n                 (ATU-C end).')
adslAturChanPerformanceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 9)).setObjects(*(("ADSL-LINE-MIB", "adslAturChanReceivedBlks"), ("ADSL-LINE-MIB", "adslAturChanTransmittedBlks"), ("ADSL-LINE-MIB", "adslAturChanCorrectedBlks"), ("ADSL-LINE-MIB", "adslAturChanUncorrectBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfValidIntervals"), ("ADSL-LINE-MIB", "adslAturChanPerfInvalidIntervals"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr15MinTimeElapsed"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr15MinReceivedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr15MinTransmittedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr15MinCorrectedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr15MinUncorrectBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr1DayTimeElapsed"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr1DayReceivedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr1DayTransmittedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr1DayCorrectedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr1DayUncorrectBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfPrev1DayMoniSecs"), ("ADSL-LINE-MIB", "adslAturChanPerfPrev1DayReceivedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfPrev1DayTransmittedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfPrev1DayCorrectedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfPrev1DayUncorrectBlks"), ("ADSL-LINE-MIB", "adslAturChanIntervalReceivedBlks"), ("ADSL-LINE-MIB", "adslAturChanIntervalTransmittedBlks"), ("ADSL-LINE-MIB", "adslAturChanIntervalCorrectedBlks"), ("ADSL-LINE-MIB", "adslAturChanIntervalUncorrectBlks"), ("ADSL-LINE-MIB", "adslAturChanIntervalValidData"),))
if mibBuilder.loadTexts: adslAturChanPerformanceGroup.setDescription('A collection of objects providing channel block\n                 performance information on an ADSL channel\n                 (ATU-C end).')
adslLineConfProfileGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 10)).setObjects(*(("ADSL-LINE-MIB", "adslAtucConfRateMode"), ("ADSL-LINE-MIB", "adslAtucConfRateChanRatio"), ("ADSL-LINE-MIB", "adslAtucConfTargetSnrMgn"), ("ADSL-LINE-MIB", "adslAtucConfMaxSnrMgn"), ("ADSL-LINE-MIB", "adslAtucConfMinSnrMgn"), ("ADSL-LINE-MIB", "adslAtucConfDownshiftSnrMgn"), ("ADSL-LINE-MIB", "adslAtucConfUpshiftSnrMgn"), ("ADSL-LINE-MIB", "adslAtucConfMinUpshiftTime"), ("ADSL-LINE-MIB", "adslAtucConfMinDownshiftTime"), ("ADSL-LINE-MIB", "adslAtucChanConfFastMinTxRate"), ("ADSL-LINE-MIB", "adslAtucChanConfInterleaveMinTxRate"), ("ADSL-LINE-MIB", "adslAtucChanConfFastMaxTxRate"), ("ADSL-LINE-MIB", "adslAtucChanConfInterleaveMaxTxRate"), ("ADSL-LINE-MIB", "adslAtucChanConfMaxInterleaveDelay"), ("ADSL-LINE-MIB", "adslAturConfRateMode"), ("ADSL-LINE-MIB", "adslAturConfRateChanRatio"), ("ADSL-LINE-MIB", "adslAturConfTargetSnrMgn"), ("ADSL-LINE-MIB", "adslAturConfMaxSnrMgn"), ("ADSL-LINE-MIB", "adslAturConfMinSnrMgn"), ("ADSL-LINE-MIB", "adslAturConfDownshiftSnrMgn"), ("ADSL-LINE-MIB", "adslAturConfUpshiftSnrMgn"), ("ADSL-LINE-MIB", "adslAturConfMinUpshiftTime"), ("ADSL-LINE-MIB", "adslAturConfMinDownshiftTime"), ("ADSL-LINE-MIB", "adslAturChanConfFastMinTxRate"), ("ADSL-LINE-MIB", "adslAturChanConfInterleaveMinTxRate"), ("ADSL-LINE-MIB", "adslAturChanConfFastMaxTxRate"), ("ADSL-LINE-MIB", "adslAturChanConfInterleaveMaxTxRate"), ("ADSL-LINE-MIB", "adslAturChanConfMaxInterleaveDelay"),))
if mibBuilder.loadTexts: adslLineConfProfileGroup.setDescription('A collection of objects providing provisioning\n                 information about an ADSL Line.')
adslLineAlarmConfProfileGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 11)).setObjects(*(("ADSL-LINE-MIB", "adslAtucThresh15MinLofs"), ("ADSL-LINE-MIB", "adslAtucThresh15MinLoss"), ("ADSL-LINE-MIB", "adslAtucThresh15MinLols"), ("ADSL-LINE-MIB", "adslAtucThresh15MinLprs"), ("ADSL-LINE-MIB", "adslAtucThresh15MinESs"), ("ADSL-LINE-MIB", "adslAtucThreshFastRateUp"), ("ADSL-LINE-MIB", "adslAtucThreshInterleaveRateUp"), ("ADSL-LINE-MIB", "adslAtucThreshFastRateDown"), ("ADSL-LINE-MIB", "adslAtucThreshInterleaveRateDown"), ("ADSL-LINE-MIB", "adslAtucInitFailureTrapEnable"), ("ADSL-LINE-MIB", "adslAturThresh15MinLofs"), ("ADSL-LINE-MIB", "adslAturThresh15MinLoss"), ("ADSL-LINE-MIB", "adslAturThresh15MinLprs"), ("ADSL-LINE-MIB", "adslAturThresh15MinESs"), ("ADSL-LINE-MIB", "adslAturThreshFastRateUp"), ("ADSL-LINE-MIB", "adslAturThreshInterleaveRateUp"), ("ADSL-LINE-MIB", "adslAturThreshFastRateDown"), ("ADSL-LINE-MIB", "adslAturThreshInterleaveRateDown"),))
if mibBuilder.loadTexts: adslLineAlarmConfProfileGroup.setDescription('A collection of objects providing alarm provisioning\n                 information about an ADSL Line.')
adslLineConfProfileControlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 12)).setObjects(*(("ADSL-LINE-MIB", "adslLineConfProfile"), ("ADSL-LINE-MIB", "adslLineAlarmConfProfile"), ("ADSL-LINE-MIB", "adslLineConfProfileRowStatus"), ("ADSL-LINE-MIB", "adslLineAlarmConfProfileRowStatus"),))
if mibBuilder.loadTexts: adslLineConfProfileControlGroup.setDescription('A collection of objects providing profile\n                 control for the ADSL system.')
adslNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 13)).setObjects(*(("ADSL-LINE-MIB", "adslAtucPerfLofsThreshTrap"), ("ADSL-LINE-MIB", "adslAtucPerfLossThreshTrap"), ("ADSL-LINE-MIB", "adslAtucPerfLprsThreshTrap"), ("ADSL-LINE-MIB", "adslAtucPerfESsThreshTrap"), ("ADSL-LINE-MIB", "adslAtucRateChangeTrap"), ("ADSL-LINE-MIB", "adslAtucPerfLolsThreshTrap"), ("ADSL-LINE-MIB", "adslAtucInitFailureTrap"), ("ADSL-LINE-MIB", "adslAturPerfLofsThreshTrap"), ("ADSL-LINE-MIB", "adslAturPerfLossThreshTrap"), ("ADSL-LINE-MIB", "adslAturPerfLprsThreshTrap"), ("ADSL-LINE-MIB", "adslAturPerfESsThreshTrap"), ("ADSL-LINE-MIB", "adslAturRateChangeTrap"),))
if mibBuilder.loadTexts: adslNotificationsGroup.setDescription('The collection of adsl notifications.')
adslAturLineGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 14)).setObjects(*(("ADSL-LINE-MIB", "adslLineCoding"),))
if mibBuilder.loadTexts: adslAturLineGroup.setDescription('A collection of objects providing configuration\n                    information about an ADSL Line on the ATU-R side.')
adslAturPhysicalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 15)).setObjects(*(("ADSL-LINE-MIB", "adslAtucInvVendorID"), ("ADSL-LINE-MIB", "adslAtucInvVersionNumber"), ("ADSL-LINE-MIB", "adslAtucCurrOutputPwr"), ("ADSL-LINE-MIB", "adslAtucCurrAttainableRate"), ("ADSL-LINE-MIB", "adslAturInvSerialNumber"), ("ADSL-LINE-MIB", "adslAturInvVendorID"), ("ADSL-LINE-MIB", "adslAturInvVersionNumber"), ("ADSL-LINE-MIB", "adslAturCurrSnrMgn"), ("ADSL-LINE-MIB", "adslAturCurrAtn"), ("ADSL-LINE-MIB", "adslAturCurrStatus"), ("ADSL-LINE-MIB", "adslAturCurrOutputPwr"), ("ADSL-LINE-MIB", "adslAturCurrAttainableRate"), ("ADSL-LINE-MIB", "adslAtucCurrStatus"),))
if mibBuilder.loadTexts: adslAturPhysicalGroup.setDescription('A collection of objects providing physical\n                    configuration information of the ADSL Line on the\n                    ATU-R side.')
adslAturChannelGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 16)).setObjects(*(("ADSL-LINE-MIB", "adslAtucChanInterleaveDelay"), ("ADSL-LINE-MIB", "adslAtucChanCurrTxRate"), ("ADSL-LINE-MIB", "adslAtucChanPrevTxRate"), ("ADSL-LINE-MIB", "adslAturChanInterleaveDelay"), ("ADSL-LINE-MIB", "adslAturChanCurrTxRate"), ("ADSL-LINE-MIB", "adslAturChanPrevTxRate"), ("ADSL-LINE-MIB", "adslAturChanCrcBlockLength"),))
if mibBuilder.loadTexts: adslAturChannelGroup.setDescription('A collection of objects providing configuration\n                   information about an ADSL channel on the ATU-R\n                   side.')
adslAturAtucPhysPerfRawCounterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 17)).setObjects(*(("ADSL-LINE-MIB", "adslAtucPerfLofs"), ("ADSL-LINE-MIB", "adslAtucPerfLoss"), ("ADSL-LINE-MIB", "adslAtucPerfESs"), ("ADSL-LINE-MIB", "adslAtucPerfInits"),))
if mibBuilder.loadTexts: adslAturAtucPhysPerfRawCounterGroup.setDescription('A collection of objects providing raw performance\n                   counts on an ADSL Line (ATU-C end) provided by the\n                   ATU-R agent.')
adslAturAtucPhysPerfIntervalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 18)).setObjects(*(("ADSL-LINE-MIB", "adslAtucPerfValidIntervals"), ("ADSL-LINE-MIB", "adslAtucPerfInvalidIntervals"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinTimeElapsed"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinLofs"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinLoss"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinESs"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinInits"), ("ADSL-LINE-MIB", "adslAtucPerfCurr1DayTimeElapsed"), ("ADSL-LINE-MIB", "adslAtucPerfCurr1DayLofs"), ("ADSL-LINE-MIB", "adslAtucPerfCurr1DayLoss"), ("ADSL-LINE-MIB", "adslAtucPerfCurr1DayESs"), ("ADSL-LINE-MIB", "adslAtucPerfCurr1DayInits"), ("ADSL-LINE-MIB", "adslAtucPerfPrev1DayMoniSecs"), ("ADSL-LINE-MIB", "adslAtucPerfPrev1DayLofs"), ("ADSL-LINE-MIB", "adslAtucPerfPrev1DayLoss"), ("ADSL-LINE-MIB", "adslAtucPerfPrev1DayESs"), ("ADSL-LINE-MIB", "adslAtucPerfPrev1DayInits"), ("ADSL-LINE-MIB", "adslAtucIntervalLofs"), ("ADSL-LINE-MIB", "adslAtucIntervalLoss"), ("ADSL-LINE-MIB", "adslAtucIntervalESs"), ("ADSL-LINE-MIB", "adslAtucIntervalInits"), ("ADSL-LINE-MIB", "adslAtucIntervalValidData"),))
if mibBuilder.loadTexts: adslAturAtucPhysPerfIntervalGroup.setDescription('A collection of objects providing current\n\n                   15-minute, 1-day; and previous 1-day performance\n                   counts on ADSL Line (ATU-C end) provided by the\n                   ATU-R agent.')
adslAturAturPhysPerfRawCounterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 19)).setObjects(*(("ADSL-LINE-MIB", "adslAturPerfLofs"), ("ADSL-LINE-MIB", "adslAturPerfLoss"), ("ADSL-LINE-MIB", "adslAturPerfLprs"), ("ADSL-LINE-MIB", "adslAturPerfESs"),))
if mibBuilder.loadTexts: adslAturAturPhysPerfRawCounterGroup.setDescription('A collection of objects providing raw performance\n                   counts on an ADSL Line (ATU-R end) provided by the\n                   ATU-R agent.')
adslAturAturPhysPerfIntervalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 20)).setObjects(*(("ADSL-LINE-MIB", "adslAturPerfValidIntervals"), ("ADSL-LINE-MIB", "adslAturPerfInvalidIntervals"), ("ADSL-LINE-MIB", "adslAturPerfCurr15MinTimeElapsed"), ("ADSL-LINE-MIB", "adslAturPerfCurr15MinLofs"), ("ADSL-LINE-MIB", "adslAturPerfCurr15MinLoss"), ("ADSL-LINE-MIB", "adslAturPerfCurr15MinLprs"), ("ADSL-LINE-MIB", "adslAturPerfCurr15MinESs"), ("ADSL-LINE-MIB", "adslAturPerfCurr1DayTimeElapsed"), ("ADSL-LINE-MIB", "adslAturPerfCurr1DayLofs"), ("ADSL-LINE-MIB", "adslAturPerfCurr1DayLoss"), ("ADSL-LINE-MIB", "adslAturPerfCurr1DayLprs"), ("ADSL-LINE-MIB", "adslAturPerfCurr1DayESs"), ("ADSL-LINE-MIB", "adslAturPerfPrev1DayMoniSecs"), ("ADSL-LINE-MIB", "adslAturPerfPrev1DayLofs"), ("ADSL-LINE-MIB", "adslAturPerfPrev1DayLoss"), ("ADSL-LINE-MIB", "adslAturPerfPrev1DayLprs"), ("ADSL-LINE-MIB", "adslAturPerfPrev1DayESs"), ("ADSL-LINE-MIB", "adslAturIntervalLofs"), ("ADSL-LINE-MIB", "adslAturIntervalLoss"), ("ADSL-LINE-MIB", "adslAturIntervalLprs"), ("ADSL-LINE-MIB", "adslAturIntervalESs"), ("ADSL-LINE-MIB", "adslAturIntervalValidData"),))
if mibBuilder.loadTexts: adslAturAturPhysPerfIntervalGroup.setDescription('A collection of objects providing current\n                   15-minute, 1-day; and previous 1-day performance\n                   counts on ADSL Line (ATU-R end) provided by the\n                   ATU-R agent.')
adslAturAtucChanPerformanceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 21)).setObjects(*(("ADSL-LINE-MIB", "adslAtucChanReceivedBlks"), ("ADSL-LINE-MIB", "adslAtucChanTransmittedBlks"), ("ADSL-LINE-MIB", "adslAtucChanCorrectedBlks"), ("ADSL-LINE-MIB", "adslAtucChanUncorrectBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr15MinTimeElapsed"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr15MinReceivedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr15MinTransmittedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr15MinCorrectedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr15MinUncorrectBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr1DayTimeElapsed"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr1DayReceivedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr1DayTransmittedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr1DayCorrectedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr1DayUncorrectBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfPrev1DayMoniSecs"), ("ADSL-LINE-MIB", "adslAtucChanPerfPrev1DayReceivedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfPrev1DayTransmittedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfPrev1DayCorrectedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfPrev1DayUncorrectBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfValidIntervals"), ("ADSL-LINE-MIB", "adslAtucChanPerfInvalidIntervals"), ("ADSL-LINE-MIB", "adslAtucChanIntervalReceivedBlks"), ("ADSL-LINE-MIB", "adslAtucChanIntervalTransmittedBlks"), ("ADSL-LINE-MIB", "adslAtucChanIntervalCorrectedBlks"), ("ADSL-LINE-MIB", "adslAtucChanIntervalUncorrectBlks"), ("ADSL-LINE-MIB", "adslAtucChanIntervalValidData"),))
if mibBuilder.loadTexts: adslAturAtucChanPerformanceGroup.setDescription('A collection of objects providing channel block\n                    performance information on an ADSL channel\n                    (ATU-C end) provided by the ATU-R agent.')
adslAturAturChanPerformanceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 22)).setObjects(*(("ADSL-LINE-MIB", "adslAturChanReceivedBlks"), ("ADSL-LINE-MIB", "adslAturChanTransmittedBlks"), ("ADSL-LINE-MIB", "adslAturChanCorrectedBlks"), ("ADSL-LINE-MIB", "adslAturChanUncorrectBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfValidIntervals"), ("ADSL-LINE-MIB", "adslAturChanPerfInvalidIntervals"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr15MinTimeElapsed"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr15MinReceivedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr15MinTransmittedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr15MinCorrectedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr15MinUncorrectBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr1DayTimeElapsed"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr1DayReceivedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr1DayTransmittedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr1DayCorrectedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr1DayUncorrectBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfPrev1DayMoniSecs"), ("ADSL-LINE-MIB", "adslAturChanPerfPrev1DayReceivedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfPrev1DayTransmittedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfPrev1DayCorrectedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfPrev1DayUncorrectBlks"), ("ADSL-LINE-MIB", "adslAturChanIntervalReceivedBlks"), ("ADSL-LINE-MIB", "adslAturChanIntervalTransmittedBlks"), ("ADSL-LINE-MIB", "adslAturChanIntervalCorrectedBlks"), ("ADSL-LINE-MIB", "adslAturChanIntervalUncorrectBlks"), ("ADSL-LINE-MIB", "adslAturChanIntervalValidData"),))
if mibBuilder.loadTexts: adslAturAturChanPerformanceGroup.setDescription('A collection of objects providing channel block\n                    performance information on an ADSL channel\n                    (ATU-R end) provided by the ATU-R agent.')
adslAturLineAlarmConfProfileGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 23)).setObjects(*(("ADSL-LINE-MIB", "adslAtucThresh15MinLofs"), ("ADSL-LINE-MIB", "adslAtucThresh15MinLoss"), ("ADSL-LINE-MIB", "adslAtucThresh15MinESs"), ("ADSL-LINE-MIB", "adslAtucThreshFastRateUp"), ("ADSL-LINE-MIB", "adslAtucThreshInterleaveRateUp"), ("ADSL-LINE-MIB", "adslAtucThreshFastRateDown"), ("ADSL-LINE-MIB", "adslAtucThreshInterleaveRateDown"), ("ADSL-LINE-MIB", "adslAtucInitFailureTrapEnable"), ("ADSL-LINE-MIB", "adslAturThresh15MinLofs"), ("ADSL-LINE-MIB", "adslAturThresh15MinLoss"), ("ADSL-LINE-MIB", "adslAturThresh15MinLprs"), ("ADSL-LINE-MIB", "adslAturThresh15MinESs"), ("ADSL-LINE-MIB", "adslAturThreshFastRateUp"), ("ADSL-LINE-MIB", "adslAturThreshInterleaveRateUp"), ("ADSL-LINE-MIB", "adslAturThreshFastRateDown"), ("ADSL-LINE-MIB", "adslAturThreshInterleaveRateDown"),))
if mibBuilder.loadTexts: adslAturLineAlarmConfProfileGroup.setDescription('A collection of objects providing alarm\n   provisioning\n                    information about an ADSL Line provided by the\n                    ATU-R agent.')
adslAturLineConfProfileControlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 24)).setObjects(*(("ADSL-LINE-MIB", "adslLineAlarmConfProfile"), ("ADSL-LINE-MIB", "adslLineAlarmConfProfileRowStatus"),))
if mibBuilder.loadTexts: adslAturLineConfProfileControlGroup.setDescription('A collection of objects providing profile\n                    control for the ADSL system by the ATU-R agent.')
adslAturNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 25)).setObjects(*(("ADSL-LINE-MIB", "adslAtucPerfLofsThreshTrap"), ("ADSL-LINE-MIB", "adslAtucPerfLossThreshTrap"), ("ADSL-LINE-MIB", "adslAtucPerfESsThreshTrap"), ("ADSL-LINE-MIB", "adslAtucRateChangeTrap"), ("ADSL-LINE-MIB", "adslAturPerfLofsThreshTrap"), ("ADSL-LINE-MIB", "adslAturPerfLossThreshTrap"), ("ADSL-LINE-MIB", "adslAturPerfLprsThreshTrap"), ("ADSL-LINE-MIB", "adslAturPerfESsThreshTrap"), ("ADSL-LINE-MIB", "adslAturRateChangeTrap"),))
if mibBuilder.loadTexts: adslAturNotificationsGroup.setDescription('The collection of ADSL notifications implemented by\n                    the ATU-R agent.')
mibBuilder.exportSymbols("ADSL-LINE-MIB", adslAtucInvVendorID=adslAtucInvVendorID, adslAtucIntervalLprs=adslAtucIntervalLprs, adslLineConfProfileRowStatus=adslLineConfProfileRowStatus, adslAtucPerfCurr15MinLoss=adslAtucPerfCurr15MinLoss, adslAtucChanConfFastMaxTxRate=adslAtucChanConfFastMaxTxRate, adslAtucThreshFastRateDown=adslAtucThreshFastRateDown, adslAtucPerfLprsThreshTrap=adslAtucPerfLprsThreshTrap, adslAtucInitFailureTrap=adslAtucInitFailureTrap, adslAturChanPerformanceGroup=adslAturChanPerformanceGroup, adslLineCoding=adslLineCoding, adslAturChanIntervalTransmittedBlks=adslAturChanIntervalTransmittedBlks, adslAtucChanEntry=adslAtucChanEntry, adslAturLineGroup=adslAturLineGroup, adslAturChanIntervalNumber=adslAturChanIntervalNumber, adslAturPhysTable=adslAturPhysTable, adslAturPerfESs=adslAturPerfESs, adslAtucInitFailureTrapEnable=adslAtucInitFailureTrapEnable, adslGroups=adslGroups, adslTraps=adslTraps, adslAtucPerfCurr15MinTimeElapsed=adslAtucPerfCurr15MinTimeElapsed, adslAturPerfPrev1DayLoss=adslAturPerfPrev1DayLoss, adslAtucCurrOutputPwr=adslAtucCurrOutputPwr, adslLineConfProfileName=adslLineConfProfileName, adslAturThresh15MinLofs=adslAturThresh15MinLofs, adslAtucRateChangeTrap=adslAtucRateChangeTrap, adslAtucConfMinUpshiftTime=adslAtucConfMinUpshiftTime, adslAtucPerfLossThreshTrap=adslAtucPerfLossThreshTrap, adslAturPhysPerfIntervalGroup=adslAturPhysPerfIntervalGroup, adslLineConfProfileTable=adslLineConfProfileTable, adslAturPerfInvalidIntervals=adslAturPerfInvalidIntervals, adslAturIntervalLofs=adslAturIntervalLofs, adslAtucPerfPrev1DayLoss=adslAtucPerfPrev1DayLoss, adslAturChanPerfCurr1DayTransmittedBlks=adslAturChanPerfCurr1DayTransmittedBlks, adslAturConfDownshiftSnrMgn=adslAturConfDownshiftSnrMgn, adslAtucPerfDataEntry=adslAtucPerfDataEntry, adslAtucConfMaxSnrMgn=adslAtucConfMaxSnrMgn, adslConformance=adslConformance, adslAtucChanTable=adslAtucChanTable, adslAturChanPerfCurr1DayCorrectedBlks=adslAturChanPerfCurr1DayCorrectedBlks, adslAturRateChangeTrap=adslAturRateChangeTrap, adslAturPerfCurr15MinLoss=adslAturPerfCurr15MinLoss, adslAturPerfPrev1DayLofs=adslAturPerfPrev1DayLofs, adslAturPerfCurr15MinESs=adslAturPerfCurr15MinESs, adslAturConfTargetSnrMgn=adslAturConfTargetSnrMgn, adslAtucPerfCurr1DayLols=adslAtucPerfCurr1DayLols, adslLineGroup=adslLineGroup, adslAtucChanPerfPrev1DayUncorrectBlks=adslAtucChanPerfPrev1DayUncorrectBlks, adslAtucPhysPerfRawCounterGroup=adslAtucPhysPerfRawCounterGroup, adslAturPerfCurr1DayLofs=adslAturPerfCurr1DayLofs, adslAtucPhysTable=adslAtucPhysTable, adslAtucThreshInterleaveRateUp=adslAtucThreshInterleaveRateUp, adslAtucConfMinSnrMgn=adslAtucConfMinSnrMgn, adslAturChanPerfCurr1DayUncorrectBlks=adslAturChanPerfCurr1DayUncorrectBlks, adslAturChanPerfPrev1DayCorrectedBlks=adslAturChanPerfPrev1DayCorrectedBlks, adslAturConfMinUpshiftTime=adslAturConfMinUpshiftTime, adslAturLineConfProfileControlGroup=adslAturLineConfProfileControlGroup, adslAtucPerfCurr1DayESs=adslAtucPerfCurr1DayESs, adslAtucChanPerfCurr1DayTimeElapsed=adslAtucChanPerfCurr1DayTimeElapsed, PYSNMP_MODULE_ID=adslMIB, adslAturChanConfFastMinTxRate=adslAturChanConfFastMinTxRate, adslAturPerfPrev1DayMoniSecs=adslAturPerfPrev1DayMoniSecs, adslAturCurrOutputPwr=adslAturCurrOutputPwr, adslAtucChanPerfCurr15MinUncorrectBlks=adslAtucChanPerfCurr15MinUncorrectBlks, adslAtucChanPerfPrev1DayMoniSecs=adslAtucChanPerfPrev1DayMoniSecs, adslAturAtucPhysPerfIntervalGroup=adslAturAtucPhysPerfIntervalGroup, adslAtucChanConfInterleaveMaxTxRate=adslAtucChanConfInterleaveMaxTxRate, adslAturNotificationsGroup=adslAturNotificationsGroup, adslAturConfRateMode=adslAturConfRateMode, adslAturChanPerfCurr1DayReceivedBlks=adslAturChanPerfCurr1DayReceivedBlks, adslAturPerfPrev1DayLprs=adslAturPerfPrev1DayLprs, adslChannelGroup=adslChannelGroup, adslAtucPerfPrev1DayESs=adslAtucPerfPrev1DayESs, adslAtucPerfCurr1DayLprs=adslAtucPerfCurr1DayLprs, adslAtucPerfPrev1DayLols=adslAtucPerfPrev1DayLols, adslAturChanPerfPrev1DayReceivedBlks=adslAturChanPerfPrev1DayReceivedBlks, adslAtucChanPerfValidIntervals=adslAtucChanPerfValidIntervals, adslAturPerfCurr15MinLprs=adslAturPerfCurr15MinLprs, adslAtucPerfCurr15MinESs=adslAtucPerfCurr15MinESs, adslAtucInvSerialNumber=adslAtucInvSerialNumber, adslLineMib=adslLineMib, adslAtucIntervalTable=adslAtucIntervalTable, adslAtucPerfCurr1DayTimeElapsed=adslAtucPerfCurr1DayTimeElapsed, adslAturAturPhysPerfRawCounterGroup=adslAturAturPhysPerfRawCounterGroup, adslAtucPerfESsThreshTrap=adslAtucPerfESsThreshTrap, adslAturChanPerfValidIntervals=adslAturChanPerfValidIntervals, adslAturChanPerfDataTable=adslAturChanPerfDataTable, adslAtucPerfInits=adslAtucPerfInits, adslAtucIntervalLols=adslAtucIntervalLols, adslAtucPerfLols=adslAtucPerfLols, adslAturChanCrcBlockLength=adslAturChanCrcBlockLength, adslNotificationsGroup=adslNotificationsGroup, adslAtucTraps=adslAtucTraps, adslAturChanEntry=adslAturChanEntry, adslAturChanPerfCurr1DayTimeElapsed=adslAturChanPerfCurr1DayTimeElapsed, adslAtucPerfCurr15MinLols=adslAtucPerfCurr15MinLols, adslAturConfUpshiftSnrMgn=adslAturConfUpshiftSnrMgn, adslAtucPhysPerfIntervalGroup=adslAtucPhysPerfIntervalGroup, adslAturChanIntervalCorrectedBlks=adslAturChanIntervalCorrectedBlks, adslLineEntry=adslLineEntry, adslLineConfProfileEntry=adslLineConfProfileEntry, adslAturAturPhysPerfIntervalGroup=adslAturAturPhysPerfIntervalGroup, adslAtucChanCorrectedBlks=adslAtucChanCorrectedBlks, adslAturCurrSnrMgn=adslAturCurrSnrMgn, adslAtucChanIntervalTransmittedBlks=adslAtucChanIntervalTransmittedBlks, adslAturPerfLoss=adslAturPerfLoss, adslAtucChanPerfPrev1DayReceivedBlks=adslAtucChanPerfPrev1DayReceivedBlks, adslAturPerfValidIntervals=adslAturPerfValidIntervals, adslAturPerfCurr1DayLoss=adslAturPerfCurr1DayLoss, adslPhysicalGroup=adslPhysicalGroup, adslAturChanTransmittedBlks=adslAturChanTransmittedBlks, adslAtucPerfLofs=adslAtucPerfLofs, adslAturPhysPerfRawCounterGroup=adslAturPhysPerfRawCounterGroup, adslAturChanPerfCurr15MinTransmittedBlks=adslAturChanPerfCurr15MinTransmittedBlks, adslLineType=adslLineType, adslAtucCurrAtn=adslAtucCurrAtn, adslAturConfMinSnrMgn=adslAturConfMinSnrMgn, adslLineMibAturCompliance=adslLineMibAturCompliance, adslAtucChanPerfPrev1DayCorrectedBlks=adslAtucChanPerfPrev1DayCorrectedBlks, adslAturCurrStatus=adslAturCurrStatus, adslAtucChanPerfCurr15MinCorrectedBlks=adslAtucChanPerfCurr15MinCorrectedBlks, adslAtucConfTargetSnrMgn=adslAtucConfTargetSnrMgn, adslAturIntervalLprs=adslAturIntervalLprs, adslAtucChanPerfDataEntry=adslAtucChanPerfDataEntry, adslAtucConfDownshiftSnrMgn=adslAtucConfDownshiftSnrMgn, adslLineConfProfile=adslLineConfProfile, adslAturConfRateChanRatio=adslAturConfRateChanRatio, adslAturChanInterleaveDelay=adslAturChanInterleaveDelay, adslAturPerfDataEntry=adslAturPerfDataEntry, adslAtucChanConfMaxInterleaveDelay=adslAtucChanConfMaxInterleaveDelay, adslAturAtucChanPerformanceGroup=adslAturAtucChanPerformanceGroup, adslAtucPerfCurr1DayLoss=adslAtucPerfCurr1DayLoss, adslLineTable=adslLineTable, adslAtucThresh15MinLoss=adslAtucThresh15MinLoss, adslAturPerfCurr15MinLofs=adslAturPerfCurr15MinLofs, adslAturChannelGroup=adslAturChannelGroup, adslAturChanIntervalReceivedBlks=adslAturChanIntervalReceivedBlks, adslAturChanPerfPrev1DayTransmittedBlks=adslAturChanPerfPrev1DayTransmittedBlks, adslAturConfMaxSnrMgn=adslAturConfMaxSnrMgn, adslAtucChanIntervalTable=adslAtucChanIntervalTable, adslAtucChanIntervalNumber=adslAtucChanIntervalNumber, adslAturChanTable=adslAturChanTable, adslAturPhysicalGroup=adslAturPhysicalGroup, adslLineAlarmConfProfileRowStatus=adslLineAlarmConfProfileRowStatus, adslAturConfMinDownshiftTime=adslAturConfMinDownshiftTime, adslAturInvVersionNumber=adslAturInvVersionNumber, adslAtucCurrStatus=adslAtucCurrStatus, adslAturChanPrevTxRate=adslAturChanPrevTxRate, adslLineAlarmConfProfileEntry=adslLineAlarmConfProfileEntry, adslAturChanConfInterleaveMinTxRate=adslAturChanConfInterleaveMinTxRate, adslAtucChanPrevTxRate=adslAtucChanPrevTxRate, adslAtucIntervalESs=adslAtucIntervalESs, adslAturIntervalNumber=adslAturIntervalNumber, adslAturChanConfInterleaveMaxTxRate=adslAturChanConfInterleaveMaxTxRate, adslMibObjects=adslMibObjects, adslAturChanPerfPrev1DayMoniSecs=adslAturChanPerfPrev1DayMoniSecs, adslAturCurrAttainableRate=adslAturCurrAttainableRate, adslAturThreshInterleaveRateDown=adslAturThreshInterleaveRateDown, adslAtucChanPerfPrev1DayTransmittedBlks=adslAtucChanPerfPrev1DayTransmittedBlks, adslAturPerfDataTable=adslAturPerfDataTable, adslAturChanPerfCurr15MinCorrectedBlks=adslAturChanPerfCurr15MinCorrectedBlks, adslAtucPhysEntry=adslAtucPhysEntry, adslAturPerfCurr1DayESs=adslAturPerfCurr1DayESs, adslAtucIntervalValidData=adslAtucIntervalValidData, adslAturIntervalESs=adslAturIntervalESs, adslAturThresh15MinLprs=adslAturThresh15MinLprs, adslLineAlarmConfProfileGroup=adslLineAlarmConfProfileGroup, adslAtucChanPerfCurr15MinTimeElapsed=adslAtucChanPerfCurr15MinTimeElapsed, adslAtucChanInterleaveDelay=adslAtucChanInterleaveDelay, adslAtucPerfLprs=adslAtucPerfLprs, adslAturPerfLprs=adslAturPerfLprs, adslAtucChanReceivedBlks=adslAtucChanReceivedBlks, adslAtucThreshInterleaveRateDown=adslAtucThreshInterleaveRateDown, adslLineSpecific=adslLineSpecific, adslAtucPerfLofsThreshTrap=adslAtucPerfLofsThreshTrap, adslCompliances=adslCompliances, adslAturChanIntervalValidData=adslAturChanIntervalValidData, adslAtucThreshFastRateUp=adslAtucThreshFastRateUp, adslAtucInvVersionNumber=adslAtucInvVersionNumber, adslAtucChanIntervalEntry=adslAtucChanIntervalEntry, adslAtucPerfPrev1DayMoniSecs=adslAtucPerfPrev1DayMoniSecs, adslAtucConfUpshiftSnrMgn=adslAtucConfUpshiftSnrMgn, adslAtucIntervalLoss=adslAtucIntervalLoss, adslAturChanUncorrectBlks=adslAturChanUncorrectBlks, adslAtucPerfCurr15MinLprs=adslAtucPerfCurr15MinLprs, adslAturChanIntervalEntry=adslAturChanIntervalEntry, adslAturPerfLossThreshTrap=adslAturPerfLossThreshTrap, adslAtucPerfPrev1DayInits=adslAtucPerfPrev1DayInits, adslAtucChanPerfCurr1DayCorrectedBlks=adslAtucChanPerfCurr1DayCorrectedBlks, adslAturChanPerfDataEntry=adslAturChanPerfDataEntry, adslAturChanConfFastMaxTxRate=adslAturChanConfFastMaxTxRate, adslAtucChanIntervalValidData=adslAtucChanIntervalValidData, adslAturThreshFastRateDown=adslAturThreshFastRateDown, adslAtucChanConfInterleaveMinTxRate=adslAtucChanConfInterleaveMinTxRate, adslLineAlarmConfProfileName=adslLineAlarmConfProfileName, adslAturAtucPhysPerfRawCounterGroup=adslAturAtucPhysPerfRawCounterGroup, adslLineConfProfileControlGroup=adslLineConfProfileControlGroup, adslAturChanPerfPrev1DayUncorrectBlks=adslAturChanPerfPrev1DayUncorrectBlks, adslAtucChanConfFastMinTxRate=adslAtucChanConfFastMinTxRate, adslAtucPerfPrev1DayLprs=adslAtucPerfPrev1DayLprs, adslAtucPerfESs=adslAtucPerfESs, adslAturChanIntervalTable=adslAturChanIntervalTable, adslAtucChanPerfInvalidIntervals=adslAtucChanPerfInvalidIntervals, adslAturThresh15MinESs=adslAturThresh15MinESs, adslAtucThresh15MinESs=adslAtucThresh15MinESs, adslLineAlarmConfProfile=adslLineAlarmConfProfile, adslAtucPerfValidIntervals=adslAtucPerfValidIntervals, adslAtucChanPerfCurr15MinTransmittedBlks=adslAtucChanPerfCurr15MinTransmittedBlks, adslAturTraps=adslAturTraps, adslAturInvVendorID=adslAturInvVendorID, adslAtucIntervalEntry=adslAtucIntervalEntry, adslAtucPerfPrev1DayLofs=adslAtucPerfPrev1DayLofs, adslAtucChanIntervalUncorrectBlks=adslAtucChanIntervalUncorrectBlks, adslLineConfProfileGroup=adslLineConfProfileGroup, adslAturPerfCurr15MinTimeElapsed=adslAturPerfCurr15MinTimeElapsed, adslAturIntervalValidData=adslAturIntervalValidData, adslAtucChanCrcBlockLength=adslAtucChanCrcBlockLength, adslAturPerfCurr1DayTimeElapsed=adslAturPerfCurr1DayTimeElapsed, adslAtucCurrSnrMgn=adslAtucCurrSnrMgn, adslAtucPerfLolsThreshTrap=adslAtucPerfLolsThreshTrap, adslAtucPerfDataTable=adslAtucPerfDataTable, adslAtucIntervalNumber=adslAtucIntervalNumber, adslAtucChanUncorrectBlks=adslAtucChanUncorrectBlks, adslLineAlarmConfProfileTable=adslLineAlarmConfProfileTable, adslAtucThresh15MinLprs=adslAtucThresh15MinLprs, adslAturChanPerfCurr15MinUncorrectBlks=adslAturChanPerfCurr15MinUncorrectBlks, adslAtucThresh15MinLols=adslAtucThresh15MinLols, adslAtucChanPerfCurr1DayUncorrectBlks=adslAtucChanPerfCurr1DayUncorrectBlks, adslAtucConfRateMode=adslAtucConfRateMode, adslAtucIntervalInits=adslAtucIntervalInits, adslAtucPerfLoss=adslAtucPerfLoss, adslAtucPerfCurr1DayLofs=adslAtucPerfCurr1DayLofs, adslAtucChanPerfDataTable=adslAtucChanPerfDataTable, adslAturIntervalEntry=adslAturIntervalEntry, adslAturChanReceivedBlks=adslAturChanReceivedBlks, adslAturChanIntervalUncorrectBlks=adslAturChanIntervalUncorrectBlks, adslAturLineAlarmConfProfileGroup=adslAturLineAlarmConfProfileGroup, adslLCSMib=adslLCSMib, adslAturAturChanPerformanceGroup=adslAturAturChanPerformanceGroup, adslMIB=adslMIB, adslAtucChanPerfCurr1DayReceivedBlks=adslAtucChanPerfCurr1DayReceivedBlks, adslAtucIntervalLofs=adslAtucIntervalLofs, adslAtucChanIntervalReceivedBlks=adslAtucChanIntervalReceivedBlks, adslAturThresh15MinLoss=adslAturThresh15MinLoss, adslAturChanCorrectedBlks=adslAturChanCorrectedBlks, adslAtucPerfCurr15MinLofs=adslAtucPerfCurr15MinLofs, adslAturChanPerfCurr15MinReceivedBlks=adslAturChanPerfCurr15MinReceivedBlks, adslAturChanPerfInvalidIntervals=adslAturChanPerfInvalidIntervals, adslAturChanPerfCurr15MinTimeElapsed=adslAturChanPerfCurr15MinTimeElapsed, adslAturThreshFastRateUp=adslAturThreshFastRateUp, adslAturPerfLofsThreshTrap=adslAturPerfLofsThreshTrap, adslAturPerfCurr1DayLprs=adslAturPerfCurr1DayLprs, adslAturPerfLprsThreshTrap=adslAturPerfLprsThreshTrap, adslAturIntervalLoss=adslAturIntervalLoss, adslAturPerfESsThreshTrap=adslAturPerfESsThreshTrap)
mibBuilder.exportSymbols("ADSL-LINE-MIB", adslAturChanCurrTxRate=adslAturChanCurrTxRate, adslAtucChanPerfCurr15MinReceivedBlks=adslAtucChanPerfCurr15MinReceivedBlks, adslAturCurrAtn=adslAturCurrAtn, adslAtucChanPerfCurr1DayTransmittedBlks=adslAtucChanPerfCurr1DayTransmittedBlks, adslAturPerfLofs=adslAturPerfLofs, adslAturChanConfMaxInterleaveDelay=adslAturChanConfMaxInterleaveDelay, adslAturThreshInterleaveRateUp=adslAturThreshInterleaveRateUp, adslAturIntervalTable=adslAturIntervalTable, adslLineMibAtucCompliance=adslLineMibAtucCompliance, adslAtucPerfCurr15MinInits=adslAtucPerfCurr15MinInits, adslAtucChanTransmittedBlks=adslAtucChanTransmittedBlks, adslAtucChanIntervalCorrectedBlks=adslAtucChanIntervalCorrectedBlks, adslAturPerfPrev1DayESs=adslAturPerfPrev1DayESs, adslAturPhysEntry=adslAturPhysEntry, adslAtucChanPerformanceGroup=adslAtucChanPerformanceGroup, adslAtucChanCurrTxRate=adslAtucChanCurrTxRate, adslAtucConfRateChanRatio=adslAtucConfRateChanRatio, adslAtucConfMinDownshiftTime=adslAtucConfMinDownshiftTime, adslAtucCurrAttainableRate=adslAtucCurrAttainableRate, adslAtucThresh15MinLofs=adslAtucThresh15MinLofs, adslAtucPerfCurr1DayInits=adslAtucPerfCurr1DayInits, adslAtucPerfInvalidIntervals=adslAtucPerfInvalidIntervals, adslAturInvSerialNumber=adslAturInvSerialNumber)
