/*--------------------------------------------------------------------------+
$Id: XMLResolver.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.xml;

/**
 * Default implementation of {@link IXMLResolver}.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 5544BF4152061189A288561D7753DB13
 */
public class XMLResolver<E extends Enum<E>, A extends Enum<A>> implements
		IXMLResolver<E, A> {

	/** Class object for attribute enum. */
	private final Class<A> attributeClass;

	/**
	 * Create new resolver.
	 * 
	 * @param attributeClass
	 *            class object for attribute enum.
	 */
	public XMLResolver(Class<A> attributeClass) {
		this.attributeClass = attributeClass;
	}

	/** {@inheritDoc} */
	public Class<A> getAttributeClass() {
		return attributeClass;
	}

	/** Returns <code>&lt;enum-element&gt;.name()</code>. */
	public String resolveAttributeName(A attribute) {
		return attribute.name();
	}

	/** Returns <code>&lt;enum-element&gt;.name()</code>. */
	public String resolveElementName(E element) {
		return element.name();
	}

}