info = {
    "name": "uk",
    "date_order": "DMY",
    "january": [
        "січень",
        "січ",
        "січня"
    ],
    "february": [
        "лютий",
        "лют",
        "лютого"
    ],
    "march": [
        "березень",
        "бер",
        "березня"
    ],
    "april": [
        "квітень",
        "кві",
        "квітня",
        "квіт"
    ],
    "may": [
        "травень",
        "тра",
        "травня",
        "трав"
    ],
    "june": [
        "червень",
        "чер",
        "червня",
        "черв"
    ],
    "july": [
        "липень",
        "лип",
        "липня"
    ],
    "august": [
        "серпень",
        "сер",
        "серпня",
        "серп"
    ],
    "september": [
        "вересень",
        "вер",
        "вересня"
    ],
    "october": [
        "жовтень",
        "жов",
        "жовтня",
        "жовт"
    ],
    "november": [
        "листопад",
        "лис",
        "листопада",
        "лист"
    ],
    "december": [
        "грудень",
        "гру",
        "грудня",
        "груд"
    ],
    "monday": [
        "понеділок",
        "пн",
        "пон"
    ],
    "tuesday": [
        "вівторок",
        "вт",
        "вів"
    ],
    "wednesday": [
        "середа",
        "ср"
    ],
    "thursday": [
        "четвер",
        "чт",
        "чет"
    ],
    "friday": [
        "п'ятниця",
        "пт"
    ],
    "saturday": [
        "субота",
        "сб",
        "суб"
    ],
    "sunday": [
        "неділя",
        "нд",
        "нед"
    ],
    "am": [
        "дп"
    ],
    "pm": [
        "пп"
    ],
    "year": [
        "рік",
        "р",
        "роки",
        "років"
    ],
    "month": [
        "місяць",
        "міс",
        "місяці",
        "місяців"
    ],
    "week": [
        "тиждень",
        "тиж",
        "тижні",
        "тижнів"
    ],
    "day": [
        "день",
        "д",
        "дні",
        "днів"
    ],
    "hour": [
        "година",
        "год",
        "години",
        "годин",
        "годину",
        "г"
    ],
    "minute": [
        "хвилина",
        "хв",
        "хвилини",
        "хвилин",
        "хвилину"
    ],
    "second": [
        "секунда",
        "с",
        "секунди",
        "секунд",
        "секунду",
        "сек"
    ],
    "relative-type": {
        "1 year ago": [
            "торік"
        ],
        "0 year ago": [
            "цього року"
        ],
        "in 1 year": [
            "наступного року"
        ],
        "1 month ago": [
            "минулого місяця"
        ],
        "0 month ago": [
            "цього місяця"
        ],
        "in 1 month": [
            "наступного місяця"
        ],
        "1 week ago": [
            "минулого тижня"
        ],
        "0 week ago": [
            "цього тижня"
        ],
        "in 1 week": [
            "наступного тижня"
        ],
        "1 day ago": [
            "учора",
            "вчора"
        ],
        "0 day ago": [
            "сьогодні"
        ],
        "in 1 day": [
            "завтра"
        ],
        "0 hour ago": [
            "цієї години"
        ],
        "0 minute ago": [
            "цієї хвилини"
        ],
        "0 second ago": [
            "зараз"
        ],
        "2 day ago": [
            "позавчора"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "через (\\d+) рік",
            "через (\\d+) року",
            "через (\\d+) р",
            "за (\\d+) р"
        ],
        "\\1 year ago": [
            "(\\d+) рік тому",
            "(\\d+) року тому",
            "(\\d+) р тому"
        ],
        "in \\1 month": [
            "через (\\d+) місяць",
            "через (\\d+) місяця",
            "через (\\d+) міс",
            "за (\\d+) міс"
        ],
        "\\1 month ago": [
            "(\\d+) місяць тому",
            "(\\d+) місяця тому",
            "(\\d+) міс тому"
        ],
        "in \\1 week": [
            "через (\\d+) тиждень",
            "через (\\d+) тижня",
            "через (\\d+) тиж",
            "за (\\d+) тиж"
        ],
        "\\1 week ago": [
            "(\\d+) тиждень тому",
            "(\\d+) тижня тому",
            "(\\d+) тиж тому"
        ],
        "in \\1 day": [
            "через (\\d+) день",
            "через (\\d+) дня",
            "через (\\d+) дн",
            "за (\\d+) д"
        ],
        "\\1 day ago": [
            "(\\d+) день тому",
            "(\\d+) дня тому",
            "(\\d+) дн тому",
            "(\\d+) д тому"
        ],
        "in \\1 hour": [
            "через (\\d+) годину",
            "через (\\d+) години",
            "через (\\d+) год",
            "за (\\d+) год"
        ],
        "\\1 hour ago": [
            "(\\d+) годину тому",
            "(\\d+) години тому",
            "(\\d+) год тому"
        ],
        "in \\1 minute": [
            "через (\\d+) хвилину",
            "через (\\d+) хвилини",
            "через (\\d+) хв",
            "за (\\d+) хв"
        ],
        "\\1 minute ago": [
            "(\\d+) хвилину тому",
            "(\\d+) хвилини тому",
            "(\\d+) хв тому"
        ],
        "in \\1 second": [
            "через (\\d+) секунду",
            "через (\\d+) секунди",
            "через (\\d+) с",
            "за (\\d+) с"
        ],
        "\\1 second ago": [
            "(\\d+) секунду тому",
            "(\\d+) секунди тому",
            "(\\d+) с тому"
        ]
    },
    "locale_specific": {},
    "skip": [
        "близько",
        "о",
        "об",
        "і",
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ],
    "sentence_splitter_group": 1,
    "ago": [
        "тому",
        "назад"
    ],
    "in": [
        "протягом"
    ],
    "simplifications": [
        {
            "^година": "1 година"
        },
        {
            "^годину": "1 годину"
        },
        {
            "^хвилину": "1 хвилину"
        },
        {
            "^секунду": "1 секунду"
        },
        {
            "кілька секунд": "44 секунди"
        },
        {
            "кілька хвилин": "2 хвилини"
        },
        {
            "опів на": "30 хвилин"
        },
        {
            "за чверть": "15 хвилин"
        }
    ]
}
