/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import org.hornetq.utils.TokenBucketLimiter;

public class TokenBucketLimiterImpl
implements TokenBucketLimiter {
    private final int rate;
    private final boolean spin;
    private long last;
    private int tokens;
    private int tokensAdded;

    public TokenBucketLimiterImpl(int rate) {
        this(rate, false);
    }

    public TokenBucketLimiterImpl(int rate, boolean spin) {
        this.rate = rate;
        this.spin = spin;
    }

    @Override
    public int getRate() {
        return this.rate;
    }

    @Override
    public boolean isSpin() {
        return this.spin;
    }

    @Override
    public void limit() {
        while (!this.check()) {
            if (this.spin) {
                Thread.yield();
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
    }

    private boolean check() {
        int tokensDue;
        int tokensToAdd;
        long diff;
        long now = System.currentTimeMillis();
        if (this.last == 0L) {
            this.last = now;
        }
        if ((diff = now - this.last) >= 1000L) {
            this.last += 1000L;
            this.tokens = 0;
            this.tokensAdded = 0;
        }
        if ((tokensToAdd = (tokensDue = (int)((long)this.rate * diff / 1000L)) - this.tokensAdded) > 0) {
            this.tokens += tokensToAdd;
            this.tokensAdded += tokensToAdd;
        }
        if (this.tokens > 0) {
            --this.tokens;
            return true;
        }
        return false;
    }
}

