/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.polyglot.cache.as;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.infinispan.manager.CacheContainer;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.projectodd.polyglot.core.util.ClusterUtil;

public class CacheService
implements Service<CacheService> {
    public static final ServiceName CACHE = ServiceName.of((String[])new String[]{"polyglot"}).append(new String[]{"cache"});
    private CacheContainer container;
    private StartContext startContext;
    private String cacheContainerName = "polyglot";
    static final Logger log = Logger.getLogger((String)"org.projectodd.polyglot.cache.as");

    public CacheService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
        this.startContext = context;
    }

    public void stop(StopContext context) {
        if (this.container != null) {
            this.container.stop();
        }
    }

    public synchronized CacheContainer getCacheContainer() {
        if (this.container == null) {
            this.lookupContainerService();
        }
        return this.container;
    }

    public boolean isClustered() {
        return this.startContext == null ? false : ClusterUtil.isClustered((ServiceRegistry)this.startContext.getController().getServiceContainer());
    }

    public void setCacheContainerName(String cacheContainerName) {
        this.cacheContainerName = cacheContainerName;
    }

    private void lookupContainerService() {
        try {
            InitialContext initialContext = new InitialContext();
            this.container = (CacheContainer)initialContext.lookup(this.infinispanServiceName());
            if (this.container != null) {
                log.info((Object)("Starting polyglot cache service: " + this.infinispanServiceName()));
                this.container.start();
            }
        }
        catch (NamingException e) {
            log.error((Object)"Cannot get cache container. ", (Throwable)e);
        }
    }

    private String infinispanServiceName() {
        return "java:jboss/infinispan/container/" + this.cacheContainerName;
    }
}

