/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming.remote.server;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.Executor;
import javax.naming.Context;
import org.jboss.logging.Logger;
import org.jboss.naming.remote.Constants;
import org.jboss.naming.remote.protocol.CancellableDataOutputStream;
import org.jboss.naming.remote.protocol.Versions;
import org.jboss.naming.remote.server.DefaultRemoteNamingServerLogger;
import org.jboss.naming.remote.server.RemoteNamingServerLogger;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.xnio.IoUtils;
import org.xnio.OptionMap;

public class RemoteNamingService {
    private static final Logger log = Logger.getLogger(RemoteNamingService.class);
    private final RemoteNamingServerLogger logger;
    private Registration registration;
    private final Context localContext;
    private final Executor executor;

    public RemoteNamingService(Context localContext, Executor executor) {
        this(localContext, executor, DefaultRemoteNamingServerLogger.INSTANCE);
    }

    public RemoteNamingService(Context localContext, Executor executor, RemoteNamingServerLogger logger) {
        this.localContext = localContext;
        this.executor = executor;
        this.logger = logger;
    }

    public void start(Endpoint endpoint) throws IOException {
        this.registration = endpoint.registerService("naming", (OpenListener)new ChannelOpenListener(), OptionMap.EMPTY);
    }

    public void stop() throws IOException {
        this.registration.close();
    }

    private void writeHeader(Channel channel) throws IOException {
        CancellableDataOutputStream dos = new CancellableDataOutputStream(channel.writeMessage());
        try {
            dos.write(Constants.NAMING);
            byte[] versions = Versions.getSupportedVersions();
            dos.write(versions.length);
            dos.write(versions);
        }
        catch (IOException e) {
            dos.cancel();
            throw e;
        }
        finally {
            dos.close();
        }
    }

    public Context getLocalContext() {
        return this.localContext;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public RemoteNamingServerLogger getLogger() {
        return this.logger;
    }

    private class ChannelCloseHandler
    implements CloseHandler<Channel> {
        private ChannelCloseHandler() {
        }

        public void handleClose(Channel channel, IOException e) {
            log.debugf("Channel %s closed.", (Object)channel);
        }
    }

    private class ClientVersionReceiver
    implements Channel.Receiver {
        private ClientVersionReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Channel channel, MessageInputStream messageInputStream) {
            DataInputStream dis = new DataInputStream((InputStream)messageInputStream);
            try {
                byte[] namingHeader = new byte[6];
                dis.read(namingHeader);
                if (!Arrays.equals(namingHeader, Constants.NAMING)) {
                    throw new IOException("Invalid leading bytes in header.");
                }
                byte version = dis.readByte();
                log.debugf("Chosen version 0x0%d", (Object)version);
                Versions.getRemoteNamingServer(version, channel, RemoteNamingService.this);
            }
            catch (IOException e) {
                RemoteNamingService.this.logger.failedToDetermineClientVersion(e);
            }
            finally {
                IoUtils.safeClose((Closeable)dis);
            }
        }

        public void handleError(Channel channel, IOException error) {
            RemoteNamingService.this.logger.closingChannel(channel, error);
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void handleEnd(Channel channel) {
            RemoteNamingService.this.logger.closingChannelOnChannelEnd(channel);
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class ChannelOpenListener
    implements OpenListener {
        private ChannelOpenListener() {
        }

        public void channelOpened(Channel channel) {
            log.debugf("Channel Opened - %s", (Object)channel);
            channel.addCloseHandler((CloseHandler)new ChannelCloseHandler());
            try {
                RemoteNamingService.this.writeHeader(channel);
                channel.receiveMessage((Channel.Receiver)new ClientVersionReceiver());
            }
            catch (IOException e) {
                RemoteNamingService.this.logger.failedToSendHeader(e);
                IoUtils.safeClose((Closeable)channel);
            }
        }

        public void registrationTerminated() {
        }
    }
}

