(ns cheshire.monad
  (:use [cheshire.factory]
        [clojure.algo.monads :only [domonad defmonad state-t
                                    maybe-m m-plus m-result m-seq m-bind]])
  (:import (java.io StringReader)
           (com.fasterxml.jackson.core JsonToken)))

;; (defn m-assoc [monadic-value k v]
;;   (bind monadic-value
;;         (fn [value]
;;           (fn [state]
;;             [value (assoc state k v)]))))

;; (defn m-double-string [monadic-value]
;;   (bind monadic-value
;;         (fn [value]
;;           (fn [state]
;;             [(str value value) state]))))

;; ;; add to state as well as munging value
;; ((-> (return "foo")
;;      (m-double-string)
;;      (m-assoc :foo "bar")
;;      (m-double-string)
;;      (m-assoc :baz "eggplant")) {})
;; ;; ["foofoofoofoo" {:baz "eggplant", :foo "bar"}]


;; ;; let's pretend these are (or will be) json tokens
;; (def tokens [:foo "bar" :baz "eggplant" :bad])

;; (defn m-parse [monadic-value]
;;   (bind monadic-value
;;         (fn [value]
;;           (fn [tokens]
;;             (let [[k v] (take 2 tokens)
;;                   new-tokens (drop 2 tokens)]
;;               (if (and k v)
;;                 [(assoc value k v) new-tokens]
;;                 [value tokens]))))))

;; ((-> (return {})
;;      (m-parse)
;;      (m-parse)
;;      (m-parse)) tokens)
;; ;; [{:baz "eggplant", :foo "bar"} (:bad)]

;;;;;;;
;; assume our tokens to be (easy-only):
;; string, number, true, false, nil


(defn make-jp [string]
  (doto (.createJsonParser json-factory (StringReader. string))
    (.nextToken)))

(def parser-m (state-t maybe-m))

(defn any-string [jp]
  (println :any-string (.getCurrentToken jp))
  (when (= JsonToken/VALUE_STRING (.getCurrentToken jp))
    ;; returns token (string) and new state (advanced JsonParser)
    (let [text (.getText jp)]
      (.nextToken jp)
      [text jp])))

(defn string-test [pred]
  (println :s-test)
  (domonad parser-m
           [s any-string
            :when (pred s)]
           (str s)))

(defn is-string [s]
  (println :is-string s)
  (string-test (partial = s)))

(def is-foo (is-string "foo"))
(def is-bar (is-string "bar"))

(def jp (make-jp "\"foo\" \"bar\""))
(def jp2 (make-jp "\"bar\" \"foo\""))

;; (is-foo jp) => ["foo" ...]
;; (is-foo jp2) => nil

(defn optional [parser]
  (m-plus parser (m-result nil)))

(def match-one m-plus)

(defn match-all [& parsers]
  (m-bind (m-seq parsers)
          (fn [x]
            (m-result
             (apply str x)))))

(def one-or-more)

(defn none-or-more [parser]
  (optional (one-or-more parser)))

(defn one-or-more [parser]
  (domonad
   [a parser
    as (none-or-more parser)]
   (str a as)))

;;(match-all is-foo is-bar)

