# PuppetDB

PuppetDB is the fast, scalable, and reliable data warehouse for Puppet. It caches data generated by Puppet, and gives you advanced features at awesome speed with a powerful API.

General Information
-----

* [FAQ and troubleshooting](./documentation/puppetdb-faq.markdown)
* [Overview & Requirements](./documentation/index.markdown)
* [Release Notes](./documentation/release_notes.markdown)
* [Known Issues](./documentation/known_issues.markdown)
* [Community Add-ons](./documentation/community_add_ons.markdown)

Installation
-----

* [Installing PuppetDB via the Puppet Module](./documentation/install_via_module.markdown)
* [Installing PuppetDB from Packages](./documentation/install_from_packages.markdown)
* [Connecting Puppet Masters](./documentation/connect_puppet_master.markdown)
* [Connecting Standalone Puppet](./documentation/connect_puppet_apply.markdown)
* [Upgrading PuppetDB](./documentation/upgrade.markdown)
* [Installing from Source](./documentation/install_from_source.markdown)

Administration
-----

* [Using PuppetDB](./documentation/using.markdown)
* [Maintaining and Tuning](./documentation/maintain_and_tune.markdown)
* [Scaling Recommendations](./documentation/scaling_recommendations.markdown)
* [Configuring](./documentation/configure.markdown)
* [Debugging with Remote REPL](./documentation/repl.markdown)

Troubleshooting
-----

* [KahaDB Corruption](./documentation/trouble_kahadb_corruption.markdown)

The PuppetDB API
-----

* [Overview](./documentation/api/query/index.markdown)
* [Curl Tips](./documentation/api/query/curl.markdown)
* [Commands](./documentation/api/commands.markdown)
* Querying
  * [Introduction](./documentation/api/query/v2/query.markdown)
  * [Tutorial](./documentation/api/query/tutorial.markdown)
  * [Operators](./documentation/api/query/v2/operators.markdown)
  * [Querying Nodes](./documentation/api/query/v2/nodes.markdown)
  * [Querying Facts](./documentation/api/query/v2/facts.markdown)
  * [Querying Fact Names](./documentation/api/query/v2/fact-names.markdown)
  * [Querying Resources](./documentation/api/query/v2/resources.markdown)
  * [Querying Metrics](./documentation/api/query/v2/metrics.markdown)
  * [Querying Reports (experimental)](./documentation/api/experimental/report.markdown)
  * [Querying Events (experimental)](./documentation/api/experimental/event.markdown)
* Wire Formats
  * [Catalog Format](./documentation/api/wire_format/catalog_format.markdown)
  * [Facts Format](./documentation/api/wire_format/facts_format.markdown)
  * [Report Format (experimental)](./documentation/api/wire_format/report_format.markdown)


# Special thanks to

## YourKit

YourKit has given us an open source license for their profiler, greatly
simplifying the profiling of PuppetDB's performance.

YourKit is kindly supporting open source projects with its full-featured Java
Profiler. YourKit, LLC is the creator of innovative and intelligent tools for
profiling Java and .NET applications. Take a look at YourKit's leading software
products:

* [YourKit Java Profiler](http://www.yourkit.com/java/profiler/index.jsp)
* [YourKit .NET Profiler](http://www.yourkit.com/.net/profiler/index.jsp)

[leiningen]: https://github.com/technomancy/leiningen
