module Puppet
  # @since 3.1 
  # @status EXPERIMENTAL
  module DSL

    # See documentation below where the class is reopened
    if RUBY_VERSION < "1.9"
      ##
      # Ruby 1.8 version - see reopened class below for documentation
      # Undefine all methods except those defined in BasicObject.
      ##
      class BlankSlate        
        instance_methods.each do |m|
          unless ['==', 'equal?', 'instance_eval', 'instance_exec', '__send__', '__id__'].include? m
            undef_method m
          end
        end
      end
    else
      ##
      # Ruby 1.9 version - see reopened class below for documentation
      ##
      class BlankSlate < BasicObject; end
    end

    # BlankSlate is a class intended for use with `method_missing`.
    #
    # * Ruby 1.9 version is based on BasicObject.
    # * Ruby 1.8 version has almost all methods undefined.
    #
    # Ruby 1.9 version doesn't include Kernel module.
    # To reference a constant in that version `::` has to be prepended to
    # the constant name.
    #
    class BlankSlate
      # Reopening class to add methods.
      # The class is conditionally created above with different superclass depending on ruby version

      private

      # Adds method normally found in {Object}, but needs to be added as {BasicObject} in Ruby 1.9
      # does not include it.
      # This method is used to define a {Context} singleton method as a cached version of a method
      # generated by a `method_missing` call.
      # @return [void]
      #
      def define_singleton_method(name, &block)
        class << self; self; end.instance_eval do
          define_method name, &block
        end
      end
    end

  end
end
