/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.core.impl.PacketImpl;
import org.hornetq.utils.XidCodecSupport;

public class SessionXAGetInDoubtXidsResponseMessage
extends PacketImpl {
    private List<Xid> xids;

    public SessionXAGetInDoubtXidsResponseMessage(List<Xid> xids) {
        super((byte)62);
        this.xids = xids;
    }

    public SessionXAGetInDoubtXidsResponseMessage() {
        super((byte)62);
    }

    @Override
    public boolean isResponse() {
        return true;
    }

    public List<Xid> getXids() {
        return this.xids;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeInt(this.xids.size());
        for (Xid xid : this.xids) {
            XidCodecSupport.encodeXid(xid, buffer);
        }
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        int len = buffer.readInt();
        this.xids = new ArrayList<Xid>(len);
        for (int i = 0; i < len; ++i) {
            Xid xid = XidCodecSupport.decodeXid(buffer);
            this.xids.add(xid);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.xids == null ? 0 : ((Object)this.xids).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionXAGetInDoubtXidsResponseMessage)) {
            return false;
        }
        SessionXAGetInDoubtXidsResponseMessage other = (SessionXAGetInDoubtXidsResponseMessage)obj;
        return !(this.xids == null ? other.xids != null : !((Object)this.xids).equals(other.xids));
    }
}

