/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.socket.nio.AbstractNioWorker;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.internal.ExecutorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNioWorkerPool<E extends AbstractNioWorker>
implements WorkerPool<E>,
ExternalResourceReleasable {
    private final AbstractNioWorker[] workers;
    private final AtomicInteger workerIndex = new AtomicInteger();
    private final Executor workerExecutor;
    private volatile boolean initDone;

    AbstractNioWorkerPool(Executor workerExecutor, int workerCount) {
        this(workerExecutor, workerCount, true);
    }

    AbstractNioWorkerPool(Executor workerExecutor, int workerCount, boolean autoInit) {
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor");
        }
        if (workerCount <= 0) {
            throw new IllegalArgumentException("workerCount (" + workerCount + ") " + "must be a positive integer.");
        }
        this.workers = new AbstractNioWorker[workerCount];
        this.workerExecutor = workerExecutor;
        if (autoInit) {
            this.init();
        }
    }

    protected void init() {
        if (this.initDone) {
            throw new IllegalStateException("Init was done before");
        }
        this.initDone = true;
        for (int i = 0; i < this.workers.length; ++i) {
            this.workers[i] = this.newWorker(this.workerExecutor);
        }
    }

    @Deprecated
    protected E createWorker(Executor executor) {
        throw new IllegalStateException("This will be removed. Override this and the newWorker(..) method!");
    }

    protected E newWorker(Executor executor) {
        return this.createWorker(executor);
    }

    @Override
    public E nextWorker() {
        return (E)this.workers[Math.abs(this.workerIndex.getAndIncrement() % this.workers.length)];
    }

    @Override
    public void rebuildSelectors() {
        for (AbstractNioWorker worker : this.workers) {
            worker.rebuildSelector();
        }
    }

    @Override
    public void releaseExternalResources() {
        this.shutdown();
        ExecutorUtil.terminate(this.workerExecutor);
    }

    @Override
    public void shutdown() {
        for (AbstractNioWorker worker : this.workers) {
            worker.shutdown();
        }
    }
}

