%global realname puppetdb
%global realversion 4.3.0
%global rpmversion 4.3.0

# Application bin dir.
%global _app_bindir /opt/puppetlabs/server/apps/puppetdb/bin
# Bin dir where convenience symlinks go.
%global _sym_bindir /opt/puppetlabs/server/bin
# Bin dir the end user adds to their PATH
%global _ux_bindir /opt/puppetlabs/bin
# Log directory
%global _app_logdir /var/log/puppetlabs/puppetdb
# Run directory, PID files go here
%global _app_rundir /var/run/puppetlabs/puppetdb

# Puppet Installation Layout
# https://github.com/puppetlabs/puppet-specifications/blob/af82509/file_paths.md
%global _app_prefix /opt/puppetlabs/server/apps/puppetdb
%global _app_data /opt/puppetlabs/server/data/puppetdb
%global _projconfdir /etc/puppetlabs/puppetdb

%global rubylibdir        /opt/puppetlabs/puppet/lib/ruby/vendor_ruby

%global _with_systemd  0
%global _with_sysvinit 0
%global _systemd_el    0
%global _systemd_sles  0
%global _old_el        0
%global _sles          0

%if 0%{?fedora} >= 18 || 0%{?rhel} >= 7
%global _with_systemd 1
%global _systemd_el   1
%endif

# We do not support any sles version less than 12, as there is not a sufficient
# version of OpenJDK available to test against.
%if 0%{?suse_version} >= 1210
%global _with_systemd 1
%global _systemd_sles 1
%global _sles         1
%endif

%if 0%{?rhel} && 0%{?rhel} < 7
%global _with_sysvinit 1
%global _old_el        1
%endif

# java 1.8.0 is available starting in fedora 20 and el 6
# SLES 12 still only has java 1.7.0
%if 0%{?fedora} >= 20 || 0%{?rhel} >= 6
%global open_jdk          java-1.8.0-openjdk-headless
%else
%global open_jdk          java-1.7.0-openjdk
%endif

# Use the alternate locations for things.
%global _sysconfdir      /etc
%global _prefix          /opt/puppetlabs/server/apps/puppetdb
%global _rundir          /var/run

%define __jar_repack     0

Name:             puppetdb
Version:          4.3.0
Release:          1%{?dist}
BuildRoot:        %{_tmppath}/%{realname}-%{version}-%{release}-root-%(%{__id_u} -n)

Summary:          Puppet Labs - puppetdb
Vendor:           Puppet Labs <info@puppetlabs.com>
License:          ASL 2.0

URL:              http://puppetlabs.com
Source0:          %{name}-%{realversion}.tar.gz

Group:            System Environment/Daemons
BuildArch:        noarch



BuildRequires:    ruby
BuildRequires:    /usr/sbin/useradd
%if %{_with_systemd}
BuildRequires:    systemd
%endif
%if %{_old_el}
Requires:         chkconfig
%endif

%if %{_systemd_el}
Requires(post):   systemd
Requires(preun):  systemd
Requires(postun): systemd
%endif

%if %{_systemd_sles}
%{?systemd_requires}
%endif

Requires:         %{open_jdk}
# net-tools is required for netstat usage in service unit file
# See: https://tickets.puppetlabs.com/browse/SERVER-338
Requires:         net-tools
# procps is required for pgrep, used in several of the init scripts
Requires:         procps


Requires:         puppet >= 3.8.1

Requires:         puppet < 5.0.0


%description
Puppet-integrated catalog and fact storage (puppetdb 4.3.0)
%package termini
Group: Development/Libraries
Summary: Termini for puppetdb
Requires: puppet-agent

%description termini
Termini for puppetdb
Contains terminus for:
  puppetdb (version 4.3.0)

%prep
%setup -q -n %{name}-%{realversion}

%build

%install

rm -rf $RPM_BUILD_ROOT

env EZ_VERBOSE=1 DESTDIR=%{buildroot} prefix=%{_prefix} app_prefix=%{_app_prefix} app_data=%{_app_data} confdir=%{_sysconfdir} bindir=%{_app_bindir} symbindir=%{_sym_bindir} rundir=%{_app_rundir} rubylibdir=%{rubylibdir} bash install.sh install_redhat
%if %{_with_systemd}
env EZ_VERBOSE=1 DESTDIR=%{buildroot} prefix=%{_prefix} app_prefix=%{_app_prefix} app_data=%{_app_data} confdir=%{_sysconfdir} bindir=%{_app_bindir} symbindir=%{_sym_bindir} rundir=%{_app_rundir} defaultsdir=%{_sysconfdir}/sysconfig unitdir=%{_unitdir} bash install.sh systemd_redhat
%else
env EZ_VERBOSE=1 DESTDIR=%{buildroot} prefix=%{_prefix} app_prefix=%{_app_prefix} app_data=%{_app_data} confdir=%{_sysconfdir} bindir=%{_app_bindir} symbindir=%{_sym_bindir} rundir=%{_app_rundir} defaultsdir=%{_sysconfdir}/sysconfig initdir=%{_initrddir} bash install.sh sysv_init_redhat
%endif


env EZ_VERBOSE=1 DESTDIR=%{buildroot} rubylibdir=%{rubylibdir} prefix=%{_prefix} bash install.sh termini

%clean
rm -rf $RPM_BUILD_ROOT

%pre
# Note: changes to this section of the spec may require synchronisation with the
# install.sh source based installation methodology.
#
# Add puppetdb group
getent group puppetdb > /dev/null || \
  groupadd -r puppetdb || :
# Add puppetdb user
if getent passwd puppetdb > /dev/null; then
  usermod --gid puppetdb --home %{_app_data} \
  --comment "puppetdb daemon" puppetdb || :
else
  useradd -r --gid puppetdb --home %{_app_data} --shell $(which nologin) \
    --comment "puppetdb daemon"  puppetdb || :
fi
if rpm -q puppetdb | grep ^puppetdb-2.* > /dev/null && [ $1 -eq 2 ] ; then tar -czf /tmp/puppetdb-upgrade-config-files.tgz -C /etc/puppetdb/conf.d config.ini database.ini jetty.ini ; fi

%post
%{_app_prefix}/scripts/install.sh postinst_redhat
%if %{_with_systemd}
# Reload the systemd units
systemctl daemon-reload >/dev/null 2>&1 || :
%endif
%if %{_systemd_el}
%systemd_post puppetdb.service
%endif
%if %{_systemd_sles}
%service_add_post puppetdb.service
%endif
%if %{_with_sysvinit}
# If this is an install (as opposed to an upgrade)...
if [ "$1" = "1" ]; then
    # Register the puppetdb service
    /sbin/chkconfig --add %{name}
fi
%endif

%preun
%if %{_systemd_el}
%systemd_preun puppetdb.service
%endif
%if %{_systemd_sles}
%service_del_preun puppetdb.service
%endif
%if %{_with_sysvinit}
# If this is an uninstall (as opposed to an upgrade) then
#  we want to shut down and disable the service.
if [ "$1" = "0" ] ; then
    /sbin/service %{name} stop >/dev/null 2>&1
    /sbin/chkconfig --del %{name}
fi
%endif

%postun
%if %{_systemd_el}
%systemd_postun_with_restart puppetdb.service
%endif
%if %{_systemd_sles}
%service_del_postun puppetdb.service
%endif
%if %{_with_sysvinit}
# Remove the rundir if this is an uninstall (as opposed to an upgrade)...
if [ "$1" = "0" ]; then
    rm -rf %{_app_rundir} || :
fi

# Only restart it if it is running
if [ "$1" = "1" ] ; then
    /sbin/service %{name} condrestart >/dev/null 2>&1
fi
%endif

%files
%defattr(-, root, root)
%dir %attr(0700, puppetdb, puppetdb) %{_app_logdir}
%dir %attr(0750, puppetdb, puppetdb) %{_projconfdir}
%doc ext/docs
%{_app_prefix}
%if %{_with_systemd}
%{_unitdir}/%{name}.service
%{_tmpfilesdir}/%{name}.conf
%else
%{_initrddir}/%{name}
%endif
%config(noreplace) %{_sysconfdir}/puppetlabs/%{realname}
%config(noreplace) %{_sysconfdir}/sysconfig/%{name}
%{_app_bindir}/puppetdb
%{_sym_bindir}/puppetdb
%{_ux_bindir}/puppetdb
%attr(-, puppetdb, puppetdb) %{_app_data}
%dir %attr(0755, puppetdb, puppetdb) %{_app_rundir}

%files termini
%defattr(-, root, root)
%{rubylibdir}/puppet/indirector/node/puppetdb.rb
%{rubylibdir}/puppet/indirector/facts/puppetdb_apply.rb
%{rubylibdir}/puppet/indirector/facts/puppetdb.rb
%{rubylibdir}/puppet/indirector/catalog/puppetdb.rb
%{rubylibdir}/puppet/indirector/resource/puppetdb.rb
%{rubylibdir}/puppet/util/puppetdb/command.rb
%{rubylibdir}/puppet/util/puppetdb/command_names.rb
%{rubylibdir}/puppet/util/puppetdb/config.rb
%{rubylibdir}/puppet/util/puppetdb/http.rb
%{rubylibdir}/puppet/util/puppetdb/char_encoding.rb
%{rubylibdir}/puppet/util/puppetdb/atom.rb
%{rubylibdir}/puppet/util/puppetdb.rb
%{rubylibdir}/puppet/reports/puppetdb.rb
%{rubylibdir}/puppet/face/node/deactivate.rb
%{rubylibdir}/puppet/face/node/status.rb
%{rubylibdir}/puppet/functions/puppetdb_query.rb


%changelog
* Thu Nov 03 2016 Puppet Labs Release <info@puppetlabs.com> -  4.3.0-1
- Build for 4.3.0
