/*
  File autogenerated by gengetopt version 2.18
  generated with the following command:
  gengetopt --unamed-opts=CLIENT [SERVER] --no-handle-help --no-handle-error --input shishi.ggo --file-name shishi_cmd 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "shishi_cmd.h"

const char *gengetopt_args_info_purpose = "Shishi command line client.  If no command is given, Shishi\nacquire or list a valid ticket for you, identified by CLIENT (if\nempty, default username in default realm), for the service SERVER (if\nempty, ticket granting ticket for client realm).";

const char *gengetopt_args_info_usage = "Usage: shishi [OPTIONS]... [CLIENT [SERVER]]...";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                    Print help and exit",
  "  -V, --version                 Print version and exit",
  "\nCommands:",
  "  -d, --destroy                 Destroy tickets in local cache, limited by any \n                                  --client-name or --server-name.  \n                                  (default=off)",
  "  -l, --list                    List tickets in local cache, limited by any \n                                  --client-name and --server-name.  \n                                  (default=off)",
  "  -r, --renew                   Renew ticket.  Use --server-name to specify \n                                  ticket, default is the most recent renewable \n                                  ticket granting ticket for the default realm. \n                                   (default=off)",
  "\nFlags:",
  "      --forwardable             Get a forwardable ticket, i.e., one that can be \n                                  used to get forwarded tickets.  (default=off)",
  "      --forwarded               Get a forwarded ticket.  (default=off)",
  "      --proxiable               Get a proxiable ticket, i.e., one that can be \n                                  used to get proxy tickets.  (default=off)",
  "      --proxy                   Get a proxy ticket.  (default=off)",
  "      --renewable               Get a renewable ticket.  (default=off)",
  "\nOptions:",
  "      --client-name=NAME        Client name. Default is login username.",
  "  -E, --encryption-type=ETYPE,[ETYPE...]\n                                Encryption types to use.  ETYPE is either \n                                  registered name or integer.  Valid values \n                                  include 'aes128', 'aes256', 'aes' (same as \n                                  'aes256'), '3des', 'des-md5', 'des-md4', \n                                  'des-crc', 'des' (same as 'des-md5'), and \n                                  'arcfour'.",
  "  -e, --endtime=STRING          Specify when ticket validity should expire.  \n                                  The time syntax may be relative (to the start \n                                  time), such as '20 hours', or absolute, such \n                                  as '2001-02-03 04:05:06 CET'. The default is \n                                  8 hours after the start time.",
  "      --realm=STRING            Set default realm.",
  "      --renew-till=STRING       Specify renewable life of ticket.  Implies \n                                  --renewable.  Accepts same time syntax as \n                                  --endtime.  If --renewable is specified, the \n                                  default is 1 week after the start time.",
  "      --server-name=NAME        Server name. Default is 'krbtgt/REALM' where \n                                  REALM is client realm.",
  "  -s, --starttime=STRING        Specify when ticket should start to be valid.  \n                                  Accepts same time syntax as --endtime. The \n                                  default is to become valid immediately.",
  "      --ticket-granter=NAME     Service name in ticket to use for \n                                  authenticating request. Only for TGS. \n                                  Defaults to 'krbtgt/REALM@REALM' where REALM \n                                  is client realm.",
  "\nOther options:",
  "      --configuration-file=FILE Read user configuration from FILE.",
  "  -c, --ticket-file=FILE        Read tickets from FILE.",
  "  -o, --library-options=STRING  Parse STRING as a configuration file statement.",
  "  -q, --quiet                   Don't produce any diagnostic output.\n                                    (default=off)",
  "      --system-configuration-file=FILE\n                                Read system configuration from FILE.",
  "      --ticket-write-file=FILE  Write tickets from FILE.  Default is to write \n                                  them back to where they were read from.",
  "  -v, --verbose                 Produce verbose output.\n                                  Use multiple times to increase amount of \n                                  information.",
    0
};

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error);

static int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->destroy_given = 0 ;
  args_info->list_given = 0 ;
  args_info->renew_given = 0 ;
  args_info->forwardable_given = 0 ;
  args_info->forwarded_given = 0 ;
  args_info->proxiable_given = 0 ;
  args_info->proxy_given = 0 ;
  args_info->renewable_given = 0 ;
  args_info->client_name_given = 0 ;
  args_info->encryption_type_given = 0 ;
  args_info->endtime_given = 0 ;
  args_info->realm_given = 0 ;
  args_info->renew_till_given = 0 ;
  args_info->server_name_given = 0 ;
  args_info->starttime_given = 0 ;
  args_info->ticket_granter_given = 0 ;
  args_info->configuration_file_given = 0 ;
  args_info->ticket_file_given = 0 ;
  args_info->library_options_given = 0 ;
  args_info->quiet_given = 0 ;
  args_info->system_configuration_file_given = 0 ;
  args_info->ticket_write_file_given = 0 ;
  args_info->verbose_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->destroy_flag = 0;
  args_info->list_flag = 0;
  args_info->renew_flag = 0;
  args_info->forwardable_flag = 0;
  args_info->forwarded_flag = 0;
  args_info->proxiable_flag = 0;
  args_info->proxy_flag = 0;
  args_info->renewable_flag = 0;
  args_info->client_name_arg = NULL;
  args_info->client_name_orig = NULL;
  args_info->encryption_type_arg = NULL;
  args_info->encryption_type_orig = NULL;
  args_info->endtime_arg = NULL;
  args_info->endtime_orig = NULL;
  args_info->realm_arg = NULL;
  args_info->realm_orig = NULL;
  args_info->renew_till_arg = NULL;
  args_info->renew_till_orig = NULL;
  args_info->server_name_arg = NULL;
  args_info->server_name_orig = NULL;
  args_info->starttime_arg = NULL;
  args_info->starttime_orig = NULL;
  args_info->ticket_granter_arg = NULL;
  args_info->ticket_granter_orig = NULL;
  args_info->configuration_file_arg = NULL;
  args_info->configuration_file_orig = NULL;
  args_info->ticket_file_arg = NULL;
  args_info->ticket_file_orig = NULL;
  args_info->library_options_arg = NULL;
  args_info->library_options_orig = NULL;
  args_info->quiet_flag = 0;
  args_info->system_configuration_file_arg = NULL;
  args_info->system_configuration_file_orig = NULL;
  args_info->ticket_write_file_arg = NULL;
  args_info->ticket_write_file_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{
  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->destroy_help = gengetopt_args_info_help[3] ;
  args_info->list_help = gengetopt_args_info_help[4] ;
  args_info->renew_help = gengetopt_args_info_help[5] ;
  args_info->forwardable_help = gengetopt_args_info_help[7] ;
  args_info->forwarded_help = gengetopt_args_info_help[8] ;
  args_info->proxiable_help = gengetopt_args_info_help[9] ;
  args_info->proxy_help = gengetopt_args_info_help[10] ;
  args_info->renewable_help = gengetopt_args_info_help[11] ;
  args_info->client_name_help = gengetopt_args_info_help[13] ;
  args_info->encryption_type_help = gengetopt_args_info_help[14] ;
  args_info->endtime_help = gengetopt_args_info_help[15] ;
  args_info->realm_help = gengetopt_args_info_help[16] ;
  args_info->renew_till_help = gengetopt_args_info_help[17] ;
  args_info->server_name_help = gengetopt_args_info_help[18] ;
  args_info->starttime_help = gengetopt_args_info_help[19] ;
  args_info->ticket_granter_help = gengetopt_args_info_help[20] ;
  args_info->configuration_file_help = gengetopt_args_info_help[22] ;
  args_info->ticket_file_help = gengetopt_args_info_help[23] ;
  args_info->library_options_help = gengetopt_args_info_help[24] ;
  args_info->quiet_help = gengetopt_args_info_help[25] ;
  args_info->system_configuration_file_help = gengetopt_args_info_help[26] ;
  args_info->ticket_write_file_help = gengetopt_args_info_help[27] ;
  args_info->verbose_help = gengetopt_args_info_help[28] ;
  args_info->verbose_min = -1;
  args_info->verbose_max = -1;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  printf("\n%s\n\n", gengetopt_args_info_usage);
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);

  args_info->inputs = NULL;
  args_info->inputs_num = 0;
}

static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{
  
  unsigned int i;
  if (args_info->client_name_arg)
    {
      free (args_info->client_name_arg); /* free previous argument */
      args_info->client_name_arg = 0;
    }
  if (args_info->client_name_orig)
    {
      free (args_info->client_name_orig); /* free previous argument */
      args_info->client_name_orig = 0;
    }
  if (args_info->encryption_type_arg)
    {
      free (args_info->encryption_type_arg); /* free previous argument */
      args_info->encryption_type_arg = 0;
    }
  if (args_info->encryption_type_orig)
    {
      free (args_info->encryption_type_orig); /* free previous argument */
      args_info->encryption_type_orig = 0;
    }
  if (args_info->endtime_arg)
    {
      free (args_info->endtime_arg); /* free previous argument */
      args_info->endtime_arg = 0;
    }
  if (args_info->endtime_orig)
    {
      free (args_info->endtime_orig); /* free previous argument */
      args_info->endtime_orig = 0;
    }
  if (args_info->realm_arg)
    {
      free (args_info->realm_arg); /* free previous argument */
      args_info->realm_arg = 0;
    }
  if (args_info->realm_orig)
    {
      free (args_info->realm_orig); /* free previous argument */
      args_info->realm_orig = 0;
    }
  if (args_info->renew_till_arg)
    {
      free (args_info->renew_till_arg); /* free previous argument */
      args_info->renew_till_arg = 0;
    }
  if (args_info->renew_till_orig)
    {
      free (args_info->renew_till_orig); /* free previous argument */
      args_info->renew_till_orig = 0;
    }
  if (args_info->server_name_arg)
    {
      free (args_info->server_name_arg); /* free previous argument */
      args_info->server_name_arg = 0;
    }
  if (args_info->server_name_orig)
    {
      free (args_info->server_name_orig); /* free previous argument */
      args_info->server_name_orig = 0;
    }
  if (args_info->starttime_arg)
    {
      free (args_info->starttime_arg); /* free previous argument */
      args_info->starttime_arg = 0;
    }
  if (args_info->starttime_orig)
    {
      free (args_info->starttime_orig); /* free previous argument */
      args_info->starttime_orig = 0;
    }
  if (args_info->ticket_granter_arg)
    {
      free (args_info->ticket_granter_arg); /* free previous argument */
      args_info->ticket_granter_arg = 0;
    }
  if (args_info->ticket_granter_orig)
    {
      free (args_info->ticket_granter_orig); /* free previous argument */
      args_info->ticket_granter_orig = 0;
    }
  if (args_info->configuration_file_arg)
    {
      free (args_info->configuration_file_arg); /* free previous argument */
      args_info->configuration_file_arg = 0;
    }
  if (args_info->configuration_file_orig)
    {
      free (args_info->configuration_file_orig); /* free previous argument */
      args_info->configuration_file_orig = 0;
    }
  if (args_info->ticket_file_arg)
    {
      free (args_info->ticket_file_arg); /* free previous argument */
      args_info->ticket_file_arg = 0;
    }
  if (args_info->ticket_file_orig)
    {
      free (args_info->ticket_file_orig); /* free previous argument */
      args_info->ticket_file_orig = 0;
    }
  if (args_info->library_options_arg)
    {
      free (args_info->library_options_arg); /* free previous argument */
      args_info->library_options_arg = 0;
    }
  if (args_info->library_options_orig)
    {
      free (args_info->library_options_orig); /* free previous argument */
      args_info->library_options_orig = 0;
    }
  if (args_info->system_configuration_file_arg)
    {
      free (args_info->system_configuration_file_arg); /* free previous argument */
      args_info->system_configuration_file_arg = 0;
    }
  if (args_info->system_configuration_file_orig)
    {
      free (args_info->system_configuration_file_orig); /* free previous argument */
      args_info->system_configuration_file_orig = 0;
    }
  if (args_info->ticket_write_file_arg)
    {
      free (args_info->ticket_write_file_arg); /* free previous argument */
      args_info->ticket_write_file_arg = 0;
    }
  if (args_info->ticket_write_file_orig)
    {
      free (args_info->ticket_write_file_orig); /* free previous argument */
      args_info->ticket_write_file_orig = 0;
    }
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);
  
  if (args_info->inputs_num)
    free (args_info->inputs);
  
  clear_given (args_info);
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  if (args_info->help_given) {
    fprintf(outfile, "%s\n", "help");
  }
  if (args_info->version_given) {
    fprintf(outfile, "%s\n", "version");
  }
  if (args_info->destroy_given) {
    fprintf(outfile, "%s\n", "destroy");
  }
  if (args_info->list_given) {
    fprintf(outfile, "%s\n", "list");
  }
  if (args_info->renew_given) {
    fprintf(outfile, "%s\n", "renew");
  }
  if (args_info->forwardable_given) {
    fprintf(outfile, "%s\n", "forwardable");
  }
  if (args_info->forwarded_given) {
    fprintf(outfile, "%s\n", "forwarded");
  }
  if (args_info->proxiable_given) {
    fprintf(outfile, "%s\n", "proxiable");
  }
  if (args_info->proxy_given) {
    fprintf(outfile, "%s\n", "proxy");
  }
  if (args_info->renewable_given) {
    fprintf(outfile, "%s\n", "renewable");
  }
  if (args_info->client_name_given) {
    if (args_info->client_name_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "client-name", args_info->client_name_orig);
    } else {
      fprintf(outfile, "%s\n", "client-name");
    }
  }
  if (args_info->encryption_type_given) {
    if (args_info->encryption_type_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "encryption-type", args_info->encryption_type_orig);
    } else {
      fprintf(outfile, "%s\n", "encryption-type");
    }
  }
  if (args_info->endtime_given) {
    if (args_info->endtime_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "endtime", args_info->endtime_orig);
    } else {
      fprintf(outfile, "%s\n", "endtime");
    }
  }
  if (args_info->realm_given) {
    if (args_info->realm_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "realm", args_info->realm_orig);
    } else {
      fprintf(outfile, "%s\n", "realm");
    }
  }
  if (args_info->renew_till_given) {
    if (args_info->renew_till_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "renew-till", args_info->renew_till_orig);
    } else {
      fprintf(outfile, "%s\n", "renew-till");
    }
  }
  if (args_info->server_name_given) {
    if (args_info->server_name_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "server-name", args_info->server_name_orig);
    } else {
      fprintf(outfile, "%s\n", "server-name");
    }
  }
  if (args_info->starttime_given) {
    if (args_info->starttime_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "starttime", args_info->starttime_orig);
    } else {
      fprintf(outfile, "%s\n", "starttime");
    }
  }
  if (args_info->ticket_granter_given) {
    if (args_info->ticket_granter_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "ticket-granter", args_info->ticket_granter_orig);
    } else {
      fprintf(outfile, "%s\n", "ticket-granter");
    }
  }
  if (args_info->configuration_file_given) {
    if (args_info->configuration_file_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "configuration-file", args_info->configuration_file_orig);
    } else {
      fprintf(outfile, "%s\n", "configuration-file");
    }
  }
  if (args_info->ticket_file_given) {
    if (args_info->ticket_file_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "ticket-file", args_info->ticket_file_orig);
    } else {
      fprintf(outfile, "%s\n", "ticket-file");
    }
  }
  if (args_info->library_options_given) {
    if (args_info->library_options_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "library-options", args_info->library_options_orig);
    } else {
      fprintf(outfile, "%s\n", "library-options");
    }
  }
  if (args_info->quiet_given) {
    fprintf(outfile, "%s\n", "quiet");
  }
  if (args_info->system_configuration_file_given) {
    if (args_info->system_configuration_file_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "system-configuration-file", args_info->system_configuration_file_orig);
    } else {
      fprintf(outfile, "%s\n", "system-configuration-file");
    }
  }
  if (args_info->ticket_write_file_given) {
    if (args_info->ticket_write_file_orig) {
      fprintf(outfile, "%s=\"%s\"\n", "ticket-write-file", args_info->ticket_write_file_orig);
    } else {
      fprintf(outfile, "%s\n", "ticket-write-file");
    }
  }
  for (i = 0; i < args_info->verbose_given; ++i)
    {
      fprintf(outfile, "%s\n", "verbose");
      
    }
  
  fclose (outfile);

  i = EXIT_SUCCESS;
  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}


/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, int min, int max, const char *option_desc);

int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, int min, int max, const char *option_desc)
{
  int error = 0;

  if (option_given && ! (min < 0 && max < 0))
    {
      if (min >= 0 && max >= 0)
        {
          if (min == max)
            {
              /* specific occurrences */
              if (option_given != min)
                {
                  fprintf (stderr, "%s: %s option occurrences must be %d\n",
                    prog_name, option_desc, min);
                  error = 1;
                }
            }
          else if (option_given < min
              || option_given > max)
            {
              /* range occurrences */
              fprintf (stderr, "%s: %s option occurrences must be between %d and %d\n",
                prog_name, option_desc, min, max);
              error = 1;
            }
        }
      else if (min >= 0)
        {
          /* at least check */
          if (option_given < min)
            {
              fprintf (stderr, "%s: %s option occurrences must be at least %d\n",
                prog_name, option_desc, min);
              error = 1;
            }
        }
      else if (max >= 0)
        {
          /* at most check */
          if (option_given > max)
            {
              fprintf (stderr, "%s: %s option occurrences must be at most %d\n",
                prog_name, option_desc, max);
              error = 1;
            }
        }
    }
    
  return error;
}
int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;

  result = cmdline_parser_internal (argc, argv, args_info, override, initialize, check_required, NULL);

  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (cmdline_parser_required2(args_info, prog_name, NULL) > 0)
    result = EXIT_FAILURE;

  return result;
}

int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error = 0;

  /* checks for required options */
  if (check_multiple_option_occurrences(prog_name, args_info->verbose_given, args_info->verbose_min, args_info->verbose_max, "'--verbose' ('-v')"))
     error = 1;
  
  
  /* checks for dependences among options */

  return error;
}

int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "destroy",	0, NULL, 'd' },
        { "list",	0, NULL, 'l' },
        { "renew",	0, NULL, 'r' },
        { "forwardable",	0, NULL, 0 },
        { "forwarded",	0, NULL, 0 },
        { "proxiable",	0, NULL, 0 },
        { "proxy",	0, NULL, 0 },
        { "renewable",	0, NULL, 0 },
        { "client-name",	1, NULL, 0 },
        { "encryption-type",	1, NULL, 'E' },
        { "endtime",	1, NULL, 'e' },
        { "realm",	1, NULL, 0 },
        { "renew-till",	1, NULL, 0 },
        { "server-name",	1, NULL, 0 },
        { "starttime",	1, NULL, 's' },
        { "ticket-granter",	1, NULL, 0 },
        { "configuration-file",	1, NULL, 0 },
        { "ticket-file",	1, NULL, 'c' },
        { "library-options",	1, NULL, 'o' },
        { "quiet",	0, NULL, 'q' },
        { "system-configuration-file",	1, NULL, 0 },
        { "ticket-write-file",	1, NULL, 0 },
        { "verbose",	0, NULL, 'v' },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVdlrE:e:s:c:o:qv", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          if (local_args_info.help_given)
            {
              fprintf (stderr, "%s: `--help' (`-h') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->help_given && ! override)
            continue;
          local_args_info.help_given = 1;
          args_info->help_given = 1;
          cmdline_parser_free (&local_args_info);
          return 0;

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'd':	/* Destroy tickets in local cache, limited by any --client-name or --server-name..  */
          if (local_args_info.destroy_given)
            {
              fprintf (stderr, "%s: `--destroy' (`-d') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->destroy_given && ! override)
            continue;
          local_args_info.destroy_given = 1;
          args_info->destroy_given = 1;
          args_info->destroy_flag = !(args_info->destroy_flag);
          break;

        case 'l':	/* List tickets in local cache, limited by any --client-name and --server-name..  */
          if (local_args_info.list_given)
            {
              fprintf (stderr, "%s: `--list' (`-l') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->list_given && ! override)
            continue;
          local_args_info.list_given = 1;
          args_info->list_given = 1;
          args_info->list_flag = !(args_info->list_flag);
          break;

        case 'r':	/* Renew ticket.  Use --server-name to specify ticket, default is the most recent renewable ticket granting ticket for the default realm..  */
          if (local_args_info.renew_given)
            {
              fprintf (stderr, "%s: `--renew' (`-r') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->renew_given && ! override)
            continue;
          local_args_info.renew_given = 1;
          args_info->renew_given = 1;
          args_info->renew_flag = !(args_info->renew_flag);
          break;

        case 'E':	/* Encryption types to use.  ETYPE is either registered name or integer.  Valid values include 'aes128', 'aes256', 'aes' (same as 'aes256'), '3des', 'des-md5', 'des-md4', 'des-crc', 'des' (same as 'des-md5'), and 'arcfour'..  */
          if (local_args_info.encryption_type_given)
            {
              fprintf (stderr, "%s: `--encryption-type' (`-E') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->encryption_type_given && ! override)
            continue;
          local_args_info.encryption_type_given = 1;
          args_info->encryption_type_given = 1;
          if (args_info->encryption_type_arg)
            free (args_info->encryption_type_arg); /* free previous string */
          args_info->encryption_type_arg = gengetopt_strdup (optarg);
          if (args_info->encryption_type_orig)
            free (args_info->encryption_type_orig); /* free previous string */
          args_info->encryption_type_orig = gengetopt_strdup (optarg);
          break;

        case 'e':	/* Specify when ticket validity should expire.  The time syntax may be relative (to the start time), such as '20 hours', or absolute, such as '2001-02-03 04:05:06 CET'. The default is 8 hours after the start time..  */
          if (local_args_info.endtime_given)
            {
              fprintf (stderr, "%s: `--endtime' (`-e') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->endtime_given && ! override)
            continue;
          local_args_info.endtime_given = 1;
          args_info->endtime_given = 1;
          if (args_info->endtime_arg)
            free (args_info->endtime_arg); /* free previous string */
          args_info->endtime_arg = gengetopt_strdup (optarg);
          if (args_info->endtime_orig)
            free (args_info->endtime_orig); /* free previous string */
          args_info->endtime_orig = gengetopt_strdup (optarg);
          break;

        case 's':	/* Specify when ticket should start to be valid.  Accepts same time syntax as --endtime. The default is to become valid immediately..  */
          if (local_args_info.starttime_given)
            {
              fprintf (stderr, "%s: `--starttime' (`-s') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->starttime_given && ! override)
            continue;
          local_args_info.starttime_given = 1;
          args_info->starttime_given = 1;
          if (args_info->starttime_arg)
            free (args_info->starttime_arg); /* free previous string */
          args_info->starttime_arg = gengetopt_strdup (optarg);
          if (args_info->starttime_orig)
            free (args_info->starttime_orig); /* free previous string */
          args_info->starttime_orig = gengetopt_strdup (optarg);
          break;

        case 'c':	/* Read tickets from FILE..  */
          if (local_args_info.ticket_file_given)
            {
              fprintf (stderr, "%s: `--ticket-file' (`-c') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->ticket_file_given && ! override)
            continue;
          local_args_info.ticket_file_given = 1;
          args_info->ticket_file_given = 1;
          if (args_info->ticket_file_arg)
            free (args_info->ticket_file_arg); /* free previous string */
          args_info->ticket_file_arg = gengetopt_strdup (optarg);
          if (args_info->ticket_file_orig)
            free (args_info->ticket_file_orig); /* free previous string */
          args_info->ticket_file_orig = gengetopt_strdup (optarg);
          break;

        case 'o':	/* Parse STRING as a configuration file statement..  */
          if (local_args_info.library_options_given)
            {
              fprintf (stderr, "%s: `--library-options' (`-o') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->library_options_given && ! override)
            continue;
          local_args_info.library_options_given = 1;
          args_info->library_options_given = 1;
          if (args_info->library_options_arg)
            free (args_info->library_options_arg); /* free previous string */
          args_info->library_options_arg = gengetopt_strdup (optarg);
          if (args_info->library_options_orig)
            free (args_info->library_options_orig); /* free previous string */
          args_info->library_options_orig = gengetopt_strdup (optarg);
          break;

        case 'q':	/* Don't produce any diagnostic output.\n.  */
          if (local_args_info.quiet_given)
            {
              fprintf (stderr, "%s: `--quiet' (`-q') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->quiet_given && ! override)
            continue;
          local_args_info.quiet_given = 1;
          args_info->quiet_given = 1;
          args_info->quiet_flag = !(args_info->quiet_flag);
          break;

        case 'v':	/* Produce verbose output.\nUse multiple times to increase amount of information..  */
          local_args_info.verbose_given++;
        
          break;


        case 0:	/* Long option with no short option */
          /* Get a forwardable ticket, i.e., one that can be used to get forwarded tickets..  */
          if (strcmp (long_options[option_index].name, "forwardable") == 0)
          {
            if (local_args_info.forwardable_given)
              {
                fprintf (stderr, "%s: `--forwardable' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->forwardable_given && ! override)
              continue;
            local_args_info.forwardable_given = 1;
            args_info->forwardable_given = 1;
            args_info->forwardable_flag = !(args_info->forwardable_flag);
          }
          /* Get a forwarded ticket..  */
          else if (strcmp (long_options[option_index].name, "forwarded") == 0)
          {
            if (local_args_info.forwarded_given)
              {
                fprintf (stderr, "%s: `--forwarded' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->forwarded_given && ! override)
              continue;
            local_args_info.forwarded_given = 1;
            args_info->forwarded_given = 1;
            args_info->forwarded_flag = !(args_info->forwarded_flag);
          }
          /* Get a proxiable ticket, i.e., one that can be used to get proxy tickets..  */
          else if (strcmp (long_options[option_index].name, "proxiable") == 0)
          {
            if (local_args_info.proxiable_given)
              {
                fprintf (stderr, "%s: `--proxiable' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->proxiable_given && ! override)
              continue;
            local_args_info.proxiable_given = 1;
            args_info->proxiable_given = 1;
            args_info->proxiable_flag = !(args_info->proxiable_flag);
          }
          /* Get a proxy ticket..  */
          else if (strcmp (long_options[option_index].name, "proxy") == 0)
          {
            if (local_args_info.proxy_given)
              {
                fprintf (stderr, "%s: `--proxy' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->proxy_given && ! override)
              continue;
            local_args_info.proxy_given = 1;
            args_info->proxy_given = 1;
            args_info->proxy_flag = !(args_info->proxy_flag);
          }
          /* Get a renewable ticket..  */
          else if (strcmp (long_options[option_index].name, "renewable") == 0)
          {
            if (local_args_info.renewable_given)
              {
                fprintf (stderr, "%s: `--renewable' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->renewable_given && ! override)
              continue;
            local_args_info.renewable_given = 1;
            args_info->renewable_given = 1;
            args_info->renewable_flag = !(args_info->renewable_flag);
          }
          /* Client name. Default is login username..  */
          else if (strcmp (long_options[option_index].name, "client-name") == 0)
          {
            if (local_args_info.client_name_given)
              {
                fprintf (stderr, "%s: `--client-name' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->client_name_given && ! override)
              continue;
            local_args_info.client_name_given = 1;
            args_info->client_name_given = 1;
            if (args_info->client_name_arg)
              free (args_info->client_name_arg); /* free previous string */
            args_info->client_name_arg = gengetopt_strdup (optarg);
            if (args_info->client_name_orig)
              free (args_info->client_name_orig); /* free previous string */
            args_info->client_name_orig = gengetopt_strdup (optarg);
          }
          /* Set default realm..  */
          else if (strcmp (long_options[option_index].name, "realm") == 0)
          {
            if (local_args_info.realm_given)
              {
                fprintf (stderr, "%s: `--realm' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->realm_given && ! override)
              continue;
            local_args_info.realm_given = 1;
            args_info->realm_given = 1;
            if (args_info->realm_arg)
              free (args_info->realm_arg); /* free previous string */
            args_info->realm_arg = gengetopt_strdup (optarg);
            if (args_info->realm_orig)
              free (args_info->realm_orig); /* free previous string */
            args_info->realm_orig = gengetopt_strdup (optarg);
          }
          /* Specify renewable life of ticket.  Implies --renewable.  Accepts same time syntax as --endtime.  If --renewable is specified, the default is 1 week after the start time..  */
          else if (strcmp (long_options[option_index].name, "renew-till") == 0)
          {
            if (local_args_info.renew_till_given)
              {
                fprintf (stderr, "%s: `--renew-till' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->renew_till_given && ! override)
              continue;
            local_args_info.renew_till_given = 1;
            args_info->renew_till_given = 1;
            if (args_info->renew_till_arg)
              free (args_info->renew_till_arg); /* free previous string */
            args_info->renew_till_arg = gengetopt_strdup (optarg);
            if (args_info->renew_till_orig)
              free (args_info->renew_till_orig); /* free previous string */
            args_info->renew_till_orig = gengetopt_strdup (optarg);
          }
          /* Server name. Default is 'krbtgt/REALM' where REALM is client realm..  */
          else if (strcmp (long_options[option_index].name, "server-name") == 0)
          {
            if (local_args_info.server_name_given)
              {
                fprintf (stderr, "%s: `--server-name' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->server_name_given && ! override)
              continue;
            local_args_info.server_name_given = 1;
            args_info->server_name_given = 1;
            if (args_info->server_name_arg)
              free (args_info->server_name_arg); /* free previous string */
            args_info->server_name_arg = gengetopt_strdup (optarg);
            if (args_info->server_name_orig)
              free (args_info->server_name_orig); /* free previous string */
            args_info->server_name_orig = gengetopt_strdup (optarg);
          }
          /* Service name in ticket to use for authenticating request. Only for TGS. Defaults to 'krbtgt/REALM@REALM' where REALM is client realm..  */
          else if (strcmp (long_options[option_index].name, "ticket-granter") == 0)
          {
            if (local_args_info.ticket_granter_given)
              {
                fprintf (stderr, "%s: `--ticket-granter' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->ticket_granter_given && ! override)
              continue;
            local_args_info.ticket_granter_given = 1;
            args_info->ticket_granter_given = 1;
            if (args_info->ticket_granter_arg)
              free (args_info->ticket_granter_arg); /* free previous string */
            args_info->ticket_granter_arg = gengetopt_strdup (optarg);
            if (args_info->ticket_granter_orig)
              free (args_info->ticket_granter_orig); /* free previous string */
            args_info->ticket_granter_orig = gengetopt_strdup (optarg);
          }
          /* Read user configuration from FILE..  */
          else if (strcmp (long_options[option_index].name, "configuration-file") == 0)
          {
            if (local_args_info.configuration_file_given)
              {
                fprintf (stderr, "%s: `--configuration-file' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->configuration_file_given && ! override)
              continue;
            local_args_info.configuration_file_given = 1;
            args_info->configuration_file_given = 1;
            if (args_info->configuration_file_arg)
              free (args_info->configuration_file_arg); /* free previous string */
            args_info->configuration_file_arg = gengetopt_strdup (optarg);
            if (args_info->configuration_file_orig)
              free (args_info->configuration_file_orig); /* free previous string */
            args_info->configuration_file_orig = gengetopt_strdup (optarg);
          }
          /* Read system configuration from FILE..  */
          else if (strcmp (long_options[option_index].name, "system-configuration-file") == 0)
          {
            if (local_args_info.system_configuration_file_given)
              {
                fprintf (stderr, "%s: `--system-configuration-file' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->system_configuration_file_given && ! override)
              continue;
            local_args_info.system_configuration_file_given = 1;
            args_info->system_configuration_file_given = 1;
            if (args_info->system_configuration_file_arg)
              free (args_info->system_configuration_file_arg); /* free previous string */
            args_info->system_configuration_file_arg = gengetopt_strdup (optarg);
            if (args_info->system_configuration_file_orig)
              free (args_info->system_configuration_file_orig); /* free previous string */
            args_info->system_configuration_file_orig = gengetopt_strdup (optarg);
          }
          /* Write tickets from FILE.  Default is to write them back to where they were read from..  */
          else if (strcmp (long_options[option_index].name, "ticket-write-file") == 0)
          {
            if (local_args_info.ticket_write_file_given)
              {
                fprintf (stderr, "%s: `--ticket-write-file' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->ticket_write_file_given && ! override)
              continue;
            local_args_info.ticket_write_file_given = 1;
            args_info->ticket_write_file_given = 1;
            if (args_info->ticket_write_file_arg)
              free (args_info->ticket_write_file_arg); /* free previous string */
            args_info->ticket_write_file_arg = gengetopt_strdup (optarg);
            if (args_info->ticket_write_file_orig)
              free (args_info->ticket_write_file_orig); /* free previous string */
            args_info->ticket_write_file_orig = gengetopt_strdup (optarg);
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  args_info->verbose_given += local_args_info.verbose_given;
  local_args_info.verbose_given = 0;
  
  if (check_required)
    {
      error += cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
      int found_prog_name = 0;
      /* whether program name, i.e., argv[0], is in the remaining args
         (this may happen with some implementations of getopt,
          but surely not with the one included by gengetopt) */

      i = optind;
      while (i < argc)
        if (argv[i++] == argv[0]) {
          found_prog_name = 1;
          break;
        }
      i = 0;

      args_info->inputs_num = argc - optind - found_prog_name;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        if (argv[optind++] != argv[0])
          args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind-1]) ;
    }

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
