/*
  File autogenerated by gengetopt version 2.12rc
  generated with the following command:
  gengetopt --no-handle-help --no-handle-error --input shishid.ggo --file-name shishid_cmd 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "shishid_cmd.h"

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Purpose:\n"
  "  Network daemon for issuing Kerberos 5 tickets.\n"
  "\n"
  "Usage: %s [OPTIONS]...\n", CMDLINE_PARSER_PACKAGE);
  printf("\n");
  printf("  -h, --help                            Print help and exit\n");
  printf("  -V, --version                         Print version and exit\n");
  printf("\nCommands:\n");
  printf("  -l, --listen=[FAMILY:]ADDR:PORT/TYPE  Sockets to listen for queries on.  \n                                          Family is `IPv4' or `IPv6', if \n                                          absent the family is decided by \n                                          gethostbyname(ADDR). An address of \n                                          `*' indicates all addresses on the \n                                          local host. The default is \n                                          `IPv4:*:kerberos/udp, \n                                          IPv4:*:kerberos/tcp, \n                                          IPv6:*:kerberos/udp, \n                                          IPv6:*:kerberos/tcp'.\n");
  printf("  -u, --setuid=NAME                     After binding socket, set user \n                                          identity.\n");
  printf("\nTLS settings:\n");
  printf("      --x509cafile=FILE                 X.509 certificate authorities used to \n                                          verify client certificates, in PEM \n                                          format.\n");
  printf("      --x509certfile=FILE               X.509 server certificate, in PEM \n                                          format.\n");
  printf("      --x509crlfile=FILE                X.509 certificate revocation list to \n                                          check for revoked client \n                                          certificates, in PEM format.\n");
  printf("      --x509keyfile=FILE                X.509 server certificate key, in PEM \n                                          format.\n");
  printf("      --resume-limit=SHORT              Keep track of up to this many TLS \n                                          sessions for resume purposes (0 to \n                                          disable TLS resume).  (default=`50')\n");
  printf("\nOther options:\n");
  printf("  -c, --configuration-file=FILE         Use specified configuration file.\n");
  printf("  -v, --verbose                         Produce verbose output.\n                                            (default=off)\n");
  printf("  -q, --quiet                           Don't produce any diagnostic output.\n                                            (default=off)\n");
}


static char *gengetopt_strdup (const char *s);

/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->listen_given = 0 ;
  args_info->setuid_given = 0 ;
  args_info->x509cafile_given = 0 ;
  args_info->x509certfile_given = 0 ;
  args_info->x509crlfile_given = 0 ;
  args_info->x509keyfile_given = 0 ;
  args_info->resume_limit_given = 0 ;
  args_info->configuration_file_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->quiet_given = 0 ;
#define clear_args() { \
  args_info->listen_arg = NULL; \
  args_info->setuid_arg = NULL; \
  args_info->x509cafile_arg = NULL; \
  args_info->x509certfile_arg = NULL; \
  args_info->x509crlfile_arg = NULL; \
  args_info->x509keyfile_arg = NULL; \
  args_info->resume_limit_arg = 50 ;\
  args_info->configuration_file_arg = NULL; \
  args_info->verbose_flag = 0;\
  args_info->quiet_flag = 0;\
}

  clear_args();

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "listen",	1, NULL, 'l' },
        { "setuid",	1, NULL, 'u' },
        { "x509cafile",	1, NULL, 0 },
        { "x509certfile",	1, NULL, 0 },
        { "x509crlfile",	1, NULL, 0 },
        { "x509keyfile",	1, NULL, 0 },
        { "resume-limit",	1, NULL, 0 },
        { "configuration-file",	1, NULL, 'c' },
        { "verbose",	0, NULL, 'v' },
        { "quiet",	0, NULL, 'q' },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVl:u:c:vq", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          if (args_info->help_given)
            {
              fprintf (stderr, "%s: `--help' (`-h') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->help_given = 1;
          return 0;

        case 'V':	/* Print version and exit.  */
          clear_args ();
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 'l':	/* Sockets to listen for queries on.  Family is `IPv4' or `IPv6', if absent the family is decided by gethostbyname(ADDR). An address of `*' indicates all addresses on the local host. The default is `IPv4:*:kerberos/udp, IPv4:*:kerberos/tcp, IPv6:*:kerberos/udp, IPv6:*:kerberos/tcp'..  */
          if (args_info->listen_given)
            {
              fprintf (stderr, "%s: `--listen' (`-l') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->listen_given = 1;
          args_info->listen_arg = gengetopt_strdup (optarg);
          break;

        case 'u':	/* After binding socket, set user identity..  */
          if (args_info->setuid_given)
            {
              fprintf (stderr, "%s: `--setuid' (`-u') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->setuid_given = 1;
          args_info->setuid_arg = gengetopt_strdup (optarg);
          break;

        case 'c':	/* Use specified configuration file..  */
          if (args_info->configuration_file_given)
            {
              fprintf (stderr, "%s: `--configuration-file' (`-c') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->configuration_file_given = 1;
          args_info->configuration_file_arg = gengetopt_strdup (optarg);
          break;

        case 'v':	/* Produce verbose output.\n.  */
          if (args_info->verbose_given)
            {
              fprintf (stderr, "%s: `--verbose' (`-v') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->verbose_given = 1;
          args_info->verbose_flag = !(args_info->verbose_flag);
          break;

        case 'q':	/* Don't produce any diagnostic output.\n.  */
          if (args_info->quiet_given)
            {
              fprintf (stderr, "%s: `--quiet' (`-q') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->quiet_given = 1;
          args_info->quiet_flag = !(args_info->quiet_flag);
          break;


        case 0:	/* Long option with no short option */
          /* X.509 certificate authorities used to verify client certificates, in PEM format..  */
          if (strcmp (long_options[option_index].name, "x509cafile") == 0)
          {
            if (args_info->x509cafile_given)
              {
                fprintf (stderr, "%s: `--x509cafile' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                return (EXIT_FAILURE);
              }
            args_info->x509cafile_given = 1;
            args_info->x509cafile_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* X.509 server certificate, in PEM format..  */
          else if (strcmp (long_options[option_index].name, "x509certfile") == 0)
          {
            if (args_info->x509certfile_given)
              {
                fprintf (stderr, "%s: `--x509certfile' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                return (EXIT_FAILURE);
              }
            args_info->x509certfile_given = 1;
            args_info->x509certfile_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* X.509 certificate revocation list to check for revoked client certificates, in PEM format..  */
          else if (strcmp (long_options[option_index].name, "x509crlfile") == 0)
          {
            if (args_info->x509crlfile_given)
              {
                fprintf (stderr, "%s: `--x509crlfile' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                return (EXIT_FAILURE);
              }
            args_info->x509crlfile_given = 1;
            args_info->x509crlfile_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* X.509 server certificate key, in PEM format..  */
          else if (strcmp (long_options[option_index].name, "x509keyfile") == 0)
          {
            if (args_info->x509keyfile_given)
              {
                fprintf (stderr, "%s: `--x509keyfile' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                return (EXIT_FAILURE);
              }
            args_info->x509keyfile_given = 1;
            args_info->x509keyfile_arg = gengetopt_strdup (optarg);
            break;
          }
          
          /* Keep track of up to this many TLS sessions for resume purposes (0 to disable TLS resume)..  */
          else if (strcmp (long_options[option_index].name, "resume-limit") == 0)
          {
            if (args_info->resume_limit_given)
              {
                fprintf (stderr, "%s: `--resume-limit' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                return (EXIT_FAILURE);
              }
            args_info->resume_limit_given = 1;
            args_info->resume_limit_arg = (short)strtol (optarg,&stop_char,0);
            break;
          }
          

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          return (EXIT_FAILURE);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", CMDLINE_PARSER_PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */


  if ( missing_required_options )
    return (EXIT_FAILURE);

  return 0;
}
